package software.amazon.awscdk.services.networkmanager;

/**
 * Properties for defining a `CfnSiteToSiteVpnAttachment`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkmanager.*;
 * CfnSiteToSiteVpnAttachmentProps cfnSiteToSiteVpnAttachmentProps = CfnSiteToSiteVpnAttachmentProps.builder()
 *         .coreNetworkId("coreNetworkId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpnConnectionArn("vpnConnectionArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:13.731Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CfnSiteToSiteVpnAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnSiteToSiteVpnAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSiteToSiteVpnAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The core network ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCoreNetworkId() {
        return null;
    }

    /**
     * The tags associated with the site-to-site VPN attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The ARN of the site-to-site VPN attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpnConnectionArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSiteToSiteVpnAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSiteToSiteVpnAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSiteToSiteVpnAttachmentProps> {
        java.lang.String coreNetworkId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String vpnConnectionArn;

        /**
         * Sets the value of {@link CfnSiteToSiteVpnAttachmentProps#getCoreNetworkId}
         * @param coreNetworkId The core network ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreNetworkId(java.lang.String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSiteToSiteVpnAttachmentProps#getTags}
         * @param tags The tags associated with the site-to-site VPN attachment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnSiteToSiteVpnAttachmentProps#getVpnConnectionArn}
         * @param vpnConnectionArn The ARN of the site-to-site VPN attachment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnConnectionArn(java.lang.String vpnConnectionArn) {
            this.vpnConnectionArn = vpnConnectionArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSiteToSiteVpnAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSiteToSiteVpnAttachmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSiteToSiteVpnAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSiteToSiteVpnAttachmentProps {
        private final java.lang.String coreNetworkId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String vpnConnectionArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.coreNetworkId = software.amazon.jsii.Kernel.get(this, "coreNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.vpnConnectionArn = software.amazon.jsii.Kernel.get(this, "vpnConnectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.coreNetworkId = builder.coreNetworkId;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.vpnConnectionArn = builder.vpnConnectionArn;
        }

        @Override
        public final java.lang.String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getVpnConnectionArn() {
            return this.vpnConnectionArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCoreNetworkId() != null) {
                data.set("coreNetworkId", om.valueToTree(this.getCoreNetworkId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpnConnectionArn() != null) {
                data.set("vpnConnectionArn", om.valueToTree(this.getVpnConnectionArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkmanager.CfnSiteToSiteVpnAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSiteToSiteVpnAttachmentProps.Jsii$Proxy that = (CfnSiteToSiteVpnAttachmentProps.Jsii$Proxy) o;

            if (this.coreNetworkId != null ? !this.coreNetworkId.equals(that.coreNetworkId) : that.coreNetworkId != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpnConnectionArn != null ? this.vpnConnectionArn.equals(that.vpnConnectionArn) : that.vpnConnectionArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.coreNetworkId != null ? this.coreNetworkId.hashCode() : 0;
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpnConnectionArn != null ? this.vpnConnectionArn.hashCode() : 0);
            return result;
        }
    }
}
