package software.amazon.awscdk.services.medialive;

/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 * <p>
 * The AWS::MediaLive::Channel resource is a MediaLive resource type that creates a channel.
 * <p>
 * A MediaLive channel ingests and transcodes (decodes and encodes) source content from the inputs that are attached to that channel, and packages the new content into outputs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.medialive.*;
 * Object tags;
 * CfnChannel cfnChannel = CfnChannel.Builder.create(this, "MyCfnChannel")
 *         .cdiInputSpecification(CdiInputSpecificationProperty.builder()
 *                 .resolution("resolution")
 *                 .build())
 *         .channelClass("channelClass")
 *         .destinations(List.of(OutputDestinationProperty.builder()
 *                 .id("id")
 *                 .mediaPackageSettings(List.of(MediaPackageOutputDestinationSettingsProperty.builder()
 *                         .channelId("channelId")
 *                         .build()))
 *                 .multiplexSettings(MultiplexProgramChannelDestinationSettingsProperty.builder()
 *                         .multiplexId("multiplexId")
 *                         .programName("programName")
 *                         .build())
 *                 .settings(List.of(OutputDestinationSettingsProperty.builder()
 *                         .passwordParam("passwordParam")
 *                         .streamName("streamName")
 *                         .url("url")
 *                         .username("username")
 *                         .build()))
 *                 .build()))
 *         .encoderSettings(EncoderSettingsProperty.builder()
 *                 .audioDescriptions(List.of(AudioDescriptionProperty.builder()
 *                         .audioNormalizationSettings(AudioNormalizationSettingsProperty.builder()
 *                                 .algorithm("algorithm")
 *                                 .algorithmControl("algorithmControl")
 *                                 .targetLkfs(123)
 *                                 .build())
 *                         .audioSelectorName("audioSelectorName")
 *                         .audioType("audioType")
 *                         .audioTypeControl("audioTypeControl")
 *                         .audioWatermarkingSettings(AudioWatermarkSettingsProperty.builder()
 *                                 .nielsenWatermarksSettings(NielsenWatermarksSettingsProperty.builder()
 *                                         .nielsenCbetSettings(NielsenCBETProperty.builder()
 *                                                 .cbetCheckDigitString("cbetCheckDigitString")
 *                                                 .cbetStepaside("cbetStepaside")
 *                                                 .csid("csid")
 *                                                 .build())
 *                                         .nielsenDistributionType("nielsenDistributionType")
 *                                         .nielsenNaesIiNwSettings(NielsenNaesIiNwProperty.builder()
 *                                                 .checkDigitString("checkDigitString")
 *                                                 .sid(123)
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .codecSettings(AudioCodecSettingsProperty.builder()
 *                                 .aacSettings(AacSettingsProperty.builder()
 *                                         .bitrate(123)
 *                                         .codingMode("codingMode")
 *                                         .inputType("inputType")
 *                                         .profile("profile")
 *                                         .rateControlMode("rateControlMode")
 *                                         .rawFormat("rawFormat")
 *                                         .sampleRate(123)
 *                                         .spec("spec")
 *                                         .vbrQuality("vbrQuality")
 *                                         .build())
 *                                 .ac3Settings(Ac3SettingsProperty.builder()
 *                                         .bitrate(123)
 *                                         .bitstreamMode("bitstreamMode")
 *                                         .codingMode("codingMode")
 *                                         .dialnorm(123)
 *                                         .drcProfile("drcProfile")
 *                                         .lfeFilter("lfeFilter")
 *                                         .metadataControl("metadataControl")
 *                                         .build())
 *                                 .eac3Settings(Eac3SettingsProperty.builder()
 *                                         .attenuationControl("attenuationControl")
 *                                         .bitrate(123)
 *                                         .bitstreamMode("bitstreamMode")
 *                                         .codingMode("codingMode")
 *                                         .dcFilter("dcFilter")
 *                                         .dialnorm(123)
 *                                         .drcLine("drcLine")
 *                                         .drcRf("drcRf")
 *                                         .lfeControl("lfeControl")
 *                                         .lfeFilter("lfeFilter")
 *                                         .loRoCenterMixLevel(123)
 *                                         .loRoSurroundMixLevel(123)
 *                                         .ltRtCenterMixLevel(123)
 *                                         .ltRtSurroundMixLevel(123)
 *                                         .metadataControl("metadataControl")
 *                                         .passthroughControl("passthroughControl")
 *                                         .phaseControl("phaseControl")
 *                                         .stereoDownmix("stereoDownmix")
 *                                         .surroundExMode("surroundExMode")
 *                                         .surroundMode("surroundMode")
 *                                         .build())
 *                                 .mp2Settings(Mp2SettingsProperty.builder()
 *                                         .bitrate(123)
 *                                         .codingMode("codingMode")
 *                                         .sampleRate(123)
 *                                         .build())
 *                                 .passThroughSettings(PassThroughSettingsProperty.builder().build())
 *                                 .wavSettings(WavSettingsProperty.builder()
 *                                         .bitDepth(123)
 *                                         .codingMode("codingMode")
 *                                         .sampleRate(123)
 *                                         .build())
 *                                 .build())
 *                         .languageCode("languageCode")
 *                         .languageCodeControl("languageCodeControl")
 *                         .name("name")
 *                         .remixSettings(RemixSettingsProperty.builder()
 *                                 .channelMappings(List.of(AudioChannelMappingProperty.builder()
 *                                         .inputChannelLevels(List.of(InputChannelLevelProperty.builder()
 *                                                 .gain(123)
 *                                                 .inputChannel(123)
 *                                                 .build()))
 *                                         .outputChannel(123)
 *                                         .build()))
 *                                 .channelsIn(123)
 *                                 .channelsOut(123)
 *                                 .build())
 *                         .streamName("streamName")
 *                         .build()))
 *                 .availBlanking(AvailBlankingProperty.builder()
 *                         .availBlankingImage(InputLocationProperty.builder()
 *                                 .passwordParam("passwordParam")
 *                                 .uri("uri")
 *                                 .username("username")
 *                                 .build())
 *                         .state("state")
 *                         .build())
 *                 .availConfiguration(AvailConfigurationProperty.builder()
 *                         .availSettings(AvailSettingsProperty.builder()
 *                                 .scte35SpliceInsert(Scte35SpliceInsertProperty.builder()
 *                                         .adAvailOffset(123)
 *                                         .noRegionalBlackoutFlag("noRegionalBlackoutFlag")
 *                                         .webDeliveryAllowedFlag("webDeliveryAllowedFlag")
 *                                         .build())
 *                                 .scte35TimeSignalApos(Scte35TimeSignalAposProperty.builder()
 *                                         .adAvailOffset(123)
 *                                         .noRegionalBlackoutFlag("noRegionalBlackoutFlag")
 *                                         .webDeliveryAllowedFlag("webDeliveryAllowedFlag")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .blackoutSlate(BlackoutSlateProperty.builder()
 *                         .blackoutSlateImage(InputLocationProperty.builder()
 *                                 .passwordParam("passwordParam")
 *                                 .uri("uri")
 *                                 .username("username")
 *                                 .build())
 *                         .networkEndBlackout("networkEndBlackout")
 *                         .networkEndBlackoutImage(InputLocationProperty.builder()
 *                                 .passwordParam("passwordParam")
 *                                 .uri("uri")
 *                                 .username("username")
 *                                 .build())
 *                         .networkId("networkId")
 *                         .state("state")
 *                         .build())
 *                 .captionDescriptions(List.of(CaptionDescriptionProperty.builder()
 *                         .captionSelectorName("captionSelectorName")
 *                         .destinationSettings(CaptionDestinationSettingsProperty.builder()
 *                                 .aribDestinationSettings(AribDestinationSettingsProperty.builder().build())
 *                                 .burnInDestinationSettings(BurnInDestinationSettingsProperty.builder()
 *                                         .alignment("alignment")
 *                                         .backgroundColor("backgroundColor")
 *                                         .backgroundOpacity(123)
 *                                         .font(InputLocationProperty.builder()
 *                                                 .passwordParam("passwordParam")
 *                                                 .uri("uri")
 *                                                 .username("username")
 *                                                 .build())
 *                                         .fontColor("fontColor")
 *                                         .fontOpacity(123)
 *                                         .fontResolution(123)
 *                                         .fontSize("fontSize")
 *                                         .outlineColor("outlineColor")
 *                                         .outlineSize(123)
 *                                         .shadowColor("shadowColor")
 *                                         .shadowOpacity(123)
 *                                         .shadowXOffset(123)
 *                                         .shadowYOffset(123)
 *                                         .teletextGridControl("teletextGridControl")
 *                                         .xPosition(123)
 *                                         .yPosition(123)
 *                                         .build())
 *                                 .dvbSubDestinationSettings(DvbSubDestinationSettingsProperty.builder()
 *                                         .alignment("alignment")
 *                                         .backgroundColor("backgroundColor")
 *                                         .backgroundOpacity(123)
 *                                         .font(InputLocationProperty.builder()
 *                                                 .passwordParam("passwordParam")
 *                                                 .uri("uri")
 *                                                 .username("username")
 *                                                 .build())
 *                                         .fontColor("fontColor")
 *                                         .fontOpacity(123)
 *                                         .fontResolution(123)
 *                                         .fontSize("fontSize")
 *                                         .outlineColor("outlineColor")
 *                                         .outlineSize(123)
 *                                         .shadowColor("shadowColor")
 *                                         .shadowOpacity(123)
 *                                         .shadowXOffset(123)
 *                                         .shadowYOffset(123)
 *                                         .teletextGridControl("teletextGridControl")
 *                                         .xPosition(123)
 *                                         .yPosition(123)
 *                                         .build())
 *                                 .ebuTtDDestinationSettings(EbuTtDDestinationSettingsProperty.builder()
 *                                         .copyrightHolder("copyrightHolder")
 *                                         .fillLineGap("fillLineGap")
 *                                         .fontFamily("fontFamily")
 *                                         .styleControl("styleControl")
 *                                         .build())
 *                                 .embeddedDestinationSettings(EmbeddedDestinationSettingsProperty.builder().build())
 *                                 .embeddedPlusScte20DestinationSettings(EmbeddedPlusScte20DestinationSettingsProperty.builder().build())
 *                                 .rtmpCaptionInfoDestinationSettings(RtmpCaptionInfoDestinationSettingsProperty.builder().build())
 *                                 .scte20PlusEmbeddedDestinationSettings(Scte20PlusEmbeddedDestinationSettingsProperty.builder().build())
 *                                 .scte27DestinationSettings(Scte27DestinationSettingsProperty.builder().build())
 *                                 .smpteTtDestinationSettings(SmpteTtDestinationSettingsProperty.builder().build())
 *                                 .teletextDestinationSettings(TeletextDestinationSettingsProperty.builder().build())
 *                                 .ttmlDestinationSettings(TtmlDestinationSettingsProperty.builder()
 *                                         .styleControl("styleControl")
 *                                         .build())
 *                                 .webvttDestinationSettings(WebvttDestinationSettingsProperty.builder()
 *                                         .styleControl("styleControl")
 *                                         .build())
 *                                 .build())
 *                         .languageCode("languageCode")
 *                         .languageDescription("languageDescription")
 *                         .name("name")
 *                         .build()))
 *                 .featureActivations(FeatureActivationsProperty.builder()
 *                         .inputPrepareScheduleActions("inputPrepareScheduleActions")
 *                         .build())
 *                 .globalConfiguration(GlobalConfigurationProperty.builder()
 *                         .initialAudioGain(123)
 *                         .inputEndAction("inputEndAction")
 *                         .inputLossBehavior(InputLossBehaviorProperty.builder()
 *                                 .blackFrameMsec(123)
 *                                 .inputLossImageColor("inputLossImageColor")
 *                                 .inputLossImageSlate(InputLocationProperty.builder()
 *                                         .passwordParam("passwordParam")
 *                                         .uri("uri")
 *                                         .username("username")
 *                                         .build())
 *                                 .inputLossImageType("inputLossImageType")
 *                                 .repeatFrameMsec(123)
 *                                 .build())
 *                         .outputLockingMode("outputLockingMode")
 *                         .outputTimingSource("outputTimingSource")
 *                         .supportLowFramerateInputs("supportLowFramerateInputs")
 *                         .build())
 *                 .motionGraphicsConfiguration(MotionGraphicsConfigurationProperty.builder()
 *                         .motionGraphicsInsertion("motionGraphicsInsertion")
 *                         .motionGraphicsSettings(MotionGraphicsSettingsProperty.builder()
 *                                 .htmlMotionGraphicsSettings(HtmlMotionGraphicsSettingsProperty.builder().build())
 *                                 .build())
 *                         .build())
 *                 .nielsenConfiguration(NielsenConfigurationProperty.builder()
 *                         .distributorId("distributorId")
 *                         .nielsenPcmToId3Tagging("nielsenPcmToId3Tagging")
 *                         .build())
 *                 .outputGroups(List.of(OutputGroupProperty.builder()
 *                         .name("name")
 *                         .outputGroupSettings(OutputGroupSettingsProperty.builder()
 *                                 .archiveGroupSettings(ArchiveGroupSettingsProperty.builder()
 *                                         .archiveCdnSettings(ArchiveCdnSettingsProperty.builder()
 *                                                 .archiveS3Settings(ArchiveS3SettingsProperty.builder()
 *                                                         .cannedAcl("cannedAcl")
 *                                                         .build())
 *                                                 .build())
 *                                         .destination(OutputLocationRefProperty.builder()
 *                                                 .destinationRefId("destinationRefId")
 *                                                 .build())
 *                                         .rolloverInterval(123)
 *                                         .build())
 *                                 .frameCaptureGroupSettings(FrameCaptureGroupSettingsProperty.builder()
 *                                         .destination(OutputLocationRefProperty.builder()
 *                                                 .destinationRefId("destinationRefId")
 *                                                 .build())
 *                                         .frameCaptureCdnSettings(FrameCaptureCdnSettingsProperty.builder()
 *                                                 .frameCaptureS3Settings(FrameCaptureS3SettingsProperty.builder()
 *                                                         .cannedAcl("cannedAcl")
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .hlsGroupSettings(HlsGroupSettingsProperty.builder()
 *                                         .adMarkers(List.of("adMarkers"))
 *                                         .baseUrlContent("baseUrlContent")
 *                                         .baseUrlContent1("baseUrlContent1")
 *                                         .baseUrlManifest("baseUrlManifest")
 *                                         .baseUrlManifest1("baseUrlManifest1")
 *                                         .captionLanguageMappings(List.of(CaptionLanguageMappingProperty.builder()
 *                                                 .captionChannel(123)
 *                                                 .languageCode("languageCode")
 *                                                 .languageDescription("languageDescription")
 *                                                 .build()))
 *                                         .captionLanguageSetting("captionLanguageSetting")
 *                                         .clientCache("clientCache")
 *                                         .codecSpecification("codecSpecification")
 *                                         .constantIv("constantIv")
 *                                         .destination(OutputLocationRefProperty.builder()
 *                                                 .destinationRefId("destinationRefId")
 *                                                 .build())
 *                                         .directoryStructure("directoryStructure")
 *                                         .discontinuityTags("discontinuityTags")
 *                                         .encryptionType("encryptionType")
 *                                         .hlsCdnSettings(HlsCdnSettingsProperty.builder()
 *                                                 .hlsAkamaiSettings(HlsAkamaiSettingsProperty.builder()
 *                                                         .connectionRetryInterval(123)
 *                                                         .filecacheDuration(123)
 *                                                         .httpTransferMode("httpTransferMode")
 *                                                         .numRetries(123)
 *                                                         .restartDelay(123)
 *                                                         .salt("salt")
 *                                                         .token("token")
 *                                                         .build())
 *                                                 .hlsBasicPutSettings(HlsBasicPutSettingsProperty.builder()
 *                                                         .connectionRetryInterval(123)
 *                                                         .filecacheDuration(123)
 *                                                         .numRetries(123)
 *                                                         .restartDelay(123)
 *                                                         .build())
 *                                                 .hlsMediaStoreSettings(HlsMediaStoreSettingsProperty.builder()
 *                                                         .connectionRetryInterval(123)
 *                                                         .filecacheDuration(123)
 *                                                         .mediaStoreStorageClass("mediaStoreStorageClass")
 *                                                         .numRetries(123)
 *                                                         .restartDelay(123)
 *                                                         .build())
 *                                                 .hlsS3Settings(HlsS3SettingsProperty.builder()
 *                                                         .cannedAcl("cannedAcl")
 *                                                         .build())
 *                                                 .hlsWebdavSettings(HlsWebdavSettingsProperty.builder()
 *                                                         .connectionRetryInterval(123)
 *                                                         .filecacheDuration(123)
 *                                                         .httpTransferMode("httpTransferMode")
 *                                                         .numRetries(123)
 *                                                         .restartDelay(123)
 *                                                         .build())
 *                                                 .build())
 *                                         .hlsId3SegmentTagging("hlsId3SegmentTagging")
 *                                         .iFrameOnlyPlaylists("iFrameOnlyPlaylists")
 *                                         .incompleteSegmentBehavior("incompleteSegmentBehavior")
 *                                         .indexNSegments(123)
 *                                         .inputLossAction("inputLossAction")
 *                                         .ivInManifest("ivInManifest")
 *                                         .ivSource("ivSource")
 *                                         .keepSegments(123)
 *                                         .keyFormat("keyFormat")
 *                                         .keyFormatVersions("keyFormatVersions")
 *                                         .keyProviderSettings(KeyProviderSettingsProperty.builder()
 *                                                 .staticKeySettings(StaticKeySettingsProperty.builder()
 *                                                         .keyProviderServer(InputLocationProperty.builder()
 *                                                                 .passwordParam("passwordParam")
 *                                                                 .uri("uri")
 *                                                                 .username("username")
 *                                                                 .build())
 *                                                         .staticKeyValue("staticKeyValue")
 *                                                         .build())
 *                                                 .build())
 *                                         .manifestCompression("manifestCompression")
 *                                         .manifestDurationFormat("manifestDurationFormat")
 *                                         .minSegmentLength(123)
 *                                         .mode("mode")
 *                                         .outputSelection("outputSelection")
 *                                         .programDateTime("programDateTime")
 *                                         .programDateTimeClock("programDateTimeClock")
 *                                         .programDateTimePeriod(123)
 *                                         .redundantManifest("redundantManifest")
 *                                         .segmentationMode("segmentationMode")
 *                                         .segmentLength(123)
 *                                         .segmentsPerSubdirectory(123)
 *                                         .streamInfResolution("streamInfResolution")
 *                                         .timedMetadataId3Frame("timedMetadataId3Frame")
 *                                         .timedMetadataId3Period(123)
 *                                         .timestampDeltaMilliseconds(123)
 *                                         .tsFileMode("tsFileMode")
 *                                         .build())
 *                                 .mediaPackageGroupSettings(MediaPackageGroupSettingsProperty.builder()
 *                                         .destination(OutputLocationRefProperty.builder()
 *                                                 .destinationRefId("destinationRefId")
 *                                                 .build())
 *                                         .build())
 *                                 .msSmoothGroupSettings(MsSmoothGroupSettingsProperty.builder()
 *                                         .acquisitionPointId("acquisitionPointId")
 *                                         .audioOnlyTimecodeControl("audioOnlyTimecodeControl")
 *                                         .certificateMode("certificateMode")
 *                                         .connectionRetryInterval(123)
 *                                         .destination(OutputLocationRefProperty.builder()
 *                                                 .destinationRefId("destinationRefId")
 *                                                 .build())
 *                                         .eventId("eventId")
 *                                         .eventIdMode("eventIdMode")
 *                                         .eventStopBehavior("eventStopBehavior")
 *                                         .filecacheDuration(123)
 *                                         .fragmentLength(123)
 *                                         .inputLossAction("inputLossAction")
 *                                         .numRetries(123)
 *                                         .restartDelay(123)
 *                                         .segmentationMode("segmentationMode")
 *                                         .sendDelayMs(123)
 *                                         .sparseTrackType("sparseTrackType")
 *                                         .streamManifestBehavior("streamManifestBehavior")
 *                                         .timestampOffset("timestampOffset")
 *                                         .timestampOffsetMode("timestampOffsetMode")
 *                                         .build())
 *                                 .multiplexGroupSettings(MultiplexGroupSettingsProperty.builder().build())
 *                                 .rtmpGroupSettings(RtmpGroupSettingsProperty.builder()
 *                                         .adMarkers(List.of("adMarkers"))
 *                                         .authenticationScheme("authenticationScheme")
 *                                         .cacheFullBehavior("cacheFullBehavior")
 *                                         .cacheLength(123)
 *                                         .captionData("captionData")
 *                                         .inputLossAction("inputLossAction")
 *                                         .restartDelay(123)
 *                                         .build())
 *                                 .udpGroupSettings(UdpGroupSettingsProperty.builder()
 *                                         .inputLossAction("inputLossAction")
 *                                         .timedMetadataId3Frame("timedMetadataId3Frame")
 *                                         .timedMetadataId3Period(123)
 *                                         .build())
 *                                 .build())
 *                         .outputs(List.of(OutputProperty.builder()
 *                                 .audioDescriptionNames(List.of("audioDescriptionNames"))
 *                                 .captionDescriptionNames(List.of("captionDescriptionNames"))
 *                                 .outputName("outputName")
 *                                 .outputSettings(OutputSettingsProperty.builder()
 *                                         .archiveOutputSettings(ArchiveOutputSettingsProperty.builder()
 *                                                 .containerSettings(ArchiveContainerSettingsProperty.builder()
 *                                                         .m2TsSettings(M2tsSettingsProperty.builder()
 *                                                                 .absentInputAudioBehavior("absentInputAudioBehavior")
 *                                                                 .arib("arib")
 *                                                                 .aribCaptionsPid("aribCaptionsPid")
 *                                                                 .aribCaptionsPidControl("aribCaptionsPidControl")
 *                                                                 .audioBufferModel("audioBufferModel")
 *                                                                 .audioFramesPerPes(123)
 *                                                                 .audioPids("audioPids")
 *                                                                 .audioStreamType("audioStreamType")
 *                                                                 .bitrate(123)
 *                                                                 .bufferModel("bufferModel")
 *                                                                 .ccDescriptor("ccDescriptor")
 *                                                                 .dvbNitSettings(DvbNitSettingsProperty.builder()
 *                                                                         .networkId(123)
 *                                                                         .networkName("networkName")
 *                                                                         .repInterval(123)
 *                                                                         .build())
 *                                                                 .dvbSdtSettings(DvbSdtSettingsProperty.builder()
 *                                                                         .outputSdt("outputSdt")
 *                                                                         .repInterval(123)
 *                                                                         .serviceName("serviceName")
 *                                                                         .serviceProviderName("serviceProviderName")
 *                                                                         .build())
 *                                                                 .dvbSubPids("dvbSubPids")
 *                                                                 .dvbTdtSettings(DvbTdtSettingsProperty.builder()
 *                                                                         .repInterval(123)
 *                                                                         .build())
 *                                                                 .dvbTeletextPid("dvbTeletextPid")
 *                                                                 .ebif("ebif")
 *                                                                 .ebpAudioInterval("ebpAudioInterval")
 *                                                                 .ebpLookaheadMs(123)
 *                                                                 .ebpPlacement("ebpPlacement")
 *                                                                 .ecmPid("ecmPid")
 *                                                                 .esRateInPes("esRateInPes")
 *                                                                 .etvPlatformPid("etvPlatformPid")
 *                                                                 .etvSignalPid("etvSignalPid")
 *                                                                 .fragmentTime(123)
 *                                                                 .klv("klv")
 *                                                                 .klvDataPids("klvDataPids")
 *                                                                 .nielsenId3Behavior("nielsenId3Behavior")
 *                                                                 .nullPacketBitrate(123)
 *                                                                 .patInterval(123)
 *                                                                 .pcrControl("pcrControl")
 *                                                                 .pcrPeriod(123)
 *                                                                 .pcrPid("pcrPid")
 *                                                                 .pmtInterval(123)
 *                                                                 .pmtPid("pmtPid")
 *                                                                 .programNum(123)
 *                                                                 .rateMode("rateMode")
 *                                                                 .scte27Pids("scte27Pids")
 *                                                                 .scte35Control("scte35Control")
 *                                                                 .scte35Pid("scte35Pid")
 *                                                                 .segmentationMarkers("segmentationMarkers")
 *                                                                 .segmentationStyle("segmentationStyle")
 *                                                                 .segmentationTime(123)
 *                                                                 .timedMetadataBehavior("timedMetadataBehavior")
 *                                                                 .timedMetadataPid("timedMetadataPid")
 *                                                                 .transportStreamId(123)
 *                                                                 .videoPid("videoPid")
 *                                                                 .build())
 *                                                         .rawSettings(RawSettingsProperty.builder().build())
 *                                                         .build())
 *                                                 .extension("extension")
 *                                                 .nameModifier("nameModifier")
 *                                                 .build())
 *                                         .frameCaptureOutputSettings(FrameCaptureOutputSettingsProperty.builder()
 *                                                 .nameModifier("nameModifier")
 *                                                 .build())
 *                                         .hlsOutputSettings(HlsOutputSettingsProperty.builder()
 *                                                 .h265PackagingType("h265PackagingType")
 *                                                 .hlsSettings(HlsSettingsProperty.builder()
 *                                                         .audioOnlyHlsSettings(AudioOnlyHlsSettingsProperty.builder()
 *                                                                 .audioGroupId("audioGroupId")
 *                                                                 .audioOnlyImage(InputLocationProperty.builder()
 *                                                                         .passwordParam("passwordParam")
 *                                                                         .uri("uri")
 *                                                                         .username("username")
 *                                                                         .build())
 *                                                                 .audioTrackType("audioTrackType")
 *                                                                 .segmentType("segmentType")
 *                                                                 .build())
 *                                                         .fmp4HlsSettings(Fmp4HlsSettingsProperty.builder()
 *                                                                 .audioRenditionSets("audioRenditionSets")
 *                                                                 .nielsenId3Behavior("nielsenId3Behavior")
 *                                                                 .timedMetadataBehavior("timedMetadataBehavior")
 *                                                                 .build())
 *                                                         .frameCaptureHlsSettings(FrameCaptureHlsSettingsProperty.builder().build())
 *                                                         .standardHlsSettings(StandardHlsSettingsProperty.builder()
 *                                                                 .audioRenditionSets("audioRenditionSets")
 *                                                                 .m3U8Settings(M3u8SettingsProperty.builder()
 *                                                                         .audioFramesPerPes(123)
 *                                                                         .audioPids("audioPids")
 *                                                                         .ecmPid("ecmPid")
 *                                                                         .nielsenId3Behavior("nielsenId3Behavior")
 *                                                                         .patInterval(123)
 *                                                                         .pcrControl("pcrControl")
 *                                                                         .pcrPeriod(123)
 *                                                                         .pcrPid("pcrPid")
 *                                                                         .pmtInterval(123)
 *                                                                         .pmtPid("pmtPid")
 *                                                                         .programNum(123)
 *                                                                         .scte35Behavior("scte35Behavior")
 *                                                                         .scte35Pid("scte35Pid")
 *                                                                         .timedMetadataBehavior("timedMetadataBehavior")
 *                                                                         .timedMetadataPid("timedMetadataPid")
 *                                                                         .transportStreamId(123)
 *                                                                         .videoPid("videoPid")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         .build())
 *                                                 .nameModifier("nameModifier")
 *                                                 .segmentModifier("segmentModifier")
 *                                                 .build())
 *                                         .mediaPackageOutputSettings(MediaPackageOutputSettingsProperty.builder().build())
 *                                         .msSmoothOutputSettings(MsSmoothOutputSettingsProperty.builder()
 *                                                 .h265PackagingType("h265PackagingType")
 *                                                 .nameModifier("nameModifier")
 *                                                 .build())
 *                                         .multiplexOutputSettings(MultiplexOutputSettingsProperty.builder()
 *                                                 .destination(OutputLocationRefProperty.builder()
 *                                                         .destinationRefId("destinationRefId")
 *                                                         .build())
 *                                                 .build())
 *                                         .rtmpOutputSettings(RtmpOutputSettingsProperty.builder()
 *                                                 .certificateMode("certificateMode")
 *                                                 .connectionRetryInterval(123)
 *                                                 .destination(OutputLocationRefProperty.builder()
 *                                                         .destinationRefId("destinationRefId")
 *                                                         .build())
 *                                                 .numRetries(123)
 *                                                 .build())
 *                                         .udpOutputSettings(UdpOutputSettingsProperty.builder()
 *                                                 .bufferMsec(123)
 *                                                 .containerSettings(UdpContainerSettingsProperty.builder()
 *                                                         .m2TsSettings(M2tsSettingsProperty.builder()
 *                                                                 .absentInputAudioBehavior("absentInputAudioBehavior")
 *                                                                 .arib("arib")
 *                                                                 .aribCaptionsPid("aribCaptionsPid")
 *                                                                 .aribCaptionsPidControl("aribCaptionsPidControl")
 *                                                                 .audioBufferModel("audioBufferModel")
 *                                                                 .audioFramesPerPes(123)
 *                                                                 .audioPids("audioPids")
 *                                                                 .audioStreamType("audioStreamType")
 *                                                                 .bitrate(123)
 *                                                                 .bufferModel("bufferModel")
 *                                                                 .ccDescriptor("ccDescriptor")
 *                                                                 .dvbNitSettings(DvbNitSettingsProperty.builder()
 *                                                                         .networkId(123)
 *                                                                         .networkName("networkName")
 *                                                                         .repInterval(123)
 *                                                                         .build())
 *                                                                 .dvbSdtSettings(DvbSdtSettingsProperty.builder()
 *                                                                         .outputSdt("outputSdt")
 *                                                                         .repInterval(123)
 *                                                                         .serviceName("serviceName")
 *                                                                         .serviceProviderName("serviceProviderName")
 *                                                                         .build())
 *                                                                 .dvbSubPids("dvbSubPids")
 *                                                                 .dvbTdtSettings(DvbTdtSettingsProperty.builder()
 *                                                                         .repInterval(123)
 *                                                                         .build())
 *                                                                 .dvbTeletextPid("dvbTeletextPid")
 *                                                                 .ebif("ebif")
 *                                                                 .ebpAudioInterval("ebpAudioInterval")
 *                                                                 .ebpLookaheadMs(123)
 *                                                                 .ebpPlacement("ebpPlacement")
 *                                                                 .ecmPid("ecmPid")
 *                                                                 .esRateInPes("esRateInPes")
 *                                                                 .etvPlatformPid("etvPlatformPid")
 *                                                                 .etvSignalPid("etvSignalPid")
 *                                                                 .fragmentTime(123)
 *                                                                 .klv("klv")
 *                                                                 .klvDataPids("klvDataPids")
 *                                                                 .nielsenId3Behavior("nielsenId3Behavior")
 *                                                                 .nullPacketBitrate(123)
 *                                                                 .patInterval(123)
 *                                                                 .pcrControl("pcrControl")
 *                                                                 .pcrPeriod(123)
 *                                                                 .pcrPid("pcrPid")
 *                                                                 .pmtInterval(123)
 *                                                                 .pmtPid("pmtPid")
 *                                                                 .programNum(123)
 *                                                                 .rateMode("rateMode")
 *                                                                 .scte27Pids("scte27Pids")
 *                                                                 .scte35Control("scte35Control")
 *                                                                 .scte35Pid("scte35Pid")
 *                                                                 .segmentationMarkers("segmentationMarkers")
 *                                                                 .segmentationStyle("segmentationStyle")
 *                                                                 .segmentationTime(123)
 *                                                                 .timedMetadataBehavior("timedMetadataBehavior")
 *                                                                 .timedMetadataPid("timedMetadataPid")
 *                                                                 .transportStreamId(123)
 *                                                                 .videoPid("videoPid")
 *                                                                 .build())
 *                                                         .build())
 *                                                 .destination(OutputLocationRefProperty.builder()
 *                                                         .destinationRefId("destinationRefId")
 *                                                         .build())
 *                                                 .fecOutputSettings(FecOutputSettingsProperty.builder()
 *                                                         .columnDepth(123)
 *                                                         .includeFec("includeFec")
 *                                                         .rowLength(123)
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .videoDescriptionName("videoDescriptionName")
 *                                 .build()))
 *                         .build()))
 *                 .timecodeConfig(TimecodeConfigProperty.builder()
 *                         .source("source")
 *                         .syncThreshold(123)
 *                         .build())
 *                 .videoDescriptions(List.of(VideoDescriptionProperty.builder()
 *                         .codecSettings(VideoCodecSettingsProperty.builder()
 *                                 .frameCaptureSettings(FrameCaptureSettingsProperty.builder()
 *                                         .captureInterval(123)
 *                                         .captureIntervalUnits("captureIntervalUnits")
 *                                         .build())
 *                                 .h264Settings(H264SettingsProperty.builder()
 *                                         .adaptiveQuantization("adaptiveQuantization")
 *                                         .afdSignaling("afdSignaling")
 *                                         .bitrate(123)
 *                                         .bufFillPct(123)
 *                                         .bufSize(123)
 *                                         .colorMetadata("colorMetadata")
 *                                         .colorSpaceSettings(H264ColorSpaceSettingsProperty.builder()
 *                                                 .colorSpacePassthroughSettings(ColorSpacePassthroughSettingsProperty.builder().build())
 *                                                 .rec601Settings(Rec601SettingsProperty.builder().build())
 *                                                 .rec709Settings(Rec709SettingsProperty.builder().build())
 *                                                 .build())
 *                                         .entropyEncoding("entropyEncoding")
 *                                         .filterSettings(H264FilterSettingsProperty.builder()
 *                                                 .temporalFilterSettings(TemporalFilterSettingsProperty.builder()
 *                                                         .postFilterSharpening("postFilterSharpening")
 *                                                         .strength("strength")
 *                                                         .build())
 *                                                 .build())
 *                                         .fixedAfd("fixedAfd")
 *                                         .flickerAq("flickerAq")
 *                                         .forceFieldPictures("forceFieldPictures")
 *                                         .framerateControl("framerateControl")
 *                                         .framerateDenominator(123)
 *                                         .framerateNumerator(123)
 *                                         .gopBReference("gopBReference")
 *                                         .gopClosedCadence(123)
 *                                         .gopNumBFrames(123)
 *                                         .gopSize(123)
 *                                         .gopSizeUnits("gopSizeUnits")
 *                                         .level("level")
 *                                         .lookAheadRateControl("lookAheadRateControl")
 *                                         .maxBitrate(123)
 *                                         .minIInterval(123)
 *                                         .numRefFrames(123)
 *                                         .parControl("parControl")
 *                                         .parDenominator(123)
 *                                         .parNumerator(123)
 *                                         .profile("profile")
 *                                         .qualityLevel("qualityLevel")
 *                                         .qvbrQualityLevel(123)
 *                                         .rateControlMode("rateControlMode")
 *                                         .scanType("scanType")
 *                                         .sceneChangeDetect("sceneChangeDetect")
 *                                         .slices(123)
 *                                         .softness(123)
 *                                         .spatialAq("spatialAq")
 *                                         .subgopLength("subgopLength")
 *                                         .syntax("syntax")
 *                                         .temporalAq("temporalAq")
 *                                         .timecodeInsertion("timecodeInsertion")
 *                                         .build())
 *                                 .h265Settings(H265SettingsProperty.builder()
 *                                         .adaptiveQuantization("adaptiveQuantization")
 *                                         .afdSignaling("afdSignaling")
 *                                         .alternativeTransferFunction("alternativeTransferFunction")
 *                                         .bitrate(123)
 *                                         .bufSize(123)
 *                                         .colorMetadata("colorMetadata")
 *                                         .colorSpaceSettings(H265ColorSpaceSettingsProperty.builder()
 *                                                 .colorSpacePassthroughSettings(ColorSpacePassthroughSettingsProperty.builder().build())
 *                                                 .hdr10Settings(Hdr10SettingsProperty.builder()
 *                                                         .maxCll(123)
 *                                                         .maxFall(123)
 *                                                         .build())
 *                                                 .rec601Settings(Rec601SettingsProperty.builder().build())
 *                                                 .rec709Settings(Rec709SettingsProperty.builder().build())
 *                                                 .build())
 *                                         .filterSettings(H265FilterSettingsProperty.builder()
 *                                                 .temporalFilterSettings(TemporalFilterSettingsProperty.builder()
 *                                                         .postFilterSharpening("postFilterSharpening")
 *                                                         .strength("strength")
 *                                                         .build())
 *                                                 .build())
 *                                         .fixedAfd("fixedAfd")
 *                                         .flickerAq("flickerAq")
 *                                         .framerateDenominator(123)
 *                                         .framerateNumerator(123)
 *                                         .gopClosedCadence(123)
 *                                         .gopSize(123)
 *                                         .gopSizeUnits("gopSizeUnits")
 *                                         .level("level")
 *                                         .lookAheadRateControl("lookAheadRateControl")
 *                                         .maxBitrate(123)
 *                                         .minIInterval(123)
 *                                         .parDenominator(123)
 *                                         .parNumerator(123)
 *                                         .profile("profile")
 *                                         .qvbrQualityLevel(123)
 *                                         .rateControlMode("rateControlMode")
 *                                         .scanType("scanType")
 *                                         .sceneChangeDetect("sceneChangeDetect")
 *                                         .slices(123)
 *                                         .tier("tier")
 *                                         .timecodeInsertion("timecodeInsertion")
 *                                         .build())
 *                                 .mpeg2Settings(Mpeg2SettingsProperty.builder()
 *                                         .adaptiveQuantization("adaptiveQuantization")
 *                                         .afdSignaling("afdSignaling")
 *                                         .colorMetadata("colorMetadata")
 *                                         .colorSpace("colorSpace")
 *                                         .displayAspectRatio("displayAspectRatio")
 *                                         .filterSettings(Mpeg2FilterSettingsProperty.builder()
 *                                                 .temporalFilterSettings(TemporalFilterSettingsProperty.builder()
 *                                                         .postFilterSharpening("postFilterSharpening")
 *                                                         .strength("strength")
 *                                                         .build())
 *                                                 .build())
 *                                         .fixedAfd("fixedAfd")
 *                                         .framerateDenominator(123)
 *                                         .framerateNumerator(123)
 *                                         .gopClosedCadence(123)
 *                                         .gopNumBFrames(123)
 *                                         .gopSize(123)
 *                                         .gopSizeUnits("gopSizeUnits")
 *                                         .scanType("scanType")
 *                                         .subgopLength("subgopLength")
 *                                         .timecodeInsertion("timecodeInsertion")
 *                                         .build())
 *                                 .build())
 *                         .height(123)
 *                         .name("name")
 *                         .respondToAfd("respondToAfd")
 *                         .scalingBehavior("scalingBehavior")
 *                         .sharpness(123)
 *                         .width(123)
 *                         .build()))
 *                 .build())
 *         .inputAttachments(List.of(InputAttachmentProperty.builder()
 *                 .automaticInputFailoverSettings(AutomaticInputFailoverSettingsProperty.builder()
 *                         .errorClearTimeMsec(123)
 *                         .failoverConditions(List.of(FailoverConditionProperty.builder()
 *                                 .failoverConditionSettings(FailoverConditionSettingsProperty.builder()
 *                                         .audioSilenceSettings(AudioSilenceFailoverSettingsProperty.builder()
 *                                                 .audioSelectorName("audioSelectorName")
 *                                                 .audioSilenceThresholdMsec(123)
 *                                                 .build())
 *                                         .inputLossSettings(InputLossFailoverSettingsProperty.builder()
 *                                                 .inputLossThresholdMsec(123)
 *                                                 .build())
 *                                         .videoBlackSettings(VideoBlackFailoverSettingsProperty.builder()
 *                                                 .blackDetectThreshold(123)
 *                                                 .videoBlackThresholdMsec(123)
 *                                                 .build())
 *                                         .build())
 *                                 .build()))
 *                         .inputPreference("inputPreference")
 *                         .secondaryInputId("secondaryInputId")
 *                         .build())
 *                 .inputAttachmentName("inputAttachmentName")
 *                 .inputId("inputId")
 *                 .inputSettings(InputSettingsProperty.builder()
 *                         .audioSelectors(List.of(AudioSelectorProperty.builder()
 *                                 .name("name")
 *                                 .selectorSettings(AudioSelectorSettingsProperty.builder()
 *                                         .audioHlsRenditionSelection(AudioHlsRenditionSelectionProperty.builder()
 *                                                 .groupId("groupId")
 *                                                 .name("name")
 *                                                 .build())
 *                                         .audioLanguageSelection(AudioLanguageSelectionProperty.builder()
 *                                                 .languageCode("languageCode")
 *                                                 .languageSelectionPolicy("languageSelectionPolicy")
 *                                                 .build())
 *                                         .audioPidSelection(AudioPidSelectionProperty.builder()
 *                                                 .pid(123)
 *                                                 .build())
 *                                         .audioTrackSelection(AudioTrackSelectionProperty.builder()
 *                                                 .tracks(List.of(AudioTrackProperty.builder()
 *                                                         .track(123)
 *                                                         .build()))
 *                                                 .build())
 *                                         .build())
 *                                 .build()))
 *                         .captionSelectors(List.of(CaptionSelectorProperty.builder()
 *                                 .languageCode("languageCode")
 *                                 .name("name")
 *                                 .selectorSettings(CaptionSelectorSettingsProperty.builder()
 *                                         .ancillarySourceSettings(AncillarySourceSettingsProperty.builder()
 *                                                 .sourceAncillaryChannelNumber(123)
 *                                                 .build())
 *                                         .aribSourceSettings(AribSourceSettingsProperty.builder().build())
 *                                         .dvbSubSourceSettings(DvbSubSourceSettingsProperty.builder()
 *                                                 .ocrLanguage("ocrLanguage")
 *                                                 .pid(123)
 *                                                 .build())
 *                                         .embeddedSourceSettings(EmbeddedSourceSettingsProperty.builder()
 *                                                 .convert608To708("convert608To708")
 *                                                 .scte20Detection("scte20Detection")
 *                                                 .source608ChannelNumber(123)
 *                                                 .source608TrackNumber(123)
 *                                                 .build())
 *                                         .scte20SourceSettings(Scte20SourceSettingsProperty.builder()
 *                                                 .convert608To708("convert608To708")
 *                                                 .source608ChannelNumber(123)
 *                                                 .build())
 *                                         .scte27SourceSettings(Scte27SourceSettingsProperty.builder()
 *                                                 .ocrLanguage("ocrLanguage")
 *                                                 .pid(123)
 *                                                 .build())
 *                                         .teletextSourceSettings(TeletextSourceSettingsProperty.builder()
 *                                                 .outputRectangle(CaptionRectangleProperty.builder()
 *                                                         .height(123)
 *                                                         .leftOffset(123)
 *                                                         .topOffset(123)
 *                                                         .width(123)
 *                                                         .build())
 *                                                 .pageNumber("pageNumber")
 *                                                 .build())
 *                                         .build())
 *                                 .build()))
 *                         .deblockFilter("deblockFilter")
 *                         .denoiseFilter("denoiseFilter")
 *                         .filterStrength(123)
 *                         .inputFilter("inputFilter")
 *                         .networkInputSettings(NetworkInputSettingsProperty.builder()
 *                                 .hlsInputSettings(HlsInputSettingsProperty.builder()
 *                                         .bandwidth(123)
 *                                         .bufferSegments(123)
 *                                         .retries(123)
 *                                         .retryInterval(123)
 *                                         .scte35Source("scte35Source")
 *                                         .build())
 *                                 .serverValidation("serverValidation")
 *                                 .build())
 *                         .scte35Pid(123)
 *                         .smpte2038DataPreference("smpte2038DataPreference")
 *                         .sourceEndBehavior("sourceEndBehavior")
 *                         .videoSelector(VideoSelectorProperty.builder()
 *                                 .colorSpace("colorSpace")
 *                                 .colorSpaceSettings(VideoSelectorColorSpaceSettingsProperty.builder()
 *                                         .hdr10Settings(Hdr10SettingsProperty.builder()
 *                                                 .maxCll(123)
 *                                                 .maxFall(123)
 *                                                 .build())
 *                                         .build())
 *                                 .colorSpaceUsage("colorSpaceUsage")
 *                                 .selectorSettings(VideoSelectorSettingsProperty.builder()
 *                                         .videoSelectorPid(VideoSelectorPidProperty.builder()
 *                                                 .pid(123)
 *                                                 .build())
 *                                         .videoSelectorProgramId(VideoSelectorProgramIdProperty.builder()
 *                                                 .programId(123)
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .inputSpecification(InputSpecificationProperty.builder()
 *                 .codec("codec")
 *                 .maximumBitrate("maximumBitrate")
 *                 .resolution("resolution")
 *                 .build())
 *         .logLevel("logLevel")
 *         .name("name")
 *         .roleArn("roleArn")
 *         .tags(tags)
 *         .vpc(VpcOutputSettingsProperty.builder()
 *                 .publicAddressAllocationIds(List.of("publicAddressAllocationIds"))
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:13.466Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel")
public class CfnChannel extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnChannel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnChannel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.medialive.CfnChannel.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::MediaLive::Channel`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnChannel(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.medialive.CfnChannelProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::MediaLive::Channel`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnChannel(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the MediaLive channel.
     * <p>
     * For example: arn:aws:medialive:us-west-1:111122223333:medialive:channel:1234567
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The inputs that are attached to this channel.
     * <p>
     * The inputs are identified by their IDs (not by their names or their ARNs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrInputs() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrInputs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A collection of tags for this channel.
     * <p>
     * Each tag is a key-value pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Specification of CDI inputs for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCdiInputSpecification() {
        return software.amazon.jsii.Kernel.get(this, "cdiInputSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specification of CDI inputs for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCdiInputSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.medialive.CfnChannel.CdiInputSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "cdiInputSpecification", value);
    }

    /**
     * Specification of CDI inputs for this channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCdiInputSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cdiInputSpecification", value);
    }

    /**
     * The class for this channel.
     * <p>
     * For a channel with two pipelines, the class is STANDARD. For a channel with one pipeline, the class is SINGLE_PIPELINE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getChannelClass() {
        return software.amazon.jsii.Kernel.get(this, "channelClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The class for this channel.
     * <p>
     * For a channel with two pipelines, the class is STANDARD. For a channel with one pipeline, the class is SINGLE_PIPELINE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelClass(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "channelClass", value);
    }

    /**
     * The settings that identify the destination for the outputs in this MediaLive output package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDestinations() {
        return software.amazon.jsii.Kernel.get(this, "destinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings that identify the destination for the outputs in this MediaLive output package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "destinations", value);
    }

    /**
     * The settings that identify the destination for the outputs in this MediaLive output package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.medialive.CfnChannel.OutputDestinationProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.medialive.CfnChannel.OutputDestinationProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "destinations", value);
    }

    /**
     * The encoding configuration for the output content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncoderSettings() {
        return software.amazon.jsii.Kernel.get(this, "encoderSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The encoding configuration for the output content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncoderSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.medialive.CfnChannel.EncoderSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "encoderSettings", value);
    }

    /**
     * The encoding configuration for the output content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncoderSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encoderSettings", value);
    }

    /**
     * The list of input attachments for the channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInputAttachments() {
        return software.amazon.jsii.Kernel.get(this, "inputAttachments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The list of input attachments for the channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputAttachments(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inputAttachments", value);
    }

    /**
     * The list of input attachments for the channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputAttachments(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.medialive.CfnChannel.InputAttachmentProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.medialive.CfnChannel.InputAttachmentProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "inputAttachments", value);
    }

    /**
     * The input specification for this channel.
     * <p>
     * It specifies the key characteristics of the inputs for this channel: the maximum bitrate, the resolution, and the codec.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInputSpecification() {
        return software.amazon.jsii.Kernel.get(this, "inputSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The input specification for this channel.
     * <p>
     * It specifies the key characteristics of the inputs for this channel: the maximum bitrate, the resolution, and the codec.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.medialive.CfnChannel.InputSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "inputSpecification", value);
    }

    /**
     * The input specification for this channel.
     * <p>
     * It specifies the key characteristics of the inputs for this channel: the maximum bitrate, the resolution, and the codec.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inputSpecification", value);
    }

    /**
     * The verbosity for logging activity for this channel.
     * <p>
     * Charges for logging (which are generated through Amazon CloudWatch Logging) are higher for higher verbosities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLogLevel() {
        return software.amazon.jsii.Kernel.get(this, "logLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The verbosity for logging activity for this channel.
     * <p>
     * Charges for logging (which are generated through Amazon CloudWatch Logging) are higher for higher verbosities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogLevel(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "logLevel", value);
    }

    /**
     * A name for this audio selector.
     * <p>
     * The AudioDescription (in an output) references this name in order to identify a specific input audio to include in that output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for this audio selector.
     * <p>
     * The AudioDescription (in an output) references this name in order to identify a specific input audio to include in that output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The IAM role for MediaLive to assume when running this channel.
     * <p>
     * The role is identified by its ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IAM role for MediaLive to assume when running this channel.
     * <p>
     * The role is identified by its ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", value);
    }

    /**
     * Settings to enable VPC mode in the channel, so that the endpoints for all outputs are in your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpc() {
        return software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Settings to enable VPC mode in the channel, so that the endpoints for all outputs are in your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpc(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.medialive.CfnChannel.VpcOutputSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpc", value);
    }

    /**
     * Settings to enable VPC mode in the channel, so that the endpoints for all outputs are in your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpc(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpc", value);
    }
    /**
     * The settings for an AAC audio encode in the output.
     * <p>
     * The parent of this entity is AudioCodecSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AacSettingsProperty aacSettingsProperty = AacSettingsProperty.builder()
     *         .bitrate(123)
     *         .codingMode("codingMode")
     *         .inputType("inputType")
     *         .profile("profile")
     *         .rateControlMode("rateControlMode")
     *         .rawFormat("rawFormat")
     *         .sampleRate(123)
     *         .spec("spec")
     *         .vbrQuality("vbrQuality")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AacSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AacSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AacSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The average bitrate in bits/second.
         * <p>
         * Valid values depend on the rate control mode and profile.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBitrate() {
            return null;
        }

        /**
         * Mono, stereo, or 5.1 channel layout. Valid values depend on the rate control mode and profile. The adReceiverMix setting receives a stereo description plus control track, and emits a mono AAC encode of the description track, with control data emitted in the PES header as per ETSI TS 101 154 Annex E.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCodingMode() {
            return null;
        }

        /**
         * Set to broadcasterMixedAd when the input contains pre-mixed main audio + AD (narration) as a stereo pair.
         * <p>
         * The Audio Type field (audioType) will be set to 3, which signals to downstream systems that this stream contains broadcaster mixed AD. Note that the input received by the encoder must contain pre-mixed audio; MediaLive does not perform the mixing. The values in audioTypeControl and audioType (in AudioDescription) are ignored when set to broadcasterMixedAd. Leave this set to normal when the input does not contain pre-mixed audio + AD.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputType() {
            return null;
        }

        /**
         * The AAC profile.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProfile() {
            return null;
        }

        /**
         * The rate control mode.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRateControlMode() {
            return null;
        }

        /**
         * Sets the LATM/LOAS AAC output for raw containers.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRawFormat() {
            return null;
        }

        /**
         * The sample rate in Hz.
         * <p>
         * Valid values depend on the rate control mode and profile.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSampleRate() {
            return null;
        }

        /**
         * Uses MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpec() {
            return null;
        }

        /**
         * The VBR quality level.
         * <p>
         * This is used only if rateControlMode is VBR.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVbrQuality() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AacSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AacSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AacSettingsProperty> {
            java.lang.Number bitrate;
            java.lang.String codingMode;
            java.lang.String inputType;
            java.lang.String profile;
            java.lang.String rateControlMode;
            java.lang.String rawFormat;
            java.lang.Number sampleRate;
            java.lang.String spec;
            java.lang.String vbrQuality;

            /**
             * Sets the value of {@link AacSettingsProperty#getBitrate}
             * @param bitrate The average bitrate in bits/second.
             *                Valid values depend on the rate control mode and profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitrate(java.lang.Number bitrate) {
                this.bitrate = bitrate;
                return this;
            }

            /**
             * Sets the value of {@link AacSettingsProperty#getCodingMode}
             * @param codingMode Mono, stereo, or 5.1 channel layout. Valid values depend on the rate control mode and profile. The adReceiverMix setting receives a stereo description plus control track, and emits a mono AAC encode of the description track, with control data emitted in the PES header as per ETSI TS 101 154 Annex E.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codingMode(java.lang.String codingMode) {
                this.codingMode = codingMode;
                return this;
            }

            /**
             * Sets the value of {@link AacSettingsProperty#getInputType}
             * @param inputType Set to broadcasterMixedAd when the input contains pre-mixed main audio + AD (narration) as a stereo pair.
             *                  The Audio Type field (audioType) will be set to 3, which signals to downstream systems that this stream contains broadcaster mixed AD. Note that the input received by the encoder must contain pre-mixed audio; MediaLive does not perform the mixing. The values in audioTypeControl and audioType (in AudioDescription) are ignored when set to broadcasterMixedAd. Leave this set to normal when the input does not contain pre-mixed audio + AD.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputType(java.lang.String inputType) {
                this.inputType = inputType;
                return this;
            }

            /**
             * Sets the value of {@link AacSettingsProperty#getProfile}
             * @param profile The AAC profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder profile(java.lang.String profile) {
                this.profile = profile;
                return this;
            }

            /**
             * Sets the value of {@link AacSettingsProperty#getRateControlMode}
             * @param rateControlMode The rate control mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rateControlMode(java.lang.String rateControlMode) {
                this.rateControlMode = rateControlMode;
                return this;
            }

            /**
             * Sets the value of {@link AacSettingsProperty#getRawFormat}
             * @param rawFormat Sets the LATM/LOAS AAC output for raw containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rawFormat(java.lang.String rawFormat) {
                this.rawFormat = rawFormat;
                return this;
            }

            /**
             * Sets the value of {@link AacSettingsProperty#getSampleRate}
             * @param sampleRate The sample rate in Hz.
             *                   Valid values depend on the rate control mode and profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleRate(java.lang.Number sampleRate) {
                this.sampleRate = sampleRate;
                return this;
            }

            /**
             * Sets the value of {@link AacSettingsProperty#getSpec}
             * @param spec Uses MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spec(java.lang.String spec) {
                this.spec = spec;
                return this;
            }

            /**
             * Sets the value of {@link AacSettingsProperty#getVbrQuality}
             * @param vbrQuality The VBR quality level.
             *                   This is used only if rateControlMode is VBR.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vbrQuality(java.lang.String vbrQuality) {
                this.vbrQuality = vbrQuality;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AacSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AacSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AacSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AacSettingsProperty {
            private final java.lang.Number bitrate;
            private final java.lang.String codingMode;
            private final java.lang.String inputType;
            private final java.lang.String profile;
            private final java.lang.String rateControlMode;
            private final java.lang.String rawFormat;
            private final java.lang.Number sampleRate;
            private final java.lang.String spec;
            private final java.lang.String vbrQuality;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bitrate = software.amazon.jsii.Kernel.get(this, "bitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.codingMode = software.amazon.jsii.Kernel.get(this, "codingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputType = software.amazon.jsii.Kernel.get(this, "inputType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.profile = software.amazon.jsii.Kernel.get(this, "profile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rateControlMode = software.amazon.jsii.Kernel.get(this, "rateControlMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rawFormat = software.amazon.jsii.Kernel.get(this, "rawFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sampleRate = software.amazon.jsii.Kernel.get(this, "sampleRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.spec = software.amazon.jsii.Kernel.get(this, "spec", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vbrQuality = software.amazon.jsii.Kernel.get(this, "vbrQuality", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bitrate = builder.bitrate;
                this.codingMode = builder.codingMode;
                this.inputType = builder.inputType;
                this.profile = builder.profile;
                this.rateControlMode = builder.rateControlMode;
                this.rawFormat = builder.rawFormat;
                this.sampleRate = builder.sampleRate;
                this.spec = builder.spec;
                this.vbrQuality = builder.vbrQuality;
            }

            @Override
            public final java.lang.Number getBitrate() {
                return this.bitrate;
            }

            @Override
            public final java.lang.String getCodingMode() {
                return this.codingMode;
            }

            @Override
            public final java.lang.String getInputType() {
                return this.inputType;
            }

            @Override
            public final java.lang.String getProfile() {
                return this.profile;
            }

            @Override
            public final java.lang.String getRateControlMode() {
                return this.rateControlMode;
            }

            @Override
            public final java.lang.String getRawFormat() {
                return this.rawFormat;
            }

            @Override
            public final java.lang.Number getSampleRate() {
                return this.sampleRate;
            }

            @Override
            public final java.lang.String getSpec() {
                return this.spec;
            }

            @Override
            public final java.lang.String getVbrQuality() {
                return this.vbrQuality;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBitrate() != null) {
                    data.set("bitrate", om.valueToTree(this.getBitrate()));
                }
                if (this.getCodingMode() != null) {
                    data.set("codingMode", om.valueToTree(this.getCodingMode()));
                }
                if (this.getInputType() != null) {
                    data.set("inputType", om.valueToTree(this.getInputType()));
                }
                if (this.getProfile() != null) {
                    data.set("profile", om.valueToTree(this.getProfile()));
                }
                if (this.getRateControlMode() != null) {
                    data.set("rateControlMode", om.valueToTree(this.getRateControlMode()));
                }
                if (this.getRawFormat() != null) {
                    data.set("rawFormat", om.valueToTree(this.getRawFormat()));
                }
                if (this.getSampleRate() != null) {
                    data.set("sampleRate", om.valueToTree(this.getSampleRate()));
                }
                if (this.getSpec() != null) {
                    data.set("spec", om.valueToTree(this.getSpec()));
                }
                if (this.getVbrQuality() != null) {
                    data.set("vbrQuality", om.valueToTree(this.getVbrQuality()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AacSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AacSettingsProperty.Jsii$Proxy that = (AacSettingsProperty.Jsii$Proxy) o;

                if (this.bitrate != null ? !this.bitrate.equals(that.bitrate) : that.bitrate != null) return false;
                if (this.codingMode != null ? !this.codingMode.equals(that.codingMode) : that.codingMode != null) return false;
                if (this.inputType != null ? !this.inputType.equals(that.inputType) : that.inputType != null) return false;
                if (this.profile != null ? !this.profile.equals(that.profile) : that.profile != null) return false;
                if (this.rateControlMode != null ? !this.rateControlMode.equals(that.rateControlMode) : that.rateControlMode != null) return false;
                if (this.rawFormat != null ? !this.rawFormat.equals(that.rawFormat) : that.rawFormat != null) return false;
                if (this.sampleRate != null ? !this.sampleRate.equals(that.sampleRate) : that.sampleRate != null) return false;
                if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) return false;
                return this.vbrQuality != null ? this.vbrQuality.equals(that.vbrQuality) : that.vbrQuality == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bitrate != null ? this.bitrate.hashCode() : 0;
                result = 31 * result + (this.codingMode != null ? this.codingMode.hashCode() : 0);
                result = 31 * result + (this.inputType != null ? this.inputType.hashCode() : 0);
                result = 31 * result + (this.profile != null ? this.profile.hashCode() : 0);
                result = 31 * result + (this.rateControlMode != null ? this.rateControlMode.hashCode() : 0);
                result = 31 * result + (this.rawFormat != null ? this.rawFormat.hashCode() : 0);
                result = 31 * result + (this.sampleRate != null ? this.sampleRate.hashCode() : 0);
                result = 31 * result + (this.spec != null ? this.spec.hashCode() : 0);
                result = 31 * result + (this.vbrQuality != null ? this.vbrQuality.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for an AC3 audio encode in the output.
     * <p>
     * The parent of this entity is AudioCodecSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * Ac3SettingsProperty ac3SettingsProperty = Ac3SettingsProperty.builder()
     *         .bitrate(123)
     *         .bitstreamMode("bitstreamMode")
     *         .codingMode("codingMode")
     *         .dialnorm(123)
     *         .drcProfile("drcProfile")
     *         .lfeFilter("lfeFilter")
     *         .metadataControl("metadataControl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.Ac3SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(Ac3SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Ac3SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The average bitrate in bits/second.
         * <p>
         * Valid bitrates depend on the coding mode.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBitrate() {
            return null;
        }

        /**
         * Specifies the bitstream mode (bsmod) for the emitted AC-3 stream.
         * <p>
         * For more information about these values, see ATSC A/52-2012.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBitstreamMode() {
            return null;
        }

        /**
         * The Dolby Digital coding mode.
         * <p>
         * This determines the number of channels.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCodingMode() {
            return null;
        }

        /**
         * Sets the dialnorm for the output.
         * <p>
         * If excluded and the input audio is Dolby Digital, dialnorm is passed through.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDialnorm() {
            return null;
        }

        /**
         * If set to filmStandard, adds dynamic range compression signaling to the output bitstream as defined in the Dolby Digital specification.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDrcProfile() {
            return null;
        }

        /**
         * When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
         * <p>
         * This is valid only in codingMode32Lfe mode.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLfeFilter() {
            return null;
        }

        /**
         * When set to followInput, encoder metadata is sourced from the DD, DD+, or DolbyE decoder that supplies this audio data.
         * <p>
         * If the audio is supplied from one of these streams, the static metadata settings are used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetadataControl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Ac3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Ac3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Ac3SettingsProperty> {
            java.lang.Number bitrate;
            java.lang.String bitstreamMode;
            java.lang.String codingMode;
            java.lang.Number dialnorm;
            java.lang.String drcProfile;
            java.lang.String lfeFilter;
            java.lang.String metadataControl;

            /**
             * Sets the value of {@link Ac3SettingsProperty#getBitrate}
             * @param bitrate The average bitrate in bits/second.
             *                Valid bitrates depend on the coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitrate(java.lang.Number bitrate) {
                this.bitrate = bitrate;
                return this;
            }

            /**
             * Sets the value of {@link Ac3SettingsProperty#getBitstreamMode}
             * @param bitstreamMode Specifies the bitstream mode (bsmod) for the emitted AC-3 stream.
             *                      For more information about these values, see ATSC A/52-2012.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitstreamMode(java.lang.String bitstreamMode) {
                this.bitstreamMode = bitstreamMode;
                return this;
            }

            /**
             * Sets the value of {@link Ac3SettingsProperty#getCodingMode}
             * @param codingMode The Dolby Digital coding mode.
             *                   This determines the number of channels.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codingMode(java.lang.String codingMode) {
                this.codingMode = codingMode;
                return this;
            }

            /**
             * Sets the value of {@link Ac3SettingsProperty#getDialnorm}
             * @param dialnorm Sets the dialnorm for the output.
             *                 If excluded and the input audio is Dolby Digital, dialnorm is passed through.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dialnorm(java.lang.Number dialnorm) {
                this.dialnorm = dialnorm;
                return this;
            }

            /**
             * Sets the value of {@link Ac3SettingsProperty#getDrcProfile}
             * @param drcProfile If set to filmStandard, adds dynamic range compression signaling to the output bitstream as defined in the Dolby Digital specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder drcProfile(java.lang.String drcProfile) {
                this.drcProfile = drcProfile;
                return this;
            }

            /**
             * Sets the value of {@link Ac3SettingsProperty#getLfeFilter}
             * @param lfeFilter When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
             *                  This is valid only in codingMode32Lfe mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lfeFilter(java.lang.String lfeFilter) {
                this.lfeFilter = lfeFilter;
                return this;
            }

            /**
             * Sets the value of {@link Ac3SettingsProperty#getMetadataControl}
             * @param metadataControl When set to followInput, encoder metadata is sourced from the DD, DD+, or DolbyE decoder that supplies this audio data.
             *                        If the audio is supplied from one of these streams, the static metadata settings are used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataControl(java.lang.String metadataControl) {
                this.metadataControl = metadataControl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Ac3SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Ac3SettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Ac3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Ac3SettingsProperty {
            private final java.lang.Number bitrate;
            private final java.lang.String bitstreamMode;
            private final java.lang.String codingMode;
            private final java.lang.Number dialnorm;
            private final java.lang.String drcProfile;
            private final java.lang.String lfeFilter;
            private final java.lang.String metadataControl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bitrate = software.amazon.jsii.Kernel.get(this, "bitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.bitstreamMode = software.amazon.jsii.Kernel.get(this, "bitstreamMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.codingMode = software.amazon.jsii.Kernel.get(this, "codingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dialnorm = software.amazon.jsii.Kernel.get(this, "dialnorm", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.drcProfile = software.amazon.jsii.Kernel.get(this, "drcProfile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lfeFilter = software.amazon.jsii.Kernel.get(this, "lfeFilter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metadataControl = software.amazon.jsii.Kernel.get(this, "metadataControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bitrate = builder.bitrate;
                this.bitstreamMode = builder.bitstreamMode;
                this.codingMode = builder.codingMode;
                this.dialnorm = builder.dialnorm;
                this.drcProfile = builder.drcProfile;
                this.lfeFilter = builder.lfeFilter;
                this.metadataControl = builder.metadataControl;
            }

            @Override
            public final java.lang.Number getBitrate() {
                return this.bitrate;
            }

            @Override
            public final java.lang.String getBitstreamMode() {
                return this.bitstreamMode;
            }

            @Override
            public final java.lang.String getCodingMode() {
                return this.codingMode;
            }

            @Override
            public final java.lang.Number getDialnorm() {
                return this.dialnorm;
            }

            @Override
            public final java.lang.String getDrcProfile() {
                return this.drcProfile;
            }

            @Override
            public final java.lang.String getLfeFilter() {
                return this.lfeFilter;
            }

            @Override
            public final java.lang.String getMetadataControl() {
                return this.metadataControl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBitrate() != null) {
                    data.set("bitrate", om.valueToTree(this.getBitrate()));
                }
                if (this.getBitstreamMode() != null) {
                    data.set("bitstreamMode", om.valueToTree(this.getBitstreamMode()));
                }
                if (this.getCodingMode() != null) {
                    data.set("codingMode", om.valueToTree(this.getCodingMode()));
                }
                if (this.getDialnorm() != null) {
                    data.set("dialnorm", om.valueToTree(this.getDialnorm()));
                }
                if (this.getDrcProfile() != null) {
                    data.set("drcProfile", om.valueToTree(this.getDrcProfile()));
                }
                if (this.getLfeFilter() != null) {
                    data.set("lfeFilter", om.valueToTree(this.getLfeFilter()));
                }
                if (this.getMetadataControl() != null) {
                    data.set("metadataControl", om.valueToTree(this.getMetadataControl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.Ac3SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Ac3SettingsProperty.Jsii$Proxy that = (Ac3SettingsProperty.Jsii$Proxy) o;

                if (this.bitrate != null ? !this.bitrate.equals(that.bitrate) : that.bitrate != null) return false;
                if (this.bitstreamMode != null ? !this.bitstreamMode.equals(that.bitstreamMode) : that.bitstreamMode != null) return false;
                if (this.codingMode != null ? !this.codingMode.equals(that.codingMode) : that.codingMode != null) return false;
                if (this.dialnorm != null ? !this.dialnorm.equals(that.dialnorm) : that.dialnorm != null) return false;
                if (this.drcProfile != null ? !this.drcProfile.equals(that.drcProfile) : that.drcProfile != null) return false;
                if (this.lfeFilter != null ? !this.lfeFilter.equals(that.lfeFilter) : that.lfeFilter != null) return false;
                return this.metadataControl != null ? this.metadataControl.equals(that.metadataControl) : that.metadataControl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bitrate != null ? this.bitrate.hashCode() : 0;
                result = 31 * result + (this.bitstreamMode != null ? this.bitstreamMode.hashCode() : 0);
                result = 31 * result + (this.codingMode != null ? this.codingMode.hashCode() : 0);
                result = 31 * result + (this.dialnorm != null ? this.dialnorm.hashCode() : 0);
                result = 31 * result + (this.drcProfile != null ? this.drcProfile.hashCode() : 0);
                result = 31 * result + (this.lfeFilter != null ? this.lfeFilter.hashCode() : 0);
                result = 31 * result + (this.metadataControl != null ? this.metadataControl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the ancillary captions to extract from the input.
     * <p>
     * The parent of this entity is CaptionSelectorSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AncillarySourceSettingsProperty ancillarySourceSettingsProperty = AncillarySourceSettingsProperty.builder()
     *         .sourceAncillaryChannelNumber(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AncillarySourceSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AncillarySourceSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AncillarySourceSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the number (1 to 4) of the captions channel you want to extract from the ancillary captions.
         * <p>
         * If you plan to convert the ancillary captions to another format, complete this field. If you plan to choose Embedded as the captions destination in the output (to pass through all the channels in the ancillary captions), leave this field blank because MediaLive ignores the field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSourceAncillaryChannelNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AncillarySourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AncillarySourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AncillarySourceSettingsProperty> {
            java.lang.Number sourceAncillaryChannelNumber;

            /**
             * Sets the value of {@link AncillarySourceSettingsProperty#getSourceAncillaryChannelNumber}
             * @param sourceAncillaryChannelNumber Specifies the number (1 to 4) of the captions channel you want to extract from the ancillary captions.
             *                                     If you plan to convert the ancillary captions to another format, complete this field. If you plan to choose Embedded as the captions destination in the output (to pass through all the channels in the ancillary captions), leave this field blank because MediaLive ignores the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceAncillaryChannelNumber(java.lang.Number sourceAncillaryChannelNumber) {
                this.sourceAncillaryChannelNumber = sourceAncillaryChannelNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AncillarySourceSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AncillarySourceSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AncillarySourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AncillarySourceSettingsProperty {
            private final java.lang.Number sourceAncillaryChannelNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceAncillaryChannelNumber = software.amazon.jsii.Kernel.get(this, "sourceAncillaryChannelNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceAncillaryChannelNumber = builder.sourceAncillaryChannelNumber;
            }

            @Override
            public final java.lang.Number getSourceAncillaryChannelNumber() {
                return this.sourceAncillaryChannelNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSourceAncillaryChannelNumber() != null) {
                    data.set("sourceAncillaryChannelNumber", om.valueToTree(this.getSourceAncillaryChannelNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AncillarySourceSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AncillarySourceSettingsProperty.Jsii$Proxy that = (AncillarySourceSettingsProperty.Jsii$Proxy) o;

                return this.sourceAncillaryChannelNumber != null ? this.sourceAncillaryChannelNumber.equals(that.sourceAncillaryChannelNumber) : that.sourceAncillaryChannelNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceAncillaryChannelNumber != null ? this.sourceAncillaryChannelNumber.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Settings to configure the destination of an Archive output.
     * <p>
     * The parent of this entity is ArchiveGroupSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * ArchiveCdnSettingsProperty archiveCdnSettingsProperty = ArchiveCdnSettingsProperty.builder()
     *         .archiveS3Settings(ArchiveS3SettingsProperty.builder()
     *                 .cannedAcl("cannedAcl")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.ArchiveCdnSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ArchiveCdnSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArchiveCdnSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Sets up Amazon S3 as the destination for this Archive output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getArchiveS3Settings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArchiveCdnSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArchiveCdnSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArchiveCdnSettingsProperty> {
            java.lang.Object archiveS3Settings;

            /**
             * Sets the value of {@link ArchiveCdnSettingsProperty#getArchiveS3Settings}
             * @param archiveS3Settings Sets up Amazon S3 as the destination for this Archive output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder archiveS3Settings(software.amazon.awscdk.services.medialive.CfnChannel.ArchiveS3SettingsProperty archiveS3Settings) {
                this.archiveS3Settings = archiveS3Settings;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveCdnSettingsProperty#getArchiveS3Settings}
             * @param archiveS3Settings Sets up Amazon S3 as the destination for this Archive output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder archiveS3Settings(software.amazon.awscdk.IResolvable archiveS3Settings) {
                this.archiveS3Settings = archiveS3Settings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArchiveCdnSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArchiveCdnSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArchiveCdnSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArchiveCdnSettingsProperty {
            private final java.lang.Object archiveS3Settings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.archiveS3Settings = software.amazon.jsii.Kernel.get(this, "archiveS3Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.archiveS3Settings = builder.archiveS3Settings;
            }

            @Override
            public final java.lang.Object getArchiveS3Settings() {
                return this.archiveS3Settings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArchiveS3Settings() != null) {
                    data.set("archiveS3Settings", om.valueToTree(this.getArchiveS3Settings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.ArchiveCdnSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArchiveCdnSettingsProperty.Jsii$Proxy that = (ArchiveCdnSettingsProperty.Jsii$Proxy) o;

                return this.archiveS3Settings != null ? this.archiveS3Settings.equals(that.archiveS3Settings) : that.archiveS3Settings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.archiveS3Settings != null ? this.archiveS3Settings.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The archive container settings.
     * <p>
     * The parent of this entity is ArchiveOutputSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * ArchiveContainerSettingsProperty archiveContainerSettingsProperty = ArchiveContainerSettingsProperty.builder()
     *         .m2TsSettings(M2tsSettingsProperty.builder()
     *                 .absentInputAudioBehavior("absentInputAudioBehavior")
     *                 .arib("arib")
     *                 .aribCaptionsPid("aribCaptionsPid")
     *                 .aribCaptionsPidControl("aribCaptionsPidControl")
     *                 .audioBufferModel("audioBufferModel")
     *                 .audioFramesPerPes(123)
     *                 .audioPids("audioPids")
     *                 .audioStreamType("audioStreamType")
     *                 .bitrate(123)
     *                 .bufferModel("bufferModel")
     *                 .ccDescriptor("ccDescriptor")
     *                 .dvbNitSettings(DvbNitSettingsProperty.builder()
     *                         .networkId(123)
     *                         .networkName("networkName")
     *                         .repInterval(123)
     *                         .build())
     *                 .dvbSdtSettings(DvbSdtSettingsProperty.builder()
     *                         .outputSdt("outputSdt")
     *                         .repInterval(123)
     *                         .serviceName("serviceName")
     *                         .serviceProviderName("serviceProviderName")
     *                         .build())
     *                 .dvbSubPids("dvbSubPids")
     *                 .dvbTdtSettings(DvbTdtSettingsProperty.builder()
     *                         .repInterval(123)
     *                         .build())
     *                 .dvbTeletextPid("dvbTeletextPid")
     *                 .ebif("ebif")
     *                 .ebpAudioInterval("ebpAudioInterval")
     *                 .ebpLookaheadMs(123)
     *                 .ebpPlacement("ebpPlacement")
     *                 .ecmPid("ecmPid")
     *                 .esRateInPes("esRateInPes")
     *                 .etvPlatformPid("etvPlatformPid")
     *                 .etvSignalPid("etvSignalPid")
     *                 .fragmentTime(123)
     *                 .klv("klv")
     *                 .klvDataPids("klvDataPids")
     *                 .nielsenId3Behavior("nielsenId3Behavior")
     *                 .nullPacketBitrate(123)
     *                 .patInterval(123)
     *                 .pcrControl("pcrControl")
     *                 .pcrPeriod(123)
     *                 .pcrPid("pcrPid")
     *                 .pmtInterval(123)
     *                 .pmtPid("pmtPid")
     *                 .programNum(123)
     *                 .rateMode("rateMode")
     *                 .scte27Pids("scte27Pids")
     *                 .scte35Control("scte35Control")
     *                 .scte35Pid("scte35Pid")
     *                 .segmentationMarkers("segmentationMarkers")
     *                 .segmentationStyle("segmentationStyle")
     *                 .segmentationTime(123)
     *                 .timedMetadataBehavior("timedMetadataBehavior")
     *                 .timedMetadataPid("timedMetadataPid")
     *                 .transportStreamId(123)
     *                 .videoPid("videoPid")
     *                 .build())
     *         .rawSettings(RawSettingsProperty.builder().build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.ArchiveContainerSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ArchiveContainerSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArchiveContainerSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The settings for the M2TS in the archive output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getM2TsSettings() {
            return null;
        }

        /**
         * The settings for Raw archive output type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRawSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArchiveContainerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArchiveContainerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArchiveContainerSettingsProperty> {
            java.lang.Object m2TsSettings;
            java.lang.Object rawSettings;

            /**
             * Sets the value of {@link ArchiveContainerSettingsProperty#getM2TsSettings}
             * @param m2TsSettings The settings for the M2TS in the archive output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder m2TsSettings(software.amazon.awscdk.services.medialive.CfnChannel.M2tsSettingsProperty m2TsSettings) {
                this.m2TsSettings = m2TsSettings;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveContainerSettingsProperty#getM2TsSettings}
             * @param m2TsSettings The settings for the M2TS in the archive output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder m2TsSettings(software.amazon.awscdk.IResolvable m2TsSettings) {
                this.m2TsSettings = m2TsSettings;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveContainerSettingsProperty#getRawSettings}
             * @param rawSettings The settings for Raw archive output type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rawSettings(software.amazon.awscdk.services.medialive.CfnChannel.RawSettingsProperty rawSettings) {
                this.rawSettings = rawSettings;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveContainerSettingsProperty#getRawSettings}
             * @param rawSettings The settings for Raw archive output type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rawSettings(software.amazon.awscdk.IResolvable rawSettings) {
                this.rawSettings = rawSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArchiveContainerSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArchiveContainerSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArchiveContainerSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArchiveContainerSettingsProperty {
            private final java.lang.Object m2TsSettings;
            private final java.lang.Object rawSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.m2TsSettings = software.amazon.jsii.Kernel.get(this, "m2TsSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rawSettings = software.amazon.jsii.Kernel.get(this, "rawSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.m2TsSettings = builder.m2TsSettings;
                this.rawSettings = builder.rawSettings;
            }

            @Override
            public final java.lang.Object getM2TsSettings() {
                return this.m2TsSettings;
            }

            @Override
            public final java.lang.Object getRawSettings() {
                return this.rawSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getM2TsSettings() != null) {
                    data.set("m2TsSettings", om.valueToTree(this.getM2TsSettings()));
                }
                if (this.getRawSettings() != null) {
                    data.set("rawSettings", om.valueToTree(this.getRawSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.ArchiveContainerSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArchiveContainerSettingsProperty.Jsii$Proxy that = (ArchiveContainerSettingsProperty.Jsii$Proxy) o;

                if (this.m2TsSettings != null ? !this.m2TsSettings.equals(that.m2TsSettings) : that.m2TsSettings != null) return false;
                return this.rawSettings != null ? this.rawSettings.equals(that.rawSettings) : that.rawSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.m2TsSettings != null ? this.m2TsSettings.hashCode() : 0;
                result = 31 * result + (this.rawSettings != null ? this.rawSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for an archive output group.
     * <p>
     * The parent of this entity is OutputGroupSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * ArchiveGroupSettingsProperty archiveGroupSettingsProperty = ArchiveGroupSettingsProperty.builder()
     *         .archiveCdnSettings(ArchiveCdnSettingsProperty.builder()
     *                 .archiveS3Settings(ArchiveS3SettingsProperty.builder()
     *                         .cannedAcl("cannedAcl")
     *                         .build())
     *                 .build())
     *         .destination(OutputLocationRefProperty.builder()
     *                 .destinationRefId("destinationRefId")
     *                 .build())
     *         .rolloverInterval(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.ArchiveGroupSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ArchiveGroupSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArchiveGroupSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings to configure the destination of an Archive output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getArchiveCdnSettings() {
            return null;
        }

        /**
         * A directory and base file name where archive files should be written.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestination() {
            return null;
        }

        /**
         * The number of seconds to write to an archive file before closing and starting a new one.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRolloverInterval() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArchiveGroupSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArchiveGroupSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArchiveGroupSettingsProperty> {
            java.lang.Object archiveCdnSettings;
            java.lang.Object destination;
            java.lang.Number rolloverInterval;

            /**
             * Sets the value of {@link ArchiveGroupSettingsProperty#getArchiveCdnSettings}
             * @param archiveCdnSettings Settings to configure the destination of an Archive output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder archiveCdnSettings(software.amazon.awscdk.services.medialive.CfnChannel.ArchiveCdnSettingsProperty archiveCdnSettings) {
                this.archiveCdnSettings = archiveCdnSettings;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveGroupSettingsProperty#getArchiveCdnSettings}
             * @param archiveCdnSettings Settings to configure the destination of an Archive output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder archiveCdnSettings(software.amazon.awscdk.IResolvable archiveCdnSettings) {
                this.archiveCdnSettings = archiveCdnSettings;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveGroupSettingsProperty#getDestination}
             * @param destination A directory and base file name where archive files should be written.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.medialive.CfnChannel.OutputLocationRefProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveGroupSettingsProperty#getDestination}
             * @param destination A directory and base file name where archive files should be written.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveGroupSettingsProperty#getRolloverInterval}
             * @param rolloverInterval The number of seconds to write to an archive file before closing and starting a new one.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rolloverInterval(java.lang.Number rolloverInterval) {
                this.rolloverInterval = rolloverInterval;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArchiveGroupSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArchiveGroupSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArchiveGroupSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArchiveGroupSettingsProperty {
            private final java.lang.Object archiveCdnSettings;
            private final java.lang.Object destination;
            private final java.lang.Number rolloverInterval;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.archiveCdnSettings = software.amazon.jsii.Kernel.get(this, "archiveCdnSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rolloverInterval = software.amazon.jsii.Kernel.get(this, "rolloverInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.archiveCdnSettings = builder.archiveCdnSettings;
                this.destination = builder.destination;
                this.rolloverInterval = builder.rolloverInterval;
            }

            @Override
            public final java.lang.Object getArchiveCdnSettings() {
                return this.archiveCdnSettings;
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.Number getRolloverInterval() {
                return this.rolloverInterval;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArchiveCdnSettings() != null) {
                    data.set("archiveCdnSettings", om.valueToTree(this.getArchiveCdnSettings()));
                }
                if (this.getDestination() != null) {
                    data.set("destination", om.valueToTree(this.getDestination()));
                }
                if (this.getRolloverInterval() != null) {
                    data.set("rolloverInterval", om.valueToTree(this.getRolloverInterval()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.ArchiveGroupSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArchiveGroupSettingsProperty.Jsii$Proxy that = (ArchiveGroupSettingsProperty.Jsii$Proxy) o;

                if (this.archiveCdnSettings != null ? !this.archiveCdnSettings.equals(that.archiveCdnSettings) : that.archiveCdnSettings != null) return false;
                if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) return false;
                return this.rolloverInterval != null ? this.rolloverInterval.equals(that.rolloverInterval) : that.rolloverInterval == null;
            }

            @Override
            public final int hashCode() {
                int result = this.archiveCdnSettings != null ? this.archiveCdnSettings.hashCode() : 0;
                result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
                result = 31 * result + (this.rolloverInterval != null ? this.rolloverInterval.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The archive output settings.
     * <p>
     * The parent of this entity is OutputSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * ArchiveOutputSettingsProperty archiveOutputSettingsProperty = ArchiveOutputSettingsProperty.builder()
     *         .containerSettings(ArchiveContainerSettingsProperty.builder()
     *                 .m2TsSettings(M2tsSettingsProperty.builder()
     *                         .absentInputAudioBehavior("absentInputAudioBehavior")
     *                         .arib("arib")
     *                         .aribCaptionsPid("aribCaptionsPid")
     *                         .aribCaptionsPidControl("aribCaptionsPidControl")
     *                         .audioBufferModel("audioBufferModel")
     *                         .audioFramesPerPes(123)
     *                         .audioPids("audioPids")
     *                         .audioStreamType("audioStreamType")
     *                         .bitrate(123)
     *                         .bufferModel("bufferModel")
     *                         .ccDescriptor("ccDescriptor")
     *                         .dvbNitSettings(DvbNitSettingsProperty.builder()
     *                                 .networkId(123)
     *                                 .networkName("networkName")
     *                                 .repInterval(123)
     *                                 .build())
     *                         .dvbSdtSettings(DvbSdtSettingsProperty.builder()
     *                                 .outputSdt("outputSdt")
     *                                 .repInterval(123)
     *                                 .serviceName("serviceName")
     *                                 .serviceProviderName("serviceProviderName")
     *                                 .build())
     *                         .dvbSubPids("dvbSubPids")
     *                         .dvbTdtSettings(DvbTdtSettingsProperty.builder()
     *                                 .repInterval(123)
     *                                 .build())
     *                         .dvbTeletextPid("dvbTeletextPid")
     *                         .ebif("ebif")
     *                         .ebpAudioInterval("ebpAudioInterval")
     *                         .ebpLookaheadMs(123)
     *                         .ebpPlacement("ebpPlacement")
     *                         .ecmPid("ecmPid")
     *                         .esRateInPes("esRateInPes")
     *                         .etvPlatformPid("etvPlatformPid")
     *                         .etvSignalPid("etvSignalPid")
     *                         .fragmentTime(123)
     *                         .klv("klv")
     *                         .klvDataPids("klvDataPids")
     *                         .nielsenId3Behavior("nielsenId3Behavior")
     *                         .nullPacketBitrate(123)
     *                         .patInterval(123)
     *                         .pcrControl("pcrControl")
     *                         .pcrPeriod(123)
     *                         .pcrPid("pcrPid")
     *                         .pmtInterval(123)
     *                         .pmtPid("pmtPid")
     *                         .programNum(123)
     *                         .rateMode("rateMode")
     *                         .scte27Pids("scte27Pids")
     *                         .scte35Control("scte35Control")
     *                         .scte35Pid("scte35Pid")
     *                         .segmentationMarkers("segmentationMarkers")
     *                         .segmentationStyle("segmentationStyle")
     *                         .segmentationTime(123)
     *                         .timedMetadataBehavior("timedMetadataBehavior")
     *                         .timedMetadataPid("timedMetadataPid")
     *                         .transportStreamId(123)
     *                         .videoPid("videoPid")
     *                         .build())
     *                 .rawSettings(RawSettingsProperty.builder().build())
     *                 .build())
     *         .extension("extension")
     *         .nameModifier("nameModifier")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.ArchiveOutputSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ArchiveOutputSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArchiveOutputSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The settings that are specific to the container type of the file.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainerSettings() {
            return null;
        }

        /**
         * The output file extension.
         * <p>
         * If excluded, this is auto-selected from the container type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExtension() {
            return null;
        }

        /**
         * A string that is concatenated to the end of the destination file name.
         * <p>
         * The string is required for multiple outputs of the same type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNameModifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArchiveOutputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArchiveOutputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArchiveOutputSettingsProperty> {
            java.lang.Object containerSettings;
            java.lang.String extension;
            java.lang.String nameModifier;

            /**
             * Sets the value of {@link ArchiveOutputSettingsProperty#getContainerSettings}
             * @param containerSettings The settings that are specific to the container type of the file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerSettings(software.amazon.awscdk.services.medialive.CfnChannel.ArchiveContainerSettingsProperty containerSettings) {
                this.containerSettings = containerSettings;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveOutputSettingsProperty#getContainerSettings}
             * @param containerSettings The settings that are specific to the container type of the file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerSettings(software.amazon.awscdk.IResolvable containerSettings) {
                this.containerSettings = containerSettings;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveOutputSettingsProperty#getExtension}
             * @param extension The output file extension.
             *                  If excluded, this is auto-selected from the container type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder extension(java.lang.String extension) {
                this.extension = extension;
                return this;
            }

            /**
             * Sets the value of {@link ArchiveOutputSettingsProperty#getNameModifier}
             * @param nameModifier A string that is concatenated to the end of the destination file name.
             *                     The string is required for multiple outputs of the same type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nameModifier(java.lang.String nameModifier) {
                this.nameModifier = nameModifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArchiveOutputSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArchiveOutputSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArchiveOutputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArchiveOutputSettingsProperty {
            private final java.lang.Object containerSettings;
            private final java.lang.String extension;
            private final java.lang.String nameModifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerSettings = software.amazon.jsii.Kernel.get(this, "containerSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.extension = software.amazon.jsii.Kernel.get(this, "extension", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nameModifier = software.amazon.jsii.Kernel.get(this, "nameModifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerSettings = builder.containerSettings;
                this.extension = builder.extension;
                this.nameModifier = builder.nameModifier;
            }

            @Override
            public final java.lang.Object getContainerSettings() {
                return this.containerSettings;
            }

            @Override
            public final java.lang.String getExtension() {
                return this.extension;
            }

            @Override
            public final java.lang.String getNameModifier() {
                return this.nameModifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerSettings() != null) {
                    data.set("containerSettings", om.valueToTree(this.getContainerSettings()));
                }
                if (this.getExtension() != null) {
                    data.set("extension", om.valueToTree(this.getExtension()));
                }
                if (this.getNameModifier() != null) {
                    data.set("nameModifier", om.valueToTree(this.getNameModifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.ArchiveOutputSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArchiveOutputSettingsProperty.Jsii$Proxy that = (ArchiveOutputSettingsProperty.Jsii$Proxy) o;

                if (this.containerSettings != null ? !this.containerSettings.equals(that.containerSettings) : that.containerSettings != null) return false;
                if (this.extension != null ? !this.extension.equals(that.extension) : that.extension != null) return false;
                return this.nameModifier != null ? this.nameModifier.equals(that.nameModifier) : that.nameModifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerSettings != null ? this.containerSettings.hashCode() : 0;
                result = 31 * result + (this.extension != null ? this.extension.hashCode() : 0);
                result = 31 * result + (this.nameModifier != null ? this.nameModifier.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Sets up Amazon S3 as the destination for this Archive output.
     * <p>
     * The parent of this entity is ArchiveCdnSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * ArchiveS3SettingsProperty archiveS3SettingsProperty = ArchiveS3SettingsProperty.builder()
     *         .cannedAcl("cannedAcl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.ArchiveS3SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ArchiveS3SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArchiveS3SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify the canned ACL to apply to each S3 request.
         * <p>
         * Defaults to none.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCannedAcl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArchiveS3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArchiveS3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArchiveS3SettingsProperty> {
            java.lang.String cannedAcl;

            /**
             * Sets the value of {@link ArchiveS3SettingsProperty#getCannedAcl}
             * @param cannedAcl Specify the canned ACL to apply to each S3 request.
             *                  Defaults to none.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cannedAcl(java.lang.String cannedAcl) {
                this.cannedAcl = cannedAcl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArchiveS3SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArchiveS3SettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArchiveS3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArchiveS3SettingsProperty {
            private final java.lang.String cannedAcl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cannedAcl = software.amazon.jsii.Kernel.get(this, "cannedAcl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cannedAcl = builder.cannedAcl;
            }

            @Override
            public final java.lang.String getCannedAcl() {
                return this.cannedAcl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCannedAcl() != null) {
                    data.set("cannedAcl", om.valueToTree(this.getCannedAcl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.ArchiveS3SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArchiveS3SettingsProperty.Jsii$Proxy that = (ArchiveS3SettingsProperty.Jsii$Proxy) o;

                return this.cannedAcl != null ? this.cannedAcl.equals(that.cannedAcl) : that.cannedAcl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cannedAcl != null ? this.cannedAcl.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration of ARIB captions in the output.
     * <p>
     * The parent of this entity is CaptionDestinationSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AribDestinationSettingsProperty aribDestinationSettingsProperty = AribDestinationSettingsProperty.builder().build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AribDestinationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AribDestinationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AribDestinationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link AribDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AribDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AribDestinationSettingsProperty> {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AribDestinationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AribDestinationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AribDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AribDestinationSettingsProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AribDestinationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }
        }
    }
    /**
     * Information about the ARIB captions to extract from the input.
     * <p>
     * The parent of this entity is CaptionSelectorSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AribSourceSettingsProperty aribSourceSettingsProperty = AribSourceSettingsProperty.builder().build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AribSourceSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AribSourceSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AribSourceSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link AribSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AribSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AribSourceSettingsProperty> {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AribSourceSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AribSourceSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AribSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AribSourceSettingsProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AribSourceSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }
        }
    }
    /**
     * The settings for remixing audio.
     * <p>
     * The parent of this entity is RemixSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioChannelMappingProperty audioChannelMappingProperty = AudioChannelMappingProperty.builder()
     *         .inputChannelLevels(List.of(InputChannelLevelProperty.builder()
     *                 .gain(123)
     *                 .inputChannel(123)
     *                 .build()))
     *         .outputChannel(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioChannelMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioChannelMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioChannelMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The indices and gain values for each input channel that should be remixed into this output channel.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputChannelLevels() {
            return null;
        }

        /**
         * The index of the output channel that is being produced.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOutputChannel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioChannelMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioChannelMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioChannelMappingProperty> {
            java.lang.Object inputChannelLevels;
            java.lang.Number outputChannel;

            /**
             * Sets the value of {@link AudioChannelMappingProperty#getInputChannelLevels}
             * @param inputChannelLevels The indices and gain values for each input channel that should be remixed into this output channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputChannelLevels(software.amazon.awscdk.IResolvable inputChannelLevels) {
                this.inputChannelLevels = inputChannelLevels;
                return this;
            }

            /**
             * Sets the value of {@link AudioChannelMappingProperty#getInputChannelLevels}
             * @param inputChannelLevels The indices and gain values for each input channel that should be remixed into this output channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputChannelLevels(java.util.List<? extends java.lang.Object> inputChannelLevels) {
                this.inputChannelLevels = inputChannelLevels;
                return this;
            }

            /**
             * Sets the value of {@link AudioChannelMappingProperty#getOutputChannel}
             * @param outputChannel The index of the output channel that is being produced.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputChannel(java.lang.Number outputChannel) {
                this.outputChannel = outputChannel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioChannelMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioChannelMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioChannelMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioChannelMappingProperty {
            private final java.lang.Object inputChannelLevels;
            private final java.lang.Number outputChannel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputChannelLevels = software.amazon.jsii.Kernel.get(this, "inputChannelLevels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputChannel = software.amazon.jsii.Kernel.get(this, "outputChannel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputChannelLevels = builder.inputChannelLevels;
                this.outputChannel = builder.outputChannel;
            }

            @Override
            public final java.lang.Object getInputChannelLevels() {
                return this.inputChannelLevels;
            }

            @Override
            public final java.lang.Number getOutputChannel() {
                return this.outputChannel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInputChannelLevels() != null) {
                    data.set("inputChannelLevels", om.valueToTree(this.getInputChannelLevels()));
                }
                if (this.getOutputChannel() != null) {
                    data.set("outputChannel", om.valueToTree(this.getOutputChannel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioChannelMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioChannelMappingProperty.Jsii$Proxy that = (AudioChannelMappingProperty.Jsii$Proxy) o;

                if (this.inputChannelLevels != null ? !this.inputChannelLevels.equals(that.inputChannelLevels) : that.inputChannelLevels != null) return false;
                return this.outputChannel != null ? this.outputChannel.equals(that.outputChannel) : that.outputChannel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputChannelLevels != null ? this.inputChannelLevels.hashCode() : 0;
                result = 31 * result + (this.outputChannel != null ? this.outputChannel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of the audio codec in the audio output.
     * <p>
     * The parent of this entity is AudioDescription.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioCodecSettingsProperty audioCodecSettingsProperty = AudioCodecSettingsProperty.builder()
     *         .aacSettings(AacSettingsProperty.builder()
     *                 .bitrate(123)
     *                 .codingMode("codingMode")
     *                 .inputType("inputType")
     *                 .profile("profile")
     *                 .rateControlMode("rateControlMode")
     *                 .rawFormat("rawFormat")
     *                 .sampleRate(123)
     *                 .spec("spec")
     *                 .vbrQuality("vbrQuality")
     *                 .build())
     *         .ac3Settings(Ac3SettingsProperty.builder()
     *                 .bitrate(123)
     *                 .bitstreamMode("bitstreamMode")
     *                 .codingMode("codingMode")
     *                 .dialnorm(123)
     *                 .drcProfile("drcProfile")
     *                 .lfeFilter("lfeFilter")
     *                 .metadataControl("metadataControl")
     *                 .build())
     *         .eac3Settings(Eac3SettingsProperty.builder()
     *                 .attenuationControl("attenuationControl")
     *                 .bitrate(123)
     *                 .bitstreamMode("bitstreamMode")
     *                 .codingMode("codingMode")
     *                 .dcFilter("dcFilter")
     *                 .dialnorm(123)
     *                 .drcLine("drcLine")
     *                 .drcRf("drcRf")
     *                 .lfeControl("lfeControl")
     *                 .lfeFilter("lfeFilter")
     *                 .loRoCenterMixLevel(123)
     *                 .loRoSurroundMixLevel(123)
     *                 .ltRtCenterMixLevel(123)
     *                 .ltRtSurroundMixLevel(123)
     *                 .metadataControl("metadataControl")
     *                 .passthroughControl("passthroughControl")
     *                 .phaseControl("phaseControl")
     *                 .stereoDownmix("stereoDownmix")
     *                 .surroundExMode("surroundExMode")
     *                 .surroundMode("surroundMode")
     *                 .build())
     *         .mp2Settings(Mp2SettingsProperty.builder()
     *                 .bitrate(123)
     *                 .codingMode("codingMode")
     *                 .sampleRate(123)
     *                 .build())
     *         .passThroughSettings(PassThroughSettingsProperty.builder().build())
     *         .wavSettings(WavSettingsProperty.builder()
     *                 .bitDepth(123)
     *                 .codingMode("codingMode")
     *                 .sampleRate(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioCodecSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioCodecSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioCodecSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The setup of the AAC audio codec in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAacSettings() {
            return null;
        }

        /**
         * The setup of an AC3 audio codec in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAc3Settings() {
            return null;
        }

        /**
         * The setup of an EAC3 audio codec in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEac3Settings() {
            return null;
        }

        /**
         * The setup of an MP2 audio codec in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMp2Settings() {
            return null;
        }

        /**
         * The setup to pass through the Dolby audio codec to the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPassThroughSettings() {
            return null;
        }

        /**
         * Settings for audio encoded with the WAV codec.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWavSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioCodecSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioCodecSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioCodecSettingsProperty> {
            java.lang.Object aacSettings;
            java.lang.Object ac3Settings;
            java.lang.Object eac3Settings;
            java.lang.Object mp2Settings;
            java.lang.Object passThroughSettings;
            java.lang.Object wavSettings;

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getAacSettings}
             * @param aacSettings The setup of the AAC audio codec in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aacSettings(software.amazon.awscdk.services.medialive.CfnChannel.AacSettingsProperty aacSettings) {
                this.aacSettings = aacSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getAacSettings}
             * @param aacSettings The setup of the AAC audio codec in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aacSettings(software.amazon.awscdk.IResolvable aacSettings) {
                this.aacSettings = aacSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getAc3Settings}
             * @param ac3Settings The setup of an AC3 audio codec in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ac3Settings(software.amazon.awscdk.services.medialive.CfnChannel.Ac3SettingsProperty ac3Settings) {
                this.ac3Settings = ac3Settings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getAc3Settings}
             * @param ac3Settings The setup of an AC3 audio codec in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ac3Settings(software.amazon.awscdk.IResolvable ac3Settings) {
                this.ac3Settings = ac3Settings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getEac3Settings}
             * @param eac3Settings The setup of an EAC3 audio codec in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eac3Settings(software.amazon.awscdk.services.medialive.CfnChannel.Eac3SettingsProperty eac3Settings) {
                this.eac3Settings = eac3Settings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getEac3Settings}
             * @param eac3Settings The setup of an EAC3 audio codec in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eac3Settings(software.amazon.awscdk.IResolvable eac3Settings) {
                this.eac3Settings = eac3Settings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getMp2Settings}
             * @param mp2Settings The setup of an MP2 audio codec in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mp2Settings(software.amazon.awscdk.services.medialive.CfnChannel.Mp2SettingsProperty mp2Settings) {
                this.mp2Settings = mp2Settings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getMp2Settings}
             * @param mp2Settings The setup of an MP2 audio codec in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mp2Settings(software.amazon.awscdk.IResolvable mp2Settings) {
                this.mp2Settings = mp2Settings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getPassThroughSettings}
             * @param passThroughSettings The setup to pass through the Dolby audio codec to the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passThroughSettings(software.amazon.awscdk.services.medialive.CfnChannel.PassThroughSettingsProperty passThroughSettings) {
                this.passThroughSettings = passThroughSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getPassThroughSettings}
             * @param passThroughSettings The setup to pass through the Dolby audio codec to the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passThroughSettings(software.amazon.awscdk.IResolvable passThroughSettings) {
                this.passThroughSettings = passThroughSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getWavSettings}
             * @param wavSettings Settings for audio encoded with the WAV codec.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder wavSettings(software.amazon.awscdk.services.medialive.CfnChannel.WavSettingsProperty wavSettings) {
                this.wavSettings = wavSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioCodecSettingsProperty#getWavSettings}
             * @param wavSettings Settings for audio encoded with the WAV codec.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder wavSettings(software.amazon.awscdk.IResolvable wavSettings) {
                this.wavSettings = wavSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioCodecSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioCodecSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioCodecSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioCodecSettingsProperty {
            private final java.lang.Object aacSettings;
            private final java.lang.Object ac3Settings;
            private final java.lang.Object eac3Settings;
            private final java.lang.Object mp2Settings;
            private final java.lang.Object passThroughSettings;
            private final java.lang.Object wavSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aacSettings = software.amazon.jsii.Kernel.get(this, "aacSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ac3Settings = software.amazon.jsii.Kernel.get(this, "ac3Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eac3Settings = software.amazon.jsii.Kernel.get(this, "eac3Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mp2Settings = software.amazon.jsii.Kernel.get(this, "mp2Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.passThroughSettings = software.amazon.jsii.Kernel.get(this, "passThroughSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.wavSettings = software.amazon.jsii.Kernel.get(this, "wavSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aacSettings = builder.aacSettings;
                this.ac3Settings = builder.ac3Settings;
                this.eac3Settings = builder.eac3Settings;
                this.mp2Settings = builder.mp2Settings;
                this.passThroughSettings = builder.passThroughSettings;
                this.wavSettings = builder.wavSettings;
            }

            @Override
            public final java.lang.Object getAacSettings() {
                return this.aacSettings;
            }

            @Override
            public final java.lang.Object getAc3Settings() {
                return this.ac3Settings;
            }

            @Override
            public final java.lang.Object getEac3Settings() {
                return this.eac3Settings;
            }

            @Override
            public final java.lang.Object getMp2Settings() {
                return this.mp2Settings;
            }

            @Override
            public final java.lang.Object getPassThroughSettings() {
                return this.passThroughSettings;
            }

            @Override
            public final java.lang.Object getWavSettings() {
                return this.wavSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAacSettings() != null) {
                    data.set("aacSettings", om.valueToTree(this.getAacSettings()));
                }
                if (this.getAc3Settings() != null) {
                    data.set("ac3Settings", om.valueToTree(this.getAc3Settings()));
                }
                if (this.getEac3Settings() != null) {
                    data.set("eac3Settings", om.valueToTree(this.getEac3Settings()));
                }
                if (this.getMp2Settings() != null) {
                    data.set("mp2Settings", om.valueToTree(this.getMp2Settings()));
                }
                if (this.getPassThroughSettings() != null) {
                    data.set("passThroughSettings", om.valueToTree(this.getPassThroughSettings()));
                }
                if (this.getWavSettings() != null) {
                    data.set("wavSettings", om.valueToTree(this.getWavSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioCodecSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioCodecSettingsProperty.Jsii$Proxy that = (AudioCodecSettingsProperty.Jsii$Proxy) o;

                if (this.aacSettings != null ? !this.aacSettings.equals(that.aacSettings) : that.aacSettings != null) return false;
                if (this.ac3Settings != null ? !this.ac3Settings.equals(that.ac3Settings) : that.ac3Settings != null) return false;
                if (this.eac3Settings != null ? !this.eac3Settings.equals(that.eac3Settings) : that.eac3Settings != null) return false;
                if (this.mp2Settings != null ? !this.mp2Settings.equals(that.mp2Settings) : that.mp2Settings != null) return false;
                if (this.passThroughSettings != null ? !this.passThroughSettings.equals(that.passThroughSettings) : that.passThroughSettings != null) return false;
                return this.wavSettings != null ? this.wavSettings.equals(that.wavSettings) : that.wavSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aacSettings != null ? this.aacSettings.hashCode() : 0;
                result = 31 * result + (this.ac3Settings != null ? this.ac3Settings.hashCode() : 0);
                result = 31 * result + (this.eac3Settings != null ? this.eac3Settings.hashCode() : 0);
                result = 31 * result + (this.mp2Settings != null ? this.mp2Settings.hashCode() : 0);
                result = 31 * result + (this.passThroughSettings != null ? this.passThroughSettings.hashCode() : 0);
                result = 31 * result + (this.wavSettings != null ? this.wavSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The encoding information for one output audio.
     * <p>
     * The parent of this entity is EncoderSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioDescriptionProperty audioDescriptionProperty = AudioDescriptionProperty.builder()
     *         .audioNormalizationSettings(AudioNormalizationSettingsProperty.builder()
     *                 .algorithm("algorithm")
     *                 .algorithmControl("algorithmControl")
     *                 .targetLkfs(123)
     *                 .build())
     *         .audioSelectorName("audioSelectorName")
     *         .audioType("audioType")
     *         .audioTypeControl("audioTypeControl")
     *         .audioWatermarkingSettings(AudioWatermarkSettingsProperty.builder()
     *                 .nielsenWatermarksSettings(NielsenWatermarksSettingsProperty.builder()
     *                         .nielsenCbetSettings(NielsenCBETProperty.builder()
     *                                 .cbetCheckDigitString("cbetCheckDigitString")
     *                                 .cbetStepaside("cbetStepaside")
     *                                 .csid("csid")
     *                                 .build())
     *                         .nielsenDistributionType("nielsenDistributionType")
     *                         .nielsenNaesIiNwSettings(NielsenNaesIiNwProperty.builder()
     *                                 .checkDigitString("checkDigitString")
     *                                 .sid(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .codecSettings(AudioCodecSettingsProperty.builder()
     *                 .aacSettings(AacSettingsProperty.builder()
     *                         .bitrate(123)
     *                         .codingMode("codingMode")
     *                         .inputType("inputType")
     *                         .profile("profile")
     *                         .rateControlMode("rateControlMode")
     *                         .rawFormat("rawFormat")
     *                         .sampleRate(123)
     *                         .spec("spec")
     *                         .vbrQuality("vbrQuality")
     *                         .build())
     *                 .ac3Settings(Ac3SettingsProperty.builder()
     *                         .bitrate(123)
     *                         .bitstreamMode("bitstreamMode")
     *                         .codingMode("codingMode")
     *                         .dialnorm(123)
     *                         .drcProfile("drcProfile")
     *                         .lfeFilter("lfeFilter")
     *                         .metadataControl("metadataControl")
     *                         .build())
     *                 .eac3Settings(Eac3SettingsProperty.builder()
     *                         .attenuationControl("attenuationControl")
     *                         .bitrate(123)
     *                         .bitstreamMode("bitstreamMode")
     *                         .codingMode("codingMode")
     *                         .dcFilter("dcFilter")
     *                         .dialnorm(123)
     *                         .drcLine("drcLine")
     *                         .drcRf("drcRf")
     *                         .lfeControl("lfeControl")
     *                         .lfeFilter("lfeFilter")
     *                         .loRoCenterMixLevel(123)
     *                         .loRoSurroundMixLevel(123)
     *                         .ltRtCenterMixLevel(123)
     *                         .ltRtSurroundMixLevel(123)
     *                         .metadataControl("metadataControl")
     *                         .passthroughControl("passthroughControl")
     *                         .phaseControl("phaseControl")
     *                         .stereoDownmix("stereoDownmix")
     *                         .surroundExMode("surroundExMode")
     *                         .surroundMode("surroundMode")
     *                         .build())
     *                 .mp2Settings(Mp2SettingsProperty.builder()
     *                         .bitrate(123)
     *                         .codingMode("codingMode")
     *                         .sampleRate(123)
     *                         .build())
     *                 .passThroughSettings(PassThroughSettingsProperty.builder().build())
     *                 .wavSettings(WavSettingsProperty.builder()
     *                         .bitDepth(123)
     *                         .codingMode("codingMode")
     *                         .sampleRate(123)
     *                         .build())
     *                 .build())
     *         .languageCode("languageCode")
     *         .languageCodeControl("languageCodeControl")
     *         .name("name")
     *         .remixSettings(RemixSettingsProperty.builder()
     *                 .channelMappings(List.of(AudioChannelMappingProperty.builder()
     *                         .inputChannelLevels(List.of(InputChannelLevelProperty.builder()
     *                                 .gain(123)
     *                                 .inputChannel(123)
     *                                 .build()))
     *                         .outputChannel(123)
     *                         .build()))
     *                 .channelsIn(123)
     *                 .channelsOut(123)
     *                 .build())
     *         .streamName("streamName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioDescriptionProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioDescriptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioDescriptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The advanced audio normalization settings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioNormalizationSettings() {
            return null;
        }

        /**
         * The name of the AudioSelector that is used as the source for this AudioDescription.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAudioSelectorName() {
            return null;
        }

        /**
         * Applies only if audioTypeControl is useConfigured.
         * <p>
         * The values for audioType are defined in ISO-IEC 13818-1.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAudioType() {
            return null;
        }

        /**
         * Determines how audio type is determined.
         * <p>
         * followInput: If the input contains an ISO 639 audioType, then that value is passed through to the output. If the input contains no ISO 639 audioType, the value in Audio Type is included in the output. useConfigured: The value in Audio Type is included in the output. Note that this field and audioType are both ignored if inputType is broadcasterMixedAd.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAudioTypeControl() {
            return null;
        }

        /**
         * Settings to configure one or more solutions that insert audio watermarks in the audio encode.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioWatermarkingSettings() {
            return null;
        }

        /**
         * The audio codec settings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodecSettings() {
            return null;
        }

        /**
         * Indicates the language of the audio output track.
         * <p>
         * Used only if languageControlMode is useConfigured, or there is no ISO 639 language code specified in the input.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageCode() {
            return null;
        }

        /**
         * Choosing followInput causes the ISO 639 language code of the output to follow the ISO 639 language code of the input.
         * <p>
         * The languageCode setting is used when useConfigured is set, or when followInput is selected but there is no ISO 639 language code specified by the input.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageCodeControl() {
            return null;
        }

        /**
         * The name of this AudioDescription.
         * <p>
         * Outputs use this name to uniquely identify this AudioDescription. Description names should be unique within this channel.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The settings that control how input audio channels are remixed into the output audio channels.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRemixSettings() {
            return null;
        }

        /**
         * Used for Microsoft Smooth and Apple HLS outputs.
         * <p>
         * Indicates the name displayed by the player (for example, English or Director Commentary).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStreamName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioDescriptionProperty> {
            java.lang.Object audioNormalizationSettings;
            java.lang.String audioSelectorName;
            java.lang.String audioType;
            java.lang.String audioTypeControl;
            java.lang.Object audioWatermarkingSettings;
            java.lang.Object codecSettings;
            java.lang.String languageCode;
            java.lang.String languageCodeControl;
            java.lang.String name;
            java.lang.Object remixSettings;
            java.lang.String streamName;

            /**
             * Sets the value of {@link AudioDescriptionProperty#getAudioNormalizationSettings}
             * @param audioNormalizationSettings The advanced audio normalization settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioNormalizationSettings(software.amazon.awscdk.services.medialive.CfnChannel.AudioNormalizationSettingsProperty audioNormalizationSettings) {
                this.audioNormalizationSettings = audioNormalizationSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getAudioNormalizationSettings}
             * @param audioNormalizationSettings The advanced audio normalization settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioNormalizationSettings(software.amazon.awscdk.IResolvable audioNormalizationSettings) {
                this.audioNormalizationSettings = audioNormalizationSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getAudioSelectorName}
             * @param audioSelectorName The name of the AudioSelector that is used as the source for this AudioDescription.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioSelectorName(java.lang.String audioSelectorName) {
                this.audioSelectorName = audioSelectorName;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getAudioType}
             * @param audioType Applies only if audioTypeControl is useConfigured.
             *                  The values for audioType are defined in ISO-IEC 13818-1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioType(java.lang.String audioType) {
                this.audioType = audioType;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getAudioTypeControl}
             * @param audioTypeControl Determines how audio type is determined.
             *                         followInput: If the input contains an ISO 639 audioType, then that value is passed through to the output. If the input contains no ISO 639 audioType, the value in Audio Type is included in the output. useConfigured: The value in Audio Type is included in the output. Note that this field and audioType are both ignored if inputType is broadcasterMixedAd.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioTypeControl(java.lang.String audioTypeControl) {
                this.audioTypeControl = audioTypeControl;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getAudioWatermarkingSettings}
             * @param audioWatermarkingSettings Settings to configure one or more solutions that insert audio watermarks in the audio encode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioWatermarkingSettings(software.amazon.awscdk.services.medialive.CfnChannel.AudioWatermarkSettingsProperty audioWatermarkingSettings) {
                this.audioWatermarkingSettings = audioWatermarkingSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getAudioWatermarkingSettings}
             * @param audioWatermarkingSettings Settings to configure one or more solutions that insert audio watermarks in the audio encode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioWatermarkingSettings(software.amazon.awscdk.IResolvable audioWatermarkingSettings) {
                this.audioWatermarkingSettings = audioWatermarkingSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getCodecSettings}
             * @param codecSettings The audio codec settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codecSettings(software.amazon.awscdk.services.medialive.CfnChannel.AudioCodecSettingsProperty codecSettings) {
                this.codecSettings = codecSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getCodecSettings}
             * @param codecSettings The audio codec settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codecSettings(software.amazon.awscdk.IResolvable codecSettings) {
                this.codecSettings = codecSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getLanguageCode}
             * @param languageCode Indicates the language of the audio output track.
             *                     Used only if languageControlMode is useConfigured, or there is no ISO 639 language code specified in the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageCode(java.lang.String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getLanguageCodeControl}
             * @param languageCodeControl Choosing followInput causes the ISO 639 language code of the output to follow the ISO 639 language code of the input.
             *                            The languageCode setting is used when useConfigured is set, or when followInput is selected but there is no ISO 639 language code specified by the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageCodeControl(java.lang.String languageCodeControl) {
                this.languageCodeControl = languageCodeControl;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getName}
             * @param name The name of this AudioDescription.
             *             Outputs use this name to uniquely identify this AudioDescription. Description names should be unique within this channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getRemixSettings}
             * @param remixSettings The settings that control how input audio channels are remixed into the output audio channels.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder remixSettings(software.amazon.awscdk.services.medialive.CfnChannel.RemixSettingsProperty remixSettings) {
                this.remixSettings = remixSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getRemixSettings}
             * @param remixSettings The settings that control how input audio channels are remixed into the output audio channels.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder remixSettings(software.amazon.awscdk.IResolvable remixSettings) {
                this.remixSettings = remixSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioDescriptionProperty#getStreamName}
             * @param streamName Used for Microsoft Smooth and Apple HLS outputs.
             *                   Indicates the name displayed by the player (for example, English or Director Commentary).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamName(java.lang.String streamName) {
                this.streamName = streamName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioDescriptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioDescriptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioDescriptionProperty {
            private final java.lang.Object audioNormalizationSettings;
            private final java.lang.String audioSelectorName;
            private final java.lang.String audioType;
            private final java.lang.String audioTypeControl;
            private final java.lang.Object audioWatermarkingSettings;
            private final java.lang.Object codecSettings;
            private final java.lang.String languageCode;
            private final java.lang.String languageCodeControl;
            private final java.lang.String name;
            private final java.lang.Object remixSettings;
            private final java.lang.String streamName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioNormalizationSettings = software.amazon.jsii.Kernel.get(this, "audioNormalizationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.audioSelectorName = software.amazon.jsii.Kernel.get(this, "audioSelectorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.audioType = software.amazon.jsii.Kernel.get(this, "audioType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.audioTypeControl = software.amazon.jsii.Kernel.get(this, "audioTypeControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.audioWatermarkingSettings = software.amazon.jsii.Kernel.get(this, "audioWatermarkingSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.codecSettings = software.amazon.jsii.Kernel.get(this, "codecSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.languageCode = software.amazon.jsii.Kernel.get(this, "languageCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.languageCodeControl = software.amazon.jsii.Kernel.get(this, "languageCodeControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.remixSettings = software.amazon.jsii.Kernel.get(this, "remixSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.streamName = software.amazon.jsii.Kernel.get(this, "streamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioNormalizationSettings = builder.audioNormalizationSettings;
                this.audioSelectorName = builder.audioSelectorName;
                this.audioType = builder.audioType;
                this.audioTypeControl = builder.audioTypeControl;
                this.audioWatermarkingSettings = builder.audioWatermarkingSettings;
                this.codecSettings = builder.codecSettings;
                this.languageCode = builder.languageCode;
                this.languageCodeControl = builder.languageCodeControl;
                this.name = builder.name;
                this.remixSettings = builder.remixSettings;
                this.streamName = builder.streamName;
            }

            @Override
            public final java.lang.Object getAudioNormalizationSettings() {
                return this.audioNormalizationSettings;
            }

            @Override
            public final java.lang.String getAudioSelectorName() {
                return this.audioSelectorName;
            }

            @Override
            public final java.lang.String getAudioType() {
                return this.audioType;
            }

            @Override
            public final java.lang.String getAudioTypeControl() {
                return this.audioTypeControl;
            }

            @Override
            public final java.lang.Object getAudioWatermarkingSettings() {
                return this.audioWatermarkingSettings;
            }

            @Override
            public final java.lang.Object getCodecSettings() {
                return this.codecSettings;
            }

            @Override
            public final java.lang.String getLanguageCode() {
                return this.languageCode;
            }

            @Override
            public final java.lang.String getLanguageCodeControl() {
                return this.languageCodeControl;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getRemixSettings() {
                return this.remixSettings;
            }

            @Override
            public final java.lang.String getStreamName() {
                return this.streamName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioNormalizationSettings() != null) {
                    data.set("audioNormalizationSettings", om.valueToTree(this.getAudioNormalizationSettings()));
                }
                if (this.getAudioSelectorName() != null) {
                    data.set("audioSelectorName", om.valueToTree(this.getAudioSelectorName()));
                }
                if (this.getAudioType() != null) {
                    data.set("audioType", om.valueToTree(this.getAudioType()));
                }
                if (this.getAudioTypeControl() != null) {
                    data.set("audioTypeControl", om.valueToTree(this.getAudioTypeControl()));
                }
                if (this.getAudioWatermarkingSettings() != null) {
                    data.set("audioWatermarkingSettings", om.valueToTree(this.getAudioWatermarkingSettings()));
                }
                if (this.getCodecSettings() != null) {
                    data.set("codecSettings", om.valueToTree(this.getCodecSettings()));
                }
                if (this.getLanguageCode() != null) {
                    data.set("languageCode", om.valueToTree(this.getLanguageCode()));
                }
                if (this.getLanguageCodeControl() != null) {
                    data.set("languageCodeControl", om.valueToTree(this.getLanguageCodeControl()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getRemixSettings() != null) {
                    data.set("remixSettings", om.valueToTree(this.getRemixSettings()));
                }
                if (this.getStreamName() != null) {
                    data.set("streamName", om.valueToTree(this.getStreamName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioDescriptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioDescriptionProperty.Jsii$Proxy that = (AudioDescriptionProperty.Jsii$Proxy) o;

                if (this.audioNormalizationSettings != null ? !this.audioNormalizationSettings.equals(that.audioNormalizationSettings) : that.audioNormalizationSettings != null) return false;
                if (this.audioSelectorName != null ? !this.audioSelectorName.equals(that.audioSelectorName) : that.audioSelectorName != null) return false;
                if (this.audioType != null ? !this.audioType.equals(that.audioType) : that.audioType != null) return false;
                if (this.audioTypeControl != null ? !this.audioTypeControl.equals(that.audioTypeControl) : that.audioTypeControl != null) return false;
                if (this.audioWatermarkingSettings != null ? !this.audioWatermarkingSettings.equals(that.audioWatermarkingSettings) : that.audioWatermarkingSettings != null) return false;
                if (this.codecSettings != null ? !this.codecSettings.equals(that.codecSettings) : that.codecSettings != null) return false;
                if (this.languageCode != null ? !this.languageCode.equals(that.languageCode) : that.languageCode != null) return false;
                if (this.languageCodeControl != null ? !this.languageCodeControl.equals(that.languageCodeControl) : that.languageCodeControl != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.remixSettings != null ? !this.remixSettings.equals(that.remixSettings) : that.remixSettings != null) return false;
                return this.streamName != null ? this.streamName.equals(that.streamName) : that.streamName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioNormalizationSettings != null ? this.audioNormalizationSettings.hashCode() : 0;
                result = 31 * result + (this.audioSelectorName != null ? this.audioSelectorName.hashCode() : 0);
                result = 31 * result + (this.audioType != null ? this.audioType.hashCode() : 0);
                result = 31 * result + (this.audioTypeControl != null ? this.audioTypeControl.hashCode() : 0);
                result = 31 * result + (this.audioWatermarkingSettings != null ? this.audioWatermarkingSettings.hashCode() : 0);
                result = 31 * result + (this.codecSettings != null ? this.codecSettings.hashCode() : 0);
                result = 31 * result + (this.languageCode != null ? this.languageCode.hashCode() : 0);
                result = 31 * result + (this.languageCodeControl != null ? this.languageCodeControl.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.remixSettings != null ? this.remixSettings.hashCode() : 0);
                result = 31 * result + (this.streamName != null ? this.streamName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Selector for HLS audio rendition.
     * <p>
     * The parent of this entity is AudioSelectorSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioHlsRenditionSelectionProperty audioHlsRenditionSelectionProperty = AudioHlsRenditionSelectionProperty.builder()
     *         .groupId("groupId")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioHlsRenditionSelectionProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioHlsRenditionSelectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioHlsRenditionSelectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the GROUP-ID in the #EXT-X-MEDIA tag of the target HLS audio rendition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupId() {
            return null;
        }

        /**
         * Specifies the NAME in the #EXT-X-MEDIA tag of the target HLS audio rendition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioHlsRenditionSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioHlsRenditionSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioHlsRenditionSelectionProperty> {
            java.lang.String groupId;
            java.lang.String name;

            /**
             * Sets the value of {@link AudioHlsRenditionSelectionProperty#getGroupId}
             * @param groupId Specifies the GROUP-ID in the #EXT-X-MEDIA tag of the target HLS audio rendition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupId(java.lang.String groupId) {
                this.groupId = groupId;
                return this;
            }

            /**
             * Sets the value of {@link AudioHlsRenditionSelectionProperty#getName}
             * @param name Specifies the NAME in the #EXT-X-MEDIA tag of the target HLS audio rendition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioHlsRenditionSelectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioHlsRenditionSelectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioHlsRenditionSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioHlsRenditionSelectionProperty {
            private final java.lang.String groupId;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groupId = software.amazon.jsii.Kernel.get(this, "groupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groupId = builder.groupId;
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getGroupId() {
                return this.groupId;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGroupId() != null) {
                    data.set("groupId", om.valueToTree(this.getGroupId()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioHlsRenditionSelectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioHlsRenditionSelectionProperty.Jsii$Proxy that = (AudioHlsRenditionSelectionProperty.Jsii$Proxy) o;

                if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.groupId != null ? this.groupId.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the audio language to extract.
     * <p>
     * The parent of this entity is AudioSelectorSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioLanguageSelectionProperty audioLanguageSelectionProperty = AudioLanguageSelectionProperty.builder()
     *         .languageCode("languageCode")
     *         .languageSelectionPolicy("languageSelectionPolicy")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioLanguageSelectionProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioLanguageSelectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioLanguageSelectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Selects a specific three-letter language code from within an audio source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageCode() {
            return null;
        }

        /**
         * When set to "strict," the transport stream demux strictly identifies audio streams by their language descriptor.
         * <p>
         * If a PMT update occurs such that an audio stream matching the initially selected language is no longer present, then mute is encoded until the language returns. If set to "loose," then on a PMT update the demux chooses another audio stream in the program with the same stream type if it can't find one with the same language.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageSelectionPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioLanguageSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioLanguageSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioLanguageSelectionProperty> {
            java.lang.String languageCode;
            java.lang.String languageSelectionPolicy;

            /**
             * Sets the value of {@link AudioLanguageSelectionProperty#getLanguageCode}
             * @param languageCode Selects a specific three-letter language code from within an audio source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageCode(java.lang.String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            /**
             * Sets the value of {@link AudioLanguageSelectionProperty#getLanguageSelectionPolicy}
             * @param languageSelectionPolicy When set to "strict," the transport stream demux strictly identifies audio streams by their language descriptor.
             *                                If a PMT update occurs such that an audio stream matching the initially selected language is no longer present, then mute is encoded until the language returns. If set to "loose," then on a PMT update the demux chooses another audio stream in the program with the same stream type if it can't find one with the same language.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageSelectionPolicy(java.lang.String languageSelectionPolicy) {
                this.languageSelectionPolicy = languageSelectionPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioLanguageSelectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioLanguageSelectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioLanguageSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioLanguageSelectionProperty {
            private final java.lang.String languageCode;
            private final java.lang.String languageSelectionPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.languageCode = software.amazon.jsii.Kernel.get(this, "languageCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.languageSelectionPolicy = software.amazon.jsii.Kernel.get(this, "languageSelectionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.languageCode = builder.languageCode;
                this.languageSelectionPolicy = builder.languageSelectionPolicy;
            }

            @Override
            public final java.lang.String getLanguageCode() {
                return this.languageCode;
            }

            @Override
            public final java.lang.String getLanguageSelectionPolicy() {
                return this.languageSelectionPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLanguageCode() != null) {
                    data.set("languageCode", om.valueToTree(this.getLanguageCode()));
                }
                if (this.getLanguageSelectionPolicy() != null) {
                    data.set("languageSelectionPolicy", om.valueToTree(this.getLanguageSelectionPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioLanguageSelectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioLanguageSelectionProperty.Jsii$Proxy that = (AudioLanguageSelectionProperty.Jsii$Proxy) o;

                if (this.languageCode != null ? !this.languageCode.equals(that.languageCode) : that.languageCode != null) return false;
                return this.languageSelectionPolicy != null ? this.languageSelectionPolicy.equals(that.languageSelectionPolicy) : that.languageSelectionPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.languageCode != null ? this.languageCode.hashCode() : 0;
                result = 31 * result + (this.languageSelectionPolicy != null ? this.languageSelectionPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for normalizing video.
     * <p>
     * The parent of this entity is AudioDescription.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioNormalizationSettingsProperty audioNormalizationSettingsProperty = AudioNormalizationSettingsProperty.builder()
     *         .algorithm("algorithm")
     *         .algorithmControl("algorithmControl")
     *         .targetLkfs(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioNormalizationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioNormalizationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioNormalizationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The audio normalization algorithm to use.
         * <p>
         * itu17701 conforms to the CALM Act specification. itu17702 conforms to the EBU R-128 specification.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlgorithm() {
            return null;
        }

        /**
         * When set to correctAudio, the output audio is corrected using the chosen algorithm.
         * <p>
         * If set to measureOnly, the audio is measured but not adjusted.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlgorithmControl() {
            return null;
        }

        /**
         * The Target LKFS(loudness) to adjust volume to.
         * <p>
         * If no value is entered, a default value is used according to the chosen algorithm. The CALM Act (1770-1) recommends a target of -24 LKFS. The EBU R-128 specification (1770-2) recommends a target of -23 LKFS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetLkfs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioNormalizationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioNormalizationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioNormalizationSettingsProperty> {
            java.lang.String algorithm;
            java.lang.String algorithmControl;
            java.lang.Number targetLkfs;

            /**
             * Sets the value of {@link AudioNormalizationSettingsProperty#getAlgorithm}
             * @param algorithm The audio normalization algorithm to use.
             *                  itu17701 conforms to the CALM Act specification. itu17702 conforms to the EBU R-128 specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithm(java.lang.String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            /**
             * Sets the value of {@link AudioNormalizationSettingsProperty#getAlgorithmControl}
             * @param algorithmControl When set to correctAudio, the output audio is corrected using the chosen algorithm.
             *                         If set to measureOnly, the audio is measured but not adjusted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithmControl(java.lang.String algorithmControl) {
                this.algorithmControl = algorithmControl;
                return this;
            }

            /**
             * Sets the value of {@link AudioNormalizationSettingsProperty#getTargetLkfs}
             * @param targetLkfs The Target LKFS(loudness) to adjust volume to.
             *                   If no value is entered, a default value is used according to the chosen algorithm. The CALM Act (1770-1) recommends a target of -24 LKFS. The EBU R-128 specification (1770-2) recommends a target of -23 LKFS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetLkfs(java.lang.Number targetLkfs) {
                this.targetLkfs = targetLkfs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioNormalizationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioNormalizationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioNormalizationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioNormalizationSettingsProperty {
            private final java.lang.String algorithm;
            private final java.lang.String algorithmControl;
            private final java.lang.Number targetLkfs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.algorithm = software.amazon.jsii.Kernel.get(this, "algorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.algorithmControl = software.amazon.jsii.Kernel.get(this, "algorithmControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetLkfs = software.amazon.jsii.Kernel.get(this, "targetLkfs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.algorithm = builder.algorithm;
                this.algorithmControl = builder.algorithmControl;
                this.targetLkfs = builder.targetLkfs;
            }

            @Override
            public final java.lang.String getAlgorithm() {
                return this.algorithm;
            }

            @Override
            public final java.lang.String getAlgorithmControl() {
                return this.algorithmControl;
            }

            @Override
            public final java.lang.Number getTargetLkfs() {
                return this.targetLkfs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlgorithm() != null) {
                    data.set("algorithm", om.valueToTree(this.getAlgorithm()));
                }
                if (this.getAlgorithmControl() != null) {
                    data.set("algorithmControl", om.valueToTree(this.getAlgorithmControl()));
                }
                if (this.getTargetLkfs() != null) {
                    data.set("targetLkfs", om.valueToTree(this.getTargetLkfs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioNormalizationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioNormalizationSettingsProperty.Jsii$Proxy that = (AudioNormalizationSettingsProperty.Jsii$Proxy) o;

                if (this.algorithm != null ? !this.algorithm.equals(that.algorithm) : that.algorithm != null) return false;
                if (this.algorithmControl != null ? !this.algorithmControl.equals(that.algorithmControl) : that.algorithmControl != null) return false;
                return this.targetLkfs != null ? this.targetLkfs.equals(that.targetLkfs) : that.targetLkfs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.algorithm != null ? this.algorithm.hashCode() : 0;
                result = 31 * result + (this.algorithmControl != null ? this.algorithmControl.hashCode() : 0);
                result = 31 * result + (this.targetLkfs != null ? this.targetLkfs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of an audio-only HLS output.
     * <p>
     * The parent of this entity is HlsSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioOnlyHlsSettingsProperty audioOnlyHlsSettingsProperty = AudioOnlyHlsSettingsProperty.builder()
     *         .audioGroupId("audioGroupId")
     *         .audioOnlyImage(InputLocationProperty.builder()
     *                 .passwordParam("passwordParam")
     *                 .uri("uri")
     *                 .username("username")
     *                 .build())
     *         .audioTrackType("audioTrackType")
     *         .segmentType("segmentType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioOnlyHlsSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioOnlyHlsSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioOnlyHlsSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the group that the audio rendition belongs to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAudioGroupId() {
            return null;
        }

        /**
         * Used with an audio-only stream.
         * <p>
         * It must be a .jpg or .png file. If given, this image is used as the cover art for the audio-only output. Ideally, it should be formatted for an iPhone screen for two reasons. The iPhone does not resize the image; instead, it crops a centered image on the top/bottom and left/right. Additionally, this image file gets saved bit-for-bit into every 10-second segment file, so it increases bandwidth by {image file size} * {segment count} * {user count.}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioOnlyImage() {
            return null;
        }

        /**
         * Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this audio-only stream instead of video in low-bandwidth scenarios.
         * <p>
         * Represented as an EXT-X-STREAM-INF in the HLS manifest. Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES Alternate Audio, Auto Select, Not Default Alternate rendition that the client might try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAudioTrackType() {
            return null;
        }

        /**
         * Specifies the segment type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSegmentType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioOnlyHlsSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioOnlyHlsSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioOnlyHlsSettingsProperty> {
            java.lang.String audioGroupId;
            java.lang.Object audioOnlyImage;
            java.lang.String audioTrackType;
            java.lang.String segmentType;

            /**
             * Sets the value of {@link AudioOnlyHlsSettingsProperty#getAudioGroupId}
             * @param audioGroupId Specifies the group that the audio rendition belongs to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioGroupId(java.lang.String audioGroupId) {
                this.audioGroupId = audioGroupId;
                return this;
            }

            /**
             * Sets the value of {@link AudioOnlyHlsSettingsProperty#getAudioOnlyImage}
             * @param audioOnlyImage Used with an audio-only stream.
             *                       It must be a .jpg or .png file. If given, this image is used as the cover art for the audio-only output. Ideally, it should be formatted for an iPhone screen for two reasons. The iPhone does not resize the image; instead, it crops a centered image on the top/bottom and left/right. Additionally, this image file gets saved bit-for-bit into every 10-second segment file, so it increases bandwidth by {image file size} * {segment count} * {user count.}.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioOnlyImage(software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty audioOnlyImage) {
                this.audioOnlyImage = audioOnlyImage;
                return this;
            }

            /**
             * Sets the value of {@link AudioOnlyHlsSettingsProperty#getAudioOnlyImage}
             * @param audioOnlyImage Used with an audio-only stream.
             *                       It must be a .jpg or .png file. If given, this image is used as the cover art for the audio-only output. Ideally, it should be formatted for an iPhone screen for two reasons. The iPhone does not resize the image; instead, it crops a centered image on the top/bottom and left/right. Additionally, this image file gets saved bit-for-bit into every 10-second segment file, so it increases bandwidth by {image file size} * {segment count} * {user count.}.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioOnlyImage(software.amazon.awscdk.IResolvable audioOnlyImage) {
                this.audioOnlyImage = audioOnlyImage;
                return this;
            }

            /**
             * Sets the value of {@link AudioOnlyHlsSettingsProperty#getAudioTrackType}
             * @param audioTrackType Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this audio-only stream instead of video in low-bandwidth scenarios.
             *                       Represented as an EXT-X-STREAM-INF in the HLS manifest. Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES Alternate Audio, Auto Select, Not Default Alternate rendition that the client might try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioTrackType(java.lang.String audioTrackType) {
                this.audioTrackType = audioTrackType;
                return this;
            }

            /**
             * Sets the value of {@link AudioOnlyHlsSettingsProperty#getSegmentType}
             * @param segmentType Specifies the segment type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentType(java.lang.String segmentType) {
                this.segmentType = segmentType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioOnlyHlsSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioOnlyHlsSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioOnlyHlsSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioOnlyHlsSettingsProperty {
            private final java.lang.String audioGroupId;
            private final java.lang.Object audioOnlyImage;
            private final java.lang.String audioTrackType;
            private final java.lang.String segmentType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioGroupId = software.amazon.jsii.Kernel.get(this, "audioGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.audioOnlyImage = software.amazon.jsii.Kernel.get(this, "audioOnlyImage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.audioTrackType = software.amazon.jsii.Kernel.get(this, "audioTrackType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.segmentType = software.amazon.jsii.Kernel.get(this, "segmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioGroupId = builder.audioGroupId;
                this.audioOnlyImage = builder.audioOnlyImage;
                this.audioTrackType = builder.audioTrackType;
                this.segmentType = builder.segmentType;
            }

            @Override
            public final java.lang.String getAudioGroupId() {
                return this.audioGroupId;
            }

            @Override
            public final java.lang.Object getAudioOnlyImage() {
                return this.audioOnlyImage;
            }

            @Override
            public final java.lang.String getAudioTrackType() {
                return this.audioTrackType;
            }

            @Override
            public final java.lang.String getSegmentType() {
                return this.segmentType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioGroupId() != null) {
                    data.set("audioGroupId", om.valueToTree(this.getAudioGroupId()));
                }
                if (this.getAudioOnlyImage() != null) {
                    data.set("audioOnlyImage", om.valueToTree(this.getAudioOnlyImage()));
                }
                if (this.getAudioTrackType() != null) {
                    data.set("audioTrackType", om.valueToTree(this.getAudioTrackType()));
                }
                if (this.getSegmentType() != null) {
                    data.set("segmentType", om.valueToTree(this.getSegmentType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioOnlyHlsSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioOnlyHlsSettingsProperty.Jsii$Proxy that = (AudioOnlyHlsSettingsProperty.Jsii$Proxy) o;

                if (this.audioGroupId != null ? !this.audioGroupId.equals(that.audioGroupId) : that.audioGroupId != null) return false;
                if (this.audioOnlyImage != null ? !this.audioOnlyImage.equals(that.audioOnlyImage) : that.audioOnlyImage != null) return false;
                if (this.audioTrackType != null ? !this.audioTrackType.equals(that.audioTrackType) : that.audioTrackType != null) return false;
                return this.segmentType != null ? this.segmentType.equals(that.segmentType) : that.segmentType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioGroupId != null ? this.audioGroupId.hashCode() : 0;
                result = 31 * result + (this.audioOnlyImage != null ? this.audioOnlyImage.hashCode() : 0);
                result = 31 * result + (this.audioTrackType != null ? this.audioTrackType.hashCode() : 0);
                result = 31 * result + (this.segmentType != null ? this.segmentType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Used to extract audio by The PID.
     * <p>
     * The parent of this entity is AudioSelectorSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioPidSelectionProperty audioPidSelectionProperty = AudioPidSelectionProperty.builder()
     *         .pid(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioPidSelectionProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioPidSelectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioPidSelectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Select the audio by this PID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPid() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioPidSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioPidSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioPidSelectionProperty> {
            java.lang.Number pid;

            /**
             * Sets the value of {@link AudioPidSelectionProperty#getPid}
             * @param pid Select the audio by this PID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pid(java.lang.Number pid) {
                this.pid = pid;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioPidSelectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioPidSelectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioPidSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioPidSelectionProperty {
            private final java.lang.Number pid;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pid = software.amazon.jsii.Kernel.get(this, "pid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pid = builder.pid;
            }

            @Override
            public final java.lang.Number getPid() {
                return this.pid;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPid() != null) {
                    data.set("pid", om.valueToTree(this.getPid()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioPidSelectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioPidSelectionProperty.Jsii$Proxy that = (AudioPidSelectionProperty.Jsii$Proxy) o;

                return this.pid != null ? this.pid.equals(that.pid) : that.pid == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pid != null ? this.pid.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Information about one audio to extract from the input.
     * <p>
     * The parent of this entity is InputSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioSelectorProperty audioSelectorProperty = AudioSelectorProperty.builder()
     *         .name("name")
     *         .selectorSettings(AudioSelectorSettingsProperty.builder()
     *                 .audioHlsRenditionSelection(AudioHlsRenditionSelectionProperty.builder()
     *                         .groupId("groupId")
     *                         .name("name")
     *                         .build())
     *                 .audioLanguageSelection(AudioLanguageSelectionProperty.builder()
     *                         .languageCode("languageCode")
     *                         .languageSelectionPolicy("languageSelectionPolicy")
     *                         .build())
     *                 .audioPidSelection(AudioPidSelectionProperty.builder()
     *                         .pid(123)
     *                         .build())
     *                 .audioTrackSelection(AudioTrackSelectionProperty.builder()
     *                         .tracks(List.of(AudioTrackProperty.builder()
     *                                 .track(123)
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for this AudioSelector.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * Information about the specific audio to extract from the input.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSelectorSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioSelectorProperty> {
            java.lang.String name;
            java.lang.Object selectorSettings;

            /**
             * Sets the value of {@link AudioSelectorProperty#getName}
             * @param name A name for this AudioSelector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorProperty#getSelectorSettings}
             * @param selectorSettings Information about the specific audio to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectorSettings(software.amazon.awscdk.services.medialive.CfnChannel.AudioSelectorSettingsProperty selectorSettings) {
                this.selectorSettings = selectorSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorProperty#getSelectorSettings}
             * @param selectorSettings Information about the specific audio to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectorSettings(software.amazon.awscdk.IResolvable selectorSettings) {
                this.selectorSettings = selectorSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioSelectorProperty {
            private final java.lang.String name;
            private final java.lang.Object selectorSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.selectorSettings = software.amazon.jsii.Kernel.get(this, "selectorSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.selectorSettings = builder.selectorSettings;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getSelectorSettings() {
                return this.selectorSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getSelectorSettings() != null) {
                    data.set("selectorSettings", om.valueToTree(this.getSelectorSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioSelectorProperty.Jsii$Proxy that = (AudioSelectorProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.selectorSettings != null ? this.selectorSettings.equals(that.selectorSettings) : that.selectorSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.selectorSettings != null ? this.selectorSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the audio to extract from the input.
     * <p>
     * The parent of this entity is AudioSelector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioSelectorSettingsProperty audioSelectorSettingsProperty = AudioSelectorSettingsProperty.builder()
     *         .audioHlsRenditionSelection(AudioHlsRenditionSelectionProperty.builder()
     *                 .groupId("groupId")
     *                 .name("name")
     *                 .build())
     *         .audioLanguageSelection(AudioLanguageSelectionProperty.builder()
     *                 .languageCode("languageCode")
     *                 .languageSelectionPolicy("languageSelectionPolicy")
     *                 .build())
     *         .audioPidSelection(AudioPidSelectionProperty.builder()
     *                 .pid(123)
     *                 .build())
     *         .audioTrackSelection(AudioTrackSelectionProperty.builder()
     *                 .tracks(List.of(AudioTrackProperty.builder()
     *                         .track(123)
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioSelectorSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioSelectorSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioSelectorSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Selector for HLS audio rendition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioHlsRenditionSelection() {
            return null;
        }

        /**
         * The language code of the audio to select.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioLanguageSelection() {
            return null;
        }

        /**
         * The PID of the audio to select.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioPidSelection() {
            return null;
        }

        /**
         * Information about the audio track to extract.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioTrackSelection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioSelectorSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioSelectorSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioSelectorSettingsProperty> {
            java.lang.Object audioHlsRenditionSelection;
            java.lang.Object audioLanguageSelection;
            java.lang.Object audioPidSelection;
            java.lang.Object audioTrackSelection;

            /**
             * Sets the value of {@link AudioSelectorSettingsProperty#getAudioHlsRenditionSelection}
             * @param audioHlsRenditionSelection Selector for HLS audio rendition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioHlsRenditionSelection(software.amazon.awscdk.services.medialive.CfnChannel.AudioHlsRenditionSelectionProperty audioHlsRenditionSelection) {
                this.audioHlsRenditionSelection = audioHlsRenditionSelection;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorSettingsProperty#getAudioHlsRenditionSelection}
             * @param audioHlsRenditionSelection Selector for HLS audio rendition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioHlsRenditionSelection(software.amazon.awscdk.IResolvable audioHlsRenditionSelection) {
                this.audioHlsRenditionSelection = audioHlsRenditionSelection;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorSettingsProperty#getAudioLanguageSelection}
             * @param audioLanguageSelection The language code of the audio to select.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioLanguageSelection(software.amazon.awscdk.services.medialive.CfnChannel.AudioLanguageSelectionProperty audioLanguageSelection) {
                this.audioLanguageSelection = audioLanguageSelection;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorSettingsProperty#getAudioLanguageSelection}
             * @param audioLanguageSelection The language code of the audio to select.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioLanguageSelection(software.amazon.awscdk.IResolvable audioLanguageSelection) {
                this.audioLanguageSelection = audioLanguageSelection;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorSettingsProperty#getAudioPidSelection}
             * @param audioPidSelection The PID of the audio to select.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioPidSelection(software.amazon.awscdk.services.medialive.CfnChannel.AudioPidSelectionProperty audioPidSelection) {
                this.audioPidSelection = audioPidSelection;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorSettingsProperty#getAudioPidSelection}
             * @param audioPidSelection The PID of the audio to select.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioPidSelection(software.amazon.awscdk.IResolvable audioPidSelection) {
                this.audioPidSelection = audioPidSelection;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorSettingsProperty#getAudioTrackSelection}
             * @param audioTrackSelection Information about the audio track to extract.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioTrackSelection(software.amazon.awscdk.services.medialive.CfnChannel.AudioTrackSelectionProperty audioTrackSelection) {
                this.audioTrackSelection = audioTrackSelection;
                return this;
            }

            /**
             * Sets the value of {@link AudioSelectorSettingsProperty#getAudioTrackSelection}
             * @param audioTrackSelection Information about the audio track to extract.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioTrackSelection(software.amazon.awscdk.IResolvable audioTrackSelection) {
                this.audioTrackSelection = audioTrackSelection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioSelectorSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioSelectorSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioSelectorSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioSelectorSettingsProperty {
            private final java.lang.Object audioHlsRenditionSelection;
            private final java.lang.Object audioLanguageSelection;
            private final java.lang.Object audioPidSelection;
            private final java.lang.Object audioTrackSelection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioHlsRenditionSelection = software.amazon.jsii.Kernel.get(this, "audioHlsRenditionSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.audioLanguageSelection = software.amazon.jsii.Kernel.get(this, "audioLanguageSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.audioPidSelection = software.amazon.jsii.Kernel.get(this, "audioPidSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.audioTrackSelection = software.amazon.jsii.Kernel.get(this, "audioTrackSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioHlsRenditionSelection = builder.audioHlsRenditionSelection;
                this.audioLanguageSelection = builder.audioLanguageSelection;
                this.audioPidSelection = builder.audioPidSelection;
                this.audioTrackSelection = builder.audioTrackSelection;
            }

            @Override
            public final java.lang.Object getAudioHlsRenditionSelection() {
                return this.audioHlsRenditionSelection;
            }

            @Override
            public final java.lang.Object getAudioLanguageSelection() {
                return this.audioLanguageSelection;
            }

            @Override
            public final java.lang.Object getAudioPidSelection() {
                return this.audioPidSelection;
            }

            @Override
            public final java.lang.Object getAudioTrackSelection() {
                return this.audioTrackSelection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioHlsRenditionSelection() != null) {
                    data.set("audioHlsRenditionSelection", om.valueToTree(this.getAudioHlsRenditionSelection()));
                }
                if (this.getAudioLanguageSelection() != null) {
                    data.set("audioLanguageSelection", om.valueToTree(this.getAudioLanguageSelection()));
                }
                if (this.getAudioPidSelection() != null) {
                    data.set("audioPidSelection", om.valueToTree(this.getAudioPidSelection()));
                }
                if (this.getAudioTrackSelection() != null) {
                    data.set("audioTrackSelection", om.valueToTree(this.getAudioTrackSelection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioSelectorSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioSelectorSettingsProperty.Jsii$Proxy that = (AudioSelectorSettingsProperty.Jsii$Proxy) o;

                if (this.audioHlsRenditionSelection != null ? !this.audioHlsRenditionSelection.equals(that.audioHlsRenditionSelection) : that.audioHlsRenditionSelection != null) return false;
                if (this.audioLanguageSelection != null ? !this.audioLanguageSelection.equals(that.audioLanguageSelection) : that.audioLanguageSelection != null) return false;
                if (this.audioPidSelection != null ? !this.audioPidSelection.equals(that.audioPidSelection) : that.audioPidSelection != null) return false;
                return this.audioTrackSelection != null ? this.audioTrackSelection.equals(that.audioTrackSelection) : that.audioTrackSelection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioHlsRenditionSelection != null ? this.audioHlsRenditionSelection.hashCode() : 0;
                result = 31 * result + (this.audioLanguageSelection != null ? this.audioLanguageSelection.hashCode() : 0);
                result = 31 * result + (this.audioPidSelection != null ? this.audioPidSelection.hashCode() : 0);
                result = 31 * result + (this.audioTrackSelection != null ? this.audioTrackSelection.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * MediaLive will perform a failover if audio is not detected in this input for the specified period.
     * <p>
     * The parent of this entity is FailoverConditionSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioSilenceFailoverSettingsProperty audioSilenceFailoverSettingsProperty = AudioSilenceFailoverSettingsProperty.builder()
     *         .audioSelectorName("audioSelectorName")
     *         .audioSilenceThresholdMsec(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioSilenceFailoverSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioSilenceFailoverSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioSilenceFailoverSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the audio selector in the input that MediaLive should monitor to detect silence.
         * <p>
         * Select your most important rendition. If you didn't create an audio selector in this input, leave blank.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAudioSelectorName() {
            return null;
        }

        /**
         * The amount of time (in milliseconds) that the active input must be silent before automatic input failover occurs.
         * <p>
         * Silence is defined as audio loss or audio quieter than -50 dBFS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAudioSilenceThresholdMsec() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioSilenceFailoverSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioSilenceFailoverSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioSilenceFailoverSettingsProperty> {
            java.lang.String audioSelectorName;
            java.lang.Number audioSilenceThresholdMsec;

            /**
             * Sets the value of {@link AudioSilenceFailoverSettingsProperty#getAudioSelectorName}
             * @param audioSelectorName The name of the audio selector in the input that MediaLive should monitor to detect silence.
             *                          Select your most important rendition. If you didn't create an audio selector in this input, leave blank.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioSelectorName(java.lang.String audioSelectorName) {
                this.audioSelectorName = audioSelectorName;
                return this;
            }

            /**
             * Sets the value of {@link AudioSilenceFailoverSettingsProperty#getAudioSilenceThresholdMsec}
             * @param audioSilenceThresholdMsec The amount of time (in milliseconds) that the active input must be silent before automatic input failover occurs.
             *                                  Silence is defined as audio loss or audio quieter than -50 dBFS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioSilenceThresholdMsec(java.lang.Number audioSilenceThresholdMsec) {
                this.audioSilenceThresholdMsec = audioSilenceThresholdMsec;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioSilenceFailoverSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioSilenceFailoverSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioSilenceFailoverSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioSilenceFailoverSettingsProperty {
            private final java.lang.String audioSelectorName;
            private final java.lang.Number audioSilenceThresholdMsec;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioSelectorName = software.amazon.jsii.Kernel.get(this, "audioSelectorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.audioSilenceThresholdMsec = software.amazon.jsii.Kernel.get(this, "audioSilenceThresholdMsec", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioSelectorName = builder.audioSelectorName;
                this.audioSilenceThresholdMsec = builder.audioSilenceThresholdMsec;
            }

            @Override
            public final java.lang.String getAudioSelectorName() {
                return this.audioSelectorName;
            }

            @Override
            public final java.lang.Number getAudioSilenceThresholdMsec() {
                return this.audioSilenceThresholdMsec;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioSelectorName() != null) {
                    data.set("audioSelectorName", om.valueToTree(this.getAudioSelectorName()));
                }
                if (this.getAudioSilenceThresholdMsec() != null) {
                    data.set("audioSilenceThresholdMsec", om.valueToTree(this.getAudioSilenceThresholdMsec()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioSilenceFailoverSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioSilenceFailoverSettingsProperty.Jsii$Proxy that = (AudioSilenceFailoverSettingsProperty.Jsii$Proxy) o;

                if (this.audioSelectorName != null ? !this.audioSelectorName.equals(that.audioSelectorName) : that.audioSelectorName != null) return false;
                return this.audioSilenceThresholdMsec != null ? this.audioSilenceThresholdMsec.equals(that.audioSilenceThresholdMsec) : that.audioSilenceThresholdMsec == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioSelectorName != null ? this.audioSelectorName.hashCode() : 0;
                result = 31 * result + (this.audioSilenceThresholdMsec != null ? this.audioSilenceThresholdMsec.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about one audio track to extract. You can select multiple tracks.
     * <p>
     * The parent of this entity is AudioTrackSelection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioTrackProperty audioTrackProperty = AudioTrackProperty.builder()
     *         .track(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioTrackProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioTrackProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioTrackProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * 1-based integer value that maps to a specific audio track.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTrack() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioTrackProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioTrackProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioTrackProperty> {
            java.lang.Number track;

            /**
             * Sets the value of {@link AudioTrackProperty#getTrack}
             * @param track 1-based integer value that maps to a specific audio track.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder track(java.lang.Number track) {
                this.track = track;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioTrackProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioTrackProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioTrackProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioTrackProperty {
            private final java.lang.Number track;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.track = software.amazon.jsii.Kernel.get(this, "track", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.track = builder.track;
            }

            @Override
            public final java.lang.Number getTrack() {
                return this.track;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTrack() != null) {
                    data.set("track", om.valueToTree(this.getTrack()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioTrackProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioTrackProperty.Jsii$Proxy that = (AudioTrackProperty.Jsii$Proxy) o;

                return this.track != null ? this.track.equals(that.track) : that.track == null;
            }

            @Override
            public final int hashCode() {
                int result = this.track != null ? this.track.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Information about the audio track to extract.
     * <p>
     * The parent of this entity is AudioSelectorSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioTrackSelectionProperty audioTrackSelectionProperty = AudioTrackSelectionProperty.builder()
     *         .tracks(List.of(AudioTrackProperty.builder()
     *                 .track(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioTrackSelectionProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioTrackSelectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioTrackSelectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Selects one or more unique audio tracks from within a source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTracks() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioTrackSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioTrackSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioTrackSelectionProperty> {
            java.lang.Object tracks;

            /**
             * Sets the value of {@link AudioTrackSelectionProperty#getTracks}
             * @param tracks Selects one or more unique audio tracks from within a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tracks(software.amazon.awscdk.IResolvable tracks) {
                this.tracks = tracks;
                return this;
            }

            /**
             * Sets the value of {@link AudioTrackSelectionProperty#getTracks}
             * @param tracks Selects one or more unique audio tracks from within a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tracks(java.util.List<? extends java.lang.Object> tracks) {
                this.tracks = tracks;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioTrackSelectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioTrackSelectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioTrackSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioTrackSelectionProperty {
            private final java.lang.Object tracks;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tracks = software.amazon.jsii.Kernel.get(this, "tracks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tracks = builder.tracks;
            }

            @Override
            public final java.lang.Object getTracks() {
                return this.tracks;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTracks() != null) {
                    data.set("tracks", om.valueToTree(this.getTracks()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioTrackSelectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioTrackSelectionProperty.Jsii$Proxy that = (AudioTrackSelectionProperty.Jsii$Proxy) o;

                return this.tracks != null ? this.tracks.equals(that.tracks) : that.tracks == null;
            }

            @Override
            public final int hashCode() {
                int result = this.tracks != null ? this.tracks.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Audio Watermark Settings.
     * <p>
     * The parent of this entity is AudioDescription.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AudioWatermarkSettingsProperty audioWatermarkSettingsProperty = AudioWatermarkSettingsProperty.builder()
     *         .nielsenWatermarksSettings(NielsenWatermarksSettingsProperty.builder()
     *                 .nielsenCbetSettings(NielsenCBETProperty.builder()
     *                         .cbetCheckDigitString("cbetCheckDigitString")
     *                         .cbetStepaside("cbetStepaside")
     *                         .csid("csid")
     *                         .build())
     *                 .nielsenDistributionType("nielsenDistributionType")
     *                 .nielsenNaesIiNwSettings(NielsenNaesIiNwProperty.builder()
     *                         .checkDigitString("checkDigitString")
     *                         .sid(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AudioWatermarkSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioWatermarkSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioWatermarkSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings to configure Nielsen Watermarks in the audio encode.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNielsenWatermarksSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AudioWatermarkSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioWatermarkSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioWatermarkSettingsProperty> {
            java.lang.Object nielsenWatermarksSettings;

            /**
             * Sets the value of {@link AudioWatermarkSettingsProperty#getNielsenWatermarksSettings}
             * @param nielsenWatermarksSettings Settings to configure Nielsen Watermarks in the audio encode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nielsenWatermarksSettings(software.amazon.awscdk.services.medialive.CfnChannel.NielsenWatermarksSettingsProperty nielsenWatermarksSettings) {
                this.nielsenWatermarksSettings = nielsenWatermarksSettings;
                return this;
            }

            /**
             * Sets the value of {@link AudioWatermarkSettingsProperty#getNielsenWatermarksSettings}
             * @param nielsenWatermarksSettings Settings to configure Nielsen Watermarks in the audio encode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nielsenWatermarksSettings(software.amazon.awscdk.IResolvable nielsenWatermarksSettings) {
                this.nielsenWatermarksSettings = nielsenWatermarksSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioWatermarkSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioWatermarkSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioWatermarkSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioWatermarkSettingsProperty {
            private final java.lang.Object nielsenWatermarksSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.nielsenWatermarksSettings = software.amazon.jsii.Kernel.get(this, "nielsenWatermarksSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.nielsenWatermarksSettings = builder.nielsenWatermarksSettings;
            }

            @Override
            public final java.lang.Object getNielsenWatermarksSettings() {
                return this.nielsenWatermarksSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNielsenWatermarksSettings() != null) {
                    data.set("nielsenWatermarksSettings", om.valueToTree(this.getNielsenWatermarksSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AudioWatermarkSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioWatermarkSettingsProperty.Jsii$Proxy that = (AudioWatermarkSettingsProperty.Jsii$Proxy) o;

                return this.nielsenWatermarksSettings != null ? this.nielsenWatermarksSettings.equals(that.nielsenWatermarksSettings) : that.nielsenWatermarksSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.nielsenWatermarksSettings != null ? this.nielsenWatermarksSettings.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Settings to configure the conditions that will define the input as unhealthy and that will make MediaLive fail over to the other input in the input failover pair.
     * <p>
     * The parent of this entity is InputAttachment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AutomaticInputFailoverSettingsProperty automaticInputFailoverSettingsProperty = AutomaticInputFailoverSettingsProperty.builder()
     *         .errorClearTimeMsec(123)
     *         .failoverConditions(List.of(FailoverConditionProperty.builder()
     *                 .failoverConditionSettings(FailoverConditionSettingsProperty.builder()
     *                         .audioSilenceSettings(AudioSilenceFailoverSettingsProperty.builder()
     *                                 .audioSelectorName("audioSelectorName")
     *                                 .audioSilenceThresholdMsec(123)
     *                                 .build())
     *                         .inputLossSettings(InputLossFailoverSettingsProperty.builder()
     *                                 .inputLossThresholdMsec(123)
     *                                 .build())
     *                         .videoBlackSettings(VideoBlackFailoverSettingsProperty.builder()
     *                                 .blackDetectThreshold(123)
     *                                 .videoBlackThresholdMsec(123)
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .inputPreference("inputPreference")
     *         .secondaryInputId("secondaryInputId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AutomaticInputFailoverSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AutomaticInputFailoverSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutomaticInputFailoverSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This clear time defines the requirement a recovered input must meet to be considered healthy.
         * <p>
         * The input must have no failover conditions for this length of time. Enter a time in milliseconds. This value is particularly important if the input_preference for the failover pair is set to PRIMARY_INPUT_PREFERRED, because after this time, MediaLive will switch back to the primary input.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getErrorClearTimeMsec() {
            return null;
        }

        /**
         * A list of failover conditions.
         * <p>
         * If any of these conditions occur, MediaLive will perform a failover to the other input.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailoverConditions() {
            return null;
        }

        /**
         * Input preference when deciding which input to make active when a previously failed input has recovered.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputPreference() {
            return null;
        }

        /**
         * The input ID of the secondary input in the automatic input failover pair.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecondaryInputId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutomaticInputFailoverSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutomaticInputFailoverSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutomaticInputFailoverSettingsProperty> {
            java.lang.Number errorClearTimeMsec;
            java.lang.Object failoverConditions;
            java.lang.String inputPreference;
            java.lang.String secondaryInputId;

            /**
             * Sets the value of {@link AutomaticInputFailoverSettingsProperty#getErrorClearTimeMsec}
             * @param errorClearTimeMsec This clear time defines the requirement a recovered input must meet to be considered healthy.
             *                           The input must have no failover conditions for this length of time. Enter a time in milliseconds. This value is particularly important if the input_preference for the failover pair is set to PRIMARY_INPUT_PREFERRED, because after this time, MediaLive will switch back to the primary input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorClearTimeMsec(java.lang.Number errorClearTimeMsec) {
                this.errorClearTimeMsec = errorClearTimeMsec;
                return this;
            }

            /**
             * Sets the value of {@link AutomaticInputFailoverSettingsProperty#getFailoverConditions}
             * @param failoverConditions A list of failover conditions.
             *                           If any of these conditions occur, MediaLive will perform a failover to the other input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failoverConditions(software.amazon.awscdk.IResolvable failoverConditions) {
                this.failoverConditions = failoverConditions;
                return this;
            }

            /**
             * Sets the value of {@link AutomaticInputFailoverSettingsProperty#getFailoverConditions}
             * @param failoverConditions A list of failover conditions.
             *                           If any of these conditions occur, MediaLive will perform a failover to the other input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failoverConditions(java.util.List<? extends java.lang.Object> failoverConditions) {
                this.failoverConditions = failoverConditions;
                return this;
            }

            /**
             * Sets the value of {@link AutomaticInputFailoverSettingsProperty#getInputPreference}
             * @param inputPreference Input preference when deciding which input to make active when a previously failed input has recovered.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputPreference(java.lang.String inputPreference) {
                this.inputPreference = inputPreference;
                return this;
            }

            /**
             * Sets the value of {@link AutomaticInputFailoverSettingsProperty#getSecondaryInputId}
             * @param secondaryInputId The input ID of the secondary input in the automatic input failover pair.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secondaryInputId(java.lang.String secondaryInputId) {
                this.secondaryInputId = secondaryInputId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutomaticInputFailoverSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutomaticInputFailoverSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutomaticInputFailoverSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutomaticInputFailoverSettingsProperty {
            private final java.lang.Number errorClearTimeMsec;
            private final java.lang.Object failoverConditions;
            private final java.lang.String inputPreference;
            private final java.lang.String secondaryInputId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.errorClearTimeMsec = software.amazon.jsii.Kernel.get(this, "errorClearTimeMsec", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.failoverConditions = software.amazon.jsii.Kernel.get(this, "failoverConditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputPreference = software.amazon.jsii.Kernel.get(this, "inputPreference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secondaryInputId = software.amazon.jsii.Kernel.get(this, "secondaryInputId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.errorClearTimeMsec = builder.errorClearTimeMsec;
                this.failoverConditions = builder.failoverConditions;
                this.inputPreference = builder.inputPreference;
                this.secondaryInputId = builder.secondaryInputId;
            }

            @Override
            public final java.lang.Number getErrorClearTimeMsec() {
                return this.errorClearTimeMsec;
            }

            @Override
            public final java.lang.Object getFailoverConditions() {
                return this.failoverConditions;
            }

            @Override
            public final java.lang.String getInputPreference() {
                return this.inputPreference;
            }

            @Override
            public final java.lang.String getSecondaryInputId() {
                return this.secondaryInputId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getErrorClearTimeMsec() != null) {
                    data.set("errorClearTimeMsec", om.valueToTree(this.getErrorClearTimeMsec()));
                }
                if (this.getFailoverConditions() != null) {
                    data.set("failoverConditions", om.valueToTree(this.getFailoverConditions()));
                }
                if (this.getInputPreference() != null) {
                    data.set("inputPreference", om.valueToTree(this.getInputPreference()));
                }
                if (this.getSecondaryInputId() != null) {
                    data.set("secondaryInputId", om.valueToTree(this.getSecondaryInputId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AutomaticInputFailoverSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutomaticInputFailoverSettingsProperty.Jsii$Proxy that = (AutomaticInputFailoverSettingsProperty.Jsii$Proxy) o;

                if (this.errorClearTimeMsec != null ? !this.errorClearTimeMsec.equals(that.errorClearTimeMsec) : that.errorClearTimeMsec != null) return false;
                if (this.failoverConditions != null ? !this.failoverConditions.equals(that.failoverConditions) : that.failoverConditions != null) return false;
                if (this.inputPreference != null ? !this.inputPreference.equals(that.inputPreference) : that.inputPreference != null) return false;
                return this.secondaryInputId != null ? this.secondaryInputId.equals(that.secondaryInputId) : that.secondaryInputId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.errorClearTimeMsec != null ? this.errorClearTimeMsec.hashCode() : 0;
                result = 31 * result + (this.failoverConditions != null ? this.failoverConditions.hashCode() : 0);
                result = 31 * result + (this.inputPreference != null ? this.inputPreference.hashCode() : 0);
                result = 31 * result + (this.secondaryInputId != null ? this.secondaryInputId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of ad avail blanking in the output.
     * <p>
     * The parent of this entity is EncoderSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AvailBlankingProperty availBlankingProperty = AvailBlankingProperty.builder()
     *         .availBlankingImage(InputLocationProperty.builder()
     *                 .passwordParam("passwordParam")
     *                 .uri("uri")
     *                 .username("username")
     *                 .build())
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AvailBlankingProperty")
    @software.amazon.jsii.Jsii.Proxy(AvailBlankingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AvailBlankingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The blanking image to be used.
         * <p>
         * Keep empty for solid black. Only .bmp and .png images are supported.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAvailBlankingImage() {
            return null;
        }

        /**
         * When set to enabled, the video, audio, and captions are blanked when insertion metadata is added.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AvailBlankingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AvailBlankingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AvailBlankingProperty> {
            java.lang.Object availBlankingImage;
            java.lang.String state;

            /**
             * Sets the value of {@link AvailBlankingProperty#getAvailBlankingImage}
             * @param availBlankingImage The blanking image to be used.
             *                           Keep empty for solid black. Only .bmp and .png images are supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availBlankingImage(software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty availBlankingImage) {
                this.availBlankingImage = availBlankingImage;
                return this;
            }

            /**
             * Sets the value of {@link AvailBlankingProperty#getAvailBlankingImage}
             * @param availBlankingImage The blanking image to be used.
             *                           Keep empty for solid black. Only .bmp and .png images are supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availBlankingImage(software.amazon.awscdk.IResolvable availBlankingImage) {
                this.availBlankingImage = availBlankingImage;
                return this;
            }

            /**
             * Sets the value of {@link AvailBlankingProperty#getState}
             * @param state When set to enabled, the video, audio, and captions are blanked when insertion metadata is added.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AvailBlankingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AvailBlankingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AvailBlankingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AvailBlankingProperty {
            private final java.lang.Object availBlankingImage;
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availBlankingImage = software.amazon.jsii.Kernel.get(this, "availBlankingImage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availBlankingImage = builder.availBlankingImage;
                this.state = builder.state;
            }

            @Override
            public final java.lang.Object getAvailBlankingImage() {
                return this.availBlankingImage;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailBlankingImage() != null) {
                    data.set("availBlankingImage", om.valueToTree(this.getAvailBlankingImage()));
                }
                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AvailBlankingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AvailBlankingProperty.Jsii$Proxy that = (AvailBlankingProperty.Jsii$Proxy) o;

                if (this.availBlankingImage != null ? !this.availBlankingImage.equals(that.availBlankingImage) : that.availBlankingImage != null) return false;
                return this.state != null ? this.state.equals(that.state) : that.state == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availBlankingImage != null ? this.availBlankingImage.hashCode() : 0;
                result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The setup of ad avail handling in the output.
     * <p>
     * The parent of this entity is EncoderSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AvailConfigurationProperty availConfigurationProperty = AvailConfigurationProperty.builder()
     *         .availSettings(AvailSettingsProperty.builder()
     *                 .scte35SpliceInsert(Scte35SpliceInsertProperty.builder()
     *                         .adAvailOffset(123)
     *                         .noRegionalBlackoutFlag("noRegionalBlackoutFlag")
     *                         .webDeliveryAllowedFlag("webDeliveryAllowedFlag")
     *                         .build())
     *                 .scte35TimeSignalApos(Scte35TimeSignalAposProperty.builder()
     *                         .adAvailOffset(123)
     *                         .noRegionalBlackoutFlag("noRegionalBlackoutFlag")
     *                         .webDeliveryAllowedFlag("webDeliveryAllowedFlag")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AvailConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AvailConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AvailConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The setup of ad avail handling in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAvailSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AvailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AvailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AvailConfigurationProperty> {
            java.lang.Object availSettings;

            /**
             * Sets the value of {@link AvailConfigurationProperty#getAvailSettings}
             * @param availSettings The setup of ad avail handling in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availSettings(software.amazon.awscdk.services.medialive.CfnChannel.AvailSettingsProperty availSettings) {
                this.availSettings = availSettings;
                return this;
            }

            /**
             * Sets the value of {@link AvailConfigurationProperty#getAvailSettings}
             * @param availSettings The setup of ad avail handling in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availSettings(software.amazon.awscdk.IResolvable availSettings) {
                this.availSettings = availSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AvailConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AvailConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AvailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AvailConfigurationProperty {
            private final java.lang.Object availSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availSettings = software.amazon.jsii.Kernel.get(this, "availSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availSettings = builder.availSettings;
            }

            @Override
            public final java.lang.Object getAvailSettings() {
                return this.availSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailSettings() != null) {
                    data.set("availSettings", om.valueToTree(this.getAvailSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AvailConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AvailConfigurationProperty.Jsii$Proxy that = (AvailConfigurationProperty.Jsii$Proxy) o;

                return this.availSettings != null ? this.availSettings.equals(that.availSettings) : that.availSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availSettings != null ? this.availSettings.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The settings for the ad avail setup in the output.
     * <p>
     * The parent of this entity is AvailConfiguration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * AvailSettingsProperty availSettingsProperty = AvailSettingsProperty.builder()
     *         .scte35SpliceInsert(Scte35SpliceInsertProperty.builder()
     *                 .adAvailOffset(123)
     *                 .noRegionalBlackoutFlag("noRegionalBlackoutFlag")
     *                 .webDeliveryAllowedFlag("webDeliveryAllowedFlag")
     *                 .build())
     *         .scte35TimeSignalApos(Scte35TimeSignalAposProperty.builder()
     *                 .adAvailOffset(123)
     *                 .noRegionalBlackoutFlag("noRegionalBlackoutFlag")
     *                 .webDeliveryAllowedFlag("webDeliveryAllowedFlag")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.AvailSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(AvailSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AvailSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The setup for SCTE-35 splice insert handling.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScte35SpliceInsert() {
            return null;
        }

        /**
         * The setup for SCTE-35 time signal APOS handling.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScte35TimeSignalApos() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AvailSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AvailSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AvailSettingsProperty> {
            java.lang.Object scte35SpliceInsert;
            java.lang.Object scte35TimeSignalApos;

            /**
             * Sets the value of {@link AvailSettingsProperty#getScte35SpliceInsert}
             * @param scte35SpliceInsert The setup for SCTE-35 splice insert handling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte35SpliceInsert(software.amazon.awscdk.services.medialive.CfnChannel.Scte35SpliceInsertProperty scte35SpliceInsert) {
                this.scte35SpliceInsert = scte35SpliceInsert;
                return this;
            }

            /**
             * Sets the value of {@link AvailSettingsProperty#getScte35SpliceInsert}
             * @param scte35SpliceInsert The setup for SCTE-35 splice insert handling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte35SpliceInsert(software.amazon.awscdk.IResolvable scte35SpliceInsert) {
                this.scte35SpliceInsert = scte35SpliceInsert;
                return this;
            }

            /**
             * Sets the value of {@link AvailSettingsProperty#getScte35TimeSignalApos}
             * @param scte35TimeSignalApos The setup for SCTE-35 time signal APOS handling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte35TimeSignalApos(software.amazon.awscdk.services.medialive.CfnChannel.Scte35TimeSignalAposProperty scte35TimeSignalApos) {
                this.scte35TimeSignalApos = scte35TimeSignalApos;
                return this;
            }

            /**
             * Sets the value of {@link AvailSettingsProperty#getScte35TimeSignalApos}
             * @param scte35TimeSignalApos The setup for SCTE-35 time signal APOS handling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte35TimeSignalApos(software.amazon.awscdk.IResolvable scte35TimeSignalApos) {
                this.scte35TimeSignalApos = scte35TimeSignalApos;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AvailSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AvailSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AvailSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AvailSettingsProperty {
            private final java.lang.Object scte35SpliceInsert;
            private final java.lang.Object scte35TimeSignalApos;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scte35SpliceInsert = software.amazon.jsii.Kernel.get(this, "scte35SpliceInsert", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scte35TimeSignalApos = software.amazon.jsii.Kernel.get(this, "scte35TimeSignalApos", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scte35SpliceInsert = builder.scte35SpliceInsert;
                this.scte35TimeSignalApos = builder.scte35TimeSignalApos;
            }

            @Override
            public final java.lang.Object getScte35SpliceInsert() {
                return this.scte35SpliceInsert;
            }

            @Override
            public final java.lang.Object getScte35TimeSignalApos() {
                return this.scte35TimeSignalApos;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getScte35SpliceInsert() != null) {
                    data.set("scte35SpliceInsert", om.valueToTree(this.getScte35SpliceInsert()));
                }
                if (this.getScte35TimeSignalApos() != null) {
                    data.set("scte35TimeSignalApos", om.valueToTree(this.getScte35TimeSignalApos()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.AvailSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AvailSettingsProperty.Jsii$Proxy that = (AvailSettingsProperty.Jsii$Proxy) o;

                if (this.scte35SpliceInsert != null ? !this.scte35SpliceInsert.equals(that.scte35SpliceInsert) : that.scte35SpliceInsert != null) return false;
                return this.scte35TimeSignalApos != null ? this.scte35TimeSignalApos.equals(that.scte35TimeSignalApos) : that.scte35TimeSignalApos == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scte35SpliceInsert != null ? this.scte35SpliceInsert.hashCode() : 0;
                result = 31 * result + (this.scte35TimeSignalApos != null ? this.scte35TimeSignalApos.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for a blackout slate.
     * <p>
     * The parent of this entity is EncoderSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * BlackoutSlateProperty blackoutSlateProperty = BlackoutSlateProperty.builder()
     *         .blackoutSlateImage(InputLocationProperty.builder()
     *                 .passwordParam("passwordParam")
     *                 .uri("uri")
     *                 .username("username")
     *                 .build())
     *         .networkEndBlackout("networkEndBlackout")
     *         .networkEndBlackoutImage(InputLocationProperty.builder()
     *                 .passwordParam("passwordParam")
     *                 .uri("uri")
     *                 .username("username")
     *                 .build())
     *         .networkId("networkId")
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.BlackoutSlateProperty")
    @software.amazon.jsii.Jsii.Proxy(BlackoutSlateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BlackoutSlateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The blackout slate image to be used.
         * <p>
         * Keep empty for solid black. Only .bmp and .png images are supported.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlackoutSlateImage() {
            return null;
        }

        /**
         * Setting to enabled causes MediaLive to blackout the video, audio, and captions, and raise the "Network Blackout Image" slate when an SCTE104/35 Network End Segmentation Descriptor is encountered.
         * <p>
         * The blackout is lifted when the Network Start Segmentation Descriptor is encountered. The Network End and Network Start descriptors must contain a network ID that matches the value entered in Network ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNetworkEndBlackout() {
            return null;
        }

        /**
         * The path to the local file to use as the Network End Blackout image.
         * <p>
         * The image is scaled to fill the entire output raster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkEndBlackoutImage() {
            return null;
        }

        /**
         * Provides a Network ID that matches EIDR ID format (for example, "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNetworkId() {
            return null;
        }

        /**
         * When set to enabled, this causes video, audio, and captions to be blanked when indicated by program metadata.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BlackoutSlateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BlackoutSlateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BlackoutSlateProperty> {
            java.lang.Object blackoutSlateImage;
            java.lang.String networkEndBlackout;
            java.lang.Object networkEndBlackoutImage;
            java.lang.String networkId;
            java.lang.String state;

            /**
             * Sets the value of {@link BlackoutSlateProperty#getBlackoutSlateImage}
             * @param blackoutSlateImage The blackout slate image to be used.
             *                           Keep empty for solid black. Only .bmp and .png images are supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blackoutSlateImage(software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty blackoutSlateImage) {
                this.blackoutSlateImage = blackoutSlateImage;
                return this;
            }

            /**
             * Sets the value of {@link BlackoutSlateProperty#getBlackoutSlateImage}
             * @param blackoutSlateImage The blackout slate image to be used.
             *                           Keep empty for solid black. Only .bmp and .png images are supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blackoutSlateImage(software.amazon.awscdk.IResolvable blackoutSlateImage) {
                this.blackoutSlateImage = blackoutSlateImage;
                return this;
            }

            /**
             * Sets the value of {@link BlackoutSlateProperty#getNetworkEndBlackout}
             * @param networkEndBlackout Setting to enabled causes MediaLive to blackout the video, audio, and captions, and raise the "Network Blackout Image" slate when an SCTE104/35 Network End Segmentation Descriptor is encountered.
             *                           The blackout is lifted when the Network Start Segmentation Descriptor is encountered. The Network End and Network Start descriptors must contain a network ID that matches the value entered in Network ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkEndBlackout(java.lang.String networkEndBlackout) {
                this.networkEndBlackout = networkEndBlackout;
                return this;
            }

            /**
             * Sets the value of {@link BlackoutSlateProperty#getNetworkEndBlackoutImage}
             * @param networkEndBlackoutImage The path to the local file to use as the Network End Blackout image.
             *                                The image is scaled to fill the entire output raster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkEndBlackoutImage(software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty networkEndBlackoutImage) {
                this.networkEndBlackoutImage = networkEndBlackoutImage;
                return this;
            }

            /**
             * Sets the value of {@link BlackoutSlateProperty#getNetworkEndBlackoutImage}
             * @param networkEndBlackoutImage The path to the local file to use as the Network End Blackout image.
             *                                The image is scaled to fill the entire output raster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkEndBlackoutImage(software.amazon.awscdk.IResolvable networkEndBlackoutImage) {
                this.networkEndBlackoutImage = networkEndBlackoutImage;
                return this;
            }

            /**
             * Sets the value of {@link BlackoutSlateProperty#getNetworkId}
             * @param networkId Provides a Network ID that matches EIDR ID format (for example, "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkId(java.lang.String networkId) {
                this.networkId = networkId;
                return this;
            }

            /**
             * Sets the value of {@link BlackoutSlateProperty#getState}
             * @param state When set to enabled, this causes video, audio, and captions to be blanked when indicated by program metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlackoutSlateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BlackoutSlateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BlackoutSlateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlackoutSlateProperty {
            private final java.lang.Object blackoutSlateImage;
            private final java.lang.String networkEndBlackout;
            private final java.lang.Object networkEndBlackoutImage;
            private final java.lang.String networkId;
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blackoutSlateImage = software.amazon.jsii.Kernel.get(this, "blackoutSlateImage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkEndBlackout = software.amazon.jsii.Kernel.get(this, "networkEndBlackout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.networkEndBlackoutImage = software.amazon.jsii.Kernel.get(this, "networkEndBlackoutImage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkId = software.amazon.jsii.Kernel.get(this, "networkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blackoutSlateImage = builder.blackoutSlateImage;
                this.networkEndBlackout = builder.networkEndBlackout;
                this.networkEndBlackoutImage = builder.networkEndBlackoutImage;
                this.networkId = builder.networkId;
                this.state = builder.state;
            }

            @Override
            public final java.lang.Object getBlackoutSlateImage() {
                return this.blackoutSlateImage;
            }

            @Override
            public final java.lang.String getNetworkEndBlackout() {
                return this.networkEndBlackout;
            }

            @Override
            public final java.lang.Object getNetworkEndBlackoutImage() {
                return this.networkEndBlackoutImage;
            }

            @Override
            public final java.lang.String getNetworkId() {
                return this.networkId;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlackoutSlateImage() != null) {
                    data.set("blackoutSlateImage", om.valueToTree(this.getBlackoutSlateImage()));
                }
                if (this.getNetworkEndBlackout() != null) {
                    data.set("networkEndBlackout", om.valueToTree(this.getNetworkEndBlackout()));
                }
                if (this.getNetworkEndBlackoutImage() != null) {
                    data.set("networkEndBlackoutImage", om.valueToTree(this.getNetworkEndBlackoutImage()));
                }
                if (this.getNetworkId() != null) {
                    data.set("networkId", om.valueToTree(this.getNetworkId()));
                }
                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.BlackoutSlateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlackoutSlateProperty.Jsii$Proxy that = (BlackoutSlateProperty.Jsii$Proxy) o;

                if (this.blackoutSlateImage != null ? !this.blackoutSlateImage.equals(that.blackoutSlateImage) : that.blackoutSlateImage != null) return false;
                if (this.networkEndBlackout != null ? !this.networkEndBlackout.equals(that.networkEndBlackout) : that.networkEndBlackout != null) return false;
                if (this.networkEndBlackoutImage != null ? !this.networkEndBlackoutImage.equals(that.networkEndBlackoutImage) : that.networkEndBlackoutImage != null) return false;
                if (this.networkId != null ? !this.networkId.equals(that.networkId) : that.networkId != null) return false;
                return this.state != null ? this.state.equals(that.state) : that.state == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blackoutSlateImage != null ? this.blackoutSlateImage.hashCode() : 0;
                result = 31 * result + (this.networkEndBlackout != null ? this.networkEndBlackout.hashCode() : 0);
                result = 31 * result + (this.networkEndBlackoutImage != null ? this.networkEndBlackoutImage.hashCode() : 0);
                result = 31 * result + (this.networkId != null ? this.networkId.hashCode() : 0);
                result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for burn-in captions in the output.
     * <p>
     * The parent of this entity is CaptionDestinationSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * BurnInDestinationSettingsProperty burnInDestinationSettingsProperty = BurnInDestinationSettingsProperty.builder()
     *         .alignment("alignment")
     *         .backgroundColor("backgroundColor")
     *         .backgroundOpacity(123)
     *         .font(InputLocationProperty.builder()
     *                 .passwordParam("passwordParam")
     *                 .uri("uri")
     *                 .username("username")
     *                 .build())
     *         .fontColor("fontColor")
     *         .fontOpacity(123)
     *         .fontResolution(123)
     *         .fontSize("fontSize")
     *         .outlineColor("outlineColor")
     *         .outlineSize(123)
     *         .shadowColor("shadowColor")
     *         .shadowOpacity(123)
     *         .shadowXOffset(123)
     *         .shadowYOffset(123)
     *         .teletextGridControl("teletextGridControl")
     *         .xPosition(123)
     *         .yPosition(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.BurnInDestinationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(BurnInDestinationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BurnInDestinationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If no explicit xPosition or yPosition is provided, setting alignment to centered places the captions at the bottom center of the output.
         * <p>
         * Similarly, setting a left alignment aligns captions to the bottom left of the output. If x and y positions are specified in conjunction with the alignment parameter, the font is justified (either left or centered) relative to those coordinates. Selecting "smart" justification left-justifies live subtitles and center-justifies pre-recorded subtitles. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlignment() {
            return null;
        }

        /**
         * Specifies the color of the rectangle behind the captions.
         * <p>
         * All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBackgroundColor() {
            return null;
        }

        /**
         * Specifies the opacity of the background rectangle.
         * <p>
         * 255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBackgroundOpacity() {
            return null;
        }

        /**
         * The external font file that is used for captions burn-in.
         * <p>
         * The file extension must be .ttf or .tte. Although you can select output fonts for many different types of input captions, embedded, STL, and Teletext sources use a strict grid system. Using external fonts with these captions sources could cause an unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFont() {
            return null;
        }

        /**
         * Specifies the color of the burned-in captions.
         * <p>
         * This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFontColor() {
            return null;
        }

        /**
         * Specifies the opacity of the burned-in captions.
         * <p>
         * 255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFontOpacity() {
            return null;
        }

        /**
         * The font resolution in DPI (dots per inch).
         * <p>
         * The default is 96 dpi. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFontResolution() {
            return null;
        }

        /**
         * When set to auto, fontSize scales depending on the size of the output.
         * <p>
         * Providing a positive integer specifies the exact font size in points. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFontSize() {
            return null;
        }

        /**
         * Specifies the font outline color.
         * <p>
         * This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutlineColor() {
            return null;
        }

        /**
         * Specifies font outline size in pixels.
         * <p>
         * This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOutlineSize() {
            return null;
        }

        /**
         * Specifies the color of the shadow cast by the captions.
         * <p>
         * All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShadowColor() {
            return null;
        }

        /**
         * Specifies the opacity of the shadow.
         * <p>
         * 255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getShadowOpacity() {
            return null;
        }

        /**
         * Specifies the horizontal offset of the shadow that is relative to the captions in pixels.
         * <p>
         * A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getShadowXOffset() {
            return null;
        }

        /**
         * Specifies the vertical offset of the shadow that is relative to the captions in pixels.
         * <p>
         * A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getShadowYOffset() {
            return null;
        }

        /**
         * Controls whether a fixed grid size is used to generate the output subtitles bitmap.
         * <p>
         * This applies only to Teletext inputs and DVB-Sub/Burn-in outputs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTeletextGridControl() {
            return null;
        }

        /**
         * Specifies the horizontal position of the captions relative to the left side of the output in pixels.
         * <p>
         * A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal captions position is determined by the alignment parameter. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getXPosition() {
            return null;
        }

        /**
         * Specifies the vertical position of the captions relative to the top of the output in pixels.
         * <p>
         * A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the captions are positioned towards the bottom of the output. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getYPosition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BurnInDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BurnInDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BurnInDestinationSettingsProperty> {
            java.lang.String alignment;
            java.lang.String backgroundColor;
            java.lang.Number backgroundOpacity;
            java.lang.Object font;
            java.lang.String fontColor;
            java.lang.Number fontOpacity;
            java.lang.Number fontResolution;
            java.lang.String fontSize;
            java.lang.String outlineColor;
            java.lang.Number outlineSize;
            java.lang.String shadowColor;
            java.lang.Number shadowOpacity;
            java.lang.Number shadowXOffset;
            java.lang.Number shadowYOffset;
            java.lang.String teletextGridControl;
            java.lang.Number xPosition;
            java.lang.Number yPosition;

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getAlignment}
             * @param alignment If no explicit xPosition or yPosition is provided, setting alignment to centered places the captions at the bottom center of the output.
             *                  Similarly, setting a left alignment aligns captions to the bottom left of the output. If x and y positions are specified in conjunction with the alignment parameter, the font is justified (either left or centered) relative to those coordinates. Selecting "smart" justification left-justifies live subtitles and center-justifies pre-recorded subtitles. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alignment(java.lang.String alignment) {
                this.alignment = alignment;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getBackgroundColor}
             * @param backgroundColor Specifies the color of the rectangle behind the captions.
             *                        All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backgroundColor(java.lang.String backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getBackgroundOpacity}
             * @param backgroundOpacity Specifies the opacity of the background rectangle.
             *                          255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backgroundOpacity(java.lang.Number backgroundOpacity) {
                this.backgroundOpacity = backgroundOpacity;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getFont}
             * @param font The external font file that is used for captions burn-in.
             *             The file extension must be .ttf or .tte. Although you can select output fonts for many different types of input captions, embedded, STL, and Teletext sources use a strict grid system. Using external fonts with these captions sources could cause an unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder font(software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty font) {
                this.font = font;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getFont}
             * @param font The external font file that is used for captions burn-in.
             *             The file extension must be .ttf or .tte. Although you can select output fonts for many different types of input captions, embedded, STL, and Teletext sources use a strict grid system. Using external fonts with these captions sources could cause an unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder font(software.amazon.awscdk.IResolvable font) {
                this.font = font;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getFontColor}
             * @param fontColor Specifies the color of the burned-in captions.
             *                  This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontColor(java.lang.String fontColor) {
                this.fontColor = fontColor;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getFontOpacity}
             * @param fontOpacity Specifies the opacity of the burned-in captions.
             *                    255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontOpacity(java.lang.Number fontOpacity) {
                this.fontOpacity = fontOpacity;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getFontResolution}
             * @param fontResolution The font resolution in DPI (dots per inch).
             *                       The default is 96 dpi. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontResolution(java.lang.Number fontResolution) {
                this.fontResolution = fontResolution;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getFontSize}
             * @param fontSize When set to auto, fontSize scales depending on the size of the output.
             *                 Providing a positive integer specifies the exact font size in points. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontSize(java.lang.String fontSize) {
                this.fontSize = fontSize;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getOutlineColor}
             * @param outlineColor Specifies the font outline color.
             *                     This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outlineColor(java.lang.String outlineColor) {
                this.outlineColor = outlineColor;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getOutlineSize}
             * @param outlineSize Specifies font outline size in pixels.
             *                    This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outlineSize(java.lang.Number outlineSize) {
                this.outlineSize = outlineSize;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getShadowColor}
             * @param shadowColor Specifies the color of the shadow cast by the captions.
             *                    All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shadowColor(java.lang.String shadowColor) {
                this.shadowColor = shadowColor;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getShadowOpacity}
             * @param shadowOpacity Specifies the opacity of the shadow.
             *                      255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shadowOpacity(java.lang.Number shadowOpacity) {
                this.shadowOpacity = shadowOpacity;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getShadowXOffset}
             * @param shadowXOffset Specifies the horizontal offset of the shadow that is relative to the captions in pixels.
             *                      A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shadowXOffset(java.lang.Number shadowXOffset) {
                this.shadowXOffset = shadowXOffset;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getShadowYOffset}
             * @param shadowYOffset Specifies the vertical offset of the shadow that is relative to the captions in pixels.
             *                      A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shadowYOffset(java.lang.Number shadowYOffset) {
                this.shadowYOffset = shadowYOffset;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getTeletextGridControl}
             * @param teletextGridControl Controls whether a fixed grid size is used to generate the output subtitles bitmap.
             *                            This applies only to Teletext inputs and DVB-Sub/Burn-in outputs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder teletextGridControl(java.lang.String teletextGridControl) {
                this.teletextGridControl = teletextGridControl;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getXPosition}
             * @param xPosition Specifies the horizontal position of the captions relative to the left side of the output in pixels.
             *                  A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal captions position is determined by the alignment parameter. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder xPosition(java.lang.Number xPosition) {
                this.xPosition = xPosition;
                return this;
            }

            /**
             * Sets the value of {@link BurnInDestinationSettingsProperty#getYPosition}
             * @param yPosition Specifies the vertical position of the captions relative to the top of the output in pixels.
             *                  A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the captions are positioned towards the bottom of the output. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder yPosition(java.lang.Number yPosition) {
                this.yPosition = yPosition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BurnInDestinationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BurnInDestinationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BurnInDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BurnInDestinationSettingsProperty {
            private final java.lang.String alignment;
            private final java.lang.String backgroundColor;
            private final java.lang.Number backgroundOpacity;
            private final java.lang.Object font;
            private final java.lang.String fontColor;
            private final java.lang.Number fontOpacity;
            private final java.lang.Number fontResolution;
            private final java.lang.String fontSize;
            private final java.lang.String outlineColor;
            private final java.lang.Number outlineSize;
            private final java.lang.String shadowColor;
            private final java.lang.Number shadowOpacity;
            private final java.lang.Number shadowXOffset;
            private final java.lang.Number shadowYOffset;
            private final java.lang.String teletextGridControl;
            private final java.lang.Number xPosition;
            private final java.lang.Number yPosition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alignment = software.amazon.jsii.Kernel.get(this, "alignment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.backgroundColor = software.amazon.jsii.Kernel.get(this, "backgroundColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.backgroundOpacity = software.amazon.jsii.Kernel.get(this, "backgroundOpacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.font = software.amazon.jsii.Kernel.get(this, "font", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fontColor = software.amazon.jsii.Kernel.get(this, "fontColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fontOpacity = software.amazon.jsii.Kernel.get(this, "fontOpacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.fontResolution = software.amazon.jsii.Kernel.get(this, "fontResolution", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.fontSize = software.amazon.jsii.Kernel.get(this, "fontSize", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outlineColor = software.amazon.jsii.Kernel.get(this, "outlineColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outlineSize = software.amazon.jsii.Kernel.get(this, "outlineSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.shadowColor = software.amazon.jsii.Kernel.get(this, "shadowColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shadowOpacity = software.amazon.jsii.Kernel.get(this, "shadowOpacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.shadowXOffset = software.amazon.jsii.Kernel.get(this, "shadowXOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.shadowYOffset = software.amazon.jsii.Kernel.get(this, "shadowYOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.teletextGridControl = software.amazon.jsii.Kernel.get(this, "teletextGridControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.xPosition = software.amazon.jsii.Kernel.get(this, "xPosition", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.yPosition = software.amazon.jsii.Kernel.get(this, "yPosition", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alignment = builder.alignment;
                this.backgroundColor = builder.backgroundColor;
                this.backgroundOpacity = builder.backgroundOpacity;
                this.font = builder.font;
                this.fontColor = builder.fontColor;
                this.fontOpacity = builder.fontOpacity;
                this.fontResolution = builder.fontResolution;
                this.fontSize = builder.fontSize;
                this.outlineColor = builder.outlineColor;
                this.outlineSize = builder.outlineSize;
                this.shadowColor = builder.shadowColor;
                this.shadowOpacity = builder.shadowOpacity;
                this.shadowXOffset = builder.shadowXOffset;
                this.shadowYOffset = builder.shadowYOffset;
                this.teletextGridControl = builder.teletextGridControl;
                this.xPosition = builder.xPosition;
                this.yPosition = builder.yPosition;
            }

            @Override
            public final java.lang.String getAlignment() {
                return this.alignment;
            }

            @Override
            public final java.lang.String getBackgroundColor() {
                return this.backgroundColor;
            }

            @Override
            public final java.lang.Number getBackgroundOpacity() {
                return this.backgroundOpacity;
            }

            @Override
            public final java.lang.Object getFont() {
                return this.font;
            }

            @Override
            public final java.lang.String getFontColor() {
                return this.fontColor;
            }

            @Override
            public final java.lang.Number getFontOpacity() {
                return this.fontOpacity;
            }

            @Override
            public final java.lang.Number getFontResolution() {
                return this.fontResolution;
            }

            @Override
            public final java.lang.String getFontSize() {
                return this.fontSize;
            }

            @Override
            public final java.lang.String getOutlineColor() {
                return this.outlineColor;
            }

            @Override
            public final java.lang.Number getOutlineSize() {
                return this.outlineSize;
            }

            @Override
            public final java.lang.String getShadowColor() {
                return this.shadowColor;
            }

            @Override
            public final java.lang.Number getShadowOpacity() {
                return this.shadowOpacity;
            }

            @Override
            public final java.lang.Number getShadowXOffset() {
                return this.shadowXOffset;
            }

            @Override
            public final java.lang.Number getShadowYOffset() {
                return this.shadowYOffset;
            }

            @Override
            public final java.lang.String getTeletextGridControl() {
                return this.teletextGridControl;
            }

            @Override
            public final java.lang.Number getXPosition() {
                return this.xPosition;
            }

            @Override
            public final java.lang.Number getYPosition() {
                return this.yPosition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlignment() != null) {
                    data.set("alignment", om.valueToTree(this.getAlignment()));
                }
                if (this.getBackgroundColor() != null) {
                    data.set("backgroundColor", om.valueToTree(this.getBackgroundColor()));
                }
                if (this.getBackgroundOpacity() != null) {
                    data.set("backgroundOpacity", om.valueToTree(this.getBackgroundOpacity()));
                }
                if (this.getFont() != null) {
                    data.set("font", om.valueToTree(this.getFont()));
                }
                if (this.getFontColor() != null) {
                    data.set("fontColor", om.valueToTree(this.getFontColor()));
                }
                if (this.getFontOpacity() != null) {
                    data.set("fontOpacity", om.valueToTree(this.getFontOpacity()));
                }
                if (this.getFontResolution() != null) {
                    data.set("fontResolution", om.valueToTree(this.getFontResolution()));
                }
                if (this.getFontSize() != null) {
                    data.set("fontSize", om.valueToTree(this.getFontSize()));
                }
                if (this.getOutlineColor() != null) {
                    data.set("outlineColor", om.valueToTree(this.getOutlineColor()));
                }
                if (this.getOutlineSize() != null) {
                    data.set("outlineSize", om.valueToTree(this.getOutlineSize()));
                }
                if (this.getShadowColor() != null) {
                    data.set("shadowColor", om.valueToTree(this.getShadowColor()));
                }
                if (this.getShadowOpacity() != null) {
                    data.set("shadowOpacity", om.valueToTree(this.getShadowOpacity()));
                }
                if (this.getShadowXOffset() != null) {
                    data.set("shadowXOffset", om.valueToTree(this.getShadowXOffset()));
                }
                if (this.getShadowYOffset() != null) {
                    data.set("shadowYOffset", om.valueToTree(this.getShadowYOffset()));
                }
                if (this.getTeletextGridControl() != null) {
                    data.set("teletextGridControl", om.valueToTree(this.getTeletextGridControl()));
                }
                if (this.getXPosition() != null) {
                    data.set("xPosition", om.valueToTree(this.getXPosition()));
                }
                if (this.getYPosition() != null) {
                    data.set("yPosition", om.valueToTree(this.getYPosition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.BurnInDestinationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BurnInDestinationSettingsProperty.Jsii$Proxy that = (BurnInDestinationSettingsProperty.Jsii$Proxy) o;

                if (this.alignment != null ? !this.alignment.equals(that.alignment) : that.alignment != null) return false;
                if (this.backgroundColor != null ? !this.backgroundColor.equals(that.backgroundColor) : that.backgroundColor != null) return false;
                if (this.backgroundOpacity != null ? !this.backgroundOpacity.equals(that.backgroundOpacity) : that.backgroundOpacity != null) return false;
                if (this.font != null ? !this.font.equals(that.font) : that.font != null) return false;
                if (this.fontColor != null ? !this.fontColor.equals(that.fontColor) : that.fontColor != null) return false;
                if (this.fontOpacity != null ? !this.fontOpacity.equals(that.fontOpacity) : that.fontOpacity != null) return false;
                if (this.fontResolution != null ? !this.fontResolution.equals(that.fontResolution) : that.fontResolution != null) return false;
                if (this.fontSize != null ? !this.fontSize.equals(that.fontSize) : that.fontSize != null) return false;
                if (this.outlineColor != null ? !this.outlineColor.equals(that.outlineColor) : that.outlineColor != null) return false;
                if (this.outlineSize != null ? !this.outlineSize.equals(that.outlineSize) : that.outlineSize != null) return false;
                if (this.shadowColor != null ? !this.shadowColor.equals(that.shadowColor) : that.shadowColor != null) return false;
                if (this.shadowOpacity != null ? !this.shadowOpacity.equals(that.shadowOpacity) : that.shadowOpacity != null) return false;
                if (this.shadowXOffset != null ? !this.shadowXOffset.equals(that.shadowXOffset) : that.shadowXOffset != null) return false;
                if (this.shadowYOffset != null ? !this.shadowYOffset.equals(that.shadowYOffset) : that.shadowYOffset != null) return false;
                if (this.teletextGridControl != null ? !this.teletextGridControl.equals(that.teletextGridControl) : that.teletextGridControl != null) return false;
                if (this.xPosition != null ? !this.xPosition.equals(that.xPosition) : that.xPosition != null) return false;
                return this.yPosition != null ? this.yPosition.equals(that.yPosition) : that.yPosition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alignment != null ? this.alignment.hashCode() : 0;
                result = 31 * result + (this.backgroundColor != null ? this.backgroundColor.hashCode() : 0);
                result = 31 * result + (this.backgroundOpacity != null ? this.backgroundOpacity.hashCode() : 0);
                result = 31 * result + (this.font != null ? this.font.hashCode() : 0);
                result = 31 * result + (this.fontColor != null ? this.fontColor.hashCode() : 0);
                result = 31 * result + (this.fontOpacity != null ? this.fontOpacity.hashCode() : 0);
                result = 31 * result + (this.fontResolution != null ? this.fontResolution.hashCode() : 0);
                result = 31 * result + (this.fontSize != null ? this.fontSize.hashCode() : 0);
                result = 31 * result + (this.outlineColor != null ? this.outlineColor.hashCode() : 0);
                result = 31 * result + (this.outlineSize != null ? this.outlineSize.hashCode() : 0);
                result = 31 * result + (this.shadowColor != null ? this.shadowColor.hashCode() : 0);
                result = 31 * result + (this.shadowOpacity != null ? this.shadowOpacity.hashCode() : 0);
                result = 31 * result + (this.shadowXOffset != null ? this.shadowXOffset.hashCode() : 0);
                result = 31 * result + (this.shadowYOffset != null ? this.shadowYOffset.hashCode() : 0);
                result = 31 * result + (this.teletextGridControl != null ? this.teletextGridControl.hashCode() : 0);
                result = 31 * result + (this.xPosition != null ? this.xPosition.hashCode() : 0);
                result = 31 * result + (this.yPosition != null ? this.yPosition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The encoding information for output captions.
     * <p>
     * The parent of this entity is EncoderSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * CaptionDescriptionProperty captionDescriptionProperty = CaptionDescriptionProperty.builder()
     *         .captionSelectorName("captionSelectorName")
     *         .destinationSettings(CaptionDestinationSettingsProperty.builder()
     *                 .aribDestinationSettings(AribDestinationSettingsProperty.builder().build())
     *                 .burnInDestinationSettings(BurnInDestinationSettingsProperty.builder()
     *                         .alignment("alignment")
     *                         .backgroundColor("backgroundColor")
     *                         .backgroundOpacity(123)
     *                         .font(InputLocationProperty.builder()
     *                                 .passwordParam("passwordParam")
     *                                 .uri("uri")
     *                                 .username("username")
     *                                 .build())
     *                         .fontColor("fontColor")
     *                         .fontOpacity(123)
     *                         .fontResolution(123)
     *                         .fontSize("fontSize")
     *                         .outlineColor("outlineColor")
     *                         .outlineSize(123)
     *                         .shadowColor("shadowColor")
     *                         .shadowOpacity(123)
     *                         .shadowXOffset(123)
     *                         .shadowYOffset(123)
     *                         .teletextGridControl("teletextGridControl")
     *                         .xPosition(123)
     *                         .yPosition(123)
     *                         .build())
     *                 .dvbSubDestinationSettings(DvbSubDestinationSettingsProperty.builder()
     *                         .alignment("alignment")
     *                         .backgroundColor("backgroundColor")
     *                         .backgroundOpacity(123)
     *                         .font(InputLocationProperty.builder()
     *                                 .passwordParam("passwordParam")
     *                                 .uri("uri")
     *                                 .username("username")
     *                                 .build())
     *                         .fontColor("fontColor")
     *                         .fontOpacity(123)
     *                         .fontResolution(123)
     *                         .fontSize("fontSize")
     *                         .outlineColor("outlineColor")
     *                         .outlineSize(123)
     *                         .shadowColor("shadowColor")
     *                         .shadowOpacity(123)
     *                         .shadowXOffset(123)
     *                         .shadowYOffset(123)
     *                         .teletextGridControl("teletextGridControl")
     *                         .xPosition(123)
     *                         .yPosition(123)
     *                         .build())
     *                 .ebuTtDDestinationSettings(EbuTtDDestinationSettingsProperty.builder()
     *                         .copyrightHolder("copyrightHolder")
     *                         .fillLineGap("fillLineGap")
     *                         .fontFamily("fontFamily")
     *                         .styleControl("styleControl")
     *                         .build())
     *                 .embeddedDestinationSettings(EmbeddedDestinationSettingsProperty.builder().build())
     *                 .embeddedPlusScte20DestinationSettings(EmbeddedPlusScte20DestinationSettingsProperty.builder().build())
     *                 .rtmpCaptionInfoDestinationSettings(RtmpCaptionInfoDestinationSettingsProperty.builder().build())
     *                 .scte20PlusEmbeddedDestinationSettings(Scte20PlusEmbeddedDestinationSettingsProperty.builder().build())
     *                 .scte27DestinationSettings(Scte27DestinationSettingsProperty.builder().build())
     *                 .smpteTtDestinationSettings(SmpteTtDestinationSettingsProperty.builder().build())
     *                 .teletextDestinationSettings(TeletextDestinationSettingsProperty.builder().build())
     *                 .ttmlDestinationSettings(TtmlDestinationSettingsProperty.builder()
     *                         .styleControl("styleControl")
     *                         .build())
     *                 .webvttDestinationSettings(WebvttDestinationSettingsProperty.builder()
     *                         .styleControl("styleControl")
     *                         .build())
     *                 .build())
     *         .languageCode("languageCode")
     *         .languageDescription("languageDescription")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.CaptionDescriptionProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptionDescriptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptionDescriptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies which input captions selector to use as a captions source when generating output captions.
         * <p>
         * This field should match a captionSelector name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCaptionSelectorName() {
            return null;
        }

        /**
         * Additional settings for a captions destination that depend on the destination type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationSettings() {
            return null;
        }

        /**
         * An ISO 639-2 three-digit code.
         * <p>
         * For more information, see http://www.loc.gov/standards/iso639-2/.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageCode() {
            return null;
        }

        /**
         * Human-readable information to indicate the captions that are available for players (for example, English or Spanish).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageDescription() {
            return null;
        }

        /**
         * The name of the captions description.
         * <p>
         * The name is used to associate a captions description with an output. Names must be unique within a channel.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptionDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptionDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptionDescriptionProperty> {
            java.lang.String captionSelectorName;
            java.lang.Object destinationSettings;
            java.lang.String languageCode;
            java.lang.String languageDescription;
            java.lang.String name;

            /**
             * Sets the value of {@link CaptionDescriptionProperty#getCaptionSelectorName}
             * @param captionSelectorName Specifies which input captions selector to use as a captions source when generating output captions.
             *                            This field should match a captionSelector name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captionSelectorName(java.lang.String captionSelectorName) {
                this.captionSelectorName = captionSelectorName;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDescriptionProperty#getDestinationSettings}
             * @param destinationSettings Additional settings for a captions destination that depend on the destination type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.CaptionDestinationSettingsProperty destinationSettings) {
                this.destinationSettings = destinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDescriptionProperty#getDestinationSettings}
             * @param destinationSettings Additional settings for a captions destination that depend on the destination type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationSettings(software.amazon.awscdk.IResolvable destinationSettings) {
                this.destinationSettings = destinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDescriptionProperty#getLanguageCode}
             * @param languageCode An ISO 639-2 three-digit code.
             *                     For more information, see http://www.loc.gov/standards/iso639-2/.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageCode(java.lang.String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDescriptionProperty#getLanguageDescription}
             * @param languageDescription Human-readable information to indicate the captions that are available for players (for example, English or Spanish).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageDescription(java.lang.String languageDescription) {
                this.languageDescription = languageDescription;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDescriptionProperty#getName}
             * @param name The name of the captions description.
             *             The name is used to associate a captions description with an output. Names must be unique within a channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptionDescriptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptionDescriptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptionDescriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptionDescriptionProperty {
            private final java.lang.String captionSelectorName;
            private final java.lang.Object destinationSettings;
            private final java.lang.String languageCode;
            private final java.lang.String languageDescription;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.captionSelectorName = software.amazon.jsii.Kernel.get(this, "captionSelectorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationSettings = software.amazon.jsii.Kernel.get(this, "destinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.languageCode = software.amazon.jsii.Kernel.get(this, "languageCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.languageDescription = software.amazon.jsii.Kernel.get(this, "languageDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.captionSelectorName = builder.captionSelectorName;
                this.destinationSettings = builder.destinationSettings;
                this.languageCode = builder.languageCode;
                this.languageDescription = builder.languageDescription;
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getCaptionSelectorName() {
                return this.captionSelectorName;
            }

            @Override
            public final java.lang.Object getDestinationSettings() {
                return this.destinationSettings;
            }

            @Override
            public final java.lang.String getLanguageCode() {
                return this.languageCode;
            }

            @Override
            public final java.lang.String getLanguageDescription() {
                return this.languageDescription;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCaptionSelectorName() != null) {
                    data.set("captionSelectorName", om.valueToTree(this.getCaptionSelectorName()));
                }
                if (this.getDestinationSettings() != null) {
                    data.set("destinationSettings", om.valueToTree(this.getDestinationSettings()));
                }
                if (this.getLanguageCode() != null) {
                    data.set("languageCode", om.valueToTree(this.getLanguageCode()));
                }
                if (this.getLanguageDescription() != null) {
                    data.set("languageDescription", om.valueToTree(this.getLanguageDescription()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.CaptionDescriptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptionDescriptionProperty.Jsii$Proxy that = (CaptionDescriptionProperty.Jsii$Proxy) o;

                if (this.captionSelectorName != null ? !this.captionSelectorName.equals(that.captionSelectorName) : that.captionSelectorName != null) return false;
                if (this.destinationSettings != null ? !this.destinationSettings.equals(that.destinationSettings) : that.destinationSettings != null) return false;
                if (this.languageCode != null ? !this.languageCode.equals(that.languageCode) : that.languageCode != null) return false;
                if (this.languageDescription != null ? !this.languageDescription.equals(that.languageDescription) : that.languageDescription != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.captionSelectorName != null ? this.captionSelectorName.hashCode() : 0;
                result = 31 * result + (this.destinationSettings != null ? this.destinationSettings.hashCode() : 0);
                result = 31 * result + (this.languageCode != null ? this.languageCode.hashCode() : 0);
                result = 31 * result + (this.languageDescription != null ? this.languageDescription.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of one captions encode in the output.
     * <p>
     * The parent of this entity is CaptionDescription.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * CaptionDestinationSettingsProperty captionDestinationSettingsProperty = CaptionDestinationSettingsProperty.builder()
     *         .aribDestinationSettings(AribDestinationSettingsProperty.builder().build())
     *         .burnInDestinationSettings(BurnInDestinationSettingsProperty.builder()
     *                 .alignment("alignment")
     *                 .backgroundColor("backgroundColor")
     *                 .backgroundOpacity(123)
     *                 .font(InputLocationProperty.builder()
     *                         .passwordParam("passwordParam")
     *                         .uri("uri")
     *                         .username("username")
     *                         .build())
     *                 .fontColor("fontColor")
     *                 .fontOpacity(123)
     *                 .fontResolution(123)
     *                 .fontSize("fontSize")
     *                 .outlineColor("outlineColor")
     *                 .outlineSize(123)
     *                 .shadowColor("shadowColor")
     *                 .shadowOpacity(123)
     *                 .shadowXOffset(123)
     *                 .shadowYOffset(123)
     *                 .teletextGridControl("teletextGridControl")
     *                 .xPosition(123)
     *                 .yPosition(123)
     *                 .build())
     *         .dvbSubDestinationSettings(DvbSubDestinationSettingsProperty.builder()
     *                 .alignment("alignment")
     *                 .backgroundColor("backgroundColor")
     *                 .backgroundOpacity(123)
     *                 .font(InputLocationProperty.builder()
     *                         .passwordParam("passwordParam")
     *                         .uri("uri")
     *                         .username("username")
     *                         .build())
     *                 .fontColor("fontColor")
     *                 .fontOpacity(123)
     *                 .fontResolution(123)
     *                 .fontSize("fontSize")
     *                 .outlineColor("outlineColor")
     *                 .outlineSize(123)
     *                 .shadowColor("shadowColor")
     *                 .shadowOpacity(123)
     *                 .shadowXOffset(123)
     *                 .shadowYOffset(123)
     *                 .teletextGridControl("teletextGridControl")
     *                 .xPosition(123)
     *                 .yPosition(123)
     *                 .build())
     *         .ebuTtDDestinationSettings(EbuTtDDestinationSettingsProperty.builder()
     *                 .copyrightHolder("copyrightHolder")
     *                 .fillLineGap("fillLineGap")
     *                 .fontFamily("fontFamily")
     *                 .styleControl("styleControl")
     *                 .build())
     *         .embeddedDestinationSettings(EmbeddedDestinationSettingsProperty.builder().build())
     *         .embeddedPlusScte20DestinationSettings(EmbeddedPlusScte20DestinationSettingsProperty.builder().build())
     *         .rtmpCaptionInfoDestinationSettings(RtmpCaptionInfoDestinationSettingsProperty.builder().build())
     *         .scte20PlusEmbeddedDestinationSettings(Scte20PlusEmbeddedDestinationSettingsProperty.builder().build())
     *         .scte27DestinationSettings(Scte27DestinationSettingsProperty.builder().build())
     *         .smpteTtDestinationSettings(SmpteTtDestinationSettingsProperty.builder().build())
     *         .teletextDestinationSettings(TeletextDestinationSettingsProperty.builder().build())
     *         .ttmlDestinationSettings(TtmlDestinationSettingsProperty.builder()
     *                 .styleControl("styleControl")
     *                 .build())
     *         .webvttDestinationSettings(WebvttDestinationSettingsProperty.builder()
     *                 .styleControl("styleControl")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.CaptionDestinationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptionDestinationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptionDestinationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of one ARIB captions encode in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAribDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one burn-in captions encode in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBurnInDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one DVB Sub captions encode in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDvbSubDestinationSettings() {
            return null;
        }

        /**
         * Settings for EBU-TT captions in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbuTtDDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one embedded captions encode in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmbeddedDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one embedded plus SCTE-20 captions encode in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmbeddedPlusScte20DestinationSettings() {
            return null;
        }

        /**
         * The configuration of one RTMPCaptionInfo captions encode in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRtmpCaptionInfoDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one SCTE20 plus embedded captions encode in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScte20PlusEmbeddedDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one SCTE-27 captions encode in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScte27DestinationSettings() {
            return null;
        }

        /**
         * The configuration of one SMPTE-TT captions encode in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSmpteTtDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one Teletext captions encode in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTeletextDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one TTML captions encode in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTtmlDestinationSettings() {
            return null;
        }

        /**
         * The configuration of one WebVTT captions encode in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWebvttDestinationSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptionDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptionDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptionDestinationSettingsProperty> {
            java.lang.Object aribDestinationSettings;
            java.lang.Object burnInDestinationSettings;
            java.lang.Object dvbSubDestinationSettings;
            java.lang.Object ebuTtDDestinationSettings;
            java.lang.Object embeddedDestinationSettings;
            java.lang.Object embeddedPlusScte20DestinationSettings;
            java.lang.Object rtmpCaptionInfoDestinationSettings;
            java.lang.Object scte20PlusEmbeddedDestinationSettings;
            java.lang.Object scte27DestinationSettings;
            java.lang.Object smpteTtDestinationSettings;
            java.lang.Object teletextDestinationSettings;
            java.lang.Object ttmlDestinationSettings;
            java.lang.Object webvttDestinationSettings;

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getAribDestinationSettings}
             * @param aribDestinationSettings The configuration of one ARIB captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aribDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.AribDestinationSettingsProperty aribDestinationSettings) {
                this.aribDestinationSettings = aribDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getAribDestinationSettings}
             * @param aribDestinationSettings The configuration of one ARIB captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aribDestinationSettings(software.amazon.awscdk.IResolvable aribDestinationSettings) {
                this.aribDestinationSettings = aribDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getBurnInDestinationSettings}
             * @param burnInDestinationSettings The configuration of one burn-in captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder burnInDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.BurnInDestinationSettingsProperty burnInDestinationSettings) {
                this.burnInDestinationSettings = burnInDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getBurnInDestinationSettings}
             * @param burnInDestinationSettings The configuration of one burn-in captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder burnInDestinationSettings(software.amazon.awscdk.IResolvable burnInDestinationSettings) {
                this.burnInDestinationSettings = burnInDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getDvbSubDestinationSettings}
             * @param dvbSubDestinationSettings The configuration of one DVB Sub captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dvbSubDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.DvbSubDestinationSettingsProperty dvbSubDestinationSettings) {
                this.dvbSubDestinationSettings = dvbSubDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getDvbSubDestinationSettings}
             * @param dvbSubDestinationSettings The configuration of one DVB Sub captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dvbSubDestinationSettings(software.amazon.awscdk.IResolvable dvbSubDestinationSettings) {
                this.dvbSubDestinationSettings = dvbSubDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getEbuTtDDestinationSettings}
             * @param ebuTtDDestinationSettings Settings for EBU-TT captions in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebuTtDDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.EbuTtDDestinationSettingsProperty ebuTtDDestinationSettings) {
                this.ebuTtDDestinationSettings = ebuTtDDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getEbuTtDDestinationSettings}
             * @param ebuTtDDestinationSettings Settings for EBU-TT captions in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebuTtDDestinationSettings(software.amazon.awscdk.IResolvable ebuTtDDestinationSettings) {
                this.ebuTtDDestinationSettings = ebuTtDDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getEmbeddedDestinationSettings}
             * @param embeddedDestinationSettings The configuration of one embedded captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddedDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.EmbeddedDestinationSettingsProperty embeddedDestinationSettings) {
                this.embeddedDestinationSettings = embeddedDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getEmbeddedDestinationSettings}
             * @param embeddedDestinationSettings The configuration of one embedded captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddedDestinationSettings(software.amazon.awscdk.IResolvable embeddedDestinationSettings) {
                this.embeddedDestinationSettings = embeddedDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getEmbeddedPlusScte20DestinationSettings}
             * @param embeddedPlusScte20DestinationSettings The configuration of one embedded plus SCTE-20 captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddedPlusScte20DestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty embeddedPlusScte20DestinationSettings) {
                this.embeddedPlusScte20DestinationSettings = embeddedPlusScte20DestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getEmbeddedPlusScte20DestinationSettings}
             * @param embeddedPlusScte20DestinationSettings The configuration of one embedded plus SCTE-20 captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddedPlusScte20DestinationSettings(software.amazon.awscdk.IResolvable embeddedPlusScte20DestinationSettings) {
                this.embeddedPlusScte20DestinationSettings = embeddedPlusScte20DestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getRtmpCaptionInfoDestinationSettings}
             * @param rtmpCaptionInfoDestinationSettings The configuration of one RTMPCaptionInfo captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rtmpCaptionInfoDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.RtmpCaptionInfoDestinationSettingsProperty rtmpCaptionInfoDestinationSettings) {
                this.rtmpCaptionInfoDestinationSettings = rtmpCaptionInfoDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getRtmpCaptionInfoDestinationSettings}
             * @param rtmpCaptionInfoDestinationSettings The configuration of one RTMPCaptionInfo captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rtmpCaptionInfoDestinationSettings(software.amazon.awscdk.IResolvable rtmpCaptionInfoDestinationSettings) {
                this.rtmpCaptionInfoDestinationSettings = rtmpCaptionInfoDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getScte20PlusEmbeddedDestinationSettings}
             * @param scte20PlusEmbeddedDestinationSettings The configuration of one SCTE20 plus embedded captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte20PlusEmbeddedDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.Scte20PlusEmbeddedDestinationSettingsProperty scte20PlusEmbeddedDestinationSettings) {
                this.scte20PlusEmbeddedDestinationSettings = scte20PlusEmbeddedDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getScte20PlusEmbeddedDestinationSettings}
             * @param scte20PlusEmbeddedDestinationSettings The configuration of one SCTE20 plus embedded captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte20PlusEmbeddedDestinationSettings(software.amazon.awscdk.IResolvable scte20PlusEmbeddedDestinationSettings) {
                this.scte20PlusEmbeddedDestinationSettings = scte20PlusEmbeddedDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getScte27DestinationSettings}
             * @param scte27DestinationSettings The configuration of one SCTE-27 captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte27DestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.Scte27DestinationSettingsProperty scte27DestinationSettings) {
                this.scte27DestinationSettings = scte27DestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getScte27DestinationSettings}
             * @param scte27DestinationSettings The configuration of one SCTE-27 captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte27DestinationSettings(software.amazon.awscdk.IResolvable scte27DestinationSettings) {
                this.scte27DestinationSettings = scte27DestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getSmpteTtDestinationSettings}
             * @param smpteTtDestinationSettings The configuration of one SMPTE-TT captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smpteTtDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.SmpteTtDestinationSettingsProperty smpteTtDestinationSettings) {
                this.smpteTtDestinationSettings = smpteTtDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getSmpteTtDestinationSettings}
             * @param smpteTtDestinationSettings The configuration of one SMPTE-TT captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smpteTtDestinationSettings(software.amazon.awscdk.IResolvable smpteTtDestinationSettings) {
                this.smpteTtDestinationSettings = smpteTtDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getTeletextDestinationSettings}
             * @param teletextDestinationSettings The configuration of one Teletext captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder teletextDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.TeletextDestinationSettingsProperty teletextDestinationSettings) {
                this.teletextDestinationSettings = teletextDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getTeletextDestinationSettings}
             * @param teletextDestinationSettings The configuration of one Teletext captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder teletextDestinationSettings(software.amazon.awscdk.IResolvable teletextDestinationSettings) {
                this.teletextDestinationSettings = teletextDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getTtmlDestinationSettings}
             * @param ttmlDestinationSettings The configuration of one TTML captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ttmlDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.TtmlDestinationSettingsProperty ttmlDestinationSettings) {
                this.ttmlDestinationSettings = ttmlDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getTtmlDestinationSettings}
             * @param ttmlDestinationSettings The configuration of one TTML captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ttmlDestinationSettings(software.amazon.awscdk.IResolvable ttmlDestinationSettings) {
                this.ttmlDestinationSettings = ttmlDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getWebvttDestinationSettings}
             * @param webvttDestinationSettings The configuration of one WebVTT captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webvttDestinationSettings(software.amazon.awscdk.services.medialive.CfnChannel.WebvttDestinationSettingsProperty webvttDestinationSettings) {
                this.webvttDestinationSettings = webvttDestinationSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionDestinationSettingsProperty#getWebvttDestinationSettings}
             * @param webvttDestinationSettings The configuration of one WebVTT captions encode in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webvttDestinationSettings(software.amazon.awscdk.IResolvable webvttDestinationSettings) {
                this.webvttDestinationSettings = webvttDestinationSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptionDestinationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptionDestinationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptionDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptionDestinationSettingsProperty {
            private final java.lang.Object aribDestinationSettings;
            private final java.lang.Object burnInDestinationSettings;
            private final java.lang.Object dvbSubDestinationSettings;
            private final java.lang.Object ebuTtDDestinationSettings;
            private final java.lang.Object embeddedDestinationSettings;
            private final java.lang.Object embeddedPlusScte20DestinationSettings;
            private final java.lang.Object rtmpCaptionInfoDestinationSettings;
            private final java.lang.Object scte20PlusEmbeddedDestinationSettings;
            private final java.lang.Object scte27DestinationSettings;
            private final java.lang.Object smpteTtDestinationSettings;
            private final java.lang.Object teletextDestinationSettings;
            private final java.lang.Object ttmlDestinationSettings;
            private final java.lang.Object webvttDestinationSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aribDestinationSettings = software.amazon.jsii.Kernel.get(this, "aribDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.burnInDestinationSettings = software.amazon.jsii.Kernel.get(this, "burnInDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dvbSubDestinationSettings = software.amazon.jsii.Kernel.get(this, "dvbSubDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ebuTtDDestinationSettings = software.amazon.jsii.Kernel.get(this, "ebuTtDDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.embeddedDestinationSettings = software.amazon.jsii.Kernel.get(this, "embeddedDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.embeddedPlusScte20DestinationSettings = software.amazon.jsii.Kernel.get(this, "embeddedPlusScte20DestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rtmpCaptionInfoDestinationSettings = software.amazon.jsii.Kernel.get(this, "rtmpCaptionInfoDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scte20PlusEmbeddedDestinationSettings = software.amazon.jsii.Kernel.get(this, "scte20PlusEmbeddedDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scte27DestinationSettings = software.amazon.jsii.Kernel.get(this, "scte27DestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.smpteTtDestinationSettings = software.amazon.jsii.Kernel.get(this, "smpteTtDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.teletextDestinationSettings = software.amazon.jsii.Kernel.get(this, "teletextDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ttmlDestinationSettings = software.amazon.jsii.Kernel.get(this, "ttmlDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.webvttDestinationSettings = software.amazon.jsii.Kernel.get(this, "webvttDestinationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aribDestinationSettings = builder.aribDestinationSettings;
                this.burnInDestinationSettings = builder.burnInDestinationSettings;
                this.dvbSubDestinationSettings = builder.dvbSubDestinationSettings;
                this.ebuTtDDestinationSettings = builder.ebuTtDDestinationSettings;
                this.embeddedDestinationSettings = builder.embeddedDestinationSettings;
                this.embeddedPlusScte20DestinationSettings = builder.embeddedPlusScte20DestinationSettings;
                this.rtmpCaptionInfoDestinationSettings = builder.rtmpCaptionInfoDestinationSettings;
                this.scte20PlusEmbeddedDestinationSettings = builder.scte20PlusEmbeddedDestinationSettings;
                this.scte27DestinationSettings = builder.scte27DestinationSettings;
                this.smpteTtDestinationSettings = builder.smpteTtDestinationSettings;
                this.teletextDestinationSettings = builder.teletextDestinationSettings;
                this.ttmlDestinationSettings = builder.ttmlDestinationSettings;
                this.webvttDestinationSettings = builder.webvttDestinationSettings;
            }

            @Override
            public final java.lang.Object getAribDestinationSettings() {
                return this.aribDestinationSettings;
            }

            @Override
            public final java.lang.Object getBurnInDestinationSettings() {
                return this.burnInDestinationSettings;
            }

            @Override
            public final java.lang.Object getDvbSubDestinationSettings() {
                return this.dvbSubDestinationSettings;
            }

            @Override
            public final java.lang.Object getEbuTtDDestinationSettings() {
                return this.ebuTtDDestinationSettings;
            }

            @Override
            public final java.lang.Object getEmbeddedDestinationSettings() {
                return this.embeddedDestinationSettings;
            }

            @Override
            public final java.lang.Object getEmbeddedPlusScte20DestinationSettings() {
                return this.embeddedPlusScte20DestinationSettings;
            }

            @Override
            public final java.lang.Object getRtmpCaptionInfoDestinationSettings() {
                return this.rtmpCaptionInfoDestinationSettings;
            }

            @Override
            public final java.lang.Object getScte20PlusEmbeddedDestinationSettings() {
                return this.scte20PlusEmbeddedDestinationSettings;
            }

            @Override
            public final java.lang.Object getScte27DestinationSettings() {
                return this.scte27DestinationSettings;
            }

            @Override
            public final java.lang.Object getSmpteTtDestinationSettings() {
                return this.smpteTtDestinationSettings;
            }

            @Override
            public final java.lang.Object getTeletextDestinationSettings() {
                return this.teletextDestinationSettings;
            }

            @Override
            public final java.lang.Object getTtmlDestinationSettings() {
                return this.ttmlDestinationSettings;
            }

            @Override
            public final java.lang.Object getWebvttDestinationSettings() {
                return this.webvttDestinationSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAribDestinationSettings() != null) {
                    data.set("aribDestinationSettings", om.valueToTree(this.getAribDestinationSettings()));
                }
                if (this.getBurnInDestinationSettings() != null) {
                    data.set("burnInDestinationSettings", om.valueToTree(this.getBurnInDestinationSettings()));
                }
                if (this.getDvbSubDestinationSettings() != null) {
                    data.set("dvbSubDestinationSettings", om.valueToTree(this.getDvbSubDestinationSettings()));
                }
                if (this.getEbuTtDDestinationSettings() != null) {
                    data.set("ebuTtDDestinationSettings", om.valueToTree(this.getEbuTtDDestinationSettings()));
                }
                if (this.getEmbeddedDestinationSettings() != null) {
                    data.set("embeddedDestinationSettings", om.valueToTree(this.getEmbeddedDestinationSettings()));
                }
                if (this.getEmbeddedPlusScte20DestinationSettings() != null) {
                    data.set("embeddedPlusScte20DestinationSettings", om.valueToTree(this.getEmbeddedPlusScte20DestinationSettings()));
                }
                if (this.getRtmpCaptionInfoDestinationSettings() != null) {
                    data.set("rtmpCaptionInfoDestinationSettings", om.valueToTree(this.getRtmpCaptionInfoDestinationSettings()));
                }
                if (this.getScte20PlusEmbeddedDestinationSettings() != null) {
                    data.set("scte20PlusEmbeddedDestinationSettings", om.valueToTree(this.getScte20PlusEmbeddedDestinationSettings()));
                }
                if (this.getScte27DestinationSettings() != null) {
                    data.set("scte27DestinationSettings", om.valueToTree(this.getScte27DestinationSettings()));
                }
                if (this.getSmpteTtDestinationSettings() != null) {
                    data.set("smpteTtDestinationSettings", om.valueToTree(this.getSmpteTtDestinationSettings()));
                }
                if (this.getTeletextDestinationSettings() != null) {
                    data.set("teletextDestinationSettings", om.valueToTree(this.getTeletextDestinationSettings()));
                }
                if (this.getTtmlDestinationSettings() != null) {
                    data.set("ttmlDestinationSettings", om.valueToTree(this.getTtmlDestinationSettings()));
                }
                if (this.getWebvttDestinationSettings() != null) {
                    data.set("webvttDestinationSettings", om.valueToTree(this.getWebvttDestinationSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.CaptionDestinationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptionDestinationSettingsProperty.Jsii$Proxy that = (CaptionDestinationSettingsProperty.Jsii$Proxy) o;

                if (this.aribDestinationSettings != null ? !this.aribDestinationSettings.equals(that.aribDestinationSettings) : that.aribDestinationSettings != null) return false;
                if (this.burnInDestinationSettings != null ? !this.burnInDestinationSettings.equals(that.burnInDestinationSettings) : that.burnInDestinationSettings != null) return false;
                if (this.dvbSubDestinationSettings != null ? !this.dvbSubDestinationSettings.equals(that.dvbSubDestinationSettings) : that.dvbSubDestinationSettings != null) return false;
                if (this.ebuTtDDestinationSettings != null ? !this.ebuTtDDestinationSettings.equals(that.ebuTtDDestinationSettings) : that.ebuTtDDestinationSettings != null) return false;
                if (this.embeddedDestinationSettings != null ? !this.embeddedDestinationSettings.equals(that.embeddedDestinationSettings) : that.embeddedDestinationSettings != null) return false;
                if (this.embeddedPlusScte20DestinationSettings != null ? !this.embeddedPlusScte20DestinationSettings.equals(that.embeddedPlusScte20DestinationSettings) : that.embeddedPlusScte20DestinationSettings != null) return false;
                if (this.rtmpCaptionInfoDestinationSettings != null ? !this.rtmpCaptionInfoDestinationSettings.equals(that.rtmpCaptionInfoDestinationSettings) : that.rtmpCaptionInfoDestinationSettings != null) return false;
                if (this.scte20PlusEmbeddedDestinationSettings != null ? !this.scte20PlusEmbeddedDestinationSettings.equals(that.scte20PlusEmbeddedDestinationSettings) : that.scte20PlusEmbeddedDestinationSettings != null) return false;
                if (this.scte27DestinationSettings != null ? !this.scte27DestinationSettings.equals(that.scte27DestinationSettings) : that.scte27DestinationSettings != null) return false;
                if (this.smpteTtDestinationSettings != null ? !this.smpteTtDestinationSettings.equals(that.smpteTtDestinationSettings) : that.smpteTtDestinationSettings != null) return false;
                if (this.teletextDestinationSettings != null ? !this.teletextDestinationSettings.equals(that.teletextDestinationSettings) : that.teletextDestinationSettings != null) return false;
                if (this.ttmlDestinationSettings != null ? !this.ttmlDestinationSettings.equals(that.ttmlDestinationSettings) : that.ttmlDestinationSettings != null) return false;
                return this.webvttDestinationSettings != null ? this.webvttDestinationSettings.equals(that.webvttDestinationSettings) : that.webvttDestinationSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aribDestinationSettings != null ? this.aribDestinationSettings.hashCode() : 0;
                result = 31 * result + (this.burnInDestinationSettings != null ? this.burnInDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.dvbSubDestinationSettings != null ? this.dvbSubDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.ebuTtDDestinationSettings != null ? this.ebuTtDDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.embeddedDestinationSettings != null ? this.embeddedDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.embeddedPlusScte20DestinationSettings != null ? this.embeddedPlusScte20DestinationSettings.hashCode() : 0);
                result = 31 * result + (this.rtmpCaptionInfoDestinationSettings != null ? this.rtmpCaptionInfoDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.scte20PlusEmbeddedDestinationSettings != null ? this.scte20PlusEmbeddedDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.scte27DestinationSettings != null ? this.scte27DestinationSettings.hashCode() : 0);
                result = 31 * result + (this.smpteTtDestinationSettings != null ? this.smpteTtDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.teletextDestinationSettings != null ? this.teletextDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.ttmlDestinationSettings != null ? this.ttmlDestinationSettings.hashCode() : 0);
                result = 31 * result + (this.webvttDestinationSettings != null ? this.webvttDestinationSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Maps a captions channel to an ISO 693-2 language code (http://www.loc.gov/standards/iso639-2), with an optional description.
     * <p>
     * The parent of this entity is HlsGroupSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * CaptionLanguageMappingProperty captionLanguageMappingProperty = CaptionLanguageMappingProperty.builder()
     *         .captionChannel(123)
     *         .languageCode("languageCode")
     *         .languageDescription("languageDescription")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.CaptionLanguageMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptionLanguageMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptionLanguageMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The closed caption channel being described by this CaptionLanguageMapping.
         * <p>
         * Each channel mapping must have a unique channel number (maximum of 4).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCaptionChannel() {
            return null;
        }

        /**
         * A three-character ISO 639-2 language code (see http://www.loc.gov/standards/iso639-2).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageCode() {
            return null;
        }

        /**
         * The textual description of language.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptionLanguageMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptionLanguageMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptionLanguageMappingProperty> {
            java.lang.Number captionChannel;
            java.lang.String languageCode;
            java.lang.String languageDescription;

            /**
             * Sets the value of {@link CaptionLanguageMappingProperty#getCaptionChannel}
             * @param captionChannel The closed caption channel being described by this CaptionLanguageMapping.
             *                       Each channel mapping must have a unique channel number (maximum of 4).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captionChannel(java.lang.Number captionChannel) {
                this.captionChannel = captionChannel;
                return this;
            }

            /**
             * Sets the value of {@link CaptionLanguageMappingProperty#getLanguageCode}
             * @param languageCode A three-character ISO 639-2 language code (see http://www.loc.gov/standards/iso639-2).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageCode(java.lang.String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            /**
             * Sets the value of {@link CaptionLanguageMappingProperty#getLanguageDescription}
             * @param languageDescription The textual description of language.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageDescription(java.lang.String languageDescription) {
                this.languageDescription = languageDescription;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptionLanguageMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptionLanguageMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptionLanguageMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptionLanguageMappingProperty {
            private final java.lang.Number captionChannel;
            private final java.lang.String languageCode;
            private final java.lang.String languageDescription;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.captionChannel = software.amazon.jsii.Kernel.get(this, "captionChannel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.languageCode = software.amazon.jsii.Kernel.get(this, "languageCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.languageDescription = software.amazon.jsii.Kernel.get(this, "languageDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.captionChannel = builder.captionChannel;
                this.languageCode = builder.languageCode;
                this.languageDescription = builder.languageDescription;
            }

            @Override
            public final java.lang.Number getCaptionChannel() {
                return this.captionChannel;
            }

            @Override
            public final java.lang.String getLanguageCode() {
                return this.languageCode;
            }

            @Override
            public final java.lang.String getLanguageDescription() {
                return this.languageDescription;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCaptionChannel() != null) {
                    data.set("captionChannel", om.valueToTree(this.getCaptionChannel()));
                }
                if (this.getLanguageCode() != null) {
                    data.set("languageCode", om.valueToTree(this.getLanguageCode()));
                }
                if (this.getLanguageDescription() != null) {
                    data.set("languageDescription", om.valueToTree(this.getLanguageDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.CaptionLanguageMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptionLanguageMappingProperty.Jsii$Proxy that = (CaptionLanguageMappingProperty.Jsii$Proxy) o;

                if (this.captionChannel != null ? !this.captionChannel.equals(that.captionChannel) : that.captionChannel != null) return false;
                if (this.languageCode != null ? !this.languageCode.equals(that.languageCode) : that.languageCode != null) return false;
                return this.languageDescription != null ? this.languageDescription.equals(that.languageDescription) : that.languageDescription == null;
            }

            @Override
            public final int hashCode() {
                int result = this.captionChannel != null ? this.captionChannel.hashCode() : 0;
                result = 31 * result + (this.languageCode != null ? this.languageCode.hashCode() : 0);
                result = 31 * result + (this.languageDescription != null ? this.languageDescription.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings to configure the caption rectangle for an output captions that will be created using this Teletext source captions.
     * <p>
     * The parent of this entity is TeletextSourceSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * CaptionRectangleProperty captionRectangleProperty = CaptionRectangleProperty.builder()
     *         .height(123)
     *         .leftOffset(123)
     *         .topOffset(123)
     *         .width(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.CaptionRectangleProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptionRectangleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptionRectangleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * See the description in leftOffset.
         * <p>
         * For height, specify the entire height of the rectangle as a percentage of the underlying frame height. For example, "80" means the rectangle height is 80% of the underlying frame height. The topOffset and rectangleHeight must add up to 100% or less. This field corresponds to tts:extent - Y in the TTML standard.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHeight() {
            return null;
        }

        /**
         * Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output.
         * <p>
         * (Make sure to leave the default if you don't have either of these formats in the output.) You can define a display rectangle for the captions that is smaller than the underlying video frame. You define the rectangle by specifying the position of the left edge, top edge, bottom edge, and right edge of the rectangle, all within the underlying video frame. The units for the measurements are percentages. If you specify a value for one of these fields, you must specify a value for all of them.
         * <p>
         * For leftOffset, specify the position of the left edge of the rectangle, as a percentage of the underlying frame width, and relative to the left edge of the frame. For example, "10" means the measurement is 10% of the underlying frame width. The rectangle left edge starts at that position from the left edge of the frame. This field corresponds to tts:origin - X in the TTML standard.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLeftOffset() {
            return null;
        }

        /**
         * See the description in leftOffset.
         * <p>
         * For topOffset, specify the position of the top edge of the rectangle, as a percentage of the underlying frame height, and relative to the top edge of the frame. For example, "10" means the measurement is 10% of the underlying frame height. The rectangle top edge starts at that position from the top edge of the frame. This field corresponds to tts:origin - Y in the TTML standard.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTopOffset() {
            return null;
        }

        /**
         * See the description in leftOffset.
         * <p>
         * For width, specify the entire width of the rectangle as a percentage of the underlying frame width. For example, "80" means the rectangle width is 80% of the underlying frame width. The leftOffset and rectangleWidth must add up to 100% or less. This field corresponds to tts:extent - X in the TTML standard.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWidth() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptionRectangleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptionRectangleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptionRectangleProperty> {
            java.lang.Number height;
            java.lang.Number leftOffset;
            java.lang.Number topOffset;
            java.lang.Number width;

            /**
             * Sets the value of {@link CaptionRectangleProperty#getHeight}
             * @param height See the description in leftOffset.
             *               For height, specify the entire height of the rectangle as a percentage of the underlying frame height. For example, "80" means the rectangle height is 80% of the underlying frame height. The topOffset and rectangleHeight must add up to 100% or less. This field corresponds to tts:extent - Y in the TTML standard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder height(java.lang.Number height) {
                this.height = height;
                return this;
            }

            /**
             * Sets the value of {@link CaptionRectangleProperty#getLeftOffset}
             * @param leftOffset Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output.
             *                   (Make sure to leave the default if you don't have either of these formats in the output.) You can define a display rectangle for the captions that is smaller than the underlying video frame. You define the rectangle by specifying the position of the left edge, top edge, bottom edge, and right edge of the rectangle, all within the underlying video frame. The units for the measurements are percentages. If you specify a value for one of these fields, you must specify a value for all of them.
             *                   <p>
             *                   For leftOffset, specify the position of the left edge of the rectangle, as a percentage of the underlying frame width, and relative to the left edge of the frame. For example, "10" means the measurement is 10% of the underlying frame width. The rectangle left edge starts at that position from the left edge of the frame. This field corresponds to tts:origin - X in the TTML standard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder leftOffset(java.lang.Number leftOffset) {
                this.leftOffset = leftOffset;
                return this;
            }

            /**
             * Sets the value of {@link CaptionRectangleProperty#getTopOffset}
             * @param topOffset See the description in leftOffset.
             *                  For topOffset, specify the position of the top edge of the rectangle, as a percentage of the underlying frame height, and relative to the top edge of the frame. For example, "10" means the measurement is 10% of the underlying frame height. The rectangle top edge starts at that position from the top edge of the frame. This field corresponds to tts:origin - Y in the TTML standard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topOffset(java.lang.Number topOffset) {
                this.topOffset = topOffset;
                return this;
            }

            /**
             * Sets the value of {@link CaptionRectangleProperty#getWidth}
             * @param width See the description in leftOffset.
             *              For width, specify the entire width of the rectangle as a percentage of the underlying frame width. For example, "80" means the rectangle width is 80% of the underlying frame width. The leftOffset and rectangleWidth must add up to 100% or less. This field corresponds to tts:extent - X in the TTML standard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder width(java.lang.Number width) {
                this.width = width;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptionRectangleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptionRectangleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptionRectangleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptionRectangleProperty {
            private final java.lang.Number height;
            private final java.lang.Number leftOffset;
            private final java.lang.Number topOffset;
            private final java.lang.Number width;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.height = software.amazon.jsii.Kernel.get(this, "height", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.leftOffset = software.amazon.jsii.Kernel.get(this, "leftOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.topOffset = software.amazon.jsii.Kernel.get(this, "topOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.width = software.amazon.jsii.Kernel.get(this, "width", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.height = builder.height;
                this.leftOffset = builder.leftOffset;
                this.topOffset = builder.topOffset;
                this.width = builder.width;
            }

            @Override
            public final java.lang.Number getHeight() {
                return this.height;
            }

            @Override
            public final java.lang.Number getLeftOffset() {
                return this.leftOffset;
            }

            @Override
            public final java.lang.Number getTopOffset() {
                return this.topOffset;
            }

            @Override
            public final java.lang.Number getWidth() {
                return this.width;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHeight() != null) {
                    data.set("height", om.valueToTree(this.getHeight()));
                }
                if (this.getLeftOffset() != null) {
                    data.set("leftOffset", om.valueToTree(this.getLeftOffset()));
                }
                if (this.getTopOffset() != null) {
                    data.set("topOffset", om.valueToTree(this.getTopOffset()));
                }
                if (this.getWidth() != null) {
                    data.set("width", om.valueToTree(this.getWidth()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.CaptionRectangleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptionRectangleProperty.Jsii$Proxy that = (CaptionRectangleProperty.Jsii$Proxy) o;

                if (this.height != null ? !this.height.equals(that.height) : that.height != null) return false;
                if (this.leftOffset != null ? !this.leftOffset.equals(that.leftOffset) : that.leftOffset != null) return false;
                if (this.topOffset != null ? !this.topOffset.equals(that.topOffset) : that.topOffset != null) return false;
                return this.width != null ? this.width.equals(that.width) : that.width == null;
            }

            @Override
            public final int hashCode() {
                int result = this.height != null ? this.height.hashCode() : 0;
                result = 31 * result + (this.leftOffset != null ? this.leftOffset.hashCode() : 0);
                result = 31 * result + (this.topOffset != null ? this.topOffset.hashCode() : 0);
                result = 31 * result + (this.width != null ? this.width.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about one caption to extract from the input.
     * <p>
     * The parent of this entity is InputSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * CaptionSelectorProperty captionSelectorProperty = CaptionSelectorProperty.builder()
     *         .languageCode("languageCode")
     *         .name("name")
     *         .selectorSettings(CaptionSelectorSettingsProperty.builder()
     *                 .ancillarySourceSettings(AncillarySourceSettingsProperty.builder()
     *                         .sourceAncillaryChannelNumber(123)
     *                         .build())
     *                 .aribSourceSettings(AribSourceSettingsProperty.builder().build())
     *                 .dvbSubSourceSettings(DvbSubSourceSettingsProperty.builder()
     *                         .ocrLanguage("ocrLanguage")
     *                         .pid(123)
     *                         .build())
     *                 .embeddedSourceSettings(EmbeddedSourceSettingsProperty.builder()
     *                         .convert608To708("convert608To708")
     *                         .scte20Detection("scte20Detection")
     *                         .source608ChannelNumber(123)
     *                         .source608TrackNumber(123)
     *                         .build())
     *                 .scte20SourceSettings(Scte20SourceSettingsProperty.builder()
     *                         .convert608To708("convert608To708")
     *                         .source608ChannelNumber(123)
     *                         .build())
     *                 .scte27SourceSettings(Scte27SourceSettingsProperty.builder()
     *                         .ocrLanguage("ocrLanguage")
     *                         .pid(123)
     *                         .build())
     *                 .teletextSourceSettings(TeletextSourceSettingsProperty.builder()
     *                         .outputRectangle(CaptionRectangleProperty.builder()
     *                                 .height(123)
     *                                 .leftOffset(123)
     *                                 .topOffset(123)
     *                                 .width(123)
     *                                 .build())
     *                         .pageNumber("pageNumber")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.CaptionSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptionSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptionSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When specified, this field indicates the three-letter language code of the captions track to extract from the source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLanguageCode() {
            return null;
        }

        /**
         * The name identifier for a captions selector.
         * <p>
         * This name is used to associate this captions selector with one or more captions descriptions. Names must be unique within a channel.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * Information about the specific audio to extract from the input.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSelectorSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptionSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptionSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptionSelectorProperty> {
            java.lang.String languageCode;
            java.lang.String name;
            java.lang.Object selectorSettings;

            /**
             * Sets the value of {@link CaptionSelectorProperty#getLanguageCode}
             * @param languageCode When specified, this field indicates the three-letter language code of the captions track to extract from the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder languageCode(java.lang.String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorProperty#getName}
             * @param name The name identifier for a captions selector.
             *             This name is used to associate this captions selector with one or more captions descriptions. Names must be unique within a channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorProperty#getSelectorSettings}
             * @param selectorSettings Information about the specific audio to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectorSettings(software.amazon.awscdk.services.medialive.CfnChannel.CaptionSelectorSettingsProperty selectorSettings) {
                this.selectorSettings = selectorSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorProperty#getSelectorSettings}
             * @param selectorSettings Information about the specific audio to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selectorSettings(software.amazon.awscdk.IResolvable selectorSettings) {
                this.selectorSettings = selectorSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptionSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptionSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptionSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptionSelectorProperty {
            private final java.lang.String languageCode;
            private final java.lang.String name;
            private final java.lang.Object selectorSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.languageCode = software.amazon.jsii.Kernel.get(this, "languageCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.selectorSettings = software.amazon.jsii.Kernel.get(this, "selectorSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.languageCode = builder.languageCode;
                this.name = builder.name;
                this.selectorSettings = builder.selectorSettings;
            }

            @Override
            public final java.lang.String getLanguageCode() {
                return this.languageCode;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getSelectorSettings() {
                return this.selectorSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLanguageCode() != null) {
                    data.set("languageCode", om.valueToTree(this.getLanguageCode()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getSelectorSettings() != null) {
                    data.set("selectorSettings", om.valueToTree(this.getSelectorSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.CaptionSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptionSelectorProperty.Jsii$Proxy that = (CaptionSelectorProperty.Jsii$Proxy) o;

                if (this.languageCode != null ? !this.languageCode.equals(that.languageCode) : that.languageCode != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.selectorSettings != null ? this.selectorSettings.equals(that.selectorSettings) : that.selectorSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.languageCode != null ? this.languageCode.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.selectorSettings != null ? this.selectorSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Captions Selector Settings.
     * <p>
     * The parent of this entity is CaptionSelector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * CaptionSelectorSettingsProperty captionSelectorSettingsProperty = CaptionSelectorSettingsProperty.builder()
     *         .ancillarySourceSettings(AncillarySourceSettingsProperty.builder()
     *                 .sourceAncillaryChannelNumber(123)
     *                 .build())
     *         .aribSourceSettings(AribSourceSettingsProperty.builder().build())
     *         .dvbSubSourceSettings(DvbSubSourceSettingsProperty.builder()
     *                 .ocrLanguage("ocrLanguage")
     *                 .pid(123)
     *                 .build())
     *         .embeddedSourceSettings(EmbeddedSourceSettingsProperty.builder()
     *                 .convert608To708("convert608To708")
     *                 .scte20Detection("scte20Detection")
     *                 .source608ChannelNumber(123)
     *                 .source608TrackNumber(123)
     *                 .build())
     *         .scte20SourceSettings(Scte20SourceSettingsProperty.builder()
     *                 .convert608To708("convert608To708")
     *                 .source608ChannelNumber(123)
     *                 .build())
     *         .scte27SourceSettings(Scte27SourceSettingsProperty.builder()
     *                 .ocrLanguage("ocrLanguage")
     *                 .pid(123)
     *                 .build())
     *         .teletextSourceSettings(TeletextSourceSettingsProperty.builder()
     *                 .outputRectangle(CaptionRectangleProperty.builder()
     *                         .height(123)
     *                         .leftOffset(123)
     *                         .topOffset(123)
     *                         .width(123)
     *                         .build())
     *                 .pageNumber("pageNumber")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.CaptionSelectorSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptionSelectorSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptionSelectorSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about the ancillary captions to extract from the input.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAncillarySourceSettings() {
            return null;
        }

        /**
         * Information about the ARIB captions to extract from the input.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAribSourceSettings() {
            return null;
        }

        /**
         * Information about the DVB Sub captions to extract from the input.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDvbSubSourceSettings() {
            return null;
        }

        /**
         * Information about the embedded captions to extract from the input.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmbeddedSourceSettings() {
            return null;
        }

        /**
         * Information about the SCTE-20 captions to extract from the input.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScte20SourceSettings() {
            return null;
        }

        /**
         * Information about the SCTE-27 captions to extract from the input.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScte27SourceSettings() {
            return null;
        }

        /**
         * Information about the Teletext captions to extract from the input.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTeletextSourceSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptionSelectorSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptionSelectorSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptionSelectorSettingsProperty> {
            java.lang.Object ancillarySourceSettings;
            java.lang.Object aribSourceSettings;
            java.lang.Object dvbSubSourceSettings;
            java.lang.Object embeddedSourceSettings;
            java.lang.Object scte20SourceSettings;
            java.lang.Object scte27SourceSettings;
            java.lang.Object teletextSourceSettings;

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getAncillarySourceSettings}
             * @param ancillarySourceSettings Information about the ancillary captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ancillarySourceSettings(software.amazon.awscdk.services.medialive.CfnChannel.AncillarySourceSettingsProperty ancillarySourceSettings) {
                this.ancillarySourceSettings = ancillarySourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getAncillarySourceSettings}
             * @param ancillarySourceSettings Information about the ancillary captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ancillarySourceSettings(software.amazon.awscdk.IResolvable ancillarySourceSettings) {
                this.ancillarySourceSettings = ancillarySourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getAribSourceSettings}
             * @param aribSourceSettings Information about the ARIB captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aribSourceSettings(software.amazon.awscdk.services.medialive.CfnChannel.AribSourceSettingsProperty aribSourceSettings) {
                this.aribSourceSettings = aribSourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getAribSourceSettings}
             * @param aribSourceSettings Information about the ARIB captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aribSourceSettings(software.amazon.awscdk.IResolvable aribSourceSettings) {
                this.aribSourceSettings = aribSourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getDvbSubSourceSettings}
             * @param dvbSubSourceSettings Information about the DVB Sub captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dvbSubSourceSettings(software.amazon.awscdk.services.medialive.CfnChannel.DvbSubSourceSettingsProperty dvbSubSourceSettings) {
                this.dvbSubSourceSettings = dvbSubSourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getDvbSubSourceSettings}
             * @param dvbSubSourceSettings Information about the DVB Sub captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dvbSubSourceSettings(software.amazon.awscdk.IResolvable dvbSubSourceSettings) {
                this.dvbSubSourceSettings = dvbSubSourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getEmbeddedSourceSettings}
             * @param embeddedSourceSettings Information about the embedded captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddedSourceSettings(software.amazon.awscdk.services.medialive.CfnChannel.EmbeddedSourceSettingsProperty embeddedSourceSettings) {
                this.embeddedSourceSettings = embeddedSourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getEmbeddedSourceSettings}
             * @param embeddedSourceSettings Information about the embedded captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder embeddedSourceSettings(software.amazon.awscdk.IResolvable embeddedSourceSettings) {
                this.embeddedSourceSettings = embeddedSourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getScte20SourceSettings}
             * @param scte20SourceSettings Information about the SCTE-20 captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte20SourceSettings(software.amazon.awscdk.services.medialive.CfnChannel.Scte20SourceSettingsProperty scte20SourceSettings) {
                this.scte20SourceSettings = scte20SourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getScte20SourceSettings}
             * @param scte20SourceSettings Information about the SCTE-20 captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte20SourceSettings(software.amazon.awscdk.IResolvable scte20SourceSettings) {
                this.scte20SourceSettings = scte20SourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getScte27SourceSettings}
             * @param scte27SourceSettings Information about the SCTE-27 captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte27SourceSettings(software.amazon.awscdk.services.medialive.CfnChannel.Scte27SourceSettingsProperty scte27SourceSettings) {
                this.scte27SourceSettings = scte27SourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getScte27SourceSettings}
             * @param scte27SourceSettings Information about the SCTE-27 captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte27SourceSettings(software.amazon.awscdk.IResolvable scte27SourceSettings) {
                this.scte27SourceSettings = scte27SourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getTeletextSourceSettings}
             * @param teletextSourceSettings Information about the Teletext captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder teletextSourceSettings(software.amazon.awscdk.services.medialive.CfnChannel.TeletextSourceSettingsProperty teletextSourceSettings) {
                this.teletextSourceSettings = teletextSourceSettings;
                return this;
            }

            /**
             * Sets the value of {@link CaptionSelectorSettingsProperty#getTeletextSourceSettings}
             * @param teletextSourceSettings Information about the Teletext captions to extract from the input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder teletextSourceSettings(software.amazon.awscdk.IResolvable teletextSourceSettings) {
                this.teletextSourceSettings = teletextSourceSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptionSelectorSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptionSelectorSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptionSelectorSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptionSelectorSettingsProperty {
            private final java.lang.Object ancillarySourceSettings;
            private final java.lang.Object aribSourceSettings;
            private final java.lang.Object dvbSubSourceSettings;
            private final java.lang.Object embeddedSourceSettings;
            private final java.lang.Object scte20SourceSettings;
            private final java.lang.Object scte27SourceSettings;
            private final java.lang.Object teletextSourceSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ancillarySourceSettings = software.amazon.jsii.Kernel.get(this, "ancillarySourceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.aribSourceSettings = software.amazon.jsii.Kernel.get(this, "aribSourceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dvbSubSourceSettings = software.amazon.jsii.Kernel.get(this, "dvbSubSourceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.embeddedSourceSettings = software.amazon.jsii.Kernel.get(this, "embeddedSourceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scte20SourceSettings = software.amazon.jsii.Kernel.get(this, "scte20SourceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scte27SourceSettings = software.amazon.jsii.Kernel.get(this, "scte27SourceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.teletextSourceSettings = software.amazon.jsii.Kernel.get(this, "teletextSourceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ancillarySourceSettings = builder.ancillarySourceSettings;
                this.aribSourceSettings = builder.aribSourceSettings;
                this.dvbSubSourceSettings = builder.dvbSubSourceSettings;
                this.embeddedSourceSettings = builder.embeddedSourceSettings;
                this.scte20SourceSettings = builder.scte20SourceSettings;
                this.scte27SourceSettings = builder.scte27SourceSettings;
                this.teletextSourceSettings = builder.teletextSourceSettings;
            }

            @Override
            public final java.lang.Object getAncillarySourceSettings() {
                return this.ancillarySourceSettings;
            }

            @Override
            public final java.lang.Object getAribSourceSettings() {
                return this.aribSourceSettings;
            }

            @Override
            public final java.lang.Object getDvbSubSourceSettings() {
                return this.dvbSubSourceSettings;
            }

            @Override
            public final java.lang.Object getEmbeddedSourceSettings() {
                return this.embeddedSourceSettings;
            }

            @Override
            public final java.lang.Object getScte20SourceSettings() {
                return this.scte20SourceSettings;
            }

            @Override
            public final java.lang.Object getScte27SourceSettings() {
                return this.scte27SourceSettings;
            }

            @Override
            public final java.lang.Object getTeletextSourceSettings() {
                return this.teletextSourceSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAncillarySourceSettings() != null) {
                    data.set("ancillarySourceSettings", om.valueToTree(this.getAncillarySourceSettings()));
                }
                if (this.getAribSourceSettings() != null) {
                    data.set("aribSourceSettings", om.valueToTree(this.getAribSourceSettings()));
                }
                if (this.getDvbSubSourceSettings() != null) {
                    data.set("dvbSubSourceSettings", om.valueToTree(this.getDvbSubSourceSettings()));
                }
                if (this.getEmbeddedSourceSettings() != null) {
                    data.set("embeddedSourceSettings", om.valueToTree(this.getEmbeddedSourceSettings()));
                }
                if (this.getScte20SourceSettings() != null) {
                    data.set("scte20SourceSettings", om.valueToTree(this.getScte20SourceSettings()));
                }
                if (this.getScte27SourceSettings() != null) {
                    data.set("scte27SourceSettings", om.valueToTree(this.getScte27SourceSettings()));
                }
                if (this.getTeletextSourceSettings() != null) {
                    data.set("teletextSourceSettings", om.valueToTree(this.getTeletextSourceSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.CaptionSelectorSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptionSelectorSettingsProperty.Jsii$Proxy that = (CaptionSelectorSettingsProperty.Jsii$Proxy) o;

                if (this.ancillarySourceSettings != null ? !this.ancillarySourceSettings.equals(that.ancillarySourceSettings) : that.ancillarySourceSettings != null) return false;
                if (this.aribSourceSettings != null ? !this.aribSourceSettings.equals(that.aribSourceSettings) : that.aribSourceSettings != null) return false;
                if (this.dvbSubSourceSettings != null ? !this.dvbSubSourceSettings.equals(that.dvbSubSourceSettings) : that.dvbSubSourceSettings != null) return false;
                if (this.embeddedSourceSettings != null ? !this.embeddedSourceSettings.equals(that.embeddedSourceSettings) : that.embeddedSourceSettings != null) return false;
                if (this.scte20SourceSettings != null ? !this.scte20SourceSettings.equals(that.scte20SourceSettings) : that.scte20SourceSettings != null) return false;
                if (this.scte27SourceSettings != null ? !this.scte27SourceSettings.equals(that.scte27SourceSettings) : that.scte27SourceSettings != null) return false;
                return this.teletextSourceSettings != null ? this.teletextSourceSettings.equals(that.teletextSourceSettings) : that.teletextSourceSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ancillarySourceSettings != null ? this.ancillarySourceSettings.hashCode() : 0;
                result = 31 * result + (this.aribSourceSettings != null ? this.aribSourceSettings.hashCode() : 0);
                result = 31 * result + (this.dvbSubSourceSettings != null ? this.dvbSubSourceSettings.hashCode() : 0);
                result = 31 * result + (this.embeddedSourceSettings != null ? this.embeddedSourceSettings.hashCode() : 0);
                result = 31 * result + (this.scte20SourceSettings != null ? this.scte20SourceSettings.hashCode() : 0);
                result = 31 * result + (this.scte27SourceSettings != null ? this.scte27SourceSettings.hashCode() : 0);
                result = 31 * result + (this.teletextSourceSettings != null ? this.teletextSourceSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The input specification for this channel.
     * <p>
     * It specifies the key characteristics of CDI inputs for this channel, when those characteristics are different from other inputs.
     * <p>
     * This entity is at the top level in the channel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * CdiInputSpecificationProperty cdiInputSpecificationProperty = CdiInputSpecificationProperty.builder()
     *         .resolution("resolution")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.CdiInputSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CdiInputSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CdiInputSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Maximum CDI input resolution.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResolution() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CdiInputSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CdiInputSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CdiInputSpecificationProperty> {
            java.lang.String resolution;

            /**
             * Sets the value of {@link CdiInputSpecificationProperty#getResolution}
             * @param resolution Maximum CDI input resolution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resolution(java.lang.String resolution) {
                this.resolution = resolution;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CdiInputSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CdiInputSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CdiInputSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CdiInputSpecificationProperty {
            private final java.lang.String resolution;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resolution = software.amazon.jsii.Kernel.get(this, "resolution", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resolution = builder.resolution;
            }

            @Override
            public final java.lang.String getResolution() {
                return this.resolution;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResolution() != null) {
                    data.set("resolution", om.valueToTree(this.getResolution()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.CdiInputSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CdiInputSpecificationProperty.Jsii$Proxy that = (CdiInputSpecificationProperty.Jsii$Proxy) o;

                return this.resolution != null ? this.resolution.equals(that.resolution) : that.resolution == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resolution != null ? this.resolution.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Passthrough applies no color space conversion to the output.
     * <p>
     * The parents of this entity are H264ColorSpaceSettings and H265ColorSpaceSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * ColorSpacePassthroughSettingsProperty colorSpacePassthroughSettingsProperty = ColorSpacePassthroughSettingsProperty.builder().build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.ColorSpacePassthroughSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ColorSpacePassthroughSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColorSpacePassthroughSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link ColorSpacePassthroughSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColorSpacePassthroughSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColorSpacePassthroughSettingsProperty> {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColorSpacePassthroughSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColorSpacePassthroughSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColorSpacePassthroughSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColorSpacePassthroughSettingsProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.ColorSpacePassthroughSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }
        }
    }
    /**
     * The configuration of DVB NIT.
     * <p>
     * The parent of this entity is M2tsSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * DvbNitSettingsProperty dvbNitSettingsProperty = DvbNitSettingsProperty.builder()
     *         .networkId(123)
     *         .networkName("networkName")
     *         .repInterval(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.DvbNitSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DvbNitSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DvbNitSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The numeric value placed in the Network Information Table (NIT).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNetworkId() {
            return null;
        }

        /**
         * The network name text placed in the networkNameDescriptor inside the Network Information Table (NIT).
         * <p>
         * The maximum length is 256 characters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNetworkName() {
            return null;
        }

        /**
         * The number of milliseconds between instances of this table in the output transport stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRepInterval() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DvbNitSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DvbNitSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DvbNitSettingsProperty> {
            java.lang.Number networkId;
            java.lang.String networkName;
            java.lang.Number repInterval;

            /**
             * Sets the value of {@link DvbNitSettingsProperty#getNetworkId}
             * @param networkId The numeric value placed in the Network Information Table (NIT).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkId(java.lang.Number networkId) {
                this.networkId = networkId;
                return this;
            }

            /**
             * Sets the value of {@link DvbNitSettingsProperty#getNetworkName}
             * @param networkName The network name text placed in the networkNameDescriptor inside the Network Information Table (NIT).
             *                    The maximum length is 256 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkName(java.lang.String networkName) {
                this.networkName = networkName;
                return this;
            }

            /**
             * Sets the value of {@link DvbNitSettingsProperty#getRepInterval}
             * @param repInterval The number of milliseconds between instances of this table in the output transport stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repInterval(java.lang.Number repInterval) {
                this.repInterval = repInterval;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DvbNitSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DvbNitSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DvbNitSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DvbNitSettingsProperty {
            private final java.lang.Number networkId;
            private final java.lang.String networkName;
            private final java.lang.Number repInterval;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.networkId = software.amazon.jsii.Kernel.get(this, "networkId", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.networkName = software.amazon.jsii.Kernel.get(this, "networkName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.repInterval = software.amazon.jsii.Kernel.get(this, "repInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.networkId = builder.networkId;
                this.networkName = builder.networkName;
                this.repInterval = builder.repInterval;
            }

            @Override
            public final java.lang.Number getNetworkId() {
                return this.networkId;
            }

            @Override
            public final java.lang.String getNetworkName() {
                return this.networkName;
            }

            @Override
            public final java.lang.Number getRepInterval() {
                return this.repInterval;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNetworkId() != null) {
                    data.set("networkId", om.valueToTree(this.getNetworkId()));
                }
                if (this.getNetworkName() != null) {
                    data.set("networkName", om.valueToTree(this.getNetworkName()));
                }
                if (this.getRepInterval() != null) {
                    data.set("repInterval", om.valueToTree(this.getRepInterval()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.DvbNitSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DvbNitSettingsProperty.Jsii$Proxy that = (DvbNitSettingsProperty.Jsii$Proxy) o;

                if (this.networkId != null ? !this.networkId.equals(that.networkId) : that.networkId != null) return false;
                if (this.networkName != null ? !this.networkName.equals(that.networkName) : that.networkName != null) return false;
                return this.repInterval != null ? this.repInterval.equals(that.repInterval) : that.repInterval == null;
            }

            @Override
            public final int hashCode() {
                int result = this.networkId != null ? this.networkId.hashCode() : 0;
                result = 31 * result + (this.networkName != null ? this.networkName.hashCode() : 0);
                result = 31 * result + (this.repInterval != null ? this.repInterval.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A DVB Service Description Table (SDT).
     * <p>
     * The parent of this entity is M2tsSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * DvbSdtSettingsProperty dvbSdtSettingsProperty = DvbSdtSettingsProperty.builder()
     *         .outputSdt("outputSdt")
     *         .repInterval(123)
     *         .serviceName("serviceName")
     *         .serviceProviderName("serviceProviderName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.DvbSdtSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DvbSdtSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DvbSdtSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Selects a method of inserting SDT information into an output stream.
         * <p>
         * The sdtFollow setting copies SDT information from input stream to output stream. The sdtFollowIfPresent setting copies SDT information from input stream to output stream if SDT information is present in the input. Otherwise, it falls back on the user-defined values. The sdtManual setting means that the user will enter the SDT information. The sdtNone setting means that the output stream will not contain SDT information.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputSdt() {
            return null;
        }

        /**
         * The number of milliseconds between instances of this table in the output transport stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRepInterval() {
            return null;
        }

        /**
         * The service name placed in the serviceDescriptor in the Service Description Table (SDT).
         * <p>
         * The maximum length is 256 characters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
            return null;
        }

        /**
         * The service provider name placed in the serviceDescriptor in the Service Description Table (SDT).
         * <p>
         * The maximum length is 256 characters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceProviderName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DvbSdtSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DvbSdtSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DvbSdtSettingsProperty> {
            java.lang.String outputSdt;
            java.lang.Number repInterval;
            java.lang.String serviceName;
            java.lang.String serviceProviderName;

            /**
             * Sets the value of {@link DvbSdtSettingsProperty#getOutputSdt}
             * @param outputSdt Selects a method of inserting SDT information into an output stream.
             *                  The sdtFollow setting copies SDT information from input stream to output stream. The sdtFollowIfPresent setting copies SDT information from input stream to output stream if SDT information is present in the input. Otherwise, it falls back on the user-defined values. The sdtManual setting means that the user will enter the SDT information. The sdtNone setting means that the output stream will not contain SDT information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputSdt(java.lang.String outputSdt) {
                this.outputSdt = outputSdt;
                return this;
            }

            /**
             * Sets the value of {@link DvbSdtSettingsProperty#getRepInterval}
             * @param repInterval The number of milliseconds between instances of this table in the output transport stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repInterval(java.lang.Number repInterval) {
                this.repInterval = repInterval;
                return this;
            }

            /**
             * Sets the value of {@link DvbSdtSettingsProperty#getServiceName}
             * @param serviceName The service name placed in the serviceDescriptor in the Service Description Table (SDT).
             *                    The maximum length is 256 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceName(java.lang.String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            /**
             * Sets the value of {@link DvbSdtSettingsProperty#getServiceProviderName}
             * @param serviceProviderName The service provider name placed in the serviceDescriptor in the Service Description Table (SDT).
             *                            The maximum length is 256 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceProviderName(java.lang.String serviceProviderName) {
                this.serviceProviderName = serviceProviderName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DvbSdtSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DvbSdtSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DvbSdtSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DvbSdtSettingsProperty {
            private final java.lang.String outputSdt;
            private final java.lang.Number repInterval;
            private final java.lang.String serviceName;
            private final java.lang.String serviceProviderName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.outputSdt = software.amazon.jsii.Kernel.get(this, "outputSdt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.repInterval = software.amazon.jsii.Kernel.get(this, "repInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceProviderName = software.amazon.jsii.Kernel.get(this, "serviceProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.outputSdt = builder.outputSdt;
                this.repInterval = builder.repInterval;
                this.serviceName = builder.serviceName;
                this.serviceProviderName = builder.serviceProviderName;
            }

            @Override
            public final java.lang.String getOutputSdt() {
                return this.outputSdt;
            }

            @Override
            public final java.lang.Number getRepInterval() {
                return this.repInterval;
            }

            @Override
            public final java.lang.String getServiceName() {
                return this.serviceName;
            }

            @Override
            public final java.lang.String getServiceProviderName() {
                return this.serviceProviderName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOutputSdt() != null) {
                    data.set("outputSdt", om.valueToTree(this.getOutputSdt()));
                }
                if (this.getRepInterval() != null) {
                    data.set("repInterval", om.valueToTree(this.getRepInterval()));
                }
                if (this.getServiceName() != null) {
                    data.set("serviceName", om.valueToTree(this.getServiceName()));
                }
                if (this.getServiceProviderName() != null) {
                    data.set("serviceProviderName", om.valueToTree(this.getServiceProviderName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.DvbSdtSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DvbSdtSettingsProperty.Jsii$Proxy that = (DvbSdtSettingsProperty.Jsii$Proxy) o;

                if (this.outputSdt != null ? !this.outputSdt.equals(that.outputSdt) : that.outputSdt != null) return false;
                if (this.repInterval != null ? !this.repInterval.equals(that.repInterval) : that.repInterval != null) return false;
                if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) return false;
                return this.serviceProviderName != null ? this.serviceProviderName.equals(that.serviceProviderName) : that.serviceProviderName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.outputSdt != null ? this.outputSdt.hashCode() : 0;
                result = 31 * result + (this.repInterval != null ? this.repInterval.hashCode() : 0);
                result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
                result = 31 * result + (this.serviceProviderName != null ? this.serviceProviderName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for DVB Sub captions in the output.
     * <p>
     * The parent of this entity is CaptionDestinationSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * DvbSubDestinationSettingsProperty dvbSubDestinationSettingsProperty = DvbSubDestinationSettingsProperty.builder()
     *         .alignment("alignment")
     *         .backgroundColor("backgroundColor")
     *         .backgroundOpacity(123)
     *         .font(InputLocationProperty.builder()
     *                 .passwordParam("passwordParam")
     *                 .uri("uri")
     *                 .username("username")
     *                 .build())
     *         .fontColor("fontColor")
     *         .fontOpacity(123)
     *         .fontResolution(123)
     *         .fontSize("fontSize")
     *         .outlineColor("outlineColor")
     *         .outlineSize(123)
     *         .shadowColor("shadowColor")
     *         .shadowOpacity(123)
     *         .shadowXOffset(123)
     *         .shadowYOffset(123)
     *         .teletextGridControl("teletextGridControl")
     *         .xPosition(123)
     *         .yPosition(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.DvbSubDestinationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DvbSubDestinationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DvbSubDestinationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If no explicit xPosition or yPosition is provided, setting the alignment to centered places the captions at the bottom center of the output.
         * <p>
         * Similarly, setting a left alignment aligns captions to the bottom left of the output. If x and y positions are specified in conjunction with the alignment parameter, the font is justified (either left or centered) relative to those coordinates. Selecting "smart" justification left-justifies live subtitles and center-justifies pre-recorded subtitles. This option is not valid for source captions that are STL or 608/embedded. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlignment() {
            return null;
        }

        /**
         * Specifies the color of the rectangle behind the captions.
         * <p>
         * All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBackgroundColor() {
            return null;
        }

        /**
         * Specifies the opacity of the background rectangle.
         * <p>
         * 255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBackgroundOpacity() {
            return null;
        }

        /**
         * The external font file that is used for captions burn-in.
         * <p>
         * The file extension must be .ttf or .tte. Although you can select output fonts for many different types of input captions, embedded, STL, and Teletext sources use a strict grid system. Using external fonts with these captions sources could cause an unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFont() {
            return null;
        }

        /**
         * Specifies the color of the burned-in captions.
         * <p>
         * This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFontColor() {
            return null;
        }

        /**
         * Specifies the opacity of the burned-in captions.
         * <p>
         * 255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFontOpacity() {
            return null;
        }

        /**
         * The font resolution in DPI (dots per inch).
         * <p>
         * The default is 96 dpi. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFontResolution() {
            return null;
        }

        /**
         * When set to auto, fontSize scales depending on the size of the output.
         * <p>
         * Providing a positive integer specifies the exact font size in points. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFontSize() {
            return null;
        }

        /**
         * Specifies the font outline color.
         * <p>
         * This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutlineColor() {
            return null;
        }

        /**
         * Specifies the font outline size in pixels.
         * <p>
         * This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOutlineSize() {
            return null;
        }

        /**
         * Specifies the color of the shadow that is cast by the captions.
         * <p>
         * All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShadowColor() {
            return null;
        }

        /**
         * Specifies the opacity of the shadow.
         * <p>
         * 255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getShadowOpacity() {
            return null;
        }

        /**
         * Specifies the horizontal offset of the shadow relative to the captions in pixels.
         * <p>
         * A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getShadowXOffset() {
            return null;
        }

        /**
         * Specifies the vertical offset of the shadow relative to the captions in pixels.
         * <p>
         * A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getShadowYOffset() {
            return null;
        }

        /**
         * Controls whether a fixed grid size is used to generate the output subtitles bitmap.
         * <p>
         * This applies to only Teletext inputs and DVB-Sub/Burn-in outputs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTeletextGridControl() {
            return null;
        }

        /**
         * Specifies the horizontal position of the captions relative to the left side of the output in pixels.
         * <p>
         * A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal captions position is determined by the alignment parameter. This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getXPosition() {
            return null;
        }

        /**
         * Specifies the vertical position of the captions relative to the top of the output in pixels.
         * <p>
         * A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the captions are positioned towards the bottom of the output. This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getYPosition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DvbSubDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DvbSubDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DvbSubDestinationSettingsProperty> {
            java.lang.String alignment;
            java.lang.String backgroundColor;
            java.lang.Number backgroundOpacity;
            java.lang.Object font;
            java.lang.String fontColor;
            java.lang.Number fontOpacity;
            java.lang.Number fontResolution;
            java.lang.String fontSize;
            java.lang.String outlineColor;
            java.lang.Number outlineSize;
            java.lang.String shadowColor;
            java.lang.Number shadowOpacity;
            java.lang.Number shadowXOffset;
            java.lang.Number shadowYOffset;
            java.lang.String teletextGridControl;
            java.lang.Number xPosition;
            java.lang.Number yPosition;

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getAlignment}
             * @param alignment If no explicit xPosition or yPosition is provided, setting the alignment to centered places the captions at the bottom center of the output.
             *                  Similarly, setting a left alignment aligns captions to the bottom left of the output. If x and y positions are specified in conjunction with the alignment parameter, the font is justified (either left or centered) relative to those coordinates. Selecting "smart" justification left-justifies live subtitles and center-justifies pre-recorded subtitles. This option is not valid for source captions that are STL or 608/embedded. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alignment(java.lang.String alignment) {
                this.alignment = alignment;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getBackgroundColor}
             * @param backgroundColor Specifies the color of the rectangle behind the captions.
             *                        All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backgroundColor(java.lang.String backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getBackgroundOpacity}
             * @param backgroundOpacity Specifies the opacity of the background rectangle.
             *                          255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backgroundOpacity(java.lang.Number backgroundOpacity) {
                this.backgroundOpacity = backgroundOpacity;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getFont}
             * @param font The external font file that is used for captions burn-in.
             *             The file extension must be .ttf or .tte. Although you can select output fonts for many different types of input captions, embedded, STL, and Teletext sources use a strict grid system. Using external fonts with these captions sources could cause an unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder font(software.amazon.awscdk.services.medialive.CfnChannel.InputLocationProperty font) {
                this.font = font;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getFont}
             * @param font The external font file that is used for captions burn-in.
             *             The file extension must be .ttf or .tte. Although you can select output fonts for many different types of input captions, embedded, STL, and Teletext sources use a strict grid system. Using external fonts with these captions sources could cause an unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder font(software.amazon.awscdk.IResolvable font) {
                this.font = font;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getFontColor}
             * @param fontColor Specifies the color of the burned-in captions.
             *                  This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontColor(java.lang.String fontColor) {
                this.fontColor = fontColor;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getFontOpacity}
             * @param fontOpacity Specifies the opacity of the burned-in captions.
             *                    255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontOpacity(java.lang.Number fontOpacity) {
                this.fontOpacity = fontOpacity;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getFontResolution}
             * @param fontResolution The font resolution in DPI (dots per inch).
             *                       The default is 96 dpi. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontResolution(java.lang.Number fontResolution) {
                this.fontResolution = fontResolution;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getFontSize}
             * @param fontSize When set to auto, fontSize scales depending on the size of the output.
             *                 Providing a positive integer specifies the exact font size in points. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontSize(java.lang.String fontSize) {
                this.fontSize = fontSize;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getOutlineColor}
             * @param outlineColor Specifies the font outline color.
             *                     This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outlineColor(java.lang.String outlineColor) {
                this.outlineColor = outlineColor;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getOutlineSize}
             * @param outlineSize Specifies the font outline size in pixels.
             *                    This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outlineSize(java.lang.Number outlineSize) {
                this.outlineSize = outlineSize;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getShadowColor}
             * @param shadowColor Specifies the color of the shadow that is cast by the captions.
             *                    All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shadowColor(java.lang.String shadowColor) {
                this.shadowColor = shadowColor;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getShadowOpacity}
             * @param shadowOpacity Specifies the opacity of the shadow.
             *                      255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shadowOpacity(java.lang.Number shadowOpacity) {
                this.shadowOpacity = shadowOpacity;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getShadowXOffset}
             * @param shadowXOffset Specifies the horizontal offset of the shadow relative to the captions in pixels.
             *                      A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shadowXOffset(java.lang.Number shadowXOffset) {
                this.shadowXOffset = shadowXOffset;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getShadowYOffset}
             * @param shadowYOffset Specifies the vertical offset of the shadow relative to the captions in pixels.
             *                      A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shadowYOffset(java.lang.Number shadowYOffset) {
                this.shadowYOffset = shadowYOffset;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getTeletextGridControl}
             * @param teletextGridControl Controls whether a fixed grid size is used to generate the output subtitles bitmap.
             *                            This applies to only Teletext inputs and DVB-Sub/Burn-in outputs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder teletextGridControl(java.lang.String teletextGridControl) {
                this.teletextGridControl = teletextGridControl;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getXPosition}
             * @param xPosition Specifies the horizontal position of the captions relative to the left side of the output in pixels.
             *                  A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal captions position is determined by the alignment parameter. This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder xPosition(java.lang.Number xPosition) {
                this.xPosition = xPosition;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubDestinationSettingsProperty#getYPosition}
             * @param yPosition Specifies the vertical position of the captions relative to the top of the output in pixels.
             *                  A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the captions are positioned towards the bottom of the output. This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder yPosition(java.lang.Number yPosition) {
                this.yPosition = yPosition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DvbSubDestinationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DvbSubDestinationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DvbSubDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DvbSubDestinationSettingsProperty {
            private final java.lang.String alignment;
            private final java.lang.String backgroundColor;
            private final java.lang.Number backgroundOpacity;
            private final java.lang.Object font;
            private final java.lang.String fontColor;
            private final java.lang.Number fontOpacity;
            private final java.lang.Number fontResolution;
            private final java.lang.String fontSize;
            private final java.lang.String outlineColor;
            private final java.lang.Number outlineSize;
            private final java.lang.String shadowColor;
            private final java.lang.Number shadowOpacity;
            private final java.lang.Number shadowXOffset;
            private final java.lang.Number shadowYOffset;
            private final java.lang.String teletextGridControl;
            private final java.lang.Number xPosition;
            private final java.lang.Number yPosition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alignment = software.amazon.jsii.Kernel.get(this, "alignment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.backgroundColor = software.amazon.jsii.Kernel.get(this, "backgroundColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.backgroundOpacity = software.amazon.jsii.Kernel.get(this, "backgroundOpacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.font = software.amazon.jsii.Kernel.get(this, "font", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fontColor = software.amazon.jsii.Kernel.get(this, "fontColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fontOpacity = software.amazon.jsii.Kernel.get(this, "fontOpacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.fontResolution = software.amazon.jsii.Kernel.get(this, "fontResolution", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.fontSize = software.amazon.jsii.Kernel.get(this, "fontSize", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outlineColor = software.amazon.jsii.Kernel.get(this, "outlineColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outlineSize = software.amazon.jsii.Kernel.get(this, "outlineSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.shadowColor = software.amazon.jsii.Kernel.get(this, "shadowColor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shadowOpacity = software.amazon.jsii.Kernel.get(this, "shadowOpacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.shadowXOffset = software.amazon.jsii.Kernel.get(this, "shadowXOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.shadowYOffset = software.amazon.jsii.Kernel.get(this, "shadowYOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.teletextGridControl = software.amazon.jsii.Kernel.get(this, "teletextGridControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.xPosition = software.amazon.jsii.Kernel.get(this, "xPosition", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.yPosition = software.amazon.jsii.Kernel.get(this, "yPosition", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alignment = builder.alignment;
                this.backgroundColor = builder.backgroundColor;
                this.backgroundOpacity = builder.backgroundOpacity;
                this.font = builder.font;
                this.fontColor = builder.fontColor;
                this.fontOpacity = builder.fontOpacity;
                this.fontResolution = builder.fontResolution;
                this.fontSize = builder.fontSize;
                this.outlineColor = builder.outlineColor;
                this.outlineSize = builder.outlineSize;
                this.shadowColor = builder.shadowColor;
                this.shadowOpacity = builder.shadowOpacity;
                this.shadowXOffset = builder.shadowXOffset;
                this.shadowYOffset = builder.shadowYOffset;
                this.teletextGridControl = builder.teletextGridControl;
                this.xPosition = builder.xPosition;
                this.yPosition = builder.yPosition;
            }

            @Override
            public final java.lang.String getAlignment() {
                return this.alignment;
            }

            @Override
            public final java.lang.String getBackgroundColor() {
                return this.backgroundColor;
            }

            @Override
            public final java.lang.Number getBackgroundOpacity() {
                return this.backgroundOpacity;
            }

            @Override
            public final java.lang.Object getFont() {
                return this.font;
            }

            @Override
            public final java.lang.String getFontColor() {
                return this.fontColor;
            }

            @Override
            public final java.lang.Number getFontOpacity() {
                return this.fontOpacity;
            }

            @Override
            public final java.lang.Number getFontResolution() {
                return this.fontResolution;
            }

            @Override
            public final java.lang.String getFontSize() {
                return this.fontSize;
            }

            @Override
            public final java.lang.String getOutlineColor() {
                return this.outlineColor;
            }

            @Override
            public final java.lang.Number getOutlineSize() {
                return this.outlineSize;
            }

            @Override
            public final java.lang.String getShadowColor() {
                return this.shadowColor;
            }

            @Override
            public final java.lang.Number getShadowOpacity() {
                return this.shadowOpacity;
            }

            @Override
            public final java.lang.Number getShadowXOffset() {
                return this.shadowXOffset;
            }

            @Override
            public final java.lang.Number getShadowYOffset() {
                return this.shadowYOffset;
            }

            @Override
            public final java.lang.String getTeletextGridControl() {
                return this.teletextGridControl;
            }

            @Override
            public final java.lang.Number getXPosition() {
                return this.xPosition;
            }

            @Override
            public final java.lang.Number getYPosition() {
                return this.yPosition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlignment() != null) {
                    data.set("alignment", om.valueToTree(this.getAlignment()));
                }
                if (this.getBackgroundColor() != null) {
                    data.set("backgroundColor", om.valueToTree(this.getBackgroundColor()));
                }
                if (this.getBackgroundOpacity() != null) {
                    data.set("backgroundOpacity", om.valueToTree(this.getBackgroundOpacity()));
                }
                if (this.getFont() != null) {
                    data.set("font", om.valueToTree(this.getFont()));
                }
                if (this.getFontColor() != null) {
                    data.set("fontColor", om.valueToTree(this.getFontColor()));
                }
                if (this.getFontOpacity() != null) {
                    data.set("fontOpacity", om.valueToTree(this.getFontOpacity()));
                }
                if (this.getFontResolution() != null) {
                    data.set("fontResolution", om.valueToTree(this.getFontResolution()));
                }
                if (this.getFontSize() != null) {
                    data.set("fontSize", om.valueToTree(this.getFontSize()));
                }
                if (this.getOutlineColor() != null) {
                    data.set("outlineColor", om.valueToTree(this.getOutlineColor()));
                }
                if (this.getOutlineSize() != null) {
                    data.set("outlineSize", om.valueToTree(this.getOutlineSize()));
                }
                if (this.getShadowColor() != null) {
                    data.set("shadowColor", om.valueToTree(this.getShadowColor()));
                }
                if (this.getShadowOpacity() != null) {
                    data.set("shadowOpacity", om.valueToTree(this.getShadowOpacity()));
                }
                if (this.getShadowXOffset() != null) {
                    data.set("shadowXOffset", om.valueToTree(this.getShadowXOffset()));
                }
                if (this.getShadowYOffset() != null) {
                    data.set("shadowYOffset", om.valueToTree(this.getShadowYOffset()));
                }
                if (this.getTeletextGridControl() != null) {
                    data.set("teletextGridControl", om.valueToTree(this.getTeletextGridControl()));
                }
                if (this.getXPosition() != null) {
                    data.set("xPosition", om.valueToTree(this.getXPosition()));
                }
                if (this.getYPosition() != null) {
                    data.set("yPosition", om.valueToTree(this.getYPosition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.DvbSubDestinationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DvbSubDestinationSettingsProperty.Jsii$Proxy that = (DvbSubDestinationSettingsProperty.Jsii$Proxy) o;

                if (this.alignment != null ? !this.alignment.equals(that.alignment) : that.alignment != null) return false;
                if (this.backgroundColor != null ? !this.backgroundColor.equals(that.backgroundColor) : that.backgroundColor != null) return false;
                if (this.backgroundOpacity != null ? !this.backgroundOpacity.equals(that.backgroundOpacity) : that.backgroundOpacity != null) return false;
                if (this.font != null ? !this.font.equals(that.font) : that.font != null) return false;
                if (this.fontColor != null ? !this.fontColor.equals(that.fontColor) : that.fontColor != null) return false;
                if (this.fontOpacity != null ? !this.fontOpacity.equals(that.fontOpacity) : that.fontOpacity != null) return false;
                if (this.fontResolution != null ? !this.fontResolution.equals(that.fontResolution) : that.fontResolution != null) return false;
                if (this.fontSize != null ? !this.fontSize.equals(that.fontSize) : that.fontSize != null) return false;
                if (this.outlineColor != null ? !this.outlineColor.equals(that.outlineColor) : that.outlineColor != null) return false;
                if (this.outlineSize != null ? !this.outlineSize.equals(that.outlineSize) : that.outlineSize != null) return false;
                if (this.shadowColor != null ? !this.shadowColor.equals(that.shadowColor) : that.shadowColor != null) return false;
                if (this.shadowOpacity != null ? !this.shadowOpacity.equals(that.shadowOpacity) : that.shadowOpacity != null) return false;
                if (this.shadowXOffset != null ? !this.shadowXOffset.equals(that.shadowXOffset) : that.shadowXOffset != null) return false;
                if (this.shadowYOffset != null ? !this.shadowYOffset.equals(that.shadowYOffset) : that.shadowYOffset != null) return false;
                if (this.teletextGridControl != null ? !this.teletextGridControl.equals(that.teletextGridControl) : that.teletextGridControl != null) return false;
                if (this.xPosition != null ? !this.xPosition.equals(that.xPosition) : that.xPosition != null) return false;
                return this.yPosition != null ? this.yPosition.equals(that.yPosition) : that.yPosition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alignment != null ? this.alignment.hashCode() : 0;
                result = 31 * result + (this.backgroundColor != null ? this.backgroundColor.hashCode() : 0);
                result = 31 * result + (this.backgroundOpacity != null ? this.backgroundOpacity.hashCode() : 0);
                result = 31 * result + (this.font != null ? this.font.hashCode() : 0);
                result = 31 * result + (this.fontColor != null ? this.fontColor.hashCode() : 0);
                result = 31 * result + (this.fontOpacity != null ? this.fontOpacity.hashCode() : 0);
                result = 31 * result + (this.fontResolution != null ? this.fontResolution.hashCode() : 0);
                result = 31 * result + (this.fontSize != null ? this.fontSize.hashCode() : 0);
                result = 31 * result + (this.outlineColor != null ? this.outlineColor.hashCode() : 0);
                result = 31 * result + (this.outlineSize != null ? this.outlineSize.hashCode() : 0);
                result = 31 * result + (this.shadowColor != null ? this.shadowColor.hashCode() : 0);
                result = 31 * result + (this.shadowOpacity != null ? this.shadowOpacity.hashCode() : 0);
                result = 31 * result + (this.shadowXOffset != null ? this.shadowXOffset.hashCode() : 0);
                result = 31 * result + (this.shadowYOffset != null ? this.shadowYOffset.hashCode() : 0);
                result = 31 * result + (this.teletextGridControl != null ? this.teletextGridControl.hashCode() : 0);
                result = 31 * result + (this.xPosition != null ? this.xPosition.hashCode() : 0);
                result = 31 * result + (this.yPosition != null ? this.yPosition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the DVB Sub captions to extract from the input.
     * <p>
     * The parent of this entity is CaptionSelectorSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * DvbSubSourceSettingsProperty dvbSubSourceSettingsProperty = DvbSubSourceSettingsProperty.builder()
     *         .ocrLanguage("ocrLanguage")
     *         .pid(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.DvbSubSourceSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DvbSubSourceSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DvbSubSourceSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If you will configure a WebVTT caption description that references this caption selector, use this field to provide the language to consider when translating the image-based source to text.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOcrLanguage() {
            return null;
        }

        /**
         * When using DVB-Sub with burn-in or SMPTE-TT, use this PID for the source content.
         * <p>
         * It is unused for DVB-Sub passthrough. All DVB-Sub content is passed through, regardless of selectors.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPid() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DvbSubSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DvbSubSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DvbSubSourceSettingsProperty> {
            java.lang.String ocrLanguage;
            java.lang.Number pid;

            /**
             * Sets the value of {@link DvbSubSourceSettingsProperty#getOcrLanguage}
             * @param ocrLanguage If you will configure a WebVTT caption description that references this caption selector, use this field to provide the language to consider when translating the image-based source to text.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ocrLanguage(java.lang.String ocrLanguage) {
                this.ocrLanguage = ocrLanguage;
                return this;
            }

            /**
             * Sets the value of {@link DvbSubSourceSettingsProperty#getPid}
             * @param pid When using DVB-Sub with burn-in or SMPTE-TT, use this PID for the source content.
             *            It is unused for DVB-Sub passthrough. All DVB-Sub content is passed through, regardless of selectors.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pid(java.lang.Number pid) {
                this.pid = pid;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DvbSubSourceSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DvbSubSourceSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DvbSubSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DvbSubSourceSettingsProperty {
            private final java.lang.String ocrLanguage;
            private final java.lang.Number pid;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ocrLanguage = software.amazon.jsii.Kernel.get(this, "ocrLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pid = software.amazon.jsii.Kernel.get(this, "pid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ocrLanguage = builder.ocrLanguage;
                this.pid = builder.pid;
            }

            @Override
            public final java.lang.String getOcrLanguage() {
                return this.ocrLanguage;
            }

            @Override
            public final java.lang.Number getPid() {
                return this.pid;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOcrLanguage() != null) {
                    data.set("ocrLanguage", om.valueToTree(this.getOcrLanguage()));
                }
                if (this.getPid() != null) {
                    data.set("pid", om.valueToTree(this.getPid()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.DvbSubSourceSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DvbSubSourceSettingsProperty.Jsii$Proxy that = (DvbSubSourceSettingsProperty.Jsii$Proxy) o;

                if (this.ocrLanguage != null ? !this.ocrLanguage.equals(that.ocrLanguage) : that.ocrLanguage != null) return false;
                return this.pid != null ? this.pid.equals(that.pid) : that.pid == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ocrLanguage != null ? this.ocrLanguage.hashCode() : 0;
                result = 31 * result + (this.pid != null ? this.pid.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The DVB Time and Date Table (TDT).
     * <p>
     * The parent of this entity is M2tsSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * DvbTdtSettingsProperty dvbTdtSettingsProperty = DvbTdtSettingsProperty.builder()
     *         .repInterval(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.DvbTdtSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(DvbTdtSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DvbTdtSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of milliseconds between instances of this table in the output transport stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRepInterval() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DvbTdtSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DvbTdtSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DvbTdtSettingsProperty> {
            java.lang.Number repInterval;

            /**
             * Sets the value of {@link DvbTdtSettingsProperty#getRepInterval}
             * @param repInterval The number of milliseconds between instances of this table in the output transport stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repInterval(java.lang.Number repInterval) {
                this.repInterval = repInterval;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DvbTdtSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DvbTdtSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DvbTdtSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DvbTdtSettingsProperty {
            private final java.lang.Number repInterval;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.repInterval = software.amazon.jsii.Kernel.get(this, "repInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.repInterval = builder.repInterval;
            }

            @Override
            public final java.lang.Number getRepInterval() {
                return this.repInterval;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRepInterval() != null) {
                    data.set("repInterval", om.valueToTree(this.getRepInterval()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.DvbTdtSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DvbTdtSettingsProperty.Jsii$Proxy that = (DvbTdtSettingsProperty.Jsii$Proxy) o;

                return this.repInterval != null ? this.repInterval.equals(that.repInterval) : that.repInterval == null;
            }

            @Override
            public final int hashCode() {
                int result = this.repInterval != null ? this.repInterval.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The settings for an EAC3 audio encode in the output.
     * <p>
     * The parent of this entity is AudioCodecSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * Eac3SettingsProperty eac3SettingsProperty = Eac3SettingsProperty.builder()
     *         .attenuationControl("attenuationControl")
     *         .bitrate(123)
     *         .bitstreamMode("bitstreamMode")
     *         .codingMode("codingMode")
     *         .dcFilter("dcFilter")
     *         .dialnorm(123)
     *         .drcLine("drcLine")
     *         .drcRf("drcRf")
     *         .lfeControl("lfeControl")
     *         .lfeFilter("lfeFilter")
     *         .loRoCenterMixLevel(123)
     *         .loRoSurroundMixLevel(123)
     *         .ltRtCenterMixLevel(123)
     *         .ltRtSurroundMixLevel(123)
     *         .metadataControl("metadataControl")
     *         .passthroughControl("passthroughControl")
     *         .phaseControl("phaseControl")
     *         .stereoDownmix("stereoDownmix")
     *         .surroundExMode("surroundExMode")
     *         .surroundMode("surroundMode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.Eac3SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(Eac3SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Eac3SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When set to attenuate3Db, applies a 3 dB attenuation to the surround channels.
         * <p>
         * Used only for the 3/2 coding mode.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAttenuationControl() {
            return null;
        }

        /**
         * The average bitrate in bits/second.
         * <p>
         * Valid bitrates depend on the coding mode.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBitrate() {
            return null;
        }

        /**
         * Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream.
         * <p>
         * For more information, see ATSC A/52-2012 (Annex E).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBitstreamMode() {
            return null;
        }

        /**
         * The Dolby Digital Plus coding mode.
         * <p>
         * This mode determines the number of channels.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCodingMode() {
            return null;
        }

        /**
         * When set to enabled, activates a DC highpass filter for all input channels.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDcFilter() {
            return null;
        }

        /**
         * Sets the dialnorm for the output.
         * <p>
         * If blank and the input audio is Dolby Digital Plus, dialnorm will be passed through.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDialnorm() {
            return null;
        }

        /**
         * Sets the Dolby dynamic range compression profile.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDrcLine() {
            return null;
        }

        /**
         * Sets the profile for heavy Dolby dynamic range compression, ensuring that the instantaneous signal peaks do not exceed specified levels.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDrcRf() {
            return null;
        }

        /**
         * When encoding 3/2 audio, setting to lfe enables the LFE channel.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLfeControl() {
            return null;
        }

        /**
         * When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
         * <p>
         * Valid only with a codingMode32 coding mode.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLfeFilter() {
            return null;
        }

        /**
         * The Left only/Right only center mix level.
         * <p>
         * Used only for the 3/2 coding mode.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLoRoCenterMixLevel() {
            return null;
        }

        /**
         * The Left only/Right only surround mix level.
         * <p>
         * Used only for a 3/2 coding mode.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLoRoSurroundMixLevel() {
            return null;
        }

        /**
         * The Left total/Right total center mix level.
         * <p>
         * Used only for a 3/2 coding mode.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLtRtCenterMixLevel() {
            return null;
        }

        /**
         * The Left total/Right total surround mix level.
         * <p>
         * Used only for the 3/2 coding mode.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLtRtSurroundMixLevel() {
            return null;
        }

        /**
         * When set to followInput, encoder metadata is sourced from the DD, DD+, or DolbyE decoder that supplies this audio data.
         * <p>
         * If the audio is not supplied from one of these streams, then the static metadata settings are used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetadataControl() {
            return null;
        }

        /**
         * When set to whenPossible, input DD+ audio will be passed through if it is present on the input.
         * <p>
         * This detection is dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+ content will have a consistent DD+ output as the system alternates between passthrough and encoding.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassthroughControl() {
            return null;
        }

        /**
         * When set to shift90Degrees, applies a 90-degree phase shift to the surround channels.
         * <p>
         * Used only for a 3/2 coding mode.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPhaseControl() {
            return null;
        }

        /**
         * A stereo downmix preference.
         * <p>
         * Used only for the 3/2 coding mode.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStereoDownmix() {
            return null;
        }

        /**
         * When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the left and right surround channels.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSurroundExMode() {
            return null;
        }

        /**
         * When encoding 2/0 audio, sets whether Dolby Surround is matrix-encoded into the two channels.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSurroundMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Eac3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Eac3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Eac3SettingsProperty> {
            java.lang.String attenuationControl;
            java.lang.Number bitrate;
            java.lang.String bitstreamMode;
            java.lang.String codingMode;
            java.lang.String dcFilter;
            java.lang.Number dialnorm;
            java.lang.String drcLine;
            java.lang.String drcRf;
            java.lang.String lfeControl;
            java.lang.String lfeFilter;
            java.lang.Number loRoCenterMixLevel;
            java.lang.Number loRoSurroundMixLevel;
            java.lang.Number ltRtCenterMixLevel;
            java.lang.Number ltRtSurroundMixLevel;
            java.lang.String metadataControl;
            java.lang.String passthroughControl;
            java.lang.String phaseControl;
            java.lang.String stereoDownmix;
            java.lang.String surroundExMode;
            java.lang.String surroundMode;

            /**
             * Sets the value of {@link Eac3SettingsProperty#getAttenuationControl}
             * @param attenuationControl When set to attenuate3Db, applies a 3 dB attenuation to the surround channels.
             *                           Used only for the 3/2 coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attenuationControl(java.lang.String attenuationControl) {
                this.attenuationControl = attenuationControl;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getBitrate}
             * @param bitrate The average bitrate in bits/second.
             *                Valid bitrates depend on the coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitrate(java.lang.Number bitrate) {
                this.bitrate = bitrate;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getBitstreamMode}
             * @param bitstreamMode Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream.
             *                      For more information, see ATSC A/52-2012 (Annex E).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitstreamMode(java.lang.String bitstreamMode) {
                this.bitstreamMode = bitstreamMode;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getCodingMode}
             * @param codingMode The Dolby Digital Plus coding mode.
             *                   This mode determines the number of channels.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codingMode(java.lang.String codingMode) {
                this.codingMode = codingMode;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getDcFilter}
             * @param dcFilter When set to enabled, activates a DC highpass filter for all input channels.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dcFilter(java.lang.String dcFilter) {
                this.dcFilter = dcFilter;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getDialnorm}
             * @param dialnorm Sets the dialnorm for the output.
             *                 If blank and the input audio is Dolby Digital Plus, dialnorm will be passed through.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dialnorm(java.lang.Number dialnorm) {
                this.dialnorm = dialnorm;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getDrcLine}
             * @param drcLine Sets the Dolby dynamic range compression profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder drcLine(java.lang.String drcLine) {
                this.drcLine = drcLine;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getDrcRf}
             * @param drcRf Sets the profile for heavy Dolby dynamic range compression, ensuring that the instantaneous signal peaks do not exceed specified levels.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder drcRf(java.lang.String drcRf) {
                this.drcRf = drcRf;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getLfeControl}
             * @param lfeControl When encoding 3/2 audio, setting to lfe enables the LFE channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lfeControl(java.lang.String lfeControl) {
                this.lfeControl = lfeControl;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getLfeFilter}
             * @param lfeFilter When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
             *                  Valid only with a codingMode32 coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lfeFilter(java.lang.String lfeFilter) {
                this.lfeFilter = lfeFilter;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getLoRoCenterMixLevel}
             * @param loRoCenterMixLevel The Left only/Right only center mix level.
             *                           Used only for the 3/2 coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loRoCenterMixLevel(java.lang.Number loRoCenterMixLevel) {
                this.loRoCenterMixLevel = loRoCenterMixLevel;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getLoRoSurroundMixLevel}
             * @param loRoSurroundMixLevel The Left only/Right only surround mix level.
             *                             Used only for a 3/2 coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loRoSurroundMixLevel(java.lang.Number loRoSurroundMixLevel) {
                this.loRoSurroundMixLevel = loRoSurroundMixLevel;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getLtRtCenterMixLevel}
             * @param ltRtCenterMixLevel The Left total/Right total center mix level.
             *                           Used only for a 3/2 coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ltRtCenterMixLevel(java.lang.Number ltRtCenterMixLevel) {
                this.ltRtCenterMixLevel = ltRtCenterMixLevel;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getLtRtSurroundMixLevel}
             * @param ltRtSurroundMixLevel The Left total/Right total surround mix level.
             *                             Used only for the 3/2 coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ltRtSurroundMixLevel(java.lang.Number ltRtSurroundMixLevel) {
                this.ltRtSurroundMixLevel = ltRtSurroundMixLevel;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getMetadataControl}
             * @param metadataControl When set to followInput, encoder metadata is sourced from the DD, DD+, or DolbyE decoder that supplies this audio data.
             *                        If the audio is not supplied from one of these streams, then the static metadata settings are used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataControl(java.lang.String metadataControl) {
                this.metadataControl = metadataControl;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getPassthroughControl}
             * @param passthroughControl When set to whenPossible, input DD+ audio will be passed through if it is present on the input.
             *                           This detection is dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+ content will have a consistent DD+ output as the system alternates between passthrough and encoding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passthroughControl(java.lang.String passthroughControl) {
                this.passthroughControl = passthroughControl;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getPhaseControl}
             * @param phaseControl When set to shift90Degrees, applies a 90-degree phase shift to the surround channels.
             *                     Used only for a 3/2 coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phaseControl(java.lang.String phaseControl) {
                this.phaseControl = phaseControl;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getStereoDownmix}
             * @param stereoDownmix A stereo downmix preference.
             *                      Used only for the 3/2 coding mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stereoDownmix(java.lang.String stereoDownmix) {
                this.stereoDownmix = stereoDownmix;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getSurroundExMode}
             * @param surroundExMode When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the left and right surround channels.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder surroundExMode(java.lang.String surroundExMode) {
                this.surroundExMode = surroundExMode;
                return this;
            }

            /**
             * Sets the value of {@link Eac3SettingsProperty#getSurroundMode}
             * @param surroundMode When encoding 2/0 audio, sets whether Dolby Surround is matrix-encoded into the two channels.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder surroundMode(java.lang.String surroundMode) {
                this.surroundMode = surroundMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Eac3SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Eac3SettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Eac3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Eac3SettingsProperty {
            private final java.lang.String attenuationControl;
            private final java.lang.Number bitrate;
            private final java.lang.String bitstreamMode;
            private final java.lang.String codingMode;
            private final java.lang.String dcFilter;
            private final java.lang.Number dialnorm;
            private final java.lang.String drcLine;
            private final java.lang.String drcRf;
            private final java.lang.String lfeControl;
            private final java.lang.String lfeFilter;
            private final java.lang.Number loRoCenterMixLevel;
            private final java.lang.Number loRoSurroundMixLevel;
            private final java.lang.Number ltRtCenterMixLevel;
            private final java.lang.Number ltRtSurroundMixLevel;
            private final java.lang.String metadataControl;
            private final java.lang.String passthroughControl;
            private final java.lang.String phaseControl;
            private final java.lang.String stereoDownmix;
            private final java.lang.String surroundExMode;
            private final java.lang.String surroundMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attenuationControl = software.amazon.jsii.Kernel.get(this, "attenuationControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bitrate = software.amazon.jsii.Kernel.get(this, "bitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.bitstreamMode = software.amazon.jsii.Kernel.get(this, "bitstreamMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.codingMode = software.amazon.jsii.Kernel.get(this, "codingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dcFilter = software.amazon.jsii.Kernel.get(this, "dcFilter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dialnorm = software.amazon.jsii.Kernel.get(this, "dialnorm", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.drcLine = software.amazon.jsii.Kernel.get(this, "drcLine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.drcRf = software.amazon.jsii.Kernel.get(this, "drcRf", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lfeControl = software.amazon.jsii.Kernel.get(this, "lfeControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lfeFilter = software.amazon.jsii.Kernel.get(this, "lfeFilter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.loRoCenterMixLevel = software.amazon.jsii.Kernel.get(this, "loRoCenterMixLevel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.loRoSurroundMixLevel = software.amazon.jsii.Kernel.get(this, "loRoSurroundMixLevel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ltRtCenterMixLevel = software.amazon.jsii.Kernel.get(this, "ltRtCenterMixLevel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ltRtSurroundMixLevel = software.amazon.jsii.Kernel.get(this, "ltRtSurroundMixLevel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.metadataControl = software.amazon.jsii.Kernel.get(this, "metadataControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.passthroughControl = software.amazon.jsii.Kernel.get(this, "passthroughControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.phaseControl = software.amazon.jsii.Kernel.get(this, "phaseControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stereoDownmix = software.amazon.jsii.Kernel.get(this, "stereoDownmix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.surroundExMode = software.amazon.jsii.Kernel.get(this, "surroundExMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.surroundMode = software.amazon.jsii.Kernel.get(this, "surroundMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attenuationControl = builder.attenuationControl;
                this.bitrate = builder.bitrate;
                this.bitstreamMode = builder.bitstreamMode;
                this.codingMode = builder.codingMode;
                this.dcFilter = builder.dcFilter;
                this.dialnorm = builder.dialnorm;
                this.drcLine = builder.drcLine;
                this.drcRf = builder.drcRf;
                this.lfeControl = builder.lfeControl;
                this.lfeFilter = builder.lfeFilter;
                this.loRoCenterMixLevel = builder.loRoCenterMixLevel;
                this.loRoSurroundMixLevel = builder.loRoSurroundMixLevel;
                this.ltRtCenterMixLevel = builder.ltRtCenterMixLevel;
                this.ltRtSurroundMixLevel = builder.ltRtSurroundMixLevel;
                this.metadataControl = builder.metadataControl;
                this.passthroughControl = builder.passthroughControl;
                this.phaseControl = builder.phaseControl;
                this.stereoDownmix = builder.stereoDownmix;
                this.surroundExMode = builder.surroundExMode;
                this.surroundMode = builder.surroundMode;
            }

            @Override
            public final java.lang.String getAttenuationControl() {
                return this.attenuationControl;
            }

            @Override
            public final java.lang.Number getBitrate() {
                return this.bitrate;
            }

            @Override
            public final java.lang.String getBitstreamMode() {
                return this.bitstreamMode;
            }

            @Override
            public final java.lang.String getCodingMode() {
                return this.codingMode;
            }

            @Override
            public final java.lang.String getDcFilter() {
                return this.dcFilter;
            }

            @Override
            public final java.lang.Number getDialnorm() {
                return this.dialnorm;
            }

            @Override
            public final java.lang.String getDrcLine() {
                return this.drcLine;
            }

            @Override
            public final java.lang.String getDrcRf() {
                return this.drcRf;
            }

            @Override
            public final java.lang.String getLfeControl() {
                return this.lfeControl;
            }

            @Override
            public final java.lang.String getLfeFilter() {
                return this.lfeFilter;
            }

            @Override
            public final java.lang.Number getLoRoCenterMixLevel() {
                return this.loRoCenterMixLevel;
            }

            @Override
            public final java.lang.Number getLoRoSurroundMixLevel() {
                return this.loRoSurroundMixLevel;
            }

            @Override
            public final java.lang.Number getLtRtCenterMixLevel() {
                return this.ltRtCenterMixLevel;
            }

            @Override
            public final java.lang.Number getLtRtSurroundMixLevel() {
                return this.ltRtSurroundMixLevel;
            }

            @Override
            public final java.lang.String getMetadataControl() {
                return this.metadataControl;
            }

            @Override
            public final java.lang.String getPassthroughControl() {
                return this.passthroughControl;
            }

            @Override
            public final java.lang.String getPhaseControl() {
                return this.phaseControl;
            }

            @Override
            public final java.lang.String getStereoDownmix() {
                return this.stereoDownmix;
            }

            @Override
            public final java.lang.String getSurroundExMode() {
                return this.surroundExMode;
            }

            @Override
            public final java.lang.String getSurroundMode() {
                return this.surroundMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttenuationControl() != null) {
                    data.set("attenuationControl", om.valueToTree(this.getAttenuationControl()));
                }
                if (this.getBitrate() != null) {
                    data.set("bitrate", om.valueToTree(this.getBitrate()));
                }
                if (this.getBitstreamMode() != null) {
                    data.set("bitstreamMode", om.valueToTree(this.getBitstreamMode()));
                }
                if (this.getCodingMode() != null) {
                    data.set("codingMode", om.valueToTree(this.getCodingMode()));
                }
                if (this.getDcFilter() != null) {
                    data.set("dcFilter", om.valueToTree(this.getDcFilter()));
                }
                if (this.getDialnorm() != null) {
                    data.set("dialnorm", om.valueToTree(this.getDialnorm()));
                }
                if (this.getDrcLine() != null) {
                    data.set("drcLine", om.valueToTree(this.getDrcLine()));
                }
                if (this.getDrcRf() != null) {
                    data.set("drcRf", om.valueToTree(this.getDrcRf()));
                }
                if (this.getLfeControl() != null) {
                    data.set("lfeControl", om.valueToTree(this.getLfeControl()));
                }
                if (this.getLfeFilter() != null) {
                    data.set("lfeFilter", om.valueToTree(this.getLfeFilter()));
                }
                if (this.getLoRoCenterMixLevel() != null) {
                    data.set("loRoCenterMixLevel", om.valueToTree(this.getLoRoCenterMixLevel()));
                }
                if (this.getLoRoSurroundMixLevel() != null) {
                    data.set("loRoSurroundMixLevel", om.valueToTree(this.getLoRoSurroundMixLevel()));
                }
                if (this.getLtRtCenterMixLevel() != null) {
                    data.set("ltRtCenterMixLevel", om.valueToTree(this.getLtRtCenterMixLevel()));
                }
                if (this.getLtRtSurroundMixLevel() != null) {
                    data.set("ltRtSurroundMixLevel", om.valueToTree(this.getLtRtSurroundMixLevel()));
                }
                if (this.getMetadataControl() != null) {
                    data.set("metadataControl", om.valueToTree(this.getMetadataControl()));
                }
                if (this.getPassthroughControl() != null) {
                    data.set("passthroughControl", om.valueToTree(this.getPassthroughControl()));
                }
                if (this.getPhaseControl() != null) {
                    data.set("phaseControl", om.valueToTree(this.getPhaseControl()));
                }
                if (this.getStereoDownmix() != null) {
                    data.set("stereoDownmix", om.valueToTree(this.getStereoDownmix()));
                }
                if (this.getSurroundExMode() != null) {
                    data.set("surroundExMode", om.valueToTree(this.getSurroundExMode()));
                }
                if (this.getSurroundMode() != null) {
                    data.set("surroundMode", om.valueToTree(this.getSurroundMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.Eac3SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Eac3SettingsProperty.Jsii$Proxy that = (Eac3SettingsProperty.Jsii$Proxy) o;

                if (this.attenuationControl != null ? !this.attenuationControl.equals(that.attenuationControl) : that.attenuationControl != null) return false;
                if (this.bitrate != null ? !this.bitrate.equals(that.bitrate) : that.bitrate != null) return false;
                if (this.bitstreamMode != null ? !this.bitstreamMode.equals(that.bitstreamMode) : that.bitstreamMode != null) return false;
                if (this.codingMode != null ? !this.codingMode.equals(that.codingMode) : that.codingMode != null) return false;
                if (this.dcFilter != null ? !this.dcFilter.equals(that.dcFilter) : that.dcFilter != null) return false;
                if (this.dialnorm != null ? !this.dialnorm.equals(that.dialnorm) : that.dialnorm != null) return false;
                if (this.drcLine != null ? !this.drcLine.equals(that.drcLine) : that.drcLine != null) return false;
                if (this.drcRf != null ? !this.drcRf.equals(that.drcRf) : that.drcRf != null) return false;
                if (this.lfeControl != null ? !this.lfeControl.equals(that.lfeControl) : that.lfeControl != null) return false;
                if (this.lfeFilter != null ? !this.lfeFilter.equals(that.lfeFilter) : that.lfeFilter != null) return false;
                if (this.loRoCenterMixLevel != null ? !this.loRoCenterMixLevel.equals(that.loRoCenterMixLevel) : that.loRoCenterMixLevel != null) return false;
                if (this.loRoSurroundMixLevel != null ? !this.loRoSurroundMixLevel.equals(that.loRoSurroundMixLevel) : that.loRoSurroundMixLevel != null) return false;
                if (this.ltRtCenterMixLevel != null ? !this.ltRtCenterMixLevel.equals(that.ltRtCenterMixLevel) : that.ltRtCenterMixLevel != null) return false;
                if (this.ltRtSurroundMixLevel != null ? !this.ltRtSurroundMixLevel.equals(that.ltRtSurroundMixLevel) : that.ltRtSurroundMixLevel != null) return false;
                if (this.metadataControl != null ? !this.metadataControl.equals(that.metadataControl) : that.metadataControl != null) return false;
                if (this.passthroughControl != null ? !this.passthroughControl.equals(that.passthroughControl) : that.passthroughControl != null) return false;
                if (this.phaseControl != null ? !this.phaseControl.equals(that.phaseControl) : that.phaseControl != null) return false;
                if (this.stereoDownmix != null ? !this.stereoDownmix.equals(that.stereoDownmix) : that.stereoDownmix != null) return false;
                if (this.surroundExMode != null ? !this.surroundExMode.equals(that.surroundExMode) : that.surroundExMode != null) return false;
                return this.surroundMode != null ? this.surroundMode.equals(that.surroundMode) : that.surroundMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attenuationControl != null ? this.attenuationControl.hashCode() : 0;
                result = 31 * result + (this.bitrate != null ? this.bitrate.hashCode() : 0);
                result = 31 * result + (this.bitstreamMode != null ? this.bitstreamMode.hashCode() : 0);
                result = 31 * result + (this.codingMode != null ? this.codingMode.hashCode() : 0);
                result = 31 * result + (this.dcFilter != null ? this.dcFilter.hashCode() : 0);
                result = 31 * result + (this.dialnorm != null ? this.dialnorm.hashCode() : 0);
                result = 31 * result + (this.drcLine != null ? this.drcLine.hashCode() : 0);
                result = 31 * result + (this.drcRf != null ? this.drcRf.hashCode() : 0);
                result = 31 * result + (this.lfeControl != null ? this.lfeControl.hashCode() : 0);
                result = 31 * result + (this.lfeFilter != null ? this.lfeFilter.hashCode() : 0);
                result = 31 * result + (this.loRoCenterMixLevel != null ? this.loRoCenterMixLevel.hashCode() : 0);
                result = 31 * result + (this.loRoSurroundMixLevel != null ? this.loRoSurroundMixLevel.hashCode() : 0);
                result = 31 * result + (this.ltRtCenterMixLevel != null ? this.ltRtCenterMixLevel.hashCode() : 0);
                result = 31 * result + (this.ltRtSurroundMixLevel != null ? this.ltRtSurroundMixLevel.hashCode() : 0);
                result = 31 * result + (this.metadataControl != null ? this.metadataControl.hashCode() : 0);
                result = 31 * result + (this.passthroughControl != null ? this.passthroughControl.hashCode() : 0);
                result = 31 * result + (this.phaseControl != null ? this.phaseControl.hashCode() : 0);
                result = 31 * result + (this.stereoDownmix != null ? this.stereoDownmix.hashCode() : 0);
                result = 31 * result + (this.surroundExMode != null ? this.surroundExMode.hashCode() : 0);
                result = 31 * result + (this.surroundMode != null ? this.surroundMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings for EBU-TT captions in the output.
     * <p>
     * The parent of this entity is CaptionDestinationSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * EbuTtDDestinationSettingsProperty ebuTtDDestinationSettingsProperty = EbuTtDDestinationSettingsProperty.builder()
     *         .copyrightHolder("copyrightHolder")
     *         .fillLineGap("fillLineGap")
     *         .fontFamily("fontFamily")
     *         .styleControl("styleControl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.EbuTtDDestinationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(EbuTtDDestinationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EbuTtDDestinationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output.
         * <p>
         * Complete this field if you want to include the name of the copyright holder in the copyright metadata tag in the TTML
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCopyrightHolder() {
            return null;
        }

        /**
         * Specifies how to handle the gap between the lines (in multi-line captions).
         * <p>
         * <ul>
         * <li>enabled: Fill with the captions background color (as specified in the input captions).</li>
         * <li>disabled: Leave the gap unfilled.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFillLineGap() {
            return null;
        }

        /**
         * Specifies the font family to include in the font data attached to the EBU-TT captions.
         * <p>
         * Valid only if styleControl is set to include. If you leave this field empty, the font family is set to "monospaced". (If styleControl is set to exclude, the font family is always set to "monospaced".) You specify only the font family. All other style information (color, bold, position and so on) is copied from the input captions. The size is always set to 100% to allow the downstream player to choose the size. - Enter a list of font families, as a comma-separated list of font names, in order of preference. The name can be a font family (such as “Arial”), or a generic font family (such as “serif”), or “default” (to let the downstream player choose the font).
         * <p>
         * <ul>
         * <li>Leave blank to set the family to “monospace”.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFontFamily() {
            return null;
        }

        /**
         * Specifies the style information (font color, font position, and so on) to include in the font data that is attached to the EBU-TT captions.
         * <p>
         * <ul>
         * <li>include: Take the style information (font color, font position, and so on) from the source captions and include that information in the font data attached to the EBU-TT captions. This option is valid only if the source captions are Embedded or Teletext.</li>
         * <li>exclude: In the font data attached to the EBU-TT captions, set the font family to "monospaced". Do not include any other style information.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStyleControl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbuTtDDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbuTtDDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EbuTtDDestinationSettingsProperty> {
            java.lang.String copyrightHolder;
            java.lang.String fillLineGap;
            java.lang.String fontFamily;
            java.lang.String styleControl;

            /**
             * Sets the value of {@link EbuTtDDestinationSettingsProperty#getCopyrightHolder}
             * @param copyrightHolder Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output.
             *                        Complete this field if you want to include the name of the copyright holder in the copyright metadata tag in the TTML
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyrightHolder(java.lang.String copyrightHolder) {
                this.copyrightHolder = copyrightHolder;
                return this;
            }

            /**
             * Sets the value of {@link EbuTtDDestinationSettingsProperty#getFillLineGap}
             * @param fillLineGap Specifies how to handle the gap between the lines (in multi-line captions).
             *                    <ul>
             *                    <li>enabled: Fill with the captions background color (as specified in the input captions).</li>
             *                    <li>disabled: Leave the gap unfilled.</li>
             *                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fillLineGap(java.lang.String fillLineGap) {
                this.fillLineGap = fillLineGap;
                return this;
            }

            /**
             * Sets the value of {@link EbuTtDDestinationSettingsProperty#getFontFamily}
             * @param fontFamily Specifies the font family to include in the font data attached to the EBU-TT captions.
             *                   Valid only if styleControl is set to include. If you leave this field empty, the font family is set to "monospaced". (If styleControl is set to exclude, the font family is always set to "monospaced".) You specify only the font family. All other style information (color, bold, position and so on) is copied from the input captions. The size is always set to 100% to allow the downstream player to choose the size. - Enter a list of font families, as a comma-separated list of font names, in order of preference. The name can be a font family (such as “Arial”), or a generic font family (such as “serif”), or “default” (to let the downstream player choose the font).
             *                   <p>
             *                   <ul>
             *                   <li>Leave blank to set the family to “monospace”.</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fontFamily(java.lang.String fontFamily) {
                this.fontFamily = fontFamily;
                return this;
            }

            /**
             * Sets the value of {@link EbuTtDDestinationSettingsProperty#getStyleControl}
             * @param styleControl Specifies the style information (font color, font position, and so on) to include in the font data that is attached to the EBU-TT captions.
             *                     <ul>
             *                     <li>include: Take the style information (font color, font position, and so on) from the source captions and include that information in the font data attached to the EBU-TT captions. This option is valid only if the source captions are Embedded or Teletext.</li>
             *                     <li>exclude: In the font data attached to the EBU-TT captions, set the font family to "monospaced". Do not include any other style information.</li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder styleControl(java.lang.String styleControl) {
                this.styleControl = styleControl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbuTtDDestinationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EbuTtDDestinationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EbuTtDDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbuTtDDestinationSettingsProperty {
            private final java.lang.String copyrightHolder;
            private final java.lang.String fillLineGap;
            private final java.lang.String fontFamily;
            private final java.lang.String styleControl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.copyrightHolder = software.amazon.jsii.Kernel.get(this, "copyrightHolder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fillLineGap = software.amazon.jsii.Kernel.get(this, "fillLineGap", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fontFamily = software.amazon.jsii.Kernel.get(this, "fontFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.styleControl = software.amazon.jsii.Kernel.get(this, "styleControl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.copyrightHolder = builder.copyrightHolder;
                this.fillLineGap = builder.fillLineGap;
                this.fontFamily = builder.fontFamily;
                this.styleControl = builder.styleControl;
            }

            @Override
            public final java.lang.String getCopyrightHolder() {
                return this.copyrightHolder;
            }

            @Override
            public final java.lang.String getFillLineGap() {
                return this.fillLineGap;
            }

            @Override
            public final java.lang.String getFontFamily() {
                return this.fontFamily;
            }

            @Override
            public final java.lang.String getStyleControl() {
                return this.styleControl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCopyrightHolder() != null) {
                    data.set("copyrightHolder", om.valueToTree(this.getCopyrightHolder()));
                }
                if (this.getFillLineGap() != null) {
                    data.set("fillLineGap", om.valueToTree(this.getFillLineGap()));
                }
                if (this.getFontFamily() != null) {
                    data.set("fontFamily", om.valueToTree(this.getFontFamily()));
                }
                if (this.getStyleControl() != null) {
                    data.set("styleControl", om.valueToTree(this.getStyleControl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.EbuTtDDestinationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbuTtDDestinationSettingsProperty.Jsii$Proxy that = (EbuTtDDestinationSettingsProperty.Jsii$Proxy) o;

                if (this.copyrightHolder != null ? !this.copyrightHolder.equals(that.copyrightHolder) : that.copyrightHolder != null) return false;
                if (this.fillLineGap != null ? !this.fillLineGap.equals(that.fillLineGap) : that.fillLineGap != null) return false;
                if (this.fontFamily != null ? !this.fontFamily.equals(that.fontFamily) : that.fontFamily != null) return false;
                return this.styleControl != null ? this.styleControl.equals(that.styleControl) : that.styleControl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.copyrightHolder != null ? this.copyrightHolder.hashCode() : 0;
                result = 31 * result + (this.fillLineGap != null ? this.fillLineGap.hashCode() : 0);
                result = 31 * result + (this.fontFamily != null ? this.fontFamily.hashCode() : 0);
                result = 31 * result + (this.styleControl != null ? this.styleControl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of embedded captions in the output.
     * <p>
     * The parent of this entity is CaptionDestinationSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * EmbeddedDestinationSettingsProperty embeddedDestinationSettingsProperty = EmbeddedDestinationSettingsProperty.builder().build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.EmbeddedDestinationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(EmbeddedDestinationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmbeddedDestinationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link EmbeddedDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmbeddedDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmbeddedDestinationSettingsProperty> {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmbeddedDestinationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmbeddedDestinationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmbeddedDestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmbeddedDestinationSettingsProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.EmbeddedDestinationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }
        }
    }
    /**
     * The settings for embedded plus SCTE-20 captions in the output.
     * <p>
     * The parent of this entity is CaptionDestinationSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * EmbeddedPlusScte20DestinationSettingsProperty embeddedPlusScte20DestinationSettingsProperty = EmbeddedPlusScte20DestinationSettingsProperty.builder().build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(EmbeddedPlusScte20DestinationSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmbeddedPlusScte20DestinationSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link EmbeddedPlusScte20DestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmbeddedPlusScte20DestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmbeddedPlusScte20DestinationSettingsProperty> {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmbeddedPlusScte20DestinationSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmbeddedPlusScte20DestinationSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmbeddedPlusScte20DestinationSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmbeddedPlusScte20DestinationSettingsProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }
        }
    }
    /**
     * Information about the embedded captions to extract from the input.
     * <p>
     * The parent of this entity is CaptionSelectorSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * EmbeddedSourceSettingsProperty embeddedSourceSettingsProperty = EmbeddedSourceSettingsProperty.builder()
     *         .convert608To708("convert608To708")
     *         .scte20Detection("scte20Detection")
     *         .source608ChannelNumber(123)
     *         .source608TrackNumber(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.EmbeddedSourceSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(EmbeddedSourceSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmbeddedSourceSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If this is upconvert, 608 data is both passed through the "608 compatibility bytes" fields of the 708 wrapper as well as translated into 708.
         * <p>
         * If 708 data is present in the source content, it is discarded.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConvert608To708() {
            return null;
        }

        /**
         * Set to "auto" to handle streams with intermittent or non-aligned SCTE-20 and embedded captions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScte20Detection() {
            return null;
        }

        /**
         * Specifies the 608/708 channel number within the video track from which to extract captions.
         * <p>
         * This is unused for passthrough.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSource608ChannelNumber() {
            return null;
        }

        /**
         * This field is unused and deprecated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSource608TrackNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EmbeddedSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmbeddedSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmbeddedSourceSettingsProperty> {
            java.lang.String convert608To708;
            java.lang.String scte20Detection;
            java.lang.Number source608ChannelNumber;
            java.lang.Number source608TrackNumber;

            /**
             * Sets the value of {@link EmbeddedSourceSettingsProperty#getConvert608To708}
             * @param convert608To708 If this is upconvert, 608 data is both passed through the "608 compatibility bytes" fields of the 708 wrapper as well as translated into 708.
             *                        If 708 data is present in the source content, it is discarded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder convert608To708(java.lang.String convert608To708) {
                this.convert608To708 = convert608To708;
                return this;
            }

            /**
             * Sets the value of {@link EmbeddedSourceSettingsProperty#getScte20Detection}
             * @param scte20Detection Set to "auto" to handle streams with intermittent or non-aligned SCTE-20 and embedded captions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte20Detection(java.lang.String scte20Detection) {
                this.scte20Detection = scte20Detection;
                return this;
            }

            /**
             * Sets the value of {@link EmbeddedSourceSettingsProperty#getSource608ChannelNumber}
             * @param source608ChannelNumber Specifies the 608/708 channel number within the video track from which to extract captions.
             *                               This is unused for passthrough.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source608ChannelNumber(java.lang.Number source608ChannelNumber) {
                this.source608ChannelNumber = source608ChannelNumber;
                return this;
            }

            /**
             * Sets the value of {@link EmbeddedSourceSettingsProperty#getSource608TrackNumber}
             * @param source608TrackNumber This field is unused and deprecated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source608TrackNumber(java.lang.Number source608TrackNumber) {
                this.source608TrackNumber = source608TrackNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmbeddedSourceSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmbeddedSourceSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmbeddedSourceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmbeddedSourceSettingsProperty {
            private final java.lang.String convert608To708;
            private final java.lang.String scte20Detection;
            private final java.lang.Number source608ChannelNumber;
            private final java.lang.Number source608TrackNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.convert608To708 = software.amazon.jsii.Kernel.get(this, "convert608To708", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scte20Detection = software.amazon.jsii.Kernel.get(this, "scte20Detection", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source608ChannelNumber = software.amazon.jsii.Kernel.get(this, "source608ChannelNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.source608TrackNumber = software.amazon.jsii.Kernel.get(this, "source608TrackNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.convert608To708 = builder.convert608To708;
                this.scte20Detection = builder.scte20Detection;
                this.source608ChannelNumber = builder.source608ChannelNumber;
                this.source608TrackNumber = builder.source608TrackNumber;
            }

            @Override
            public final java.lang.String getConvert608To708() {
                return this.convert608To708;
            }

            @Override
            public final java.lang.String getScte20Detection() {
                return this.scte20Detection;
            }

            @Override
            public final java.lang.Number getSource608ChannelNumber() {
                return this.source608ChannelNumber;
            }

            @Override
            public final java.lang.Number getSource608TrackNumber() {
                return this.source608TrackNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConvert608To708() != null) {
                    data.set("convert608To708", om.valueToTree(this.getConvert608To708()));
                }
                if (this.getScte20Detection() != null) {
                    data.set("scte20Detection", om.valueToTree(this.getScte20Detection()));
                }
                if (this.getSource608ChannelNumber() != null) {
                    data.set("source608ChannelNumber", om.valueToTree(this.getSource608ChannelNumber()));
                }
                if (this.getSource608TrackNumber() != null) {
                    data.set("source608TrackNumber", om.valueToTree(this.getSource608TrackNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.EmbeddedSourceSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EmbeddedSourceSettingsProperty.Jsii$Proxy that = (EmbeddedSourceSettingsProperty.Jsii$Proxy) o;

                if (this.convert608To708 != null ? !this.convert608To708.equals(that.convert608To708) : that.convert608To708 != null) return false;
                if (this.scte20Detection != null ? !this.scte20Detection.equals(that.scte20Detection) : that.scte20Detection != null) return false;
                if (this.source608ChannelNumber != null ? !this.source608ChannelNumber.equals(that.source608ChannelNumber) : that.source608ChannelNumber != null) return false;
                return this.source608TrackNumber != null ? this.source608TrackNumber.equals(that.source608TrackNumber) : that.source608TrackNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.convert608To708 != null ? this.convert608To708.hashCode() : 0;
                result = 31 * result + (this.scte20Detection != null ? this.scte20Detection.hashCode() : 0);
                result = 31 * result + (this.source608ChannelNumber != null ? this.source608ChannelNumber.hashCode() : 0);
                result = 31 * result + (this.source608TrackNumber != null ? this.source608TrackNumber.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for the encoding of outputs.
     * <p>
     * This entity is at the top level in the channel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * EncoderSettingsProperty encoderSettingsProperty = EncoderSettingsProperty.builder()
     *         .audioDescriptions(List.of(AudioDescriptionProperty.builder()
     *                 .audioNormalizationSettings(AudioNormalizationSettingsProperty.builder()
     *                         .algorithm("algorithm")
     *                         .algorithmControl("algorithmControl")
     *                         .targetLkfs(123)
     *                         .build())
     *                 .audioSelectorName("audioSelectorName")
     *                 .audioType("audioType")
     *                 .audioTypeControl("audioTypeControl")
     *                 .audioWatermarkingSettings(AudioWatermarkSettingsProperty.builder()
     *                         .nielsenWatermarksSettings(NielsenWatermarksSettingsProperty.builder()
     *                                 .nielsenCbetSettings(NielsenCBETProperty.builder()
     *                                         .cbetCheckDigitString("cbetCheckDigitString")
     *                                         .cbetStepaside("cbetStepaside")
     *                                         .csid("csid")
     *                                         .build())
     *                                 .nielsenDistributionType("nielsenDistributionType")
     *                                 .nielsenNaesIiNwSettings(NielsenNaesIiNwProperty.builder()
     *                                         .checkDigitString("checkDigitString")
     *                                         .sid(123)
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .codecSettings(AudioCodecSettingsProperty.builder()
     *                         .aacSettings(AacSettingsProperty.builder()
     *                                 .bitrate(123)
     *                                 .codingMode("codingMode")
     *                                 .inputType("inputType")
     *                                 .profile("profile")
     *                                 .rateControlMode("rateControlMode")
     *                                 .rawFormat("rawFormat")
     *                                 .sampleRate(123)
     *                                 .spec("spec")
     *                                 .vbrQuality("vbrQuality")
     *                                 .build())
     *                         .ac3Settings(Ac3SettingsProperty.builder()
     *                                 .bitrate(123)
     *                                 .bitstreamMode("bitstreamMode")
     *                                 .codingMode("codingMode")
     *                                 .dialnorm(123)
     *                                 .drcProfile("drcProfile")
     *                                 .lfeFilter("lfeFilter")
     *                                 .metadataControl("metadataControl")
     *                                 .build())
     *                         .eac3Settings(Eac3SettingsProperty.builder()
     *                                 .attenuationControl("attenuationControl")
     *                                 .bitrate(123)
     *                                 .bitstreamMode("bitstreamMode")
     *                                 .codingMode("codingMode")
     *                                 .dcFilter("dcFilter")
     *                                 .dialnorm(123)
     *                                 .drcLine("drcLine")
     *                                 .drcRf("drcRf")
     *                                 .lfeControl("lfeControl")
     *                                 .lfeFilter("lfeFilter")
     *                                 .loRoCenterMixLevel(123)
     *                                 .loRoSurroundMixLevel(123)
     *                                 .ltRtCenterMixLevel(123)
     *                                 .ltRtSurroundMixLevel(123)
     *                                 .metadataControl("metadataControl")
     *                                 .passthroughControl("passthroughControl")
     *                                 .phaseControl("phaseControl")
     *                                 .stereoDownmix("stereoDownmix")
     *                                 .surroundExMode("surroundExMode")
     *                                 .surroundMode("surroundMode")
     *                                 .build())
     *                         .mp2Settings(Mp2SettingsProperty.builder()
     *                                 .bitrate(123)
     *                                 .codingMode("codingMode")
     *                                 .sampleRate(123)
     *                                 .build())
     *                         .passThroughSettings(PassThroughSettingsProperty.builder().build())
     *                         .wavSettings(WavSettingsProperty.builder()
     *                                 .bitDepth(123)
     *                                 .codingMode("codingMode")
     *                                 .sampleRate(123)
     *                                 .build())
     *                         .build())
     *                 .languageCode("languageCode")
     *                 .languageCodeControl("languageCodeControl")
     *                 .name("name")
     *                 .remixSettings(RemixSettingsProperty.builder()
     *                         .channelMappings(List.of(AudioChannelMappingProperty.builder()
     *                                 .inputChannelLevels(List.of(InputChannelLevelProperty.builder()
     *                                         .gain(123)
     *                                         .inputChannel(123)
     *                                         .build()))
     *                                 .outputChannel(123)
     *                                 .build()))
     *                         .channelsIn(123)
     *                         .channelsOut(123)
     *                         .build())
     *                 .streamName("streamName")
     *                 .build()))
     *         .availBlanking(AvailBlankingProperty.builder()
     *                 .availBlankingImage(InputLocationProperty.builder()
     *                         .passwordParam("passwordParam")
     *                         .uri("uri")
     *                         .username("username")
     *                         .build())
     *                 .state("state")
     *                 .build())
     *         .availConfiguration(AvailConfigurationProperty.builder()
     *                 .availSettings(AvailSettingsProperty.builder()
     *                         .scte35SpliceInsert(Scte35SpliceInsertProperty.builder()
     *                                 .adAvailOffset(123)
     *                                 .noRegionalBlackoutFlag("noRegionalBlackoutFlag")
     *                                 .webDeliveryAllowedFlag("webDeliveryAllowedFlag")
     *                                 .build())
     *                         .scte35TimeSignalApos(Scte35TimeSignalAposProperty.builder()
     *                                 .adAvailOffset(123)
     *                                 .noRegionalBlackoutFlag("noRegionalBlackoutFlag")
     *                                 .webDeliveryAllowedFlag("webDeliveryAllowedFlag")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .blackoutSlate(BlackoutSlateProperty.builder()
     *                 .blackoutSlateImage(InputLocationProperty.builder()
     *                         .passwordParam("passwordParam")
     *                         .uri("uri")
     *                         .username("username")
     *                         .build())
     *                 .networkEndBlackout("networkEndBlackout")
     *                 .networkEndBlackoutImage(InputLocationProperty.builder()
     *                         .passwordParam("passwordParam")
     *                         .uri("uri")
     *                         .username("username")
     *                         .build())
     *                 .networkId("networkId")
     *                 .state("state")
     *                 .build())
     *         .captionDescriptions(List.of(CaptionDescriptionProperty.builder()
     *                 .captionSelectorName("captionSelectorName")
     *                 .destinationSettings(CaptionDestinationSettingsProperty.builder()
     *                         .aribDestinationSettings(AribDestinationSettingsProperty.builder().build())
     *                         .burnInDestinationSettings(BurnInDestinationSettingsProperty.builder()
     *                                 .alignment("alignment")
     *                                 .backgroundColor("backgroundColor")
     *                                 .backgroundOpacity(123)
     *                                 .font(InputLocationProperty.builder()
     *                                         .passwordParam("passwordParam")
     *                                         .uri("uri")
     *                                         .username("username")
     *                                         .build())
     *                                 .fontColor("fontColor")
     *                                 .fontOpacity(123)
     *                                 .fontResolution(123)
     *                                 .fontSize("fontSize")
     *                                 .outlineColor("outlineColor")
     *                                 .outlineSize(123)
     *                                 .shadowColor("shadowColor")
     *                                 .shadowOpacity(123)
     *                                 .shadowXOffset(123)
     *                                 .shadowYOffset(123)
     *                                 .teletextGridControl("teletextGridControl")
     *                                 .xPosition(123)
     *                                 .yPosition(123)
     *                                 .build())
     *                         .dvbSubDestinationSettings(DvbSubDestinationSettingsProperty.builder()
     *                                 .alignment("alignment")
     *                                 .backgroundColor("backgroundColor")
     *                                 .backgroundOpacity(123)
     *                                 .font(InputLocationProperty.builder()
     *                                         .passwordParam("passwordParam")
     *                                         .uri("uri")
     *                                         .username("username")
     *                                         .build())
     *                                 .fontColor("fontColor")
     *                                 .fontOpacity(123)
     *                                 .fontResolution(123)
     *                                 .fontSize("fontSize")
     *                                 .outlineColor("outlineColor")
     *                                 .outlineSize(123)
     *                                 .shadowColor("shadowColor")
     *                                 .shadowOpacity(123)
     *                                 .shadowXOffset(123)
     *                                 .shadowYOffset(123)
     *                                 .teletextGridControl("teletextGridControl")
     *                                 .xPosition(123)
     *                                 .yPosition(123)
     *                                 .build())
     *                         .ebuTtDDestinationSettings(EbuTtDDestinationSettingsProperty.builder()
     *                                 .copyrightHolder("copyrightHolder")
     *                                 .fillLineGap("fillLineGap")
     *                                 .fontFamily("fontFamily")
     *                                 .styleControl("styleControl")
     *                                 .build())
     *                         .embeddedDestinationSettings(EmbeddedDestinationSettingsProperty.builder().build())
     *                         .embeddedPlusScte20DestinationSettings(EmbeddedPlusScte20DestinationSettingsProperty.builder().build())
     *                         .rtmpCaptionInfoDestinationSettings(RtmpCaptionInfoDestinationSettingsProperty.builder().build())
     *                         .scte20PlusEmbeddedDestinationSettings(Scte20PlusEmbeddedDestinationSettingsProperty.builder().build())
     *                         .scte27DestinationSettings(Scte27DestinationSettingsProperty.builder().build())
     *                         .smpteTtDestinationSettings(SmpteTtDestinationSettingsProperty.builder().build())
     *                         .teletextDestinationSettings(TeletextDestinationSettingsProperty.builder().build())
     *                         .ttmlDestinationSettings(TtmlDestinationSettingsProperty.builder()
     *                                 .styleControl("styleControl")
     *                                 .build())
     *                         .webvttDestinationSettings(WebvttDestinationSettingsProperty.builder()
     *                                 .styleControl("styleControl")
     *                                 .build())
     *                         .build())
     *                 .languageCode("languageCode")
     *                 .languageDescription("languageDescription")
     *                 .name("name")
     *                 .build()))
     *         .featureActivations(FeatureActivationsProperty.builder()
     *                 .inputPrepareScheduleActions("inputPrepareScheduleActions")
     *                 .build())
     *         .globalConfiguration(GlobalConfigurationProperty.builder()
     *                 .initialAudioGain(123)
     *                 .inputEndAction("inputEndAction")
     *                 .inputLossBehavior(InputLossBehaviorProperty.builder()
     *                         .blackFrameMsec(123)
     *                         .inputLossImageColor("inputLossImageColor")
     *                         .inputLossImageSlate(InputLocationProperty.builder()
     *                                 .passwordParam("passwordParam")
     *                                 .uri("uri")
     *                                 .username("username")
     *                                 .build())
     *                         .inputLossImageType("inputLossImageType")
     *                         .repeatFrameMsec(123)
     *                         .build())
     *                 .outputLockingMode("outputLockingMode")
     *                 .outputTimingSource("outputTimingSource")
     *                 .supportLowFramerateInputs("supportLowFramerateInputs")
     *                 .build())
     *         .motionGraphicsConfiguration(MotionGraphicsConfigurationProperty.builder()
     *                 .motionGraphicsInsertion("motionGraphicsInsertion")
     *                 .motionGraphicsSettings(MotionGraphicsSettingsProperty.builder()
     *                         .htmlMotionGraphicsSettings(HtmlMotionGraphicsSettingsProperty.builder().build())
     *                         .build())
     *                 .build())
     *         .nielsenConfiguration(NielsenConfigurationProperty.builder()
     *                 .distributorId("distributorId")
     *                 .nielsenPcmToId3Tagging("nielsenPcmToId3Tagging")
     *                 .build())
     *         .outputGroups(List.of(OutputGroupProperty.builder()
     *                 .name("name")
     *                 .outputGroupSettings(OutputGroupSettingsProperty.builder()
     *                         .archiveGroupSettings(ArchiveGroupSettingsProperty.builder()
     *                                 .archiveCdnSettings(ArchiveCdnSettingsProperty.builder()
     *                                         .archiveS3Settings(ArchiveS3SettingsProperty.builder()
     *                                                 .cannedAcl("cannedAcl")
     *                                                 .build())
     *                                         .build())
     *                                 .destination(OutputLocationRefProperty.builder()
     *                                         .destinationRefId("destinationRefId")
     *                                         .build())
     *                                 .rolloverInterval(123)
     *                                 .build())
     *                         .frameCaptureGroupSettings(FrameCaptureGroupSettingsProperty.builder()
     *                                 .destination(OutputLocationRefProperty.builder()
     *                                         .destinationRefId("destinationRefId")
     *                                         .build())
     *                                 .frameCaptureCdnSettings(FrameCaptureCdnSettingsProperty.builder()
     *                                         .frameCaptureS3Settings(FrameCaptureS3SettingsProperty.builder()
     *                                                 .cannedAcl("cannedAcl")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .hlsGroupSettings(HlsGroupSettingsProperty.builder()
     *                                 .adMarkers(List.of("adMarkers"))
     *                                 .baseUrlContent("baseUrlContent")
     *                                 .baseUrlContent1("baseUrlContent1")
     *                                 .baseUrlManifest("baseUrlManifest")
     *                                 .baseUrlManifest1("baseUrlManifest1")
     *                                 .captionLanguageMappings(List.of(CaptionLanguageMappingProperty.builder()
     *                                         .captionChannel(123)
     *                                         .languageCode("languageCode")
     *                                         .languageDescription("languageDescription")
     *                                         .build()))
     *                                 .captionLanguageSetting("captionLanguageSetting")
     *                                 .clientCache("clientCache")
     *                                 .codecSpecification("codecSpecification")
     *                                 .constantIv("constantIv")
     *                                 .destination(OutputLocationRefProperty.builder()
     *                                         .destinationRefId("destinationRefId")
     *                                         .build())
     *                                 .directoryStructure("directoryStructure")
     *                                 .discontinuityTags("discontinuityTags")
     *                                 .encryptionType("encryptionType")
     *                                 .hlsCdnSettings(HlsCdnSettingsProperty.builder()
     *                                         .hlsAkamaiSettings(HlsAkamaiSettingsProperty.builder()
     *                                                 .connectionRetryInterval(123)
     *                                                 .filecacheDuration(123)
     *                                                 .httpTransferMode("httpTransferMode")
     *                                                 .numRetries(123)
     *                                                 .restartDelay(123)
     *                                                 .salt("salt")
     *                                                 .token("token")
     *                                                 .build())
     *                                         .hlsBasicPutSettings(HlsBasicPutSettingsProperty.builder()
     *                                                 .connectionRetryInterval(123)
     *                                                 .filecacheDuration(123)
     *                                                 .numRetries(123)
     *                                                 .restartDelay(123)
     *                                                 .build())
     *                                         .hlsMediaStoreSettings(HlsMediaStoreSettingsProperty.builder()
     *                                                 .connectionRetryInterval(123)
     *                                                 .filecacheDuration(123)
     *                                                 .mediaStoreStorageClass("mediaStoreStorageClass")
     *                                                 .numRetries(123)
     *                                                 .restartDelay(123)
     *                                                 .build())
     *                                         .hlsS3Settings(HlsS3SettingsProperty.builder()
     *                                                 .cannedAcl("cannedAcl")
     *                                                 .build())
     *                                         .hlsWebdavSettings(HlsWebdavSettingsProperty.builder()
     *                                                 .connectionRetryInterval(123)
     *                                                 .filecacheDuration(123)
     *                                                 .httpTransferMode("httpTransferMode")
     *                                                 .numRetries(123)
     *                                                 .restartDelay(123)
     *                                                 .build())
     *                                         .build())
     *                                 .hlsId3SegmentTagging("hlsId3SegmentTagging")
     *                                 .iFrameOnlyPlaylists("iFrameOnlyPlaylists")
     *                                 .incompleteSegmentBehavior("incompleteSegmentBehavior")
     *                                 .indexNSegments(123)
     *                                 .inputLossAction("inputLossAction")
     *                                 .ivInManifest("ivInManifest")
     *                                 .ivSource("ivSource")
     *                                 .keepSegments(123)
     *                                 .keyFormat("keyFormat")
     *                                 .keyFormatVersions("keyFormatVersions")
     *                                 .keyProviderSettings(KeyProviderSettingsProperty.builder()
     *                                         .staticKeySettings(StaticKeySettingsProperty.builder()
     *                                                 .keyProviderServer(InputLocationProperty.builder()
     *                                                         .passwordParam("passwordParam")
     *                                                         .uri("uri")
     *                                                         .username("username")
     *                                                         .build())
     *                                                 .staticKeyValue("staticKeyValue")
     *                                                 .build())
     *                                         .build())
     *                                 .manifestCompression("manifestCompression")
     *                                 .manifestDurationFormat("manifestDurationFormat")
     *                                 .minSegmentLength(123)
     *                                 .mode("mode")
     *                                 .outputSelection("outputSelection")
     *                                 .programDateTime("programDateTime")
     *                                 .programDateTimeClock("programDateTimeClock")
     *                                 .programDateTimePeriod(123)
     *                                 .redundantManifest("redundantManifest")
     *                                 .segmentationMode("segmentationMode")
     *                                 .segmentLength(123)
     *                                 .segmentsPerSubdirectory(123)
     *                                 .streamInfResolution("streamInfResolution")
     *                                 .timedMetadataId3Frame("timedMetadataId3Frame")
     *                                 .timedMetadataId3Period(123)
     *                                 .timestampDeltaMilliseconds(123)
     *                                 .tsFileMode("tsFileMode")
     *                                 .build())
     *                         .mediaPackageGroupSettings(MediaPackageGroupSettingsProperty.builder()
     *                                 .destination(OutputLocationRefProperty.builder()
     *                                         .destinationRefId("destinationRefId")
     *                                         .build())
     *                                 .build())
     *                         .msSmoothGroupSettings(MsSmoothGroupSettingsProperty.builder()
     *                                 .acquisitionPointId("acquisitionPointId")
     *                                 .audioOnlyTimecodeControl("audioOnlyTimecodeControl")
     *                                 .certificateMode("certificateMode")
     *                                 .connectionRetryInterval(123)
     *                                 .destination(OutputLocationRefProperty.builder()
     *                                         .destinationRefId("destinationRefId")
     *                                         .build())
     *                                 .eventId("eventId")
     *                                 .eventIdMode("eventIdMode")
     *                                 .eventStopBehavior("eventStopBehavior")
     *                                 .filecacheDuration(123)
     *                                 .fragmentLength(123)
     *                                 .inputLossAction("inputLossAction")
     *                                 .numRetries(123)
     *                                 .restartDelay(123)
     *                                 .segmentationMode("segmentationMode")
     *                                 .sendDelayMs(123)
     *                                 .sparseTrackType("sparseTrackType")
     *                                 .streamManifestBehavior("streamManifestBehavior")
     *                                 .timestampOffset("timestampOffset")
     *                                 .timestampOffsetMode("timestampOffsetMode")
     *                                 .build())
     *                         .multiplexGroupSettings(MultiplexGroupSettingsProperty.builder().build())
     *                         .rtmpGroupSettings(RtmpGroupSettingsProperty.builder()
     *                                 .adMarkers(List.of("adMarkers"))
     *                                 .authenticationScheme("authenticationScheme")
     *                                 .cacheFullBehavior("cacheFullBehavior")
     *                                 .cacheLength(123)
     *                                 .captionData("captionData")
     *                                 .inputLossAction("inputLossAction")
     *                                 .restartDelay(123)
     *                                 .build())
     *                         .udpGroupSettings(UdpGroupSettingsProperty.builder()
     *                                 .inputLossAction("inputLossAction")
     *                                 .timedMetadataId3Frame("timedMetadataId3Frame")
     *                                 .timedMetadataId3Period(123)
     *                                 .build())
     *                         .build())
     *                 .outputs(List.of(OutputProperty.builder()
     *                         .audioDescriptionNames(List.of("audioDescriptionNames"))
     *                         .captionDescriptionNames(List.of("captionDescriptionNames"))
     *                         .outputName("outputName")
     *                         .outputSettings(OutputSettingsProperty.builder()
     *                                 .archiveOutputSettings(ArchiveOutputSettingsProperty.builder()
     *                                         .containerSettings(ArchiveContainerSettingsProperty.builder()
     *                                                 .m2TsSettings(M2tsSettingsProperty.builder()
     *                                                         .absentInputAudioBehavior("absentInputAudioBehavior")
     *                                                         .arib("arib")
     *                                                         .aribCaptionsPid("aribCaptionsPid")
     *                                                         .aribCaptionsPidControl("aribCaptionsPidControl")
     *                                                         .audioBufferModel("audioBufferModel")
     *                                                         .audioFramesPerPes(123)
     *                                                         .audioPids("audioPids")
     *                                                         .audioStreamType("audioStreamType")
     *                                                         .bitrate(123)
     *                                                         .bufferModel("bufferModel")
     *                                                         .ccDescriptor("ccDescriptor")
     *                                                         .dvbNitSettings(DvbNitSettingsProperty.builder()
     *                                                                 .networkId(123)
     *                                                                 .networkName("networkName")
     *                                                                 .repInterval(123)
     *                                                                 .build())
     *                                                         .dvbSdtSettings(DvbSdtSettingsProperty.builder()
     *                                                                 .outputSdt("outputSdt")
     *                                                                 .repInterval(123)
     *                                                                 .serviceName("serviceName")
     *                                                                 .serviceProviderName("serviceProviderName")
     *                                                                 .build())
     *                                                         .dvbSubPids("dvbSubPids")
     *                                                         .dvbTdtSettings(DvbTdtSettingsProperty.builder()
     *                                                                 .repInterval(123)
     *                                                                 .build())
     *                                                         .dvbTeletextPid("dvbTeletextPid")
     *                                                         .ebif("ebif")
     *                                                         .ebpAudioInterval("ebpAudioInterval")
     *                                                         .ebpLookaheadMs(123)
     *                                                         .ebpPlacement("ebpPlacement")
     *                                                         .ecmPid("ecmPid")
     *                                                         .esRateInPes("esRateInPes")
     *                                                         .etvPlatformPid("etvPlatformPid")
     *                                                         .etvSignalPid("etvSignalPid")
     *                                                         .fragmentTime(123)
     *                                                         .klv("klv")
     *                                                         .klvDataPids("klvDataPids")
     *                                                         .nielsenId3Behavior("nielsenId3Behavior")
     *                                                         .nullPacketBitrate(123)
     *                                                         .patInterval(123)
     *                                                         .pcrControl("pcrControl")
     *                                                         .pcrPeriod(123)
     *                                                         .pcrPid("pcrPid")
     *                                                         .pmtInterval(123)
     *                                                         .pmtPid("pmtPid")
     *                                                         .programNum(123)
     *                                                         .rateMode("rateMode")
     *                                                         .scte27Pids("scte27Pids")
     *                                                         .scte35Control("scte35Control")
     *                                                         .scte35Pid("scte35Pid")
     *                                                         .segmentationMarkers("segmentationMarkers")
     *                                                         .segmentationStyle("segmentationStyle")
     *                                                         .segmentationTime(123)
     *                                                         .timedMetadataBehavior("timedMetadataBehavior")
     *                                                         .timedMetadataPid("timedMetadataPid")
     *                                                         .transportStreamId(123)
     *                                                         .videoPid("videoPid")
     *                                                         .build())
     *                                                 .rawSettings(RawSettingsProperty.builder().build())
     *                                                 .build())
     *                                         .extension("extension")
     *                                         .nameModifier("nameModifier")
     *                                         .build())
     *                                 .frameCaptureOutputSettings(FrameCaptureOutputSettingsProperty.builder()
     *                                         .nameModifier("nameModifier")
     *                                         .build())
     *                                 .hlsOutputSettings(HlsOutputSettingsProperty.builder()
     *                                         .h265PackagingType("h265PackagingType")
     *                                         .hlsSettings(HlsSettingsProperty.builder()
     *                                                 .audioOnlyHlsSettings(AudioOnlyHlsSettingsProperty.builder()
     *                                                         .audioGroupId("audioGroupId")
     *                                                         .audioOnlyImage(InputLocationProperty.builder()
     *                                                                 .passwordParam("passwordParam")
     *                                                                 .uri("uri")
     *                                                                 .username("username")
     *                                                                 .build())
     *                                                         .audioTrackType("audioTrackType")
     *                                                         .segmentType("segmentType")
     *                                                         .build())
     *                                                 .fmp4HlsSettings(Fmp4HlsSettingsProperty.builder()
     *                                                         .audioRenditionSets("audioRenditionSets")
     *                                                         .nielsenId3Behavior("nielsenId3Behavior")
     *                                                         .timedMetadataBehavior("timedMetadataBehavior")
     *                                                         .build())
     *                                                 .frameCaptureHlsSettings(FrameCaptureHlsSettingsProperty.builder().build())
     *                                                 .standardHlsSettings(StandardHlsSettingsProperty.builder()
     *                                                         .audioRenditionSets("audioRenditionSets")
     *                                                         .m3U8Settings(M3u8SettingsProperty.builder()
     *                                                                 .audioFramesPerPes(123)
     *                                                                 .audioPids("audioPids")
     *                                                                 .ecmPid("ecmPid")
     *                                                                 .nielsenId3Behavior("nielsenId3Behavior")
     *                                                                 .patInterval(123)
     *                                                                 .pcrControl("pcrControl")
     *                                                                 .pcrPeriod(123)
     *                                                                 .pcrPid("pcrPid")
     *                                                                 .pmtInterval(123)
     *                                                                 .pmtPid("pmtPid")
     *                                                                 .programNum(123)
     *                                                                 .scte35Behavior("scte35Behavior")
     *                                                                 .scte35Pid("scte35Pid")
     *                                                                 .timedMetadataBehavior("timedMetadataBehavior")
     *                                                                 .timedMetadataPid("timedMetadataPid")
     *                                                                 .transportStreamId(123)
     *                                                                 .videoPid("videoPid")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .build())
     *                                         .nameModifier("nameModifier")
     *                                         .segmentModifier("segmentModifier")
     *                                         .build())
     *                                 .mediaPackageOutputSettings(MediaPackageOutputSettingsProperty.builder().build())
     *                                 .msSmoothOutputSettings(MsSmoothOutputSettingsProperty.builder()
     *                                         .h265PackagingType("h265PackagingType")
     *                                         .nameModifier("nameModifier")
     *                                         .build())
     *                                 .multiplexOutputSettings(MultiplexOutputSettingsProperty.builder()
     *                                         .destination(OutputLocationRefProperty.builder()
     *                                                 .destinationRefId("destinationRefId")
     *                                                 .build())
     *                                         .build())
     *                                 .rtmpOutputSettings(RtmpOutputSettingsProperty.builder()
     *                                         .certificateMode("certificateMode")
     *                                         .connectionRetryInterval(123)
     *                                         .destination(OutputLocationRefProperty.builder()
     *                                                 .destinationRefId("destinationRefId")
     *                                                 .build())
     *                                         .numRetries(123)
     *                                         .build())
     *                                 .udpOutputSettings(UdpOutputSettingsProperty.builder()
     *                                         .bufferMsec(123)
     *                                         .containerSettings(UdpContainerSettingsProperty.builder()
     *                                                 .m2TsSettings(M2tsSettingsProperty.builder()
     *                                                         .absentInputAudioBehavior("absentInputAudioBehavior")
     *                                                         .arib("arib")
     *                                                         .aribCaptionsPid("aribCaptionsPid")
     *                                                         .aribCaptionsPidControl("aribCaptionsPidControl")
     *                                                         .audioBufferModel("audioBufferModel")
     *                                                         .audioFramesPerPes(123)
     *                                                         .audioPids("audioPids")
     *                                                         .audioStreamType("audioStreamType")
     *                                                         .bitrate(123)
     *                                                         .bufferModel("bufferModel")
     *                                                         .ccDescriptor("ccDescriptor")
     *                                                         .dvbNitSettings(DvbNitSettingsProperty.builder()
     *                                                                 .networkId(123)
     *                                                                 .networkName("networkName")
     *                                                                 .repInterval(123)
     *                                                                 .build())
     *                                                         .dvbSdtSettings(DvbSdtSettingsProperty.builder()
     *                                                                 .outputSdt("outputSdt")
     *                                                                 .repInterval(123)
     *                                                                 .serviceName("serviceName")
     *                                                                 .serviceProviderName("serviceProviderName")
     *                                                                 .build())
     *                                                         .dvbSubPids("dvbSubPids")
     *                                                         .dvbTdtSettings(DvbTdtSettingsProperty.builder()
     *                                                                 .repInterval(123)
     *                                                                 .build())
     *                                                         .dvbTeletextPid("dvbTeletextPid")
     *                                                         .ebif("ebif")
     *                                                         .ebpAudioInterval("ebpAudioInterval")
     *                                                         .ebpLookaheadMs(123)
     *                                                         .ebpPlacement("ebpPlacement")
     *                                                         .ecmPid("ecmPid")
     *                                                         .esRateInPes("esRateInPes")
     *                                                         .etvPlatformPid("etvPlatformPid")
     *                                                         .etvSignalPid("etvSignalPid")
     *                                                         .fragmentTime(123)
     *                                                         .klv("klv")
     *                                                         .klvDataPids("klvDataPids")
     *                                                         .nielsenId3Behavior("nielsenId3Behavior")
     *                                                         .nullPacketBitrate(123)
     *                                                         .patInterval(123)
     *                                                         .pcrControl("pcrControl")
     *                                                         .pcrPeriod(123)
     *                                                         .pcrPid("pcrPid")
     *                                                         .pmtInterval(123)
     *                                                         .pmtPid("pmtPid")
     *                                                         .programNum(123)
     *                                                         .rateMode("rateMode")
     *                                                         .scte27Pids("scte27Pids")
     *                                                         .scte35Control("scte35Control")
     *                                                         .scte35Pid("scte35Pid")
     *                                                         .segmentationMarkers("segmentationMarkers")
     *                                                         .segmentationStyle("segmentationStyle")
     *                                                         .segmentationTime(123)
     *                                                         .timedMetadataBehavior("timedMetadataBehavior")
     *                                                         .timedMetadataPid("timedMetadataPid")
     *                                                         .transportStreamId(123)
     *                                                         .videoPid("videoPid")
     *                                                         .build())
     *                                                 .build())
     *                                         .destination(OutputLocationRefProperty.builder()
     *                                                 .destinationRefId("destinationRefId")
     *                                                 .build())
     *                                         .fecOutputSettings(FecOutputSettingsProperty.builder()
     *                                                 .columnDepth(123)
     *                                                 .includeFec("includeFec")
     *                                                 .rowLength(123)
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .videoDescriptionName("videoDescriptionName")
     *                         .build()))
     *                 .build()))
     *         .timecodeConfig(TimecodeConfigProperty.builder()
     *                 .source("source")
     *                 .syncThreshold(123)
     *                 .build())
     *         .videoDescriptions(List.of(VideoDescriptionProperty.builder()
     *                 .codecSettings(VideoCodecSettingsProperty.builder()
     *                         .frameCaptureSettings(FrameCaptureSettingsProperty.builder()
     *                                 .captureInterval(123)
     *                                 .captureIntervalUnits("captureIntervalUnits")
     *                                 .build())
     *                         .h264Settings(H264SettingsProperty.builder()
     *                                 .adaptiveQuantization("adaptiveQuantization")
     *                                 .afdSignaling("afdSignaling")
     *                                 .bitrate(123)
     *                                 .bufFillPct(123)
     *                                 .bufSize(123)
     *                                 .colorMetadata("colorMetadata")
     *                                 .colorSpaceSettings(H264ColorSpaceSettingsProperty.builder()
     *                                         .colorSpacePassthroughSettings(ColorSpacePassthroughSettingsProperty.builder().build())
     *                                         .rec601Settings(Rec601SettingsProperty.builder().build())
     *                                         .rec709Settings(Rec709SettingsProperty.builder().build())
     *                                         .build())
     *                                 .entropyEncoding("entropyEncoding")
     *                                 .filterSettings(H264FilterSettingsProperty.builder()
     *                                         .temporalFilterSettings(TemporalFilterSettingsProperty.builder()
     *                                                 .postFilterSharpening("postFilterSharpening")
     *                                                 .strength("strength")
     *                                                 .build())
     *                                         .build())
     *                                 .fixedAfd("fixedAfd")
     *                                 .flickerAq("flickerAq")
     *                                 .forceFieldPictures("forceFieldPictures")
     *                                 .framerateControl("framerateControl")
     *                                 .framerateDenominator(123)
     *                                 .framerateNumerator(123)
     *                                 .gopBReference("gopBReference")
     *                                 .gopClosedCadence(123)
     *                                 .gopNumBFrames(123)
     *                                 .gopSize(123)
     *                                 .gopSizeUnits("gopSizeUnits")
     *                                 .level("level")
     *                                 .lookAheadRateControl("lookAheadRateControl")
     *                                 .maxBitrate(123)
     *                                 .minIInterval(123)
     *                                 .numRefFrames(123)
     *                                 .parControl("parControl")
     *                                 .parDenominator(123)
     *                                 .parNumerator(123)
     *                                 .profile("profile")
     *                                 .qualityLevel("qualityLevel")
     *                                 .qvbrQualityLevel(123)
     *                                 .rateControlMode("rateControlMode")
     *                                 .scanType("scanType")
     *                                 .sceneChangeDetect("sceneChangeDetect")
     *                                 .slices(123)
     *                                 .softness(123)
     *                                 .spatialAq("spatialAq")
     *                                 .subgopLength("subgopLength")
     *                                 .syntax("syntax")
     *                                 .temporalAq("temporalAq")
     *                                 .timecodeInsertion("timecodeInsertion")
     *                                 .build())
     *                         .h265Settings(H265SettingsProperty.builder()
     *                                 .adaptiveQuantization("adaptiveQuantization")
     *                                 .afdSignaling("afdSignaling")
     *                                 .alternativeTransferFunction("alternativeTransferFunction")
     *                                 .bitrate(123)
     *                                 .bufSize(123)
     *                                 .colorMetadata("colorMetadata")
     *                                 .colorSpaceSettings(H265ColorSpaceSettingsProperty.builder()
     *                                         .colorSpacePassthroughSettings(ColorSpacePassthroughSettingsProperty.builder().build())
     *                                         .hdr10Settings(Hdr10SettingsProperty.builder()
     *                                                 .maxCll(123)
     *                                                 .maxFall(123)
     *                                                 .build())
     *                                         .rec601Settings(Rec601SettingsProperty.builder().build())
     *                                         .rec709Settings(Rec709SettingsProperty.builder().build())
     *                                         .build())
     *                                 .filterSettings(H265FilterSettingsProperty.builder()
     *                                         .temporalFilterSettings(TemporalFilterSettingsProperty.builder()
     *                                                 .postFilterSharpening("postFilterSharpening")
     *                                                 .strength("strength")
     *                                                 .build())
     *                                         .build())
     *                                 .fixedAfd("fixedAfd")
     *                                 .flickerAq("flickerAq")
     *                                 .framerateDenominator(123)
     *                                 .framerateNumerator(123)
     *                                 .gopClosedCadence(123)
     *                                 .gopSize(123)
     *                                 .gopSizeUnits("gopSizeUnits")
     *                                 .level("level")
     *                                 .lookAheadRateControl("lookAheadRateControl")
     *                                 .maxBitrate(123)
     *                                 .minIInterval(123)
     *                                 .parDenominator(123)
     *                                 .parNumerator(123)
     *                                 .profile("profile")
     *                                 .qvbrQualityLevel(123)
     *                                 .rateControlMode("rateControlMode")
     *                                 .scanType("scanType")
     *                                 .sceneChangeDetect("sceneChangeDetect")
     *                                 .slices(123)
     *                                 .tier("tier")
     *                                 .timecodeInsertion("timecodeInsertion")
     *                                 .build())
     *                         .mpeg2Settings(Mpeg2SettingsProperty.builder()
     *                                 .adaptiveQuantization("adaptiveQuantization")
     *                                 .afdSignaling("afdSignaling")
     *                                 .colorMetadata("colorMetadata")
     *                                 .colorSpace("colorSpace")
     *                                 .displayAspectRatio("displayAspectRatio")
     *                                 .filterSettings(Mpeg2FilterSettingsProperty.builder()
     *                                         .temporalFilterSettings(TemporalFilterSettingsProperty.builder()
     *                                                 .postFilterSharpening("postFilterSharpening")
     *                                                 .strength("strength")
     *                                                 .build())
     *                                         .build())
     *                                 .fixedAfd("fixedAfd")
     *                                 .framerateDenominator(123)
     *                                 .framerateNumerator(123)
     *                                 .gopClosedCadence(123)
     *                                 .gopNumBFrames(123)
     *                                 .gopSize(123)
     *                                 .gopSizeUnits("gopSizeUnits")
     *                                 .scanType("scanType")
     *                                 .subgopLength("subgopLength")
     *                                 .timecodeInsertion("timecodeInsertion")
     *                                 .build())
     *                         .build())
     *                 .height(123)
     *                 .name("name")
     *                 .respondToAfd("respondToAfd")
     *                 .scalingBehavior("scalingBehavior")
     *                 .sharpness(123)
     *                 .width(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.EncoderSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(EncoderSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncoderSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The encoding information for output audio.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioDescriptions() {
            return null;
        }

        /**
         * The settings for ad avail blanking.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAvailBlanking() {
            return null;
        }

        /**
         * The configuration settings for the ad avail handling.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAvailConfiguration() {
            return null;
        }

        /**
         * The settings for the blackout slate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlackoutSlate() {
            return null;
        }

        /**
         * The encoding information for output captions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCaptionDescriptions() {
            return null;
        }

        /**
         * Settings to enable specific features.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFeatureActivations() {
            return null;
        }

        /**
         * The configuration settings that apply to the entire channel.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGlobalConfiguration() {
            return null;
        }

        /**
         * Settings to enable and configure the motion graphics overlay feature in the channel.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMotionGraphicsConfiguration() {
            return null;
        }

        /**
         * The settings to configure Nielsen watermarks.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNielsenConfiguration() {
            return null;
        }

        /**
         * The settings for the output groups in the channel.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputGroups() {
            return null;
        }

        /**
         * Contains settings used to acquire and adjust timecode information from the inputs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimecodeConfig() {
            return null;
        }

        /**
         * The encoding information for output videos.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVideoDescriptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncoderSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncoderSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncoderSettingsProperty> {
            java.lang.Object audioDescriptions;
            java.lang.Object availBlanking;
            java.lang.Object availConfiguration;
            java.lang.Object blackoutSlate;
            java.lang.Object captionDescriptions;
            java.lang.Object featureActivations;
            java.lang.Object globalConfiguration;
            java.lang.Object motionGraphicsConfiguration;
            java.lang.Object nielsenConfiguration;
            java.lang.Object outputGroups;
            java.lang.Object timecodeConfig;
            java.lang.Object videoDescriptions;

            /**
             * Sets the value of {@link EncoderSettingsProperty#getAudioDescriptions}
             * @param audioDescriptions The encoding information for output audio.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioDescriptions(software.amazon.awscdk.IResolvable audioDescriptions) {
                this.audioDescriptions = audioDescriptions;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getAudioDescriptions}
             * @param audioDescriptions The encoding information for output audio.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioDescriptions(java.util.List<? extends java.lang.Object> audioDescriptions) {
                this.audioDescriptions = audioDescriptions;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getAvailBlanking}
             * @param availBlanking The settings for ad avail blanking.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availBlanking(software.amazon.awscdk.services.medialive.CfnChannel.AvailBlankingProperty availBlanking) {
                this.availBlanking = availBlanking;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getAvailBlanking}
             * @param availBlanking The settings for ad avail blanking.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availBlanking(software.amazon.awscdk.IResolvable availBlanking) {
                this.availBlanking = availBlanking;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getAvailConfiguration}
             * @param availConfiguration The configuration settings for the ad avail handling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availConfiguration(software.amazon.awscdk.services.medialive.CfnChannel.AvailConfigurationProperty availConfiguration) {
                this.availConfiguration = availConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getAvailConfiguration}
             * @param availConfiguration The configuration settings for the ad avail handling.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availConfiguration(software.amazon.awscdk.IResolvable availConfiguration) {
                this.availConfiguration = availConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getBlackoutSlate}
             * @param blackoutSlate The settings for the blackout slate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blackoutSlate(software.amazon.awscdk.services.medialive.CfnChannel.BlackoutSlateProperty blackoutSlate) {
                this.blackoutSlate = blackoutSlate;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getBlackoutSlate}
             * @param blackoutSlate The settings for the blackout slate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blackoutSlate(software.amazon.awscdk.IResolvable blackoutSlate) {
                this.blackoutSlate = blackoutSlate;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getCaptionDescriptions}
             * @param captionDescriptions The encoding information for output captions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captionDescriptions(software.amazon.awscdk.IResolvable captionDescriptions) {
                this.captionDescriptions = captionDescriptions;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getCaptionDescriptions}
             * @param captionDescriptions The encoding information for output captions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captionDescriptions(java.util.List<? extends java.lang.Object> captionDescriptions) {
                this.captionDescriptions = captionDescriptions;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getFeatureActivations}
             * @param featureActivations Settings to enable specific features.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureActivations(software.amazon.awscdk.services.medialive.CfnChannel.FeatureActivationsProperty featureActivations) {
                this.featureActivations = featureActivations;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getFeatureActivations}
             * @param featureActivations Settings to enable specific features.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureActivations(software.amazon.awscdk.IResolvable featureActivations) {
                this.featureActivations = featureActivations;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getGlobalConfiguration}
             * @param globalConfiguration The configuration settings that apply to the entire channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder globalConfiguration(software.amazon.awscdk.services.medialive.CfnChannel.GlobalConfigurationProperty globalConfiguration) {
                this.globalConfiguration = globalConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getGlobalConfiguration}
             * @param globalConfiguration The configuration settings that apply to the entire channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder globalConfiguration(software.amazon.awscdk.IResolvable globalConfiguration) {
                this.globalConfiguration = globalConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getMotionGraphicsConfiguration}
             * @param motionGraphicsConfiguration Settings to enable and configure the motion graphics overlay feature in the channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder motionGraphicsConfiguration(software.amazon.awscdk.services.medialive.CfnChannel.MotionGraphicsConfigurationProperty motionGraphicsConfiguration) {
                this.motionGraphicsConfiguration = motionGraphicsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getMotionGraphicsConfiguration}
             * @param motionGraphicsConfiguration Settings to enable and configure the motion graphics overlay feature in the channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder motionGraphicsConfiguration(software.amazon.awscdk.IResolvable motionGraphicsConfiguration) {
                this.motionGraphicsConfiguration = motionGraphicsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getNielsenConfiguration}
             * @param nielsenConfiguration The settings to configure Nielsen watermarks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nielsenConfiguration(software.amazon.awscdk.services.medialive.CfnChannel.NielsenConfigurationProperty nielsenConfiguration) {
                this.nielsenConfiguration = nielsenConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getNielsenConfiguration}
             * @param nielsenConfiguration The settings to configure Nielsen watermarks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nielsenConfiguration(software.amazon.awscdk.IResolvable nielsenConfiguration) {
                this.nielsenConfiguration = nielsenConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getOutputGroups}
             * @param outputGroups The settings for the output groups in the channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputGroups(software.amazon.awscdk.IResolvable outputGroups) {
                this.outputGroups = outputGroups;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getOutputGroups}
             * @param outputGroups The settings for the output groups in the channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputGroups(java.util.List<? extends java.lang.Object> outputGroups) {
                this.outputGroups = outputGroups;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getTimecodeConfig}
             * @param timecodeConfig Contains settings used to acquire and adjust timecode information from the inputs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timecodeConfig(software.amazon.awscdk.services.medialive.CfnChannel.TimecodeConfigProperty timecodeConfig) {
                this.timecodeConfig = timecodeConfig;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getTimecodeConfig}
             * @param timecodeConfig Contains settings used to acquire and adjust timecode information from the inputs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timecodeConfig(software.amazon.awscdk.IResolvable timecodeConfig) {
                this.timecodeConfig = timecodeConfig;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getVideoDescriptions}
             * @param videoDescriptions The encoding information for output videos.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder videoDescriptions(software.amazon.awscdk.IResolvable videoDescriptions) {
                this.videoDescriptions = videoDescriptions;
                return this;
            }

            /**
             * Sets the value of {@link EncoderSettingsProperty#getVideoDescriptions}
             * @param videoDescriptions The encoding information for output videos.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder videoDescriptions(java.util.List<? extends java.lang.Object> videoDescriptions) {
                this.videoDescriptions = videoDescriptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncoderSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncoderSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncoderSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncoderSettingsProperty {
            private final java.lang.Object audioDescriptions;
            private final java.lang.Object availBlanking;
            private final java.lang.Object availConfiguration;
            private final java.lang.Object blackoutSlate;
            private final java.lang.Object captionDescriptions;
            private final java.lang.Object featureActivations;
            private final java.lang.Object globalConfiguration;
            private final java.lang.Object motionGraphicsConfiguration;
            private final java.lang.Object nielsenConfiguration;
            private final java.lang.Object outputGroups;
            private final java.lang.Object timecodeConfig;
            private final java.lang.Object videoDescriptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioDescriptions = software.amazon.jsii.Kernel.get(this, "audioDescriptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.availBlanking = software.amazon.jsii.Kernel.get(this, "availBlanking", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.availConfiguration = software.amazon.jsii.Kernel.get(this, "availConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.blackoutSlate = software.amazon.jsii.Kernel.get(this, "blackoutSlate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.captionDescriptions = software.amazon.jsii.Kernel.get(this, "captionDescriptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.featureActivations = software.amazon.jsii.Kernel.get(this, "featureActivations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.globalConfiguration = software.amazon.jsii.Kernel.get(this, "globalConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.motionGraphicsConfiguration = software.amazon.jsii.Kernel.get(this, "motionGraphicsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nielsenConfiguration = software.amazon.jsii.Kernel.get(this, "nielsenConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputGroups = software.amazon.jsii.Kernel.get(this, "outputGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timecodeConfig = software.amazon.jsii.Kernel.get(this, "timecodeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.videoDescriptions = software.amazon.jsii.Kernel.get(this, "videoDescriptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioDescriptions = builder.audioDescriptions;
                this.availBlanking = builder.availBlanking;
                this.availConfiguration = builder.availConfiguration;
                this.blackoutSlate = builder.blackoutSlate;
                this.captionDescriptions = builder.captionDescriptions;
                this.featureActivations = builder.featureActivations;
                this.globalConfiguration = builder.globalConfiguration;
                this.motionGraphicsConfiguration = builder.motionGraphicsConfiguration;
                this.nielsenConfiguration = builder.nielsenConfiguration;
                this.outputGroups = builder.outputGroups;
                this.timecodeConfig = builder.timecodeConfig;
                this.videoDescriptions = builder.videoDescriptions;
            }

            @Override
            public final java.lang.Object getAudioDescriptions() {
                return this.audioDescriptions;
            }

            @Override
            public final java.lang.Object getAvailBlanking() {
                return this.availBlanking;
            }

            @Override
            public final java.lang.Object getAvailConfiguration() {
                return this.availConfiguration;
            }

            @Override
            public final java.lang.Object getBlackoutSlate() {
                return this.blackoutSlate;
            }

            @Override
            public final java.lang.Object getCaptionDescriptions() {
                return this.captionDescriptions;
            }

            @Override
            public final java.lang.Object getFeatureActivations() {
                return this.featureActivations;
            }

            @Override
            public final java.lang.Object getGlobalConfiguration() {
                return this.globalConfiguration;
            }

            @Override
            public final java.lang.Object getMotionGraphicsConfiguration() {
                return this.motionGraphicsConfiguration;
            }

            @Override
            public final java.lang.Object getNielsenConfiguration() {
                return this.nielsenConfiguration;
            }

            @Override
            public final java.lang.Object getOutputGroups() {
                return this.outputGroups;
            }

            @Override
            public final java.lang.Object getTimecodeConfig() {
                return this.timecodeConfig;
            }

            @Override
            public final java.lang.Object getVideoDescriptions() {
                return this.videoDescriptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioDescriptions() != null) {
                    data.set("audioDescriptions", om.valueToTree(this.getAudioDescriptions()));
                }
                if (this.getAvailBlanking() != null) {
                    data.set("availBlanking", om.valueToTree(this.getAvailBlanking()));
                }
                if (this.getAvailConfiguration() != null) {
                    data.set("availConfiguration", om.valueToTree(this.getAvailConfiguration()));
                }
                if (this.getBlackoutSlate() != null) {
                    data.set("blackoutSlate", om.valueToTree(this.getBlackoutSlate()));
                }
                if (this.getCaptionDescriptions() != null) {
                    data.set("captionDescriptions", om.valueToTree(this.getCaptionDescriptions()));
                }
                if (this.getFeatureActivations() != null) {
                    data.set("featureActivations", om.valueToTree(this.getFeatureActivations()));
                }
                if (this.getGlobalConfiguration() != null) {
                    data.set("globalConfiguration", om.valueToTree(this.getGlobalConfiguration()));
                }
                if (this.getMotionGraphicsConfiguration() != null) {
                    data.set("motionGraphicsConfiguration", om.valueToTree(this.getMotionGraphicsConfiguration()));
                }
                if (this.getNielsenConfiguration() != null) {
                    data.set("nielsenConfiguration", om.valueToTree(this.getNielsenConfiguration()));
                }
                if (this.getOutputGroups() != null) {
                    data.set("outputGroups", om.valueToTree(this.getOutputGroups()));
                }
                if (this.getTimecodeConfig() != null) {
                    data.set("timecodeConfig", om.valueToTree(this.getTimecodeConfig()));
                }
                if (this.getVideoDescriptions() != null) {
                    data.set("videoDescriptions", om.valueToTree(this.getVideoDescriptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.EncoderSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncoderSettingsProperty.Jsii$Proxy that = (EncoderSettingsProperty.Jsii$Proxy) o;

                if (this.audioDescriptions != null ? !this.audioDescriptions.equals(that.audioDescriptions) : that.audioDescriptions != null) return false;
                if (this.availBlanking != null ? !this.availBlanking.equals(that.availBlanking) : that.availBlanking != null) return false;
                if (this.availConfiguration != null ? !this.availConfiguration.equals(that.availConfiguration) : that.availConfiguration != null) return false;
                if (this.blackoutSlate != null ? !this.blackoutSlate.equals(that.blackoutSlate) : that.blackoutSlate != null) return false;
                if (this.captionDescriptions != null ? !this.captionDescriptions.equals(that.captionDescriptions) : that.captionDescriptions != null) return false;
                if (this.featureActivations != null ? !this.featureActivations.equals(that.featureActivations) : that.featureActivations != null) return false;
                if (this.globalConfiguration != null ? !this.globalConfiguration.equals(that.globalConfiguration) : that.globalConfiguration != null) return false;
                if (this.motionGraphicsConfiguration != null ? !this.motionGraphicsConfiguration.equals(that.motionGraphicsConfiguration) : that.motionGraphicsConfiguration != null) return false;
                if (this.nielsenConfiguration != null ? !this.nielsenConfiguration.equals(that.nielsenConfiguration) : that.nielsenConfiguration != null) return false;
                if (this.outputGroups != null ? !this.outputGroups.equals(that.outputGroups) : that.outputGroups != null) return false;
                if (this.timecodeConfig != null ? !this.timecodeConfig.equals(that.timecodeConfig) : that.timecodeConfig != null) return false;
                return this.videoDescriptions != null ? this.videoDescriptions.equals(that.videoDescriptions) : that.videoDescriptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioDescriptions != null ? this.audioDescriptions.hashCode() : 0;
                result = 31 * result + (this.availBlanking != null ? this.availBlanking.hashCode() : 0);
                result = 31 * result + (this.availConfiguration != null ? this.availConfiguration.hashCode() : 0);
                result = 31 * result + (this.blackoutSlate != null ? this.blackoutSlate.hashCode() : 0);
                result = 31 * result + (this.captionDescriptions != null ? this.captionDescriptions.hashCode() : 0);
                result = 31 * result + (this.featureActivations != null ? this.featureActivations.hashCode() : 0);
                result = 31 * result + (this.globalConfiguration != null ? this.globalConfiguration.hashCode() : 0);
                result = 31 * result + (this.motionGraphicsConfiguration != null ? this.motionGraphicsConfiguration.hashCode() : 0);
                result = 31 * result + (this.nielsenConfiguration != null ? this.nielsenConfiguration.hashCode() : 0);
                result = 31 * result + (this.outputGroups != null ? this.outputGroups.hashCode() : 0);
                result = 31 * result + (this.timecodeConfig != null ? this.timecodeConfig.hashCode() : 0);
                result = 31 * result + (this.videoDescriptions != null ? this.videoDescriptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Failover Condition settings. There can be multiple failover conditions inside AutomaticInputFailoverSettings.
     * <p>
     * The parent of this entity is AutomaticInputFailoverSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * FailoverConditionProperty failoverConditionProperty = FailoverConditionProperty.builder()
     *         .failoverConditionSettings(FailoverConditionSettingsProperty.builder()
     *                 .audioSilenceSettings(AudioSilenceFailoverSettingsProperty.builder()
     *                         .audioSelectorName("audioSelectorName")
     *                         .audioSilenceThresholdMsec(123)
     *                         .build())
     *                 .inputLossSettings(InputLossFailoverSettingsProperty.builder()
     *                         .inputLossThresholdMsec(123)
     *                         .build())
     *                 .videoBlackSettings(VideoBlackFailoverSettingsProperty.builder()
     *                         .blackDetectThreshold(123)
     *                         .videoBlackThresholdMsec(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.FailoverConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(FailoverConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FailoverConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings for a specific failover condition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailoverConditionSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FailoverConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FailoverConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FailoverConditionProperty> {
            java.lang.Object failoverConditionSettings;

            /**
             * Sets the value of {@link FailoverConditionProperty#getFailoverConditionSettings}
             * @param failoverConditionSettings Settings for a specific failover condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failoverConditionSettings(software.amazon.awscdk.services.medialive.CfnChannel.FailoverConditionSettingsProperty failoverConditionSettings) {
                this.failoverConditionSettings = failoverConditionSettings;
                return this;
            }

            /**
             * Sets the value of {@link FailoverConditionProperty#getFailoverConditionSettings}
             * @param failoverConditionSettings Settings for a specific failover condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failoverConditionSettings(software.amazon.awscdk.IResolvable failoverConditionSettings) {
                this.failoverConditionSettings = failoverConditionSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FailoverConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FailoverConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FailoverConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FailoverConditionProperty {
            private final java.lang.Object failoverConditionSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.failoverConditionSettings = software.amazon.jsii.Kernel.get(this, "failoverConditionSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.failoverConditionSettings = builder.failoverConditionSettings;
            }

            @Override
            public final java.lang.Object getFailoverConditionSettings() {
                return this.failoverConditionSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFailoverConditionSettings() != null) {
                    data.set("failoverConditionSettings", om.valueToTree(this.getFailoverConditionSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.FailoverConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FailoverConditionProperty.Jsii$Proxy that = (FailoverConditionProperty.Jsii$Proxy) o;

                return this.failoverConditionSettings != null ? this.failoverConditionSettings.equals(that.failoverConditionSettings) : that.failoverConditionSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.failoverConditionSettings != null ? this.failoverConditionSettings.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Settings for one failover condition.
     * <p>
     * The parent of this entity is FailoverCondition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * FailoverConditionSettingsProperty failoverConditionSettingsProperty = FailoverConditionSettingsProperty.builder()
     *         .audioSilenceSettings(AudioSilenceFailoverSettingsProperty.builder()
     *                 .audioSelectorName("audioSelectorName")
     *                 .audioSilenceThresholdMsec(123)
     *                 .build())
     *         .inputLossSettings(InputLossFailoverSettingsProperty.builder()
     *                 .inputLossThresholdMsec(123)
     *                 .build())
     *         .videoBlackSettings(VideoBlackFailoverSettingsProperty.builder()
     *                 .blackDetectThreshold(123)
     *                 .videoBlackThresholdMsec(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.FailoverConditionSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(FailoverConditionSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FailoverConditionSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * MediaLive will perform a failover if the specified audio selector is silent for the specified period.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioSilenceSettings() {
            return null;
        }

        /**
         * MediaLive will perform a failover if content is not detected in this input for the specified period.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputLossSettings() {
            return null;
        }

        /**
         * MediaLive will perform a failover if content is considered black for the specified period.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVideoBlackSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FailoverConditionSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FailoverConditionSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FailoverConditionSettingsProperty> {
            java.lang.Object audioSilenceSettings;
            java.lang.Object inputLossSettings;
            java.lang.Object videoBlackSettings;

            /**
             * Sets the value of {@link FailoverConditionSettingsProperty#getAudioSilenceSettings}
             * @param audioSilenceSettings MediaLive will perform a failover if the specified audio selector is silent for the specified period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioSilenceSettings(software.amazon.awscdk.services.medialive.CfnChannel.AudioSilenceFailoverSettingsProperty audioSilenceSettings) {
                this.audioSilenceSettings = audioSilenceSettings;
                return this;
            }

            /**
             * Sets the value of {@link FailoverConditionSettingsProperty#getAudioSilenceSettings}
             * @param audioSilenceSettings MediaLive will perform a failover if the specified audio selector is silent for the specified period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioSilenceSettings(software.amazon.awscdk.IResolvable audioSilenceSettings) {
                this.audioSilenceSettings = audioSilenceSettings;
                return this;
            }

            /**
             * Sets the value of {@link FailoverConditionSettingsProperty#getInputLossSettings}
             * @param inputLossSettings MediaLive will perform a failover if content is not detected in this input for the specified period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputLossSettings(software.amazon.awscdk.services.medialive.CfnChannel.InputLossFailoverSettingsProperty inputLossSettings) {
                this.inputLossSettings = inputLossSettings;
                return this;
            }

            /**
             * Sets the value of {@link FailoverConditionSettingsProperty#getInputLossSettings}
             * @param inputLossSettings MediaLive will perform a failover if content is not detected in this input for the specified period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputLossSettings(software.amazon.awscdk.IResolvable inputLossSettings) {
                this.inputLossSettings = inputLossSettings;
                return this;
            }

            /**
             * Sets the value of {@link FailoverConditionSettingsProperty#getVideoBlackSettings}
             * @param videoBlackSettings MediaLive will perform a failover if content is considered black for the specified period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder videoBlackSettings(software.amazon.awscdk.services.medialive.CfnChannel.VideoBlackFailoverSettingsProperty videoBlackSettings) {
                this.videoBlackSettings = videoBlackSettings;
                return this;
            }

            /**
             * Sets the value of {@link FailoverConditionSettingsProperty#getVideoBlackSettings}
             * @param videoBlackSettings MediaLive will perform a failover if content is considered black for the specified period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder videoBlackSettings(software.amazon.awscdk.IResolvable videoBlackSettings) {
                this.videoBlackSettings = videoBlackSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FailoverConditionSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FailoverConditionSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FailoverConditionSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FailoverConditionSettingsProperty {
            private final java.lang.Object audioSilenceSettings;
            private final java.lang.Object inputLossSettings;
            private final java.lang.Object videoBlackSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioSilenceSettings = software.amazon.jsii.Kernel.get(this, "audioSilenceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputLossSettings = software.amazon.jsii.Kernel.get(this, "inputLossSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.videoBlackSettings = software.amazon.jsii.Kernel.get(this, "videoBlackSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioSilenceSettings = builder.audioSilenceSettings;
                this.inputLossSettings = builder.inputLossSettings;
                this.videoBlackSettings = builder.videoBlackSettings;
            }

            @Override
            public final java.lang.Object getAudioSilenceSettings() {
                return this.audioSilenceSettings;
            }

            @Override
            public final java.lang.Object getInputLossSettings() {
                return this.inputLossSettings;
            }

            @Override
            public final java.lang.Object getVideoBlackSettings() {
                return this.videoBlackSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioSilenceSettings() != null) {
                    data.set("audioSilenceSettings", om.valueToTree(this.getAudioSilenceSettings()));
                }
                if (this.getInputLossSettings() != null) {
                    data.set("inputLossSettings", om.valueToTree(this.getInputLossSettings()));
                }
                if (this.getVideoBlackSettings() != null) {
                    data.set("videoBlackSettings", om.valueToTree(this.getVideoBlackSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.FailoverConditionSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FailoverConditionSettingsProperty.Jsii$Proxy that = (FailoverConditionSettingsProperty.Jsii$Proxy) o;

                if (this.audioSilenceSettings != null ? !this.audioSilenceSettings.equals(that.audioSilenceSettings) : that.audioSilenceSettings != null) return false;
                if (this.inputLossSettings != null ? !this.inputLossSettings.equals(that.inputLossSettings) : that.inputLossSettings != null) return false;
                return this.videoBlackSettings != null ? this.videoBlackSettings.equals(that.videoBlackSettings) : that.videoBlackSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioSilenceSettings != null ? this.audioSilenceSettings.hashCode() : 0;
                result = 31 * result + (this.inputLossSettings != null ? this.inputLossSettings.hashCode() : 0);
                result = 31 * result + (this.videoBlackSettings != null ? this.videoBlackSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings to enable specific features. You can't configure these features until you have enabled them in the channel.
     * <p>
     * The parent of this entity is EncoderSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * FeatureActivationsProperty featureActivationsProperty = FeatureActivationsProperty.builder()
     *         .inputPrepareScheduleActions("inputPrepareScheduleActions")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.FeatureActivationsProperty")
    @software.amazon.jsii.Jsii.Proxy(FeatureActivationsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FeatureActivationsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables the Input Prepare feature.
         * <p>
         * You can create Input Prepare actions in the schedule only if this feature is enabled.
         * If you disable the feature on an existing schedule, make sure that you first delete all input prepare actions from the schedule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputPrepareScheduleActions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FeatureActivationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FeatureActivationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FeatureActivationsProperty> {
            java.lang.String inputPrepareScheduleActions;

            /**
             * Sets the value of {@link FeatureActivationsProperty#getInputPrepareScheduleActions}
             * @param inputPrepareScheduleActions Enables the Input Prepare feature.
             *                                    You can create Input Prepare actions in the schedule only if this feature is enabled.
             *                                    If you disable the feature on an existing schedule, make sure that you first delete all input prepare actions from the schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputPrepareScheduleActions(java.lang.String inputPrepareScheduleActions) {
                this.inputPrepareScheduleActions = inputPrepareScheduleActions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FeatureActivationsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FeatureActivationsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FeatureActivationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FeatureActivationsProperty {
            private final java.lang.String inputPrepareScheduleActions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputPrepareScheduleActions = software.amazon.jsii.Kernel.get(this, "inputPrepareScheduleActions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputPrepareScheduleActions = builder.inputPrepareScheduleActions;
            }

            @Override
            public final java.lang.String getInputPrepareScheduleActions() {
                return this.inputPrepareScheduleActions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInputPrepareScheduleActions() != null) {
                    data.set("inputPrepareScheduleActions", om.valueToTree(this.getInputPrepareScheduleActions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.FeatureActivationsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FeatureActivationsProperty.Jsii$Proxy that = (FeatureActivationsProperty.Jsii$Proxy) o;

                return this.inputPrepareScheduleActions != null ? this.inputPrepareScheduleActions.equals(that.inputPrepareScheduleActions) : that.inputPrepareScheduleActions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputPrepareScheduleActions != null ? this.inputPrepareScheduleActions.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The settings for FEC.
     * <p>
     * The parent of this entity is UdpOutputSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * FecOutputSettingsProperty fecOutputSettingsProperty = FecOutputSettingsProperty.builder()
     *         .columnDepth(123)
     *         .includeFec("includeFec")
     *         .rowLength(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.FecOutputSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(FecOutputSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FecOutputSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The parameter D from SMPTE 2022-1.
         * <p>
         * The height of the FEC protection matrix. The number of transport stream packets per column error correction packet. The number must be between 4 and 20, inclusive.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getColumnDepth() {
            return null;
        }

        /**
         * Enables column only or column and row-based FEC.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIncludeFec() {
            return null;
        }

        /**
         * The parameter L from SMPTE 2022-1.
         * <p>
         * The width of the FEC protection matrix. Must be between 1 and 20, inclusive. If only Column FEC is used, then larger values increase robustness. If Row FEC is used, then this is the number of transport stream packets per row error correction packet, and the value must be between 4 and 20, inclusive, if includeFec is columnAndRow. If includeFec is column, this value must be 1 to 20, inclusive.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRowLength() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FecOutputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FecOutputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FecOutputSettingsProperty> {
            java.lang.Number columnDepth;
            java.lang.String includeFec;
            java.lang.Number rowLength;

            /**
             * Sets the value of {@link FecOutputSettingsProperty#getColumnDepth}
             * @param columnDepth The parameter D from SMPTE 2022-1.
             *                    The height of the FEC protection matrix. The number of transport stream packets per column error correction packet. The number must be between 4 and 20, inclusive.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnDepth(java.lang.Number columnDepth) {
                this.columnDepth = columnDepth;
                return this;
            }

            /**
             * Sets the value of {@link FecOutputSettingsProperty#getIncludeFec}
             * @param includeFec Enables column only or column and row-based FEC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeFec(java.lang.String includeFec) {
                this.includeFec = includeFec;
                return this;
            }

            /**
             * Sets the value of {@link FecOutputSettingsProperty#getRowLength}
             * @param rowLength The parameter L from SMPTE 2022-1.
             *                  The width of the FEC protection matrix. Must be between 1 and 20, inclusive. If only Column FEC is used, then larger values increase robustness. If Row FEC is used, then this is the number of transport stream packets per row error correction packet, and the value must be between 4 and 20, inclusive, if includeFec is columnAndRow. If includeFec is column, this value must be 1 to 20, inclusive.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rowLength(java.lang.Number rowLength) {
                this.rowLength = rowLength;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FecOutputSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FecOutputSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FecOutputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FecOutputSettingsProperty {
            private final java.lang.Number columnDepth;
            private final java.lang.String includeFec;
            private final java.lang.Number rowLength;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnDepth = software.amazon.jsii.Kernel.get(this, "columnDepth", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.includeFec = software.amazon.jsii.Kernel.get(this, "includeFec", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rowLength = software.amazon.jsii.Kernel.get(this, "rowLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnDepth = builder.columnDepth;
                this.includeFec = builder.includeFec;
                this.rowLength = builder.rowLength;
            }

            @Override
            public final java.lang.Number getColumnDepth() {
                return this.columnDepth;
            }

            @Override
            public final java.lang.String getIncludeFec() {
                return this.includeFec;
            }

            @Override
            public final java.lang.Number getRowLength() {
                return this.rowLength;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumnDepth() != null) {
                    data.set("columnDepth", om.valueToTree(this.getColumnDepth()));
                }
                if (this.getIncludeFec() != null) {
                    data.set("includeFec", om.valueToTree(this.getIncludeFec()));
                }
                if (this.getRowLength() != null) {
                    data.set("rowLength", om.valueToTree(this.getRowLength()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.FecOutputSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FecOutputSettingsProperty.Jsii$Proxy that = (FecOutputSettingsProperty.Jsii$Proxy) o;

                if (this.columnDepth != null ? !this.columnDepth.equals(that.columnDepth) : that.columnDepth != null) return false;
                if (this.includeFec != null ? !this.includeFec.equals(that.includeFec) : that.includeFec != null) return false;
                return this.rowLength != null ? this.rowLength.equals(that.rowLength) : that.rowLength == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnDepth != null ? this.columnDepth.hashCode() : 0;
                result = 31 * result + (this.includeFec != null ? this.includeFec.hashCode() : 0);
                result = 31 * result + (this.rowLength != null ? this.rowLength.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings for the fMP4 containers.
     * <p>
     * The parent of this entity is HlsSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * Fmp4HlsSettingsProperty fmp4HlsSettingsProperty = Fmp4HlsSettingsProperty.builder()
     *         .audioRenditionSets("audioRenditionSets")
     *         .nielsenId3Behavior("nielsenId3Behavior")
     *         .timedMetadataBehavior("timedMetadataBehavior")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.Fmp4HlsSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(Fmp4HlsSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Fmp4HlsSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List all the audio groups that are used with the video output stream.
         * <p>
         * Input all the audio GROUP-IDs that are associated to the video, separate by ','.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAudioRenditionSets() {
            return null;
        }

        /**
         * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNielsenId3Behavior() {
            return null;
        }

        /**
         * When set to passthrough, timed metadata is passed through from input to output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimedMetadataBehavior() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Fmp4HlsSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Fmp4HlsSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Fmp4HlsSettingsProperty> {
            java.lang.String audioRenditionSets;
            java.lang.String nielsenId3Behavior;
            java.lang.String timedMetadataBehavior;

            /**
             * Sets the value of {@link Fmp4HlsSettingsProperty#getAudioRenditionSets}
             * @param audioRenditionSets List all the audio groups that are used with the video output stream.
             *                           Input all the audio GROUP-IDs that are associated to the video, separate by ','.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioRenditionSets(java.lang.String audioRenditionSets) {
                this.audioRenditionSets = audioRenditionSets;
                return this;
            }

            /**
             * Sets the value of {@link Fmp4HlsSettingsProperty#getNielsenId3Behavior}
             * @param nielsenId3Behavior If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nielsenId3Behavior(java.lang.String nielsenId3Behavior) {
                this.nielsenId3Behavior = nielsenId3Behavior;
                return this;
            }

            /**
             * Sets the value of {@link Fmp4HlsSettingsProperty#getTimedMetadataBehavior}
             * @param timedMetadataBehavior When set to passthrough, timed metadata is passed through from input to output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timedMetadataBehavior(java.lang.String timedMetadataBehavior) {
                this.timedMetadataBehavior = timedMetadataBehavior;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Fmp4HlsSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Fmp4HlsSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Fmp4HlsSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Fmp4HlsSettingsProperty {
            private final java.lang.String audioRenditionSets;
            private final java.lang.String nielsenId3Behavior;
            private final java.lang.String timedMetadataBehavior;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioRenditionSets = software.amazon.jsii.Kernel.get(this, "audioRenditionSets", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nielsenId3Behavior = software.amazon.jsii.Kernel.get(this, "nielsenId3Behavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timedMetadataBehavior = software.amazon.jsii.Kernel.get(this, "timedMetadataBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioRenditionSets = builder.audioRenditionSets;
                this.nielsenId3Behavior = builder.nielsenId3Behavior;
                this.timedMetadataBehavior = builder.timedMetadataBehavior;
            }

            @Override
            public final java.lang.String getAudioRenditionSets() {
                return this.audioRenditionSets;
            }

            @Override
            public final java.lang.String getNielsenId3Behavior() {
                return this.nielsenId3Behavior;
            }

            @Override
            public final java.lang.String getTimedMetadataBehavior() {
                return this.timedMetadataBehavior;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioRenditionSets() != null) {
                    data.set("audioRenditionSets", om.valueToTree(this.getAudioRenditionSets()));
                }
                if (this.getNielsenId3Behavior() != null) {
                    data.set("nielsenId3Behavior", om.valueToTree(this.getNielsenId3Behavior()));
                }
                if (this.getTimedMetadataBehavior() != null) {
                    data.set("timedMetadataBehavior", om.valueToTree(this.getTimedMetadataBehavior()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.Fmp4HlsSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Fmp4HlsSettingsProperty.Jsii$Proxy that = (Fmp4HlsSettingsProperty.Jsii$Proxy) o;

                if (this.audioRenditionSets != null ? !this.audioRenditionSets.equals(that.audioRenditionSets) : that.audioRenditionSets != null) return false;
                if (this.nielsenId3Behavior != null ? !this.nielsenId3Behavior.equals(that.nielsenId3Behavior) : that.nielsenId3Behavior != null) return false;
                return this.timedMetadataBehavior != null ? this.timedMetadataBehavior.equals(that.timedMetadataBehavior) : that.timedMetadataBehavior == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioRenditionSets != null ? this.audioRenditionSets.hashCode() : 0;
                result = 31 * result + (this.nielsenId3Behavior != null ? this.nielsenId3Behavior.hashCode() : 0);
                result = 31 * result + (this.timedMetadataBehavior != null ? this.timedMetadataBehavior.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings to configure the destination of a Frame Capture output.
     * <p>
     * The parent of this entity is FrameCaptureGroupSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * FrameCaptureCdnSettingsProperty frameCaptureCdnSettingsProperty = FrameCaptureCdnSettingsProperty.builder()
     *         .frameCaptureS3Settings(FrameCaptureS3SettingsProperty.builder()
     *                 .cannedAcl("cannedAcl")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.FrameCaptureCdnSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(FrameCaptureCdnSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FrameCaptureCdnSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Sets up Amazon S3 as the destination for this Frame Capture output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFrameCaptureS3Settings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FrameCaptureCdnSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FrameCaptureCdnSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FrameCaptureCdnSettingsProperty> {
            java.lang.Object frameCaptureS3Settings;

            /**
             * Sets the value of {@link FrameCaptureCdnSettingsProperty#getFrameCaptureS3Settings}
             * @param frameCaptureS3Settings Sets up Amazon S3 as the destination for this Frame Capture output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frameCaptureS3Settings(software.amazon.awscdk.services.medialive.CfnChannel.FrameCaptureS3SettingsProperty frameCaptureS3Settings) {
                this.frameCaptureS3Settings = frameCaptureS3Settings;
                return this;
            }

            /**
             * Sets the value of {@link FrameCaptureCdnSettingsProperty#getFrameCaptureS3Settings}
             * @param frameCaptureS3Settings Sets up Amazon S3 as the destination for this Frame Capture output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frameCaptureS3Settings(software.amazon.awscdk.IResolvable frameCaptureS3Settings) {
                this.frameCaptureS3Settings = frameCaptureS3Settings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FrameCaptureCdnSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FrameCaptureCdnSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FrameCaptureCdnSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FrameCaptureCdnSettingsProperty {
            private final java.lang.Object frameCaptureS3Settings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.frameCaptureS3Settings = software.amazon.jsii.Kernel.get(this, "frameCaptureS3Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.frameCaptureS3Settings = builder.frameCaptureS3Settings;
            }

            @Override
            public final java.lang.Object getFrameCaptureS3Settings() {
                return this.frameCaptureS3Settings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFrameCaptureS3Settings() != null) {
                    data.set("frameCaptureS3Settings", om.valueToTree(this.getFrameCaptureS3Settings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.FrameCaptureCdnSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FrameCaptureCdnSettingsProperty.Jsii$Proxy that = (FrameCaptureCdnSettingsProperty.Jsii$Proxy) o;

                return this.frameCaptureS3Settings != null ? this.frameCaptureS3Settings.equals(that.frameCaptureS3Settings) : that.frameCaptureS3Settings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.frameCaptureS3Settings != null ? this.frameCaptureS3Settings.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The settings for a frame capture output group.
     * <p>
     * The parent of this entity is OutputGroupSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * FrameCaptureGroupSettingsProperty frameCaptureGroupSettingsProperty = FrameCaptureGroupSettingsProperty.builder()
     *         .destination(OutputLocationRefProperty.builder()
     *                 .destinationRefId("destinationRefId")
     *                 .build())
     *         .frameCaptureCdnSettings(FrameCaptureCdnSettingsProperty.builder()
     *                 .frameCaptureS3Settings(FrameCaptureS3SettingsProperty.builder()
     *                         .cannedAcl("cannedAcl")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.FrameCaptureGroupSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(FrameCaptureGroupSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FrameCaptureGroupSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The destination for the frame capture files.
         * <p>
         * The destination is either the URI for an Amazon S3 bucket and object, plus a file name prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling_) or the URI for a MediaStore container, plus a file name prefix (for example, mediastoressl://sportsDelivery/20180820/curling_). The final file names consist of the prefix from the destination field (for example, "curling_") + name modifier + the counter (5 digits, starting from 00001) + extension (which is always .jpg). For example, curlingLow.00001.jpg.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestination() {
            return null;
        }

        /**
         * Settings to configure the destination of a Frame Capture output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFrameCaptureCdnSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FrameCaptureGroupSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FrameCaptureGroupSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FrameCaptureGroupSettingsProperty> {
            java.lang.Object destination;
            java.lang.Object frameCaptureCdnSettings;

            /**
             * Sets the value of {@link FrameCaptureGroupSettingsProperty#getDestination}
             * @param destination The destination for the frame capture files.
             *                    The destination is either the URI for an Amazon S3 bucket and object, plus a file name prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling_) or the URI for a MediaStore container, plus a file name prefix (for example, mediastoressl://sportsDelivery/20180820/curling_). The final file names consist of the prefix from the destination field (for example, "curling_") + name modifier + the counter (5 digits, starting from 00001) + extension (which is always .jpg). For example, curlingLow.00001.jpg.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.medialive.CfnChannel.OutputLocationRefProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link FrameCaptureGroupSettingsProperty#getDestination}
             * @param destination The destination for the frame capture files.
             *                    The destination is either the URI for an Amazon S3 bucket and object, plus a file name prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling_) or the URI for a MediaStore container, plus a file name prefix (for example, mediastoressl://sportsDelivery/20180820/curling_). The final file names consist of the prefix from the destination field (for example, "curling_") + name modifier + the counter (5 digits, starting from 00001) + extension (which is always .jpg). For example, curlingLow.00001.jpg.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link FrameCaptureGroupSettingsProperty#getFrameCaptureCdnSettings}
             * @param frameCaptureCdnSettings Settings to configure the destination of a Frame Capture output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frameCaptureCdnSettings(software.amazon.awscdk.services.medialive.CfnChannel.FrameCaptureCdnSettingsProperty frameCaptureCdnSettings) {
                this.frameCaptureCdnSettings = frameCaptureCdnSettings;
                return this;
            }

            /**
             * Sets the value of {@link FrameCaptureGroupSettingsProperty#getFrameCaptureCdnSettings}
             * @param frameCaptureCdnSettings Settings to configure the destination of a Frame Capture output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frameCaptureCdnSettings(software.amazon.awscdk.IResolvable frameCaptureCdnSettings) {
                this.frameCaptureCdnSettings = frameCaptureCdnSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FrameCaptureGroupSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FrameCaptureGroupSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FrameCaptureGroupSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FrameCaptureGroupSettingsProperty {
            private final java.lang.Object destination;
            private final java.lang.Object frameCaptureCdnSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.frameCaptureCdnSettings = software.amazon.jsii.Kernel.get(this, "frameCaptureCdnSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = builder.destination;
                this.frameCaptureCdnSettings = builder.frameCaptureCdnSettings;
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.Object getFrameCaptureCdnSettings() {
                return this.frameCaptureCdnSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestination() != null) {
                    data.set("destination", om.valueToTree(this.getDestination()));
                }
                if (this.getFrameCaptureCdnSettings() != null) {
                    data.set("frameCaptureCdnSettings", om.valueToTree(this.getFrameCaptureCdnSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.FrameCaptureGroupSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FrameCaptureGroupSettingsProperty.Jsii$Proxy that = (FrameCaptureGroupSettingsProperty.Jsii$Proxy) o;

                if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) return false;
                return this.frameCaptureCdnSettings != null ? this.frameCaptureCdnSettings.equals(that.frameCaptureCdnSettings) : that.frameCaptureCdnSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destination != null ? this.destination.hashCode() : 0;
                result = 31 * result + (this.frameCaptureCdnSettings != null ? this.frameCaptureCdnSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings for a frame capture output in an HLS output group.
     * <p>
     * The parent of this entity is HlsSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * FrameCaptureHlsSettingsProperty frameCaptureHlsSettingsProperty = FrameCaptureHlsSettingsProperty.builder().build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.FrameCaptureHlsSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(FrameCaptureHlsSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FrameCaptureHlsSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @return a {@link Builder} of {@link FrameCaptureHlsSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FrameCaptureHlsSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FrameCaptureHlsSettingsProperty> {

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FrameCaptureHlsSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FrameCaptureHlsSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FrameCaptureHlsSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FrameCaptureHlsSettingsProperty {

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();


                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.FrameCaptureHlsSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }
        }
    }
    /**
     * The frame capture output settings.
     * <p>
     * The parent of this entity is OutputSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * FrameCaptureOutputSettingsProperty frameCaptureOutputSettingsProperty = FrameCaptureOutputSettingsProperty.builder()
     *         .nameModifier("nameModifier")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.FrameCaptureOutputSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(FrameCaptureOutputSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FrameCaptureOutputSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Required if the output group contains more than one output.
         * <p>
         * This modifier forms part of the output file name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNameModifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FrameCaptureOutputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FrameCaptureOutputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FrameCaptureOutputSettingsProperty> {
            java.lang.String nameModifier;

            /**
             * Sets the value of {@link FrameCaptureOutputSettingsProperty#getNameModifier}
             * @param nameModifier Required if the output group contains more than one output.
             *                     This modifier forms part of the output file name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nameModifier(java.lang.String nameModifier) {
                this.nameModifier = nameModifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FrameCaptureOutputSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FrameCaptureOutputSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FrameCaptureOutputSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FrameCaptureOutputSettingsProperty {
            private final java.lang.String nameModifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.nameModifier = software.amazon.jsii.Kernel.get(this, "nameModifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.nameModifier = builder.nameModifier;
            }

            @Override
            public final java.lang.String getNameModifier() {
                return this.nameModifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNameModifier() != null) {
                    data.set("nameModifier", om.valueToTree(this.getNameModifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.FrameCaptureOutputSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FrameCaptureOutputSettingsProperty.Jsii$Proxy that = (FrameCaptureOutputSettingsProperty.Jsii$Proxy) o;

                return this.nameModifier != null ? this.nameModifier.equals(that.nameModifier) : that.nameModifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.nameModifier != null ? this.nameModifier.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Sets up Amazon S3 as the destination for this Frame Capture output.
     * <p>
     * The parent of this entity is FrameCaptureCdnSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * FrameCaptureS3SettingsProperty frameCaptureS3SettingsProperty = FrameCaptureS3SettingsProperty.builder()
     *         .cannedAcl("cannedAcl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.FrameCaptureS3SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(FrameCaptureS3SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FrameCaptureS3SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify the canned ACL to apply to each S3 request.
         * <p>
         * Defaults to none.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCannedAcl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FrameCaptureS3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FrameCaptureS3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FrameCaptureS3SettingsProperty> {
            java.lang.String cannedAcl;

            /**
             * Sets the value of {@link FrameCaptureS3SettingsProperty#getCannedAcl}
             * @param cannedAcl Specify the canned ACL to apply to each S3 request.
             *                  Defaults to none.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cannedAcl(java.lang.String cannedAcl) {
                this.cannedAcl = cannedAcl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FrameCaptureS3SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FrameCaptureS3SettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FrameCaptureS3SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FrameCaptureS3SettingsProperty {
            private final java.lang.String cannedAcl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cannedAcl = software.amazon.jsii.Kernel.get(this, "cannedAcl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cannedAcl = builder.cannedAcl;
            }

            @Override
            public final java.lang.String getCannedAcl() {
                return this.cannedAcl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCannedAcl() != null) {
                    data.set("cannedAcl", om.valueToTree(this.getCannedAcl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.FrameCaptureS3SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FrameCaptureS3SettingsProperty.Jsii$Proxy that = (FrameCaptureS3SettingsProperty.Jsii$Proxy) o;

                return this.cannedAcl != null ? this.cannedAcl.equals(that.cannedAcl) : that.cannedAcl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cannedAcl != null ? this.cannedAcl.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The frame capture settings.
     * <p>
     * The parent of this entity is VideoCodecSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * FrameCaptureSettingsProperty frameCaptureSettingsProperty = FrameCaptureSettingsProperty.builder()
     *         .captureInterval(123)
     *         .captureIntervalUnits("captureIntervalUnits")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.FrameCaptureSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(FrameCaptureSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FrameCaptureSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The frequency, in seconds, for capturing frames for inclusion in the output.
         * <p>
         * For example, "10" means capture a frame every 10 seconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCaptureInterval() {
            return null;
        }

        /**
         * Unit for the frame capture interval.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCaptureIntervalUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FrameCaptureSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FrameCaptureSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FrameCaptureSettingsProperty> {
            java.lang.Number captureInterval;
            java.lang.String captureIntervalUnits;

            /**
             * Sets the value of {@link FrameCaptureSettingsProperty#getCaptureInterval}
             * @param captureInterval The frequency, in seconds, for capturing frames for inclusion in the output.
             *                        For example, "10" means capture a frame every 10 seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureInterval(java.lang.Number captureInterval) {
                this.captureInterval = captureInterval;
                return this;
            }

            /**
             * Sets the value of {@link FrameCaptureSettingsProperty#getCaptureIntervalUnits}
             * @param captureIntervalUnits Unit for the frame capture interval.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureIntervalUnits(java.lang.String captureIntervalUnits) {
                this.captureIntervalUnits = captureIntervalUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FrameCaptureSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FrameCaptureSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FrameCaptureSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FrameCaptureSettingsProperty {
            private final java.lang.Number captureInterval;
            private final java.lang.String captureIntervalUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.captureInterval = software.amazon.jsii.Kernel.get(this, "captureInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.captureIntervalUnits = software.amazon.jsii.Kernel.get(this, "captureIntervalUnits", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.captureInterval = builder.captureInterval;
                this.captureIntervalUnits = builder.captureIntervalUnits;
            }

            @Override
            public final java.lang.Number getCaptureInterval() {
                return this.captureInterval;
            }

            @Override
            public final java.lang.String getCaptureIntervalUnits() {
                return this.captureIntervalUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCaptureInterval() != null) {
                    data.set("captureInterval", om.valueToTree(this.getCaptureInterval()));
                }
                if (this.getCaptureIntervalUnits() != null) {
                    data.set("captureIntervalUnits", om.valueToTree(this.getCaptureIntervalUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.FrameCaptureSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FrameCaptureSettingsProperty.Jsii$Proxy that = (FrameCaptureSettingsProperty.Jsii$Proxy) o;

                if (this.captureInterval != null ? !this.captureInterval.equals(that.captureInterval) : that.captureInterval != null) return false;
                return this.captureIntervalUnits != null ? this.captureIntervalUnits.equals(that.captureIntervalUnits) : that.captureIntervalUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.captureInterval != null ? this.captureInterval.hashCode() : 0;
                result = 31 * result + (this.captureIntervalUnits != null ? this.captureIntervalUnits.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration settings that apply to the entire channel.
     * <p>
     * The parent of this entity is EncoderSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * GlobalConfigurationProperty globalConfigurationProperty = GlobalConfigurationProperty.builder()
     *         .initialAudioGain(123)
     *         .inputEndAction("inputEndAction")
     *         .inputLossBehavior(InputLossBehaviorProperty.builder()
     *                 .blackFrameMsec(123)
     *                 .inputLossImageColor("inputLossImageColor")
     *                 .inputLossImageSlate(InputLocationProperty.builder()
     *                         .passwordParam("passwordParam")
     *                         .uri("uri")
     *                         .username("username")
     *                         .build())
     *                 .inputLossImageType("inputLossImageType")
     *                 .repeatFrameMsec(123)
     *                 .build())
     *         .outputLockingMode("outputLockingMode")
     *         .outputTimingSource("outputTimingSource")
     *         .supportLowFramerateInputs("supportLowFramerateInputs")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.GlobalConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(GlobalConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GlobalConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value to set the initial audio gain for the channel.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInitialAudioGain() {
            return null;
        }

        /**
         * Indicates the action to take when the current input completes (for example, end-of-file).
         * <p>
         * When switchAndLoopInputs is configured, MediaLive restarts at the beginning of the first input. When "none" is configured, MediaLive transcodes either black, a solid color, or a user-specified slate images per the "Input Loss Behavior" configuration until the next input switch occurs (which is controlled through the Channel Schedule API).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputEndAction() {
            return null;
        }

        /**
         * The settings for system actions when the input is lost.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputLossBehavior() {
            return null;
        }

        /**
         * Indicates how MediaLive pipelines are synchronized.
         * <p>
         * PIPELINELOCKING - MediaLive attempts to synchronize the output of each pipeline to the other. EPOCHLOCKING - MediaLive attempts to synchronize the output of each pipeline to the Unix epoch.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputLockingMode() {
            return null;
        }

        /**
         * Indicates whether the rate of frames emitted by the Live encoder should be paced by its system clock (which optionally might be locked to another source through NTP) or should be locked to the clock of the source that is providing the input stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputTimingSource() {
            return null;
        }

        /**
         * Adjusts the video input buffer for streams with very low video frame rates.
         * <p>
         * This is commonly set to enabled for music channels with less than one video frame per second.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSupportLowFramerateInputs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GlobalConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GlobalConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GlobalConfigurationProperty> {
            java.lang.Number initialAudioGain;
            java.lang.String inputEndAction;
            java.lang.Object inputLossBehavior;
            java.lang.String outputLockingMode;
            java.lang.String outputTimingSource;
            java.lang.String supportLowFramerateInputs;

            /**
             * Sets the value of {@link GlobalConfigurationProperty#getInitialAudioGain}
             * @param initialAudioGain The value to set the initial audio gain for the channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initialAudioGain(java.lang.Number initialAudioGain) {
                this.initialAudioGain = initialAudioGain;
                return this;
            }

            /**
             * Sets the value of {@link GlobalConfigurationProperty#getInputEndAction}
             * @param inputEndAction Indicates the action to take when the current input completes (for example, end-of-file).
             *                       When switchAndLoopInputs is configured, MediaLive restarts at the beginning of the first input. When "none" is configured, MediaLive transcodes either black, a solid color, or a user-specified slate images per the "Input Loss Behavior" configuration until the next input switch occurs (which is controlled through the Channel Schedule API).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputEndAction(java.lang.String inputEndAction) {
                this.inputEndAction = inputEndAction;
                return this;
            }

            /**
             * Sets the value of {@link GlobalConfigurationProperty#getInputLossBehavior}
             * @param inputLossBehavior The settings for system actions when the input is lost.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputLossBehavior(software.amazon.awscdk.services.medialive.CfnChannel.InputLossBehaviorProperty inputLossBehavior) {
                this.inputLossBehavior = inputLossBehavior;
                return this;
            }

            /**
             * Sets the value of {@link GlobalConfigurationProperty#getInputLossBehavior}
             * @param inputLossBehavior The settings for system actions when the input is lost.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputLossBehavior(software.amazon.awscdk.IResolvable inputLossBehavior) {
                this.inputLossBehavior = inputLossBehavior;
                return this;
            }

            /**
             * Sets the value of {@link GlobalConfigurationProperty#getOutputLockingMode}
             * @param outputLockingMode Indicates how MediaLive pipelines are synchronized.
             *                          PIPELINELOCKING - MediaLive attempts to synchronize the output of each pipeline to the other. EPOCHLOCKING - MediaLive attempts to synchronize the output of each pipeline to the Unix epoch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputLockingMode(java.lang.String outputLockingMode) {
                this.outputLockingMode = outputLockingMode;
                return this;
            }

            /**
             * Sets the value of {@link GlobalConfigurationProperty#getOutputTimingSource}
             * @param outputTimingSource Indicates whether the rate of frames emitted by the Live encoder should be paced by its system clock (which optionally might be locked to another source through NTP) or should be locked to the clock of the source that is providing the input stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputTimingSource(java.lang.String outputTimingSource) {
                this.outputTimingSource = outputTimingSource;
                return this;
            }

            /**
             * Sets the value of {@link GlobalConfigurationProperty#getSupportLowFramerateInputs}
             * @param supportLowFramerateInputs Adjusts the video input buffer for streams with very low video frame rates.
             *                                  This is commonly set to enabled for music channels with less than one video frame per second.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder supportLowFramerateInputs(java.lang.String supportLowFramerateInputs) {
                this.supportLowFramerateInputs = supportLowFramerateInputs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlobalConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GlobalConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GlobalConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlobalConfigurationProperty {
            private final java.lang.Number initialAudioGain;
            private final java.lang.String inputEndAction;
            private final java.lang.Object inputLossBehavior;
            private final java.lang.String outputLockingMode;
            private final java.lang.String outputTimingSource;
            private final java.lang.String supportLowFramerateInputs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.initialAudioGain = software.amazon.jsii.Kernel.get(this, "initialAudioGain", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.inputEndAction = software.amazon.jsii.Kernel.get(this, "inputEndAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputLossBehavior = software.amazon.jsii.Kernel.get(this, "inputLossBehavior", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputLockingMode = software.amazon.jsii.Kernel.get(this, "outputLockingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputTimingSource = software.amazon.jsii.Kernel.get(this, "outputTimingSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.supportLowFramerateInputs = software.amazon.jsii.Kernel.get(this, "supportLowFramerateInputs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.initialAudioGain = builder.initialAudioGain;
                this.inputEndAction = builder.inputEndAction;
                this.inputLossBehavior = builder.inputLossBehavior;
                this.outputLockingMode = builder.outputLockingMode;
                this.outputTimingSource = builder.outputTimingSource;
                this.supportLowFramerateInputs = builder.supportLowFramerateInputs;
            }

            @Override
            public final java.lang.Number getInitialAudioGain() {
                return this.initialAudioGain;
            }

            @Override
            public final java.lang.String getInputEndAction() {
                return this.inputEndAction;
            }

            @Override
            public final java.lang.Object getInputLossBehavior() {
                return this.inputLossBehavior;
            }

            @Override
            public final java.lang.String getOutputLockingMode() {
                return this.outputLockingMode;
            }

            @Override
            public final java.lang.String getOutputTimingSource() {
                return this.outputTimingSource;
            }

            @Override
            public final java.lang.String getSupportLowFramerateInputs() {
                return this.supportLowFramerateInputs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInitialAudioGain() != null) {
                    data.set("initialAudioGain", om.valueToTree(this.getInitialAudioGain()));
                }
                if (this.getInputEndAction() != null) {
                    data.set("inputEndAction", om.valueToTree(this.getInputEndAction()));
                }
                if (this.getInputLossBehavior() != null) {
                    data.set("inputLossBehavior", om.valueToTree(this.getInputLossBehavior()));
                }
                if (this.getOutputLockingMode() != null) {
                    data.set("outputLockingMode", om.valueToTree(this.getOutputLockingMode()));
                }
                if (this.getOutputTimingSource() != null) {
                    data.set("outputTimingSource", om.valueToTree(this.getOutputTimingSource()));
                }
                if (this.getSupportLowFramerateInputs() != null) {
                    data.set("supportLowFramerateInputs", om.valueToTree(this.getSupportLowFramerateInputs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.GlobalConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GlobalConfigurationProperty.Jsii$Proxy that = (GlobalConfigurationProperty.Jsii$Proxy) o;

                if (this.initialAudioGain != null ? !this.initialAudioGain.equals(that.initialAudioGain) : that.initialAudioGain != null) return false;
                if (this.inputEndAction != null ? !this.inputEndAction.equals(that.inputEndAction) : that.inputEndAction != null) return false;
                if (this.inputLossBehavior != null ? !this.inputLossBehavior.equals(that.inputLossBehavior) : that.inputLossBehavior != null) return false;
                if (this.outputLockingMode != null ? !this.outputLockingMode.equals(that.outputLockingMode) : that.outputLockingMode != null) return false;
                if (this.outputTimingSource != null ? !this.outputTimingSource.equals(that.outputTimingSource) : that.outputTimingSource != null) return false;
                return this.supportLowFramerateInputs != null ? this.supportLowFramerateInputs.equals(that.supportLowFramerateInputs) : that.supportLowFramerateInputs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.initialAudioGain != null ? this.initialAudioGain.hashCode() : 0;
                result = 31 * result + (this.inputEndAction != null ? this.inputEndAction.hashCode() : 0);
                result = 31 * result + (this.inputLossBehavior != null ? this.inputLossBehavior.hashCode() : 0);
                result = 31 * result + (this.outputLockingMode != null ? this.outputLockingMode.hashCode() : 0);
                result = 31 * result + (this.outputTimingSource != null ? this.outputTimingSource.hashCode() : 0);
                result = 31 * result + (this.supportLowFramerateInputs != null ? this.supportLowFramerateInputs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings for configuring color space in an H264 video encode.
     * <p>
     * The parent of this entity is H264Settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * H264ColorSpaceSettingsProperty h264ColorSpaceSettingsProperty = H264ColorSpaceSettingsProperty.builder()
     *         .colorSpacePassthroughSettings(ColorSpacePassthroughSettingsProperty.builder().build())
     *         .rec601Settings(Rec601SettingsProperty.builder().build())
     *         .rec709Settings(Rec709SettingsProperty.builder().build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.H264ColorSpaceSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(H264ColorSpaceSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface H264ColorSpaceSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Passthrough applies no color space conversion to the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColorSpacePassthroughSettings() {
            return null;
        }

        /**
         * Settings to configure the handling of Rec601 color space.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRec601Settings() {
            return null;
        }

        /**
         * Settings to configure the handling of Rec709 color space.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRec709Settings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link H264ColorSpaceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link H264ColorSpaceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<H264ColorSpaceSettingsProperty> {
            java.lang.Object colorSpacePassthroughSettings;
            java.lang.Object rec601Settings;
            java.lang.Object rec709Settings;

            /**
             * Sets the value of {@link H264ColorSpaceSettingsProperty#getColorSpacePassthroughSettings}
             * @param colorSpacePassthroughSettings Passthrough applies no color space conversion to the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorSpacePassthroughSettings(software.amazon.awscdk.services.medialive.CfnChannel.ColorSpacePassthroughSettingsProperty colorSpacePassthroughSettings) {
                this.colorSpacePassthroughSettings = colorSpacePassthroughSettings;
                return this;
            }

            /**
             * Sets the value of {@link H264ColorSpaceSettingsProperty#getColorSpacePassthroughSettings}
             * @param colorSpacePassthroughSettings Passthrough applies no color space conversion to the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorSpacePassthroughSettings(software.amazon.awscdk.IResolvable colorSpacePassthroughSettings) {
                this.colorSpacePassthroughSettings = colorSpacePassthroughSettings;
                return this;
            }

            /**
             * Sets the value of {@link H264ColorSpaceSettingsProperty#getRec601Settings}
             * @param rec601Settings Settings to configure the handling of Rec601 color space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rec601Settings(software.amazon.awscdk.services.medialive.CfnChannel.Rec601SettingsProperty rec601Settings) {
                this.rec601Settings = rec601Settings;
                return this;
            }

            /**
             * Sets the value of {@link H264ColorSpaceSettingsProperty#getRec601Settings}
             * @param rec601Settings Settings to configure the handling of Rec601 color space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rec601Settings(software.amazon.awscdk.IResolvable rec601Settings) {
                this.rec601Settings = rec601Settings;
                return this;
            }

            /**
             * Sets the value of {@link H264ColorSpaceSettingsProperty#getRec709Settings}
             * @param rec709Settings Settings to configure the handling of Rec709 color space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rec709Settings(software.amazon.awscdk.services.medialive.CfnChannel.Rec709SettingsProperty rec709Settings) {
                this.rec709Settings = rec709Settings;
                return this;
            }

            /**
             * Sets the value of {@link H264ColorSpaceSettingsProperty#getRec709Settings}
             * @param rec709Settings Settings to configure the handling of Rec709 color space.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rec709Settings(software.amazon.awscdk.IResolvable rec709Settings) {
                this.rec709Settings = rec709Settings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link H264ColorSpaceSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public H264ColorSpaceSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link H264ColorSpaceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements H264ColorSpaceSettingsProperty {
            private final java.lang.Object colorSpacePassthroughSettings;
            private final java.lang.Object rec601Settings;
            private final java.lang.Object rec709Settings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.colorSpacePassthroughSettings = software.amazon.jsii.Kernel.get(this, "colorSpacePassthroughSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rec601Settings = software.amazon.jsii.Kernel.get(this, "rec601Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rec709Settings = software.amazon.jsii.Kernel.get(this, "rec709Settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.colorSpacePassthroughSettings = builder.colorSpacePassthroughSettings;
                this.rec601Settings = builder.rec601Settings;
                this.rec709Settings = builder.rec709Settings;
            }

            @Override
            public final java.lang.Object getColorSpacePassthroughSettings() {
                return this.colorSpacePassthroughSettings;
            }

            @Override
            public final java.lang.Object getRec601Settings() {
                return this.rec601Settings;
            }

            @Override
            public final java.lang.Object getRec709Settings() {
                return this.rec709Settings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColorSpacePassthroughSettings() != null) {
                    data.set("colorSpacePassthroughSettings", om.valueToTree(this.getColorSpacePassthroughSettings()));
                }
                if (this.getRec601Settings() != null) {
                    data.set("rec601Settings", om.valueToTree(this.getRec601Settings()));
                }
                if (this.getRec709Settings() != null) {
                    data.set("rec709Settings", om.valueToTree(this.getRec709Settings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.H264ColorSpaceSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                H264ColorSpaceSettingsProperty.Jsii$Proxy that = (H264ColorSpaceSettingsProperty.Jsii$Proxy) o;

                if (this.colorSpacePassthroughSettings != null ? !this.colorSpacePassthroughSettings.equals(that.colorSpacePassthroughSettings) : that.colorSpacePassthroughSettings != null) return false;
                if (this.rec601Settings != null ? !this.rec601Settings.equals(that.rec601Settings) : that.rec601Settings != null) return false;
                return this.rec709Settings != null ? this.rec709Settings.equals(that.rec709Settings) : that.rec709Settings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.colorSpacePassthroughSettings != null ? this.colorSpacePassthroughSettings.hashCode() : 0;
                result = 31 * result + (this.rec601Settings != null ? this.rec601Settings.hashCode() : 0);
                result = 31 * result + (this.rec709Settings != null ? this.rec709Settings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings to configure video filters that apply to the H264 codec.
     * <p>
     * The parent of this entity is H264Settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * H264FilterSettingsProperty h264FilterSettingsProperty = H264FilterSettingsProperty.builder()
     *         .temporalFilterSettings(TemporalFilterSettingsProperty.builder()
     *                 .postFilterSharpening("postFilterSharpening")
     *                 .strength("strength")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.H264FilterSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(H264FilterSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface H264FilterSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings for applying the temporal filter to the video.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTemporalFilterSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link H264FilterSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link H264FilterSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<H264FilterSettingsProperty> {
            java.lang.Object temporalFilterSettings;

            /**
             * Sets the value of {@link H264FilterSettingsProperty#getTemporalFilterSettings}
             * @param temporalFilterSettings Settings for applying the temporal filter to the video.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder temporalFilterSettings(software.amazon.awscdk.services.medialive.CfnChannel.TemporalFilterSettingsProperty temporalFilterSettings) {
                this.temporalFilterSettings = temporalFilterSettings;
                return this;
            }

            /**
             * Sets the value of {@link H264FilterSettingsProperty#getTemporalFilterSettings}
             * @param temporalFilterSettings Settings for applying the temporal filter to the video.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder temporalFilterSettings(software.amazon.awscdk.IResolvable temporalFilterSettings) {
                this.temporalFilterSettings = temporalFilterSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link H264FilterSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public H264FilterSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link H264FilterSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements H264FilterSettingsProperty {
            private final java.lang.Object temporalFilterSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.temporalFilterSettings = software.amazon.jsii.Kernel.get(this, "temporalFilterSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.temporalFilterSettings = builder.temporalFilterSettings;
            }

            @Override
            public final java.lang.Object getTemporalFilterSettings() {
                return this.temporalFilterSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTemporalFilterSettings() != null) {
                    data.set("temporalFilterSettings", om.valueToTree(this.getTemporalFilterSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnChannel.H264FilterSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                H264FilterSettingsProperty.Jsii$Proxy that = (H264FilterSettingsProperty.Jsii$Proxy) o;

                return this.temporalFilterSettings != null ? this.temporalFilterSettings.equals(that.temporalFilterSettings) : that.temporalFilterSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.temporalFilterSettings != null ? this.temporalFilterSettings.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The settings for the H.264 codec in the output.
     * <p>
     * The parent of this entity is VideoCodecSettings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * H264SettingsProperty h264SettingsProperty = H264SettingsProperty.builder()
     *         .adaptiveQuantization("adaptiveQuantization")
     *         .afdSignaling("afdSignaling")
     *         .bitrate(123)
     *         .bufFillPct(123)
     *         .bufSize(123)
     *         .colorMetadata("colorMetadata")
     *         .colorSpaceSettings(H264ColorSpaceSettingsProperty.builder()
     *                 .colorSpacePassthroughSettings(ColorSpacePassthroughSettingsProperty.builder().build())
     *                 .rec601Settings(Rec601SettingsProperty.builder().build())
     *                 .rec709Settings(Rec709SettingsProperty.builder().build())
     *                 .build())
     *         .entropyEncoding("entropyEncoding")
     *         .filterSettings(H264FilterSettingsProperty.builder()
     *                 .temporalFilterSettings(TemporalFilterSettingsProperty.builder()
     *                         .postFilterSharpening("postFilterSharpening")
     *                         .strength("strength")
     *                         .build())
     *                 .build())
     *         .fixedAfd("fixedAfd")
     *         .flickerAq("flickerAq")
     *         .forceFieldPictures("forceFieldPictures")
     *         .framerateControl("framerateControl")
     *         .framerateDenominator(123)
     *         .framerateNumerator(123)
     *         .gopBReference("gopBReference")
     *         .gopClosedCadence(123)
     *         .gopNumBFrames(123)
     *         .gopSize(123)
     *         .gopSizeUnits("gopSizeUnits")
     *         .level("level")
     *         .lookAheadRateControl("lookAheadRateControl")
     *         .maxBitrate(123)
     *         .minIInterval(123)
     *         .numRefFrames(123)
     *         .parControl("parControl")
     *         .parDenominator(123)
     *         .parNumerator(123)
     *         .profile("profile")
     *         .qualityLevel("qualityLevel")
     *         .qvbrQualityLevel(123)
     *         .rateControlMode("rateControlMode")
     *         .scanType("scanType")
     *         .sceneChangeDetect("sceneChangeDetect")
     *         .slices(123)
     *         .softness(123)
     *         .spatialAq("spatialAq")
     *         .subgopLength("subgopLength")
     *         .syntax("syntax")
     *         .temporalAq("temporalAq")
     *         .timecodeInsertion("timecodeInsertion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnChannel.H264SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(H264SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface H264SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The adaptive quantization.
         * <p>
         * This allows intra-frame quantizers to vary to improve visual quality.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdaptiveQuantization() {
            return null;
        }

        /**
         * Indicates that AFD values will be written into the output stream.
         * <p>
         * If afdSignaling is auto, the system tries to preserve the input AFD value (in cases where multiple AFD values are valid). If set to fixed, the AFD value is the value configured in the fixedAfd parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAfdSignaling() {
            return null;
        }

        /**
         * The average bitrate in bits/second.
         * <p>
         * This is required when the rate control mode is VBR or CBR. It isn't used for QVBR. In a Microsoft Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest multiple of 1000.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBitrate() {
            return null;
        }

        /**
         * The percentage of the buffer that should initially be filled (HRD buffer model).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBufFillPct() {
            return null;
        }

        /**
         * The size of the buffer (HRD buffer model) in bits/second.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBufSize() {
            return null;
        }

        /**
         * Includes color space metadata in the output.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getColorMetadata() {
            return null;
        }

        /**
         * Settings to configure the color space handling for the video.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColorSpaceSettings() {
            return null;
        }

        /**
         * The entropy encoding mode.
         * <p>
         * Use cabac (must be in Main or High profile) or cavlc.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEntropyEncoding() {
            return null;
        }

        /**
         * Optional filters that you can apply to an encode.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilterSettings() {
            return null;
        }

        /**
         * A four-bit AFD value to write on all frames of video in the output stream.
         * <p>
         * Valid only when afdSignaling is set to Fixed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFixedAfd() {
            return null;
        }

        /**
         * If set to enabled, adjusts the quantization within each frame to reduce flicker or pop on I-frames.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFlickerAq() {
            return null;
        }

        /**
         * This setting applies only when scan type is "interlaced." It controls whether coding is performed on a field basis or on a frame basis. (When the video is progressive, the coding is always performed on a frame basis.) enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields are coded separately. disabled: Code the two sets of fields separately (on a field basis) or together (on a frame basis using PAFF), depending on what is most appropriate for the content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getForceFieldPictures() {
            return null;
        }

        /**
         * Indicates how the output video frame rate is specified.
         * <p>
         * If you select "specified," the output video frame rate is determined by framerateNumerator and framerateDenominator. If you select "initializeFromSource," the output video frame rate is set equal to the input video frame rate of the first input.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFramerateControl() {
            return null;
        }

        /**
         * The frame rate denominator.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFramerateDenominator() {
            return null;
        }

        /**
         * The frame rate numerator.
         * <p>
         * The frame rate is a fraction, for example, 24000/1001 = 23.976 fps.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFramerateNumerator() {
            return null;
        }

        /**
         * If enabled, uses reference B frames for GOP structures that have B frames > 1.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGopBReference() {
            return null;
        }

        /**
         * The frequency of closed GOPs.
         * <p>
         * In streaming applications, we recommend that you set this to 1 so that a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGopClosedCadence() {
            return null;
        }

        /**
         * The number of B-frames between reference frames.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGopNumBFrames() {
            return null;
        }

        /**
         * The GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.
         * <p>
         * The value must be greater than zero.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGopSize() {
            return null;
        }

        /**
         * Indicates if the gopSize is specified in frames or seconds.
         * <p>
         * If seconds, the system converts the gopSize into a frame count at runtime.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGopSizeUnits() {
            return null;
        }

        /**
         * The H.264 level.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLevel() {
            return null;
        }

        /**
         * The amount of lookahead.
         * <p>
         * A value of low can decrease latency and memory usage, while high can produce better quality for certain content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLookAheadRateControl() {
            return null;
        }

        /**
         * For QVBR: See the tooltip for Quality level.
         * <p>
         * For VBR: Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxBitrate() {
            return null;
        }

        /**
         * Meaningful only if sceneChangeDetect is set to enabled.
         * <p>
         * This setting enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting the I-interval. The normal cadence resumes for the next GOP. Note that the maximum GOP stretch = GOP size + Min-I-interval - 1.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinIInterval() {
            return null;
        }

        /**
         * The number of reference frames to use.
         * <p>
         * The encoder might use more than requested if you use B-frames or interlaced encoding.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumRefFrames() {
            return null;
        }

        /**
         * Indicates how the output pixel aspect ratio is specified.
         * <p>
         * If "specified" is selected, the output video pixel aspect ratio is determined by parNumerator and parDenominator. If "initializeFromSource" is selected, the output pixels aspect ratio will be set equal to the input video pixel aspect ratio of the first input.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParControl() {
            return null;
        }

        /**
         * The Pixel Aspect Ratio denominator.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getParDenominator() {
            return null;
        }

        /**
         * The Pixel Aspect Ratio numerator.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getParNumerator() {
            return null;
        }

        /**
         * An H.264 profile.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProfile() {
            return null;
        }

        /**
         * Leave as STANDARD_QUALITY or choose a different value (which might result in additional costs to run the channel).
         * <p>
         * <ul>
         * <li>ENHANCED_QUALITY: Produces a slightly better video quality without an increase in the bitrate. Has an effect only when the Rate control mode is QVBR or CBR. If this channel is in a MediaLive multiplex, the value must be ENHANCED_QUALITY.</li>
         * <li>STANDARD_QUALITY: Valid for any Rate control mode.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getQualityLevel() {
            return null;
        }

        /**
         * Controls the target quality for the video encode.
         * <p>
         * This applies only when the rate control mode is QVBR. Set values for the QVBR quality level field and Max bitrate field that suit your most important viewing devices. Recommended values are: - Primary screen: Quality level: 8 to 10. Max bitrate: 4M - PC or tablet: Quality level: 7. Max bitrate: 1.5M to 3M - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getQvbrQualityLevel() {
            return null;
        }

        /**
         * The rate control mode.
         * <p>
         * QVBR: The quality will match the specified quality level except when it is constrained by the maximum bitrate. We recommend this if you or your viewers pay for bandwidth. VBR: The quality and bitrate vary, depending on the video complexity. We recommend this instead of QVBR if you want to maintain a specific average bitrate over the duration of the channel. CBR: The quality varies, depending on the video complexity. We recommend this only if you distribute your assets to devices that can't handle variable bitrates.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRateControlMode() {
            return null;
        }

        /**
         * Sets the scan type of the output to progressive or top-field-first interlaced.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScanType() {
            return null;
        }

        /**
         * The scene change detection.
         * <p>
         * On: inserts I-frames when the scene change is detected. Off: does not force an I-frame when the scene change is detected.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSceneChangeDetect() {
            return null;
        }

        /**
         * The number of slices per picture.
         * <p>
         * The number must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures. This field is optional. If you don't specify a value, MediaLive chooses the number of slices based on the encode resolution.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSlices() {
            return null;
        }

        /**
         * Softness.
         * <p>
         * Selects a quantizer matrix. Larger values reduce high-frequency content in the encoded image.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSoftness() {
            return null;
        }

        /**
         * If set to enabled, adjusts quantization within each frame based on the spatial variation of content complexity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpatialAq() {
            return null;
        }

        /**
         * If set to fixed, uses gopNumBFrames B-frames per sub-GOP.
         * <p>
         * If set to dynamic, optimizes the number of B-frames used for each sub-GOP to improve visual quality.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubgopLength() {
            return null;
        }

        /**
         * Produces a bitstream that is compliant with SMPTE RP-2027.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSyntax() {
            return null;
        }

        /**
         * If set to enabled, adjusts quantization within each frame based on the temporal variation of content complexity.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTemporalAq() {
            return null;
        }

        /**
         * Determines how timecodes should be inserted into the video elementary stream.
         * <p>
         * disabled: don't include timecodes. picTimingSei: pass through picture timing SEI messages from the source specified in Timecode Config.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimecodeInsertion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link H264SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link H264SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<H264SettingsProperty> {
            java.lang.String adaptiveQuantization;
            java.lang.String afdSignaling;
            java.lang.Number bitrate;
            java.lang.Number bufFillPct;
            java.lang.Number bufSize;
            java.lang.String colorMetadata;
            java.lang.Object colorSpaceSettings;
            java.lang.String entropyEncoding;
            java.lang.Object filterSettings;
            java.lang.String fixedAfd;
            java.lang.String flickerAq;
            java.lang.String forceFieldPictures;
            java.lang.String framerateControl;
            java.lang.Number framerateDenominator;
            java.lang.Number framerateNumerator;
            java.lang.String gopBReference;
            java.lang.Number gopClosedCadence;
            java.lang.Number gopNumBFrames;
            java.lang.Number gopSize;
            java.lang.String gopSizeUnits;
            java.lang.String level;
            java.lang.String lookAheadRateControl;
            java.lang.Number maxBitrate;
            java.lang.Number minIInterval;
            java.lang.Number numRefFrames;
            java.lang.String parControl;
            java.lang.Number parDenominator;
            java.lang.Number parNumerator;
            java.lang.String profile;
            java.lang.String qualityLevel;
            java.lang.Number qvbrQualityLevel;
            java.lang.String rateControlMode;
            java.lang.String scanType;
            java.lang.String sceneChangeDetect;
            java.lang.Number slices;
            java.lang.Number softness;
            java.lang.String spatialAq;
            java.lang.String subgopLength;
            java.lang.String syntax;
            java.lang.String temporalAq;
            java.lang.String timecodeInsertion;

            /**
             * Sets the value of {@link H264SettingsProperty#getAdaptiveQuantization}
             * @param adaptiveQuantization The adaptive quantization.
             *                             This allows intra-frame quantizers to vary to improve visual quality.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adaptiveQuantization(java.lang.String adaptiveQuantization) {
                this.adaptiveQuantization = adaptiveQuantization;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getAfdSignaling}
             * @param afdSignaling Indicates that AFD values will be written into the output stream.
             *                     If afdSignaling is auto, the system tries to preserve the input AFD value (in cases where multiple AFD values are valid). If set to fixed, the AFD value is the value configured in the fixedAfd parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder afdSignaling(java.lang.String afdSignaling) {
                this.afdSignaling = afdSignaling;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getBitrate}
             * @param bitrate The average bitrate in bits/second.
             *                This is required when the rate control mode is VBR or CBR. It isn't used for QVBR. In a Microsoft Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest multiple of 1000.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bitrate(java.lang.Number bitrate) {
                this.bitrate = bitrate;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getBufFillPct}
             * @param bufFillPct The percentage of the buffer that should initially be filled (HRD buffer model).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufFillPct(java.lang.Number bufFillPct) {
                this.bufFillPct = bufFillPct;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getBufSize}
             * @param bufSize The size of the buffer (HRD buffer model) in bits/second.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufSize(java.lang.Number bufSize) {
                this.bufSize = bufSize;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getColorMetadata}
             * @param colorMetadata Includes color space metadata in the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorMetadata(java.lang.String colorMetadata) {
                this.colorMetadata = colorMetadata;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getColorSpaceSettings}
             * @param colorSpaceSettings Settings to configure the color space handling for the video.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorSpaceSettings(software.amazon.awscdk.services.medialive.CfnChannel.H264ColorSpaceSettingsProperty colorSpaceSettings) {
                this.colorSpaceSettings = colorSpaceSettings;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getColorSpaceSettings}
             * @param colorSpaceSettings Settings to configure the color space handling for the video.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder colorSpaceSettings(software.amazon.awscdk.IResolvable colorSpaceSettings) {
                this.colorSpaceSettings = colorSpaceSettings;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getEntropyEncoding}
             * @param entropyEncoding The entropy encoding mode.
             *                        Use cabac (must be in Main or High profile) or cavlc.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entropyEncoding(java.lang.String entropyEncoding) {
                this.entropyEncoding = entropyEncoding;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getFilterSettings}
             * @param filterSettings Optional filters that you can apply to an encode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterSettings(software.amazon.awscdk.services.medialive.CfnChannel.H264FilterSettingsProperty filterSettings) {
                this.filterSettings = filterSettings;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getFilterSettings}
             * @param filterSettings Optional filters that you can apply to an encode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterSettings(software.amazon.awscdk.IResolvable filterSettings) {
                this.filterSettings = filterSettings;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getFixedAfd}
             * @param fixedAfd A four-bit AFD value to write on all frames of video in the output stream.
             *                 Valid only when afdSignaling is set to Fixed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fixedAfd(java.lang.String fixedAfd) {
                this.fixedAfd = fixedAfd;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getFlickerAq}
             * @param flickerAq If set to enabled, adjusts the quantization within each frame to reduce flicker or pop on I-frames.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flickerAq(java.lang.String flickerAq) {
                this.flickerAq = flickerAq;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getForceFieldPictures}
             * @param forceFieldPictures This setting applies only when scan type is "interlaced." It controls whether coding is performed on a field basis or on a frame basis. (When the video is progressive, the coding is always performed on a frame basis.) enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields are coded separately. disabled: Code the two sets of fields separately (on a field basis) or together (on a frame basis using PAFF), depending on what is most appropriate for the content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forceFieldPictures(java.lang.String forceFieldPictures) {
                this.forceFieldPictures = forceFieldPictures;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getFramerateControl}
             * @param framerateControl Indicates how the output video frame rate is specified.
             *                         If you select "specified," the output video frame rate is determined by framerateNumerator and framerateDenominator. If you select "initializeFromSource," the output video frame rate is set equal to the input video frame rate of the first input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder framerateControl(java.lang.String framerateControl) {
                this.framerateControl = framerateControl;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getFramerateDenominator}
             * @param framerateDenominator The frame rate denominator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder framerateDenominator(java.lang.Number framerateDenominator) {
                this.framerateDenominator = framerateDenominator;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getFramerateNumerator}
             * @param framerateNumerator The frame rate numerator.
             *                           The frame rate is a fraction, for example, 24000/1001 = 23.976 fps.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder framerateNumerator(java.lang.Number framerateNumerator) {
                this.framerateNumerator = framerateNumerator;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getGopBReference}
             * @param gopBReference If enabled, uses reference B frames for GOP structures that have B frames > 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gopBReference(java.lang.String gopBReference) {
                this.gopBReference = gopBReference;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getGopClosedCadence}
             * @param gopClosedCadence The frequency of closed GOPs.
             *                         In streaming applications, we recommend that you set this to 1 so that a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gopClosedCadence(java.lang.Number gopClosedCadence) {
                this.gopClosedCadence = gopClosedCadence;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getGopNumBFrames}
             * @param gopNumBFrames The number of B-frames between reference frames.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gopNumBFrames(java.lang.Number gopNumBFrames) {
                this.gopNumBFrames = gopNumBFrames;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getGopSize}
             * @param gopSize The GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.
             *                The value must be greater than zero.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gopSize(java.lang.Number gopSize) {
                this.gopSize = gopSize;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getGopSizeUnits}
             * @param gopSizeUnits Indicates if the gopSize is specified in frames or seconds.
             *                     If seconds, the system converts the gopSize into a frame count at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gopSizeUnits(java.lang.String gopSizeUnits) {
                this.gopSizeUnits = gopSizeUnits;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getLevel}
             * @param level The H.264 level.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder level(java.lang.String level) {
                this.level = level;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getLookAheadRateControl}
             * @param lookAheadRateControl The amount of lookahead.
             *                             A value of low can decrease latency and memory usage, while high can produce better quality for certain content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lookAheadRateControl(java.lang.String lookAheadRateControl) {
                this.lookAheadRateControl = lookAheadRateControl;
                return this;
            }

            /**
             * Sets the value of {@link H264SettingsProperty#getMaxBitrate}
             * @param maxBitrate For QVBR: See the to