package software.amazon.awscdk.services.lambda;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * LambdaRuntimeProps lambdaRuntimeProps = LambdaRuntimeProps.builder()
 *         .bundlingDockerImage("bundlingDockerImage")
 *         .supportsCodeGuruProfiling(false)
 *         .supportsInlineCode(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:13.103Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.LambdaRuntimeProps")
@software.amazon.jsii.Jsii.Proxy(LambdaRuntimeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LambdaRuntimeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Docker image name to be used for bundling in this runtime.
     * <p>
     * Default: - the latest docker image "amazon/public.ecr.aws/sam/build-<runtime>" from https://gallery.ecr.aws
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBundlingDockerImage() {
        return null;
    }

    /**
     * Whether this runtime is integrated with and supported for profiling using Amazon CodeGuru Profiler.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSupportsCodeGuruProfiling() {
        return null;
    }

    /**
     * Whether the ``ZipFile`` (aka inline code) property can be used with this runtime.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSupportsInlineCode() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LambdaRuntimeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaRuntimeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LambdaRuntimeProps> {
        java.lang.String bundlingDockerImage;
        java.lang.Boolean supportsCodeGuruProfiling;
        java.lang.Boolean supportsInlineCode;

        /**
         * Sets the value of {@link LambdaRuntimeProps#getBundlingDockerImage}
         * @param bundlingDockerImage The Docker image name to be used for bundling in this runtime.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundlingDockerImage(java.lang.String bundlingDockerImage) {
            this.bundlingDockerImage = bundlingDockerImage;
            return this;
        }

        /**
         * Sets the value of {@link LambdaRuntimeProps#getSupportsCodeGuruProfiling}
         * @param supportsCodeGuruProfiling Whether this runtime is integrated with and supported for profiling using Amazon CodeGuru Profiler.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportsCodeGuruProfiling(java.lang.Boolean supportsCodeGuruProfiling) {
            this.supportsCodeGuruProfiling = supportsCodeGuruProfiling;
            return this;
        }

        /**
         * Sets the value of {@link LambdaRuntimeProps#getSupportsInlineCode}
         * @param supportsInlineCode Whether the ``ZipFile`` (aka inline code) property can be used with this runtime.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportsInlineCode(java.lang.Boolean supportsInlineCode) {
            this.supportsInlineCode = supportsInlineCode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaRuntimeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LambdaRuntimeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LambdaRuntimeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaRuntimeProps {
        private final java.lang.String bundlingDockerImage;
        private final java.lang.Boolean supportsCodeGuruProfiling;
        private final java.lang.Boolean supportsInlineCode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bundlingDockerImage = software.amazon.jsii.Kernel.get(this, "bundlingDockerImage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.supportsCodeGuruProfiling = software.amazon.jsii.Kernel.get(this, "supportsCodeGuruProfiling", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.supportsInlineCode = software.amazon.jsii.Kernel.get(this, "supportsInlineCode", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bundlingDockerImage = builder.bundlingDockerImage;
            this.supportsCodeGuruProfiling = builder.supportsCodeGuruProfiling;
            this.supportsInlineCode = builder.supportsInlineCode;
        }

        @Override
        public final java.lang.String getBundlingDockerImage() {
            return this.bundlingDockerImage;
        }

        @Override
        public final java.lang.Boolean getSupportsCodeGuruProfiling() {
            return this.supportsCodeGuruProfiling;
        }

        @Override
        public final java.lang.Boolean getSupportsInlineCode() {
            return this.supportsInlineCode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBundlingDockerImage() != null) {
                data.set("bundlingDockerImage", om.valueToTree(this.getBundlingDockerImage()));
            }
            if (this.getSupportsCodeGuruProfiling() != null) {
                data.set("supportsCodeGuruProfiling", om.valueToTree(this.getSupportsCodeGuruProfiling()));
            }
            if (this.getSupportsInlineCode() != null) {
                data.set("supportsInlineCode", om.valueToTree(this.getSupportsInlineCode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.LambdaRuntimeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaRuntimeProps.Jsii$Proxy that = (LambdaRuntimeProps.Jsii$Proxy) o;

            if (this.bundlingDockerImage != null ? !this.bundlingDockerImage.equals(that.bundlingDockerImage) : that.bundlingDockerImage != null) return false;
            if (this.supportsCodeGuruProfiling != null ? !this.supportsCodeGuruProfiling.equals(that.supportsCodeGuruProfiling) : that.supportsCodeGuruProfiling != null) return false;
            return this.supportsInlineCode != null ? this.supportsInlineCode.equals(that.supportsInlineCode) : that.supportsInlineCode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bundlingDockerImage != null ? this.bundlingDockerImage.hashCode() : 0;
            result = 31 * result + (this.supportsCodeGuruProfiling != null ? this.supportsCodeGuruProfiling.hashCode() : 0);
            result = 31 * result + (this.supportsInlineCode != null ? this.supportsInlineCode.hashCode() : 0);
            return result;
        }
    }
}
