package software.amazon.awscdk.services.iotfleetwise;

/**
 * Properties for defining a `CfnSignalCatalog`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotfleetwise.*;
 * CfnSignalCatalogProps cfnSignalCatalogProps = CfnSignalCatalogProps.builder()
 *         .description("description")
 *         .name("name")
 *         .nodes(List.of(NodeProperty.builder()
 *                 .actuator(ActuatorProperty.builder()
 *                         .dataType("dataType")
 *                         .fullyQualifiedName("fullyQualifiedName")
 *                         // the properties below are optional
 *                         .allowedValues(List.of("allowedValues"))
 *                         .assignedValue("assignedValue")
 *                         .description("description")
 *                         .max(123)
 *                         .min(123)
 *                         .unit("unit")
 *                         .build())
 *                 .attribute(AttributeProperty.builder()
 *                         .dataType("dataType")
 *                         .fullyQualifiedName("fullyQualifiedName")
 *                         // the properties below are optional
 *                         .allowedValues(List.of("allowedValues"))
 *                         .assignedValue("assignedValue")
 *                         .defaultValue("defaultValue")
 *                         .description("description")
 *                         .max(123)
 *                         .min(123)
 *                         .unit("unit")
 *                         .build())
 *                 .branch(BranchProperty.builder()
 *                         .fullyQualifiedName("fullyQualifiedName")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .build())
 *                 .sensor(SensorProperty.builder()
 *                         .dataType("dataType")
 *                         .fullyQualifiedName("fullyQualifiedName")
 *                         // the properties below are optional
 *                         .allowedValues(List.of("allowedValues"))
 *                         .description("description")
 *                         .max(123)
 *                         .min(123)
 *                         .unit("unit")
 *                         .build())
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:12.633Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnSignalCatalogProps")
@software.amazon.jsii.Jsii.Proxy(CfnSignalCatalogProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSignalCatalogProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::IoTFleetWise::SignalCatalog.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * `AWS::IoTFleetWise::SignalCatalog.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * `AWS::IoTFleetWise::SignalCatalog.Nodes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNodes() {
        return null;
    }

    /**
     * `AWS::IoTFleetWise::SignalCatalog.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSignalCatalogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSignalCatalogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSignalCatalogProps> {
        java.lang.String description;
        java.lang.String name;
        java.lang.Object nodes;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnSignalCatalogProps#getDescription}
         * @param description `AWS::IoTFleetWise::SignalCatalog.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnSignalCatalogProps#getName}
         * @param name `AWS::IoTFleetWise::SignalCatalog.Name`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnSignalCatalogProps#getNodes}
         * @param nodes `AWS::IoTFleetWise::SignalCatalog.Nodes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodes(software.amazon.awscdk.IResolvable nodes) {
            this.nodes = nodes;
            return this;
        }

        /**
         * Sets the value of {@link CfnSignalCatalogProps#getNodes}
         * @param nodes `AWS::IoTFleetWise::SignalCatalog.Nodes`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodes(java.util.List<? extends java.lang.Object> nodes) {
            this.nodes = nodes;
            return this;
        }

        /**
         * Sets the value of {@link CfnSignalCatalogProps#getTags}
         * @param tags `AWS::IoTFleetWise::SignalCatalog.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSignalCatalogProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSignalCatalogProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSignalCatalogProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSignalCatalogProps {
        private final java.lang.String description;
        private final java.lang.String name;
        private final java.lang.Object nodes;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nodes = software.amazon.jsii.Kernel.get(this, "nodes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.name = builder.name;
            this.nodes = builder.nodes;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getNodes() {
            return this.nodes;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getNodes() != null) {
                data.set("nodes", om.valueToTree(this.getNodes()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnSignalCatalogProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSignalCatalogProps.Jsii$Proxy that = (CfnSignalCatalogProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.nodes != null ? !this.nodes.equals(that.nodes) : that.nodes != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.nodes != null ? this.nodes.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
