package software.amazon.awscdk.services.iotanalytics;

/**
 * Properties for defining a `CfnDatastore`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotanalytics.*;
 * Object jsonConfiguration;
 * Object serviceManagedS3;
 * CfnDatastoreProps cfnDatastoreProps = CfnDatastoreProps.builder()
 *         .datastoreName("datastoreName")
 *         .datastorePartitions(DatastorePartitionsProperty.builder()
 *                 .partitions(List.of(DatastorePartitionProperty.builder()
 *                         .partition(PartitionProperty.builder()
 *                                 .attributeName("attributeName")
 *                                 .build())
 *                         .timestampPartition(TimestampPartitionProperty.builder()
 *                                 .attributeName("attributeName")
 *                                 // the properties below are optional
 *                                 .timestampFormat("timestampFormat")
 *                                 .build())
 *                         .build()))
 *                 .build())
 *         .datastoreStorage(DatastoreStorageProperty.builder()
 *                 .customerManagedS3(CustomerManagedS3Property.builder()
 *                         .bucket("bucket")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .keyPrefix("keyPrefix")
 *                         .build())
 *                 .iotSiteWiseMultiLayerStorage(IotSiteWiseMultiLayerStorageProperty.builder()
 *                         .customerManagedS3Storage(CustomerManagedS3StorageProperty.builder()
 *                                 .bucket("bucket")
 *                                 // the properties below are optional
 *                                 .keyPrefix("keyPrefix")
 *                                 .build())
 *                         .build())
 *                 .serviceManagedS3(serviceManagedS3)
 *                 .build())
 *         .fileFormatConfiguration(FileFormatConfigurationProperty.builder()
 *                 .jsonConfiguration(jsonConfiguration)
 *                 .parquetConfiguration(ParquetConfigurationProperty.builder()
 *                         .schemaDefinition(SchemaDefinitionProperty.builder()
 *                                 .columns(List.of(ColumnProperty.builder()
 *                                         .name("name")
 *                                         .type("type")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .retentionPeriod(RetentionPeriodProperty.builder()
 *                 .numberOfDays(123)
 *                 .unlimited(false)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:12.537Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnDatastoreProps")
@software.amazon.jsii.Jsii.Proxy(CfnDatastoreProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDatastoreProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatastoreName() {
        return null;
    }

    /**
     * Information about the partition dimensions in a data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDatastorePartitions() {
        return null;
    }

    /**
     * Where data store data is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDatastoreStorage() {
        return null;
    }

    /**
     * Contains the configuration information of file formats. AWS IoT Analytics data stores support JSON and [Parquet](https://docs.aws.amazon.com/https://parquet.apache.org/) .
     * <p>
     * The default file format is JSON. You can specify only one format.
     * <p>
     * You can't change the file format after you create the data store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFileFormatConfiguration() {
        return null;
    }

    /**
     * How long, in days, message data is kept for the data store.
     * <p>
     * When <code>customerManagedS3</code> storage is selected, this parameter is ignored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRetentionPeriod() {
        return null;
    }

    /**
     * Metadata which can be used to manage the data store.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDatastoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDatastoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDatastoreProps> {
        java.lang.String datastoreName;
        java.lang.Object datastorePartitions;
        java.lang.Object datastoreStorage;
        java.lang.Object fileFormatConfiguration;
        java.lang.Object retentionPeriod;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDatastoreProps#getDatastoreName}
         * @param datastoreName The name of the data store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastoreName(java.lang.String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatastoreProps#getDatastorePartitions}
         * @param datastorePartitions Information about the partition dimensions in a data store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastorePartitions(software.amazon.awscdk.services.iotanalytics.CfnDatastore.DatastorePartitionsProperty datastorePartitions) {
            this.datastorePartitions = datastorePartitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatastoreProps#getDatastorePartitions}
         * @param datastorePartitions Information about the partition dimensions in a data store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastorePartitions(software.amazon.awscdk.IResolvable datastorePartitions) {
            this.datastorePartitions = datastorePartitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatastoreProps#getDatastoreStorage}
         * @param datastoreStorage Where data store data is stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastoreStorage(software.amazon.awscdk.services.iotanalytics.CfnDatastore.DatastoreStorageProperty datastoreStorage) {
            this.datastoreStorage = datastoreStorage;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatastoreProps#getDatastoreStorage}
         * @param datastoreStorage Where data store data is stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastoreStorage(software.amazon.awscdk.IResolvable datastoreStorage) {
            this.datastoreStorage = datastoreStorage;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatastoreProps#getFileFormatConfiguration}
         * @param fileFormatConfiguration Contains the configuration information of file formats. AWS IoT Analytics data stores support JSON and [Parquet](https://docs.aws.amazon.com/https://parquet.apache.org/) .
         *                                The default file format is JSON. You can specify only one format.
         *                                <p>
         *                                You can't change the file format after you create the data store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileFormatConfiguration(software.amazon.awscdk.services.iotanalytics.CfnDatastore.FileFormatConfigurationProperty fileFormatConfiguration) {
            this.fileFormatConfiguration = fileFormatConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatastoreProps#getFileFormatConfiguration}
         * @param fileFormatConfiguration Contains the configuration information of file formats. AWS IoT Analytics data stores support JSON and [Parquet](https://docs.aws.amazon.com/https://parquet.apache.org/) .
         *                                The default file format is JSON. You can specify only one format.
         *                                <p>
         *                                You can't change the file format after you create the data store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileFormatConfiguration(software.amazon.awscdk.IResolvable fileFormatConfiguration) {
            this.fileFormatConfiguration = fileFormatConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatastoreProps#getRetentionPeriod}
         * @param retentionPeriod How long, in days, message data is kept for the data store.
         *                        When <code>customerManagedS3</code> storage is selected, this parameter is ignored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(software.amazon.awscdk.services.iotanalytics.CfnDatastore.RetentionPeriodProperty retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatastoreProps#getRetentionPeriod}
         * @param retentionPeriod How long, in days, message data is kept for the data store.
         *                        When <code>customerManagedS3</code> storage is selected, this parameter is ignored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(software.amazon.awscdk.IResolvable retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnDatastoreProps#getTags}
         * @param tags Metadata which can be used to manage the data store.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDatastoreProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDatastoreProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDatastoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDatastoreProps {
        private final java.lang.String datastoreName;
        private final java.lang.Object datastorePartitions;
        private final java.lang.Object datastoreStorage;
        private final java.lang.Object fileFormatConfiguration;
        private final java.lang.Object retentionPeriod;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.datastoreName = software.amazon.jsii.Kernel.get(this, "datastoreName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.datastorePartitions = software.amazon.jsii.Kernel.get(this, "datastorePartitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.datastoreStorage = software.amazon.jsii.Kernel.get(this, "datastoreStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.fileFormatConfiguration = software.amazon.jsii.Kernel.get(this, "fileFormatConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.retentionPeriod = software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.datastoreName = builder.datastoreName;
            this.datastorePartitions = builder.datastorePartitions;
            this.datastoreStorage = builder.datastoreStorage;
            this.fileFormatConfiguration = builder.fileFormatConfiguration;
            this.retentionPeriod = builder.retentionPeriod;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDatastoreName() {
            return this.datastoreName;
        }

        @Override
        public final java.lang.Object getDatastorePartitions() {
            return this.datastorePartitions;
        }

        @Override
        public final java.lang.Object getDatastoreStorage() {
            return this.datastoreStorage;
        }

        @Override
        public final java.lang.Object getFileFormatConfiguration() {
            return this.fileFormatConfiguration;
        }

        @Override
        public final java.lang.Object getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDatastoreName() != null) {
                data.set("datastoreName", om.valueToTree(this.getDatastoreName()));
            }
            if (this.getDatastorePartitions() != null) {
                data.set("datastorePartitions", om.valueToTree(this.getDatastorePartitions()));
            }
            if (this.getDatastoreStorage() != null) {
                data.set("datastoreStorage", om.valueToTree(this.getDatastoreStorage()));
            }
            if (this.getFileFormatConfiguration() != null) {
                data.set("fileFormatConfiguration", om.valueToTree(this.getFileFormatConfiguration()));
            }
            if (this.getRetentionPeriod() != null) {
                data.set("retentionPeriod", om.valueToTree(this.getRetentionPeriod()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnDatastoreProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDatastoreProps.Jsii$Proxy that = (CfnDatastoreProps.Jsii$Proxy) o;

            if (this.datastoreName != null ? !this.datastoreName.equals(that.datastoreName) : that.datastoreName != null) return false;
            if (this.datastorePartitions != null ? !this.datastorePartitions.equals(that.datastorePartitions) : that.datastorePartitions != null) return false;
            if (this.datastoreStorage != null ? !this.datastoreStorage.equals(that.datastoreStorage) : that.datastoreStorage != null) return false;
            if (this.fileFormatConfiguration != null ? !this.fileFormatConfiguration.equals(that.fileFormatConfiguration) : that.fileFormatConfiguration != null) return false;
            if (this.retentionPeriod != null ? !this.retentionPeriod.equals(that.retentionPeriod) : that.retentionPeriod != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.datastoreName != null ? this.datastoreName.hashCode() : 0;
            result = 31 * result + (this.datastorePartitions != null ? this.datastorePartitions.hashCode() : 0);
            result = 31 * result + (this.datastoreStorage != null ? this.datastoreStorage.hashCode() : 0);
            result = 31 * result + (this.fileFormatConfiguration != null ? this.fileFormatConfiguration.hashCode() : 0);
            result = 31 * result + (this.retentionPeriod != null ? this.retentionPeriod.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
