package software.amazon.awscdk.services.imagebuilder;

/**
 * A CloudFormation `AWS::ImageBuilder::ImagePipeline`.
 * <p>
 * An image pipeline is the automation configuration for building secure OS images on AWS . The Image Builder image pipeline is associated with an image recipe that defines the build, validation, and test phases for an image build lifecycle. An image pipeline can be associated with an infrastructure configuration that defines where your image is built. You can define attributes, such as instance type, subnets, security groups, logging, and other infrastructure-related configurations. You can also associate your image pipeline with a distribution configuration to define how you would like to deploy your image.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.imagebuilder.*;
 * CfnImagePipeline cfnImagePipeline = CfnImagePipeline.Builder.create(this, "MyCfnImagePipeline")
 *         .infrastructureConfigurationArn("infrastructureConfigurationArn")
 *         .name("name")
 *         // the properties below are optional
 *         .containerRecipeArn("containerRecipeArn")
 *         .description("description")
 *         .distributionConfigurationArn("distributionConfigurationArn")
 *         .enhancedImageMetadataEnabled(false)
 *         .imageRecipeArn("imageRecipeArn")
 *         .imageTestsConfiguration(ImageTestsConfigurationProperty.builder()
 *                 .imageTestsEnabled(false)
 *                 .timeoutMinutes(123)
 *                 .build())
 *         .schedule(ScheduleProperty.builder()
 *                 .pipelineExecutionStartCondition("pipelineExecutionStartCondition")
 *                 .scheduleExpression("scheduleExpression")
 *                 .build())
 *         .status("status")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:12.382Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnImagePipeline")
public class CfnImagePipeline extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnImagePipeline(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnImagePipeline(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.imagebuilder.CfnImagePipeline.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ImageBuilder::ImagePipeline`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnImagePipeline(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.imagebuilder.CfnImagePipelineProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the Amazon Resource Name (ARN) of the image pipeline.
     * <p>
     * For example, <code>arn:aws:imagebuilder:us-west-2:123456789012:image-pipeline/mywindows2016pipeline</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the name of the image pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags of this image pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInfrastructureConfigurationArn() {
        return software.amazon.jsii.Kernel.get(this, "infrastructureConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInfrastructureConfigurationArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "infrastructureConfigurationArn", java.util.Objects.requireNonNull(value, "infrastructureConfigurationArn is required"));
    }

    /**
     * The name of the image pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the image pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getContainerRecipeArn() {
        return software.amazon.jsii.Kernel.get(this, "containerRecipeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerRecipeArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "containerRecipeArn", value);
    }

    /**
     * The description of this image pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of this image pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the distribution configuration associated with this image pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDistributionConfigurationArn() {
        return software.amazon.jsii.Kernel.get(this, "distributionConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the distribution configuration associated with this image pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDistributionConfigurationArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "distributionConfigurationArn", value);
    }

    /**
     * Collects additional information about the image being created, including the operating system (OS) version and package list.
     * <p>
     * This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnhancedImageMetadataEnabled() {
        return software.amazon.jsii.Kernel.get(this, "enhancedImageMetadataEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Collects additional information about the image being created, including the operating system (OS) version and package list.
     * <p>
     * This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnhancedImageMetadataEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enhancedImageMetadataEnabled", value);
    }

    /**
     * Collects additional information about the image being created, including the operating system (OS) version and package list.
     * <p>
     * This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnhancedImageMetadataEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enhancedImageMetadataEnabled", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the image recipe associated with this image pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getImageRecipeArn() {
        return software.amazon.jsii.Kernel.get(this, "imageRecipeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the image recipe associated with this image pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageRecipeArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "imageRecipeArn", value);
    }

    /**
     * The configuration of the image tests that run after image creation to ensure the quality of the image that was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getImageTestsConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "imageTestsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of the image tests that run after image creation to ensure the quality of the image that was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageTestsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.imagebuilder.CfnImagePipeline.ImageTestsConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "imageTestsConfiguration", value);
    }

    /**
     * The configuration of the image tests that run after image creation to ensure the quality of the image that was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageTestsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "imageTestsConfiguration", value);
    }

    /**
     * The schedule of the image pipeline.
     * <p>
     * A schedule configures how often and when a pipeline automatically creates a new image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The schedule of the image pipeline.
     * <p>
     * A schedule configures how often and when a pipeline automatically creates a new image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.imagebuilder.CfnImagePipeline.ScheduleProperty value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * The schedule of the image pipeline.
     * <p>
     * A schedule configures how often and when a pipeline automatically creates a new image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * The status of the image pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the image pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "status", value);
    }
    /**
     * When you create an image or container recipe with Image Builder , you can add the build or test components that your image pipeline uses to create the final image.
     * <p>
     * You must have at least one build component to create a recipe, but test components are not required. Your pipeline runs tests after it builds the image, to ensure that the target image is functional and can be used reliably for launching Amazon EC2 instances.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * ImageTestsConfigurationProperty imageTestsConfigurationProperty = ImageTestsConfigurationProperty.builder()
     *         .imageTestsEnabled(false)
     *         .timeoutMinutes(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnImagePipeline.ImageTestsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageTestsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageTestsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines if tests should be executed when building this image.
         * <p>
         * For example, <code>true</code> or <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImageTestsEnabled() {
            return null;
        }

        /**
         * The maximum time in minutes that tests are permitted to run.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImageTestsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageTestsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageTestsConfigurationProperty> {
            java.lang.Object imageTestsEnabled;
            java.lang.Number timeoutMinutes;

            /**
             * Sets the value of {@link ImageTestsConfigurationProperty#getImageTestsEnabled}
             * @param imageTestsEnabled Defines if tests should be executed when building this image.
             *                          For example, <code>true</code> or <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageTestsEnabled(java.lang.Boolean imageTestsEnabled) {
                this.imageTestsEnabled = imageTestsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ImageTestsConfigurationProperty#getImageTestsEnabled}
             * @param imageTestsEnabled Defines if tests should be executed when building this image.
             *                          For example, <code>true</code> or <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageTestsEnabled(software.amazon.awscdk.IResolvable imageTestsEnabled) {
                this.imageTestsEnabled = imageTestsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ImageTestsConfigurationProperty#getTimeoutMinutes}
             * @param timeoutMinutes The maximum time in minutes that tests are permitted to run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutMinutes(java.lang.Number timeoutMinutes) {
                this.timeoutMinutes = timeoutMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageTestsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageTestsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImageTestsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageTestsConfigurationProperty {
            private final java.lang.Object imageTestsEnabled;
            private final java.lang.Number timeoutMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.imageTestsEnabled = software.amazon.jsii.Kernel.get(this, "imageTestsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutMinutes = software.amazon.jsii.Kernel.get(this, "timeoutMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.imageTestsEnabled = builder.imageTestsEnabled;
                this.timeoutMinutes = builder.timeoutMinutes;
            }

            @Override
            public final java.lang.Object getImageTestsEnabled() {
                return this.imageTestsEnabled;
            }

            @Override
            public final java.lang.Number getTimeoutMinutes() {
                return this.timeoutMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getImageTestsEnabled() != null) {
                    data.set("imageTestsEnabled", om.valueToTree(this.getImageTestsEnabled()));
                }
                if (this.getTimeoutMinutes() != null) {
                    data.set("timeoutMinutes", om.valueToTree(this.getTimeoutMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnImagePipeline.ImageTestsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageTestsConfigurationProperty.Jsii$Proxy that = (ImageTestsConfigurationProperty.Jsii$Proxy) o;

                if (this.imageTestsEnabled != null ? !this.imageTestsEnabled.equals(that.imageTestsEnabled) : that.imageTestsEnabled != null) return false;
                return this.timeoutMinutes != null ? this.timeoutMinutes.equals(that.timeoutMinutes) : that.timeoutMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.imageTestsEnabled != null ? this.imageTestsEnabled.hashCode() : 0;
                result = 31 * result + (this.timeoutMinutes != null ? this.timeoutMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A schedule configures how often and when a pipeline will automatically create a new image.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * ScheduleProperty scheduleProperty = ScheduleProperty.builder()
     *         .pipelineExecutionStartCondition("pipelineExecutionStartCondition")
     *         .scheduleExpression("scheduleExpression")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnImagePipeline.ScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The condition configures when the pipeline should trigger a new image build.
         * <p>
         * When the <code>pipelineExecutionStartCondition</code> is set to <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code> , and you use semantic version filters on the base image or components in your image recipe, Image Builder will build a new image only when there are new versions of the image or components in your recipe that match the semantic version filter. When it is set to <code>EXPRESSION_MATCH_ONLY</code> , it will build a new image every time the CRON expression matches the current time. For semantic version syntax, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html">CreateComponent</a> in the <em>Image Builder API Reference</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPipelineExecutionStartCondition() {
            return null;
        }

        /**
         * The cron expression determines how often EC2 Image Builder evaluates your `pipelineExecutionStartCondition` .
         * <p>
         * For information on how to format a cron expression in Image Builder, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html">Use cron expressions in EC2 Image Builder</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScheduleExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleProperty> {
            java.lang.String pipelineExecutionStartCondition;
            java.lang.String scheduleExpression;

            /**
             * Sets the value of {@link ScheduleProperty#getPipelineExecutionStartCondition}
             * @param pipelineExecutionStartCondition The condition configures when the pipeline should trigger a new image build.
             *                                        When the <code>pipelineExecutionStartCondition</code> is set to <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code> , and you use semantic version filters on the base image or components in your image recipe, Image Builder will build a new image only when there are new versions of the image or components in your recipe that match the semantic version filter. When it is set to <code>EXPRESSION_MATCH_ONLY</code> , it will build a new image every time the CRON expression matches the current time. For semantic version syntax, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html">CreateComponent</a> in the <em>Image Builder API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pipelineExecutionStartCondition(java.lang.String pipelineExecutionStartCondition) {
                this.pipelineExecutionStartCondition = pipelineExecutionStartCondition;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getScheduleExpression}
             * @param scheduleExpression The cron expression determines how often EC2 Image Builder evaluates your `pipelineExecutionStartCondition` .
             *                           For information on how to format a cron expression in Image Builder, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html">Use cron expressions in EC2 Image Builder</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleExpression(java.lang.String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleProperty {
            private final java.lang.String pipelineExecutionStartCondition;
            private final java.lang.String scheduleExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pipelineExecutionStartCondition = software.amazon.jsii.Kernel.get(this, "pipelineExecutionStartCondition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pipelineExecutionStartCondition = builder.pipelineExecutionStartCondition;
                this.scheduleExpression = builder.scheduleExpression;
            }

            @Override
            public final java.lang.String getPipelineExecutionStartCondition() {
                return this.pipelineExecutionStartCondition;
            }

            @Override
            public final java.lang.String getScheduleExpression() {
                return this.scheduleExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPipelineExecutionStartCondition() != null) {
                    data.set("pipelineExecutionStartCondition", om.valueToTree(this.getPipelineExecutionStartCondition()));
                }
                if (this.getScheduleExpression() != null) {
                    data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnImagePipeline.ScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleProperty.Jsii$Proxy that = (ScheduleProperty.Jsii$Proxy) o;

                if (this.pipelineExecutionStartCondition != null ? !this.pipelineExecutionStartCondition.equals(that.pipelineExecutionStartCondition) : that.pipelineExecutionStartCondition != null) return false;
                return this.scheduleExpression != null ? this.scheduleExpression.equals(that.scheduleExpression) : that.scheduleExpression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pipelineExecutionStartCondition != null ? this.pipelineExecutionStartCondition.hashCode() : 0;
                result = 31 * result + (this.scheduleExpression != null ? this.scheduleExpression.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.imagebuilder.CfnImagePipeline}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.imagebuilder.CfnImagePipeline> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.imagebuilder.CfnImagePipelineProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.imagebuilder.CfnImagePipelineProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline.
         * <p>
         * @return {@code this}
         * @param infrastructureConfigurationArn The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder infrastructureConfigurationArn(final java.lang.String infrastructureConfigurationArn) {
            this.props.infrastructureConfigurationArn(infrastructureConfigurationArn);
            return this;
        }

        /**
         * The name of the image pipeline.
         * <p>
         * @return {@code this}
         * @param name The name of the image pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.
         * <p>
         * @return {@code this}
         * @param containerRecipeArn The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerRecipeArn(final java.lang.String containerRecipeArn) {
            this.props.containerRecipeArn(containerRecipeArn);
            return this;
        }

        /**
         * The description of this image pipeline.
         * <p>
         * @return {@code this}
         * @param description The description of this image pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the distribution configuration associated with this image pipeline.
         * <p>
         * @return {@code this}
         * @param distributionConfigurationArn The Amazon Resource Name (ARN) of the distribution configuration associated with this image pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionConfigurationArn(final java.lang.String distributionConfigurationArn) {
            this.props.distributionConfigurationArn(distributionConfigurationArn);
            return this;
        }

        /**
         * Collects additional information about the image being created, including the operating system (OS) version and package list.
         * <p>
         * This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
         * <p>
         * @return {@code this}
         * @param enhancedImageMetadataEnabled Collects additional information about the image being created, including the operating system (OS) version and package list. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedImageMetadataEnabled(final java.lang.Boolean enhancedImageMetadataEnabled) {
            this.props.enhancedImageMetadataEnabled(enhancedImageMetadataEnabled);
            return this;
        }
        /**
         * Collects additional information about the image being created, including the operating system (OS) version and package list.
         * <p>
         * This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
         * <p>
         * @return {@code this}
         * @param enhancedImageMetadataEnabled Collects additional information about the image being created, including the operating system (OS) version and package list. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedImageMetadataEnabled(final software.amazon.awscdk.IResolvable enhancedImageMetadataEnabled) {
            this.props.enhancedImageMetadataEnabled(enhancedImageMetadataEnabled);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the image recipe associated with this image pipeline.
         * <p>
         * @return {@code this}
         * @param imageRecipeArn The Amazon Resource Name (ARN) of the image recipe associated with this image pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageRecipeArn(final java.lang.String imageRecipeArn) {
            this.props.imageRecipeArn(imageRecipeArn);
            return this;
        }

        /**
         * The configuration of the image tests that run after image creation to ensure the quality of the image that was created.
         * <p>
         * @return {@code this}
         * @param imageTestsConfiguration The configuration of the image tests that run after image creation to ensure the quality of the image that was created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTestsConfiguration(final software.amazon.awscdk.services.imagebuilder.CfnImagePipeline.ImageTestsConfigurationProperty imageTestsConfiguration) {
            this.props.imageTestsConfiguration(imageTestsConfiguration);
            return this;
        }
        /**
         * The configuration of the image tests that run after image creation to ensure the quality of the image that was created.
         * <p>
         * @return {@code this}
         * @param imageTestsConfiguration The configuration of the image tests that run after image creation to ensure the quality of the image that was created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTestsConfiguration(final software.amazon.awscdk.IResolvable imageTestsConfiguration) {
            this.props.imageTestsConfiguration(imageTestsConfiguration);
            return this;
        }

        /**
         * The schedule of the image pipeline.
         * <p>
         * A schedule configures how often and when a pipeline automatically creates a new image.
         * <p>
         * @return {@code this}
         * @param schedule The schedule of the image pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.imagebuilder.CfnImagePipeline.ScheduleProperty schedule) {
            this.props.schedule(schedule);
            return this;
        }
        /**
         * The schedule of the image pipeline.
         * <p>
         * A schedule configures how often and when a pipeline automatically creates a new image.
         * <p>
         * @return {@code this}
         * @param schedule The schedule of the image pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.IResolvable schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * The status of the image pipeline.
         * <p>
         * @return {@code this}
         * @param status The status of the image pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(final java.lang.String status) {
            this.props.status(status);
            return this;
        }

        /**
         * The tags of this image pipeline.
         * <p>
         * @return {@code this}
         * @param tags The tags of this image pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.imagebuilder.CfnImagePipeline}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.imagebuilder.CfnImagePipeline build() {
            return new software.amazon.awscdk.services.imagebuilder.CfnImagePipeline(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
