package software.amazon.awscdk.services.iam;

/**
 * Properties for defining an IAM access key.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Creates a new IAM user, access and secret keys, and stores the secret access key in a Secret.
 * User user = new User(this, "User");
 * AccessKey accessKey = AccessKey.Builder.create(this, "AccessKey").user(user).build();
 * Secret secret = Secret.Builder.create(this, "Secret")
 *         .secretStringValue(accessKey.getSecretAccessKey())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:12.271Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.AccessKeyProps")
@software.amazon.jsii.Jsii.Proxy(AccessKeyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AccessKeyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IAM user this key will belong to.
     * <p>
     * Changing this value will result in the access key being deleted and a new
     * access key (with a different ID and secret value) being assigned to the new
     * user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IUser getUser();

    /**
     * A CloudFormation-specific value that signifies the access key should be replaced/rotated.
     * <p>
     * This value can only be incremented. Incrementing this
     * value will cause CloudFormation to replace the Access Key resource.
     * <p>
     * Default: - No serial value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSerial() {
        return null;
    }

    /**
     * The status of the access key.
     * <p>
     * An Active access key is allowed to be used
     * to make API calls; An Inactive key cannot.
     * <p>
     * Default: - The access key is active
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.AccessKeyStatus getStatus() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AccessKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AccessKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AccessKeyProps> {
        software.amazon.awscdk.services.iam.IUser user;
        java.lang.Number serial;
        software.amazon.awscdk.services.iam.AccessKeyStatus status;

        /**
         * Sets the value of {@link AccessKeyProps#getUser}
         * @param user The IAM user this key will belong to. This parameter is required.
         *             Changing this value will result in the access key being deleted and a new
         *             access key (with a different ID and secret value) being assigned to the new
         *             user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(software.amazon.awscdk.services.iam.IUser user) {
            this.user = user;
            return this;
        }

        /**
         * Sets the value of {@link AccessKeyProps#getSerial}
         * @param serial A CloudFormation-specific value that signifies the access key should be replaced/rotated.
         *               This value can only be incremented. Incrementing this
         *               value will cause CloudFormation to replace the Access Key resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serial(java.lang.Number serial) {
            this.serial = serial;
            return this;
        }

        /**
         * Sets the value of {@link AccessKeyProps#getStatus}
         * @param status The status of the access key.
         *               An Active access key is allowed to be used
         *               to make API calls; An Inactive key cannot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(software.amazon.awscdk.services.iam.AccessKeyStatus status) {
            this.status = status;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AccessKeyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AccessKeyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AccessKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessKeyProps {
        private final software.amazon.awscdk.services.iam.IUser user;
        private final java.lang.Number serial;
        private final software.amazon.awscdk.services.iam.AccessKeyStatus status;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IUser.class));
            this.serial = software.amazon.jsii.Kernel.get(this, "serial", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AccessKeyStatus.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.user = java.util.Objects.requireNonNull(builder.user, "user is required");
            this.serial = builder.serial;
            this.status = builder.status;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IUser getUser() {
            return this.user;
        }

        @Override
        public final java.lang.Number getSerial() {
            return this.serial;
        }

        @Override
        public final software.amazon.awscdk.services.iam.AccessKeyStatus getStatus() {
            return this.status;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("user", om.valueToTree(this.getUser()));
            if (this.getSerial() != null) {
                data.set("serial", om.valueToTree(this.getSerial()));
            }
            if (this.getStatus() != null) {
                data.set("status", om.valueToTree(this.getStatus()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iam.AccessKeyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AccessKeyProps.Jsii$Proxy that = (AccessKeyProps.Jsii$Proxy) o;

            if (!user.equals(that.user)) return false;
            if (this.serial != null ? !this.serial.equals(that.serial) : that.serial != null) return false;
            return this.status != null ? this.status.equals(that.status) : that.status == null;
        }

        @Override
        public final int hashCode() {
            int result = this.user.hashCode();
            result = 31 * result + (this.serial != null ? this.serial.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            return result;
        }
    }
}
