package software.amazon.awscdk.services.fsx;

/**
 * The permitted Lustre data compression algorithms.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Map&lt;String, LustreDataCompressionType&gt; lustreConfiguration = Map.of(
 *         // ...
 *         "dataCompressionType", LustreDataCompressionType.LZ4);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:12.002Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.LustreDataCompressionType")
public enum LustreDataCompressionType {
    /**
     * `NONE` - (Default) Data compression is turned off when the file system is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
    /**
     * `LZ4` - Data compression is turned on with the LZ4 algorithm.
     * <p>
     * Note: When you turn data compression on for an existing file system, only newly written files are compressed. Existing files are not compressed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LZ4,
}
