package software.amazon.awscdk.services.fsx;

/**
 * The configuration for the Amazon FSx for Lustre file system.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Vpc vpc;
 * s3.Bucket bucket;
 * Map&lt;String, Object&gt; lustreConfiguration = Map.of(
 *         "deploymentType", LustreDeploymentType.SCRATCH_2,
 *         "exportPath", bucket.s3UrlForObject(),
 *         "importPath", bucket.s3UrlForObject(),
 *         "autoImportPolicy", LustreAutoImportPolicy.NEW_CHANGED_DELETED);
 * LustreFileSystem fs = LustreFileSystem.Builder.create(this, "FsxLustreFileSystem")
 *         .vpc(vpc)
 *         .vpcSubnet(vpc.getPrivateSubnets()[0])
 *         .storageCapacityGiB(1200)
 *         .lustreConfiguration(lustreConfiguration)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:12.002Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.LustreConfiguration")
@software.amazon.jsii.Jsii.Proxy(LustreConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LustreConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of backing file system deployment used by FSx.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fsx.LustreDeploymentType getDeploymentType();

    /**
     * Available with `Scratch` and `Persistent_1` deployment types.
     * <p>
     * When you create your file system, your existing S3 objects appear as file and directory listings. Use this property to choose how Amazon FSx keeps your file and directory listings up to date as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates from your S3 bucket</a> .
     * <p>
     * <blockquote>
     * <p>
     * This parameter is not supported for Lustre file systems using the <code>Persistent_2</code> deployment type.
     * <p>
     * </blockquote>
     * <p>
     * Default: - no import policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fsx.LustreAutoImportPolicy getAutoImportPolicy() {
        return null;
    }

    /**
     * Sets the data compression configuration for the file system.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a> in the <em>Amazon FSx for Lustre User Guide</em> .
     * <p>
     * Default: - no compression
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fsx.LustreDataCompressionType getDataCompressionType() {
        return null;
    }

    /**
     * The path in Amazon S3 where the root of your Amazon FSx file system is exported.
     * <p>
     * The path must use the same
     * Amazon S3 bucket as specified in ImportPath. If you only specify a bucket name, such as s3://import-bucket, you
     * get a 1:1 mapping of file system objects to S3 bucket objects. This mapping means that the input data in S3 is
     * overwritten on export. If you provide a custom prefix in the export path, such as
     * s3://import-bucket/[custom-optional-prefix], Amazon FSx exports the contents of your file system to that export
     * prefix in the Amazon S3 bucket.
     * <p>
     * Default: s3://import-bucket/FSxLustre[creation-timestamp]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExportPath() {
        return null;
    }

    /**
     * For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk.
     * <p>
     * Allowed values are between 1 and 512,000.
     * <p>
     * Default: 1024
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getImportedFileChunkSizeMiB() {
        return null;
    }

    /**
     * The path to the Amazon S3 bucket (including the optional prefix) that you're using as the data repository for your Amazon FSx for Lustre file system.
     * <p>
     * Must be of the format "s3://{bucketName}/optional-prefix" and cannot
     * exceed 900 characters.
     * <p>
     * Default: - no bucket is imported
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImportPath() {
        return null;
    }

    /**
     * Required for the PERSISTENT_1 deployment type, describes the amount of read and write throughput for each 1 tebibyte of storage, in MB/s/TiB.
     * <p>
     * Valid values are 50, 100, 200.
     * <p>
     * Default: - no default, conditionally required for PERSISTENT_1 deployment type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPerUnitStorageThroughput() {
        return null;
    }

    /**
     * The preferred day and time to perform weekly maintenance.
     * <p>
     * The first digit is the day of the week, starting at 1
     * for Monday, then the following are hours and minutes in the UTC time zone, 24 hour clock. For example: '2:20:30'
     * is Tuesdays at 20:30.
     * <p>
     * Default: - no preference
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fsx.LustreMaintenanceTime getWeeklyMaintenanceStartTime() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LustreConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LustreConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LustreConfiguration> {
        software.amazon.awscdk.services.fsx.LustreDeploymentType deploymentType;
        software.amazon.awscdk.services.fsx.LustreAutoImportPolicy autoImportPolicy;
        software.amazon.awscdk.services.fsx.LustreDataCompressionType dataCompressionType;
        java.lang.String exportPath;
        java.lang.Number importedFileChunkSizeMiB;
        java.lang.String importPath;
        java.lang.Number perUnitStorageThroughput;
        software.amazon.awscdk.services.fsx.LustreMaintenanceTime weeklyMaintenanceStartTime;

        /**
         * Sets the value of {@link LustreConfiguration#getDeploymentType}
         * @param deploymentType The type of backing file system deployment used by FSx. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentType(software.amazon.awscdk.services.fsx.LustreDeploymentType deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        /**
         * Sets the value of {@link LustreConfiguration#getAutoImportPolicy}
         * @param autoImportPolicy Available with `Scratch` and `Persistent_1` deployment types.
         *                         When you create your file system, your existing S3 objects appear as file and directory listings. Use this property to choose how Amazon FSx keeps your file and directory listings up to date as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:
         *                         <p>
         *                         For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html">Automatically import updates from your S3 bucket</a> .
         *                         <p>
         *                         <blockquote>
         *                         <p>
         *                         This parameter is not supported for Lustre file systems using the <code>Persistent_2</code> deployment type.
         *                         <p>
         *                         </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoImportPolicy(software.amazon.awscdk.services.fsx.LustreAutoImportPolicy autoImportPolicy) {
            this.autoImportPolicy = autoImportPolicy;
            return this;
        }

        /**
         * Sets the value of {@link LustreConfiguration#getDataCompressionType}
         * @param dataCompressionType Sets the data compression configuration for the file system.
         *                            For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a> in the <em>Amazon FSx for Lustre User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCompressionType(software.amazon.awscdk.services.fsx.LustreDataCompressionType dataCompressionType) {
            this.dataCompressionType = dataCompressionType;
            return this;
        }

        /**
         * Sets the value of {@link LustreConfiguration#getExportPath}
         * @param exportPath The path in Amazon S3 where the root of your Amazon FSx file system is exported.
         *                   The path must use the same
         *                   Amazon S3 bucket as specified in ImportPath. If you only specify a bucket name, such as s3://import-bucket, you
         *                   get a 1:1 mapping of file system objects to S3 bucket objects. This mapping means that the input data in S3 is
         *                   overwritten on export. If you provide a custom prefix in the export path, such as
         *                   s3://import-bucket/[custom-optional-prefix], Amazon FSx exports the contents of your file system to that export
         *                   prefix in the Amazon S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportPath(java.lang.String exportPath) {
            this.exportPath = exportPath;
            return this;
        }

        /**
         * Sets the value of {@link LustreConfiguration#getImportedFileChunkSizeMiB}
         * @param importedFileChunkSizeMiB For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk.
         *                                 Allowed values are between 1 and 512,000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder importedFileChunkSizeMiB(java.lang.Number importedFileChunkSizeMiB) {
            this.importedFileChunkSizeMiB = importedFileChunkSizeMiB;
            return this;
        }

        /**
         * Sets the value of {@link LustreConfiguration#getImportPath}
         * @param importPath The path to the Amazon S3 bucket (including the optional prefix) that you're using as the data repository for your Amazon FSx for Lustre file system.
         *                   Must be of the format "s3://{bucketName}/optional-prefix" and cannot
         *                   exceed 900 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder importPath(java.lang.String importPath) {
            this.importPath = importPath;
            return this;
        }

        /**
         * Sets the value of {@link LustreConfiguration#getPerUnitStorageThroughput}
         * @param perUnitStorageThroughput Required for the PERSISTENT_1 deployment type, describes the amount of read and write throughput for each 1 tebibyte of storage, in MB/s/TiB.
         *                                 Valid values are 50, 100, 200.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder perUnitStorageThroughput(java.lang.Number perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
            return this;
        }

        /**
         * Sets the value of {@link LustreConfiguration#getWeeklyMaintenanceStartTime}
         * @param weeklyMaintenanceStartTime The preferred day and time to perform weekly maintenance.
         *                                   The first digit is the day of the week, starting at 1
         *                                   for Monday, then the following are hours and minutes in the UTC time zone, 24 hour clock. For example: '2:20:30'
         *                                   is Tuesdays at 20:30.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder weeklyMaintenanceStartTime(software.amazon.awscdk.services.fsx.LustreMaintenanceTime weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LustreConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LustreConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LustreConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LustreConfiguration {
        private final software.amazon.awscdk.services.fsx.LustreDeploymentType deploymentType;
        private final software.amazon.awscdk.services.fsx.LustreAutoImportPolicy autoImportPolicy;
        private final software.amazon.awscdk.services.fsx.LustreDataCompressionType dataCompressionType;
        private final java.lang.String exportPath;
        private final java.lang.Number importedFileChunkSizeMiB;
        private final java.lang.String importPath;
        private final java.lang.Number perUnitStorageThroughput;
        private final software.amazon.awscdk.services.fsx.LustreMaintenanceTime weeklyMaintenanceStartTime;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deploymentType = software.amazon.jsii.Kernel.get(this, "deploymentType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.fsx.LustreDeploymentType.class));
            this.autoImportPolicy = software.amazon.jsii.Kernel.get(this, "autoImportPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.fsx.LustreAutoImportPolicy.class));
            this.dataCompressionType = software.amazon.jsii.Kernel.get(this, "dataCompressionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.fsx.LustreDataCompressionType.class));
            this.exportPath = software.amazon.jsii.Kernel.get(this, "exportPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.importedFileChunkSizeMiB = software.amazon.jsii.Kernel.get(this, "importedFileChunkSizeMiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.importPath = software.amazon.jsii.Kernel.get(this, "importPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.perUnitStorageThroughput = software.amazon.jsii.Kernel.get(this, "perUnitStorageThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.weeklyMaintenanceStartTime = software.amazon.jsii.Kernel.get(this, "weeklyMaintenanceStartTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.fsx.LustreMaintenanceTime.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deploymentType = java.util.Objects.requireNonNull(builder.deploymentType, "deploymentType is required");
            this.autoImportPolicy = builder.autoImportPolicy;
            this.dataCompressionType = builder.dataCompressionType;
            this.exportPath = builder.exportPath;
            this.importedFileChunkSizeMiB = builder.importedFileChunkSizeMiB;
            this.importPath = builder.importPath;
            this.perUnitStorageThroughput = builder.perUnitStorageThroughput;
            this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        }

        @Override
        public final software.amazon.awscdk.services.fsx.LustreDeploymentType getDeploymentType() {
            return this.deploymentType;
        }

        @Override
        public final software.amazon.awscdk.services.fsx.LustreAutoImportPolicy getAutoImportPolicy() {
            return this.autoImportPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.fsx.LustreDataCompressionType getDataCompressionType() {
            return this.dataCompressionType;
        }

        @Override
        public final java.lang.String getExportPath() {
            return this.exportPath;
        }

        @Override
        public final java.lang.Number getImportedFileChunkSizeMiB() {
            return this.importedFileChunkSizeMiB;
        }

        @Override
        public final java.lang.String getImportPath() {
            return this.importPath;
        }

        @Override
        public final java.lang.Number getPerUnitStorageThroughput() {
            return this.perUnitStorageThroughput;
        }

        @Override
        public final software.amazon.awscdk.services.fsx.LustreMaintenanceTime getWeeklyMaintenanceStartTime() {
            return this.weeklyMaintenanceStartTime;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deploymentType", om.valueToTree(this.getDeploymentType()));
            if (this.getAutoImportPolicy() != null) {
                data.set("autoImportPolicy", om.valueToTree(this.getAutoImportPolicy()));
            }
            if (this.getDataCompressionType() != null) {
                data.set("dataCompressionType", om.valueToTree(this.getDataCompressionType()));
            }
            if (this.getExportPath() != null) {
                data.set("exportPath", om.valueToTree(this.getExportPath()));
            }
            if (this.getImportedFileChunkSizeMiB() != null) {
                data.set("importedFileChunkSizeMiB", om.valueToTree(this.getImportedFileChunkSizeMiB()));
            }
            if (this.getImportPath() != null) {
                data.set("importPath", om.valueToTree(this.getImportPath()));
            }
            if (this.getPerUnitStorageThroughput() != null) {
                data.set("perUnitStorageThroughput", om.valueToTree(this.getPerUnitStorageThroughput()));
            }
            if (this.getWeeklyMaintenanceStartTime() != null) {
                data.set("weeklyMaintenanceStartTime", om.valueToTree(this.getWeeklyMaintenanceStartTime()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.LustreConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LustreConfiguration.Jsii$Proxy that = (LustreConfiguration.Jsii$Proxy) o;

            if (!deploymentType.equals(that.deploymentType)) return false;
            if (this.autoImportPolicy != null ? !this.autoImportPolicy.equals(that.autoImportPolicy) : that.autoImportPolicy != null) return false;
            if (this.dataCompressionType != null ? !this.dataCompressionType.equals(that.dataCompressionType) : that.dataCompressionType != null) return false;
            if (this.exportPath != null ? !this.exportPath.equals(that.exportPath) : that.exportPath != null) return false;
            if (this.importedFileChunkSizeMiB != null ? !this.importedFileChunkSizeMiB.equals(that.importedFileChunkSizeMiB) : that.importedFileChunkSizeMiB != null) return false;
            if (this.importPath != null ? !this.importPath.equals(that.importPath) : that.importPath != null) return false;
            if (this.perUnitStorageThroughput != null ? !this.perUnitStorageThroughput.equals(that.perUnitStorageThroughput) : that.perUnitStorageThroughput != null) return false;
            return this.weeklyMaintenanceStartTime != null ? this.weeklyMaintenanceStartTime.equals(that.weeklyMaintenanceStartTime) : that.weeklyMaintenanceStartTime == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deploymentType.hashCode();
            result = 31 * result + (this.autoImportPolicy != null ? this.autoImportPolicy.hashCode() : 0);
            result = 31 * result + (this.dataCompressionType != null ? this.dataCompressionType.hashCode() : 0);
            result = 31 * result + (this.exportPath != null ? this.exportPath.hashCode() : 0);
            result = 31 * result + (this.importedFileChunkSizeMiB != null ? this.importedFileChunkSizeMiB.hashCode() : 0);
            result = 31 * result + (this.importPath != null ? this.importPath.hashCode() : 0);
            result = 31 * result + (this.perUnitStorageThroughput != null ? this.perUnitStorageThroughput.hashCode() : 0);
            result = 31 * result + (this.weeklyMaintenanceStartTime != null ? this.weeklyMaintenanceStartTime.hashCode() : 0);
            return result;
        }
    }
}
