package software.amazon.awscdk.services.fsx;

/**
 * Properties for defining a `CfnDataRepositoryAssociation`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fsx.*;
 * CfnDataRepositoryAssociationProps cfnDataRepositoryAssociationProps = CfnDataRepositoryAssociationProps.builder()
 *         .dataRepositoryPath("dataRepositoryPath")
 *         .fileSystemId("fileSystemId")
 *         .fileSystemPath("fileSystemPath")
 *         // the properties below are optional
 *         .batchImportMetaDataOnCreate(false)
 *         .importedFileChunkSize(123)
 *         .s3(S3Property.builder()
 *                 .autoExportPolicy(AutoExportPolicyProperty.builder()
 *                         .events(List.of("events"))
 *                         .build())
 *                 .autoImportPolicy(AutoImportPolicyProperty.builder()
 *                         .events(List.of("events"))
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:11.966Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnDataRepositoryAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnDataRepositoryAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDataRepositoryAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::FSx::DataRepositoryAssociation.DataRepositoryPath`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataRepositoryPath();

    /**
     * `AWS::FSx::DataRepositoryAssociation.FileSystemId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId();

    /**
     * `AWS::FSx::DataRepositoryAssociation.FileSystemPath`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFileSystemPath();

    /**
     * `AWS::FSx::DataRepositoryAssociation.BatchImportMetaDataOnCreate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBatchImportMetaDataOnCreate() {
        return null;
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.ImportedFileChunkSize`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getImportedFileChunkSize() {
        return null;
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.S3`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
        return null;
    }

    /**
     * `AWS::FSx::DataRepositoryAssociation.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDataRepositoryAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDataRepositoryAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDataRepositoryAssociationProps> {
        java.lang.String dataRepositoryPath;
        java.lang.String fileSystemId;
        java.lang.String fileSystemPath;
        java.lang.Object batchImportMetaDataOnCreate;
        java.lang.Number importedFileChunkSize;
        java.lang.Object s3;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDataRepositoryAssociationProps#getDataRepositoryPath}
         * @param dataRepositoryPath `AWS::FSx::DataRepositoryAssociation.DataRepositoryPath`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataRepositoryPath(java.lang.String dataRepositoryPath) {
            this.dataRepositoryPath = dataRepositoryPath;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataRepositoryAssociationProps#getFileSystemId}
         * @param fileSystemId `AWS::FSx::DataRepositoryAssociation.FileSystemId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemId(java.lang.String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataRepositoryAssociationProps#getFileSystemPath}
         * @param fileSystemPath `AWS::FSx::DataRepositoryAssociation.FileSystemPath`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemPath(java.lang.String fileSystemPath) {
            this.fileSystemPath = fileSystemPath;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataRepositoryAssociationProps#getBatchImportMetaDataOnCreate}
         * @param batchImportMetaDataOnCreate `AWS::FSx::DataRepositoryAssociation.BatchImportMetaDataOnCreate`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchImportMetaDataOnCreate(java.lang.Boolean batchImportMetaDataOnCreate) {
            this.batchImportMetaDataOnCreate = batchImportMetaDataOnCreate;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataRepositoryAssociationProps#getBatchImportMetaDataOnCreate}
         * @param batchImportMetaDataOnCreate `AWS::FSx::DataRepositoryAssociation.BatchImportMetaDataOnCreate`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchImportMetaDataOnCreate(software.amazon.awscdk.IResolvable batchImportMetaDataOnCreate) {
            this.batchImportMetaDataOnCreate = batchImportMetaDataOnCreate;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataRepositoryAssociationProps#getImportedFileChunkSize}
         * @param importedFileChunkSize `AWS::FSx::DataRepositoryAssociation.ImportedFileChunkSize`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder importedFileChunkSize(java.lang.Number importedFileChunkSize) {
            this.importedFileChunkSize = importedFileChunkSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataRepositoryAssociationProps#getS3}
         * @param s3 `AWS::FSx::DataRepositoryAssociation.S3`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3(software.amazon.awscdk.services.fsx.CfnDataRepositoryAssociation.S3Property s3) {
            this.s3 = s3;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataRepositoryAssociationProps#getS3}
         * @param s3 `AWS::FSx::DataRepositoryAssociation.S3`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3(software.amazon.awscdk.IResolvable s3) {
            this.s3 = s3;
            return this;
        }

        /**
         * Sets the value of {@link CfnDataRepositoryAssociationProps#getTags}
         * @param tags `AWS::FSx::DataRepositoryAssociation.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDataRepositoryAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDataRepositoryAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDataRepositoryAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDataRepositoryAssociationProps {
        private final java.lang.String dataRepositoryPath;
        private final java.lang.String fileSystemId;
        private final java.lang.String fileSystemPath;
        private final java.lang.Object batchImportMetaDataOnCreate;
        private final java.lang.Number importedFileChunkSize;
        private final java.lang.Object s3;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataRepositoryPath = software.amazon.jsii.Kernel.get(this, "dataRepositoryPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileSystemId = software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileSystemPath = software.amazon.jsii.Kernel.get(this, "fileSystemPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.batchImportMetaDataOnCreate = software.amazon.jsii.Kernel.get(this, "batchImportMetaDataOnCreate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.importedFileChunkSize = software.amazon.jsii.Kernel.get(this, "importedFileChunkSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataRepositoryPath = java.util.Objects.requireNonNull(builder.dataRepositoryPath, "dataRepositoryPath is required");
            this.fileSystemId = java.util.Objects.requireNonNull(builder.fileSystemId, "fileSystemId is required");
            this.fileSystemPath = java.util.Objects.requireNonNull(builder.fileSystemPath, "fileSystemPath is required");
            this.batchImportMetaDataOnCreate = builder.batchImportMetaDataOnCreate;
            this.importedFileChunkSize = builder.importedFileChunkSize;
            this.s3 = builder.s3;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDataRepositoryPath() {
            return this.dataRepositoryPath;
        }

        @Override
        public final java.lang.String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final java.lang.String getFileSystemPath() {
            return this.fileSystemPath;
        }

        @Override
        public final java.lang.Object getBatchImportMetaDataOnCreate() {
            return this.batchImportMetaDataOnCreate;
        }

        @Override
        public final java.lang.Number getImportedFileChunkSize() {
            return this.importedFileChunkSize;
        }

        @Override
        public final java.lang.Object getS3() {
            return this.s3;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataRepositoryPath", om.valueToTree(this.getDataRepositoryPath()));
            data.set("fileSystemId", om.valueToTree(this.getFileSystemId()));
            data.set("fileSystemPath", om.valueToTree(this.getFileSystemPath()));
            if (this.getBatchImportMetaDataOnCreate() != null) {
                data.set("batchImportMetaDataOnCreate", om.valueToTree(this.getBatchImportMetaDataOnCreate()));
            }
            if (this.getImportedFileChunkSize() != null) {
                data.set("importedFileChunkSize", om.valueToTree(this.getImportedFileChunkSize()));
            }
            if (this.getS3() != null) {
                data.set("s3", om.valueToTree(this.getS3()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnDataRepositoryAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDataRepositoryAssociationProps.Jsii$Proxy that = (CfnDataRepositoryAssociationProps.Jsii$Proxy) o;

            if (!dataRepositoryPath.equals(that.dataRepositoryPath)) return false;
            if (!fileSystemId.equals(that.fileSystemId)) return false;
            if (!fileSystemPath.equals(that.fileSystemPath)) return false;
            if (this.batchImportMetaDataOnCreate != null ? !this.batchImportMetaDataOnCreate.equals(that.batchImportMetaDataOnCreate) : that.batchImportMetaDataOnCreate != null) return false;
            if (this.importedFileChunkSize != null ? !this.importedFileChunkSize.equals(that.importedFileChunkSize) : that.importedFileChunkSize != null) return false;
            if (this.s3 != null ? !this.s3.equals(that.s3) : that.s3 != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataRepositoryPath.hashCode();
            result = 31 * result + (this.fileSystemId.hashCode());
            result = 31 * result + (this.fileSystemPath.hashCode());
            result = 31 * result + (this.batchImportMetaDataOnCreate != null ? this.batchImportMetaDataOnCreate.hashCode() : 0);
            result = 31 * result + (this.importedFileChunkSize != null ? this.importedFileChunkSize.hashCode() : 0);
            result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
