package software.amazon.awscdk.services.eventschemas;

/**
 * Properties for defining a `CfnDiscoverer`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eventschemas.*;
 * CfnDiscovererProps cfnDiscovererProps = CfnDiscovererProps.builder()
 *         .sourceArn("sourceArn")
 *         // the properties below are optional
 *         .crossAccount(false)
 *         .description("description")
 *         .tags(List.of(TagsEntryProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:11.881Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eventschemas.CfnDiscovererProps")
@software.amazon.jsii.Jsii.Proxy(CfnDiscovererProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDiscovererProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the event bus.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceArn();

    /**
     * Allows for the discovery of the event schemas that are sent to the event bus from another account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCrossAccount() {
        return null;
    }

    /**
     * A description for the discoverer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Tags associated with the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.eventschemas.CfnDiscoverer.TagsEntryProperty> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDiscovererProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDiscovererProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDiscovererProps> {
        java.lang.String sourceArn;
        java.lang.Object crossAccount;
        java.lang.String description;
        java.util.List<software.amazon.awscdk.services.eventschemas.CfnDiscoverer.TagsEntryProperty> tags;

        /**
         * Sets the value of {@link CfnDiscovererProps#getSourceArn}
         * @param sourceArn The ARN of the event bus. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceArn(java.lang.String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDiscovererProps#getCrossAccount}
         * @param crossAccount Allows for the discovery of the event schemas that are sent to the event bus from another account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossAccount(java.lang.Boolean crossAccount) {
            this.crossAccount = crossAccount;
            return this;
        }

        /**
         * Sets the value of {@link CfnDiscovererProps#getCrossAccount}
         * @param crossAccount Allows for the discovery of the event schemas that are sent to the event bus from another account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossAccount(software.amazon.awscdk.IResolvable crossAccount) {
            this.crossAccount = crossAccount;
            return this;
        }

        /**
         * Sets the value of {@link CfnDiscovererProps#getDescription}
         * @param description A description for the discoverer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnDiscovererProps#getTags}
         * @param tags Tags associated with the resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.services.eventschemas.CfnDiscoverer.TagsEntryProperty> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.services.eventschemas.CfnDiscoverer.TagsEntryProperty>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDiscovererProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDiscovererProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDiscovererProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDiscovererProps {
        private final java.lang.String sourceArn;
        private final java.lang.Object crossAccount;
        private final java.lang.String description;
        private final java.util.List<software.amazon.awscdk.services.eventschemas.CfnDiscoverer.TagsEntryProperty> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sourceArn = software.amazon.jsii.Kernel.get(this, "sourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.crossAccount = software.amazon.jsii.Kernel.get(this, "crossAccount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eventschemas.CfnDiscoverer.TagsEntryProperty.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sourceArn = java.util.Objects.requireNonNull(builder.sourceArn, "sourceArn is required");
            this.crossAccount = builder.crossAccount;
            this.description = builder.description;
            this.tags = (java.util.List<software.amazon.awscdk.services.eventschemas.CfnDiscoverer.TagsEntryProperty>)builder.tags;
        }

        @Override
        public final java.lang.String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final java.lang.Object getCrossAccount() {
            return this.crossAccount;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.eventschemas.CfnDiscoverer.TagsEntryProperty> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sourceArn", om.valueToTree(this.getSourceArn()));
            if (this.getCrossAccount() != null) {
                data.set("crossAccount", om.valueToTree(this.getCrossAccount()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eventschemas.CfnDiscovererProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDiscovererProps.Jsii$Proxy that = (CfnDiscovererProps.Jsii$Proxy) o;

            if (!sourceArn.equals(that.sourceArn)) return false;
            if (this.crossAccount != null ? !this.crossAccount.equals(that.crossAccount) : that.crossAccount != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.sourceArn.hashCode();
            result = 31 * result + (this.crossAccount != null ? this.crossAccount.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
