package software.amazon.awscdk.services.events.targets;

/**
 * Use an AWS Lambda function that makes API calls as an event rule target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.events.targets.*;
 * import software.amazon.awscdk.services.iam.*;
 * Object parameters;
 * PolicyStatement policyStatement;
 * AwsApi awsApi = AwsApi.Builder.create()
 *         .action("action")
 *         .service("service")
 *         // the properties below are optional
 *         .apiVersion("apiVersion")
 *         .catchErrorPattern("catchErrorPattern")
 *         .parameters(parameters)
 *         .policyStatement(policyStatement)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:11.853Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.AwsApi")
public class AwsApi extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected AwsApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AwsApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AwsApi(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.targets.AwsApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns a RuleTarget that can be used to trigger this AwsApi as a result from an EventBridge event.
     * <p>
     * @param rule This parameter is required.
     * @param id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule, final @org.jetbrains.annotations.Nullable java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required"), id });
    }

    /**
     * Returns a RuleTarget that can be used to trigger this AwsApi as a result from an EventBridge event.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.targets.AwsApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.targets.AwsApi> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.events.targets.AwsApiProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.events.targets.AwsApiProps.Builder();
        }

        /**
         * The service action to call.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html">https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html</a>
         * @param action The service action to call. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(final java.lang.String action) {
            this.props.action(action);
            return this;
        }

        /**
         * The service to call.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html">https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html</a>
         * @param service The service to call. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(final java.lang.String service) {
            this.props.service(service);
            return this;
        }

        /**
         * API version to use for the service.
         * <p>
         * Default: - use latest available API version
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/locking-api-versions.html">https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/locking-api-versions.html</a>
         * @param apiVersion API version to use for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiVersion(final java.lang.String apiVersion) {
            this.props.apiVersion(apiVersion);
            return this;
        }

        /**
         * The regex pattern to use to catch API errors.
         * <p>
         * The <code>code</code> property of the
         * <code>Error</code> object will be tested against this pattern. If there is a match an
         * error will not be thrown.
         * <p>
         * Default: - do not catch errors
         * <p>
         * @return {@code this}
         * @param catchErrorPattern The regex pattern to use to catch API errors. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder catchErrorPattern(final java.lang.String catchErrorPattern) {
            this.props.catchErrorPattern(catchErrorPattern);
            return this;
        }

        /**
         * The parameters for the service action.
         * <p>
         * Default: - no parameters
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html">https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html</a>
         * @param parameters The parameters for the service action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.lang.Object parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * The IAM policy statement to allow the API call.
         * <p>
         * Use only if
         * resource restriction is needed.
         * <p>
         * Default: - extract the permission from the API call
         * <p>
         * @return {@code this}
         * @param policyStatement The IAM policy statement to allow the API call. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyStatement(final software.amazon.awscdk.services.iam.PolicyStatement policyStatement) {
            this.props.policyStatement(policyStatement);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.events.targets.AwsApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.events.targets.AwsApi build() {
            return new software.amazon.awscdk.services.events.targets.AwsApi(
                this.props.build()
            );
        }
    }
}
