package software.amazon.awscdk.services.efs;

/**
 * Properties of EFS FileSystem.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * FileSystem fileSystem = FileSystem.Builder.create(this, "MyEfsFileSystem")
 *         .vpc(new Vpc(this, "VPC"))
 *         .lifecyclePolicy(LifecyclePolicy.AFTER_14_DAYS) // files are not transitioned to infrequent access (IA) storage by default
 *         .performanceMode(PerformanceMode.GENERAL_PURPOSE) // default
 *         .outOfInfrequentAccessPolicy(OutOfInfrequentAccessPolicy.AFTER_1_ACCESS)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:11.381Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.FileSystemProps")
@software.amazon.jsii.Jsii.Proxy(FileSystemProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FileSystemProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * VPC to launch the file system in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * Whether to enable automatic backups for the file system.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableAutomaticBackups() {
        return null;
    }

    /**
     * Defines if the data at rest in the file system is encrypted or not.
     * <p>
     * Default: - If your application has the '
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEncrypted() {
        return null;
    }

    /**
     * The file system's name.
     * <p>
     * Default: - CDK generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileSystemName() {
        return null;
    }

    /**
     * The KMS key used for encryption.
     * <p>
     * This is required to encrypt the data at rest if &#64;encrypted is set to true.
     * <p>
     * Default: - if 'encrypted' is true, the default key for EFS (/aws/elasticfilesystem) is used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKmsKey() {
        return null;
    }

    /**
     * A policy used by EFS lifecycle management to transition files to the Infrequent Access (IA) storage class.
     * <p>
     * Default: - None. EFS will not transition files to the IA storage class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.LifecyclePolicy getLifecyclePolicy() {
        return null;
    }

    /**
     * A policy used by EFS lifecycle management to transition files from Infrequent Access (IA) storage class to primary storage class.
     * <p>
     * Default: - None. EFS will not transition files from IA storage to primary storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy getOutOfInfrequentAccessPolicy() {
        return null;
    }

    /**
     * The performance mode that the file system will operate under.
     * <p>
     * An Amazon EFS file system's performance mode can't be changed after the file system has been created.
     * Updating this property will replace the file system.
     * <p>
     * Default: PerformanceMode.GENERAL_PURPOSE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.PerformanceMode getPerformanceMode() {
        return null;
    }

    /**
     * Provisioned throughput for the file system.
     * <p>
     * This is a required property if the throughput mode is set to PROVISIONED.
     * Must be at least 1MiB/s.
     * <p>
     * Default: - none, errors out
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getProvisionedThroughputPerSecond() {
        return null;
    }

    /**
     * The removal policy to apply to the file system.
     * <p>
     * Default: RemovalPolicy.RETAIN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * Security Group to assign to this file system.
     * <p>
     * Default: - creates new security group which allows all outbound traffic
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * Enum to mention the throughput mode of the file system.
     * <p>
     * Default: ThroughputMode.BURSTING
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.ThroughputMode getThroughputMode() {
        return null;
    }

    /**
     * Which subnets to place the mount target in the VPC.
     * <p>
     * Default: - the Vpc default strategy if not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FileSystemProps> {
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.lang.Boolean enableAutomaticBackups;
        java.lang.Boolean encrypted;
        java.lang.String fileSystemName;
        software.amazon.awscdk.services.kms.IKey kmsKey;
        software.amazon.awscdk.services.efs.LifecyclePolicy lifecyclePolicy;
        software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy outOfInfrequentAccessPolicy;
        software.amazon.awscdk.services.efs.PerformanceMode performanceMode;
        software.amazon.awscdk.Size provisionedThroughputPerSecond;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        software.amazon.awscdk.services.efs.ThroughputMode throughputMode;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link FileSystemProps#getVpc}
         * @param vpc VPC to launch the file system in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getEnableAutomaticBackups}
         * @param enableAutomaticBackups Whether to enable automatic backups for the file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAutomaticBackups(java.lang.Boolean enableAutomaticBackups) {
            this.enableAutomaticBackups = enableAutomaticBackups;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getEncrypted}
         * @param encrypted Defines if the data at rest in the file system is encrypted or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(java.lang.Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getFileSystemName}
         * @param fileSystemName The file system's name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemName(java.lang.String fileSystemName) {
            this.fileSystemName = fileSystemName;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getKmsKey}
         * @param kmsKey The KMS key used for encryption.
         *               This is required to encrypt the data at rest if &#64;encrypted is set to true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getLifecyclePolicy}
         * @param lifecyclePolicy A policy used by EFS lifecycle management to transition files to the Infrequent Access (IA) storage class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecyclePolicy(software.amazon.awscdk.services.efs.LifecyclePolicy lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getOutOfInfrequentAccessPolicy}
         * @param outOfInfrequentAccessPolicy A policy used by EFS lifecycle management to transition files from Infrequent Access (IA) storage class to primary storage class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outOfInfrequentAccessPolicy(software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy outOfInfrequentAccessPolicy) {
            this.outOfInfrequentAccessPolicy = outOfInfrequentAccessPolicy;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getPerformanceMode}
         * @param performanceMode The performance mode that the file system will operate under.
         *                        An Amazon EFS file system's performance mode can't be changed after the file system has been created.
         *                        Updating this property will replace the file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceMode(software.amazon.awscdk.services.efs.PerformanceMode performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getProvisionedThroughputPerSecond}
         * @param provisionedThroughputPerSecond Provisioned throughput for the file system.
         *                                       This is a required property if the throughput mode is set to PROVISIONED.
         *                                       Must be at least 1MiB/s.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedThroughputPerSecond(software.amazon.awscdk.Size provisionedThroughputPerSecond) {
            this.provisionedThroughputPerSecond = provisionedThroughputPerSecond;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getRemovalPolicy}
         * @param removalPolicy The removal policy to apply to the file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getSecurityGroup}
         * @param securityGroup Security Group to assign to this file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getThroughputMode}
         * @param throughputMode Enum to mention the throughput mode of the file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throughputMode(software.amazon.awscdk.services.efs.ThroughputMode throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        /**
         * Sets the value of {@link FileSystemProps#getVpcSubnets}
         * @param vpcSubnets Which subnets to place the mount target in the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileSystemProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FileSystemProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileSystemProps {
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.Boolean enableAutomaticBackups;
        private final java.lang.Boolean encrypted;
        private final java.lang.String fileSystemName;
        private final software.amazon.awscdk.services.kms.IKey kmsKey;
        private final software.amazon.awscdk.services.efs.LifecyclePolicy lifecyclePolicy;
        private final software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy outOfInfrequentAccessPolicy;
        private final software.amazon.awscdk.services.efs.PerformanceMode performanceMode;
        private final software.amazon.awscdk.Size provisionedThroughputPerSecond;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final software.amazon.awscdk.services.efs.ThroughputMode throughputMode;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.enableAutomaticBackups = software.amazon.jsii.Kernel.get(this, "enableAutomaticBackups", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.fileSystemName = software.amazon.jsii.Kernel.get(this, "fileSystemName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.lifecyclePolicy = software.amazon.jsii.Kernel.get(this, "lifecyclePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.LifecyclePolicy.class));
            this.outOfInfrequentAccessPolicy = software.amazon.jsii.Kernel.get(this, "outOfInfrequentAccessPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy.class));
            this.performanceMode = software.amazon.jsii.Kernel.get(this, "performanceMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.PerformanceMode.class));
            this.provisionedThroughputPerSecond = software.amazon.jsii.Kernel.get(this, "provisionedThroughputPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.throughputMode = software.amazon.jsii.Kernel.get(this, "throughputMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.ThroughputMode.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.enableAutomaticBackups = builder.enableAutomaticBackups;
            this.encrypted = builder.encrypted;
            this.fileSystemName = builder.fileSystemName;
            this.kmsKey = builder.kmsKey;
            this.lifecyclePolicy = builder.lifecyclePolicy;
            this.outOfInfrequentAccessPolicy = builder.outOfInfrequentAccessPolicy;
            this.performanceMode = builder.performanceMode;
            this.provisionedThroughputPerSecond = builder.provisionedThroughputPerSecond;
            this.removalPolicy = builder.removalPolicy;
            this.securityGroup = builder.securityGroup;
            this.throughputMode = builder.throughputMode;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.lang.Boolean getEnableAutomaticBackups() {
            return this.enableAutomaticBackups;
        }

        @Override
        public final java.lang.Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final java.lang.String getFileSystemName() {
            return this.fileSystemName;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final software.amazon.awscdk.services.efs.LifecyclePolicy getLifecyclePolicy() {
            return this.lifecyclePolicy;
        }

        @Override
        public final software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy getOutOfInfrequentAccessPolicy() {
            return this.outOfInfrequentAccessPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.efs.PerformanceMode getPerformanceMode() {
            return this.performanceMode;
        }

        @Override
        public final software.amazon.awscdk.Size getProvisionedThroughputPerSecond() {
            return this.provisionedThroughputPerSecond;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final software.amazon.awscdk.services.efs.ThroughputMode getThroughputMode() {
            return this.throughputMode;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getEnableAutomaticBackups() != null) {
                data.set("enableAutomaticBackups", om.valueToTree(this.getEnableAutomaticBackups()));
            }
            if (this.getEncrypted() != null) {
                data.set("encrypted", om.valueToTree(this.getEncrypted()));
            }
            if (this.getFileSystemName() != null) {
                data.set("fileSystemName", om.valueToTree(this.getFileSystemName()));
            }
            if (this.getKmsKey() != null) {
                data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            }
            if (this.getLifecyclePolicy() != null) {
                data.set("lifecyclePolicy", om.valueToTree(this.getLifecyclePolicy()));
            }
            if (this.getOutOfInfrequentAccessPolicy() != null) {
                data.set("outOfInfrequentAccessPolicy", om.valueToTree(this.getOutOfInfrequentAccessPolicy()));
            }
            if (this.getPerformanceMode() != null) {
                data.set("performanceMode", om.valueToTree(this.getPerformanceMode()));
            }
            if (this.getProvisionedThroughputPerSecond() != null) {
                data.set("provisionedThroughputPerSecond", om.valueToTree(this.getProvisionedThroughputPerSecond()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getThroughputMode() != null) {
                data.set("throughputMode", om.valueToTree(this.getThroughputMode()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.FileSystemProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileSystemProps.Jsii$Proxy that = (FileSystemProps.Jsii$Proxy) o;

            if (!vpc.equals(that.vpc)) return false;
            if (this.enableAutomaticBackups != null ? !this.enableAutomaticBackups.equals(that.enableAutomaticBackups) : that.enableAutomaticBackups != null) return false;
            if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
            if (this.fileSystemName != null ? !this.fileSystemName.equals(that.fileSystemName) : that.fileSystemName != null) return false;
            if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
            if (this.lifecyclePolicy != null ? !this.lifecyclePolicy.equals(that.lifecyclePolicy) : that.lifecyclePolicy != null) return false;
            if (this.outOfInfrequentAccessPolicy != null ? !this.outOfInfrequentAccessPolicy.equals(that.outOfInfrequentAccessPolicy) : that.outOfInfrequentAccessPolicy != null) return false;
            if (this.performanceMode != null ? !this.performanceMode.equals(that.performanceMode) : that.performanceMode != null) return false;
            if (this.provisionedThroughputPerSecond != null ? !this.provisionedThroughputPerSecond.equals(that.provisionedThroughputPerSecond) : that.provisionedThroughputPerSecond != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.throughputMode != null ? !this.throughputMode.equals(that.throughputMode) : that.throughputMode != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.vpc.hashCode();
            result = 31 * result + (this.enableAutomaticBackups != null ? this.enableAutomaticBackups.hashCode() : 0);
            result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
            result = 31 * result + (this.fileSystemName != null ? this.fileSystemName.hashCode() : 0);
            result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
            result = 31 * result + (this.lifecyclePolicy != null ? this.lifecyclePolicy.hashCode() : 0);
            result = 31 * result + (this.outOfInfrequentAccessPolicy != null ? this.outOfInfrequentAccessPolicy.hashCode() : 0);
            result = 31 * result + (this.performanceMode != null ? this.performanceMode.hashCode() : 0);
            result = 31 * result + (this.provisionedThroughputPerSecond != null ? this.provisionedThroughputPerSecond.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.throughputMode != null ? this.throughputMode.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
