package software.amazon.awscdk.services.ecs.patterns;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * ApplicationLoadBalancedFargateService loadBalancedFargateService = ApplicationLoadBalancedFargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(1024)
 *         .desiredCount(1)
 *         .cpu(512)
 *         .taskImageOptions(ApplicationLoadBalancedTaskImageOptions.builder()
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .build())
 *         .taskSubnets(SubnetSelection.builder()
 *                 .subnets(List.of(Subnet.fromSubnetId(this, "subnet", "VpcISOLATEDSubnet1Subnet80F07FA0")))
 *                 .build())
 *         .loadBalancerName("application-lb-name")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:11.306Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.ApplicationLoadBalancedTaskImageOptions")
@software.amazon.jsii.Jsii.Proxy(ApplicationLoadBalancedTaskImageOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationLoadBalancedTaskImageOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The image used to start a container.
     * <p>
     * Image or taskDefinition must be specified, not both.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImage getImage();

    /**
     * The command that's passed to the container.
     * <p>
     * If there are multiple arguments, make sure that each argument is a separated string in the array.
     * <p>
     * This parameter maps to <code>Cmd</code> in the <a href="https://docs.docker.com/engine/api/v1.38/#operation/ContainerCreate">Create a container</a> section
     * of the <a href="https://docs.docker.com/engine/api/v1.38/">Docker Remote API</a> and the <code>COMMAND</code> parameter to
     * <a href="https://docs.docker.com/engine/reference/commandline/run/">docker run</a>.
     * <p>
     * For more information about the Docker <code>CMD</code> parameter, see https://docs.docker.com/engine/reference/builder/#cmd.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return null;
    }

    /**
     * The container name value to be specified in the task definition.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContainerName() {
        return null;
    }

    /**
     * The port number on the container that is bound to the user-specified or automatically assigned host port.
     * <p>
     * If you are using containers in a task with the awsvpc or host network mode, exposed ports should be specified using containerPort.
     * If you are using containers in a task with the bridge network mode and you specify a container port and not a host port,
     * your container automatically receives a host port in the ephemeral port range.
     * <p>
     * Port mappings that are automatically assigned in this way do not count toward the 100 reserved ports limit of a container instance.
     * <p>
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PortMapping.html#ECS-Type-PortMapping-hostPort">hostPort</a>.
     * <p>
     * Default: 80
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getContainerPort() {
        return null;
    }

    /**
     * A key/value map of labels to add to the container.
     * <p>
     * Default: - No labels.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getDockerLabels() {
        return null;
    }

    /**
     * Flag to indicate whether to enable logging.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableLogging() {
        return null;
    }

    /**
     * The entry point that's passed to the container.
     * <p>
     * This parameter maps to <code>Entrypoint</code> in the <a href="https://docs.docker.com/engine/api/v1.38/#operation/ContainerCreate">Create a container</a> section
     * of the <a href="https://docs.docker.com/engine/api/v1.38/">Docker Remote API</a> and the <code>--entrypoint</code> option to
     * <a href="https://docs.docker.com/engine/reference/commandline/run/">docker run</a>.
     * <p>
     * For more information about the Docker <code>ENTRYPOINT</code> parameter, see https://docs.docker.com/engine/reference/builder/#entrypoint.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEntryPoint() {
        return null;
    }

    /**
     * The environment variables to pass to the container.
     * <p>
     * Default: - No environment variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * The name of the task execution IAM role that grants the Amazon ECS container agent permission to call AWS APIs on your behalf.
     * <p>
     * Default: - No value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getExecutionRole() {
        return null;
    }

    /**
     * The name of a family that this task definition is registered to.
     * <p>
     * A family groups multiple versions of a task definition.
     * <p>
     * Default: - Automatically generated name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFamily() {
        return null;
    }

    /**
     * The log driver to use.
     * <p>
     * Default: - AwsLogDriver if enableLogging is true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.LogDriver getLogDriver() {
        return null;
    }

    /**
     * The secret to expose to the container as an environment variable.
     * <p>
     * Default: - No secret environment variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> getSecrets() {
        return null;
    }

    /**
     * The name of the task IAM role that grants containers in the task permission to call AWS APIs on your behalf.
     * <p>
     * Default: - A task role is automatically created for you.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getTaskRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplicationLoadBalancedTaskImageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationLoadBalancedTaskImageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationLoadBalancedTaskImageOptions> {
        software.amazon.awscdk.services.ecs.ContainerImage image;
        java.util.List<java.lang.String> command;
        java.lang.String containerName;
        java.lang.Number containerPort;
        java.util.Map<java.lang.String, java.lang.String> dockerLabels;
        java.lang.Boolean enableLogging;
        java.util.List<java.lang.String> entryPoint;
        java.util.Map<java.lang.String, java.lang.String> environment;
        software.amazon.awscdk.services.iam.IRole executionRole;
        java.lang.String family;
        software.amazon.awscdk.services.ecs.LogDriver logDriver;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets;
        software.amazon.awscdk.services.iam.IRole taskRole;

        /**
         * Sets the value of {@link ApplicationLoadBalancedTaskImageOptions#getImage}
         * @param image The image used to start a container. This parameter is required.
         *              Image or taskDefinition must be specified, not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedTaskImageOptions#getCommand}
         * @param command The command that's passed to the container.
         *                If there are multiple arguments, make sure that each argument is a separated string in the array.
         *                <p>
         *                This parameter maps to <code>Cmd</code> in the <a href="https://docs.docker.com/engine/api/v1.38/#operation/ContainerCreate">Create a container</a> section
         *                of the <a href="https://docs.docker.com/engine/api/v1.38/">Docker Remote API</a> and the <code>COMMAND</code> parameter to
         *                <a href="https://docs.docker.com/engine/reference/commandline/run/">docker run</a>.
         *                <p>
         *                For more information about the Docker <code>CMD</code> parameter, see https://docs.docker.com/engine/reference/builder/#cmd.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedTaskImageOptions#getContainerName}
         * @param containerName The container name value to be specified in the task definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerName(java.lang.String containerName) {
            this.containerName = containerName;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedTaskImageOptions#getContainerPort}
         * @param containerPort The port number on the container that is bound to the user-specified or automatically assigned host port.
         *                      If you are using containers in a task with the awsvpc or host network mode, exposed ports should be specified using containerPort.
         *                      If you are using containers in a task with the bridge network mode and you specify a container port and not a host port,
         *                      your container automatically receives a host port in the ephemeral port range.
         *                      <p>
         *                      Port mappings that are automatically assigned in this way do not count toward the 100 reserved ports limit of a container instance.
         *                      <p>
         *                      For more information, see
         *                      <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PortMapping.html#ECS-Type-PortMapping-hostPort">hostPort</a>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerPort(java.lang.Number containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedTaskImageOptions#getDockerLabels}
         * @param dockerLabels A key/value map of labels to add to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerLabels(java.util.Map<java.lang.String, java.lang.String> dockerLabels) {
            this.dockerLabels = dockerLabels;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedTaskImageOptions#getEnableLogging}
         * @param enableLogging Flag to indicate whether to enable logging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLogging(java.lang.Boolean enableLogging) {
            this.enableLogging = enableLogging;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedTaskImageOptions#getEntryPoint}
         * @param entryPoint The entry point that's passed to the container.
         *                   This parameter maps to <code>Entrypoint</code> in the <a href="https://docs.docker.com/engine/api/v1.38/#operation/ContainerCreate">Create a container</a> section
         *                   of the <a href="https://docs.docker.com/engine/api/v1.38/">Docker Remote API</a> and the <code>--entrypoint</code> option to
         *                   <a href="https://docs.docker.com/engine/reference/commandline/run/">docker run</a>.
         *                   <p>
         *                   For more information about the Docker <code>ENTRYPOINT</code> parameter, see https://docs.docker.com/engine/reference/builder/#entrypoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entryPoint(java.util.List<java.lang.String> entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedTaskImageOptions#getEnvironment}
         * @param environment The environment variables to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedTaskImageOptions#getExecutionRole}
         * @param executionRole The name of the task execution IAM role that grants the Amazon ECS container agent permission to call AWS APIs on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(software.amazon.awscdk.services.iam.IRole executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedTaskImageOptions#getFamily}
         * @param family The name of a family that this task definition is registered to.
         *               A family groups multiple versions of a task definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(java.lang.String family) {
            this.family = family;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedTaskImageOptions#getLogDriver}
         * @param logDriver The log driver to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDriver(software.amazon.awscdk.services.ecs.LogDriver logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedTaskImageOptions#getSecrets}
         * @param secrets The secret to expose to the container as an environment variable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder secrets(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ecs.Secret> secrets) {
            this.secrets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret>)secrets;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancedTaskImageOptions#getTaskRole}
         * @param taskRole The name of the task IAM role that grants containers in the task permission to call AWS APIs on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskRole(software.amazon.awscdk.services.iam.IRole taskRole) {
            this.taskRole = taskRole;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationLoadBalancedTaskImageOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplicationLoadBalancedTaskImageOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplicationLoadBalancedTaskImageOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationLoadBalancedTaskImageOptions {
        private final software.amazon.awscdk.services.ecs.ContainerImage image;
        private final java.util.List<java.lang.String> command;
        private final java.lang.String containerName;
        private final java.lang.Number containerPort;
        private final java.util.Map<java.lang.String, java.lang.String> dockerLabels;
        private final java.lang.Boolean enableLogging;
        private final java.util.List<java.lang.String> entryPoint;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final software.amazon.awscdk.services.iam.IRole executionRole;
        private final java.lang.String family;
        private final software.amazon.awscdk.services.ecs.LogDriver logDriver;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets;
        private final software.amazon.awscdk.services.iam.IRole taskRole;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class));
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.containerPort = software.amazon.jsii.Kernel.get(this, "containerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.dockerLabels = software.amazon.jsii.Kernel.get(this, "dockerLabels", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.enableLogging = software.amazon.jsii.Kernel.get(this, "enableLogging", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.entryPoint = software.amazon.jsii.Kernel.get(this, "entryPoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.family = software.amazon.jsii.Kernel.get(this, "family", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logDriver = software.amazon.jsii.Kernel.get(this, "logDriver", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class));
            this.secrets = software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Secret.class)));
            this.taskRole = software.amazon.jsii.Kernel.get(this, "taskRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
            this.command = builder.command;
            this.containerName = builder.containerName;
            this.containerPort = builder.containerPort;
            this.dockerLabels = builder.dockerLabels;
            this.enableLogging = builder.enableLogging;
            this.entryPoint = builder.entryPoint;
            this.environment = builder.environment;
            this.executionRole = builder.executionRole;
            this.family = builder.family;
            this.logDriver = builder.logDriver;
            this.secrets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret>)builder.secrets;
            this.taskRole = builder.taskRole;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return this.image;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final java.lang.String getContainerName() {
            return this.containerName;
        }

        @Override
        public final java.lang.Number getContainerPort() {
            return this.containerPort;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getDockerLabels() {
            return this.dockerLabels;
        }

        @Override
        public final java.lang.Boolean getEnableLogging() {
            return this.enableLogging;
        }

        @Override
        public final java.util.List<java.lang.String> getEntryPoint() {
            return this.entryPoint;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public final java.lang.String getFamily() {
            return this.family;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.LogDriver getLogDriver() {
            return this.logDriver;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> getSecrets() {
            return this.secrets;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getTaskRole() {
            return this.taskRole;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("image", om.valueToTree(this.getImage()));
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getContainerName() != null) {
                data.set("containerName", om.valueToTree(this.getContainerName()));
            }
            if (this.getContainerPort() != null) {
                data.set("containerPort", om.valueToTree(this.getContainerPort()));
            }
            if (this.getDockerLabels() != null) {
                data.set("dockerLabels", om.valueToTree(this.getDockerLabels()));
            }
            if (this.getEnableLogging() != null) {
                data.set("enableLogging", om.valueToTree(this.getEnableLogging()));
            }
            if (this.getEntryPoint() != null) {
                data.set("entryPoint", om.valueToTree(this.getEntryPoint()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getExecutionRole() != null) {
                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
            }
            if (this.getFamily() != null) {
                data.set("family", om.valueToTree(this.getFamily()));
            }
            if (this.getLogDriver() != null) {
                data.set("logDriver", om.valueToTree(this.getLogDriver()));
            }
            if (this.getSecrets() != null) {
                data.set("secrets", om.valueToTree(this.getSecrets()));
            }
            if (this.getTaskRole() != null) {
                data.set("taskRole", om.valueToTree(this.getTaskRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs_patterns.ApplicationLoadBalancedTaskImageOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationLoadBalancedTaskImageOptions.Jsii$Proxy that = (ApplicationLoadBalancedTaskImageOptions.Jsii$Proxy) o;

            if (!image.equals(that.image)) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.containerName != null ? !this.containerName.equals(that.containerName) : that.containerName != null) return false;
            if (this.containerPort != null ? !this.containerPort.equals(that.containerPort) : that.containerPort != null) return false;
            if (this.dockerLabels != null ? !this.dockerLabels.equals(that.dockerLabels) : that.dockerLabels != null) return false;
            if (this.enableLogging != null ? !this.enableLogging.equals(that.enableLogging) : that.enableLogging != null) return false;
            if (this.entryPoint != null ? !this.entryPoint.equals(that.entryPoint) : that.entryPoint != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.executionRole != null ? !this.executionRole.equals(that.executionRole) : that.executionRole != null) return false;
            if (this.family != null ? !this.family.equals(that.family) : that.family != null) return false;
            if (this.logDriver != null ? !this.logDriver.equals(that.logDriver) : that.logDriver != null) return false;
            if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) return false;
            return this.taskRole != null ? this.taskRole.equals(that.taskRole) : that.taskRole == null;
        }

        @Override
        public final int hashCode() {
            int result = this.image.hashCode();
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.containerName != null ? this.containerName.hashCode() : 0);
            result = 31 * result + (this.containerPort != null ? this.containerPort.hashCode() : 0);
            result = 31 * result + (this.dockerLabels != null ? this.dockerLabels.hashCode() : 0);
            result = 31 * result + (this.enableLogging != null ? this.enableLogging.hashCode() : 0);
            result = 31 * result + (this.entryPoint != null ? this.entryPoint.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.executionRole != null ? this.executionRole.hashCode() : 0);
            result = 31 * result + (this.family != null ? this.family.hashCode() : 0);
            result = 31 * result + (this.logDriver != null ? this.logDriver.hashCode() : 0);
            result = 31 * result + (this.secrets != null ? this.secrets.hashCode() : 0);
            result = 31 * result + (this.taskRole != null ? this.taskRole.hashCode() : 0);
            return result;
        }
    }
}
