package software.amazon.awscdk.services.ecs;

/**
 * The options for firelens log router https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html#firelens-taskdef-customconfig.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * FirelensOptions firelensOptions = FirelensOptions.builder()
 *         .configFileType(FirelensConfigFileType.S3)
 *         .configFileValue("configFileValue")
 *         .enableECSLogMetadata(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:11.235Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.FirelensOptions")
@software.amazon.jsii.Jsii.Proxy(FirelensOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FirelensOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Custom configuration file, s3 or file.
     * <p>
     * Both configFileType and configFileValue must be used together
     * to define a custom configuration source.
     * <p>
     * Default: - determined by checking configFileValue with S3 ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FirelensConfigFileType getConfigFileType() {
        return null;
    }

    /**
     * Custom configuration file, S3 ARN or a file path Both configFileType and configFileValue must be used together to define a custom configuration source.
     * <p>
     * Default: - no config file value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConfigFileValue() {
        return null;
    }

    /**
     * By default, Amazon ECS adds additional fields in your log entries that help identify the source of the logs.
     * <p>
     * You can disable this action by setting enable-ecs-log-metadata to false.
     * <p>
     * Default: - true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableECSLogMetadata() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FirelensOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FirelensOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FirelensOptions> {
        software.amazon.awscdk.services.ecs.FirelensConfigFileType configFileType;
        java.lang.String configFileValue;
        java.lang.Boolean enableEcsLogMetadata;

        /**
         * Sets the value of {@link FirelensOptions#getConfigFileType}
         * @param configFileType Custom configuration file, s3 or file.
         *                       Both configFileType and configFileValue must be used together
         *                       to define a custom configuration source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configFileType(software.amazon.awscdk.services.ecs.FirelensConfigFileType configFileType) {
            this.configFileType = configFileType;
            return this;
        }

        /**
         * Sets the value of {@link FirelensOptions#getConfigFileValue}
         * @param configFileValue Custom configuration file, S3 ARN or a file path Both configFileType and configFileValue must be used together to define a custom configuration source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configFileValue(java.lang.String configFileValue) {
            this.configFileValue = configFileValue;
            return this;
        }

        /**
         * Sets the value of {@link FirelensOptions#getEnableEcsLogMetadata}
         * @param enableEcsLogMetadata By default, Amazon ECS adds additional fields in your log entries that help identify the source of the logs.
         *                             You can disable this action by setting enable-ecs-log-metadata to false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsLogMetadata(java.lang.Boolean enableEcsLogMetadata) {
            this.enableEcsLogMetadata = enableEcsLogMetadata;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FirelensOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FirelensOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FirelensOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirelensOptions {
        private final software.amazon.awscdk.services.ecs.FirelensConfigFileType configFileType;
        private final java.lang.String configFileValue;
        private final java.lang.Boolean enableEcsLogMetadata;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configFileType = software.amazon.jsii.Kernel.get(this, "configFileType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FirelensConfigFileType.class));
            this.configFileValue = software.amazon.jsii.Kernel.get(this, "configFileValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableEcsLogMetadata = software.amazon.jsii.Kernel.get(this, "enableECSLogMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configFileType = builder.configFileType;
            this.configFileValue = builder.configFileValue;
            this.enableEcsLogMetadata = builder.enableEcsLogMetadata;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.FirelensConfigFileType getConfigFileType() {
            return this.configFileType;
        }

        @Override
        public final java.lang.String getConfigFileValue() {
            return this.configFileValue;
        }

        @Override
        public final java.lang.Boolean getEnableECSLogMetadata() {
            return this.enableEcsLogMetadata;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getConfigFileType() != null) {
                data.set("configFileType", om.valueToTree(this.getConfigFileType()));
            }
            if (this.getConfigFileValue() != null) {
                data.set("configFileValue", om.valueToTree(this.getConfigFileValue()));
            }
            if (this.getEnableECSLogMetadata() != null) {
                data.set("enableECSLogMetadata", om.valueToTree(this.getEnableECSLogMetadata()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.FirelensOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FirelensOptions.Jsii$Proxy that = (FirelensOptions.Jsii$Proxy) o;

            if (this.configFileType != null ? !this.configFileType.equals(that.configFileType) : that.configFileType != null) return false;
            if (this.configFileValue != null ? !this.configFileValue.equals(that.configFileValue) : that.configFileValue != null) return false;
            return this.enableEcsLogMetadata != null ? this.enableEcsLogMetadata.equals(that.enableEcsLogMetadata) : that.enableEcsLogMetadata == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configFileType != null ? this.configFileType.hashCode() : 0;
            result = 31 * result + (this.configFileValue != null ? this.configFileValue.hashCode() : 0);
            result = 31 * result + (this.enableEcsLogMetadata != null ? this.enableEcsLogMetadata.hashCode() : 0);
            return result;
        }
    }
}
