package software.amazon.awscdk.services.ecs;

/**
 * The properties for the base Ec2Service or FargateService service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.servicediscovery.*;
 * Cluster cluster;
 * ContainerDefinition containerDefinition;
 * INamespace namespace;
 * BaseServiceOptions baseServiceOptions = BaseServiceOptions.builder()
 *         .cluster(cluster)
 *         // the properties below are optional
 *         .capacityProviderStrategies(List.of(CapacityProviderStrategy.builder()
 *                 .capacityProvider("capacityProvider")
 *                 // the properties below are optional
 *                 .base(123)
 *                 .weight(123)
 *                 .build()))
 *         .circuitBreaker(DeploymentCircuitBreaker.builder()
 *                 .rollback(false)
 *                 .build())
 *         .cloudMapOptions(CloudMapOptions.builder()
 *                 .cloudMapNamespace(namespace)
 *                 .container(containerDefinition)
 *                 .containerPort(123)
 *                 .dnsRecordType(DnsRecordType.A)
 *                 .dnsTtl(Duration.minutes(30))
 *                 .failureThreshold(123)
 *                 .name("name")
 *                 .build())
 *         .deploymentController(DeploymentController.builder()
 *                 .type(DeploymentControllerType.ECS)
 *                 .build())
 *         .desiredCount(123)
 *         .enableECSManagedTags(false)
 *         .enableExecuteCommand(false)
 *         .healthCheckGracePeriod(Duration.minutes(30))
 *         .maxHealthyPercent(123)
 *         .minHealthyPercent(123)
 *         .propagateTags(PropagatedTagSource.SERVICE)
 *         .serviceName("serviceName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:11.106Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.BaseServiceOptions")
@software.amazon.jsii.Jsii.Proxy(BaseServiceOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseServiceOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the cluster that hosts the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ICluster getCluster();

    /**
     * A list of Capacity Provider strategies used to place a service.
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> getCapacityProviderStrategies() {
        return null;
    }

    /**
     * Whether to enable the deployment circuit breaker.
     * <p>
     * If this property is defined, circuit breaker will be implicitly
     * enabled.
     * <p>
     * Default: - disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker getCircuitBreaker() {
        return null;
    }

    /**
     * The options for configuring an Amazon ECS service to use service discovery.
     * <p>
     * Default: - AWS Cloud Map service discovery is not enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CloudMapOptions getCloudMapOptions() {
        return null;
    }

    /**
     * Specifies which deployment controller to use for the service.
     * <p>
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a>
     * <p>
     * Default: - Rolling update (ECS)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.DeploymentController getDeploymentController() {
        return null;
    }

    /**
     * The desired number of instantiations of the task definition to keep running on the service.
     * <p>
     * Default: - When creating the service, default is 1; when updating the service, default uses
     * the current task number.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDesiredCount() {
        return null;
    }

    /**
     * Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
     * <p>
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableECSManagedTags() {
        return null;
    }

    /**
     * Whether to enable the ability to execute into a container.
     * <p>
     * Default: - undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableExecuteCommand() {
        return null;
    }

    /**
     * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
     * <p>
     * Default: - defaults to 60 seconds if at least one load balancer is in-use and it is not already set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getHealthCheckGracePeriod() {
        return null;
    }

    /**
     * The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
     * <p>
     * Default: - 100 if daemon, otherwise 200
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxHealthyPercent() {
        return null;
    }

    /**
     * The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
     * <p>
     * Default: - 0 if daemon, otherwise 50
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinHealthyPercent() {
        return null;
    }

    /**
     * Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
     * <p>
     * Valid values are: PropagatedTagSource.SERVICE, PropagatedTagSource.TASK_DEFINITION or PropagatedTagSource.NONE
     * <p>
     * Default: PropagatedTagSource.NONE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
        return null;
    }

    /**
     * The name of the service.
     * <p>
     * Default: - CloudFormation-generated name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BaseServiceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BaseServiceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BaseServiceOptions> {
        software.amazon.awscdk.services.ecs.ICluster cluster;
        java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies;
        software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker;
        software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions;
        software.amazon.awscdk.services.ecs.DeploymentController deploymentController;
        java.lang.Number desiredCount;
        java.lang.Boolean enableEcsManagedTags;
        java.lang.Boolean enableExecuteCommand;
        software.amazon.awscdk.Duration healthCheckGracePeriod;
        java.lang.Number maxHealthyPercent;
        java.lang.Number minHealthyPercent;
        software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        java.lang.String serviceName;

        /**
         * Sets the value of {@link BaseServiceOptions#getCluster}
         * @param cluster The name of the cluster that hosts the service. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceOptions#getCapacityProviderStrategies}
         * @param capacityProviderStrategies A list of Capacity Provider strategies used to place a service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder capacityProviderStrategies(java.util.List<? extends software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies) {
            this.capacityProviderStrategies = (java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy>)capacityProviderStrategies;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceOptions#getCircuitBreaker}
         * @param circuitBreaker Whether to enable the deployment circuit breaker.
         *                       If this property is defined, circuit breaker will be implicitly
         *                       enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder circuitBreaker(software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker) {
            this.circuitBreaker = circuitBreaker;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceOptions#getCloudMapOptions}
         * @param cloudMapOptions The options for configuring an Amazon ECS service to use service discovery.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudMapOptions(software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions) {
            this.cloudMapOptions = cloudMapOptions;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceOptions#getDeploymentController}
         * @param deploymentController Specifies which deployment controller to use for the service.
         *                             For more information, see
         *                             <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentController(software.amazon.awscdk.services.ecs.DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceOptions#getDesiredCount}
         * @param desiredCount The desired number of instantiations of the task definition to keep running on the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCount(java.lang.Number desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceOptions#getEnableEcsManagedTags}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         *                             For more information, see
         *                             <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(java.lang.Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceOptions#getEnableExecuteCommand}
         * @param enableExecuteCommand Whether to enable the ability to execute into a container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExecuteCommand(java.lang.Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceOptions#getHealthCheckGracePeriod}
         * @param healthCheckGracePeriod The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckGracePeriod(software.amazon.awscdk.Duration healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceOptions#getMaxHealthyPercent}
         * @param maxHealthyPercent The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxHealthyPercent(java.lang.Number maxHealthyPercent) {
            this.maxHealthyPercent = maxHealthyPercent;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceOptions#getMinHealthyPercent}
         * @param minHealthyPercent The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minHealthyPercent(java.lang.Number minHealthyPercent) {
            this.minHealthyPercent = minHealthyPercent;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceOptions#getPropagateTags}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         *                      Valid values are: PropagatedTagSource.SERVICE, PropagatedTagSource.TASK_DEFINITION or PropagatedTagSource.NONE
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        /**
         * Sets the value of {@link BaseServiceOptions#getServiceName}
         * @param serviceName The name of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseServiceOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BaseServiceOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BaseServiceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseServiceOptions {
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies;
        private final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker;
        private final software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions;
        private final software.amazon.awscdk.services.ecs.DeploymentController deploymentController;
        private final java.lang.Number desiredCount;
        private final java.lang.Boolean enableEcsManagedTags;
        private final java.lang.Boolean enableExecuteCommand;
        private final software.amazon.awscdk.Duration healthCheckGracePeriod;
        private final java.lang.Number maxHealthyPercent;
        private final java.lang.Number minHealthyPercent;
        private final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private final java.lang.String serviceName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
            this.capacityProviderStrategies = software.amazon.jsii.Kernel.get(this, "capacityProviderStrategies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CapacityProviderStrategy.class)));
            this.circuitBreaker = software.amazon.jsii.Kernel.get(this, "circuitBreaker", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker.class));
            this.cloudMapOptions = software.amazon.jsii.Kernel.get(this, "cloudMapOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CloudMapOptions.class));
            this.deploymentController = software.amazon.jsii.Kernel.get(this, "deploymentController", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DeploymentController.class));
            this.desiredCount = software.amazon.jsii.Kernel.get(this, "desiredCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.enableEcsManagedTags = software.amazon.jsii.Kernel.get(this, "enableECSManagedTags", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableExecuteCommand = software.amazon.jsii.Kernel.get(this, "enableExecuteCommand", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.healthCheckGracePeriod = software.amazon.jsii.Kernel.get(this, "healthCheckGracePeriod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.maxHealthyPercent = software.amazon.jsii.Kernel.get(this, "maxHealthyPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minHealthyPercent = software.amazon.jsii.Kernel.get(this, "minHealthyPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.propagateTags = software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PropagatedTagSource.class));
            this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.capacityProviderStrategies = (java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy>)builder.capacityProviderStrategies;
            this.circuitBreaker = builder.circuitBreaker;
            this.cloudMapOptions = builder.cloudMapOptions;
            this.deploymentController = builder.deploymentController;
            this.desiredCount = builder.desiredCount;
            this.enableEcsManagedTags = builder.enableEcsManagedTags;
            this.enableExecuteCommand = builder.enableExecuteCommand;
            this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
            this.maxHealthyPercent = builder.maxHealthyPercent;
            this.minHealthyPercent = builder.minHealthyPercent;
            this.propagateTags = builder.propagateTags;
            this.serviceName = builder.serviceName;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.CapacityProviderStrategy> getCapacityProviderStrategies() {
            return this.capacityProviderStrategies;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker getCircuitBreaker() {
            return this.circuitBreaker;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.CloudMapOptions getCloudMapOptions() {
            return this.cloudMapOptions;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.DeploymentController getDeploymentController() {
            return this.deploymentController;
        }

        @Override
        public final java.lang.Number getDesiredCount() {
            return this.desiredCount;
        }

        @Override
        public final java.lang.Boolean getEnableECSManagedTags() {
            return this.enableEcsManagedTags;
        }

        @Override
        public final java.lang.Boolean getEnableExecuteCommand() {
            return this.enableExecuteCommand;
        }

        @Override
        public final software.amazon.awscdk.Duration getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        @Override
        public final java.lang.Number getMaxHealthyPercent() {
            return this.maxHealthyPercent;
        }

        @Override
        public final java.lang.Number getMinHealthyPercent() {
            return this.minHealthyPercent;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public final java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cluster", om.valueToTree(this.getCluster()));
            if (this.getCapacityProviderStrategies() != null) {
                data.set("capacityProviderStrategies", om.valueToTree(this.getCapacityProviderStrategies()));
            }
            if (this.getCircuitBreaker() != null) {
                data.set("circuitBreaker", om.valueToTree(this.getCircuitBreaker()));
            }
            if (this.getCloudMapOptions() != null) {
                data.set("cloudMapOptions", om.valueToTree(this.getCloudMapOptions()));
            }
            if (this.getDeploymentController() != null) {
                data.set("deploymentController", om.valueToTree(this.getDeploymentController()));
            }
            if (this.getDesiredCount() != null) {
                data.set("desiredCount", om.valueToTree(this.getDesiredCount()));
            }
            if (this.getEnableECSManagedTags() != null) {
                data.set("enableECSManagedTags", om.valueToTree(this.getEnableECSManagedTags()));
            }
            if (this.getEnableExecuteCommand() != null) {
                data.set("enableExecuteCommand", om.valueToTree(this.getEnableExecuteCommand()));
            }
            if (this.getHealthCheckGracePeriod() != null) {
                data.set("healthCheckGracePeriod", om.valueToTree(this.getHealthCheckGracePeriod()));
            }
            if (this.getMaxHealthyPercent() != null) {
                data.set("maxHealthyPercent", om.valueToTree(this.getMaxHealthyPercent()));
            }
            if (this.getMinHealthyPercent() != null) {
                data.set("minHealthyPercent", om.valueToTree(this.getMinHealthyPercent()));
            }
            if (this.getPropagateTags() != null) {
                data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
            }
            if (this.getServiceName() != null) {
                data.set("serviceName", om.valueToTree(this.getServiceName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.BaseServiceOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BaseServiceOptions.Jsii$Proxy that = (BaseServiceOptions.Jsii$Proxy) o;

            if (!cluster.equals(that.cluster)) return false;
            if (this.capacityProviderStrategies != null ? !this.capacityProviderStrategies.equals(that.capacityProviderStrategies) : that.capacityProviderStrategies != null) return false;
            if (this.circuitBreaker != null ? !this.circuitBreaker.equals(that.circuitBreaker) : that.circuitBreaker != null) return false;
            if (this.cloudMapOptions != null ? !this.cloudMapOptions.equals(that.cloudMapOptions) : that.cloudMapOptions != null) return false;
            if (this.deploymentController != null ? !this.deploymentController.equals(that.deploymentController) : that.deploymentController != null) return false;
            if (this.desiredCount != null ? !this.desiredCount.equals(that.desiredCount) : that.desiredCount != null) return false;
            if (this.enableEcsManagedTags != null ? !this.enableEcsManagedTags.equals(that.enableEcsManagedTags) : that.enableEcsManagedTags != null) return false;
            if (this.enableExecuteCommand != null ? !this.enableExecuteCommand.equals(that.enableExecuteCommand) : that.enableExecuteCommand != null) return false;
            if (this.healthCheckGracePeriod != null ? !this.healthCheckGracePeriod.equals(that.healthCheckGracePeriod) : that.healthCheckGracePeriod != null) return false;
            if (this.maxHealthyPercent != null ? !this.maxHealthyPercent.equals(that.maxHealthyPercent) : that.maxHealthyPercent != null) return false;
            if (this.minHealthyPercent != null ? !this.minHealthyPercent.equals(that.minHealthyPercent) : that.minHealthyPercent != null) return false;
            if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
            return this.serviceName != null ? this.serviceName.equals(that.serviceName) : that.serviceName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cluster.hashCode();
            result = 31 * result + (this.capacityProviderStrategies != null ? this.capacityProviderStrategies.hashCode() : 0);
            result = 31 * result + (this.circuitBreaker != null ? this.circuitBreaker.hashCode() : 0);
            result = 31 * result + (this.cloudMapOptions != null ? this.cloudMapOptions.hashCode() : 0);
            result = 31 * result + (this.deploymentController != null ? this.deploymentController.hashCode() : 0);
            result = 31 * result + (this.desiredCount != null ? this.desiredCount.hashCode() : 0);
            result = 31 * result + (this.enableEcsManagedTags != null ? this.enableEcsManagedTags.hashCode() : 0);
            result = 31 * result + (this.enableExecuteCommand != null ? this.enableExecuteCommand.hashCode() : 0);
            result = 31 * result + (this.healthCheckGracePeriod != null ? this.healthCheckGracePeriod.hashCode() : 0);
            result = 31 * result + (this.maxHealthyPercent != null ? this.maxHealthyPercent.hashCode() : 0);
            result = 31 * result + (this.minHealthyPercent != null ? this.minHealthyPercent.hashCode() : 0);
            result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            return result;
        }
    }
}
