package software.amazon.awscdk.services.ecs;

/**
 * An Auto Scaling Group Capacity Provider.
 * <p>
 * This allows an ECS cluster to target
 * a specific EC2 Auto Scaling Group for the placement of tasks. Optionally (and
 * recommended), ECS can manage the number of instances in the ASG to fit the
 * tasks, and can ensure that instances are not prematurely terminated while
 * there are still tasks running on them.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * LaunchTemplate launchTemplate = LaunchTemplate.Builder.create(this, "ASG-LaunchTemplate")
 *         .instanceType(new InstanceType("t3.medium"))
 *         .machineImage(EcsOptimizedImage.amazonLinux2())
 *         .userData(UserData.forLinux())
 *         .build();
 * AutoScalingGroup autoScalingGroup = AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .mixedInstancesPolicy(MixedInstancesPolicy.builder()
 *                 .instancesDistribution(InstancesDistribution.builder()
 *                         .onDemandPercentageAboveBaseCapacity(50)
 *                         .build())
 *                 .launchTemplate(launchTemplate)
 *                 .build())
 *         .build();
 * Cluster cluster = Cluster.Builder.create(this, "Cluster").vpc(vpc).build();
 * AsgCapacityProvider capacityProvider = AsgCapacityProvider.Builder.create(this, "AsgCapacityProvider")
 *         .autoScalingGroup(autoScalingGroup)
 *         .machineImageType(MachineImageType.AMAZON_LINUX_2)
 *         .build();
 * cluster.addAsgCapacityProvider(capacityProvider);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:11.098Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AsgCapacityProvider")
public class AsgCapacityProvider extends software.constructs.Construct {

    protected AsgCapacityProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AsgCapacityProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AsgCapacityProvider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AsgCapacityProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Auto Scaling Group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.AutoScalingGroup getAutoScalingGroup() {
        return software.amazon.jsii.Kernel.get(this, "autoScalingGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.AutoScalingGroup.class));
    }

    /**
     * Capacity provider name.
     * <p>
     * Default: Chosen by CloudFormation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCapacityProviderName() {
        return software.amazon.jsii.Kernel.get(this, "capacityProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Auto Scaling Group machineImageType.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.MachineImageType getMachineImageType() {
        return software.amazon.jsii.Kernel.get(this, "machineImageType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.MachineImageType.class));
    }

    /**
     * Specifies whether the containers can access the container instance role.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getCanContainersAccessInstanceRole() {
        return software.amazon.jsii.Kernel.get(this, "canContainersAccessInstanceRole", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Whether managed termination protection is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableManagedTerminationProtection() {
        return software.amazon.jsii.Kernel.get(this, "enableManagedTerminationProtection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.AsgCapacityProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.AsgCapacityProvider> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.AsgCapacityProviderProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.AsgCapacityProviderProps.Builder();
        }

        /**
         * Specifies whether the containers can access the container instance role.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param canContainersAccessInstanceRole Specifies whether the containers can access the container instance role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder canContainersAccessInstanceRole(final java.lang.Boolean canContainersAccessInstanceRole) {
            this.props.canContainersAccessInstanceRole(canContainersAccessInstanceRole);
            return this;
        }

        /**
         * What type of machine image this is.
         * <p>
         * Depending on the setting, different UserData will automatically be added
         * to the <code>AutoScalingGroup</code> to configure it properly for use with ECS.
         * <p>
         * If you create an <code>AutoScalingGroup</code> yourself and are adding it via
         * <code>addAutoScalingGroup()</code>, you must specify this value. If you are adding an
         * <code>autoScalingGroup</code> via <code>addCapacity</code>, this value will be determined
         * from the <code>machineImage</code> you pass.
         * <p>
         * Default: - Automatically determined from `machineImage`, if available, otherwise `MachineImageType.AMAZON_LINUX_2`.
         * <p>
         * @return {@code this}
         * @param machineImageType What type of machine image this is. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImageType(final software.amazon.awscdk.services.ecs.MachineImageType machineImageType) {
            this.props.machineImageType(machineImageType);
            return this;
        }

        /**
         * Specify whether to enable Automated Draining for Spot Instances running Amazon ECS Services.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-spot.html">Using Spot Instances</a>.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param spotInstanceDraining Specify whether to enable Automated Draining for Spot Instances running Amazon ECS Services. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotInstanceDraining(final java.lang.Boolean spotInstanceDraining) {
            this.props.spotInstanceDraining(spotInstanceDraining);
            return this;
        }

        /**
         * If {@link AddAutoScalingGroupCapacityOptions.taskDrainTime} is non-zero, then the ECS cluster creates an SNS Topic to as part of a system to drain instances of tasks when the instance is being shut down. If this property is provided, then this key will be used to encrypt the contents of that SNS Topic. See [SNS Data Encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-data-encryption.html) for more information.
         * <p>
         * Default: The SNS Topic will not be encrypted.
         * <p>
         * @return {@code this}
         * @param topicEncryptionKey If {@link AddAutoScalingGroupCapacityOptions.taskDrainTime} is non-zero, then the ECS cluster creates an SNS Topic to as part of a system to drain instances of tasks when the instance is being shut down. If this property is provided, then this key will be used to encrypt the contents of that SNS Topic. See [SNS Data Encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-data-encryption.html) for more information. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicEncryptionKey(final software.amazon.awscdk.services.kms.IKey topicEncryptionKey) {
            this.props.topicEncryptionKey(topicEncryptionKey);
            return this;
        }

        /**
         * The autoscaling group to add as a Capacity Provider.
         * <p>
         * @return {@code this}
         * @param autoScalingGroup The autoscaling group to add as a Capacity Provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroup(final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup) {
            this.props.autoScalingGroup(autoScalingGroup);
            return this;
        }

        /**
         * The name of the capacity provider.
         * <p>
         * If a name is specified,
         * it cannot start with <code>aws</code>, <code>ecs</code>, or <code>fargate</code>. If no name is specified,
         * a default name in the CFNStackName-CFNResourceName-RandomString format is used.
         * <p>
         * Default: CloudFormation-generated name
         * <p>
         * @return {@code this}
         * @param capacityProviderName The name of the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderName(final java.lang.String capacityProviderName) {
            this.props.capacityProviderName(capacityProviderName);
            return this;
        }

        /**
         * Whether to enable managed scaling.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enableManagedScaling Whether to enable managed scaling. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableManagedScaling(final java.lang.Boolean enableManagedScaling) {
            this.props.enableManagedScaling(enableManagedScaling);
            return this;
        }

        /**
         * Whether to enable managed termination protection.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enableManagedTerminationProtection Whether to enable managed termination protection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableManagedTerminationProtection(final java.lang.Boolean enableManagedTerminationProtection) {
            this.props.enableManagedTerminationProtection(enableManagedTerminationProtection);
            return this;
        }

        /**
         * Maximum scaling step size.
         * <p>
         * In most cases this should be left alone.
         * <p>
         * Default: 1000
         * <p>
         * @return {@code this}
         * @param maximumScalingStepSize Maximum scaling step size. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumScalingStepSize(final java.lang.Number maximumScalingStepSize) {
            this.props.maximumScalingStepSize(maximumScalingStepSize);
            return this;
        }

        /**
         * Minimum scaling step size.
         * <p>
         * In most cases this should be left alone.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param minimumScalingStepSize Minimum scaling step size. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minimumScalingStepSize(final java.lang.Number minimumScalingStepSize) {
            this.props.minimumScalingStepSize(minimumScalingStepSize);
            return this;
        }

        /**
         * Target capacity percent.
         * <p>
         * In most cases this should be left alone.
         * <p>
         * Default: 100
         * <p>
         * @return {@code this}
         * @param targetCapacityPercent Target capacity percent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetCapacityPercent(final java.lang.Number targetCapacityPercent) {
            this.props.targetCapacityPercent(targetCapacityPercent);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.AsgCapacityProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.AsgCapacityProvider build() {
            return new software.amazon.awscdk.services.ecs.AsgCapacityProvider(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
