package software.amazon.awscdk.services.ec2;

/**
 * Options for writing logs to a destination.
 * <p>
 * TODO: there are other destination options, currently they are
 * only for s3 destinations (not sure if that will change)
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * DestinationOptions destinationOptions = DestinationOptions.builder()
 *         .fileFormat(FlowLogFileFormat.PLAIN_TEXT)
 *         .hiveCompatiblePartitions(false)
 *         .perHourPartition(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:10.925Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.DestinationOptions")
@software.amazon.jsii.Jsii.Proxy(DestinationOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DestinationOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.S3DestinationOptions {

    /**
     * @return a {@link Builder} of {@link DestinationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DestinationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DestinationOptions> {
        software.amazon.awscdk.services.ec2.FlowLogFileFormat fileFormat;
        java.lang.Boolean hiveCompatiblePartitions;
        java.lang.Boolean perHourPartition;

        /**
         * Sets the value of {@link DestinationOptions#getFileFormat}
         * @param fileFormat The format for the flow log.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileFormat(software.amazon.awscdk.services.ec2.FlowLogFileFormat fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        /**
         * Sets the value of {@link DestinationOptions#getHiveCompatiblePartitions}
         * @param hiveCompatiblePartitions Use Hive-compatible prefixes for flow logs stored in Amazon S3.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hiveCompatiblePartitions(java.lang.Boolean hiveCompatiblePartitions) {
            this.hiveCompatiblePartitions = hiveCompatiblePartitions;
            return this;
        }

        /**
         * Sets the value of {@link DestinationOptions#getPerHourPartition}
         * @param perHourPartition Partition the flow log per hour.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder perHourPartition(java.lang.Boolean perHourPartition) {
            this.perHourPartition = perHourPartition;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DestinationOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DestinationOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DestinationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationOptions {
        private final software.amazon.awscdk.services.ec2.FlowLogFileFormat fileFormat;
        private final java.lang.Boolean hiveCompatiblePartitions;
        private final java.lang.Boolean perHourPartition;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fileFormat = software.amazon.jsii.Kernel.get(this, "fileFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.FlowLogFileFormat.class));
            this.hiveCompatiblePartitions = software.amazon.jsii.Kernel.get(this, "hiveCompatiblePartitions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.perHourPartition = software.amazon.jsii.Kernel.get(this, "perHourPartition", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fileFormat = builder.fileFormat;
            this.hiveCompatiblePartitions = builder.hiveCompatiblePartitions;
            this.perHourPartition = builder.perHourPartition;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.FlowLogFileFormat getFileFormat() {
            return this.fileFormat;
        }

        @Override
        public final java.lang.Boolean getHiveCompatiblePartitions() {
            return this.hiveCompatiblePartitions;
        }

        @Override
        public final java.lang.Boolean getPerHourPartition() {
            return this.perHourPartition;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getFileFormat() != null) {
                data.set("fileFormat", om.valueToTree(this.getFileFormat()));
            }
            if (this.getHiveCompatiblePartitions() != null) {
                data.set("hiveCompatiblePartitions", om.valueToTree(this.getHiveCompatiblePartitions()));
            }
            if (this.getPerHourPartition() != null) {
                data.set("perHourPartition", om.valueToTree(this.getPerHourPartition()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.DestinationOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DestinationOptions.Jsii$Proxy that = (DestinationOptions.Jsii$Proxy) o;

            if (this.fileFormat != null ? !this.fileFormat.equals(that.fileFormat) : that.fileFormat != null) return false;
            if (this.hiveCompatiblePartitions != null ? !this.hiveCompatiblePartitions.equals(that.hiveCompatiblePartitions) : that.hiveCompatiblePartitions != null) return false;
            return this.perHourPartition != null ? this.perHourPartition.equals(that.perHourPartition) : that.perHourPartition == null;
        }

        @Override
        public final int hashCode() {
            int result = this.fileFormat != null ? this.fileFormat.hashCode() : 0;
            result = 31 * result + (this.hiveCompatiblePartitions != null ? this.hiveCompatiblePartitions.hashCode() : 0);
            result = 31 * result + (this.perHourPartition != null ? this.perHourPartition.hashCode() : 0);
            return result;
        }
    }
}
