package software.amazon.awscdk.services.datasync;

/**
 * Properties for defining a `CfnLocationHDFS`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnLocationHDFSProps cfnLocationHDFSProps = CfnLocationHDFSProps.builder()
 *         .agentArns(List.of("agentArns"))
 *         .authenticationType("authenticationType")
 *         .nameNodes(List.of(NameNodeProperty.builder()
 *                 .hostname("hostname")
 *                 .port(123)
 *                 .build()))
 *         // the properties below are optional
 *         .blockSize(123)
 *         .kerberosKeytab("kerberosKeytab")
 *         .kerberosKrb5Conf("kerberosKrb5Conf")
 *         .kerberosPrincipal("kerberosPrincipal")
 *         .kmsKeyProviderUri("kmsKeyProviderUri")
 *         .qopConfiguration(QopConfigurationProperty.builder()
 *                 .dataTransferProtection("dataTransferProtection")
 *                 .rpcProtection("rpcProtection")
 *                 .build())
 *         .replicationFactor(123)
 *         .simpleUser("simpleUser")
 *         .subdirectory("subdirectory")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:10.380Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnLocationHDFSProps")
@software.amazon.jsii.Jsii.Proxy(CfnLocationHDFSProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLocationHDFSProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Names (ARNs) of the agents that are used to connect to the HDFS cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAgentArns();

    /**
     * `AWS::DataSync::LocationHDFS.AuthenticationType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthenticationType();

    /**
     * The NameNode that manages the HDFS namespace.
     * <p>
     * The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getNameNodes();

    /**
     * The size of data blocks to write into the HDFS cluster.
     * <p>
     * The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBlockSize() {
        return null;
    }

    /**
     * The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys.
     * <p>
     * Provide the base64-encoded file text. If <code>KERBEROS</code> is specified for <code>AuthType</code> , this value is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKerberosKeytab() {
        return null;
    }

    /**
     * The `krb5.conf` file that contains the Kerberos configuration information. You can load the `krb5.conf` by providing a string of the file's contents or an Amazon S3 presigned URL of the file. If `KERBEROS` is specified for `AuthType` , this value is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKerberosKrb5Conf() {
        return null;
    }

    /**
     * The Kerberos principal with access to the files and folders on the HDFS cluster.
     * <p>
     * <blockquote>
     * <p>
     * If <code>KERBEROS</code> is specified for <code>AuthenticationType</code> , this parameter is required.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKerberosPrincipal() {
        return null;
    }

    /**
     * The URI of the HDFS cluster's Key Management Server (KMS).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyProviderUri() {
        return null;
    }

    /**
     * The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster.
     * <p>
     * If <code>QopConfiguration</code> isn't specified, <code>RpcProtection</code> and <code>DataTransferProtection</code> default to <code>PRIVACY</code> . If you set <code>RpcProtection</code> or <code>DataTransferProtection</code> , the other parameter assumes the same value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getQopConfiguration() {
        return null;
    }

    /**
     * The number of DataNodes to replicate the data to when writing to the HDFS cluster.
     * <p>
     * By default, data is replicated to three DataNodes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getReplicationFactor() {
        return null;
    }

    /**
     * The user name used to identify the client on the host operating system.
     * <p>
     * <blockquote>
     * <p>
     * If <code>SIMPLE</code> is specified for <code>AuthenticationType</code> , this parameter is required.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSimpleUser() {
        return null;
    }

    /**
     * A subdirectory in the HDFS cluster.
     * <p>
     * This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to <code>/</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubdirectory() {
        return null;
    }

    /**
     * The key-value pair that represents the tag that you want to add to the location.
     * <p>
     * The value can be an empty string. We recommend using tags to name your resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLocationHDFSProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLocationHDFSProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLocationHDFSProps> {
        java.util.List<java.lang.String> agentArns;
        java.lang.String authenticationType;
        java.lang.Object nameNodes;
        java.lang.Number blockSize;
        java.lang.String kerberosKeytab;
        java.lang.String kerberosKrb5Conf;
        java.lang.String kerberosPrincipal;
        java.lang.String kmsKeyProviderUri;
        java.lang.Object qopConfiguration;
        java.lang.Number replicationFactor;
        java.lang.String simpleUser;
        java.lang.String subdirectory;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnLocationHDFSProps#getAgentArns}
         * @param agentArns The Amazon Resource Names (ARNs) of the agents that are used to connect to the HDFS cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentArns(java.util.List<java.lang.String> agentArns) {
            this.agentArns = agentArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationHDFSProps#getAuthenticationType}
         * @param authenticationType `AWS::DataSync::LocationHDFS.AuthenticationType`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationType(java.lang.String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationHDFSProps#getNameNodes}
         * @param nameNodes The NameNode that manages the HDFS namespace. This parameter is required.
         *                  The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nameNodes(software.amazon.awscdk.IResolvable nameNodes) {
            this.nameNodes = nameNodes;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationHDFSProps#getNameNodes}
         * @param nameNodes The NameNode that manages the HDFS namespace. This parameter is required.
         *                  The NameNode performs operations such as opening, closing, and renaming files and directories. The NameNode contains the information to map blocks of data to the DataNodes. You can use only one NameNode.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nameNodes(java.util.List<? extends java.lang.Object> nameNodes) {
            this.nameNodes = nameNodes;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationHDFSProps#getBlockSize}
         * @param blockSize The size of data blocks to write into the HDFS cluster.
         *                  The block size must be a multiple of 512 bytes. The default block size is 128 mebibytes (MiB).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockSize(java.lang.Number blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationHDFSProps#getKerberosKeytab}
         * @param kerberosKeytab The Kerberos key table (keytab) that contains mappings between the defined Kerberos principal and the encrypted keys.
         *                       Provide the base64-encoded file text. If <code>KERBEROS</code> is specified for <code>AuthType</code> , this value is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kerberosKeytab(java.lang.String kerberosKeytab) {
            this.kerberosKeytab = kerberosKeytab;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationHDFSProps#getKerberosKrb5Conf}
         * @param kerberosKrb5Conf The `krb5.conf` file that contains the Kerberos configuration information. You can load the `krb5.conf` by providing a string of the file's contents or an Amazon S3 presigned URL of the file. If `KERBEROS` is specified for `AuthType` , this value is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kerberosKrb5Conf(java.lang.String kerberosKrb5Conf) {
            this.kerberosKrb5Conf = kerberosKrb5Conf;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationHDFSProps#getKerberosPrincipal}
         * @param kerberosPrincipal The Kerberos principal with access to the files and folders on the HDFS cluster.
         *                          <blockquote>
         *                          <p>
         *                          If <code>KERBEROS</code> is specified for <code>AuthenticationType</code> , this parameter is required.
         *                          <p>
         *                          </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kerberosPrincipal(java.lang.String kerberosPrincipal) {
            this.kerberosPrincipal = kerberosPrincipal;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationHDFSProps#getKmsKeyProviderUri}
         * @param kmsKeyProviderUri The URI of the HDFS cluster's Key Management Server (KMS).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyProviderUri(java.lang.String kmsKeyProviderUri) {
            this.kmsKeyProviderUri = kmsKeyProviderUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationHDFSProps#getQopConfiguration}
         * @param qopConfiguration The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster.
         *                         If <code>QopConfiguration</code> isn't specified, <code>RpcProtection</code> and <code>DataTransferProtection</code> default to <code>PRIVACY</code> . If you set <code>RpcProtection</code> or <code>DataTransferProtection</code> , the other parameter assumes the same value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder qopConfiguration(software.amazon.awscdk.services.datasync.CfnLocationHDFS.QopConfigurationProperty qopConfiguration) {
            this.qopConfiguration = qopConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationHDFSProps#getQopConfiguration}
         * @param qopConfiguration The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster.
         *                         If <code>QopConfiguration</code> isn't specified, <code>RpcProtection</code> and <code>DataTransferProtection</code> default to <code>PRIVACY</code> . If you set <code>RpcProtection</code> or <code>DataTransferProtection</code> , the other parameter assumes the same value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder qopConfiguration(software.amazon.awscdk.IResolvable qopConfiguration) {
            this.qopConfiguration = qopConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationHDFSProps#getReplicationFactor}
         * @param replicationFactor The number of DataNodes to replicate the data to when writing to the HDFS cluster.
         *                          By default, data is replicated to three DataNodes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationFactor(java.lang.Number replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationHDFSProps#getSimpleUser}
         * @param simpleUser The user name used to identify the client on the host operating system.
         *                   <blockquote>
         *                   <p>
         *                   If <code>SIMPLE</code> is specified for <code>AuthenticationType</code> , this parameter is required.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder simpleUser(java.lang.String simpleUser) {
            this.simpleUser = simpleUser;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationHDFSProps#getSubdirectory}
         * @param subdirectory A subdirectory in the HDFS cluster.
         *                     This subdirectory is used to read data from or write data to the HDFS cluster. If the subdirectory isn't specified, it will default to <code>/</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subdirectory(java.lang.String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationHDFSProps#getTags}
         * @param tags The key-value pair that represents the tag that you want to add to the location.
         *             The value can be an empty string. We recommend using tags to name your resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLocationHDFSProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLocationHDFSProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLocationHDFSProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLocationHDFSProps {
        private final java.util.List<java.lang.String> agentArns;
        private final java.lang.String authenticationType;
        private final java.lang.Object nameNodes;
        private final java.lang.Number blockSize;
        private final java.lang.String kerberosKeytab;
        private final java.lang.String kerberosKrb5Conf;
        private final java.lang.String kerberosPrincipal;
        private final java.lang.String kmsKeyProviderUri;
        private final java.lang.Object qopConfiguration;
        private final java.lang.Number replicationFactor;
        private final java.lang.String simpleUser;
        private final java.lang.String subdirectory;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.agentArns = software.amazon.jsii.Kernel.get(this, "agentArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nameNodes = software.amazon.jsii.Kernel.get(this, "nameNodes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.blockSize = software.amazon.jsii.Kernel.get(this, "blockSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.kerberosKeytab = software.amazon.jsii.Kernel.get(this, "kerberosKeytab", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kerberosKrb5Conf = software.amazon.jsii.Kernel.get(this, "kerberosKrb5Conf", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kerberosPrincipal = software.amazon.jsii.Kernel.get(this, "kerberosPrincipal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyProviderUri = software.amazon.jsii.Kernel.get(this, "kmsKeyProviderUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.qopConfiguration = software.amazon.jsii.Kernel.get(this, "qopConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.replicationFactor = software.amazon.jsii.Kernel.get(this, "replicationFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.simpleUser = software.amazon.jsii.Kernel.get(this, "simpleUser", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subdirectory = software.amazon.jsii.Kernel.get(this, "subdirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.agentArns = java.util.Objects.requireNonNull(builder.agentArns, "agentArns is required");
            this.authenticationType = java.util.Objects.requireNonNull(builder.authenticationType, "authenticationType is required");
            this.nameNodes = java.util.Objects.requireNonNull(builder.nameNodes, "nameNodes is required");
            this.blockSize = builder.blockSize;
            this.kerberosKeytab = builder.kerberosKeytab;
            this.kerberosKrb5Conf = builder.kerberosKrb5Conf;
            this.kerberosPrincipal = builder.kerberosPrincipal;
            this.kmsKeyProviderUri = builder.kmsKeyProviderUri;
            this.qopConfiguration = builder.qopConfiguration;
            this.replicationFactor = builder.replicationFactor;
            this.simpleUser = builder.simpleUser;
            this.subdirectory = builder.subdirectory;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getAgentArns() {
            return this.agentArns;
        }

        @Override
        public final java.lang.String getAuthenticationType() {
            return this.authenticationType;
        }

        @Override
        public final java.lang.Object getNameNodes() {
            return this.nameNodes;
        }

        @Override
        public final java.lang.Number getBlockSize() {
            return this.blockSize;
        }

        @Override
        public final java.lang.String getKerberosKeytab() {
            return this.kerberosKeytab;
        }

        @Override
        public final java.lang.String getKerberosKrb5Conf() {
            return this.kerberosKrb5Conf;
        }

        @Override
        public final java.lang.String getKerberosPrincipal() {
            return this.kerberosPrincipal;
        }

        @Override
        public final java.lang.String getKmsKeyProviderUri() {
            return this.kmsKeyProviderUri;
        }

        @Override
        public final java.lang.Object getQopConfiguration() {
            return this.qopConfiguration;
        }

        @Override
        public final java.lang.Number getReplicationFactor() {
            return this.replicationFactor;
        }

        @Override
        public final java.lang.String getSimpleUser() {
            return this.simpleUser;
        }

        @Override
        public final java.lang.String getSubdirectory() {
            return this.subdirectory;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("agentArns", om.valueToTree(this.getAgentArns()));
            data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
            data.set("nameNodes", om.valueToTree(this.getNameNodes()));
            if (this.getBlockSize() != null) {
                data.set("blockSize", om.valueToTree(this.getBlockSize()));
            }
            if (this.getKerberosKeytab() != null) {
                data.set("kerberosKeytab", om.valueToTree(this.getKerberosKeytab()));
            }
            if (this.getKerberosKrb5Conf() != null) {
                data.set("kerberosKrb5Conf", om.valueToTree(this.getKerberosKrb5Conf()));
            }
            if (this.getKerberosPrincipal() != null) {
                data.set("kerberosPrincipal", om.valueToTree(this.getKerberosPrincipal()));
            }
            if (this.getKmsKeyProviderUri() != null) {
                data.set("kmsKeyProviderUri", om.valueToTree(this.getKmsKeyProviderUri()));
            }
            if (this.getQopConfiguration() != null) {
                data.set("qopConfiguration", om.valueToTree(this.getQopConfiguration()));
            }
            if (this.getReplicationFactor() != null) {
                data.set("replicationFactor", om.valueToTree(this.getReplicationFactor()));
            }
            if (this.getSimpleUser() != null) {
                data.set("simpleUser", om.valueToTree(this.getSimpleUser()));
            }
            if (this.getSubdirectory() != null) {
                data.set("subdirectory", om.valueToTree(this.getSubdirectory()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnLocationHDFSProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLocationHDFSProps.Jsii$Proxy that = (CfnLocationHDFSProps.Jsii$Proxy) o;

            if (!agentArns.equals(that.agentArns)) return false;
            if (!authenticationType.equals(that.authenticationType)) return false;
            if (!nameNodes.equals(that.nameNodes)) return false;
            if (this.blockSize != null ? !this.blockSize.equals(that.blockSize) : that.blockSize != null) return false;
            if (this.kerberosKeytab != null ? !this.kerberosKeytab.equals(that.kerberosKeytab) : that.kerberosKeytab != null) return false;
            if (this.kerberosKrb5Conf != null ? !this.kerberosKrb5Conf.equals(that.kerberosKrb5Conf) : that.kerberosKrb5Conf != null) return false;
            if (this.kerberosPrincipal != null ? !this.kerberosPrincipal.equals(that.kerberosPrincipal) : that.kerberosPrincipal != null) return false;
            if (this.kmsKeyProviderUri != null ? !this.kmsKeyProviderUri.equals(that.kmsKeyProviderUri) : that.kmsKeyProviderUri != null) return false;
            if (this.qopConfiguration != null ? !this.qopConfiguration.equals(that.qopConfiguration) : that.qopConfiguration != null) return false;
            if (this.replicationFactor != null ? !this.replicationFactor.equals(that.replicationFactor) : that.replicationFactor != null) return false;
            if (this.simpleUser != null ? !this.simpleUser.equals(that.simpleUser) : that.simpleUser != null) return false;
            if (this.subdirectory != null ? !this.subdirectory.equals(that.subdirectory) : that.subdirectory != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.agentArns.hashCode();
            result = 31 * result + (this.authenticationType.hashCode());
            result = 31 * result + (this.nameNodes.hashCode());
            result = 31 * result + (this.blockSize != null ? this.blockSize.hashCode() : 0);
            result = 31 * result + (this.kerberosKeytab != null ? this.kerberosKeytab.hashCode() : 0);
            result = 31 * result + (this.kerberosKrb5Conf != null ? this.kerberosKrb5Conf.hashCode() : 0);
            result = 31 * result + (this.kerberosPrincipal != null ? this.kerberosPrincipal.hashCode() : 0);
            result = 31 * result + (this.kmsKeyProviderUri != null ? this.kmsKeyProviderUri.hashCode() : 0);
            result = 31 * result + (this.qopConfiguration != null ? this.qopConfiguration.hashCode() : 0);
            result = 31 * result + (this.replicationFactor != null ? this.replicationFactor.hashCode() : 0);
            result = 31 * result + (this.simpleUser != null ? this.simpleUser.hashCode() : 0);
            result = 31 * result + (this.subdirectory != null ? this.subdirectory.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
