package software.amazon.awscdk.services.cognito;

/**
 * A CloudFormation `AWS::Cognito::IdentityPoolRoleAttachment`.
 * <p>
 * The <code>AWS::Cognito::IdentityPoolRoleAttachment</code> resource manages the role configuration for an Amazon Cognito identity pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * Object roles;
 * CfnIdentityPoolRoleAttachment cfnIdentityPoolRoleAttachment = CfnIdentityPoolRoleAttachment.Builder.create(this, "MyCfnIdentityPoolRoleAttachment")
 *         .identityPoolId("identityPoolId")
 *         // the properties below are optional
 *         .roleMappings(Map.of(
 *                 "roleMappingsKey", RoleMappingProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .ambiguousRoleResolution("ambiguousRoleResolution")
 *                         .identityProvider("identityProvider")
 *                         .rulesConfiguration(RulesConfigurationTypeProperty.builder()
 *                                 .rules(List.of(MappingRuleProperty.builder()
 *                                         .claim("claim")
 *                                         .matchType("matchType")
 *                                         .roleArn("roleArn")
 *                                         .value("value")
 *                                         .build()))
 *                                 .build())
 *                         .build()))
 *         .roles(roles)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:10.095Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnIdentityPoolRoleAttachment")
public class CfnIdentityPoolRoleAttachment extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnIdentityPoolRoleAttachment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIdentityPoolRoleAttachment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachment.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Cognito::IdentityPoolRoleAttachment`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIdentityPoolRoleAttachment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An identity pool ID in the format `REGION:GUID` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIdentityPoolId() {
        return software.amazon.jsii.Kernel.get(this, "identityPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An identity pool ID in the format `REGION:GUID` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityPoolId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "identityPoolId", java.util.Objects.requireNonNull(value, "identityPoolId is required"));
    }

    /**
     * The map of the roles associated with this pool.
     * <p>
     * For a given role, the key is either "authenticated" or "unauthenticated". The value is the role ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRoles() {
        return software.amazon.jsii.Kernel.get(this, "roles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The map of the roles associated with this pool.
     * <p>
     * For a given role, the key is either "authenticated" or "unauthenticated". The value is the role ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoles(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "roles", java.util.Objects.requireNonNull(value, "roles is required"));
    }

    /**
     * How users for a specific identity provider are mapped to roles.
     * <p>
     * This is a string to the <code>RoleMapping</code> object map. The string identifies the identity provider. For example: <code>graph.facebook.com</code> or <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id</code> .
     * <p>
     * If the <code>IdentityProvider</code> field isn't provided in this object, the string is used as the identity provider name.
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html">RoleMapping property</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRoleMappings() {
        return software.amazon.jsii.Kernel.get(this, "roleMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * How users for a specific identity provider are mapped to roles.
     * <p>
     * This is a string to the <code>RoleMapping</code> object map. The string identifies the identity provider. For example: <code>graph.facebook.com</code> or <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id</code> .
     * <p>
     * If the <code>IdentityProvider</code> field isn't provided in this object, the string is used as the identity provider name.
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html">RoleMapping property</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleMappings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "roleMappings", value);
    }

    /**
     * How users for a specific identity provider are mapped to roles.
     * <p>
     * This is a string to the <code>RoleMapping</code> object map. The string identifies the identity provider. For example: <code>graph.facebook.com</code> or <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id</code> .
     * <p>
     * If the <code>IdentityProvider</code> field isn't provided in this object, the string is used as the identity provider name.
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html">RoleMapping property</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleMappings(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachment.RoleMappingProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachment.RoleMappingProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "roleMappings", value);
    }
    /**
     * Defines how to map a claim to a role ARN.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * MappingRuleProperty mappingRuleProperty = MappingRuleProperty.builder()
     *         .claim("claim")
     *         .matchType("matchType")
     *         .roleArn("roleArn")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnIdentityPoolRoleAttachment.MappingRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(MappingRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MappingRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The claim name that must be present in the token.
         * <p>
         * For example: "isAdmin" or "paid".
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClaim();

        /**
         * The match condition that specifies how closely the claim value in the IdP token must match `Value` .
         * <p>
         * Valid values are: <code>Equals</code> , <code>Contains</code> , <code>StartsWith</code> , and <code>NotEqual</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMatchType();

        /**
         * The Amazon Resource Name (ARN) of the role.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * A brief string that the claim must match.
         * <p>
         * For example, "paid" or "yes".
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link MappingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MappingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MappingRuleProperty> {
            java.lang.String claim;
            java.lang.String matchType;
            java.lang.String roleArn;
            java.lang.String value;

            /**
             * Sets the value of {@link MappingRuleProperty#getClaim}
             * @param claim The claim name that must be present in the token. This parameter is required.
             *              For example: "isAdmin" or "paid".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder claim(java.lang.String claim) {
                this.claim = claim;
                return this;
            }

            /**
             * Sets the value of {@link MappingRuleProperty#getMatchType}
             * @param matchType The match condition that specifies how closely the claim value in the IdP token must match `Value` . This parameter is required.
             *                  Valid values are: <code>Equals</code> , <code>Contains</code> , <code>StartsWith</code> , and <code>NotEqual</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchType(java.lang.String matchType) {
                this.matchType = matchType;
                return this;
            }

            /**
             * Sets the value of {@link MappingRuleProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the role. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link MappingRuleProperty#getValue}
             * @param value A brief string that the claim must match. This parameter is required.
             *              For example, "paid" or "yes".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MappingRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MappingRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MappingRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MappingRuleProperty {
            private final java.lang.String claim;
            private final java.lang.String matchType;
            private final java.lang.String roleArn;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.claim = software.amazon.jsii.Kernel.get(this, "claim", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.matchType = software.amazon.jsii.Kernel.get(this, "matchType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.claim = java.util.Objects.requireNonNull(builder.claim, "claim is required");
                this.matchType = java.util.Objects.requireNonNull(builder.matchType, "matchType is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getClaim() {
                return this.claim;
            }

            @Override
            public final java.lang.String getMatchType() {
                return this.matchType;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("claim", om.valueToTree(this.getClaim()));
                data.set("matchType", om.valueToTree(this.getMatchType()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnIdentityPoolRoleAttachment.MappingRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MappingRuleProperty.Jsii$Proxy that = (MappingRuleProperty.Jsii$Proxy) o;

                if (!claim.equals(that.claim)) return false;
                if (!matchType.equals(that.matchType)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.claim.hashCode();
                result = 31 * result + (this.matchType.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * `RoleMapping` is a property of the [AWS::Cognito::IdentityPoolRoleAttachment](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html) resource that defines the role-mapping attributes of an Amazon Cognito identity pool.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * RoleMappingProperty roleMappingProperty = RoleMappingProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .ambiguousRoleResolution("ambiguousRoleResolution")
     *         .identityProvider("identityProvider")
     *         .rulesConfiguration(RulesConfigurationTypeProperty.builder()
     *                 .rules(List.of(MappingRuleProperty.builder()
     *                         .claim("claim")
     *                         .matchType("matchType")
     *                         .roleArn("roleArn")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnIdentityPoolRoleAttachment.RoleMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(RoleMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RoleMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The role-mapping type.
         * <p>
         * <code>Token</code> uses <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims from the Amazon Cognito identity provider token to map groups to roles. <code>Rules</code> attempts to match claims from the token to map to a role.
         * <p>
         * Valid values are <code>Token</code> or <code>Rules</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Specifies the action to be taken if either no rules match the claim value for the Rules type, or there is no `cognito:preferred_role` claim and there are multiple `cognito:roles` matches for the Token type.
         * <p>
         * If you specify Token or Rules as the Type, AmbiguousRoleResolution is required.
         * <p>
         * Valid values are <code>AuthenticatedRole</code> or <code>Deny</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAmbiguousRoleResolution() {
            return null;
        }

        /**
         * Identifier for the identity provider for which the role is mapped.
         * <p>
         * For example: <code>graph.facebook.com</code> or <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id (http://cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id)</code> . This is the identity provider that is used by the user for authentication.
         * <p>
         * If the identity provider property isn't provided, the key of the entry in the <code>RoleMappings</code> map is used as the identity provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdentityProvider() {
            return null;
        }

        /**
         * The rules to be used for mapping users to roles.
         * <p>
         * If you specify "Rules" as the role-mapping type, RulesConfiguration is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRulesConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RoleMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RoleMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RoleMappingProperty> {
            java.lang.String type;
            java.lang.String ambiguousRoleResolution;
            java.lang.String identityProvider;
            java.lang.Object rulesConfiguration;

            /**
             * Sets the value of {@link RoleMappingProperty#getType}
             * @param type The role-mapping type. This parameter is required.
             *             <code>Token</code> uses <code>cognito:roles</code> and <code>cognito:preferred_role</code> claims from the Amazon Cognito identity provider token to map groups to roles. <code>Rules</code> attempts to match claims from the token to map to a role.
             *             <p>
             *             Valid values are <code>Token</code> or <code>Rules</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link RoleMappingProperty#getAmbiguousRoleResolution}
             * @param ambiguousRoleResolution Specifies the action to be taken if either no rules match the claim value for the Rules type, or there is no `cognito:preferred_role` claim and there are multiple `cognito:roles` matches for the Token type.
             *                                If you specify Token or Rules as the Type, AmbiguousRoleResolution is required.
             *                                <p>
             *                                Valid values are <code>AuthenticatedRole</code> or <code>Deny</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ambiguousRoleResolution(java.lang.String ambiguousRoleResolution) {
                this.ambiguousRoleResolution = ambiguousRoleResolution;
                return this;
            }

            /**
             * Sets the value of {@link RoleMappingProperty#getIdentityProvider}
             * @param identityProvider Identifier for the identity provider for which the role is mapped.
             *                         For example: <code>graph.facebook.com</code> or <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id (http://cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id)</code> . This is the identity provider that is used by the user for authentication.
             *                         <p>
             *                         If the identity provider property isn't provided, the key of the entry in the <code>RoleMappings</code> map is used as the identity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityProvider(java.lang.String identityProvider) {
                this.identityProvider = identityProvider;
                return this;
            }

            /**
             * Sets the value of {@link RoleMappingProperty#getRulesConfiguration}
             * @param rulesConfiguration The rules to be used for mapping users to roles.
             *                           If you specify "Rules" as the role-mapping type, RulesConfiguration is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rulesConfiguration(software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachment.RulesConfigurationTypeProperty rulesConfiguration) {
                this.rulesConfiguration = rulesConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RoleMappingProperty#getRulesConfiguration}
             * @param rulesConfiguration The rules to be used for mapping users to roles.
             *                           If you specify "Rules" as the role-mapping type, RulesConfiguration is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rulesConfiguration(software.amazon.awscdk.IResolvable rulesConfiguration) {
                this.rulesConfiguration = rulesConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoleMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RoleMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RoleMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoleMappingProperty {
            private final java.lang.String type;
            private final java.lang.String ambiguousRoleResolution;
            private final java.lang.String identityProvider;
            private final java.lang.Object rulesConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ambiguousRoleResolution = software.amazon.jsii.Kernel.get(this, "ambiguousRoleResolution", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.identityProvider = software.amazon.jsii.Kernel.get(this, "identityProvider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rulesConfiguration = software.amazon.jsii.Kernel.get(this, "rulesConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.ambiguousRoleResolution = builder.ambiguousRoleResolution;
                this.identityProvider = builder.identityProvider;
                this.rulesConfiguration = builder.rulesConfiguration;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getAmbiguousRoleResolution() {
                return this.ambiguousRoleResolution;
            }

            @Override
            public final java.lang.String getIdentityProvider() {
                return this.identityProvider;
            }

            @Override
            public final java.lang.Object getRulesConfiguration() {
                return this.rulesConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getAmbiguousRoleResolution() != null) {
                    data.set("ambiguousRoleResolution", om.valueToTree(this.getAmbiguousRoleResolution()));
                }
                if (this.getIdentityProvider() != null) {
                    data.set("identityProvider", om.valueToTree(this.getIdentityProvider()));
                }
                if (this.getRulesConfiguration() != null) {
                    data.set("rulesConfiguration", om.valueToTree(this.getRulesConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnIdentityPoolRoleAttachment.RoleMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RoleMappingProperty.Jsii$Proxy that = (RoleMappingProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.ambiguousRoleResolution != null ? !this.ambiguousRoleResolution.equals(that.ambiguousRoleResolution) : that.ambiguousRoleResolution != null) return false;
                if (this.identityProvider != null ? !this.identityProvider.equals(that.identityProvider) : that.identityProvider != null) return false;
                return this.rulesConfiguration != null ? this.rulesConfiguration.equals(that.rulesConfiguration) : that.rulesConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.ambiguousRoleResolution != null ? this.ambiguousRoleResolution.hashCode() : 0);
                result = 31 * result + (this.identityProvider != null ? this.identityProvider.hashCode() : 0);
                result = 31 * result + (this.rulesConfiguration != null ? this.rulesConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * `RulesConfigurationType` is a subproperty of the [RoleMapping](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html) property that defines the rules to be used for mapping users to roles.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cognito.*;
     * RulesConfigurationTypeProperty rulesConfigurationTypeProperty = RulesConfigurationTypeProperty.builder()
     *         .rules(List.of(MappingRuleProperty.builder()
     *                 .claim("claim")
     *                 .matchType("matchType")
     *                 .roleArn("roleArn")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnIdentityPoolRoleAttachment.RulesConfigurationTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(RulesConfigurationTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RulesConfigurationTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The rules.
         * <p>
         * You can specify up to 25 rules per identity provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRules();

        /**
         * @return a {@link Builder} of {@link RulesConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RulesConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RulesConfigurationTypeProperty> {
            java.lang.Object rules;

            /**
             * Sets the value of {@link RulesConfigurationTypeProperty#getRules}
             * @param rules The rules. This parameter is required.
             *              You can specify up to 25 rules per identity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link RulesConfigurationTypeProperty#getRules}
             * @param rules The rules. This parameter is required.
             *              You can specify up to 25 rules per identity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<? extends java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RulesConfigurationTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RulesConfigurationTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RulesConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RulesConfigurationTypeProperty {
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.rules = java.util.Objects.requireNonNull(builder.rules, "rules is required");
            }

            @Override
            public final java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("rules", om.valueToTree(this.getRules()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnIdentityPoolRoleAttachment.RulesConfigurationTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RulesConfigurationTypeProperty.Jsii$Proxy that = (RulesConfigurationTypeProperty.Jsii$Proxy) o;

                return this.rules.equals(that.rules);
            }

            @Override
            public final int hashCode() {
                int result = this.rules.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachmentProps.Builder();
        }

        /**
         * An identity pool ID in the format `REGION:GUID` .
         * <p>
         * @return {@code this}
         * @param identityPoolId An identity pool ID in the format `REGION:GUID` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityPoolId(final java.lang.String identityPoolId) {
            this.props.identityPoolId(identityPoolId);
            return this;
        }

        /**
         * How users for a specific identity provider are mapped to roles.
         * <p>
         * This is a string to the <code>RoleMapping</code> object map. The string identifies the identity provider. For example: <code>graph.facebook.com</code> or <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id</code> .
         * <p>
         * If the <code>IdentityProvider</code> field isn't provided in this object, the string is used as the identity provider name.
         * <p>
         * For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html">RoleMapping property</a> .
         * <p>
         * @return {@code this}
         * @param roleMappings How users for a specific identity provider are mapped to roles. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleMappings(final software.amazon.awscdk.IResolvable roleMappings) {
            this.props.roleMappings(roleMappings);
            return this;
        }
        /**
         * How users for a specific identity provider are mapped to roles.
         * <p>
         * This is a string to the <code>RoleMapping</code> object map. The string identifies the identity provider. For example: <code>graph.facebook.com</code> or <code>cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id</code> .
         * <p>
         * If the <code>IdentityProvider</code> field isn't provided in this object, the string is used as the identity provider name.
         * <p>
         * For more information, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html">RoleMapping property</a> .
         * <p>
         * @return {@code this}
         * @param roleMappings How users for a specific identity provider are mapped to roles. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleMappings(final java.util.Map<java.lang.String, ? extends java.lang.Object> roleMappings) {
            this.props.roleMappings(roleMappings);
            return this;
        }

        /**
         * The map of the roles associated with this pool.
         * <p>
         * For a given role, the key is either "authenticated" or "unauthenticated". The value is the role ARN.
         * <p>
         * @return {@code this}
         * @param roles The map of the roles associated with this pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roles(final java.lang.Object roles) {
            this.props.roles(roles);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachment build() {
            return new software.amazon.awscdk.services.cognito.CfnIdentityPoolRoleAttachment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
