package software.amazon.awscdk.services.cloudwatch;

/**
 * A dashboard widget that displays the most recent value for every metric.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * dashboard.addWidgets(SingleValueWidget.Builder.create()
 *         .metrics(List.of())
 *         .fullPrecision(true)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:09.728Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.SingleValueWidget")
public class SingleValueWidget extends software.amazon.awscdk.services.cloudwatch.ConcreteWidget {

    protected SingleValueWidget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SingleValueWidget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SingleValueWidget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.SingleValueWidgetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Return the widget JSON for use in the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> toJson() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "toJson", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.SingleValueWidget}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.SingleValueWidget> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.cloudwatch.SingleValueWidgetProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.cloudwatch.SingleValueWidgetProps.Builder();
        }

        /**
         * Height of the widget.
         * <p>
         * Default: - 6 for Alarm and Graph widgets.
         * 3 for single value widgets where most recent value of a metric is displayed.
         * <p>
         * @return {@code this}
         * @param height Height of the widget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder height(final java.lang.Number height) {
            this.props.height(height);
            return this;
        }

        /**
         * The region the metrics of this graph should be taken from.
         * <p>
         * Default: - Current region
         * <p>
         * @return {@code this}
         * @param region The region the metrics of this graph should be taken from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * Title for the graph.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param title Title for the graph. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(final java.lang.String title) {
            this.props.title(title);
            return this;
        }

        /**
         * Width of the widget, in a grid of 24 units wide.
         * <p>
         * Default: 6
         * <p>
         * @return {@code this}
         * @param width Width of the widget, in a grid of 24 units wide. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder width(final java.lang.Number width) {
            this.props.width(width);
            return this;
        }

        /**
         * Metrics to display.
         * <p>
         * @return {@code this}
         * @param metrics Metrics to display. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metrics(final java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IMetric> metrics) {
            this.props.metrics(metrics);
            return this;
        }

        /**
         * Whether to show as many digits as can fit, before rounding.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param fullPrecision Whether to show as many digits as can fit, before rounding. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fullPrecision(final java.lang.Boolean fullPrecision) {
            this.props.fullPrecision(fullPrecision);
            return this;
        }

        /**
         * Whether to show the value from the entire time range.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param setPeriodToTimeRange Whether to show the value from the entire time range. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder setPeriodToTimeRange(final java.lang.Boolean setPeriodToTimeRange) {
            this.props.setPeriodToTimeRange(setPeriodToTimeRange);
            return this;
        }

        /**
         * Whether to show a graph below the value illustrating the value for the whole time range.
         * <p>
         * Cannot be used in combination with <code>setPeriodToTimeRange</code>
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param sparkline Whether to show a graph below the value illustrating the value for the whole time range. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sparkline(final java.lang.Boolean sparkline) {
            this.props.sparkline(sparkline);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.SingleValueWidget}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudwatch.SingleValueWidget build() {
            return new software.amazon.awscdk.services.cloudwatch.SingleValueWidget(
                this.props.build()
            );
        }
    }
}
