package software.amazon.awscdk.services.cloudfront;

/**
 * Configuration for a set of security-related HTTP response headers.
 * <p>
 * CloudFront adds these headers to HTTP responses that it sends for requests that match a cache behavior
 * associated with this response headers policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Using an existing managed response headers policy
 * S3Origin bucketOrigin;
 * Distribution.Builder.create(this, "myDistManagedPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .responseHeadersPolicy(ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS)
 *                 .build())
 *         .build();
 * // Creating a custom response headers policy -- all parameters optional
 * ResponseHeadersPolicy myResponseHeadersPolicy = ResponseHeadersPolicy.Builder.create(this, "ResponseHeadersPolicy")
 *         .responseHeadersPolicyName("MyPolicy")
 *         .comment("A default policy")
 *         .corsBehavior(ResponseHeadersCorsBehavior.builder()
 *                 .accessControlAllowCredentials(false)
 *                 .accessControlAllowHeaders(List.of("X-Custom-Header-1", "X-Custom-Header-2"))
 *                 .accessControlAllowMethods(List.of("GET", "POST"))
 *                 .accessControlAllowOrigins(List.of("*"))
 *                 .accessControlExposeHeaders(List.of("X-Custom-Header-1", "X-Custom-Header-2"))
 *                 .accessControlMaxAge(Duration.seconds(600))
 *                 .originOverride(true)
 *                 .build())
 *         .customHeadersBehavior(ResponseCustomHeadersBehavior.builder()
 *                 .customHeaders(List.of(ResponseCustomHeader.builder().header("X-Amz-Date").value("some-value").override(true).build(), ResponseCustomHeader.builder().header("X-Amz-Security-Token").value("some-value").override(false).build()))
 *                 .build())
 *         .securityHeadersBehavior(ResponseSecurityHeadersBehavior.builder()
 *                 .contentSecurityPolicy(ResponseHeadersContentSecurityPolicy.builder().contentSecurityPolicy("default-src https:;").override(true).build())
 *                 .contentTypeOptions(ResponseHeadersContentTypeOptions.builder().override(true).build())
 *                 .frameOptions(ResponseHeadersFrameOptions.builder().frameOption(HeadersFrameOption.DENY).override(true).build())
 *                 .referrerPolicy(ResponseHeadersReferrerPolicy.builder().referrerPolicy(HeadersReferrerPolicy.NO_REFERRER).override(true).build())
 *                 .strictTransportSecurity(ResponseHeadersStrictTransportSecurity.builder().accessControlMaxAge(Duration.seconds(600)).includeSubdomains(true).override(true).build())
 *                 .xssProtection(ResponseHeadersXSSProtection.builder().protection(true).modeBlock(true).reportUri("https://example.com/csp-report").override(true).build())
 *                 .build())
 *         .build();
 * Distribution.Builder.create(this, "myDistCustomPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .responseHeadersPolicy(myResponseHeadersPolicy)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:09.605Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.ResponseSecurityHeadersBehavior")
@software.amazon.jsii.Jsii.Proxy(ResponseSecurityHeadersBehavior.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResponseSecurityHeadersBehavior extends software.amazon.jsii.JsiiSerializable {

    /**
     * The policy directives and their values that CloudFront includes as values for the Content-Security-Policy HTTP response header.
     * <p>
     * Default: - no content security policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.ResponseHeadersContentSecurityPolicy getContentSecurityPolicy() {
        return null;
    }

    /**
     * Determines whether CloudFront includes the X-Content-Type-Options HTTP response header with its value set to nosniff.
     * <p>
     * Default: - no content type options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.ResponseHeadersContentTypeOptions getContentTypeOptions() {
        return null;
    }

    /**
     * Determines whether CloudFront includes the X-Frame-Options HTTP response header and the header’s value.
     * <p>
     * Default: - no frame options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.ResponseHeadersFrameOptions getFrameOptions() {
        return null;
    }

    /**
     * Determines whether CloudFront includes the Referrer-Policy HTTP response header and the header’s value.
     * <p>
     * Default: - no referrer policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.ResponseHeadersReferrerPolicy getReferrerPolicy() {
        return null;
    }

    /**
     * Determines whether CloudFront includes the Strict-Transport-Security HTTP response header and the header’s value.
     * <p>
     * Default: - no strict transport security
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.ResponseHeadersStrictTransportSecurity getStrictTransportSecurity() {
        return null;
    }

    /**
     * Determines whether CloudFront includes the X-XSS-Protection HTTP response header and the header’s value.
     * <p>
     * Default: - no xss protection
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.ResponseHeadersXSSProtection getXssProtection() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ResponseSecurityHeadersBehavior}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResponseSecurityHeadersBehavior}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResponseSecurityHeadersBehavior> {
        software.amazon.awscdk.services.cloudfront.ResponseHeadersContentSecurityPolicy contentSecurityPolicy;
        software.amazon.awscdk.services.cloudfront.ResponseHeadersContentTypeOptions contentTypeOptions;
        software.amazon.awscdk.services.cloudfront.ResponseHeadersFrameOptions frameOptions;
        software.amazon.awscdk.services.cloudfront.ResponseHeadersReferrerPolicy referrerPolicy;
        software.amazon.awscdk.services.cloudfront.ResponseHeadersStrictTransportSecurity strictTransportSecurity;
        software.amazon.awscdk.services.cloudfront.ResponseHeadersXSSProtection xssProtection;

        /**
         * Sets the value of {@link ResponseSecurityHeadersBehavior#getContentSecurityPolicy}
         * @param contentSecurityPolicy The policy directives and their values that CloudFront includes as values for the Content-Security-Policy HTTP response header.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentSecurityPolicy(software.amazon.awscdk.services.cloudfront.ResponseHeadersContentSecurityPolicy contentSecurityPolicy) {
            this.contentSecurityPolicy = contentSecurityPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ResponseSecurityHeadersBehavior#getContentTypeOptions}
         * @param contentTypeOptions Determines whether CloudFront includes the X-Content-Type-Options HTTP response header with its value set to nosniff.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentTypeOptions(software.amazon.awscdk.services.cloudfront.ResponseHeadersContentTypeOptions contentTypeOptions) {
            this.contentTypeOptions = contentTypeOptions;
            return this;
        }

        /**
         * Sets the value of {@link ResponseSecurityHeadersBehavior#getFrameOptions}
         * @param frameOptions Determines whether CloudFront includes the X-Frame-Options HTTP response header and the header’s value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frameOptions(software.amazon.awscdk.services.cloudfront.ResponseHeadersFrameOptions frameOptions) {
            this.frameOptions = frameOptions;
            return this;
        }

        /**
         * Sets the value of {@link ResponseSecurityHeadersBehavior#getReferrerPolicy}
         * @param referrerPolicy Determines whether CloudFront includes the Referrer-Policy HTTP response header and the header’s value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder referrerPolicy(software.amazon.awscdk.services.cloudfront.ResponseHeadersReferrerPolicy referrerPolicy) {
            this.referrerPolicy = referrerPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ResponseSecurityHeadersBehavior#getStrictTransportSecurity}
         * @param strictTransportSecurity Determines whether CloudFront includes the Strict-Transport-Security HTTP response header and the header’s value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder strictTransportSecurity(software.amazon.awscdk.services.cloudfront.ResponseHeadersStrictTransportSecurity strictTransportSecurity) {
            this.strictTransportSecurity = strictTransportSecurity;
            return this;
        }

        /**
         * Sets the value of {@link ResponseSecurityHeadersBehavior#getXssProtection}
         * @param xssProtection Determines whether CloudFront includes the X-XSS-Protection HTTP response header and the header’s value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xssProtection(software.amazon.awscdk.services.cloudfront.ResponseHeadersXSSProtection xssProtection) {
            this.xssProtection = xssProtection;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResponseSecurityHeadersBehavior}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResponseSecurityHeadersBehavior build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResponseSecurityHeadersBehavior}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResponseSecurityHeadersBehavior {
        private final software.amazon.awscdk.services.cloudfront.ResponseHeadersContentSecurityPolicy contentSecurityPolicy;
        private final software.amazon.awscdk.services.cloudfront.ResponseHeadersContentTypeOptions contentTypeOptions;
        private final software.amazon.awscdk.services.cloudfront.ResponseHeadersFrameOptions frameOptions;
        private final software.amazon.awscdk.services.cloudfront.ResponseHeadersReferrerPolicy referrerPolicy;
        private final software.amazon.awscdk.services.cloudfront.ResponseHeadersStrictTransportSecurity strictTransportSecurity;
        private final software.amazon.awscdk.services.cloudfront.ResponseHeadersXSSProtection xssProtection;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.contentSecurityPolicy = software.amazon.jsii.Kernel.get(this, "contentSecurityPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ResponseHeadersContentSecurityPolicy.class));
            this.contentTypeOptions = software.amazon.jsii.Kernel.get(this, "contentTypeOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ResponseHeadersContentTypeOptions.class));
            this.frameOptions = software.amazon.jsii.Kernel.get(this, "frameOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ResponseHeadersFrameOptions.class));
            this.referrerPolicy = software.amazon.jsii.Kernel.get(this, "referrerPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ResponseHeadersReferrerPolicy.class));
            this.strictTransportSecurity = software.amazon.jsii.Kernel.get(this, "strictTransportSecurity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ResponseHeadersStrictTransportSecurity.class));
            this.xssProtection = software.amazon.jsii.Kernel.get(this, "xssProtection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ResponseHeadersXSSProtection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.contentSecurityPolicy = builder.contentSecurityPolicy;
            this.contentTypeOptions = builder.contentTypeOptions;
            this.frameOptions = builder.frameOptions;
            this.referrerPolicy = builder.referrerPolicy;
            this.strictTransportSecurity = builder.strictTransportSecurity;
            this.xssProtection = builder.xssProtection;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.ResponseHeadersContentSecurityPolicy getContentSecurityPolicy() {
            return this.contentSecurityPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.ResponseHeadersContentTypeOptions getContentTypeOptions() {
            return this.contentTypeOptions;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.ResponseHeadersFrameOptions getFrameOptions() {
            return this.frameOptions;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.ResponseHeadersReferrerPolicy getReferrerPolicy() {
            return this.referrerPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.ResponseHeadersStrictTransportSecurity getStrictTransportSecurity() {
            return this.strictTransportSecurity;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.ResponseHeadersXSSProtection getXssProtection() {
            return this.xssProtection;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getContentSecurityPolicy() != null) {
                data.set("contentSecurityPolicy", om.valueToTree(this.getContentSecurityPolicy()));
            }
            if (this.getContentTypeOptions() != null) {
                data.set("contentTypeOptions", om.valueToTree(this.getContentTypeOptions()));
            }
            if (this.getFrameOptions() != null) {
                data.set("frameOptions", om.valueToTree(this.getFrameOptions()));
            }
            if (this.getReferrerPolicy() != null) {
                data.set("referrerPolicy", om.valueToTree(this.getReferrerPolicy()));
            }
            if (this.getStrictTransportSecurity() != null) {
                data.set("strictTransportSecurity", om.valueToTree(this.getStrictTransportSecurity()));
            }
            if (this.getXssProtection() != null) {
                data.set("xssProtection", om.valueToTree(this.getXssProtection()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.ResponseSecurityHeadersBehavior"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResponseSecurityHeadersBehavior.Jsii$Proxy that = (ResponseSecurityHeadersBehavior.Jsii$Proxy) o;

            if (this.contentSecurityPolicy != null ? !this.contentSecurityPolicy.equals(that.contentSecurityPolicy) : that.contentSecurityPolicy != null) return false;
            if (this.contentTypeOptions != null ? !this.contentTypeOptions.equals(that.contentTypeOptions) : that.contentTypeOptions != null) return false;
            if (this.frameOptions != null ? !this.frameOptions.equals(that.frameOptions) : that.frameOptions != null) return false;
            if (this.referrerPolicy != null ? !this.referrerPolicy.equals(that.referrerPolicy) : that.referrerPolicy != null) return false;
            if (this.strictTransportSecurity != null ? !this.strictTransportSecurity.equals(that.strictTransportSecurity) : that.strictTransportSecurity != null) return false;
            return this.xssProtection != null ? this.xssProtection.equals(that.xssProtection) : that.xssProtection == null;
        }

        @Override
        public final int hashCode() {
            int result = this.contentSecurityPolicy != null ? this.contentSecurityPolicy.hashCode() : 0;
            result = 31 * result + (this.contentTypeOptions != null ? this.contentTypeOptions.hashCode() : 0);
            result = 31 * result + (this.frameOptions != null ? this.frameOptions.hashCode() : 0);
            result = 31 * result + (this.referrerPolicy != null ? this.referrerPolicy.hashCode() : 0);
            result = 31 * result + (this.strictTransportSecurity != null ? this.strictTransportSecurity.hashCode() : 0);
            result = 31 * result + (this.xssProtection != null ? this.xssProtection.hashCode() : 0);
            return result;
        }
    }
}
