package software.amazon.awscdk.services.backup;

/**
 * Configuration for AWS Backup Vault Lock.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.backup.*;
 * LockConfiguration lockConfiguration = LockConfiguration.builder()
 *         .minRetention(Duration.minutes(30))
 *         // the properties below are optional
 *         .changeableFor(Duration.minutes(30))
 *         .maxRetention(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:09.299Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.LockConfiguration")
@software.amazon.jsii.Jsii.Proxy(LockConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LockConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * The minimum retention period that the vault retains its recovery points.
     * <p>
     * If this parameter is specified, any backup or copy job to the vault must
     * have a lifecycle policy with a retention period equal to or longer than
     * the minimum retention period. If the job's retention period is shorter than
     * that minimum retention period, then the vault fails that backup or copy job,
     * and you should either modify your lifecycle settings or use a different
     * vault. Recovery points already saved in the vault prior to Vault Lock are
     * not affected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getMinRetention();

    /**
     * The duration before the lock date.
     * <p>
     * AWS Backup enforces a 72-hour cooling-off period before Vault Lock takes
     * effect and becomes immutable.
     * <p>
     * Before the lock date, you can delete Vault Lock from the vault or change
     * the Vault Lock configuration. On and after the lock date, the Vault Lock
     * becomes immutable and cannot be changed or deleted.
     * <p>
     * Default: - Vault Lock can be deleted or changed at any time
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getChangeableFor() {
        return null;
    }

    /**
     * The maximum retention period that the vault retains its recovery points.
     * <p>
     * If this parameter is specified, any backup or copy job to the vault must
     * have a lifecycle policy with a retention period equal to or shorter than
     * the maximum retention period. If the job's retention period is longer than
     * that maximum retention period, then the vault fails the backup or copy job,
     * and you should either modify your lifecycle settings or use a different
     * vault. Recovery points already saved in the vault prior to Vault Lock are
     * not affected.
     * <p>
     * Default: - Vault Lock does not enforce a maximum retention period
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMaxRetention() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LockConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LockConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LockConfiguration> {
        software.amazon.awscdk.Duration minRetention;
        software.amazon.awscdk.Duration changeableFor;
        software.amazon.awscdk.Duration maxRetention;

        /**
         * Sets the value of {@link LockConfiguration#getMinRetention}
         * @param minRetention The minimum retention period that the vault retains its recovery points. This parameter is required.
         *                     If this parameter is specified, any backup or copy job to the vault must
         *                     have a lifecycle policy with a retention period equal to or longer than
         *                     the minimum retention period. If the job's retention period is shorter than
         *                     that minimum retention period, then the vault fails that backup or copy job,
         *                     and you should either modify your lifecycle settings or use a different
         *                     vault. Recovery points already saved in the vault prior to Vault Lock are
         *                     not affected.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minRetention(software.amazon.awscdk.Duration minRetention) {
            this.minRetention = minRetention;
            return this;
        }

        /**
         * Sets the value of {@link LockConfiguration#getChangeableFor}
         * @param changeableFor The duration before the lock date.
         *                      AWS Backup enforces a 72-hour cooling-off period before Vault Lock takes
         *                      effect and becomes immutable.
         *                      <p>
         *                      Before the lock date, you can delete Vault Lock from the vault or change
         *                      the Vault Lock configuration. On and after the lock date, the Vault Lock
         *                      becomes immutable and cannot be changed or deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder changeableFor(software.amazon.awscdk.Duration changeableFor) {
            this.changeableFor = changeableFor;
            return this;
        }

        /**
         * Sets the value of {@link LockConfiguration#getMaxRetention}
         * @param maxRetention The maximum retention period that the vault retains its recovery points.
         *                     If this parameter is specified, any backup or copy job to the vault must
         *                     have a lifecycle policy with a retention period equal to or shorter than
         *                     the maximum retention period. If the job's retention period is longer than
         *                     that maximum retention period, then the vault fails the backup or copy job,
         *                     and you should either modify your lifecycle settings or use a different
         *                     vault. Recovery points already saved in the vault prior to Vault Lock are
         *                     not affected.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRetention(software.amazon.awscdk.Duration maxRetention) {
            this.maxRetention = maxRetention;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LockConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LockConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LockConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LockConfiguration {
        private final software.amazon.awscdk.Duration minRetention;
        private final software.amazon.awscdk.Duration changeableFor;
        private final software.amazon.awscdk.Duration maxRetention;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.minRetention = software.amazon.jsii.Kernel.get(this, "minRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.changeableFor = software.amazon.jsii.Kernel.get(this, "changeableFor", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.maxRetention = software.amazon.jsii.Kernel.get(this, "maxRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.minRetention = java.util.Objects.requireNonNull(builder.minRetention, "minRetention is required");
            this.changeableFor = builder.changeableFor;
            this.maxRetention = builder.maxRetention;
        }

        @Override
        public final software.amazon.awscdk.Duration getMinRetention() {
            return this.minRetention;
        }

        @Override
        public final software.amazon.awscdk.Duration getChangeableFor() {
            return this.changeableFor;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxRetention() {
            return this.maxRetention;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("minRetention", om.valueToTree(this.getMinRetention()));
            if (this.getChangeableFor() != null) {
                data.set("changeableFor", om.valueToTree(this.getChangeableFor()));
            }
            if (this.getMaxRetention() != null) {
                data.set("maxRetention", om.valueToTree(this.getMaxRetention()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.LockConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LockConfiguration.Jsii$Proxy that = (LockConfiguration.Jsii$Proxy) o;

            if (!minRetention.equals(that.minRetention)) return false;
            if (this.changeableFor != null ? !this.changeableFor.equals(that.changeableFor) : that.changeableFor != null) return false;
            return this.maxRetention != null ? this.maxRetention.equals(that.maxRetention) : that.maxRetention == null;
        }

        @Override
        public final int hashCode() {
            int result = this.minRetention.hashCode();
            result = 31 * result + (this.changeableFor != null ? this.changeableFor.hashCode() : 0);
            result = 31 * result + (this.maxRetention != null ? this.maxRetention.hashCode() : 0);
            return result;
        }
    }
}
