package software.amazon.awscdk.services.backup;

/**
 * A resource to backup.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * BackupPlan plan;
 * Vpc vpc;
 * ITable myTable = Table.fromTableName(this, "Table", "myTableName");
 * DatabaseInstance myDatabaseInstance = DatabaseInstance.Builder.create(this, "DatabaseInstance")
 *         .engine(DatabaseInstanceEngine.mysql(MySqlInstanceEngineProps.builder().version(MysqlEngineVersion.VER_8_0_26).build()))
 *         .vpc(vpc)
 *         .build();
 * DatabaseCluster myDatabaseCluster = DatabaseCluster.Builder.create(this, "DatabaseCluster")
 *         .engine(DatabaseClusterEngine.auroraMysql(AuroraMysqlClusterEngineProps.builder().version(AuroraMysqlEngineVersion.VER_2_08_1).build()))
 *         .credentials(Credentials.fromGeneratedSecret("clusteradmin"))
 *         .instanceProps(InstanceProps.builder()
 *                 .vpc(vpc)
 *                 .build())
 *         .build();
 * ServerlessCluster myServerlessCluster = ServerlessCluster.Builder.create(this, "ServerlessCluster")
 *         .engine(DatabaseClusterEngine.AURORA_POSTGRESQL)
 *         .parameterGroup(ParameterGroup.fromParameterGroupName(this, "ParameterGroup", "default.aurora-postgresql10"))
 *         .vpc(vpc)
 *         .build();
 * Construct myCoolConstruct = new Construct(this, "MyCoolConstruct");
 * plan.addSelection("Selection", BackupSelectionOptions.builder()
 *         .resources(List.of(BackupResource.fromDynamoDbTable(myTable), BackupResource.fromRdsDatabaseInstance(myDatabaseInstance), BackupResource.fromRdsDatabaseCluster(myDatabaseCluster), BackupResource.fromRdsServerlessCluster(myServerlessCluster), BackupResource.fromTag("stage", "prod"), BackupResource.fromConstruct(myCoolConstruct)))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:09.283Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.BackupResource")
public class BackupResource extends software.amazon.jsii.JsiiObject {

    protected BackupResource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BackupResource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param resource
     * @param tagCondition
     * @param construct
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BackupResource(final @org.jetbrains.annotations.Nullable java.lang.String resource, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.TagCondition tagCondition, final @org.jetbrains.annotations.Nullable software.constructs.Construct construct) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { resource, tagCondition, construct });
    }

    /**
     * @param resource
     * @param tagCondition
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BackupResource(final @org.jetbrains.annotations.Nullable java.lang.String resource, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.TagCondition tagCondition) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { resource, tagCondition });
    }

    /**
     * @param resource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BackupResource(final @org.jetbrains.annotations.Nullable java.lang.String resource) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { resource });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BackupResource() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * A list of ARNs or match patterns such as `arn:aws:ec2:us-east-1:123456789012:volume/*`.
     * <p>
     * @param arn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupResource fromArn(final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupResource.class, "fromArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupResource.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Adds all supported resources in a construct.
     * <p>
     * @param construct The construct containing resources to backup. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupResource fromConstruct(final @org.jetbrains.annotations.NotNull software.constructs.Construct construct) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupResource.class, "fromConstruct", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupResource.class), new Object[] { java.util.Objects.requireNonNull(construct, "construct is required") });
    }

    /**
     * A DynamoDB table.
     * <p>
     * @param table This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupResource fromDynamoDbTable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITable table) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupResource.class, "fromDynamoDbTable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupResource.class), new Object[] { java.util.Objects.requireNonNull(table, "table is required") });
    }

    /**
     * An EC2 instance.
     * <p>
     * @param instance This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupResource fromEc2Instance(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IInstance instance) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupResource.class, "fromEc2Instance", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupResource.class), new Object[] { java.util.Objects.requireNonNull(instance, "instance is required") });
    }

    /**
     * An EFS file system.
     * <p>
     * @param fileSystem This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupResource fromEfsFileSystem(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.IFileSystem fileSystem) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupResource.class, "fromEfsFileSystem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupResource.class), new Object[] { java.util.Objects.requireNonNull(fileSystem, "fileSystem is required") });
    }

    /**
     * A RDS database cluter.
     * <p>
     * @param cluster This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupResource fromRdsDatabaseCluster(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IDatabaseCluster cluster) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupResource.class, "fromRdsDatabaseCluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupResource.class), new Object[] { java.util.Objects.requireNonNull(cluster, "cluster is required") });
    }

    /**
     * A RDS database instance.
     * <p>
     * @param instance This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupResource fromRdsDatabaseInstance(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IDatabaseInstance instance) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupResource.class, "fromRdsDatabaseInstance", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupResource.class), new Object[] { java.util.Objects.requireNonNull(instance, "instance is required") });
    }

    /**
     * An Aurora database instance.
     * <p>
     * @param cluster This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupResource fromRdsServerlessCluster(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IServerlessCluster cluster) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupResource.class, "fromRdsServerlessCluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupResource.class), new Object[] { java.util.Objects.requireNonNull(cluster, "cluster is required") });
    }

    /**
     * A tag condition.
     * <p>
     * @param key This parameter is required.
     * @param value This parameter is required.
     * @param operation
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupResource fromTag(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.String value, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.TagOperation operation) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupResource.class, "fromTag", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupResource.class), new Object[] { java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required"), operation });
    }

    /**
     * A tag condition.
     * <p>
     * @param key This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.BackupResource fromTag(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.backup.BackupResource.class, "fromTag", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupResource.class), new Object[] { java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * A construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.constructs.Construct getConstruct() {
        return software.amazon.jsii.Kernel.get(this, "construct", software.amazon.jsii.NativeType.forClass(software.constructs.Construct.class));
    }

    /**
     * A resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResource() {
        return software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A condition on a tag.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.TagCondition getTagCondition() {
        return software.amazon.jsii.Kernel.get(this, "tagCondition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.TagCondition.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.backup.BackupResource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.backup.BackupResource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param resource
         * @param construct
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String resource, final software.constructs.Construct construct) {
            return new Builder(resource, construct);
        }
        /**
         * @return a new instance of {@link Builder}.
         * @param resource
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String resource) {
            return new Builder(resource, null);
        }
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder(null, null);
        }

        private final java.lang.String resource;
        private final software.constructs.Construct construct;
        private software.amazon.awscdk.services.backup.TagCondition.Builder tagCondition;

        private Builder(final java.lang.String resource, final software.constructs.Construct construct) {
            this.resource = resource;
            this.construct = construct;
        }

        /**
         * The key in a key-value pair.
         * <p>
         * For example, in <code>"ec2:ResourceTag/Department": "accounting"</code>,
         * <code>ec2:ResourceTag/Department</code> is the key.
         * <p>
         * @return {@code this}
         * @param key The key in a key-value pair. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(final java.lang.String key) {
            this.tagCondition().key(key);
            return this;
        }

        /**
         * The value in a key-value pair.
         * <p>
         * For example, in <code>"ec2:ResourceTag/Department": "accounting"</code>,
         * <code>accounting</code> is the value.
         * <p>
         * @return {@code this}
         * @param value The value in a key-value pair. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(final java.lang.String value) {
            this.tagCondition().value(value);
            return this;
        }

        /**
         * An operation that is applied to a key-value pair used to filter resources in a selection.
         * <p>
         * Default: STRING_EQUALS
         * <p>
         * @return {@code this}
         * @param operation An operation that is applied to a key-value pair used to filter resources in a selection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operation(final software.amazon.awscdk.services.backup.TagOperation operation) {
            this.tagCondition().operation(operation);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.backup.BackupResource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.backup.BackupResource build() {
            return new software.amazon.awscdk.services.backup.BackupResource(
                this.resource,
                this.tagCondition != null ? this.tagCondition.build() : null,
                this.construct
            );
        }

        private software.amazon.awscdk.services.backup.TagCondition.Builder tagCondition() {
            if (this.tagCondition == null) {
                this.tagCondition = new software.amazon.awscdk.services.backup.TagCondition.Builder();
            }
            return this.tagCondition;
        }
    }
}
