package software.amazon.awscdk.services.autoscaling;

/**
 * Block device.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * BlockDeviceVolume blockDeviceVolume;
 * BlockDevice blockDevice = BlockDevice.builder()
 *         .deviceName("deviceName")
 *         .volume(blockDeviceVolume)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:09.154Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.BlockDevice")
@software.amazon.jsii.Jsii.Proxy(BlockDevice.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BlockDevice extends software.amazon.jsii.JsiiSerializable {

    /**
     * The device name exposed to the EC2 instance.
     * <p>
     * Supply a value like <code>/dev/sdh</code>, <code>xvdh</code>.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeviceName();

    /**
     * Defines the block device volume, to be either an Amazon EBS volume or an ephemeral instance store volume.
     * <p>
     * Supply a value like <code>BlockDeviceVolume.ebs(15)</code>, <code>BlockDeviceVolume.ephemeral(0)</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.BlockDeviceVolume getVolume();

    /**
     * @return a {@link Builder} of {@link BlockDevice}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BlockDevice}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BlockDevice> {
        java.lang.String deviceName;
        software.amazon.awscdk.services.autoscaling.BlockDeviceVolume volume;

        /**
         * Sets the value of {@link BlockDevice#getDeviceName}
         * @param deviceName The device name exposed to the EC2 instance. This parameter is required.
         *                   Supply a value like <code>/dev/sdh</code>, <code>xvdh</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceName(java.lang.String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        /**
         * Sets the value of {@link BlockDevice#getVolume}
         * @param volume Defines the block device volume, to be either an Amazon EBS volume or an ephemeral instance store volume. This parameter is required.
         *               Supply a value like <code>BlockDeviceVolume.ebs(15)</code>, <code>BlockDeviceVolume.ephemeral(0)</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volume(software.amazon.awscdk.services.autoscaling.BlockDeviceVolume volume) {
            this.volume = volume;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BlockDevice}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BlockDevice build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BlockDevice}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlockDevice {
        private final java.lang.String deviceName;
        private final software.amazon.awscdk.services.autoscaling.BlockDeviceVolume volume;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deviceName = software.amazon.jsii.Kernel.get(this, "deviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volume = software.amazon.jsii.Kernel.get(this, "volume", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.BlockDeviceVolume.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deviceName = java.util.Objects.requireNonNull(builder.deviceName, "deviceName is required");
            this.volume = java.util.Objects.requireNonNull(builder.volume, "volume is required");
        }

        @Override
        public final java.lang.String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.BlockDeviceVolume getVolume() {
            return this.volume;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deviceName", om.valueToTree(this.getDeviceName()));
            data.set("volume", om.valueToTree(this.getVolume()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.BlockDevice"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BlockDevice.Jsii$Proxy that = (BlockDevice.Jsii$Proxy) o;

            if (!deviceName.equals(that.deviceName)) return false;
            return this.volume.equals(that.volume);
        }

        @Override
        public final int hashCode() {
            int result = this.deviceName.hashCode();
            result = 31 * result + (this.volume.hashCode());
            return result;
        }
    }
}
