package software.amazon.awscdk.pipelines;

/**
 * Deployment of a single Stack.
 * <p>
 * You don't need to instantiate this class -- it will
 * be automatically instantiated as necessary when you
 * add a <code>Stage</code> to a pipeline.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cxapi.*;
 * import software.amazon.awscdk.pipelines.*;
 * CloudFormationStackArtifact cloudFormationStackArtifact;
 * StackDeployment stackDeployment = StackDeployment.fromArtifact(cloudFormationStackArtifact);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:15.785Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.StackDeployment")
public class StackDeployment extends software.amazon.jsii.JsiiObject {

    protected StackDeployment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StackDeployment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Build a `StackDeployment` from a Stack Artifact in a Cloud Assembly.
     * <p>
     * @param stackArtifact This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.StackDeployment fromArtifact(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cxapi.CloudFormationStackArtifact stackArtifact) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.pipelines.StackDeployment.class, "fromArtifact", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StackDeployment.class), new Object[] { java.util.Objects.requireNonNull(stackArtifact, "stackArtifact is required") });
    }

    /**
     * Add a dependency on another stack.
     * <p>
     * @param stackDeployment This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addStackDependency(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.StackDeployment stackDeployment) {
        software.amazon.jsii.Kernel.call(this, "addStackDependency", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stackDeployment, "stackDeployment is required") });
    }

    /**
     * Adds steps to each phase of the stack.
     * <p>
     * @param pre steps executed before stack.prepare. This parameter is required.
     * @param changeSet steps executed after stack.prepare and before stack.deploy. This parameter is required.
     * @param post steps executed after stack.deploy. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addStackSteps(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.Step> pre, final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.Step> changeSet, final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.Step> post) {
        software.amazon.jsii.Kernel.call(this, "addStackSteps", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(pre, "pre is required"), java.util.Objects.requireNonNull(changeSet, "changeSet is required"), java.util.Objects.requireNonNull(post, "post is required") });
    }

    /**
     * Template path on disk to CloudAssembly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAbsoluteTemplatePath() {
        return software.amazon.jsii.Kernel.get(this, "absoluteTemplatePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Assets referenced by this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.StackAsset> getAssets() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "assets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StackAsset.class))));
    }

    /**
     * Steps that take place after stack is prepared but before stack deploys.
     * <p>
     * Your pipeline engine may not disable <code>prepareStep</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.Step> getChangeSet() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "changeSet", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class))));
    }

    /**
     * Construct path for this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConstructPath() {
        return software.amazon.jsii.Kernel.get(this, "constructPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Steps to execute after stack deploys.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.Step> getPost() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "post", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class))));
    }

    /**
     * Steps that take place before stack is prepared.
     * <p>
     * If your pipeline engine disables 'prepareStep', then this will happen before stack deploys
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.Step> getPre() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "pre", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class))));
    }

    /**
     * Artifact ID for this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStackArtifactId() {
        return software.amazon.jsii.Kernel.get(this, "stackArtifactId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Other stacks this stack depends on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.pipelines.StackDeployment> getStackDependencies() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "stackDependencies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StackDeployment.class))));
    }

    /**
     * Name for this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStackName() {
        return software.amazon.jsii.Kernel.get(this, "stackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tags to apply to the stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Account where the stack should be deployed.
     * <p>
     * Default: - Pipeline account
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAccount() {
        return software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Role to assume before deploying this stack.
     * <p>
     * Default: - Don't assume any role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAssumeRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "assumeRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Execution role to pass to CloudFormation.
     * <p>
     * Default: - No execution role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Region where the stack should be deployed.
     * <p>
     * Default: - Pipeline region
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The asset that represents the CloudFormation template for this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.StackAsset getTemplateAsset() {
        return software.amazon.jsii.Kernel.get(this, "templateAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.StackAsset.class));
    }

    /**
     * The S3 URL which points to the template asset location in the publishing bucket.
     * <p>
     * This is <code>undefined</code> if the stack template is not published. Use the
     * <code>DefaultStackSynthesizer</code> to ensure it is.
     * <p>
     * Example value: <code>https://bucket.s3.amazonaws.com/object/key</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTemplateUrl() {
        return software.amazon.jsii.Kernel.get(this, "templateUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
