/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.rds.IInstanceEngine;
import software.amazon.awscdk.services.rds.IOptionGroup;
import software.amazon.awscdk.services.rds.OptionConfiguration;
import software.amazon.awscdk.services.rds.OptionGroupProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_rds.OptionGroup")
public class OptionGroup
extends Resource
implements IOptionGroup {
    protected OptionGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected OptionGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public OptionGroup(@NotNull Construct scope, @NotNull String id, @NotNull OptionGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IOptionGroup fromOptionGroupName(@NotNull Construct scope, @NotNull String id, @NotNull String optionGroupName) {
        return (IOptionGroup)JsiiObject.jsiiStaticCall(OptionGroup.class, (String)"fromOptionGroupName", (NativeType)NativeType.forClass(IOptionGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(optionGroupName, "optionGroupName is required")});
    }

    @Override
    @NotNull
    public Boolean addConfiguration(@NotNull OptionConfiguration configuration) {
        return (Boolean)Kernel.call((Object)this, (String)"addConfiguration", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(configuration, "configuration is required")});
    }

    @NotNull
    public Map<String, Connections> getOptionConnections() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"optionConnections", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Connections.class))));
    }

    @Override
    @NotNull
    public String getOptionGroupName() {
        return (String)Kernel.get((Object)this, (String)"optionGroupName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<OptionGroup> {
        private final Construct scope;
        private final String id;
        private final OptionGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new OptionGroupProps.Builder();
        }

        public Builder configurations(List<? extends OptionConfiguration> configurations) {
            this.props.configurations(configurations);
            return this;
        }

        public Builder engine(IInstanceEngine engine) {
            this.props.engine(engine);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public OptionGroup build() {
            return new OptionGroup(this.scope, this.id, this.props.build());
        }
    }
}

