package software.amazon.awscdk.services.stepfunctions;

/**
 * Define a Fail state in the state machine.
 * <p>
 * Reaching a Fail state terminates the state execution in failure.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function submitLambda;
 * Function getStatusLambda;
 * LambdaInvoke submitJob = LambdaInvoke.Builder.create(this, "Submit Job")
 *         .lambdaFunction(submitLambda)
 *         // Lambda's result is in the attribute `Payload`
 *         .outputPath("$.Payload")
 *         .build();
 * Wait waitX = Wait.Builder.create(this, "Wait X Seconds")
 *         .time(WaitTime.secondsPath("$.waitSeconds"))
 *         .build();
 * LambdaInvoke getStatus = LambdaInvoke.Builder.create(this, "Get Job Status")
 *         .lambdaFunction(getStatusLambda)
 *         // Pass just the field named "guid" into the Lambda, put the
 *         // Lambda's result in a field called "status" in the response
 *         .inputPath("$.guid")
 *         .outputPath("$.Payload")
 *         .build();
 * Fail jobFailed = Fail.Builder.create(this, "Job Failed")
 *         .cause("AWS Batch Job Failed")
 *         .error("DescribeJob returned FAILED")
 *         .build();
 * LambdaInvoke finalStatus = LambdaInvoke.Builder.create(this, "Get Final Job Status")
 *         .lambdaFunction(getStatusLambda)
 *         // Use "guid" field as input
 *         .inputPath("$.guid")
 *         .outputPath("$.Payload")
 *         .build();
 * Chain definition = submitJob.next(waitX).next(getStatus).next(new Choice(this, "Job Complete?").when(Condition.stringEquals("$.status", "FAILED"), jobFailed).when(Condition.stringEquals("$.status", "SUCCEEDED"), finalStatus).otherwise(waitX));
 * StateMachine.Builder.create(this, "StateMachine")
 *         .definition(definition)
 *         .timeout(Duration.minutes(5))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:54.652Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.Fail")
public class Fail extends software.amazon.awscdk.services.stepfunctions.State {

    protected Fail(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Fail(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Fail(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.FailProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Fail(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Return the Amazon States Language object for this state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson() {
        return software.amazon.jsii.Kernel.call(this, "toStateJson", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class));
    }

    /**
     * Continuable states of this Chainable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "endStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.INextable.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.Fail}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.Fail> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.stepfunctions.FailProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A description for the cause of the failure.
         * <p>
         * Default: No description
         * <p>
         * @return {@code this}
         * @param cause A description for the cause of the failure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cause(final java.lang.String cause) {
            this.props().cause(cause);
            return this;
        }

        /**
         * An optional description for this state.
         * <p>
         * Default: No comment
         * <p>
         * @return {@code this}
         * @param comment An optional description for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props().comment(comment);
            return this;
        }

        /**
         * Error code used to represent this failure.
         * <p>
         * Default: No error code
         * <p>
         * @return {@code this}
         * @param error Error code used to represent this failure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder error(final java.lang.String error) {
            this.props().error(error);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.Fail}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.Fail build() {
            return new software.amazon.awscdk.services.stepfunctions.Fail(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.stepfunctions.FailProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.stepfunctions.FailProps.Builder();
            }
            return this.props;
        }
    }
}
