package software.amazon.awscdk.services.sqs;

/**
 * Properties for defining a `CfnQueuePolicy`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sqs.*;
 * Object policyDocument;
 * CfnQueuePolicyProps cfnQueuePolicyProps = CfnQueuePolicyProps.builder()
 *         .policyDocument(policyDocument)
 *         .queues(List.of("queues"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:54.529Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sqs.CfnQueuePolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnQueuePolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnQueuePolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A policy document that contains the permissions for the specified Amazon SQS queues.
     * <p>
     * For more information about Amazon SQS policies, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-creating-custom-policies.html">Using custom policies with the Amazon SQS access policy language</a> in the <em>Amazon SQS Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getPolicyDocument();

    /**
     * The URLs of the queues to which you want to add the policy.
     * <p>
     * You can use the <code>[Ref](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html)</code> function to specify an <code>[AWS::SQS::Queue](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html)</code> resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getQueues();

    /**
     * @return a {@link Builder} of {@link CfnQueuePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnQueuePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnQueuePolicyProps> {
        java.lang.Object policyDocument;
        java.util.List<java.lang.String> queues;

        /**
         * Sets the value of {@link CfnQueuePolicyProps#getPolicyDocument}
         * @param policyDocument A policy document that contains the permissions for the specified Amazon SQS queues. This parameter is required.
         *                       For more information about Amazon SQS policies, see <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-creating-custom-policies.html">Using custom policies with the Amazon SQS access policy language</a> in the <em>Amazon SQS Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDocument(java.lang.Object policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        /**
         * Sets the value of {@link CfnQueuePolicyProps#getQueues}
         * @param queues The URLs of the queues to which you want to add the policy. This parameter is required.
         *               You can use the <code>[Ref](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-ref.html)</code> function to specify an <code>[AWS::SQS::Queue](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html)</code> resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queues(java.util.List<java.lang.String> queues) {
            this.queues = queues;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnQueuePolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnQueuePolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnQueuePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnQueuePolicyProps {
        private final java.lang.Object policyDocument;
        private final java.util.List<java.lang.String> queues;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.policyDocument = software.amazon.jsii.Kernel.get(this, "policyDocument", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.queues = software.amazon.jsii.Kernel.get(this, "queues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.policyDocument = java.util.Objects.requireNonNull(builder.policyDocument, "policyDocument is required");
            this.queues = java.util.Objects.requireNonNull(builder.queues, "queues is required");
        }

        @Override
        public final java.lang.Object getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final java.util.List<java.lang.String> getQueues() {
            return this.queues;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
            data.set("queues", om.valueToTree(this.getQueues()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sqs.CfnQueuePolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnQueuePolicyProps.Jsii$Proxy that = (CfnQueuePolicyProps.Jsii$Proxy) o;

            if (!policyDocument.equals(that.policyDocument)) return false;
            return this.queues.equals(that.queues);
        }

        @Override
        public final int hashCode() {
            int result = this.policyDocument.hashCode();
            result = 31 * result + (this.queues.hashCode());
            return result;
        }
    }
}
