package software.amazon.awscdk.services.secretsmanager;

/**
 * Options to add a rotation schedule to a secret.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function fn;
 * Secret secret = new Secret(this, "Secret");
 * secret.addRotationSchedule("RotationSchedule", RotationScheduleOptions.builder()
 *         .rotationLambda(fn)
 *         .automaticallyAfter(Duration.days(15))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:54.319Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.RotationScheduleOptions")
@software.amazon.jsii.Jsii.Proxy(RotationScheduleOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RotationScheduleOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
     * <p>
     * A value of zero will disable automatic rotation - <code>Duration.days(0)</code>.
     * <p>
     * Default: Duration.days(30)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getAutomaticallyAfter() {
        return null;
    }

    /**
     * Hosted rotation.
     * <p>
     * Default: - either `rotationLambda` or `hostedRotation` must be specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.HostedRotation getHostedRotation() {
        return null;
    }

    /**
     * A Lambda function that can rotate the secret.
     * <p>
     * Default: - either `rotationLambda` or `hostedRotation` must be specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.IFunction getRotationLambda() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RotationScheduleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RotationScheduleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RotationScheduleOptions> {
        software.amazon.awscdk.Duration automaticallyAfter;
        software.amazon.awscdk.services.secretsmanager.HostedRotation hostedRotation;
        software.amazon.awscdk.services.lambda.IFunction rotationLambda;

        /**
         * Sets the value of {@link RotationScheduleOptions#getAutomaticallyAfter}
         * @param automaticallyAfter Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
         *                           A value of zero will disable automatic rotation - <code>Duration.days(0)</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticallyAfter(software.amazon.awscdk.Duration automaticallyAfter) {
            this.automaticallyAfter = automaticallyAfter;
            return this;
        }

        /**
         * Sets the value of {@link RotationScheduleOptions#getHostedRotation}
         * @param hostedRotation Hosted rotation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedRotation(software.amazon.awscdk.services.secretsmanager.HostedRotation hostedRotation) {
            this.hostedRotation = hostedRotation;
            return this;
        }

        /**
         * Sets the value of {@link RotationScheduleOptions#getRotationLambda}
         * @param rotationLambda A Lambda function that can rotate the secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationLambda(software.amazon.awscdk.services.lambda.IFunction rotationLambda) {
            this.rotationLambda = rotationLambda;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RotationScheduleOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RotationScheduleOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RotationScheduleOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RotationScheduleOptions {
        private final software.amazon.awscdk.Duration automaticallyAfter;
        private final software.amazon.awscdk.services.secretsmanager.HostedRotation hostedRotation;
        private final software.amazon.awscdk.services.lambda.IFunction rotationLambda;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.automaticallyAfter = software.amazon.jsii.Kernel.get(this, "automaticallyAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.hostedRotation = software.amazon.jsii.Kernel.get(this, "hostedRotation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.HostedRotation.class));
            this.rotationLambda = software.amazon.jsii.Kernel.get(this, "rotationLambda", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.automaticallyAfter = builder.automaticallyAfter;
            this.hostedRotation = builder.hostedRotation;
            this.rotationLambda = builder.rotationLambda;
        }

        @Override
        public final software.amazon.awscdk.Duration getAutomaticallyAfter() {
            return this.automaticallyAfter;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.HostedRotation getHostedRotation() {
            return this.hostedRotation;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getRotationLambda() {
            return this.rotationLambda;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAutomaticallyAfter() != null) {
                data.set("automaticallyAfter", om.valueToTree(this.getAutomaticallyAfter()));
            }
            if (this.getHostedRotation() != null) {
                data.set("hostedRotation", om.valueToTree(this.getHostedRotation()));
            }
            if (this.getRotationLambda() != null) {
                data.set("rotationLambda", om.valueToTree(this.getRotationLambda()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_secretsmanager.RotationScheduleOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RotationScheduleOptions.Jsii$Proxy that = (RotationScheduleOptions.Jsii$Proxy) o;

            if (this.automaticallyAfter != null ? !this.automaticallyAfter.equals(that.automaticallyAfter) : that.automaticallyAfter != null) return false;
            if (this.hostedRotation != null ? !this.hostedRotation.equals(that.hostedRotation) : that.hostedRotation != null) return false;
            return this.rotationLambda != null ? this.rotationLambda.equals(that.rotationLambda) : that.rotationLambda == null;
        }

        @Override
        public final int hashCode() {
            int result = this.automaticallyAfter != null ? this.automaticallyAfter.hashCode() : 0;
            result = 31 * result + (this.hostedRotation != null ? this.hostedRotation.hashCode() : 0);
            result = 31 * result + (this.rotationLambda != null ? this.rotationLambda.hashCode() : 0);
            return result;
        }
    }
}
