package software.amazon.awscdk.services.secretsmanager;

/**
 * A rotation schedule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.secretsmanager.*;
 * Function function_;
 * HostedRotation hostedRotation;
 * Secret secret;
 * RotationSchedule rotationSchedule = RotationSchedule.Builder.create(this, "MyRotationSchedule")
 *         .secret(secret)
 *         // the properties below are optional
 *         .automaticallyAfter(Duration.minutes(30))
 *         .hostedRotation(hostedRotation)
 *         .rotationLambda(function_)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:54.318Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.RotationSchedule")
public class RotationSchedule extends software.amazon.awscdk.Resource {

    protected RotationSchedule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RotationSchedule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RotationSchedule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.RotationScheduleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.secretsmanager.RotationSchedule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.secretsmanager.RotationSchedule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.secretsmanager.RotationScheduleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.secretsmanager.RotationScheduleProps.Builder();
        }

        /**
         * Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
         * <p>
         * A value of zero will disable automatic rotation - <code>Duration.days(0)</code>.
         * <p>
         * Default: Duration.days(30)
         * <p>
         * @return {@code this}
         * @param automaticallyAfter Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticallyAfter(final software.amazon.awscdk.Duration automaticallyAfter) {
            this.props.automaticallyAfter(automaticallyAfter);
            return this;
        }

        /**
         * Hosted rotation.
         * <p>
         * Default: - either `rotationLambda` or `hostedRotation` must be specified
         * <p>
         * @return {@code this}
         * @param hostedRotation Hosted rotation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedRotation(final software.amazon.awscdk.services.secretsmanager.HostedRotation hostedRotation) {
            this.props.hostedRotation(hostedRotation);
            return this;
        }

        /**
         * A Lambda function that can rotate the secret.
         * <p>
         * Default: - either `rotationLambda` or `hostedRotation` must be specified
         * <p>
         * @return {@code this}
         * @param rotationLambda A Lambda function that can rotate the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotationLambda(final software.amazon.awscdk.services.lambda.IFunction rotationLambda) {
            this.props.rotationLambda(rotationLambda);
            return this;
        }

        /**
         * The secret to rotate.
         * <p>
         * If hosted rotation is used, this must be a JSON string with the following format:
         * <p>
         * <blockquote><pre>
         * {
         *    "engine": &lt;required: database engine&gt;,
         *    "host": &lt;required: instance host name&gt;,
         *    "username": &lt;required: username&gt;,
         *    "password": &lt;required: password&gt;,
         *    "dbname": &lt;optional: database name&gt;,
         *    "port": &lt;optional: if not specified, default port will be used&gt;,
         *    "masterarn": &lt;required for multi user rotation: the arn of the master secret which will be used to create users/change passwords&gt;
         * }
         * </pre></blockquote>
         * <p>
         * This is typically the case for a secret referenced from an <code>AWS::SecretsManager::SecretTargetAttachment</code>
         * or an <code>ISecret</code> returned by the <code>attach()</code> method of <code>Secret</code>.
         * <p>
         * @return {@code this}
         * @param secret The secret to rotate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(final software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.props.secret(secret);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.secretsmanager.RotationSchedule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.secretsmanager.RotationSchedule build() {
            return new software.amazon.awscdk.services.secretsmanager.RotationSchedule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
