package software.amazon.awscdk.services.route53;

/**
 * Construction properties for a RecordSet.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.route53.*;
 * HostedZone hostedZone;
 * RecordTarget recordTarget;
 * RecordSetProps recordSetProps = RecordSetProps.builder()
 *         .recordType(RecordType.A)
 *         .target(recordTarget)
 *         .zone(hostedZone)
 *         // the properties below are optional
 *         .comment("comment")
 *         .deleteExisting(false)
 *         .recordName("recordName")
 *         .ttl(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:53.961Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.RecordSetProps")
@software.amazon.jsii.Jsii.Proxy(RecordSetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RecordSetProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.route53.RecordSetOptions {

    /**
     * The record type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.RecordType getRecordType();

    /**
     * The target for this record, either `RecordTarget.fromValues()` or `RecordTarget.fromAlias()`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.RecordTarget getTarget();

    /**
     * @return a {@link Builder} of {@link RecordSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RecordSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RecordSetProps> {
        software.amazon.awscdk.services.route53.RecordType recordType;
        software.amazon.awscdk.services.route53.RecordTarget target;
        software.amazon.awscdk.services.route53.IHostedZone zone;
        java.lang.String comment;
        java.lang.Boolean deleteExisting;
        java.lang.String recordName;
        software.amazon.awscdk.Duration ttl;

        /**
         * Sets the value of {@link RecordSetProps#getRecordType}
         * @param recordType The record type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordType(software.amazon.awscdk.services.route53.RecordType recordType) {
            this.recordType = recordType;
            return this;
        }

        /**
         * Sets the value of {@link RecordSetProps#getTarget}
         * @param target The target for this record, either `RecordTarget.fromValues()` or `RecordTarget.fromAlias()`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(software.amazon.awscdk.services.route53.RecordTarget target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link RecordSetProps#getZone}
         * @param zone The hosted zone in which to define the new record. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zone(software.amazon.awscdk.services.route53.IHostedZone zone) {
            this.zone = zone;
            return this;
        }

        /**
         * Sets the value of {@link RecordSetProps#getComment}
         * @param comment A comment to add on the record.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link RecordSetProps#getDeleteExisting}
         * @param deleteExisting Whether to delete the same record set in the hosted zone if it already exists.
         *                       This allows to deploy a new record set while minimizing the downtime because the
         *                       new record set will be created immediately after the existing one is deleted. It
         *                       also avoids "manual" actions to delete existing record sets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteExisting(java.lang.Boolean deleteExisting) {
            this.deleteExisting = deleteExisting;
            return this;
        }

        /**
         * Sets the value of {@link RecordSetProps#getRecordName}
         * @param recordName The domain name for this record.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordName(java.lang.String recordName) {
            this.recordName = recordName;
            return this;
        }

        /**
         * Sets the value of {@link RecordSetProps#getTtl}
         * @param ttl The resource record cache time to live (TTL).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttl(software.amazon.awscdk.Duration ttl) {
            this.ttl = ttl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RecordSetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RecordSetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RecordSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecordSetProps {
        private final software.amazon.awscdk.services.route53.RecordType recordType;
        private final software.amazon.awscdk.services.route53.RecordTarget target;
        private final software.amazon.awscdk.services.route53.IHostedZone zone;
        private final java.lang.String comment;
        private final java.lang.Boolean deleteExisting;
        private final java.lang.String recordName;
        private final software.amazon.awscdk.Duration ttl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.recordType = software.amazon.jsii.Kernel.get(this, "recordType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.RecordType.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.RecordTarget.class));
            this.zone = software.amazon.jsii.Kernel.get(this, "zone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deleteExisting = software.amazon.jsii.Kernel.get(this, "deleteExisting", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.recordName = software.amazon.jsii.Kernel.get(this, "recordName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ttl = software.amazon.jsii.Kernel.get(this, "ttl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.recordType = java.util.Objects.requireNonNull(builder.recordType, "recordType is required");
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
            this.zone = java.util.Objects.requireNonNull(builder.zone, "zone is required");
            this.comment = builder.comment;
            this.deleteExisting = builder.deleteExisting;
            this.recordName = builder.recordName;
            this.ttl = builder.ttl;
        }

        @Override
        public final software.amazon.awscdk.services.route53.RecordType getRecordType() {
            return this.recordType;
        }

        @Override
        public final software.amazon.awscdk.services.route53.RecordTarget getTarget() {
            return this.target;
        }

        @Override
        public final software.amazon.awscdk.services.route53.IHostedZone getZone() {
            return this.zone;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.Boolean getDeleteExisting() {
            return this.deleteExisting;
        }

        @Override
        public final java.lang.String getRecordName() {
            return this.recordName;
        }

        @Override
        public final software.amazon.awscdk.Duration getTtl() {
            return this.ttl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("recordType", om.valueToTree(this.getRecordType()));
            data.set("target", om.valueToTree(this.getTarget()));
            data.set("zone", om.valueToTree(this.getZone()));
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getDeleteExisting() != null) {
                data.set("deleteExisting", om.valueToTree(this.getDeleteExisting()));
            }
            if (this.getRecordName() != null) {
                data.set("recordName", om.valueToTree(this.getRecordName()));
            }
            if (this.getTtl() != null) {
                data.set("ttl", om.valueToTree(this.getTtl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.RecordSetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RecordSetProps.Jsii$Proxy that = (RecordSetProps.Jsii$Proxy) o;

            if (!recordType.equals(that.recordType)) return false;
            if (!target.equals(that.target)) return false;
            if (!zone.equals(that.zone)) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.deleteExisting != null ? !this.deleteExisting.equals(that.deleteExisting) : that.deleteExisting != null) return false;
            if (this.recordName != null ? !this.recordName.equals(that.recordName) : that.recordName != null) return false;
            return this.ttl != null ? this.ttl.equals(that.ttl) : that.ttl == null;
        }

        @Override
        public final int hashCode() {
            int result = this.recordType.hashCode();
            result = 31 * result + (this.target.hashCode());
            result = 31 * result + (this.zone.hashCode());
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.deleteExisting != null ? this.deleteExisting.hashCode() : 0);
            result = 31 * result + (this.recordName != null ? this.recordName.hashCode() : 0);
            result = 31 * result + (this.ttl != null ? this.ttl.hashCode() : 0);
            return result;
        }
    }
}
