package software.amazon.awscdk.services.route53;

/**
 * A DNS CNAME record.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.certificatemanager.*;
 * import software.amazon.awscdk.services.route53.*;
 * // hosted zone and route53 features
 * String hostedZoneId;
 * String zoneName = "example.com";
 * String myDomainName = "api.example.com";
 * Certificate certificate = Certificate.Builder.create(this, "cert").domainName(myDomainName).build();
 * GraphqlApi api = GraphqlApi.Builder.create(this, "api")
 *         .name("myApi")
 *         .domainName(DomainOptions.builder()
 *                 .certificate(certificate)
 *                 .domainName(myDomainName)
 *                 .build())
 *         .build();
 * // hosted zone for adding appsync domain
 * IHostedZone zone = HostedZone.fromHostedZoneAttributes(this, "HostedZone", HostedZoneAttributes.builder()
 *         .hostedZoneId(hostedZoneId)
 *         .zoneName(zoneName)
 *         .build());
 * // create a cname to the appsync domain. will map to something like xxxx.cloudfront.net
 * // create a cname to the appsync domain. will map to something like xxxx.cloudfront.net
 * CnameRecord.Builder.create(this, "CnameApiRecord")
 *         .recordName("api")
 *         .zone(zone)
 *         .domainName(api.getAppSyncDomainName())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:53.947Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CnameRecord")
public class CnameRecord extends software.amazon.awscdk.services.route53.RecordSet {

    protected CnameRecord(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CnameRecord(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CnameRecord(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.CnameRecordProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53.CnameRecord}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53.CnameRecord> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53.CnameRecordProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53.CnameRecordProps.Builder();
        }

        /**
         * The hosted zone in which to define the new record.
         * <p>
         * @return {@code this}
         * @param zone The hosted zone in which to define the new record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zone(final software.amazon.awscdk.services.route53.IHostedZone zone) {
            this.props.zone(zone);
            return this;
        }

        /**
         * A comment to add on the record.
         * <p>
         * Default: no comment
         * <p>
         * @return {@code this}
         * @param comment A comment to add on the record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * Whether to delete the same record set in the hosted zone if it already exists.
         * <p>
         * This allows to deploy a new record set while minimizing the downtime because the
         * new record set will be created immediately after the existing one is deleted. It
         * also avoids "manual" actions to delete existing record sets.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param deleteExisting Whether to delete the same record set in the hosted zone if it already exists. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteExisting(final java.lang.Boolean deleteExisting) {
            this.props.deleteExisting(deleteExisting);
            return this;
        }

        /**
         * The domain name for this record.
         * <p>
         * Default: zone root
         * <p>
         * @return {@code this}
         * @param recordName The domain name for this record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordName(final java.lang.String recordName) {
            this.props.recordName(recordName);
            return this;
        }

        /**
         * The resource record cache time to live (TTL).
         * <p>
         * Default: Duration.minutes(30)
         * <p>
         * @return {@code this}
         * @param ttl The resource record cache time to live (TTL). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttl(final software.amazon.awscdk.Duration ttl) {
            this.props.ttl(ttl);
            return this;
        }

        /**
         * The domain name.
         * <p>
         * @return {@code this}
         * @param domainName The domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.route53.CnameRecord}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53.CnameRecord build() {
            return new software.amazon.awscdk.services.route53.CnameRecord(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
