package software.amazon.awscdk.services.route53;

/**
 * A CloudFormation `AWS::Route53::RecordSet`.
 * <p>
 * Information about the record that you want to create.
 * <p>
 * The <code>AWS::Route53::RecordSet</code> type can be used as a standalone resource or as an embedded property in the <code>AWS::Route53::RecordSetGroup</code> type. Note that some <code>AWS::Route53::RecordSet</code> properties are valid only when used within <code>AWS::Route53::RecordSetGroup</code> .
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html">ChangeResourceRecordSets</a> in the <em>Amazon Route 53 API Reference</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53.*;
 * CfnRecordSet cfnRecordSet = CfnRecordSet.Builder.create(this, "MyCfnRecordSet")
 *         .name("name")
 *         .type("type")
 *         // the properties below are optional
 *         .aliasTarget(AliasTargetProperty.builder()
 *                 .dnsName("dnsName")
 *                 .hostedZoneId("hostedZoneId")
 *                 // the properties below are optional
 *                 .evaluateTargetHealth(false)
 *                 .build())
 *         .cidrRoutingConfig(CidrRoutingConfigProperty.builder()
 *                 .collectionId("collectionId")
 *                 .locationName("locationName")
 *                 .build())
 *         .comment("comment")
 *         .failover("failover")
 *         .geoLocation(GeoLocationProperty.builder()
 *                 .continentCode("continentCode")
 *                 .countryCode("countryCode")
 *                 .subdivisionCode("subdivisionCode")
 *                 .build())
 *         .healthCheckId("healthCheckId")
 *         .hostedZoneId("hostedZoneId")
 *         .hostedZoneName("hostedZoneName")
 *         .multiValueAnswer(false)
 *         .region("region")
 *         .resourceRecords(List.of("resourceRecords"))
 *         .setIdentifier("setIdentifier")
 *         .ttl("ttl")
 *         .weight(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:53.911Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CfnRecordSet")
public class CfnRecordSet extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnRecordSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRecordSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.route53.CfnRecordSet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Route53::RecordSet`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRecordSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.CfnRecordSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * For `ChangeResourceRecordSets` requests, the name of the record that you want to create, update, or delete.
     * <p>
     * For <code>ListResourceRecordSets</code> responses, the name of a record in the specified hosted zone.
     * <p>
     * <em>ChangeResourceRecordSets Only</em>
     * <p>
     * Enter a fully qualified domain name, for example, <code>www.example.com</code> . You can optionally include a trailing dot. If you omit the trailing dot, Amazon Route 53 assumes that the domain name that you specify is fully qualified. This means that Route 53 treats <code>www.example.com</code> (without a trailing dot) and <code>www.example.com.</code> (with a trailing dot) as identical.
     * <p>
     * For information about how to specify characters other than <code>a-z</code> , <code>0-9</code> , and <code>-</code> (hyphen) and how to specify internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a> in the <em>Amazon Route 53 Developer Guide</em> .
     * <p>
     * You can use the asterisk (*) wildcard to replace the leftmost label in a domain name, for example, <code>*.example.com</code> . Note the following:
     * <p>
     * <ul>
     * <li>The * must replace the entire label. For example, you can't specify <code>*prod.example.com</code> or <code>prod*.example.com</code> .</li>
     * <li>The * can't replace any of the middle labels, for example, marketing.*.example.com.</li>
     * <li>If you include * in any position other than the leftmost label in a domain name, DNS treats it as an * character (ASCII 42), not as a wildcard.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * You can't use the * wildcard for resource records sets that have a type of NS.
     * <p>
     * </blockquote>
     * <p>
     * You can use the * wildcard as the leftmost label in a domain name, for example, <code>*.example.com</code> . You can't use an * for one of the middle labels, for example, <code>marketing.*.example.com</code> . In addition, the * must replace the entire label; for example, you can't specify <code>prod*.example.com</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For `ChangeResourceRecordSets` requests, the name of the record that you want to create, update, or delete.
     * <p>
     * For <code>ListResourceRecordSets</code> responses, the name of a record in the specified hosted zone.
     * <p>
     * <em>ChangeResourceRecordSets Only</em>
     * <p>
     * Enter a fully qualified domain name, for example, <code>www.example.com</code> . You can optionally include a trailing dot. If you omit the trailing dot, Amazon Route 53 assumes that the domain name that you specify is fully qualified. This means that Route 53 treats <code>www.example.com</code> (without a trailing dot) and <code>www.example.com.</code> (with a trailing dot) as identical.
     * <p>
     * For information about how to specify characters other than <code>a-z</code> , <code>0-9</code> , and <code>-</code> (hyphen) and how to specify internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a> in the <em>Amazon Route 53 Developer Guide</em> .
     * <p>
     * You can use the asterisk (*) wildcard to replace the leftmost label in a domain name, for example, <code>*.example.com</code> . Note the following:
     * <p>
     * <ul>
     * <li>The * must replace the entire label. For example, you can't specify <code>*prod.example.com</code> or <code>prod*.example.com</code> .</li>
     * <li>The * can't replace any of the middle labels, for example, marketing.*.example.com.</li>
     * <li>If you include * in any position other than the leftmost label in a domain name, DNS treats it as an * character (ASCII 42), not as a wildcard.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * You can't use the * wildcard for resource records sets that have a type of NS.
     * <p>
     * </blockquote>
     * <p>
     * You can use the * wildcard as the leftmost label in a domain name, for example, <code>*.example.com</code> . You can't use an * for one of the middle labels, for example, <code>marketing.*.example.com</code> . In addition, the * must replace the entire label; for example, you can't specify <code>prod*.example.com</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The DNS record type.
     * <p>
     * For information about different record types and how data is encoded for them, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS Resource Record Types</a> in the <em>Amazon Route 53 Developer Guide</em> .
     * <p>
     * Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>DS</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     * <p>
     * Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> . When creating a group of weighted, latency, geolocation, or failover resource record sets, specify the same value for all of the resource record sets in the group.
     * <p>
     * Valid values for multivalue answer resource record sets: <code>A</code> | <code>AAAA</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     * <p>
     * <blockquote>
     * <p>
     * SPF records were formerly used to verify the identity of the sender of email messages. However, we no longer recommend that you create resource record sets for which the value of <code>Type</code> is <code>SPF</code> . RFC 7208, <em>Sender Policy Framework (SPF) for Authorizing Use of Domains in Email, Version 1</em> , has been updated to say, "...[I]ts existence and mechanism defined in [RFC4408] have led to some interoperability issues. Accordingly, its use is no longer appropriate for SPF version 1; implementations are not to use it." In RFC 7208, see section 14.1, <a href="https://docs.aws.amazon.com/http://tools.ietf.org/html/rfc7208#section-14.1">The SPF DNS Record Type</a> .
     * <p>
     * </blockquote>
     * <p>
     * Values for alias resource record sets:
     * <p>
     * <ul>
     * <li><em>Amazon API Gateway custom regional APIs and edge-optimized APIs:</em> <code>A</code></li>
     * <li><em>CloudFront distributions:</em> <code>A</code></li>
     * </ul>
     * <p>
     * If IPv6 is enabled for the distribution, create two resource record sets to route traffic to your distribution, one with a value of <code>A</code> and one with a value of <code>AAAA</code> .
     * <p>
     * <ul>
     * <li><em>Amazon API Gateway environment that has a regionalized subdomain</em> : <code>A</code></li>
     * <li><em>ELB load balancers:</em> <code>A</code> | <code>AAAA</code></li>
     * <li><em>Amazon S3 buckets:</em> <code>A</code></li>
     * <li><em>Amazon Virtual Private Cloud interface VPC endpoints</em> <code>A</code></li>
     * <li><em>Another resource record set in this hosted zone:</em> Specify the type of the resource record set that you're creating the alias for. All values are supported except <code>NS</code> and <code>SOA</code> .</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you're creating an alias record that has the same name as the hosted zone (known as the zone apex), you can't route traffic to a record for which the value of <code>Type</code> is <code>CNAME</code> . This is because the alias record must have the same type as the record you're routing traffic to, and creating a CNAME record for the zone apex isn't supported even for an alias record.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The DNS record type.
     * <p>
     * For information about different record types and how data is encoded for them, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS Resource Record Types</a> in the <em>Amazon Route 53 Developer Guide</em> .
     * <p>
     * Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>DS</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     * <p>
     * Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> . When creating a group of weighted, latency, geolocation, or failover resource record sets, specify the same value for all of the resource record sets in the group.
     * <p>
     * Valid values for multivalue answer resource record sets: <code>A</code> | <code>AAAA</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     * <p>
     * <blockquote>
     * <p>
     * SPF records were formerly used to verify the identity of the sender of email messages. However, we no longer recommend that you create resource record sets for which the value of <code>Type</code> is <code>SPF</code> . RFC 7208, <em>Sender Policy Framework (SPF) for Authorizing Use of Domains in Email, Version 1</em> , has been updated to say, "...[I]ts existence and mechanism defined in [RFC4408] have led to some interoperability issues. Accordingly, its use is no longer appropriate for SPF version 1; implementations are not to use it." In RFC 7208, see section 14.1, <a href="https://docs.aws.amazon.com/http://tools.ietf.org/html/rfc7208#section-14.1">The SPF DNS Record Type</a> .
     * <p>
     * </blockquote>
     * <p>
     * Values for alias resource record sets:
     * <p>
     * <ul>
     * <li><em>Amazon API Gateway custom regional APIs and edge-optimized APIs:</em> <code>A</code></li>
     * <li><em>CloudFront distributions:</em> <code>A</code></li>
     * </ul>
     * <p>
     * If IPv6 is enabled for the distribution, create two resource record sets to route traffic to your distribution, one with a value of <code>A</code> and one with a value of <code>AAAA</code> .
     * <p>
     * <ul>
     * <li><em>Amazon API Gateway environment that has a regionalized subdomain</em> : <code>A</code></li>
     * <li><em>ELB load balancers:</em> <code>A</code> | <code>AAAA</code></li>
     * <li><em>Amazon S3 buckets:</em> <code>A</code></li>
     * <li><em>Amazon Virtual Private Cloud interface VPC endpoints</em> <code>A</code></li>
     * <li><em>Another resource record set in this hosted zone:</em> Specify the type of the resource record set that you're creating the alias for. All values are supported except <code>NS</code> and <code>SOA</code> .</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you're creating an alias record that has the same name as the hosted zone (known as the zone apex), you can't route traffic to a record for which the value of <code>Type</code> is <code>CNAME</code> . This is because the alias record must have the same type as the record you're routing traffic to, and creating a CNAME record for the zone apex isn't supported even for an alias record.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * *Alias resource record sets only:* Information about the AWS resource, such as a CloudFront distribution or an Amazon S3 bucket, that you want to route traffic to.
     * <p>
     * If you're creating resource records sets for a private hosted zone, note the following:
     * <p>
     * <ul>
     * <li>You can't create an alias resource record set in a private hosted zone to route traffic to a CloudFront distribution.</li>
     * <li>Creating geolocation alias resource record sets or latency alias resource record sets in a private hosted zone is unsupported.</li>
     * <li>For information about creating failover resource record sets in a private hosted zone, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAliasTarget() {
        return software.amazon.jsii.Kernel.get(this, "aliasTarget", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * *Alias resource record sets only:* Information about the AWS resource, such as a CloudFront distribution or an Amazon S3 bucket, that you want to route traffic to.
     * <p>
     * If you're creating resource records sets for a private hosted zone, note the following:
     * <p>
     * <ul>
     * <li>You can't create an alias resource record set in a private hosted zone to route traffic to a CloudFront distribution.</li>
     * <li>Creating geolocation alias resource record sets or latency alias resource record sets in a private hosted zone is unsupported.</li>
     * <li>For information about creating failover resource record sets in a private hosted zone, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAliasTarget(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.CfnRecordSet.AliasTargetProperty value) {
        software.amazon.jsii.Kernel.set(this, "aliasTarget", value);
    }

    /**
     * *Alias resource record sets only:* Information about the AWS resource, such as a CloudFront distribution or an Amazon S3 bucket, that you want to route traffic to.
     * <p>
     * If you're creating resource records sets for a private hosted zone, note the following:
     * <p>
     * <ul>
     * <li>You can't create an alias resource record set in a private hosted zone to route traffic to a CloudFront distribution.</li>
     * <li>Creating geolocation alias resource record sets or latency alias resource record sets in a private hosted zone is unsupported.</li>
     * <li>For information about creating failover resource record sets in a private hosted zone, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAliasTarget(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "aliasTarget", value);
    }

    /**
     * `AWS::Route53::RecordSet.CidrRoutingConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCidrRoutingConfig() {
        return software.amazon.jsii.Kernel.get(this, "cidrRoutingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Route53::RecordSet.CidrRoutingConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCidrRoutingConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.CfnRecordSet.CidrRoutingConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "cidrRoutingConfig", value);
    }

    /**
     * `AWS::Route53::RecordSet.CidrRoutingConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCidrRoutingConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cidrRoutingConfig", value);
    }

    /**
     * *Optional:* Any comments you want to include about a change batch request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * *Optional:* Any comments you want to include about a change batch request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComment(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "comment", value);
    }

    /**
     * *Failover resource record sets only:* To configure failover, you add the `Failover` element to two resource record sets.
     * <p>
     * For one resource record set, you specify <code>PRIMARY</code> as the value for <code>Failover</code> ; for the other resource record set, you specify <code>SECONDARY</code> . In addition, you include the <code>HealthCheckId</code> element and specify the health check that you want Amazon Route 53 to perform for each resource record set.
     * <p>
     * Except where noted, the following failover behaviors assume that you have included the <code>HealthCheckId</code> element in both resource record sets:
     * <p>
     * <ul>
     * <li>When the primary resource record set is healthy, Route 53 responds to DNS queries with the applicable value from the primary resource record set regardless of the health of the secondary resource record set.</li>
     * <li>When the primary resource record set is unhealthy and the secondary resource record set is healthy, Route 53 responds to DNS queries with the applicable value from the secondary resource record set.</li>
     * <li>When the secondary resource record set is unhealthy, Route 53 responds to DNS queries with the applicable value from the primary resource record set regardless of the health of the primary resource record set.</li>
     * <li>If you omit the <code>HealthCheckId</code> element for the secondary resource record set, and if the primary resource record set is unhealthy, Route 53 always responds to DNS queries with the applicable value from the secondary resource record set. This is true regardless of the health of the associated endpoint.</li>
     * </ul>
     * <p>
     * You can't create non-failover resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as failover resource record sets.
     * <p>
     * For failover alias resource record sets, you must also include the <code>EvaluateTargetHealth</code> element and set the value to true.
     * <p>
     * For more information about configuring failover for Route 53, see the following topics in the <em>Amazon Route 53 Developer Guide</em> :
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health Checks and DNS Failover</a></li>
     * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFailover() {
        return software.amazon.jsii.Kernel.get(this, "failover", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * *Failover resource record sets only:* To configure failover, you add the `Failover` element to two resource record sets.
     * <p>
     * For one resource record set, you specify <code>PRIMARY</code> as the value for <code>Failover</code> ; for the other resource record set, you specify <code>SECONDARY</code> . In addition, you include the <code>HealthCheckId</code> element and specify the health check that you want Amazon Route 53 to perform for each resource record set.
     * <p>
     * Except where noted, the following failover behaviors assume that you have included the <code>HealthCheckId</code> element in both resource record sets:
     * <p>
     * <ul>
     * <li>When the primary resource record set is healthy, Route 53 responds to DNS queries with the applicable value from the primary resource record set regardless of the health of the secondary resource record set.</li>
     * <li>When the primary resource record set is unhealthy and the secondary resource record set is healthy, Route 53 responds to DNS queries with the applicable value from the secondary resource record set.</li>
     * <li>When the secondary resource record set is unhealthy, Route 53 responds to DNS queries with the applicable value from the primary resource record set regardless of the health of the primary resource record set.</li>
     * <li>If you omit the <code>HealthCheckId</code> element for the secondary resource record set, and if the primary resource record set is unhealthy, Route 53 always responds to DNS queries with the applicable value from the secondary resource record set. This is true regardless of the health of the associated endpoint.</li>
     * </ul>
     * <p>
     * You can't create non-failover resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as failover resource record sets.
     * <p>
     * For failover alias resource record sets, you must also include the <code>EvaluateTargetHealth</code> element and set the value to true.
     * <p>
     * For more information about configuring failover for Route 53, see the following topics in the <em>Amazon Route 53 Developer Guide</em> :
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health Checks and DNS Failover</a></li>
     * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFailover(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "failover", value);
    }

    /**
     * *Geolocation resource record sets only:* A complex type that lets you control how Amazon Route 53 responds to DNS queries based on the geographic origin of the query.
     * <p>
     * For example, if you want all queries from Africa to be routed to a web server with an IP address of <code>192.0.2.111</code> , create a resource record set with a <code>Type</code> of <code>A</code> and a <code>ContinentCode</code> of <code>AF</code> .
     * <p>
     * <blockquote>
     * <p>
     * Although creating geolocation and geolocation alias resource record sets in a private hosted zone is allowed, it's not supported.
     * <p>
     * </blockquote>
     * <p>
     * If you create separate resource record sets for overlapping geographic regions (for example, one resource record set for a continent and one for a country on the same continent), priority goes to the smallest geographic region. This allows you to route most queries for a continent to one resource and to route queries for a country on that continent to a different resource.
     * <p>
     * You can't create two geolocation resource record sets that specify the same geographic location.
     * <p>
     * The value <code>*</code> in the <code>CountryCode</code> element matches all geographic locations that aren't specified in other geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements.
     * <p>
     * <blockquote>
     * <p>
     * Geolocation works by mapping IP addresses to locations. However, some IP addresses aren't mapped to geographic locations, so even if you create geolocation resource record sets that cover all seven continents, Route 53 will receive some DNS queries from locations that it can't identify. We recommend that you create a resource record set for which the value of <code>CountryCode</code> is <code>*</code> . Two groups of queries are routed to the resource that you specify in this record: queries that come from locations for which you haven't created geolocation resource record sets and queries from IP addresses that aren't mapped to a location. If you don't create a <code>*</code> resource record set, Route 53 returns a "no answer" response for queries from those locations.
     * <p>
     * </blockquote>
     * <p>
     * You can't create non-geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as geolocation resource record sets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGeoLocation() {
        return software.amazon.jsii.Kernel.get(this, "geoLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * *Geolocation resource record sets only:* A complex type that lets you control how Amazon Route 53 responds to DNS queries based on the geographic origin of the query.
     * <p>
     * For example, if you want all queries from Africa to be routed to a web server with an IP address of <code>192.0.2.111</code> , create a resource record set with a <code>Type</code> of <code>A</code> and a <code>ContinentCode</code> of <code>AF</code> .
     * <p>
     * <blockquote>
     * <p>
     * Although creating geolocation and geolocation alias resource record sets in a private hosted zone is allowed, it's not supported.
     * <p>
     * </blockquote>
     * <p>
     * If you create separate resource record sets for overlapping geographic regions (for example, one resource record set for a continent and one for a country on the same continent), priority goes to the smallest geographic region. This allows you to route most queries for a continent to one resource and to route queries for a country on that continent to a different resource.
     * <p>
     * You can't create two geolocation resource record sets that specify the same geographic location.
     * <p>
     * The value <code>*</code> in the <code>CountryCode</code> element matches all geographic locations that aren't specified in other geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements.
     * <p>
     * <blockquote>
     * <p>
     * Geolocation works by mapping IP addresses to locations. However, some IP addresses aren't mapped to geographic locations, so even if you create geolocation resource record sets that cover all seven continents, Route 53 will receive some DNS queries from locations that it can't identify. We recommend that you create a resource record set for which the value of <code>CountryCode</code> is <code>*</code> . Two groups of queries are routed to the resource that you specify in this record: queries that come from locations for which you haven't created geolocation resource record sets and queries from IP addresses that aren't mapped to a location. If you don't create a <code>*</code> resource record set, Route 53 returns a "no answer" response for queries from those locations.
     * <p>
     * </blockquote>
     * <p>
     * You can't create non-geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as geolocation resource record sets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGeoLocation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.CfnRecordSet.GeoLocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "geoLocation", value);
    }

    /**
     * *Geolocation resource record sets only:* A complex type that lets you control how Amazon Route 53 responds to DNS queries based on the geographic origin of the query.
     * <p>
     * For example, if you want all queries from Africa to be routed to a web server with an IP address of <code>192.0.2.111</code> , create a resource record set with a <code>Type</code> of <code>A</code> and a <code>ContinentCode</code> of <code>AF</code> .
     * <p>
     * <blockquote>
     * <p>
     * Although creating geolocation and geolocation alias resource record sets in a private hosted zone is allowed, it's not supported.
     * <p>
     * </blockquote>
     * <p>
     * If you create separate resource record sets for overlapping geographic regions (for example, one resource record set for a continent and one for a country on the same continent), priority goes to the smallest geographic region. This allows you to route most queries for a continent to one resource and to route queries for a country on that continent to a different resource.
     * <p>
     * You can't create two geolocation resource record sets that specify the same geographic location.
     * <p>
     * The value <code>*</code> in the <code>CountryCode</code> element matches all geographic locations that aren't specified in other geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements.
     * <p>
     * <blockquote>
     * <p>
     * Geolocation works by mapping IP addresses to locations. However, some IP addresses aren't mapped to geographic locations, so even if you create geolocation resource record sets that cover all seven continents, Route 53 will receive some DNS queries from locations that it can't identify. We recommend that you create a resource record set for which the value of <code>CountryCode</code> is <code>*</code> . Two groups of queries are routed to the resource that you specify in this record: queries that come from locations for which you haven't created geolocation resource record sets and queries from IP addresses that aren't mapped to a location. If you don't create a <code>*</code> resource record set, Route 53 returns a "no answer" response for queries from those locations.
     * <p>
     * </blockquote>
     * <p>
     * You can't create non-geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as geolocation resource record sets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGeoLocation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "geoLocation", value);
    }

    /**
     * If you want Amazon Route 53 to return this resource record set in response to a DNS query only when the status of a health check is healthy, include the `HealthCheckId` element and specify the ID of the applicable health check.
     * <p>
     * Route 53 determines whether a resource record set is healthy based on one of the following:
     * <p>
     * <ul>
     * <li>By periodically sending a request to the endpoint that is specified in the health check</li>
     * <li>By aggregating the status of a specified group of health checks (calculated health checks)</li>
     * <li>By determining the current state of a CloudWatch alarm (CloudWatch metric health checks)</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * Route 53 doesn't check the health of the endpoint that is specified in the resource record set, for example, the endpoint specified by the IP address in the <code>Value</code> element. When you add a <code>HealthCheckId</code> element to a resource record set, Route 53 checks the health of the endpoint that you specified in the health check.
     * <p>
     * </blockquote>
     * <p>
     * For more information, see the following topics in the <em>Amazon Route 53 Developer Guide</em> :
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a></li>
     * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health Checks and DNS Failover</a></li>
     * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a></li>
     * </ul>
     * <p>
     * <em>When to Specify HealthCheckId</em>
     * <p>
     * Specifying a value for <code>HealthCheckId</code> is useful only when Route 53 is choosing between two or more resource record sets to respond to a DNS query, and you want Route 53 to base the choice in part on the status of a health check. Configuring health checks makes sense only in the following configurations:
     * <p>
     * <ul>
     * <li><em>Non-alias resource record sets</em> : You're checking the health of a group of non-alias resource record sets that have the same routing policy, name, and type (such as multiple weighted records named www.example.com with a type of A) and you specify health check IDs for all the resource record sets.</li>
     * </ul>
     * <p>
     * If the health check status for a resource record set is healthy, Route 53 includes the record among the records that it responds to DNS queries with.
     * <p>
     * If the health check status for a resource record set is unhealthy, Route 53 stops responding to DNS queries using the value for that resource record set.
     * <p>
     * If the health check status for all resource record sets in the group is unhealthy, Route 53 considers all resource record sets in the group healthy and responds to DNS queries accordingly.
     * <p>
     * <ul>
     * <li><em>Alias resource record sets</em> : You specify the following settings:</li>
     * <li>You set <code>EvaluateTargetHealth</code> to true for an alias resource record set in a group of resource record sets that have the same routing policy, name, and type (such as multiple weighted records named www.example.com with a type of A).</li>
     * <li>You configure the alias resource record set to route traffic to a non-alias resource record set in the same hosted zone.</li>
     * <li>You specify a health check ID for the non-alias resource record set.</li>
     * </ul>
     * <p>
     * If the health check status is healthy, Route 53 considers the alias resource record set to be healthy and includes the alias record among the records that it responds to DNS queries with.
     * <p>
     * If the health check status is unhealthy, Route 53 stops responding to DNS queries using the alias resource record set.
     * <p>
     * <blockquote>
     * <p>
     * The alias resource record set can also route traffic to a <em>group</em> of non-alias resource record sets that have the same routing policy, name, and type. In that configuration, associate health checks with all of the resource record sets in the group of non-alias resource record sets.
     * <p>
     * </blockquote>
     * <p>
     * <em>Geolocation Routing</em>
     * <p>
     * For geolocation resource record sets, if an endpoint is unhealthy, Route 53 looks for a resource record set for the larger, associated geographic region. For example, suppose you have resource record sets for a state in the United States, for the entire United States, for North America, and a resource record set that has <code>*</code> for <code>CountryCode</code> is <code>*</code> , which applies to all locations. If the endpoint for the state resource record set is unhealthy, Route 53 checks for healthy resource record sets in the following order until it finds a resource record set for which the endpoint is healthy:
     * <p>
     * <ul>
     * <li>The United States</li>
     * <li>North America</li>
     * <li>The default resource record set</li>
     * </ul>
     * <p>
     * <em>Specifying the Health Check Endpoint by Domain Name</em>
     * <p>
     * If your health checks specify the endpoint only by domain name, we recommend that you create a separate health check for each endpoint. For example, create a health check for each <code>HTTP</code> server that is serving content for <code>www.example.com</code> . For the value of <code>FullyQualifiedDomainName</code> , specify the domain name of the server (such as <code>us-east-2-www.example.com</code> ), not the name of the resource record sets ( <code>www.example.com</code> ).
     * <p>
     * <blockquote>
     * <p>
     * Health check results will be unpredictable if you do the following:
     * <p>
     * <ul>
     * <li>Create a health check that has the same value for <code>FullyQualifiedDomainName</code> as the name of a resource record set.</li>
     * <li>Associate that health check with the resource record set.</li>
     * </ul>
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHealthCheckId() {
        return software.amazon.jsii.Kernel.get(this, "healthCheckId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If you want Amazon Route 53 to return this resource record set in response to a DNS query only when the status of a health check is healthy, include the `HealthCheckId` element and specify the ID of the applicable health check.
     * <p>
     * Route 53 determines whether a resource record set is healthy based on one of the following:
     * <p>
     * <ul>
     * <li>By periodically sending a request to the endpoint that is specified in the health check</li>
     * <li>By aggregating the status of a specified group of health checks (calculated health checks)</li>
     * <li>By determining the current state of a CloudWatch alarm (CloudWatch metric health checks)</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * Route 53 doesn't check the health of the endpoint that is specified in the resource record set, for example, the endpoint specified by the IP address in the <code>Value</code> element. When you add a <code>HealthCheckId</code> element to a resource record set, Route 53 checks the health of the endpoint that you specified in the health check.
     * <p>
     * </blockquote>
     * <p>
     * For more information, see the following topics in the <em>Amazon Route 53 Developer Guide</em> :
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a></li>
     * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health Checks and DNS Failover</a></li>
     * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a></li>
     * </ul>
     * <p>
     * <em>When to Specify HealthCheckId</em>
     * <p>
     * Specifying a value for <code>HealthCheckId</code> is useful only when Route 53 is choosing between two or more resource record sets to respond to a DNS query, and you want Route 53 to base the choice in part on the status of a health check. Configuring health checks makes sense only in the following configurations:
     * <p>
     * <ul>
     * <li><em>Non-alias resource record sets</em> : You're checking the health of a group of non-alias resource record sets that have the same routing policy, name, and type (such as multiple weighted records named www.example.com with a type of A) and you specify health check IDs for all the resource record sets.</li>
     * </ul>
     * <p>
     * If the health check status for a resource record set is healthy, Route 53 includes the record among the records that it responds to DNS queries with.
     * <p>
     * If the health check status for a resource record set is unhealthy, Route 53 stops responding to DNS queries using the value for that resource record set.
     * <p>
     * If the health check status for all resource record sets in the group is unhealthy, Route 53 considers all resource record sets in the group healthy and responds to DNS queries accordingly.
     * <p>
     * <ul>
     * <li><em>Alias resource record sets</em> : You specify the following settings:</li>
     * <li>You set <code>EvaluateTargetHealth</code> to true for an alias resource record set in a group of resource record sets that have the same routing policy, name, and type (such as multiple weighted records named www.example.com with a type of A).</li>
     * <li>You configure the alias resource record set to route traffic to a non-alias resource record set in the same hosted zone.</li>
     * <li>You specify a health check ID for the non-alias resource record set.</li>
     * </ul>
     * <p>
     * If the health check status is healthy, Route 53 considers the alias resource record set to be healthy and includes the alias record among the records that it responds to DNS queries with.
     * <p>
     * If the health check status is unhealthy, Route 53 stops responding to DNS queries using the alias resource record set.
     * <p>
     * <blockquote>
     * <p>
     * The alias resource record set can also route traffic to a <em>group</em> of non-alias resource record sets that have the same routing policy, name, and type. In that configuration, associate health checks with all of the resource record sets in the group of non-alias resource record sets.
     * <p>
     * </blockquote>
     * <p>
     * <em>Geolocation Routing</em>
     * <p>
     * For geolocation resource record sets, if an endpoint is unhealthy, Route 53 looks for a resource record set for the larger, associated geographic region. For example, suppose you have resource record sets for a state in the United States, for the entire United States, for North America, and a resource record set that has <code>*</code> for <code>CountryCode</code> is <code>*</code> , which applies to all locations. If the endpoint for the state resource record set is unhealthy, Route 53 checks for healthy resource record sets in the following order until it finds a resource record set for which the endpoint is healthy:
     * <p>
     * <ul>
     * <li>The United States</li>
     * <li>North America</li>
     * <li>The default resource record set</li>
     * </ul>
     * <p>
     * <em>Specifying the Health Check Endpoint by Domain Name</em>
     * <p>
     * If your health checks specify the endpoint only by domain name, we recommend that you create a separate health check for each endpoint. For example, create a health check for each <code>HTTP</code> server that is serving content for <code>www.example.com</code> . For the value of <code>FullyQualifiedDomainName</code> , specify the domain name of the server (such as <code>us-east-2-www.example.com</code> ), not the name of the resource record sets ( <code>www.example.com</code> ).
     * <p>
     * <blockquote>
     * <p>
     * Health check results will be unpredictable if you do the following:
     * <p>
     * <ul>
     * <li>Create a health check that has the same value for <code>FullyQualifiedDomainName</code> as the name of a resource record set.</li>
     * <li>Associate that health check with the resource record set.</li>
     * </ul>
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckId", value);
    }

    /**
     * The ID of the hosted zone that you want to create records in.
     * <p>
     * Specify either <code>HostedZoneName</code> or <code>HostedZoneId</code> , but not both. If you have multiple hosted zones with the same domain name, you must specify the hosted zone using <code>HostedZoneId</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneId() {
        return software.amazon.jsii.Kernel.get(this, "hostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the hosted zone that you want to create records in.
     * <p>
     * Specify either <code>HostedZoneName</code> or <code>HostedZoneId</code> , but not both. If you have multiple hosted zones with the same domain name, you must specify the hosted zone using <code>HostedZoneId</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostedZoneId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "hostedZoneId", value);
    }

    /**
     * The name of the hosted zone that you want to create records in.
     * <p>
     * You must include a trailing dot (for example, <code>www.example.com.</code> ) as part of the <code>HostedZoneName</code> .
     * <p>
     * When you create a stack using an AWS::Route53::RecordSet that specifies <code>HostedZoneName</code> , AWS CloudFormation attempts to find a hosted zone whose name matches the HostedZoneName. If AWS CloudFormation cannot find a hosted zone with a matching domain name, or if there is more than one hosted zone with the specified domain name, AWS CloudFormation will not create the stack.
     * <p>
     * Specify either <code>HostedZoneName</code> or <code>HostedZoneId</code> , but not both. If you have multiple hosted zones with the same domain name, you must specify the hosted zone using <code>HostedZoneId</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneName() {
        return software.amazon.jsii.Kernel.get(this, "hostedZoneName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the hosted zone that you want to create records in.
     * <p>
     * You must include a trailing dot (for example, <code>www.example.com.</code> ) as part of the <code>HostedZoneName</code> .
     * <p>
     * When you create a stack using an AWS::Route53::RecordSet that specifies <code>HostedZoneName</code> , AWS CloudFormation attempts to find a hosted zone whose name matches the HostedZoneName. If AWS CloudFormation cannot find a hosted zone with a matching domain name, or if there is more than one hosted zone with the specified domain name, AWS CloudFormation will not create the stack.
     * <p>
     * Specify either <code>HostedZoneName</code> or <code>HostedZoneId</code> , but not both. If you have multiple hosted zones with the same domain name, you must specify the hosted zone using <code>HostedZoneId</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostedZoneName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "hostedZoneName", value);
    }

    /**
     * *Multivalue answer resource record sets only* : To route traffic approximately randomly to multiple resources, such as web servers, create one multivalue answer record for each resource and specify `true` for `MultiValueAnswer` .
     * <p>
     * Note the following:
     * <p>
     * <ul>
     * <li>If you associate a health check with a multivalue answer resource record set, Amazon Route 53 responds to DNS queries with the corresponding IP address only when the health check is healthy.</li>
     * <li>If you don't associate a health check with a multivalue answer record, Route 53 always considers the record to be healthy.</li>
     * <li>Route 53 responds to DNS queries with up to eight healthy records; if you have eight or fewer healthy records, Route 53 responds to all DNS queries with all the healthy records.</li>
     * <li>If you have more than eight healthy records, Route 53 responds to different DNS resolvers with different combinations of healthy records.</li>
     * <li>When all records are unhealthy, Route 53 responds to DNS queries with up to eight unhealthy records.</li>
     * <li>If a resource becomes unavailable after a resolver caches a response, client software typically tries another of the IP addresses in the response.</li>
     * </ul>
     * <p>
     * You can't create multivalue answer alias records.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMultiValueAnswer() {
        return software.amazon.jsii.Kernel.get(this, "multiValueAnswer", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * *Multivalue answer resource record sets only* : To route traffic approximately randomly to multiple resources, such as web servers, create one multivalue answer record for each resource and specify `true` for `MultiValueAnswer` .
     * <p>
     * Note the following:
     * <p>
     * <ul>
     * <li>If you associate a health check with a multivalue answer resource record set, Amazon Route 53 responds to DNS queries with the corresponding IP address only when the health check is healthy.</li>
     * <li>If you don't associate a health check with a multivalue answer record, Route 53 always considers the record to be healthy.</li>
     * <li>Route 53 responds to DNS queries with up to eight healthy records; if you have eight or fewer healthy records, Route 53 responds to all DNS queries with all the healthy records.</li>
     * <li>If you have more than eight healthy records, Route 53 responds to different DNS resolvers with different combinations of healthy records.</li>
     * <li>When all records are unhealthy, Route 53 responds to DNS queries with up to eight unhealthy records.</li>
     * <li>If a resource becomes unavailable after a resolver caches a response, client software typically tries another of the IP addresses in the response.</li>
     * </ul>
     * <p>
     * You can't create multivalue answer alias records.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiValueAnswer(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "multiValueAnswer", value);
    }

    /**
     * *Multivalue answer resource record sets only* : To route traffic approximately randomly to multiple resources, such as web servers, create one multivalue answer record for each resource and specify `true` for `MultiValueAnswer` .
     * <p>
     * Note the following:
     * <p>
     * <ul>
     * <li>If you associate a health check with a multivalue answer resource record set, Amazon Route 53 responds to DNS queries with the corresponding IP address only when the health check is healthy.</li>
     * <li>If you don't associate a health check with a multivalue answer record, Route 53 always considers the record to be healthy.</li>
     * <li>Route 53 responds to DNS queries with up to eight healthy records; if you have eight or fewer healthy records, Route 53 responds to all DNS queries with all the healthy records.</li>
     * <li>If you have more than eight healthy records, Route 53 responds to different DNS resolvers with different combinations of healthy records.</li>
     * <li>When all records are unhealthy, Route 53 responds to DNS queries with up to eight unhealthy records.</li>
     * <li>If a resource becomes unavailable after a resolver caches a response, client software typically tries another of the IP addresses in the response.</li>
     * </ul>
     * <p>
     * You can't create multivalue answer alias records.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiValueAnswer(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "multiValueAnswer", value);
    }

    /**
     * *Latency-based resource record sets only:* The Amazon EC2 Region where you created the resource that this resource record set refers to.
     * <p>
     * The resource typically is an AWS resource, such as an EC2 instance or an ELB load balancer, and is referred to by an IP address or a DNS domain name, depending on the record type.
     * <p>
     * <blockquote>
     * <p>
     * Although creating latency and latency alias resource record sets in a private hosted zone is allowed, it's not supported.
     * <p>
     * </blockquote>
     * <p>
     * When Amazon Route 53 receives a DNS query for a domain name and type for which you have created latency resource record sets, Route 53 selects the latency resource record set that has the lowest latency between the end user and the associated Amazon EC2 Region. Route 53 then returns the value that is associated with the selected resource record set.
     * <p>
     * Note the following:
     * <p>
     * <ul>
     * <li>You can only specify one <code>ResourceRecord</code> per latency resource record set.</li>
     * <li>You can only create one latency resource record set for each Amazon EC2 Region.</li>
     * <li>You aren't required to create latency resource record sets for all Amazon EC2 Regions. Route 53 will choose the region with the best latency from among the regions that you create latency resource record sets for.</li>
     * <li>You can't create non-latency resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as latency resource record sets.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * *Latency-based resource record sets only:* The Amazon EC2 Region where you created the resource that this resource record set refers to.
     * <p>
     * The resource typically is an AWS resource, such as an EC2 instance or an ELB load balancer, and is referred to by an IP address or a DNS domain name, depending on the record type.
     * <p>
     * <blockquote>
     * <p>
     * Although creating latency and latency alias resource record sets in a private hosted zone is allowed, it's not supported.
     * <p>
     * </blockquote>
     * <p>
     * When Amazon Route 53 receives a DNS query for a domain name and type for which you have created latency resource record sets, Route 53 selects the latency resource record set that has the lowest latency between the end user and the associated Amazon EC2 Region. Route 53 then returns the value that is associated with the selected resource record set.
     * <p>
     * Note the following:
     * <p>
     * <ul>
     * <li>You can only specify one <code>ResourceRecord</code> per latency resource record set.</li>
     * <li>You can only create one latency resource record set for each Amazon EC2 Region.</li>
     * <li>You aren't required to create latency resource record sets for all Amazon EC2 Regions. Route 53 will choose the region with the best latency from among the regions that you create latency resource record sets for.</li>
     * <li>You can't create non-latency resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as latency resource record sets.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "region", value);
    }

    /**
     * One or more values that correspond with the value that you specified for the `Type` property.
     * <p>
     * For example, if you specified <code>A</code> for <code>Type</code> , you specify one or more IP addresses in IPv4 format for <code>ResourceRecords</code> . For information about the format of values for each record type, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS Resource Record Types</a> in the <em>Amazon Route 53 Developer Guide</em> .
     * <p>
     * Note the following:
     * <p>
     * <ul>
     * <li>You can specify more than one value for all record types except CNAME and SOA.</li>
     * <li>The maximum length of a value is 4000 characters.</li>
     * <li>If you're creating an alias record, omit <code>ResourceRecords</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceRecords() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "resourceRecords", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * One or more values that correspond with the value that you specified for the `Type` property.
     * <p>
     * For example, if you specified <code>A</code> for <code>Type</code> , you specify one or more IP addresses in IPv4 format for <code>ResourceRecords</code> . For information about the format of values for each record type, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS Resource Record Types</a> in the <em>Amazon Route 53 Developer Guide</em> .
     * <p>
     * Note the following:
     * <p>
     * <ul>
     * <li>You can specify more than one value for all record types except CNAME and SOA.</li>
     * <li>The maximum length of a value is 4000 characters.</li>
     * <li>If you're creating an alias record, omit <code>ResourceRecords</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceRecords(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "resourceRecords", value);
    }

    /**
     * *Resource record sets that have a routing policy other than simple:* An identifier that differentiates among multiple resource record sets that have the same combination of name and type, such as multiple weighted resource record sets named acme.example.com that have a type of A. In a group of resource record sets that have the same name and type, the value of `SetIdentifier` must be unique for each resource record set.
     * <p>
     * For information about routing policies, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a Routing Policy</a> in the <em>Amazon Route 53 Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSetIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "setIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * *Resource record sets that have a routing policy other than simple:* An identifier that differentiates among multiple resource record sets that have the same combination of name and type, such as multiple weighted resource record sets named acme.example.com that have a type of A. In a group of resource record sets that have the same name and type, the value of `SetIdentifier` must be unique for each resource record set.
     * <p>
     * For information about routing policies, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a Routing Policy</a> in the <em>Amazon Route 53 Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSetIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "setIdentifier", value);
    }

    /**
     * The resource record cache time to live (TTL), in seconds. Note the following:.
     * <p>
     * <ul>
     * <li>If you're creating or updating an alias resource record set, omit <code>TTL</code> . Amazon Route 53 uses the value of <code>TTL</code> for the alias target.</li>
     * <li>If you're associating this resource record set with a health check (if you're adding a <code>HealthCheckId</code> element), we recommend that you specify a <code>TTL</code> of 60 seconds or less so clients respond quickly to changes in health status.</li>
     * <li>All of the resource record sets in a group of weighted resource record sets must have the same value for <code>TTL</code> .</li>
     * <li>If a group of weighted resource record sets includes one or more weighted alias resource record sets for which the alias target is an ELB load balancer, we recommend that you specify a <code>TTL</code> of 60 seconds for all of the non-alias weighted resource record sets that have the same name and type. Values other than 60 seconds (the TTL for load balancers) will change the effect of the values that you specify for <code>Weight</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTtl() {
        return software.amazon.jsii.Kernel.get(this, "ttl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The resource record cache time to live (TTL), in seconds. Note the following:.
     * <p>
     * <ul>
     * <li>If you're creating or updating an alias resource record set, omit <code>TTL</code> . Amazon Route 53 uses the value of <code>TTL</code> for the alias target.</li>
     * <li>If you're associating this resource record set with a health check (if you're adding a <code>HealthCheckId</code> element), we recommend that you specify a <code>TTL</code> of 60 seconds or less so clients respond quickly to changes in health status.</li>
     * <li>All of the resource record sets in a group of weighted resource record sets must have the same value for <code>TTL</code> .</li>
     * <li>If a group of weighted resource record sets includes one or more weighted alias resource record sets for which the alias target is an ELB load balancer, we recommend that you specify a <code>TTL</code> of 60 seconds for all of the non-alias weighted resource record sets that have the same name and type. Values other than 60 seconds (the TTL for load balancers) will change the effect of the values that you specify for <code>Weight</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTtl(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ttl", value);
    }

    /**
     * *Weighted resource record sets only:* Among resource record sets that have the same combination of DNS name and type, a value that determines the proportion of DNS queries that Amazon Route 53 responds to using the current resource record set.
     * <p>
     * Route 53 calculates the sum of the weights for the resource record sets that have the same combination of DNS name and type. Route 53 then responds to queries based on the ratio of a resource's weight to the total. Note the following:
     * <p>
     * <ul>
     * <li>You must specify a value for the <code>Weight</code> element for every weighted resource record set.</li>
     * <li>You can only specify one <code>ResourceRecord</code> per weighted resource record set.</li>
     * <li>You can't create latency, failover, or geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as weighted resource record sets.</li>
     * <li>You can create a maximum of 100 weighted resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements.</li>
     * <li>For weighted (but not weighted alias) resource record sets, if you set <code>Weight</code> to <code>0</code> for a resource record set, Route 53 never responds to queries with the applicable value for that resource record set. However, if you set <code>Weight</code> to <code>0</code> for all resource record sets that have the same combination of DNS name and type, traffic is routed to all resources with equal probability.</li>
     * </ul>
     * <p>
     * The effect of setting <code>Weight</code> to <code>0</code> is different when you associate health checks with weighted resource record sets. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html">Options for Configuring Route 53 Active-Active and Active-Passive Failover</a> in the <em>Amazon Route 53 Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
        return software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * *Weighted resource record sets only:* Among resource record sets that have the same combination of DNS name and type, a value that determines the proportion of DNS queries that Amazon Route 53 responds to using the current resource record set.
     * <p>
     * Route 53 calculates the sum of the weights for the resource record sets that have the same combination of DNS name and type. Route 53 then responds to queries based on the ratio of a resource's weight to the total. Note the following:
     * <p>
     * <ul>
     * <li>You must specify a value for the <code>Weight</code> element for every weighted resource record set.</li>
     * <li>You can only specify one <code>ResourceRecord</code> per weighted resource record set.</li>
     * <li>You can't create latency, failover, or geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as weighted resource record sets.</li>
     * <li>You can create a maximum of 100 weighted resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements.</li>
     * <li>For weighted (but not weighted alias) resource record sets, if you set <code>Weight</code> to <code>0</code> for a resource record set, Route 53 never responds to queries with the applicable value for that resource record set. However, if you set <code>Weight</code> to <code>0</code> for all resource record sets that have the same combination of DNS name and type, traffic is routed to all resources with equal probability.</li>
     * </ul>
     * <p>
     * The effect of setting <code>Weight</code> to <code>0</code> is different when you associate health checks with weighted resource record sets. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html">Options for Configuring Route 53 Active-Active and Active-Passive Failover</a> in the <em>Amazon Route 53 Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWeight(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "weight", value);
    }
    /**
     * *Alias records only:* Information about the AWS resource, such as a CloudFront distribution or an Amazon S3 bucket, that you want to route traffic to.
     * <p>
     * When creating records for a private hosted zone, note the following:
     * <p>
     * <ul>
     * <li>Creating geolocation alias and latency alias records in a private hosted zone is allowed but not supported.</li>
     * <li>For information about creating failover records in a private hosted zone, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a> .</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53.*;
     * AliasTargetProperty aliasTargetProperty = AliasTargetProperty.builder()
     *         .dnsName("dnsName")
     *         .hostedZoneId("hostedZoneId")
     *         // the properties below are optional
     *         .evaluateTargetHealth(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CfnRecordSet.AliasTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(AliasTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AliasTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * *Alias records only:* The value that you specify depends on where you want to route queries:.
         * <p>
         * <ul>
         * <li><strong>Amazon API Gateway custom regional APIs and edge-optimized APIs</strong> - Specify the applicable domain name for your API. You can get the applicable value using the AWS CLI command <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-domain-names.html">get-domain-names</a> :</li>
         * <li>For regional APIs, specify the value of <code>regionalDomainName</code> .</li>
         * <li>For edge-optimized APIs, specify the value of <code>distributionDomainName</code> . This is the name of the associated CloudFront distribution, such as <code>da1b2c3d4e5.cloudfront.net</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The name of the record that you're creating must match a custom domain name for your API, such as <code>api.example.com</code> .
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>Amazon Virtual Private Cloud interface VPC endpoint</strong> - Enter the API endpoint for the interface endpoint, such as <code>vpce-123456789abcdef01-example-us-east-1a.elasticloadbalancing.us-east-1.vpce.amazonaws.com</code> . For edge-optimized APIs, this is the domain name for the corresponding CloudFront distribution. You can get the value of <code>DnsName</code> using the AWS CLI command <a href="https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-vpc-endpoints.html">describe-vpc-endpoints</a> .</li>
         * <li><strong>CloudFront distribution</strong> - Specify the domain name that CloudFront assigned when you created your distribution.</li>
         * </ul>
         * <p>
         * Your CloudFront distribution must include an alternate domain name that matches the name of the record. For example, if the name of the record is <em>acme.example.com</em> , your CloudFront distribution must include <em>acme.example.com</em> as one of the alternate domain names. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html">Using Alternate Domain Names (CNAMEs)</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * You can't create a record in a private hosted zone to route traffic to a CloudFront distribution.
         * <p>
         * <blockquote>
         * <p>
         * For failover alias records, you can't specify a CloudFront distribution for both the primary and secondary records. A distribution must include an alternate domain name that matches the name of the record. However, the primary and secondary records have the same name, and you can't include the same alternate domain name in more than one distribution.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>Elastic Beanstalk environment</strong> - If the domain name for your Elastic Beanstalk environment includes the region that you deployed the environment in, you can create an alias record that routes traffic to the environment. For example, the domain name <code>my-environment. *us-west-2* .elasticbeanstalk.com</code> is a regionalized domain name.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * For environments that were created before early 2016, the domain name doesn't include the region. To route traffic to these environments, you must create a CNAME record instead of an alias record. Note that you can't create a CNAME record for the root domain name. For example, if your domain name is example.com, you can create a record that routes traffic for acme.example.com to your Elastic Beanstalk environment, but you can't create a record that routes traffic for example.com to your Elastic Beanstalk environment.
         * <p>
         * </blockquote>
         * <p>
         * For Elastic Beanstalk environments that have regionalized subdomains, specify the <code>CNAME</code> attribute for the environment. You can use the following methods to get the value of the CNAME attribute:
         * <p>
         * <ul>
         * <li><em>AWS Management Console</em> : For information about how to get the value by using the console, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/customdomains.html">Using Custom Domains with AWS Elastic Beanstalk</a> in the <em>AWS Elastic Beanstalk Developer Guide</em> .</li>
         * <li><em>Elastic Beanstalk API</em> : Use the <code>DescribeEnvironments</code> action to get the value of the <code>CNAME</code> attribute. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEnvironments.html">DescribeEnvironments</a> in the <em>AWS Elastic Beanstalk API Reference</em> .</li>
         * <li><em>AWS CLI</em> : Use the <code>describe-environments</code> command to get the value of the <code>CNAME</code> attribute. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/reference/elasticbeanstalk/describe-environments.html">describe-environments</a> in the <em>AWS CLI</em> .</li>
         * <li><strong>ELB load balancer</strong> - Specify the DNS name that is associated with the load balancer. Get the DNS name by using the AWS Management Console , the ELB API, or the AWS CLI .</li>
         * <li><em>AWS Management Console</em> : Go to the EC2 page, choose <em>Load Balancers</em> in the navigation pane, choose the load balancer, choose the <em>Description</em> tab, and get the value of the <em>DNS name</em> field.</li>
         * </ul>
         * <p>
         * If you're routing traffic to a Classic Load Balancer, get the value that begins with <em>dualstack</em> . If you're routing traffic to another type of load balancer, get the value that applies to the record type, A or AAAA.
         * <p>
         * <ul>
         * <li><em>Elastic Load Balancing API</em> : Use <code>DescribeLoadBalancers</code> to get the value of <code>DNSName</code> . For more information, see the applicable guide:</li>
         * <li>Classic Load Balancers: <a href="https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a></li>
         * <li>Application and Network Load Balancers: <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a></li>
         * <li><em>CloudFormation Fn::GetAtt intrinsic function</em> : Use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-getatt.html">Fn::GetAtt</a> intrinsic function to get the value of <code>DNSName</code> :</li>
         * <li><a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#aws-properties-ec2-elb-return-values">Classic Load Balancers</a> .</li>
         * <li><a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#aws-resource-elasticloadbalancingv2-loadbalancer-return-values">Application and Network Load Balancers</a> .</li>
         * <li><em>AWS CLI</em> : Use <code>describe-load-balancers</code> to get the value of <code>DNSName</code> . For more information, see the applicable guide:</li>
         * <li>Classic Load Balancers: <a href="https://docs.aws.amazon.com/cli/latest/reference/elb/describe-load-balancers.html">describe-load-balancers</a></li>
         * <li>Application and Network Load Balancers: <a href="https://docs.aws.amazon.com/cli/latest/reference/elbv2/describe-load-balancers.html">describe-load-balancers</a></li>
         * <li><strong>Global Accelerator accelerator</strong> - Specify the DNS name for your accelerator:</li>
         * <li><em>Global Accelerator API</em> : To get the DNS name, use <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeAccelerator.html">DescribeAccelerator</a> .</li>
         * <li><em>AWS CLI</em> : To get the DNS name, use <a href="https://docs.aws.amazon.com/cli/latest/reference/globalaccelerator/describe-accelerator.html">describe-accelerator</a> .</li>
         * <li><strong>Amazon S3 bucket that is configured as a static website</strong> - Specify the domain name of the Amazon S3 website endpoint that you created the bucket in, for example, <code>s3-website.us-east-2.amazonaws.com</code> . For more information about valid values, see the table <a href="https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_website_region_endpoints">Amazon S3 Website Endpoints</a> in the <em>Amazon Web Services General Reference</em> . For more information about using S3 buckets for websites, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/getting-started.html">Getting Started with Amazon Route 53</a> in the <em>Amazon Route 53 Developer Guide.</em></li>
         * <li><strong>Another Route 53 record</strong> - Specify the value of the <code>Name</code> element for a record in the current hosted zone.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you're creating an alias record that has the same name as the hosted zone (known as the zone apex), you can't specify the domain name for a record for which the value of <code>Type</code> is <code>CNAME</code> . This is because the alias record must have the same type as the record that you're routing traffic to, and creating a CNAME record for the zone apex isn't supported even for an alias record.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDnsName();

        /**
         * *Alias resource records sets only* : The value used depends on where you want to route traffic:.
         * <p>
         * <ul>
         * <li><strong>Amazon API Gateway custom regional APIs and edge-optimized APIs</strong> - Specify the hosted zone ID for your API. You can get the applicable value using the AWS CLI command <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-domain-names.html">get-domain-names</a> :</li>
         * <li>For regional APIs, specify the value of <code>regionalHostedZoneId</code> .</li>
         * <li>For edge-optimized APIs, specify the value of <code>distributionHostedZoneId</code> .</li>
         * <li><strong>Amazon Virtual Private Cloud interface VPC endpoint</strong> - Specify the hosted zone ID for your interface endpoint. You can get the value of <code>HostedZoneId</code> using the AWS CLI command <a href="https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-vpc-endpoints.html">describe-vpc-endpoints</a> .</li>
         * <li><strong>CloudFront distribution</strong> - Specify <code>Z2FDTNDATAQYW2</code> . This is always the hosted zone ID when you create an alias record that routes traffic to a CloudFront distribution.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Alias records for CloudFront can't be created in a private zone.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>Elastic Beanstalk environment</strong> - Specify the hosted zone ID for the region that you created the environment in. The environment must have a regionalized subdomain. For a list of regions and the corresponding hosted zone IDs, see <a href="https://docs.aws.amazon.com/general/latest/gr/elasticbeanstalk.html">AWS Elastic Beanstalk endpoints and quotas</a> in the <em>Amazon Web Services General Reference</em> .</li>
         * <li><strong>ELB load balancer</strong> - Specify the value of the hosted zone ID for the load balancer. Use the following methods to get the hosted zone ID:</li>
         * <li><a href="https://docs.aws.amazon.com/general/latest/gr/elb.html">Service Endpoints</a> table in the "Elastic Load Balancing Endpoints and Quotas" topic in the <em>Amazon Web Services General Reference</em> : Use the value that corresponds with the region that you created your load balancer in. Note that there are separate columns for Application and Classic Load Balancers and for Network Load Balancers.</li>
         * <li><em>AWS Management Console</em> : Go to the Amazon EC2 page, choose <em>Load Balancers</em> in the navigation pane, select the load balancer, and get the value of the <em>Hosted zone</em> field on the <em>Description</em> tab.</li>
         * <li><em>Elastic Load Balancing API</em> : Use <code>DescribeLoadBalancers</code> to get the applicable value. For more information, see the applicable guide:</li>
         * <li>Classic Load Balancers: Use <a href="https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> to get the value of <code>CanonicalHostedZoneNameID</code> .</li>
         * <li>Application and Network Load Balancers: Use <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> to get the value of <code>CanonicalHostedZoneID</code> .</li>
         * <li><em>CloudFormation Fn::GetAtt intrinsic function</em> : Use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-getatt.html">Fn::GetAtt</a> intrinsic function to get the applicable value:</li>
         * <li>Classic Load Balancers: Get <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#aws-properties-ec2-elb-return-values">CanonicalHostedZoneNameID</a> .</li>
         * <li>Application and Network Load Balancers: Get <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#aws-resource-elasticloadbalancingv2-loadbalancer-return-values">CanonicalHostedZoneID</a> .</li>
         * <li><em>AWS CLI</em> : Use <code>describe-load-balancers</code> to get the applicable value. For more information, see the applicable guide:</li>
         * <li>Classic Load Balancers: Use <a href="https://docs.aws.amazon.com/cli/latest/reference/elb/describe-load-balancers.html">describe-load-balancers</a> to get the value of <code>CanonicalHostedZoneNameID</code> .</li>
         * <li>Application and Network Load Balancers: Use <a href="https://docs.aws.amazon.com/cli/latest/reference/elbv2/describe-load-balancers.html">describe-load-balancers</a> to get the value of <code>CanonicalHostedZoneID</code> .</li>
         * <li><strong>Global Accelerator accelerator</strong> - Specify <code>Z2BJ6XQ5FK7U4H</code> .</li>
         * <li><strong>An Amazon S3 bucket configured as a static website</strong> - Specify the hosted zone ID for the region that you created the bucket in. For more information about valid values, see the table <a href="https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_website_region_endpoints">Amazon S3 Website Endpoints</a> in the <em>Amazon Web Services General Reference</em> .</li>
         * <li><strong>Another Route 53 record in your hosted zone</strong> - Specify the hosted zone ID of your hosted zone. (An alias record can't reference a record in a different hosted zone.)</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHostedZoneId();

        /**
         * *Applies only to alias, failover alias, geolocation alias, latency alias, and weighted alias resource record sets:* When `EvaluateTargetHealth` is `true` , an alias resource record set inherits the health of the referenced AWS resource, such as an ELB load balancer or another resource record set in the hosted zone.
         * <p>
         * Note the following:
         * <p>
         * <ul>
         * <li><strong>CloudFront distributions</strong> - You can't set <code>EvaluateTargetHealth</code> to <code>true</code> when the alias target is a CloudFront distribution.</li>
         * <li><strong>Elastic Beanstalk environments that have regionalized subdomains</strong> - If you specify an Elastic Beanstalk environment in <code>DNSName</code> and the environment contains an ELB load balancer, Elastic Load Balancing routes queries only to the healthy Amazon EC2 instances that are registered with the load balancer. (An environment automatically contains an ELB load balancer if it includes more than one Amazon EC2 instance.) If you set <code>EvaluateTargetHealth</code> to <code>true</code> and either no Amazon EC2 instances are healthy or the load balancer itself is unhealthy, Route 53 routes queries to other available resources that are healthy, if any.</li>
         * </ul>
         * <p>
         * If the environment contains a single Amazon EC2 instance, there are no special requirements.
         * <p>
         * <ul>
         * <li><strong>ELB load balancers</strong> - Health checking behavior depends on the type of load balancer:</li>
         * <li><em>Classic Load Balancers</em> : If you specify an ELB Classic Load Balancer in <code>DNSName</code> , Elastic Load Balancing routes queries only to the healthy Amazon EC2 instances that are registered with the load balancer. If you set <code>EvaluateTargetHealth</code> to <code>true</code> and either no EC2 instances are healthy or the load balancer itself is unhealthy, Route 53 routes queries to other resources.</li>
         * <li><em>Application and Network Load Balancers</em> : If you specify an ELB Application or Network Load Balancer and you set <code>EvaluateTargetHealth</code> to <code>true</code> , Route 53 routes queries to the load balancer based on the health of the target groups that are associated with the load balancer:</li>
         * <li>For an Application or Network Load Balancer to be considered healthy, every target group that contains targets must contain at least one healthy target. If any target group contains only unhealthy targets, the load balancer is considered unhealthy, and Route 53 routes queries to other resources.</li>
         * <li>A target group that has no registered targets is considered unhealthy.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * When you create a load balancer, you configure settings for Elastic Load Balancing health checks; they're not Route 53 health checks, but they perform a similar function. Do not create Route 53 health checks for the EC2 instances that you register with an ELB load balancer.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>S3 buckets</strong> - There are no special requirements for setting <code>EvaluateTargetHealth</code> to <code>true</code> when the alias target is an S3 bucket.</li>
         * <li><strong>Other records in the same hosted zone</strong> - If the AWS resource that you specify in <code>DNSName</code> is a record or a group of records (for example, a group of weighted records) but is not another alias record, we recommend that you associate a health check with all of the records in the alias target. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-complex-configs.html#dns-failover-complex-configs-hc-omitting">What Happens When You Omit Health Checks?</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
         * </ul>
         * <p>
         * For more information and examples, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Amazon Route 53 Health Checks and DNS Failover</a> in the <em>Amazon Route 53 Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEvaluateTargetHealth() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AliasTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AliasTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AliasTargetProperty> {
            java.lang.String dnsName;
            java.lang.String hostedZoneId;
            java.lang.Object evaluateTargetHealth;

            /**
             * Sets the value of {@link AliasTargetProperty#getDnsName}
             * @param dnsName *Alias records only:* The value that you specify depends on where you want to route queries:. This parameter is required.
             *                <ul>
             *                <li><strong>Amazon API Gateway custom regional APIs and edge-optimized APIs</strong> - Specify the applicable domain name for your API. You can get the applicable value using the AWS CLI command <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-domain-names.html">get-domain-names</a> :</li>
             *                <li>For regional APIs, specify the value of <code>regionalDomainName</code> .</li>
             *                <li>For edge-optimized APIs, specify the value of <code>distributionDomainName</code> . This is the name of the associated CloudFront distribution, such as <code>da1b2c3d4e5.cloudfront.net</code> .</li>
             *                </ul>
             *                <p>
             *                <blockquote>
             *                <p>
             *                The name of the record that you're creating must match a custom domain name for your API, such as <code>api.example.com</code> .
             *                <p>
             *                </blockquote>
             *                <p>
             *                <ul>
             *                <li><strong>Amazon Virtual Private Cloud interface VPC endpoint</strong> - Enter the API endpoint for the interface endpoint, such as <code>vpce-123456789abcdef01-example-us-east-1a.elasticloadbalancing.us-east-1.vpce.amazonaws.com</code> . For edge-optimized APIs, this is the domain name for the corresponding CloudFront distribution. You can get the value of <code>DnsName</code> using the AWS CLI command <a href="https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-vpc-endpoints.html">describe-vpc-endpoints</a> .</li>
             *                <li><strong>CloudFront distribution</strong> - Specify the domain name that CloudFront assigned when you created your distribution.</li>
             *                </ul>
             *                <p>
             *                Your CloudFront distribution must include an alternate domain name that matches the name of the record. For example, if the name of the record is <em>acme.example.com</em> , your CloudFront distribution must include <em>acme.example.com</em> as one of the alternate domain names. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html">Using Alternate Domain Names (CNAMEs)</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                <p>
             *                You can't create a record in a private hosted zone to route traffic to a CloudFront distribution.
             *                <p>
             *                <blockquote>
             *                <p>
             *                For failover alias records, you can't specify a CloudFront distribution for both the primary and secondary records. A distribution must include an alternate domain name that matches the name of the record. However, the primary and secondary records have the same name, and you can't include the same alternate domain name in more than one distribution.
             *                <p>
             *                </blockquote>
             *                <p>
             *                <ul>
             *                <li><strong>Elastic Beanstalk environment</strong> - If the domain name for your Elastic Beanstalk environment includes the region that you deployed the environment in, you can create an alias record that routes traffic to the environment. For example, the domain name <code>my-environment. *us-west-2* .elasticbeanstalk.com</code> is a regionalized domain name.</li>
             *                </ul>
             *                <p>
             *                <blockquote>
             *                <p>
             *                For environments that were created before early 2016, the domain name doesn't include the region. To route traffic to these environments, you must create a CNAME record instead of an alias record. Note that you can't create a CNAME record for the root domain name. For example, if your domain name is example.com, you can create a record that routes traffic for acme.example.com to your Elastic Beanstalk environment, but you can't create a record that routes traffic for example.com to your Elastic Beanstalk environment.
             *                <p>
             *                </blockquote>
             *                <p>
             *                For Elastic Beanstalk environments that have regionalized subdomains, specify the <code>CNAME</code> attribute for the environment. You can use the following methods to get the value of the CNAME attribute:
             *                <p>
             *                <ul>
             *                <li><em>AWS Management Console</em> : For information about how to get the value by using the console, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/customdomains.html">Using Custom Domains with AWS Elastic Beanstalk</a> in the <em>AWS Elastic Beanstalk Developer Guide</em> .</li>
             *                <li><em>Elastic Beanstalk API</em> : Use the <code>DescribeEnvironments</code> action to get the value of the <code>CNAME</code> attribute. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEnvironments.html">DescribeEnvironments</a> in the <em>AWS Elastic Beanstalk API Reference</em> .</li>
             *                <li><em>AWS CLI</em> : Use the <code>describe-environments</code> command to get the value of the <code>CNAME</code> attribute. For more information, see <a href="https://docs.aws.amazon.com/cli/latest/reference/elasticbeanstalk/describe-environments.html">describe-environments</a> in the <em>AWS CLI</em> .</li>
             *                <li><strong>ELB load balancer</strong> - Specify the DNS name that is associated with the load balancer. Get the DNS name by using the AWS Management Console , the ELB API, or the AWS CLI .</li>
             *                <li><em>AWS Management Console</em> : Go to the EC2 page, choose <em>Load Balancers</em> in the navigation pane, choose the load balancer, choose the <em>Description</em> tab, and get the value of the <em>DNS name</em> field.</li>
             *                </ul>
             *                <p>
             *                If you're routing traffic to a Classic Load Balancer, get the value that begins with <em>dualstack</em> . If you're routing traffic to another type of load balancer, get the value that applies to the record type, A or AAAA.
             *                <p>
             *                <ul>
             *                <li><em>Elastic Load Balancing API</em> : Use <code>DescribeLoadBalancers</code> to get the value of <code>DNSName</code> . For more information, see the applicable guide:</li>
             *                <li>Classic Load Balancers: <a href="https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a></li>
             *                <li>Application and Network Load Balancers: <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a></li>
             *                <li><em>CloudFormation Fn::GetAtt intrinsic function</em> : Use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-getatt.html">Fn::GetAtt</a> intrinsic function to get the value of <code>DNSName</code> :</li>
             *                <li><a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#aws-properties-ec2-elb-return-values">Classic Load Balancers</a> .</li>
             *                <li><a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#aws-resource-elasticloadbalancingv2-loadbalancer-return-values">Application and Network Load Balancers</a> .</li>
             *                <li><em>AWS CLI</em> : Use <code>describe-load-balancers</code> to get the value of <code>DNSName</code> . For more information, see the applicable guide:</li>
             *                <li>Classic Load Balancers: <a href="https://docs.aws.amazon.com/cli/latest/reference/elb/describe-load-balancers.html">describe-load-balancers</a></li>
             *                <li>Application and Network Load Balancers: <a href="https://docs.aws.amazon.com/cli/latest/reference/elbv2/describe-load-balancers.html">describe-load-balancers</a></li>
             *                <li><strong>Global Accelerator accelerator</strong> - Specify the DNS name for your accelerator:</li>
             *                <li><em>Global Accelerator API</em> : To get the DNS name, use <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeAccelerator.html">DescribeAccelerator</a> .</li>
             *                <li><em>AWS CLI</em> : To get the DNS name, use <a href="https://docs.aws.amazon.com/cli/latest/reference/globalaccelerator/describe-accelerator.html">describe-accelerator</a> .</li>
             *                <li><strong>Amazon S3 bucket that is configured as a static website</strong> - Specify the domain name of the Amazon S3 website endpoint that you created the bucket in, for example, <code>s3-website.us-east-2.amazonaws.com</code> . For more information about valid values, see the table <a href="https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_website_region_endpoints">Amazon S3 Website Endpoints</a> in the <em>Amazon Web Services General Reference</em> . For more information about using S3 buckets for websites, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/getting-started.html">Getting Started with Amazon Route 53</a> in the <em>Amazon Route 53 Developer Guide.</em></li>
             *                <li><strong>Another Route 53 record</strong> - Specify the value of the <code>Name</code> element for a record in the current hosted zone.</li>
             *                </ul>
             *                <p>
             *                <blockquote>
             *                <p>
             *                If you're creating an alias record that has the same name as the hosted zone (known as the zone apex), you can't specify the domain name for a record for which the value of <code>Type</code> is <code>CNAME</code> . This is because the alias record must have the same type as the record that you're routing traffic to, and creating a CNAME record for the zone apex isn't supported even for an alias record.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsName(java.lang.String dnsName) {
                this.dnsName = dnsName;
                return this;
            }

            /**
             * Sets the value of {@link AliasTargetProperty#getHostedZoneId}
             * @param hostedZoneId *Alias resource records sets only* : The value used depends on where you want to route traffic:. This parameter is required.
             *                     <ul>
             *                     <li><strong>Amazon API Gateway custom regional APIs and edge-optimized APIs</strong> - Specify the hosted zone ID for your API. You can get the applicable value using the AWS CLI command <a href="https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-domain-names.html">get-domain-names</a> :</li>
             *                     <li>For regional APIs, specify the value of <code>regionalHostedZoneId</code> .</li>
             *                     <li>For edge-optimized APIs, specify the value of <code>distributionHostedZoneId</code> .</li>
             *                     <li><strong>Amazon Virtual Private Cloud interface VPC endpoint</strong> - Specify the hosted zone ID for your interface endpoint. You can get the value of <code>HostedZoneId</code> using the AWS CLI command <a href="https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-vpc-endpoints.html">describe-vpc-endpoints</a> .</li>
             *                     <li><strong>CloudFront distribution</strong> - Specify <code>Z2FDTNDATAQYW2</code> . This is always the hosted zone ID when you create an alias record that routes traffic to a CloudFront distribution.</li>
             *                     </ul>
             *                     <p>
             *                     <blockquote>
             *                     <p>
             *                     Alias records for CloudFront can't be created in a private zone.
             *                     <p>
             *                     </blockquote>
             *                     <p>
             *                     <ul>
             *                     <li><strong>Elastic Beanstalk environment</strong> - Specify the hosted zone ID for the region that you created the environment in. The environment must have a regionalized subdomain. For a list of regions and the corresponding hosted zone IDs, see <a href="https://docs.aws.amazon.com/general/latest/gr/elasticbeanstalk.html">AWS Elastic Beanstalk endpoints and quotas</a> in the <em>Amazon Web Services General Reference</em> .</li>
             *                     <li><strong>ELB load balancer</strong> - Specify the value of the hosted zone ID for the load balancer. Use the following methods to get the hosted zone ID:</li>
             *                     <li><a href="https://docs.aws.amazon.com/general/latest/gr/elb.html">Service Endpoints</a> table in the "Elastic Load Balancing Endpoints and Quotas" topic in the <em>Amazon Web Services General Reference</em> : Use the value that corresponds with the region that you created your load balancer in. Note that there are separate columns for Application and Classic Load Balancers and for Network Load Balancers.</li>
             *                     <li><em>AWS Management Console</em> : Go to the Amazon EC2 page, choose <em>Load Balancers</em> in the navigation pane, select the load balancer, and get the value of the <em>Hosted zone</em> field on the <em>Description</em> tab.</li>
             *                     <li><em>Elastic Load Balancing API</em> : Use <code>DescribeLoadBalancers</code> to get the applicable value. For more information, see the applicable guide:</li>
             *                     <li>Classic Load Balancers: Use <a href="https://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> to get the value of <code>CanonicalHostedZoneNameID</code> .</li>
             *                     <li>Application and Network Load Balancers: Use <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> to get the value of <code>CanonicalHostedZoneID</code> .</li>
             *                     <li><em>CloudFormation Fn::GetAtt intrinsic function</em> : Use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-getatt.html">Fn::GetAtt</a> intrinsic function to get the applicable value:</li>
             *                     <li>Classic Load Balancers: Get <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-elb.html#aws-properties-ec2-elb-return-values">CanonicalHostedZoneNameID</a> .</li>
             *                     <li>Application and Network Load Balancers: Get <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#aws-resource-elasticloadbalancingv2-loadbalancer-return-values">CanonicalHostedZoneID</a> .</li>
             *                     <li><em>AWS CLI</em> : Use <code>describe-load-balancers</code> to get the applicable value. For more information, see the applicable guide:</li>
             *                     <li>Classic Load Balancers: Use <a href="https://docs.aws.amazon.com/cli/latest/reference/elb/describe-load-balancers.html">describe-load-balancers</a> to get the value of <code>CanonicalHostedZoneNameID</code> .</li>
             *                     <li>Application and Network Load Balancers: Use <a href="https://docs.aws.amazon.com/cli/latest/reference/elbv2/describe-load-balancers.html">describe-load-balancers</a> to get the value of <code>CanonicalHostedZoneID</code> .</li>
             *                     <li><strong>Global Accelerator accelerator</strong> - Specify <code>Z2BJ6XQ5FK7U4H</code> .</li>
             *                     <li><strong>An Amazon S3 bucket configured as a static website</strong> - Specify the hosted zone ID for the region that you created the bucket in. For more information about valid values, see the table <a href="https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_website_region_endpoints">Amazon S3 Website Endpoints</a> in the <em>Amazon Web Services General Reference</em> .</li>
             *                     <li><strong>Another Route 53 record in your hosted zone</strong> - Specify the hosted zone ID of your hosted zone. (An alias record can't reference a record in a different hosted zone.)</li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostedZoneId(java.lang.String hostedZoneId) {
                this.hostedZoneId = hostedZoneId;
                return this;
            }

            /**
             * Sets the value of {@link AliasTargetProperty#getEvaluateTargetHealth}
             * @param evaluateTargetHealth *Applies only to alias, failover alias, geolocation alias, latency alias, and weighted alias resource record sets:* When `EvaluateTargetHealth` is `true` , an alias resource record set inherits the health of the referenced AWS resource, such as an ELB load balancer or another resource record set in the hosted zone.
             *                             Note the following:
             *                             <p>
             *                             <ul>
             *                             <li><strong>CloudFront distributions</strong> - You can't set <code>EvaluateTargetHealth</code> to <code>true</code> when the alias target is a CloudFront distribution.</li>
             *                             <li><strong>Elastic Beanstalk environments that have regionalized subdomains</strong> - If you specify an Elastic Beanstalk environment in <code>DNSName</code> and the environment contains an ELB load balancer, Elastic Load Balancing routes queries only to the healthy Amazon EC2 instances that are registered with the load balancer. (An environment automatically contains an ELB load balancer if it includes more than one Amazon EC2 instance.) If you set <code>EvaluateTargetHealth</code> to <code>true</code> and either no Amazon EC2 instances are healthy or the load balancer itself is unhealthy, Route 53 routes queries to other available resources that are healthy, if any.</li>
             *                             </ul>
             *                             <p>
             *                             If the environment contains a single Amazon EC2 instance, there are no special requirements.
             *                             <p>
             *                             <ul>
             *                             <li><strong>ELB load balancers</strong> - Health checking behavior depends on the type of load balancer:</li>
             *                             <li><em>Classic Load Balancers</em> : If you specify an ELB Classic Load Balancer in <code>DNSName</code> , Elastic Load Balancing routes queries only to the healthy Amazon EC2 instances that are registered with the load balancer. If you set <code>EvaluateTargetHealth</code> to <code>true</code> and either no EC2 instances are healthy or the load balancer itself is unhealthy, Route 53 routes queries to other resources.</li>
             *                             <li><em>Application and Network Load Balancers</em> : If you specify an ELB Application or Network Load Balancer and you set <code>EvaluateTargetHealth</code> to <code>true</code> , Route 53 routes queries to the load balancer based on the health of the target groups that are associated with the load balancer:</li>
             *                             <li>For an Application or Network Load Balancer to be considered healthy, every target group that contains targets must contain at least one healthy target. If any target group contains only unhealthy targets, the load balancer is considered unhealthy, and Route 53 routes queries to other resources.</li>
             *                             <li>A target group that has no registered targets is considered unhealthy.</li>
             *                             </ul>
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             When you create a load balancer, you configure settings for Elastic Load Balancing health checks; they're not Route 53 health checks, but they perform a similar function. Do not create Route 53 health checks for the EC2 instances that you register with an ELB load balancer.
             *                             <p>
             *                             </blockquote>
             *                             <p>
             *                             <ul>
             *                             <li><strong>S3 buckets</strong> - There are no special requirements for setting <code>EvaluateTargetHealth</code> to <code>true</code> when the alias target is an S3 bucket.</li>
             *                             <li><strong>Other records in the same hosted zone</strong> - If the AWS resource that you specify in <code>DNSName</code> is a record or a group of records (for example, a group of weighted records) but is not another alias record, we recommend that you associate a health check with all of the records in the alias target. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-complex-configs.html#dns-failover-complex-configs-hc-omitting">What Happens When You Omit Health Checks?</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
             *                             </ul>
             *                             <p>
             *                             For more information and examples, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Amazon Route 53 Health Checks and DNS Failover</a> in the <em>Amazon Route 53 Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluateTargetHealth(java.lang.Boolean evaluateTargetHealth) {
                this.evaluateTargetHealth = evaluateTargetHealth;
                return this;
            }

            /**
             * Sets the value of {@link AliasTargetProperty#getEvaluateTargetHealth}
             * @param evaluateTargetHealth *Applies only to alias, failover alias, geolocation alias, latency alias, and weighted alias resource record sets:* When `EvaluateTargetHealth` is `true` , an alias resource record set inherits the health of the referenced AWS resource, such as an ELB load balancer or another resource record set in the hosted zone.
             *                             Note the following:
             *                             <p>
             *                             <ul>
             *                             <li><strong>CloudFront distributions</strong> - You can't set <code>EvaluateTargetHealth</code> to <code>true</code> when the alias target is a CloudFront distribution.</li>
             *                             <li><strong>Elastic Beanstalk environments that have regionalized subdomains</strong> - If you specify an Elastic Beanstalk environment in <code>DNSName</code> and the environment contains an ELB load balancer, Elastic Load Balancing routes queries only to the healthy Amazon EC2 instances that are registered with the load balancer. (An environment automatically contains an ELB load balancer if it includes more than one Amazon EC2 instance.) If you set <code>EvaluateTargetHealth</code> to <code>true</code> and either no Amazon EC2 instances are healthy or the load balancer itself is unhealthy, Route 53 routes queries to other available resources that are healthy, if any.</li>
             *                             </ul>
             *                             <p>
             *                             If the environment contains a single Amazon EC2 instance, there are no special requirements.
             *                             <p>
             *                             <ul>
             *                             <li><strong>ELB load balancers</strong> - Health checking behavior depends on the type of load balancer:</li>
             *                             <li><em>Classic Load Balancers</em> : If you specify an ELB Classic Load Balancer in <code>DNSName</code> , Elastic Load Balancing routes queries only to the healthy Amazon EC2 instances that are registered with the load balancer. If you set <code>EvaluateTargetHealth</code> to <code>true</code> and either no EC2 instances are healthy or the load balancer itself is unhealthy, Route 53 routes queries to other resources.</li>
             *                             <li><em>Application and Network Load Balancers</em> : If you specify an ELB Application or Network Load Balancer and you set <code>EvaluateTargetHealth</code> to <code>true</code> , Route 53 routes queries to the load balancer based on the health of the target groups that are associated with the load balancer:</li>
             *                             <li>For an Application or Network Load Balancer to be considered healthy, every target group that contains targets must contain at least one healthy target. If any target group contains only unhealthy targets, the load balancer is considered unhealthy, and Route 53 routes queries to other resources.</li>
             *                             <li>A target group that has no registered targets is considered unhealthy.</li>
             *                             </ul>
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             When you create a load balancer, you configure settings for Elastic Load Balancing health checks; they're not Route 53 health checks, but they perform a similar function. Do not create Route 53 health checks for the EC2 instances that you register with an ELB load balancer.
             *                             <p>
             *                             </blockquote>
             *                             <p>
             *                             <ul>
             *                             <li><strong>S3 buckets</strong> - There are no special requirements for setting <code>EvaluateTargetHealth</code> to <code>true</code> when the alias target is an S3 bucket.</li>
             *                             <li><strong>Other records in the same hosted zone</strong> - If the AWS resource that you specify in <code>DNSName</code> is a record or a group of records (for example, a group of weighted records) but is not another alias record, we recommend that you associate a health check with all of the records in the alias target. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-complex-configs.html#dns-failover-complex-configs-hc-omitting">What Happens When You Omit Health Checks?</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
             *                             </ul>
             *                             <p>
             *                             For more information and examples, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Amazon Route 53 Health Checks and DNS Failover</a> in the <em>Amazon Route 53 Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluateTargetHealth(software.amazon.awscdk.IResolvable evaluateTargetHealth) {
                this.evaluateTargetHealth = evaluateTargetHealth;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AliasTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AliasTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AliasTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AliasTargetProperty {
            private final java.lang.String dnsName;
            private final java.lang.String hostedZoneId;
            private final java.lang.Object evaluateTargetHealth;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dnsName = software.amazon.jsii.Kernel.get(this, "dnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostedZoneId = software.amazon.jsii.Kernel.get(this, "hostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.evaluateTargetHealth = software.amazon.jsii.Kernel.get(this, "evaluateTargetHealth", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dnsName = java.util.Objects.requireNonNull(builder.dnsName, "dnsName is required");
                this.hostedZoneId = java.util.Objects.requireNonNull(builder.hostedZoneId, "hostedZoneId is required");
                this.evaluateTargetHealth = builder.evaluateTargetHealth;
            }

            @Override
            public final java.lang.String getDnsName() {
                return this.dnsName;
            }

            @Override
            public final java.lang.String getHostedZoneId() {
                return this.hostedZoneId;
            }

            @Override
            public final java.lang.Object getEvaluateTargetHealth() {
                return this.evaluateTargetHealth;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dnsName", om.valueToTree(this.getDnsName()));
                data.set("hostedZoneId", om.valueToTree(this.getHostedZoneId()));
                if (this.getEvaluateTargetHealth() != null) {
                    data.set("evaluateTargetHealth", om.valueToTree(this.getEvaluateTargetHealth()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.CfnRecordSet.AliasTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AliasTargetProperty.Jsii$Proxy that = (AliasTargetProperty.Jsii$Proxy) o;

                if (!dnsName.equals(that.dnsName)) return false;
                if (!hostedZoneId.equals(that.hostedZoneId)) return false;
                return this.evaluateTargetHealth != null ? this.evaluateTargetHealth.equals(that.evaluateTargetHealth) : that.evaluateTargetHealth == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dnsName.hashCode();
                result = 31 * result + (this.hostedZoneId.hashCode());
                result = 31 * result + (this.evaluateTargetHealth != null ? this.evaluateTargetHealth.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53.*;
     * CidrRoutingConfigProperty cidrRoutingConfigProperty = CidrRoutingConfigProperty.builder()
     *         .collectionId("collectionId")
     *         .locationName("locationName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CfnRecordSet.CidrRoutingConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CidrRoutingConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CidrRoutingConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnRecordSet.CidrRoutingConfigProperty.CollectionId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCollectionId();

        /**
         * `CfnRecordSet.CidrRoutingConfigProperty.LocationName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocationName();

        /**
         * @return a {@link Builder} of {@link CidrRoutingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CidrRoutingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CidrRoutingConfigProperty> {
            java.lang.String collectionId;
            java.lang.String locationName;

            /**
             * Sets the value of {@link CidrRoutingConfigProperty#getCollectionId}
             * @param collectionId `CfnRecordSet.CidrRoutingConfigProperty.CollectionId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder collectionId(java.lang.String collectionId) {
                this.collectionId = collectionId;
                return this;
            }

            /**
             * Sets the value of {@link CidrRoutingConfigProperty#getLocationName}
             * @param locationName `CfnRecordSet.CidrRoutingConfigProperty.LocationName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder locationName(java.lang.String locationName) {
                this.locationName = locationName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CidrRoutingConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CidrRoutingConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CidrRoutingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CidrRoutingConfigProperty {
            private final java.lang.String collectionId;
            private final java.lang.String locationName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.collectionId = software.amazon.jsii.Kernel.get(this, "collectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.locationName = software.amazon.jsii.Kernel.get(this, "locationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.collectionId = java.util.Objects.requireNonNull(builder.collectionId, "collectionId is required");
                this.locationName = java.util.Objects.requireNonNull(builder.locationName, "locationName is required");
            }

            @Override
            public final java.lang.String getCollectionId() {
                return this.collectionId;
            }

            @Override
            public final java.lang.String getLocationName() {
                return this.locationName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("collectionId", om.valueToTree(this.getCollectionId()));
                data.set("locationName", om.valueToTree(this.getLocationName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.CfnRecordSet.CidrRoutingConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CidrRoutingConfigProperty.Jsii$Proxy that = (CidrRoutingConfigProperty.Jsii$Proxy) o;

                if (!collectionId.equals(that.collectionId)) return false;
                return this.locationName.equals(that.locationName);
            }

            @Override
            public final int hashCode() {
                int result = this.collectionId.hashCode();
                result = 31 * result + (this.locationName.hashCode());
                return result;
            }
        }
    }
    /**
     * A complex type that contains information about a geographic location.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53.*;
     * GeoLocationProperty geoLocationProperty = GeoLocationProperty.builder()
     *         .continentCode("continentCode")
     *         .countryCode("countryCode")
     *         .subdivisionCode("subdivisionCode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CfnRecordSet.GeoLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(GeoLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GeoLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * For geolocation resource record sets, a two-letter abbreviation that identifies a continent. Route 53 supports the following continent codes:.
         * <p>
         * <ul>
         * <li><em>AF</em> : Africa</li>
         * <li><em>AN</em> : Antarctica</li>
         * <li><em>AS</em> : Asia</li>
         * <li><em>EU</em> : Europe</li>
         * <li><em>OC</em> : Oceania</li>
         * <li><em>NA</em> : North America</li>
         * <li><em>SA</em> : South America</li>
         * </ul>
         * <p>
         * Constraint: Specifying <code>ContinentCode</code> with either <code>CountryCode</code> or <code>SubdivisionCode</code> returns an <code>InvalidInput</code> error.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContinentCode() {
            return null;
        }

        /**
         * For geolocation resource record sets, the two-letter code for a country.
         * <p>
         * Route 53 uses the two-letter country codes that are specified in <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCountryCode() {
            return null;
        }

        /**
         * For geolocation resource record sets, the two-letter code for a state of the United States.
         * <p>
         * Route 53 doesn't support any other values for <code>SubdivisionCode</code> . For a list of state abbreviations, see <a href="https://docs.aws.amazon.com/https://pe.usps.com/text/pub28/28apb.htm">Appendix B: Two–Letter State and Possession Abbreviations</a> on the United States Postal Service website.
         * <p>
         * If you specify <code>subdivisioncode</code> , you must also specify <code>US</code> for <code>CountryCode</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubdivisionCode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GeoLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GeoLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GeoLocationProperty> {
            java.lang.String continentCode;
            java.lang.String countryCode;
            java.lang.String subdivisionCode;

            /**
             * Sets the value of {@link GeoLocationProperty#getContinentCode}
             * @param continentCode For geolocation resource record sets, a two-letter abbreviation that identifies a continent. Route 53 supports the following continent codes:.
             *                      <ul>
             *                      <li><em>AF</em> : Africa</li>
             *                      <li><em>AN</em> : Antarctica</li>
             *                      <li><em>AS</em> : Asia</li>
             *                      <li><em>EU</em> : Europe</li>
             *                      <li><em>OC</em> : Oceania</li>
             *                      <li><em>NA</em> : North America</li>
             *                      <li><em>SA</em> : South America</li>
             *                      </ul>
             *                      <p>
             *                      Constraint: Specifying <code>ContinentCode</code> with either <code>CountryCode</code> or <code>SubdivisionCode</code> returns an <code>InvalidInput</code> error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder continentCode(java.lang.String continentCode) {
                this.continentCode = continentCode;
                return this;
            }

            /**
             * Sets the value of {@link GeoLocationProperty#getCountryCode}
             * @param countryCode For geolocation resource record sets, the two-letter code for a country.
             *                    Route 53 uses the two-letter country codes that are specified in <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder countryCode(java.lang.String countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            /**
             * Sets the value of {@link GeoLocationProperty#getSubdivisionCode}
             * @param subdivisionCode For geolocation resource record sets, the two-letter code for a state of the United States.
             *                        Route 53 doesn't support any other values for <code>SubdivisionCode</code> . For a list of state abbreviations, see <a href="https://docs.aws.amazon.com/https://pe.usps.com/text/pub28/28apb.htm">Appendix B: Two–Letter State and Possession Abbreviations</a> on the United States Postal Service website.
             *                        <p>
             *                        If you specify <code>subdivisioncode</code> , you must also specify <code>US</code> for <code>CountryCode</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subdivisionCode(java.lang.String subdivisionCode) {
                this.subdivisionCode = subdivisionCode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GeoLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GeoLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GeoLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeoLocationProperty {
            private final java.lang.String continentCode;
            private final java.lang.String countryCode;
            private final java.lang.String subdivisionCode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.continentCode = software.amazon.jsii.Kernel.get(this, "continentCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.countryCode = software.amazon.jsii.Kernel.get(this, "countryCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subdivisionCode = software.amazon.jsii.Kernel.get(this, "subdivisionCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.continentCode = builder.continentCode;
                this.countryCode = builder.countryCode;
                this.subdivisionCode = builder.subdivisionCode;
            }

            @Override
            public final java.lang.String getContinentCode() {
                return this.continentCode;
            }

            @Override
            public final java.lang.String getCountryCode() {
                return this.countryCode;
            }

            @Override
            public final java.lang.String getSubdivisionCode() {
                return this.subdivisionCode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContinentCode() != null) {
                    data.set("continentCode", om.valueToTree(this.getContinentCode()));
                }
                if (this.getCountryCode() != null) {
                    data.set("countryCode", om.valueToTree(this.getCountryCode()));
                }
                if (this.getSubdivisionCode() != null) {
                    data.set("subdivisionCode", om.valueToTree(this.getSubdivisionCode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.CfnRecordSet.GeoLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GeoLocationProperty.Jsii$Proxy that = (GeoLocationProperty.Jsii$Proxy) o;

                if (this.continentCode != null ? !this.continentCode.equals(that.continentCode) : that.continentCode != null) return false;
                if (this.countryCode != null ? !this.countryCode.equals(that.countryCode) : that.countryCode != null) return false;
                return this.subdivisionCode != null ? this.subdivisionCode.equals(that.subdivisionCode) : that.subdivisionCode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.continentCode != null ? this.continentCode.hashCode() : 0;
                result = 31 * result + (this.countryCode != null ? this.countryCode.hashCode() : 0);
                result = 31 * result + (this.subdivisionCode != null ? this.subdivisionCode.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53.CfnRecordSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53.CfnRecordSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53.CfnRecordSetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53.CfnRecordSetProps.Builder();
        }

        /**
         * For `ChangeResourceRecordSets` requests, the name of the record that you want to create, update, or delete.
         * <p>
         * For <code>ListResourceRecordSets</code> responses, the name of a record in the specified hosted zone.
         * <p>
         * <em>ChangeResourceRecordSets Only</em>
         * <p>
         * Enter a fully qualified domain name, for example, <code>www.example.com</code> . You can optionally include a trailing dot. If you omit the trailing dot, Amazon Route 53 assumes that the domain name that you specify is fully qualified. This means that Route 53 treats <code>www.example.com</code> (without a trailing dot) and <code>www.example.com.</code> (with a trailing dot) as identical.
         * <p>
         * For information about how to specify characters other than <code>a-z</code> , <code>0-9</code> , and <code>-</code> (hyphen) and how to specify internationalized domain names, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a> in the <em>Amazon Route 53 Developer Guide</em> .
         * <p>
         * You can use the asterisk (*) wildcard to replace the leftmost label in a domain name, for example, <code>*.example.com</code> . Note the following:
         * <p>
         * <ul>
         * <li>The * must replace the entire label. For example, you can't specify <code>*prod.example.com</code> or <code>prod*.example.com</code> .</li>
         * <li>The * can't replace any of the middle labels, for example, marketing.*.example.com.</li>
         * <li>If you include * in any position other than the leftmost label in a domain name, DNS treats it as an * character (ASCII 42), not as a wildcard.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * You can't use the * wildcard for resource records sets that have a type of NS.
         * <p>
         * </blockquote>
         * <p>
         * You can use the * wildcard as the leftmost label in a domain name, for example, <code>*.example.com</code> . You can't use an * for one of the middle labels, for example, <code>marketing.*.example.com</code> . In addition, the * must replace the entire label; for example, you can't specify <code>prod*.example.com</code> .
         * <p>
         * @return {@code this}
         * @param name For `ChangeResourceRecordSets` requests, the name of the record that you want to create, update, or delete. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The DNS record type.
         * <p>
         * For information about different record types and how data is encoded for them, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS Resource Record Types</a> in the <em>Amazon Route 53 Developer Guide</em> .
         * <p>
         * Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>DS</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
         * <p>
         * Values for weighted, latency, geolocation, and failover resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code> . When creating a group of weighted, latency, geolocation, or failover resource record sets, specify the same value for all of the resource record sets in the group.
         * <p>
         * Valid values for multivalue answer resource record sets: <code>A</code> | <code>AAAA</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
         * <p>
         * <blockquote>
         * <p>
         * SPF records were formerly used to verify the identity of the sender of email messages. However, we no longer recommend that you create resource record sets for which the value of <code>Type</code> is <code>SPF</code> . RFC 7208, <em>Sender Policy Framework (SPF) for Authorizing Use of Domains in Email, Version 1</em> , has been updated to say, "...[I]ts existence and mechanism defined in [RFC4408] have led to some interoperability issues. Accordingly, its use is no longer appropriate for SPF version 1; implementations are not to use it." In RFC 7208, see section 14.1, <a href="https://docs.aws.amazon.com/http://tools.ietf.org/html/rfc7208#section-14.1">The SPF DNS Record Type</a> .
         * <p>
         * </blockquote>
         * <p>
         * Values for alias resource record sets:
         * <p>
         * <ul>
         * <li><em>Amazon API Gateway custom regional APIs and edge-optimized APIs:</em> <code>A</code></li>
         * <li><em>CloudFront distributions:</em> <code>A</code></li>
         * </ul>
         * <p>
         * If IPv6 is enabled for the distribution, create two resource record sets to route traffic to your distribution, one with a value of <code>A</code> and one with a value of <code>AAAA</code> .
         * <p>
         * <ul>
         * <li><em>Amazon API Gateway environment that has a regionalized subdomain</em> : <code>A</code></li>
         * <li><em>ELB load balancers:</em> <code>A</code> | <code>AAAA</code></li>
         * <li><em>Amazon S3 buckets:</em> <code>A</code></li>
         * <li><em>Amazon Virtual Private Cloud interface VPC endpoints</em> <code>A</code></li>
         * <li><em>Another resource record set in this hosted zone:</em> Specify the type of the resource record set that you're creating the alias for. All values are supported except <code>NS</code> and <code>SOA</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you're creating an alias record that has the same name as the hosted zone (known as the zone apex), you can't route traffic to a record for which the value of <code>Type</code> is <code>CNAME</code> . This is because the alias record must have the same type as the record you're routing traffic to, and creating a CNAME record for the zone apex isn't supported even for an alias record.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param type The DNS record type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * *Alias resource record sets only:* Information about the AWS resource, such as a CloudFront distribution or an Amazon S3 bucket, that you want to route traffic to.
         * <p>
         * If you're creating resource records sets for a private hosted zone, note the following:
         * <p>
         * <ul>
         * <li>You can't create an alias resource record set in a private hosted zone to route traffic to a CloudFront distribution.</li>
         * <li>Creating geolocation alias resource record sets or latency alias resource record sets in a private hosted zone is unsupported.</li>
         * <li>For information about creating failover resource record sets in a private hosted zone, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param aliasTarget *Alias resource record sets only:* Information about the AWS resource, such as a CloudFront distribution or an Amazon S3 bucket, that you want to route traffic to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasTarget(final software.amazon.awscdk.services.route53.CfnRecordSet.AliasTargetProperty aliasTarget) {
            this.props.aliasTarget(aliasTarget);
            return this;
        }
        /**
         * *Alias resource record sets only:* Information about the AWS resource, such as a CloudFront distribution or an Amazon S3 bucket, that you want to route traffic to.
         * <p>
         * If you're creating resource records sets for a private hosted zone, note the following:
         * <p>
         * <ul>
         * <li>You can't create an alias resource record set in a private hosted zone to route traffic to a CloudFront distribution.</li>
         * <li>Creating geolocation alias resource record sets or latency alias resource record sets in a private hosted zone is unsupported.</li>
         * <li>For information about creating failover resource record sets in a private hosted zone, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a> in the <em>Amazon Route 53 Developer Guide</em> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param aliasTarget *Alias resource record sets only:* Information about the AWS resource, such as a CloudFront distribution or an Amazon S3 bucket, that you want to route traffic to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasTarget(final software.amazon.awscdk.IResolvable aliasTarget) {
            this.props.aliasTarget(aliasTarget);
            return this;
        }

        /**
         * `AWS::Route53::RecordSet.CidrRoutingConfig`.
         * <p>
         * @return {@code this}
         * @param cidrRoutingConfig `AWS::Route53::RecordSet.CidrRoutingConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrRoutingConfig(final software.amazon.awscdk.services.route53.CfnRecordSet.CidrRoutingConfigProperty cidrRoutingConfig) {
            this.props.cidrRoutingConfig(cidrRoutingConfig);
            return this;
        }
        /**
         * `AWS::Route53::RecordSet.CidrRoutingConfig`.
         * <p>
         * @return {@code this}
         * @param cidrRoutingConfig `AWS::Route53::RecordSet.CidrRoutingConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrRoutingConfig(final software.amazon.awscdk.IResolvable cidrRoutingConfig) {
            this.props.cidrRoutingConfig(cidrRoutingConfig);
            return this;
        }

        /**
         * *Optional:* Any comments you want to include about a change batch request.
         * <p>
         * @return {@code this}
         * @param comment *Optional:* Any comments you want to include about a change batch request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * *Failover resource record sets only:* To configure failover, you add the `Failover` element to two resource record sets.
         * <p>
         * For one resource record set, you specify <code>PRIMARY</code> as the value for <code>Failover</code> ; for the other resource record set, you specify <code>SECONDARY</code> . In addition, you include the <code>HealthCheckId</code> element and specify the health check that you want Amazon Route 53 to perform for each resource record set.
         * <p>
         * Except where noted, the following failover behaviors assume that you have included the <code>HealthCheckId</code> element in both resource record sets:
         * <p>
         * <ul>
         * <li>When the primary resource record set is healthy, Route 53 responds to DNS queries with the applicable value from the primary resource record set regardless of the health of the secondary resource record set.</li>
         * <li>When the primary resource record set is unhealthy and the secondary resource record set is healthy, Route 53 responds to DNS queries with the applicable value from the secondary resource record set.</li>
         * <li>When the secondary resource record set is unhealthy, Route 53 responds to DNS queries with the applicable value from the primary resource record set regardless of the health of the primary resource record set.</li>
         * <li>If you omit the <code>HealthCheckId</code> element for the secondary resource record set, and if the primary resource record set is unhealthy, Route 53 always responds to DNS queries with the applicable value from the secondary resource record set. This is true regardless of the health of the associated endpoint.</li>
         * </ul>
         * <p>
         * You can't create non-failover resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as failover resource record sets.
         * <p>
         * For failover alias resource record sets, you must also include the <code>EvaluateTargetHealth</code> element and set the value to true.
         * <p>
         * For more information about configuring failover for Route 53, see the following topics in the <em>Amazon Route 53 Developer Guide</em> :
         * <p>
         * <ul>
         * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health Checks and DNS Failover</a></li>
         * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param failover *Failover resource record sets only:* To configure failover, you add the `Failover` element to two resource record sets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failover(final java.lang.String failover) {
            this.props.failover(failover);
            return this;
        }

        /**
         * *Geolocation resource record sets only:* A complex type that lets you control how Amazon Route 53 responds to DNS queries based on the geographic origin of the query.
         * <p>
         * For example, if you want all queries from Africa to be routed to a web server with an IP address of <code>192.0.2.111</code> , create a resource record set with a <code>Type</code> of <code>A</code> and a <code>ContinentCode</code> of <code>AF</code> .
         * <p>
         * <blockquote>
         * <p>
         * Although creating geolocation and geolocation alias resource record sets in a private hosted zone is allowed, it's not supported.
         * <p>
         * </blockquote>
         * <p>
         * If you create separate resource record sets for overlapping geographic regions (for example, one resource record set for a continent and one for a country on the same continent), priority goes to the smallest geographic region. This allows you to route most queries for a continent to one resource and to route queries for a country on that continent to a different resource.
         * <p>
         * You can't create two geolocation resource record sets that specify the same geographic location.
         * <p>
         * The value <code>*</code> in the <code>CountryCode</code> element matches all geographic locations that aren't specified in other geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements.
         * <p>
         * <blockquote>
         * <p>
         * Geolocation works by mapping IP addresses to locations. However, some IP addresses aren't mapped to geographic locations, so even if you create geolocation resource record sets that cover all seven continents, Route 53 will receive some DNS queries from locations that it can't identify. We recommend that you create a resource record set for which the value of <code>CountryCode</code> is <code>*</code> . Two groups of queries are routed to the resource that you specify in this record: queries that come from locations for which you haven't created geolocation resource record sets and queries from IP addresses that aren't mapped to a location. If you don't create a <code>*</code> resource record set, Route 53 returns a "no answer" response for queries from those locations.
         * <p>
         * </blockquote>
         * <p>
         * You can't create non-geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as geolocation resource record sets.
         * <p>
         * @return {@code this}
         * @param geoLocation *Geolocation resource record sets only:* A complex type that lets you control how Amazon Route 53 responds to DNS queries based on the geographic origin of the query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder geoLocation(final software.amazon.awscdk.services.route53.CfnRecordSet.GeoLocationProperty geoLocation) {
            this.props.geoLocation(geoLocation);
            return this;
        }
        /**
         * *Geolocation resource record sets only:* A complex type that lets you control how Amazon Route 53 responds to DNS queries based on the geographic origin of the query.
         * <p>
         * For example, if you want all queries from Africa to be routed to a web server with an IP address of <code>192.0.2.111</code> , create a resource record set with a <code>Type</code> of <code>A</code> and a <code>ContinentCode</code> of <code>AF</code> .
         * <p>
         * <blockquote>
         * <p>
         * Although creating geolocation and geolocation alias resource record sets in a private hosted zone is allowed, it's not supported.
         * <p>
         * </blockquote>
         * <p>
         * If you create separate resource record sets for overlapping geographic regions (for example, one resource record set for a continent and one for a country on the same continent), priority goes to the smallest geographic region. This allows you to route most queries for a continent to one resource and to route queries for a country on that continent to a different resource.
         * <p>
         * You can't create two geolocation resource record sets that specify the same geographic location.
         * <p>
         * The value <code>*</code> in the <code>CountryCode</code> element matches all geographic locations that aren't specified in other geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements.
         * <p>
         * <blockquote>
         * <p>
         * Geolocation works by mapping IP addresses to locations. However, some IP addresses aren't mapped to geographic locations, so even if you create geolocation resource record sets that cover all seven continents, Route 53 will receive some DNS queries from locations that it can't identify. We recommend that you create a resource record set for which the value of <code>CountryCode</code> is <code>*</code> . Two groups of queries are routed to the resource that you specify in this record: queries that come from locations for which you haven't created geolocation resource record sets and queries from IP addresses that aren't mapped to a location. If you don't create a <code>*</code> resource record set, Route 53 returns a "no answer" response for queries from those locations.
         * <p>
         * </blockquote>
         * <p>
         * You can't create non-geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as geolocation resource record sets.
         * <p>
         * @return {@code this}
         * @param geoLocation *Geolocation resource record sets only:* A complex type that lets you control how Amazon Route 53 responds to DNS queries based on the geographic origin of the query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder geoLocation(final software.amazon.awscdk.IResolvable geoLocation) {
            this.props.geoLocation(geoLocation);
            return this;
        }

        /**
         * If you want Amazon Route 53 to return this resource record set in response to a DNS query only when the status of a health check is healthy, include the `HealthCheckId` element and specify the ID of the applicable health check.
         * <p>
         * Route 53 determines whether a resource record set is healthy based on one of the following:
         * <p>
         * <ul>
         * <li>By periodically sending a request to the endpoint that is specified in the health check</li>
         * <li>By aggregating the status of a specified group of health checks (calculated health checks)</li>
         * <li>By determining the current state of a CloudWatch alarm (CloudWatch metric health checks)</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Route 53 doesn't check the health of the endpoint that is specified in the resource record set, for example, the endpoint specified by the IP address in the <code>Value</code> element. When you add a <code>HealthCheckId</code> element to a resource record set, Route 53 checks the health of the endpoint that you specified in the health check.
         * <p>
         * </blockquote>
         * <p>
         * For more information, see the following topics in the <em>Amazon Route 53 Developer Guide</em> :
         * <p>
         * <ul>
         * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html">How Amazon Route 53 Determines Whether an Endpoint Is Healthy</a></li>
         * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html">Route 53 Health Checks and DNS Failover</a></li>
         * <li><a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html">Configuring Failover in a Private Hosted Zone</a></li>
         * </ul>
         * <p>
         * <em>When to Specify HealthCheckId</em>
         * <p>
         * Specifying a value for <code>HealthCheckId</code> is useful only when Route 53 is choosing between two or more resource record sets to respond to a DNS query, and you want Route 53 to base the choice in part on the status of a health check. Configuring health checks makes sense only in the following configurations:
         * <p>
         * <ul>
         * <li><em>Non-alias resource record sets</em> : You're checking the health of a group of non-alias resource record sets that have the same routing policy, name, and type (such as multiple weighted records named www.example.com with a type of A) and you specify health check IDs for all the resource record sets.</li>
         * </ul>
         * <p>
         * If the health check status for a resource record set is healthy, Route 53 includes the record among the records that it responds to DNS queries with.
         * <p>
         * If the health check status for a resource record set is unhealthy, Route 53 stops responding to DNS queries using the value for that resource record set.
         * <p>
         * If the health check status for all resource record sets in the group is unhealthy, Route 53 considers all resource record sets in the group healthy and responds to DNS queries accordingly.
         * <p>
         * <ul>
         * <li><em>Alias resource record sets</em> : You specify the following settings:</li>
         * <li>You set <code>EvaluateTargetHealth</code> to true for an alias resource record set in a group of resource record sets that have the same routing policy, name, and type (such as multiple weighted records named www.example.com with a type of A).</li>
         * <li>You configure the alias resource record set to route traffic to a non-alias resource record set in the same hosted zone.</li>
         * <li>You specify a health check ID for the non-alias resource record set.</li>
         * </ul>
         * <p>
         * If the health check status is healthy, Route 53 considers the alias resource record set to be healthy and includes the alias record among the records that it responds to DNS queries with.
         * <p>
         * If the health check status is unhealthy, Route 53 stops responding to DNS queries using the alias resource record set.
         * <p>
         * <blockquote>
         * <p>
         * The alias resource record set can also route traffic to a <em>group</em> of non-alias resource record sets that have the same routing policy, name, and type. In that configuration, associate health checks with all of the resource record sets in the group of non-alias resource record sets.
         * <p>
         * </blockquote>
         * <p>
         * <em>Geolocation Routing</em>
         * <p>
         * For geolocation resource record sets, if an endpoint is unhealthy, Route 53 looks for a resource record set for the larger, associated geographic region. For example, suppose you have resource record sets for a state in the United States, for the entire United States, for North America, and a resource record set that has <code>*</code> for <code>CountryCode</code> is <code>*</code> , which applies to all locations. If the endpoint for the state resource record set is unhealthy, Route 53 checks for healthy resource record sets in the following order until it finds a resource record set for which the endpoint is healthy:
         * <p>
         * <ul>
         * <li>The United States</li>
         * <li>North America</li>
         * <li>The default resource record set</li>
         * </ul>
         * <p>
         * <em>Specifying the Health Check Endpoint by Domain Name</em>
         * <p>
         * If your health checks specify the endpoint only by domain name, we recommend that you create a separate health check for each endpoint. For example, create a health check for each <code>HTTP</code> server that is serving content for <code>www.example.com</code> . For the value of <code>FullyQualifiedDomainName</code> , specify the domain name of the server (such as <code>us-east-2-www.example.com</code> ), not the name of the resource record sets ( <code>www.example.com</code> ).
         * <p>
         * <blockquote>
         * <p>
         * Health check results will be unpredictable if you do the following:
         * <p>
         * <ul>
         * <li>Create a health check that has the same value for <code>FullyQualifiedDomainName</code> as the name of a resource record set.</li>
         * <li>Associate that health check with the resource record set.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param healthCheckId If you want Amazon Route 53 to return this resource record set in response to a DNS query only when the status of a health check is healthy, include the `HealthCheckId` element and specify the ID of the applicable health check. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckId(final java.lang.String healthCheckId) {
            this.props.healthCheckId(healthCheckId);
            return this;
        }

        /**
         * The ID of the hosted zone that you want to create records in.
         * <p>
         * Specify either <code>HostedZoneName</code> or <code>HostedZoneId</code> , but not both. If you have multiple hosted zones with the same domain name, you must specify the hosted zone using <code>HostedZoneId</code> .
         * <p>
         * @return {@code this}
         * @param hostedZoneId The ID of the hosted zone that you want to create records in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneId(final java.lang.String hostedZoneId) {
            this.props.hostedZoneId(hostedZoneId);
            return this;
        }

        /**
         * The name of the hosted zone that you want to create records in.
         * <p>
         * You must include a trailing dot (for example, <code>www.example.com.</code> ) as part of the <code>HostedZoneName</code> .
         * <p>
         * When you create a stack using an AWS::Route53::RecordSet that specifies <code>HostedZoneName</code> , AWS CloudFormation attempts to find a hosted zone whose name matches the HostedZoneName. If AWS CloudFormation cannot find a hosted zone with a matching domain name, or if there is more than one hosted zone with the specified domain name, AWS CloudFormation will not create the stack.
         * <p>
         * Specify either <code>HostedZoneName</code> or <code>HostedZoneId</code> , but not both. If you have multiple hosted zones with the same domain name, you must specify the hosted zone using <code>HostedZoneId</code> .
         * <p>
         * @return {@code this}
         * @param hostedZoneName The name of the hosted zone that you want to create records in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZoneName(final java.lang.String hostedZoneName) {
            this.props.hostedZoneName(hostedZoneName);
            return this;
        }

        /**
         * *Multivalue answer resource record sets only* : To route traffic approximately randomly to multiple resources, such as web servers, create one multivalue answer record for each resource and specify `true` for `MultiValueAnswer` .
         * <p>
         * Note the following:
         * <p>
         * <ul>
         * <li>If you associate a health check with a multivalue answer resource record set, Amazon Route 53 responds to DNS queries with the corresponding IP address only when the health check is healthy.</li>
         * <li>If you don't associate a health check with a multivalue answer record, Route 53 always considers the record to be healthy.</li>
         * <li>Route 53 responds to DNS queries with up to eight healthy records; if you have eight or fewer healthy records, Route 53 responds to all DNS queries with all the healthy records.</li>
         * <li>If you have more than eight healthy records, Route 53 responds to different DNS resolvers with different combinations of healthy records.</li>
         * <li>When all records are unhealthy, Route 53 responds to DNS queries with up to eight unhealthy records.</li>
         * <li>If a resource becomes unavailable after a resolver caches a response, client software typically tries another of the IP addresses in the response.</li>
         * </ul>
         * <p>
         * You can't create multivalue answer alias records.
         * <p>
         * @return {@code this}
         * @param multiValueAnswer *Multivalue answer resource record sets only* : To route traffic approximately randomly to multiple resources, such as web servers, create one multivalue answer record for each resource and specify `true` for `MultiValueAnswer` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiValueAnswer(final java.lang.Boolean multiValueAnswer) {
            this.props.multiValueAnswer(multiValueAnswer);
            return this;
        }
        /**
         * *Multivalue answer resource record sets only* : To route traffic approximately randomly to multiple resources, such as web servers, create one multivalue answer record for each resource and specify `true` for `MultiValueAnswer` .
         * <p>
         * Note the following:
         * <p>
         * <ul>
         * <li>If you associate a health check with a multivalue answer resource record set, Amazon Route 53 responds to DNS queries with the corresponding IP address only when the health check is healthy.</li>
         * <li>If you don't associate a health check with a multivalue answer record, Route 53 always considers the record to be healthy.</li>
         * <li>Route 53 responds to DNS queries with up to eight healthy records; if you have eight or fewer healthy records, Route 53 responds to all DNS queries with all the healthy records.</li>
         * <li>If you have more than eight healthy records, Route 53 responds to different DNS resolvers with different combinations of healthy records.</li>
         * <li>When all records are unhealthy, Route 53 responds to DNS queries with up to eight unhealthy records.</li>
         * <li>If a resource becomes unavailable after a resolver caches a response, client software typically tries another of the IP addresses in the response.</li>
         * </ul>
         * <p>
         * You can't create multivalue answer alias records.
         * <p>
         * @return {@code this}
         * @param multiValueAnswer *Multivalue answer resource record sets only* : To route traffic approximately randomly to multiple resources, such as web servers, create one multivalue answer record for each resource and specify `true` for `MultiValueAnswer` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiValueAnswer(final software.amazon.awscdk.IResolvable multiValueAnswer) {
            this.props.multiValueAnswer(multiValueAnswer);
            return this;
        }

        /**
         * *Latency-based resource record sets only:* The Amazon EC2 Region where you created the resource that this resource record set refers to.
         * <p>
         * The resource typically is an AWS resource, such as an EC2 instance or an ELB load balancer, and is referred to by an IP address or a DNS domain name, depending on the record type.
         * <p>
         * <blockquote>
         * <p>
         * Although creating latency and latency alias resource record sets in a private hosted zone is allowed, it's not supported.
         * <p>
         * </blockquote>
         * <p>
         * When Amazon Route 53 receives a DNS query for a domain name and type for which you have created latency resource record sets, Route 53 selects the latency resource record set that has the lowest latency between the end user and the associated Amazon EC2 Region. Route 53 then returns the value that is associated with the selected resource record set.
         * <p>
         * Note the following:
         * <p>
         * <ul>
         * <li>You can only specify one <code>ResourceRecord</code> per latency resource record set.</li>
         * <li>You can only create one latency resource record set for each Amazon EC2 Region.</li>
         * <li>You aren't required to create latency resource record sets for all Amazon EC2 Regions. Route 53 will choose the region with the best latency from among the regions that you create latency resource record sets for.</li>
         * <li>You can't create non-latency resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as latency resource record sets.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param region *Latency-based resource record sets only:* The Amazon EC2 Region where you created the resource that this resource record set refers to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * One or more values that correspond with the value that you specified for the `Type` property.
         * <p>
         * For example, if you specified <code>A</code> for <code>Type</code> , you specify one or more IP addresses in IPv4 format for <code>ResourceRecords</code> . For information about the format of values for each record type, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html">Supported DNS Resource Record Types</a> in the <em>Amazon Route 53 Developer Guide</em> .
         * <p>
         * Note the following:
         * <p>
         * <ul>
         * <li>You can specify more than one value for all record types except CNAME and SOA.</li>
         * <li>The maximum length of a value is 4000 characters.</li>
         * <li>If you're creating an alias record, omit <code>ResourceRecords</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param resourceRecords One or more values that correspond with the value that you specified for the `Type` property. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceRecords(final java.util.List<java.lang.String> resourceRecords) {
            this.props.resourceRecords(resourceRecords);
            return this;
        }

        /**
         * *Resource record sets that have a routing policy other than simple:* An identifier that differentiates among multiple resource record sets that have the same combination of name and type, such as multiple weighted resource record sets named acme.example.com that have a type of A. In a group of resource record sets that have the same name and type, the value of `SetIdentifier` must be unique for each resource record set.
         * <p>
         * For information about routing policies, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html">Choosing a Routing Policy</a> in the <em>Amazon Route 53 Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param setIdentifier *Resource record sets that have a routing policy other than simple:* An identifier that differentiates among multiple resource record sets that have the same combination of name and type, such as multiple weighted resource record sets named acme.example.com that have a type of A. In a group of resource record sets that have the same name and type, the value of `SetIdentifier` must be unique for each resource record set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder setIdentifier(final java.lang.String setIdentifier) {
            this.props.setIdentifier(setIdentifier);
            return this;
        }

        /**
         * The resource record cache time to live (TTL), in seconds. Note the following:.
         * <p>
         * <ul>
         * <li>If you're creating or updating an alias resource record set, omit <code>TTL</code> . Amazon Route 53 uses the value of <code>TTL</code> for the alias target.</li>
         * <li>If you're associating this resource record set with a health check (if you're adding a <code>HealthCheckId</code> element), we recommend that you specify a <code>TTL</code> of 60 seconds or less so clients respond quickly to changes in health status.</li>
         * <li>All of the resource record sets in a group of weighted resource record sets must have the same value for <code>TTL</code> .</li>
         * <li>If a group of weighted resource record sets includes one or more weighted alias resource record sets for which the alias target is an ELB load balancer, we recommend that you specify a <code>TTL</code> of 60 seconds for all of the non-alias weighted resource record sets that have the same name and type. Values other than 60 seconds (the TTL for load balancers) will change the effect of the values that you specify for <code>Weight</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param ttl The resource record cache time to live (TTL), in seconds. Note the following:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttl(final java.lang.String ttl) {
            this.props.ttl(ttl);
            return this;
        }

        /**
         * *Weighted resource record sets only:* Among resource record sets that have the same combination of DNS name and type, a value that determines the proportion of DNS queries that Amazon Route 53 responds to using the current resource record set.
         * <p>
         * Route 53 calculates the sum of the weights for the resource record sets that have the same combination of DNS name and type. Route 53 then responds to queries based on the ratio of a resource's weight to the total. Note the following:
         * <p>
         * <ul>
         * <li>You must specify a value for the <code>Weight</code> element for every weighted resource record set.</li>
         * <li>You can only specify one <code>ResourceRecord</code> per weighted resource record set.</li>
         * <li>You can't create latency, failover, or geolocation resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements as weighted resource record sets.</li>
         * <li>You can create a maximum of 100 weighted resource record sets that have the same values for the <code>Name</code> and <code>Type</code> elements.</li>
         * <li>For weighted (but not weighted alias) resource record sets, if you set <code>Weight</code> to <code>0</code> for a resource record set, Route 53 never responds to queries with the applicable value for that resource record set. However, if you set <code>Weight</code> to <code>0</code> for all resource record sets that have the same combination of DNS name and type, traffic is routed to all resources with equal probability.</li>
         * </ul>
         * <p>
         * The effect of setting <code>Weight</code> to <code>0</code> is different when you associate health checks with weighted resource record sets. For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html">Options for Configuring Route 53 Active-Active and Active-Passive Failover</a> in the <em>Amazon Route 53 Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param weight *Weighted resource record sets only:* Among resource record sets that have the same combination of DNS name and type, a value that determines the proportion of DNS queries that Amazon Route 53 responds to using the current resource record set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder weight(final java.lang.Number weight) {
            this.props.weight(weight);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.route53.CfnRecordSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53.CfnRecordSet build() {
            return new software.amazon.awscdk.services.route53.CfnRecordSet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
