package software.amazon.awscdk.services.rds;

/**
 * A database cluster restored from a snapshot.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseClusterFromSnapshot.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.aurora(AuroraClusterEngineProps.builder().version(AuroraEngineVersion.VER_1_22_2).build()))
 *         .instanceProps(InstanceProps.builder()
 *                 .vpc(vpc)
 *                 .build())
 *         .snapshotIdentifier("mySnapshot")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:53.741Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseClusterFromSnapshot")
public class DatabaseClusterFromSnapshot extends software.amazon.awscdk.services.rds.DatabaseClusterBase {

    protected DatabaseClusterFromSnapshot(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseClusterFromSnapshot(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DatabaseClusterFromSnapshot(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.DatabaseClusterFromSnapshotProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds the multi user rotation to this cluster.
     * <p>
     * See <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-two-users">Alternating users rotation strategy</a>
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotation addRotationMultiUser(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.RotationMultiUserOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addRotationMultiUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotation.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds the single user rotation of the master password to this cluster.
     * <p>
     * See <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-one-user-one-password">Single user rotation strategy</a>
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotation addRotationSingleUser(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.RotationSingleUserOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addRotationSingleUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotation.class), new Object[] { options });
    }

    /**
     * Adds the single user rotation of the master password to this cluster.
     * <p>
     * See <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets_strategies.html#rotating-secrets-one-user-one-password">Single user rotation strategy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotation addRotationSingleUser() {
        return software.amazon.jsii.Kernel.call(this, "addRotationSingleUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotation.class));
    }

    /**
     * The endpoint to use for read/write operations.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Endpoint getClusterEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Endpoint.class));
    }

    /**
     * Identifier of the cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Endpoint to use for load-balanced read-only operations.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.Endpoint getClusterReadEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "clusterReadEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Endpoint.class));
    }

    /**
     * Access to the network connections.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * Endpoints which address each individual replica.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.rds.Endpoint> getInstanceEndpoints() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "instanceEndpoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.Endpoint.class))));
    }

    /**
     * Identifiers of the replicas.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getInstanceIdentifiers() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "instanceIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Application for multi user rotation to this cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getMultiUserRotationApplication() {
        return software.amazon.jsii.Kernel.get(this, "multiUserRotationApplication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.CfnDBClusterProps getNewCfnProps() {
        return software.amazon.jsii.Kernel.get(this, "newCfnProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CfnDBClusterProps.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class))));
    }

    /**
     * Application for single user rotation of the master password to this cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotationApplication getSingleUserRotationApplication() {
        return software.amazon.jsii.Kernel.get(this, "singleUserRotationApplication", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotationApplication.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.ISubnetGroup getSubnetGroup() {
        return software.amazon.jsii.Kernel.get(this, "subnetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.ISubnetGroup.class));
    }

    /**
     * The VPC network to place the cluster in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
    }

    /**
     * The engine for this Cluster.
     * <p>
     * Never undefined.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.IClusterEngine getEngine() {
        return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IClusterEngine.class));
    }

    /**
     * The secret attached to this cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
        return software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
    }

    /**
     * The cluster's subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.DatabaseClusterFromSnapshot}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.DatabaseClusterFromSnapshot> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.DatabaseClusterFromSnapshotProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.DatabaseClusterFromSnapshotProps.Builder();
        }

        /**
         * What kind of database to start.
         * <p>
         * @return {@code this}
         * @param engine What kind of database to start. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final software.amazon.awscdk.services.rds.IClusterEngine engine) {
            this.props.engine(engine);
            return this;
        }

        /**
         * Settings for the individual instances that are launched.
         * <p>
         * @return {@code this}
         * @param instanceProps Settings for the individual instances that are launched. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProps(final software.amazon.awscdk.services.rds.InstanceProps instanceProps) {
            this.props.instanceProps(instanceProps);
            return this;
        }

        /**
         * The identifier for the DB instance snapshot or DB cluster snapshot to restore from.
         * <p>
         * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot.
         * However, you can use only the ARN to specify a DB instance snapshot.
         * <p>
         * @return {@code this}
         * @param snapshotIdentifier The identifier for the DB instance snapshot or DB cluster snapshot to restore from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotIdentifier(final java.lang.String snapshotIdentifier) {
            this.props.snapshotIdentifier(snapshotIdentifier);
            return this;
        }

        /**
         * The number of seconds to set a cluster's target backtrack window to.
         * <p>
         * This feature is only supported by the Aurora MySQL database engine and
         * cannot be enabled on existing clusters.
         * <p>
         * Default: 0 seconds (no backtrack)
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html</a>
         * @param backtrackWindow The number of seconds to set a cluster's target backtrack window to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backtrackWindow(final software.amazon.awscdk.Duration backtrackWindow) {
            this.props.backtrackWindow(backtrackWindow);
            return this;
        }

        /**
         * Backup settings.
         * <p>
         * Default: - Backup retention period for automated backups is 1 day.
         * Backup preferred window is set to a 30-minute window selected at random from an
         * 8-hour block of time for each AWS Region, occurring on a random day of the week.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow</a>
         * @param backup Backup settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backup(final software.amazon.awscdk.services.rds.BackupProps backup) {
            this.props.backup(backup);
            return this;
        }

        /**
         * The list of log types that need to be enabled for exporting to CloudWatch Logs.
         * <p>
         * Default: - no log exports
         * <p>
         * @return {@code this}
         * @param cloudwatchLogsExports The list of log types that need to be enabled for exporting to CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudwatchLogsExports(final java.util.List<java.lang.String> cloudwatchLogsExports) {
            this.props.cloudwatchLogsExports(cloudwatchLogsExports);
            return this;
        }

        /**
         * The number of days log events are kept in CloudWatch Logs.
         * <p>
         * When updating
         * this property, unsetting it doesn't remove the log retention policy. To
         * remove the retention policy, set the value to <code>Infinity</code>.
         * <p>
         * Default: - logs never expire
         * <p>
         * @return {@code this}
         * @param cloudwatchLogsRetention The number of days log events are kept in CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudwatchLogsRetention(final software.amazon.awscdk.services.logs.RetentionDays cloudwatchLogsRetention) {
            this.props.cloudwatchLogsRetention(cloudwatchLogsRetention);
            return this;
        }

        /**
         * The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * <p>
         * Default: - a new role is created.
         * <p>
         * @return {@code this}
         * @param cloudwatchLogsRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudwatchLogsRetentionRole(final software.amazon.awscdk.services.iam.IRole cloudwatchLogsRetentionRole) {
            this.props.cloudwatchLogsRetentionRole(cloudwatchLogsRetentionRole);
            return this;
        }

        /**
         * An optional identifier for the cluster.
         * <p>
         * Default: - A name is automatically generated.
         * <p>
         * @return {@code this}
         * @param clusterIdentifier An optional identifier for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterIdentifier(final java.lang.String clusterIdentifier) {
            this.props.clusterIdentifier(clusterIdentifier);
            return this;
        }

        /**
         * Whether to copy tags to the snapshot when a snapshot is created.
         * <p>
         * Default: - true
         * <p>
         * @return {@code this}
         * @param copyTagsToSnapshot Whether to copy tags to the snapshot when a snapshot is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(final java.lang.Boolean copyTagsToSnapshot) {
            this.props.copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }

        /**
         * (deprecated) Credentials for the administrative user.
         * <p>
         * Note - using this prop only works with <code>Credentials.fromPassword()</code> with the
         * username of the snapshot, <code>Credentials.fromUsername()</code> with the username and
         * password of the snapshot or <code>Credentials.fromSecret()</code> with a secret containing
         * the username and password of the snapshot.
         * <p>
         * Default: - A username of 'admin' (or 'postgres' for PostgreSQL) and SecretsManager-generated password
         * that **will not be applied** to the cluster, use `snapshotCredentials` for the correct behavior.
         * <p>
         * @return {@code this}
         * @deprecated use `snapshotCredentials` which allows to generate a new password
         * @param credentials Credentials for the administrative user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder credentials(final software.amazon.awscdk.services.rds.Credentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        /**
         * Name of a database which is automatically created inside the cluster.
         * <p>
         * Default: - Database is not created in cluster.
         * <p>
         * @return {@code this}
         * @param defaultDatabaseName Name of a database which is automatically created inside the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultDatabaseName(final java.lang.String defaultDatabaseName) {
            this.props.defaultDatabaseName(defaultDatabaseName);
            return this;
        }

        /**
         * Indicates whether the DB cluster should have deletion protection enabled.
         * <p>
         * Default: - true if ``removalPolicy`` is RETAIN, false otherwise
         * <p>
         * @return {@code this}
         * @param deletionProtection Indicates whether the DB cluster should have deletion protection enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        /**
         * Whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param iamAuthentication Whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamAuthentication(final java.lang.Boolean iamAuthentication) {
            this.props.iamAuthentication(iamAuthentication);
            return this;
        }

        /**
         * Base identifier for instances.
         * <p>
         * Every replica is named by appending the replica number to this string, 1-based.
         * <p>
         * Default: - clusterIdentifier is used with the word "Instance" appended.
         * If clusterIdentifier is not provided, the identifier is automatically generated.
         * <p>
         * @return {@code this}
         * @param instanceIdentifierBase Base identifier for instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceIdentifierBase(final java.lang.String instanceIdentifierBase) {
            this.props.instanceIdentifierBase(instanceIdentifierBase);
            return this;
        }

        /**
         * How many replicas/instances to create.
         * <p>
         * Has to be at least 1.
         * <p>
         * Default: 2
         * <p>
         * @return {@code this}
         * @param instances How many replicas/instances to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instances(final java.lang.Number instances) {
            this.props.instances(instances);
            return this;
        }

        /**
         * The ordering of updates for instances.
         * <p>
         * Default: InstanceUpdateBehaviour.BULK
         * <p>
         * @return {@code this}
         * @param instanceUpdateBehaviour The ordering of updates for instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceUpdateBehaviour(final software.amazon.awscdk.services.rds.InstanceUpdateBehaviour instanceUpdateBehaviour) {
            this.props.instanceUpdateBehaviour(instanceUpdateBehaviour);
            return this;
        }

        /**
         * The interval, in seconds, between points when Amazon RDS collects enhanced monitoring metrics for the DB instances.
         * <p>
         * Default: no enhanced monitoring
         * <p>
         * @return {@code this}
         * @param monitoringInterval The interval, in seconds, between points when Amazon RDS collects enhanced monitoring metrics for the DB instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringInterval(final software.amazon.awscdk.Duration monitoringInterval) {
            this.props.monitoringInterval(monitoringInterval);
            return this;
        }

        /**
         * Role that will be used to manage DB instances monitoring.
         * <p>
         * Default: - A role is automatically created for you
         * <p>
         * @return {@code this}
         * @param monitoringRole Role that will be used to manage DB instances monitoring. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringRole(final software.amazon.awscdk.services.iam.IRole monitoringRole) {
            this.props.monitoringRole(monitoringRole);
            return this;
        }

        /**
         * Additional parameters to pass to the database engine.
         * <p>
         * Default: - No parameter group.
         * <p>
         * @return {@code this}
         * @param parameterGroup Additional parameters to pass to the database engine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterGroup(final software.amazon.awscdk.services.rds.IParameterGroup parameterGroup) {
            this.props.parameterGroup(parameterGroup);
            return this;
        }

        /**
         * The parameters in the DBClusterParameterGroup to create automatically.
         * <p>
         * You can only specify parameterGroup or parameters but not both.
         * You need to use a versioned engine to auto-generate a DBClusterParameterGroup.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param parameters The parameters in the DBClusterParameterGroup to create automatically. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * What port to listen on.
         * <p>
         * Default: - The default for the engine is used.
         * <p>
         * @return {@code this}
         * @param port What port to listen on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * A preferred maintenance window day/time range. Should be specified as a range ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC).
         * <p>
         * Example: 'Sun:23:45-Mon:00:15'
         * <p>
         * Default: - 30-minute window selected at random from an 8-hour block of time for
         * each AWS Region, occurring on a random day of the week.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance</a>
         * @param preferredMaintenanceWindow A preferred maintenance window day/time range. Should be specified as a range ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(final java.lang.String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        /**
         * The removal policy to apply when the cluster and its instances are removed from the stack or replaced during an update.
         * <p>
         * Default: - RemovalPolicy.SNAPSHOT (remove the cluster and instances, but retain a snapshot of the data)
         * <p>
         * @return {@code this}
         * @param removalPolicy The removal policy to apply when the cluster and its instances are removed from the stack or replaced during an update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * S3 buckets that you want to load data into. This feature is only supported by the Aurora database engine.
         * <p>
         * This property must not be used if <code>s3ExportRole</code> is used.
         * <p>
         * For MySQL:
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/postgresql-s3-export.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/postgresql-s3-export.html</a>
         * @param s3ExportBuckets S3 buckets that you want to load data into. This feature is only supported by the Aurora database engine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ExportBuckets(final java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ExportBuckets) {
            this.props.s3ExportBuckets(s3ExportBuckets);
            return this;
        }

        /**
         * Role that will be associated with this DB cluster to enable S3 export.
         * <p>
         * This feature is only supported by the Aurora database engine.
         * <p>
         * This property must not be used if <code>s3ExportBuckets</code> is used.
         * <p>
         * For MySQL:
         * <p>
         * Default: - New role is created if `s3ExportBuckets` is set, no role is defined otherwise
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/postgresql-s3-export.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/postgresql-s3-export.html</a>
         * @param s3ExportRole Role that will be associated with this DB cluster to enable S3 export. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ExportRole(final software.amazon.awscdk.services.iam.IRole s3ExportRole) {
            this.props.s3ExportRole(s3ExportRole);
            return this;
        }

        /**
         * S3 buckets that you want to load data from. This feature is only supported by the Aurora database engine.
         * <p>
         * This property must not be used if <code>s3ImportRole</code> is used.
         * <p>
         * For MySQL:
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Migrating.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Migrating.html</a>
         * @param s3ImportBuckets S3 buckets that you want to load data from. This feature is only supported by the Aurora database engine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ImportBuckets(final java.util.List<? extends software.amazon.awscdk.services.s3.IBucket> s3ImportBuckets) {
            this.props.s3ImportBuckets(s3ImportBuckets);
            return this;
        }

        /**
         * Role that will be associated with this DB cluster to enable S3 import.
         * <p>
         * This feature is only supported by the Aurora database engine.
         * <p>
         * This property must not be used if <code>s3ImportBuckets</code> is used.
         * <p>
         * For MySQL:
         * <p>
         * Default: - New role is created if `s3ImportBuckets` is set, no role is defined otherwise
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Migrating.html">https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Migrating.html</a>
         * @param s3ImportRole Role that will be associated with this DB cluster to enable S3 import. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3ImportRole(final software.amazon.awscdk.services.iam.IRole s3ImportRole) {
            this.props.s3ImportRole(s3ImportRole);
            return this;
        }

        /**
         * Master user credentials.
         * <p>
         * Note - It is not possible to change the master username for a snapshot;
         * however, it is possible to provide (or generate) a new password.
         * <p>
         * Default: - The existing username and password from the snapshot will be used.
         * <p>
         * @return {@code this}
         * @param snapshotCredentials Master user credentials. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotCredentials(final software.amazon.awscdk.services.rds.SnapshotCredentials snapshotCredentials) {
            this.props.snapshotCredentials(snapshotCredentials);
            return this;
        }

        /**
         * Whether to enable storage encryption.
         * <p>
         * Default: - true if storageEncryptionKey is provided, false otherwise
         * <p>
         * @return {@code this}
         * @param storageEncrypted Whether to enable storage encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final java.lang.Boolean storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }

        /**
         * The KMS key for storage encryption.
         * <p>
         * If specified, {&#64;link storageEncrypted} will be set to <code>true</code>.
         * <p>
         * Default: - if storageEncrypted is true then the default master key, no key otherwise
         * <p>
         * @return {@code this}
         * @param storageEncryptionKey The KMS key for storage encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncryptionKey(final software.amazon.awscdk.services.kms.IKey storageEncryptionKey) {
            this.props.storageEncryptionKey(storageEncryptionKey);
            return this;
        }

        /**
         * Existing subnet group for the cluster.
         * <p>
         * Default: - a new subnet group will be created.
         * <p>
         * @return {@code this}
         * @param subnetGroup Existing subnet group for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetGroup(final software.amazon.awscdk.services.rds.ISubnetGroup subnetGroup) {
            this.props.subnetGroup(subnetGroup);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.rds.DatabaseClusterFromSnapshot}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.DatabaseClusterFromSnapshot build() {
            return new software.amazon.awscdk.services.rds.DatabaseClusterFromSnapshot(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
