package software.amazon.awscdk.services.rds;

/**
 * A CloudFormation `AWS::RDS::GlobalCluster`.
 * <p>
 * The <code>AWS::RDS::GlobalCluster</code> resource creates or updates an Amazon Aurora global database spread across multiple AWS Regions.
 * <p>
 * The global database contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.
 * <p>
 * You can create a global database that is initially empty, and then add a primary cluster and a secondary cluster to it.
 * <p>
 * For information about Aurora global databases, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html">Working with Amazon Aurora Global Databases</a> in the <em>Amazon Aurora User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnGlobalCluster cfnGlobalCluster = CfnGlobalCluster.Builder.create(this, "MyCfnGlobalCluster")
 *         .deletionProtection(false)
 *         .engine("engine")
 *         .engineVersion("engineVersion")
 *         .globalClusterIdentifier("globalClusterIdentifier")
 *         .sourceDbClusterIdentifier("sourceDbClusterIdentifier")
 *         .storageEncrypted(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:53.722Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnGlobalCluster")
public class CfnGlobalCluster extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnGlobalCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGlobalCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.CfnGlobalCluster.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::RDS::GlobalCluster`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnGlobalCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.CfnGlobalClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::RDS::GlobalCluster`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnGlobalCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The deletion protection setting for the new global database.
     * <p>
     * The global database can't be deleted when deletion protection is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtection() {
        return software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The deletion protection setting for the new global database.
     * <p>
     * The global database can't be deleted when deletion protection is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * The deletion protection setting for the new global database.
     * <p>
     * The global database can't be deleted when deletion protection is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtection(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtection", value);
    }

    /**
     * The name of the database engine to be used for this DB cluster.
     * <p>
     * If this property isn't specified, the database engine is derived from the source DB cluster specified by the <code>SourceDBClusterIdentifier</code> property.
     * <p>
     * <blockquote>
     * <p>
     * If the <code>SourceDBClusterIdentifier</code> property isn't specified, this property is required. If the <code>SourceDBClusterIdentifier</code> property is specified, make sure this property isn't specified.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
        return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the database engine to be used for this DB cluster.
     * <p>
     * If this property isn't specified, the database engine is derived from the source DB cluster specified by the <code>SourceDBClusterIdentifier</code> property.
     * <p>
     * <blockquote>
     * <p>
     * If the <code>SourceDBClusterIdentifier</code> property isn't specified, this property is required. If the <code>SourceDBClusterIdentifier</code> property is specified, make sure this property isn't specified.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngine(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engine", value);
    }

    /**
     * The engine version of the Aurora global database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The engine version of the Aurora global database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineVersion", value);
    }

    /**
     * The cluster identifier of the global database cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGlobalClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "globalClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The cluster identifier of the global database cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGlobalClusterIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "globalClusterIdentifier", value);
    }

    /**
     * The DB cluster identifier or Amazon Resource Name (ARN) to use as the primary cluster of the global database.
     * <p>
     * <blockquote>
     * <p>
     * If the <code>Engine</code> property isn't specified, this property is required. If the <code>Engine</code> property is specified, make sure this property isn't specified.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceDbClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "sourceDbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The DB cluster identifier or Amazon Resource Name (ARN) to use as the primary cluster of the global database.
     * <p>
     * <blockquote>
     * <p>
     * If the <code>Engine</code> property isn't specified, this property is required. If the <code>Engine</code> property is specified, make sure this property isn't specified.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceDbClusterIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceDbClusterIdentifier", value);
    }

    /**
     * The storage encryption setting for the global database cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStorageEncrypted() {
        return software.amazon.jsii.Kernel.get(this, "storageEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The storage encryption setting for the global database cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageEncrypted(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "storageEncrypted", value);
    }

    /**
     * The storage encryption setting for the global database cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageEncrypted(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "storageEncrypted", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.CfnGlobalCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.CfnGlobalCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.rds.CfnGlobalClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The deletion protection setting for the new global database.
         * <p>
         * The global database can't be deleted when deletion protection is enabled.
         * <p>
         * @return {@code this}
         * @param deletionProtection The deletion protection setting for the new global database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props().deletionProtection(deletionProtection);
            return this;
        }
        /**
         * The deletion protection setting for the new global database.
         * <p>
         * The global database can't be deleted when deletion protection is enabled.
         * <p>
         * @return {@code this}
         * @param deletionProtection The deletion protection setting for the new global database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final software.amazon.awscdk.IResolvable deletionProtection) {
            this.props().deletionProtection(deletionProtection);
            return this;
        }

        /**
         * The name of the database engine to be used for this DB cluster.
         * <p>
         * If this property isn't specified, the database engine is derived from the source DB cluster specified by the <code>SourceDBClusterIdentifier</code> property.
         * <p>
         * <blockquote>
         * <p>
         * If the <code>SourceDBClusterIdentifier</code> property isn't specified, this property is required. If the <code>SourceDBClusterIdentifier</code> property is specified, make sure this property isn't specified.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param engine The name of the database engine to be used for this DB cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final java.lang.String engine) {
            this.props().engine(engine);
            return this;
        }

        /**
         * The engine version of the Aurora global database.
         * <p>
         * @return {@code this}
         * @param engineVersion The engine version of the Aurora global database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(final java.lang.String engineVersion) {
            this.props().engineVersion(engineVersion);
            return this;
        }

        /**
         * The cluster identifier of the global database cluster.
         * <p>
         * @return {@code this}
         * @param globalClusterIdentifier The cluster identifier of the global database cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalClusterIdentifier(final java.lang.String globalClusterIdentifier) {
            this.props().globalClusterIdentifier(globalClusterIdentifier);
            return this;
        }

        /**
         * The DB cluster identifier or Amazon Resource Name (ARN) to use as the primary cluster of the global database.
         * <p>
         * <blockquote>
         * <p>
         * If the <code>Engine</code> property isn't specified, this property is required. If the <code>Engine</code> property is specified, make sure this property isn't specified.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param sourceDbClusterIdentifier The DB cluster identifier or Amazon Resource Name (ARN) to use as the primary cluster of the global database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbClusterIdentifier(final java.lang.String sourceDbClusterIdentifier) {
            this.props().sourceDbClusterIdentifier(sourceDbClusterIdentifier);
            return this;
        }

        /**
         * The storage encryption setting for the global database cluster.
         * <p>
         * @return {@code this}
         * @param storageEncrypted The storage encryption setting for the global database cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final java.lang.Boolean storageEncrypted) {
            this.props().storageEncrypted(storageEncrypted);
            return this;
        }
        /**
         * The storage encryption setting for the global database cluster.
         * <p>
         * @return {@code this}
         * @param storageEncrypted The storage encryption setting for the global database cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final software.amazon.awscdk.IResolvable storageEncrypted) {
            this.props().storageEncrypted(storageEncrypted);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.rds.CfnGlobalCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.CfnGlobalCluster build() {
            return new software.amazon.awscdk.services.rds.CfnGlobalCluster(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.rds.CfnGlobalClusterProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.rds.CfnGlobalClusterProps.Builder();
            }
            return this.props;
        }
    }
}
