package software.amazon.awscdk.services.networkfirewall;

/**
 * Properties for defining a `CfnFirewall`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkfirewall.*;
 * CfnFirewallProps cfnFirewallProps = CfnFirewallProps.builder()
 *         .firewallName("firewallName")
 *         .firewallPolicyArn("firewallPolicyArn")
 *         .subnetMappings(List.of(SubnetMappingProperty.builder()
 *                 .subnetId("subnetId")
 *                 .build()))
 *         .vpcId("vpcId")
 *         // the properties below are optional
 *         .deleteProtection(false)
 *         .description("description")
 *         .firewallPolicyChangeProtection(false)
 *         .subnetChangeProtection(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:53.325Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnFirewallProps")
@software.amazon.jsii.Jsii.Proxy(CfnFirewallProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFirewallProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The descriptive name of the firewall.
     * <p>
     * You can't change the name of a firewall after you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFirewallName();

    /**
     * The Amazon Resource Name (ARN) of the firewall policy.
     * <p>
     * The relationship of firewall to firewall policy is many to one. Each firewall requires one firewall policy association, and you can use the same firewall policy for multiple firewalls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFirewallPolicyArn();

    /**
     * The public subnets that Network Firewall is using for the firewall.
     * <p>
     * Each subnet must belong to a different Availability Zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSubnetMappings();

    /**
     * The unique identifier of the VPC where the firewall is in use.
     * <p>
     * You can't change the VPC of a firewall after you create the firewall.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

    /**
     * A flag indicating whether it is possible to delete the firewall.
     * <p>
     * A setting of <code>TRUE</code> indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteProtection() {
        return null;
    }

    /**
     * A description of the firewall.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * A setting indicating whether the firewall is protected against a change to the firewall policy association.
     * <p>
     * Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFirewallPolicyChangeProtection() {
        return null;
    }

    /**
     * A setting indicating whether the firewall is protected against changes to the subnet associations.
     * <p>
     * Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSubnetChangeProtection() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFirewallProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFirewallProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFirewallProps> {
        java.lang.String firewallName;
        java.lang.String firewallPolicyArn;
        java.lang.Object subnetMappings;
        java.lang.String vpcId;
        java.lang.Object deleteProtection;
        java.lang.String description;
        java.lang.Object firewallPolicyChangeProtection;
        java.lang.Object subnetChangeProtection;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnFirewallProps#getFirewallName}
         * @param firewallName The descriptive name of the firewall. This parameter is required.
         *                     You can't change the name of a firewall after you create it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallName(java.lang.String firewallName) {
            this.firewallName = firewallName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getFirewallPolicyArn}
         * @param firewallPolicyArn The Amazon Resource Name (ARN) of the firewall policy. This parameter is required.
         *                          The relationship of firewall to firewall policy is many to one. Each firewall requires one firewall policy association, and you can use the same firewall policy for multiple firewalls.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallPolicyArn(java.lang.String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getSubnetMappings}
         * @param subnetMappings The public subnets that Network Firewall is using for the firewall. This parameter is required.
         *                       Each subnet must belong to a different Availability Zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetMappings(software.amazon.awscdk.IResolvable subnetMappings) {
            this.subnetMappings = subnetMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getSubnetMappings}
         * @param subnetMappings The public subnets that Network Firewall is using for the firewall. This parameter is required.
         *                       Each subnet must belong to a different Availability Zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetMappings(java.util.List<? extends java.lang.Object> subnetMappings) {
            this.subnetMappings = subnetMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getVpcId}
         * @param vpcId The unique identifier of the VPC where the firewall is in use. This parameter is required.
         *              You can't change the VPC of a firewall after you create the firewall.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getDeleteProtection}
         * @param deleteProtection A flag indicating whether it is possible to delete the firewall.
         *                         A setting of <code>TRUE</code> indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteProtection(java.lang.Boolean deleteProtection) {
            this.deleteProtection = deleteProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getDeleteProtection}
         * @param deleteProtection A flag indicating whether it is possible to delete the firewall.
         *                         A setting of <code>TRUE</code> indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to <code>TRUE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteProtection(software.amazon.awscdk.IResolvable deleteProtection) {
            this.deleteProtection = deleteProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getDescription}
         * @param description A description of the firewall.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getFirewallPolicyChangeProtection}
         * @param firewallPolicyChangeProtection A setting indicating whether the firewall is protected against a change to the firewall policy association.
         *                                       Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallPolicyChangeProtection(java.lang.Boolean firewallPolicyChangeProtection) {
            this.firewallPolicyChangeProtection = firewallPolicyChangeProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getFirewallPolicyChangeProtection}
         * @param firewallPolicyChangeProtection A setting indicating whether the firewall is protected against a change to the firewall policy association.
         *                                       Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallPolicyChangeProtection(software.amazon.awscdk.IResolvable firewallPolicyChangeProtection) {
            this.firewallPolicyChangeProtection = firewallPolicyChangeProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getSubnetChangeProtection}
         * @param subnetChangeProtection A setting indicating whether the firewall is protected against changes to the subnet associations.
         *                               Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetChangeProtection(java.lang.Boolean subnetChangeProtection) {
            this.subnetChangeProtection = subnetChangeProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getSubnetChangeProtection}
         * @param subnetChangeProtection A setting indicating whether the firewall is protected against changes to the subnet associations.
         *                               Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to <code>TRUE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetChangeProtection(software.amazon.awscdk.IResolvable subnetChangeProtection) {
            this.subnetChangeProtection = subnetChangeProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFirewallProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFirewallProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFirewallProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFirewallProps {
        private final java.lang.String firewallName;
        private final java.lang.String firewallPolicyArn;
        private final java.lang.Object subnetMappings;
        private final java.lang.String vpcId;
        private final java.lang.Object deleteProtection;
        private final java.lang.String description;
        private final java.lang.Object firewallPolicyChangeProtection;
        private final java.lang.Object subnetChangeProtection;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.firewallName = software.amazon.jsii.Kernel.get(this, "firewallName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.firewallPolicyArn = software.amazon.jsii.Kernel.get(this, "firewallPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetMappings = software.amazon.jsii.Kernel.get(this, "subnetMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deleteProtection = software.amazon.jsii.Kernel.get(this, "deleteProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.firewallPolicyChangeProtection = software.amazon.jsii.Kernel.get(this, "firewallPolicyChangeProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.subnetChangeProtection = software.amazon.jsii.Kernel.get(this, "subnetChangeProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.firewallName = java.util.Objects.requireNonNull(builder.firewallName, "firewallName is required");
            this.firewallPolicyArn = java.util.Objects.requireNonNull(builder.firewallPolicyArn, "firewallPolicyArn is required");
            this.subnetMappings = java.util.Objects.requireNonNull(builder.subnetMappings, "subnetMappings is required");
            this.vpcId = java.util.Objects.requireNonNull(builder.vpcId, "vpcId is required");
            this.deleteProtection = builder.deleteProtection;
            this.description = builder.description;
            this.firewallPolicyChangeProtection = builder.firewallPolicyChangeProtection;
            this.subnetChangeProtection = builder.subnetChangeProtection;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getFirewallName() {
            return this.firewallName;
        }

        @Override
        public final java.lang.String getFirewallPolicyArn() {
            return this.firewallPolicyArn;
        }

        @Override
        public final java.lang.Object getSubnetMappings() {
            return this.subnetMappings;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final java.lang.Object getDeleteProtection() {
            return this.deleteProtection;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getFirewallPolicyChangeProtection() {
            return this.firewallPolicyChangeProtection;
        }

        @Override
        public final java.lang.Object getSubnetChangeProtection() {
            return this.subnetChangeProtection;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("firewallName", om.valueToTree(this.getFirewallName()));
            data.set("firewallPolicyArn", om.valueToTree(this.getFirewallPolicyArn()));
            data.set("subnetMappings", om.valueToTree(this.getSubnetMappings()));
            data.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getDeleteProtection() != null) {
                data.set("deleteProtection", om.valueToTree(this.getDeleteProtection()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getFirewallPolicyChangeProtection() != null) {
                data.set("firewallPolicyChangeProtection", om.valueToTree(this.getFirewallPolicyChangeProtection()));
            }
            if (this.getSubnetChangeProtection() != null) {
                data.set("subnetChangeProtection", om.valueToTree(this.getSubnetChangeProtection()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnFirewallProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFirewallProps.Jsii$Proxy that = (CfnFirewallProps.Jsii$Proxy) o;

            if (!firewallName.equals(that.firewallName)) return false;
            if (!firewallPolicyArn.equals(that.firewallPolicyArn)) return false;
            if (!subnetMappings.equals(that.subnetMappings)) return false;
            if (!vpcId.equals(that.vpcId)) return false;
            if (this.deleteProtection != null ? !this.deleteProtection.equals(that.deleteProtection) : that.deleteProtection != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.firewallPolicyChangeProtection != null ? !this.firewallPolicyChangeProtection.equals(that.firewallPolicyChangeProtection) : that.firewallPolicyChangeProtection != null) return false;
            if (this.subnetChangeProtection != null ? !this.subnetChangeProtection.equals(that.subnetChangeProtection) : that.subnetChangeProtection != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.firewallName.hashCode();
            result = 31 * result + (this.firewallPolicyArn.hashCode());
            result = 31 * result + (this.subnetMappings.hashCode());
            result = 31 * result + (this.vpcId.hashCode());
            result = 31 * result + (this.deleteProtection != null ? this.deleteProtection.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.firewallPolicyChangeProtection != null ? this.firewallPolicyChangeProtection.hashCode() : 0);
            result = 31 * result + (this.subnetChangeProtection != null ? this.subnetChangeProtection.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
