package software.amazon.awscdk.services.networkfirewall;

/**
 * Properties for defining a `CfnFirewallPolicy`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkfirewall.*;
 * CfnFirewallPolicyProps cfnFirewallPolicyProps = CfnFirewallPolicyProps.builder()
 *         .firewallPolicy(FirewallPolicyProperty.builder()
 *                 .statelessDefaultActions(List.of("statelessDefaultActions"))
 *                 .statelessFragmentDefaultActions(List.of("statelessFragmentDefaultActions"))
 *                 // the properties below are optional
 *                 .statefulDefaultActions(List.of("statefulDefaultActions"))
 *                 .statefulEngineOptions(StatefulEngineOptionsProperty.builder()
 *                         .ruleOrder("ruleOrder")
 *                         .build())
 *                 .statefulRuleGroupReferences(List.of(StatefulRuleGroupReferenceProperty.builder()
 *                         .resourceArn("resourceArn")
 *                         // the properties below are optional
 *                         .priority(123)
 *                         .build()))
 *                 .statelessCustomActions(List.of(CustomActionProperty.builder()
 *                         .actionDefinition(ActionDefinitionProperty.builder()
 *                                 .publishMetricAction(PublishMetricActionProperty.builder()
 *                                         .dimensions(List.of(DimensionProperty.builder()
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         .actionName("actionName")
 *                         .build()))
 *                 .statelessRuleGroupReferences(List.of(StatelessRuleGroupReferenceProperty.builder()
 *                         .priority(123)
 *                         .resourceArn("resourceArn")
 *                         .build()))
 *                 .build())
 *         .firewallPolicyName("firewallPolicyName")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:53.324Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnFirewallPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFirewallPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The traffic filtering behavior of a firewall policy, defined in a collection of stateless and stateful rule groups and other settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getFirewallPolicy();

    /**
     * The descriptive name of the firewall policy.
     * <p>
     * You can't change the name of a firewall policy after you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFirewallPolicyName();

    /**
     * A description of the firewall policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFirewallPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFirewallPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFirewallPolicyProps> {
        java.lang.Object firewallPolicy;
        java.lang.String firewallPolicyName;
        java.lang.String description;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnFirewallPolicyProps#getFirewallPolicy}
         * @param firewallPolicy The traffic filtering behavior of a firewall policy, defined in a collection of stateless and stateful rule groups and other settings. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallPolicy(software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicy.FirewallPolicyProperty firewallPolicy) {
            this.firewallPolicy = firewallPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallPolicyProps#getFirewallPolicy}
         * @param firewallPolicy The traffic filtering behavior of a firewall policy, defined in a collection of stateless and stateful rule groups and other settings. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallPolicy(software.amazon.awscdk.IResolvable firewallPolicy) {
            this.firewallPolicy = firewallPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallPolicyProps#getFirewallPolicyName}
         * @param firewallPolicyName The descriptive name of the firewall policy. This parameter is required.
         *                           You can't change the name of a firewall policy after you create it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallPolicyName(java.lang.String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallPolicyProps#getDescription}
         * @param description A description of the firewall policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallPolicyProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFirewallPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFirewallPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFirewallPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFirewallPolicyProps {
        private final java.lang.Object firewallPolicy;
        private final java.lang.String firewallPolicyName;
        private final java.lang.String description;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.firewallPolicy = software.amazon.jsii.Kernel.get(this, "firewallPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.firewallPolicyName = software.amazon.jsii.Kernel.get(this, "firewallPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.firewallPolicy = java.util.Objects.requireNonNull(builder.firewallPolicy, "firewallPolicy is required");
            this.firewallPolicyName = java.util.Objects.requireNonNull(builder.firewallPolicyName, "firewallPolicyName is required");
            this.description = builder.description;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getFirewallPolicy() {
            return this.firewallPolicy;
        }

        @Override
        public final java.lang.String getFirewallPolicyName() {
            return this.firewallPolicyName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("firewallPolicy", om.valueToTree(this.getFirewallPolicy()));
            data.set("firewallPolicyName", om.valueToTree(this.getFirewallPolicyName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkfirewall.CfnFirewallPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFirewallPolicyProps.Jsii$Proxy that = (CfnFirewallPolicyProps.Jsii$Proxy) o;

            if (!firewallPolicy.equals(that.firewallPolicy)) return false;
            if (!firewallPolicyName.equals(that.firewallPolicyName)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.firewallPolicy.hashCode();
            result = 31 * result + (this.firewallPolicyName.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
