package software.amazon.awscdk.services.lex;

/**
 * A CloudFormation `AWS::Lex::Bot`.
 * <p>
 * Specifies an Amazon Lex conversational bot.
 * <p>
 * You must configure an intent based on the AMAZON.FallbackIntent built-in intent. If you don't add one, creating the bot will fail.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lex.*;
 * Object dataPrivacy;
 * Object sentimentAnalysisSettings;
 * CfnBot cfnBot = CfnBot.Builder.create(this, "MyCfnBot")
 *         .dataPrivacy(dataPrivacy)
 *         .idleSessionTtlInSeconds(123)
 *         .name("name")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .autoBuildBotLocales(false)
 *         .botFileS3Location(S3LocationProperty.builder()
 *                 .s3Bucket("s3Bucket")
 *                 .s3ObjectKey("s3ObjectKey")
 *                 // the properties below are optional
 *                 .s3ObjectVersion("s3ObjectVersion")
 *                 .build())
 *         .botLocales(List.of(BotLocaleProperty.builder()
 *                 .localeId("localeId")
 *                 .nluConfidenceThreshold(123)
 *                 // the properties below are optional
 *                 .customVocabulary(CustomVocabularyProperty.builder()
 *                         .customVocabularyItems(List.of(CustomVocabularyItemProperty.builder()
 *                                 .phrase("phrase")
 *                                 // the properties below are optional
 *                                 .weight(123)
 *                                 .build()))
 *                         .build())
 *                 .description("description")
 *                 .intents(List.of(IntentProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .dialogCodeHook(DialogCodeHookSettingProperty.builder()
 *                                 .enabled(false)
 *                                 .build())
 *                         .fulfillmentCodeHook(FulfillmentCodeHookSettingProperty.builder()
 *                                 .enabled(false)
 *                                 // the properties below are optional
 *                                 .fulfillmentUpdatesSpecification(FulfillmentUpdatesSpecificationProperty.builder()
 *                                         .active(false)
 *                                         // the properties below are optional
 *                                         .startResponse(FulfillmentStartResponseSpecificationProperty.builder()
 *                                                 .delayInSeconds(123)
 *                                                 .messageGroups(List.of(MessageGroupProperty.builder()
 *                                                         .message(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         // the properties below are optional
 *                                                         .variations(List.of(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .build()))
 *                                                 // the properties below are optional
 *                                                 .allowInterrupt(false)
 *                                                 .build())
 *                                         .timeoutInSeconds(123)
 *                                         .updateResponse(FulfillmentUpdateResponseSpecificationProperty.builder()
 *                                                 .frequencyInSeconds(123)
 *                                                 .messageGroups(List.of(MessageGroupProperty.builder()
 *                                                         .message(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         // the properties below are optional
 *                                                         .variations(List.of(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .build()))
 *                                                 // the properties below are optional
 *                                                 .allowInterrupt(false)
 *                                                 .build())
 *                                         .build())
 *                                 .postFulfillmentStatusSpecification(PostFulfillmentStatusSpecificationProperty.builder()
 *                                         .failureResponse(ResponseSpecificationProperty.builder()
 *                                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                         .message(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         // the properties below are optional
 *                                                         .variations(List.of(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .build()))
 *                                                 // the properties below are optional
 *                                                 .allowInterrupt(false)
 *                                                 .build())
 *                                         .successResponse(ResponseSpecificationProperty.builder()
 *                                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                         .message(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         // the properties below are optional
 *                                                         .variations(List.of(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .build()))
 *                                                 // the properties below are optional
 *                                                 .allowInterrupt(false)
 *                                                 .build())
 *                                         .timeoutResponse(ResponseSpecificationProperty.builder()
 *                                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                         .message(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         // the properties below are optional
 *                                                         .variations(List.of(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .build()))
 *                                                 // the properties below are optional
 *                                                 .allowInterrupt(false)
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .inputContexts(List.of(InputContextProperty.builder()
 *                                 .name("name")
 *                                 .build()))
 *                         .intentClosingSetting(IntentClosingSettingProperty.builder()
 *                                 .closingResponse(ResponseSpecificationProperty.builder()
 *                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                 .message(MessageProperty.builder()
 *                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                 .title("title")
 *                                                                 // the properties below are optional
 *                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                         .text("text")
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .imageUrl("imageUrl")
 *                                                                 .subtitle("subtitle")
 *                                                                 .build())
 *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .variations(List.of(MessageProperty.builder()
 *                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                 .title("title")
 *                                                                 // the properties below are optional
 *                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                         .text("text")
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .imageUrl("imageUrl")
 *                                                                 .subtitle("subtitle")
 *                                                                 .build())
 *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build()))
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .allowInterrupt(false)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .isActive(false)
 *                                 .build())
 *                         .intentConfirmationSetting(IntentConfirmationSettingProperty.builder()
 *                                 .declinationResponse(ResponseSpecificationProperty.builder()
 *                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                 .message(MessageProperty.builder()
 *                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                 .title("title")
 *                                                                 // the properties below are optional
 *                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                         .text("text")
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .imageUrl("imageUrl")
 *                                                                 .subtitle("subtitle")
 *                                                                 .build())
 *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .variations(List.of(MessageProperty.builder()
 *                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                 .title("title")
 *                                                                 // the properties below are optional
 *                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                         .text("text")
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .imageUrl("imageUrl")
 *                                                                 .subtitle("subtitle")
 *                                                                 .build())
 *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build()))
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .allowInterrupt(false)
 *                                         .build())
 *                                 .promptSpecification(PromptSpecificationProperty.builder()
 *                                         .maxRetries(123)
 *                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                 .message(MessageProperty.builder()
 *                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                 .title("title")
 *                                                                 // the properties below are optional
 *                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                         .text("text")
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .imageUrl("imageUrl")
 *                                                                 .subtitle("subtitle")
 *                                                                 .build())
 *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .variations(List.of(MessageProperty.builder()
 *                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                 .title("title")
 *                                                                 // the properties below are optional
 *                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                         .text("text")
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .imageUrl("imageUrl")
 *                                                                 .subtitle("subtitle")
 *                                                                 .build())
 *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build()))
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .allowInterrupt(false)
 *                                         .messageSelectionStrategy("messageSelectionStrategy")
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .isActive(false)
 *                                 .build())
 *                         .kendraConfiguration(KendraConfigurationProperty.builder()
 *                                 .kendraIndex("kendraIndex")
 *                                 // the properties below are optional
 *                                 .queryFilterString("queryFilterString")
 *                                 .queryFilterStringEnabled(false)
 *                                 .build())
 *                         .outputContexts(List.of(OutputContextProperty.builder()
 *                                 .name("name")
 *                                 .timeToLiveInSeconds(123)
 *                                 .turnsToLive(123)
 *                                 .build()))
 *                         .parentIntentSignature("parentIntentSignature")
 *                         .sampleUtterances(List.of(SampleUtteranceProperty.builder()
 *                                 .utterance("utterance")
 *                                 .build()))
 *                         .slotPriorities(List.of(SlotPriorityProperty.builder()
 *                                 .priority(123)
 *                                 .slotName("slotName")
 *                                 .build()))
 *                         .slots(List.of(SlotProperty.builder()
 *                                 .name("name")
 *                                 .slotTypeName("slotTypeName")
 *                                 .valueElicitationSetting(SlotValueElicitationSettingProperty.builder()
 *                                         .slotConstraint("slotConstraint")
 *                                         // the properties below are optional
 *                                         .defaultValueSpecification(SlotDefaultValueSpecificationProperty.builder()
 *                                                 .defaultValueList(List.of(SlotDefaultValueProperty.builder()
 *                                                         .defaultValue("defaultValue")
 *                                                         .build()))
 *                                                 .build())
 *                                         .promptSpecification(PromptSpecificationProperty.builder()
 *                                                 .maxRetries(123)
 *                                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                         .message(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         // the properties below are optional
 *                                                         .variations(List.of(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .build()))
 *                                                 // the properties below are optional
 *                                                 .allowInterrupt(false)
 *                                                 .messageSelectionStrategy("messageSelectionStrategy")
 *                                                 .build())
 *                                         .sampleUtterances(List.of(SampleUtteranceProperty.builder()
 *                                                 .utterance("utterance")
 *                                                 .build()))
 *                                         .waitAndContinueSpecification(WaitAndContinueSpecificationProperty.builder()
 *                                                 .continueResponse(ResponseSpecificationProperty.builder()
 *                                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                                 .message(MessageProperty.builder()
 *                                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                                 .title("title")
 *                                                                                 // the properties below are optional
 *                                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                                         .text("text")
 *                                                                                         .value("value")
 *                                                                                         .build()))
 *                                                                                 .imageUrl("imageUrl")
 *                                                                                 .subtitle("subtitle")
 *                                                                                 .build())
 *                                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .build())
 *                                                                 // the properties below are optional
 *                                                                 .variations(List.of(MessageProperty.builder()
 *                                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                                 .title("title")
 *                                                                                 // the properties below are optional
 *                                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                                         .text("text")
 *                                                                                         .value("value")
 *                                                                                         .build()))
 *                                                                                 .imageUrl("imageUrl")
 *                                                                                 .subtitle("subtitle")
 *                                                                                 .build())
 *                                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .build()))
 *                                                                 .build()))
 *                                                         // the properties below are optional
 *                                                         .allowInterrupt(false)
 *                                                         .build())
 *                                                 .waitingResponse(ResponseSpecificationProperty.builder()
 *                                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                                 .message(MessageProperty.builder()
 *                                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                                 .title("title")
 *                                                                                 // the properties below are optional
 *                                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                                         .text("text")
 *                                                                                         .value("value")
 *                                                                                         .build()))
 *                                                                                 .imageUrl("imageUrl")
 *                                                                                 .subtitle("subtitle")
 *                                                                                 .build())
 *                                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .build())
 *                                                                 // the properties below are optional
 *                                                                 .variations(List.of(MessageProperty.builder()
 *                                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                                 .title("title")
 *                                                                                 // the properties below are optional
 *                                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                                         .text("text")
 *                                                                                         .value("value")
 *                                                                                         .build()))
 *                                                                                 .imageUrl("imageUrl")
 *                                                                                 .subtitle("subtitle")
 *                                                                                 .build())
 *                                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .build()))
 *                                                                 .build()))
 *                                                         // the properties below are optional
 *                                                         .allowInterrupt(false)
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .isActive(false)
 *                                                 .stillWaitingResponse(StillWaitingResponseSpecificationProperty.builder()
 *                                                         .frequencyInSeconds(123)
 *                                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                                 .message(MessageProperty.builder()
 *                                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                                 .title("title")
 *                                                                                 // the properties below are optional
 *                                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                                         .text("text")
 *                                                                                         .value("value")
 *                                                                                         .build()))
 *                                                                                 .imageUrl("imageUrl")
 *                                                                                 .subtitle("subtitle")
 *                                                                                 .build())
 *                                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .build())
 *                                                                 // the properties below are optional
 *                                                                 .variations(List.of(MessageProperty.builder()
 *                                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                                 .title("title")
 *                                                                                 // the properties below are optional
 *                                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                                         .text("text")
 *                                                                                         .value("value")
 *                                                                                         .build()))
 *                                                                                 .imageUrl("imageUrl")
 *                                                                                 .subtitle("subtitle")
 *                                                                                 .build())
 *                                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .build()))
 *                                                                 .build()))
 *                                                         .timeoutInSeconds(123)
 *                                                         // the properties below are optional
 *                                                         .allowInterrupt(false)
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .description("description")
 *                                 .multipleValuesSetting(MultipleValuesSettingProperty.builder()
 *                                         .allowMultipleValues(false)
 *                                         .build())
 *                                 .obfuscationSetting(ObfuscationSettingProperty.builder()
 *                                         .obfuscationSettingType("obfuscationSettingType")
 *                                         .build())
 *                                 .build()))
 *                         .build()))
 *                 .slotTypes(List.of(SlotTypeProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .externalSourceSetting(ExternalSourceSettingProperty.builder()
 *                                 .grammarSlotTypeSetting(GrammarSlotTypeSettingProperty.builder()
 *                                         .source(GrammarSlotTypeSourceProperty.builder()
 *                                                 .s3BucketName("s3BucketName")
 *                                                 .s3ObjectKey("s3ObjectKey")
 *                                                 // the properties below are optional
 *                                                 .kmsKeyArn("kmsKeyArn")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .parentSlotTypeSignature("parentSlotTypeSignature")
 *                         .slotTypeValues(List.of(SlotTypeValueProperty.builder()
 *                                 .sampleValue(SampleValueProperty.builder()
 *                                         .value("value")
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .synonyms(List.of(SampleValueProperty.builder()
 *                                         .value("value")
 *                                         .build()))
 *                                 .build()))
 *                         .valueSelectionSetting(SlotValueSelectionSettingProperty.builder()
 *                                 .resolutionStrategy("resolutionStrategy")
 *                                 // the properties below are optional
 *                                 .advancedRecognitionSetting(AdvancedRecognitionSettingProperty.builder()
 *                                         .audioRecognitionStrategy("audioRecognitionStrategy")
 *                                         .build())
 *                                 .regexFilter(SlotValueRegexFilterProperty.builder()
 *                                         .pattern("pattern")
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *                 .voiceSettings(VoiceSettingsProperty.builder()
 *                         .voiceId("voiceId")
 *                         // the properties below are optional
 *                         .engine("engine")
 *                         .build())
 *                 .build()))
 *         .botTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .description("description")
 *         .testBotAliasSettings(TestBotAliasSettingsProperty.builder()
 *                 .botAliasLocaleSettings(List.of(BotAliasLocaleSettingsItemProperty.builder()
 *                         .botAliasLocaleSetting(BotAliasLocaleSettingsProperty.builder()
 *                                 .enabled(false)
 *                                 // the properties below are optional
 *                                 .codeHookSpecification(CodeHookSpecificationProperty.builder()
 *                                         .lambdaCodeHook(LambdaCodeHookProperty.builder()
 *                                                 .codeHookInterfaceVersion("codeHookInterfaceVersion")
 *                                                 .lambdaArn("lambdaArn")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .localeId("localeId")
 *                         .build()))
 *                 .conversationLogSettings(ConversationLogSettingsProperty.builder()
 *                         .audioLogSettings(List.of(AudioLogSettingProperty.builder()
 *                                 .destination(AudioLogDestinationProperty.builder()
 *                                         .s3Bucket(S3BucketLogDestinationProperty.builder()
 *                                                 .logPrefix("logPrefix")
 *                                                 .s3BucketArn("s3BucketArn")
 *                                                 // the properties below are optional
 *                                                 .kmsKeyArn("kmsKeyArn")
 *                                                 .build())
 *                                         .build())
 *                                 .enabled(false)
 *                                 .build()))
 *                         .textLogSettings(List.of(TextLogSettingProperty.builder()
 *                                 .destination(TextLogDestinationProperty.builder()
 *                                         .cloudWatch(CloudWatchLogGroupLogDestinationProperty.builder()
 *                                                 .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *                                                 .logPrefix("logPrefix")
 *                                                 .build())
 *                                         .build())
 *                                 .enabled(false)
 *                                 .build()))
 *                         .build())
 *                 .description("description")
 *                 .sentimentAnalysisSettings(sentimentAnalysisSettings)
 *                 .build())
 *         .testBotAliasTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:52.843Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot")
public class CfnBot extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnBot(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBot(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lex.CfnBot.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Lex::Bot`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnBot(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lex.CfnBotProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Provides information on additional privacy protections Amazon Lex should use with the bot's data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDataPrivacy() {
        return software.amazon.jsii.Kernel.get(this, "dataPrivacy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Provides information on additional privacy protections Amazon Lex should use with the bot's data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataPrivacy(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "dataPrivacy", java.util.Objects.requireNonNull(value, "dataPrivacy is required"));
    }

    /**
     * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
     * <p>
     * A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.
     * <p>
     * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getIdleSessionTtlInSeconds() {
        return software.amazon.jsii.Kernel.get(this, "idleSessionTtlInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
     * <p>
     * A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.
     * <p>
     * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdleSessionTtlInSeconds(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "idleSessionTtlInSeconds", java.util.Objects.requireNonNull(value, "idleSessionTtlInSeconds is required"));
    }

    /**
     * The name of the field to filter the list of bots.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the field to filter the list of bots.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * Indicates whether Amazon Lex V2 should automatically build the locales for the bot after a change.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoBuildBotLocales() {
        return software.amazon.jsii.Kernel.get(this, "autoBuildBotLocales", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether Amazon Lex V2 should automatically build the locales for the bot after a change.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoBuildBotLocales(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "autoBuildBotLocales", value);
    }

    /**
     * Indicates whether Amazon Lex V2 should automatically build the locales for the bot after a change.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoBuildBotLocales(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoBuildBotLocales", value);
    }

    /**
     * The Amazon S3 location of files used to import a bot.
     * <p>
     * The files must be in the import format specified in <a href="https://docs.aws.amazon.com/lexv2/latest/dg/import-export-format.html">JSON format for importing and exporting</a> in the <em>Amazon Lex developer guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBotFileS3Location() {
        return software.amazon.jsii.Kernel.get(this, "botFileS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Amazon S3 location of files used to import a bot.
     * <p>
     * The files must be in the import format specified in <a href="https://docs.aws.amazon.com/lexv2/latest/dg/import-export-format.html">JSON format for importing and exporting</a> in the <em>Amazon Lex developer guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotFileS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lex.CfnBot.S3LocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "botFileS3Location", value);
    }

    /**
     * The Amazon S3 location of files used to import a bot.
     * <p>
     * The files must be in the import format specified in <a href="https://docs.aws.amazon.com/lexv2/latest/dg/import-export-format.html">JSON format for importing and exporting</a> in the <em>Amazon Lex developer guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotFileS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "botFileS3Location", value);
    }

    /**
     * A list of locales for the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBotLocales() {
        return software.amazon.jsii.Kernel.get(this, "botLocales", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of locales for the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotLocales(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "botLocales", value);
    }

    /**
     * A list of locales for the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotLocales(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.lex.CfnBot.BotLocaleProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.lex.CfnBot.BotLocaleProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "botLocales", value);
    }

    /**
     * A list of tags to add to the bot.
     * <p>
     * You can only add tags when you import a bot. You can't use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBotTags() {
        return software.amazon.jsii.Kernel.get(this, "botTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of tags to add to the bot.
     * <p>
     * You can only add tags when you import a bot. You can't use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "botTags", value);
    }

    /**
     * A list of tags to add to the bot.
     * <p>
     * You can only add tags when you import a bot. You can't use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBotTags(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.CfnTag)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.CfnTag; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "botTags", value);
    }

    /**
     * The description of the version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Specifies configuration settings for the alias used to test the bot.
     * <p>
     * If the <code>TestBotAliasSettings</code> property is not specified, the settings are configured with default values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTestBotAliasSettings() {
        return software.amazon.jsii.Kernel.get(this, "testBotAliasSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies configuration settings for the alias used to test the bot.
     * <p>
     * If the <code>TestBotAliasSettings</code> property is not specified, the settings are configured with default values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTestBotAliasSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lex.CfnBot.TestBotAliasSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "testBotAliasSettings", value);
    }

    /**
     * Specifies configuration settings for the alias used to test the bot.
     * <p>
     * If the <code>TestBotAliasSettings</code> property is not specified, the settings are configured with default values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTestBotAliasSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "testBotAliasSettings", value);
    }

    /**
     * A list of tags to add to the test alias for a bot.
     * <p>
     * You can only add tags when you import a bot. You can't use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTestBotAliasTags() {
        return software.amazon.jsii.Kernel.get(this, "testBotAliasTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of tags to add to the test alias for a bot.
     * <p>
     * You can only add tags when you import a bot. You can't use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTestBotAliasTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "testBotAliasTags", value);
    }

    /**
     * A list of tags to add to the test alias for a bot.
     * <p>
     * You can only add tags when you import a bot. You can't use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTestBotAliasTags(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.CfnTag)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.CfnTag; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "testBotAliasTags", value);
    }
    /**
     * Specifies settings that enable advanced audio recognition for slot values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * AdvancedRecognitionSettingProperty advancedRecognitionSettingProperty = AdvancedRecognitionSettingProperty.builder()
     *         .audioRecognitionStrategy("audioRecognitionStrategy")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.AdvancedRecognitionSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(AdvancedRecognitionSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdvancedRecognitionSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies that Amazon Lex should use slot values as a custom vocabulary when recognizing user utterances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAudioRecognitionStrategy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdvancedRecognitionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdvancedRecognitionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdvancedRecognitionSettingProperty> {
            java.lang.String audioRecognitionStrategy;

            /**
             * Sets the value of {@link AdvancedRecognitionSettingProperty#getAudioRecognitionStrategy}
             * @param audioRecognitionStrategy Specifies that Amazon Lex should use slot values as a custom vocabulary when recognizing user utterances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioRecognitionStrategy(java.lang.String audioRecognitionStrategy) {
                this.audioRecognitionStrategy = audioRecognitionStrategy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdvancedRecognitionSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdvancedRecognitionSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdvancedRecognitionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdvancedRecognitionSettingProperty {
            private final java.lang.String audioRecognitionStrategy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioRecognitionStrategy = software.amazon.jsii.Kernel.get(this, "audioRecognitionStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioRecognitionStrategy = builder.audioRecognitionStrategy;
            }

            @Override
            public final java.lang.String getAudioRecognitionStrategy() {
                return this.audioRecognitionStrategy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioRecognitionStrategy() != null) {
                    data.set("audioRecognitionStrategy", om.valueToTree(this.getAudioRecognitionStrategy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.AdvancedRecognitionSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdvancedRecognitionSettingProperty.Jsii$Proxy that = (AdvancedRecognitionSettingProperty.Jsii$Proxy) o;

                return this.audioRecognitionStrategy != null ? this.audioRecognitionStrategy.equals(that.audioRecognitionStrategy) : that.audioRecognitionStrategy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioRecognitionStrategy != null ? this.audioRecognitionStrategy.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the location of audio log files collected when conversation logging is enabled for a bot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * AudioLogDestinationProperty audioLogDestinationProperty = AudioLogDestinationProperty.builder()
     *         .s3Bucket(S3BucketLogDestinationProperty.builder()
     *                 .logPrefix("logPrefix")
     *                 .s3BucketArn("s3BucketArn")
     *                 // the properties below are optional
     *                 .kmsKeyArn("kmsKeyArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.AudioLogDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioLogDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioLogDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the Amazon S3 bucket where the audio files are stored.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Bucket();

        /**
         * @return a {@link Builder} of {@link AudioLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioLogDestinationProperty> {
            java.lang.Object s3Bucket;

            /**
             * Sets the value of {@link AudioLogDestinationProperty#getS3Bucket}
             * @param s3Bucket Specifies the Amazon S3 bucket where the audio files are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(software.amazon.awscdk.services.lex.CfnBot.S3BucketLogDestinationProperty s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Sets the value of {@link AudioLogDestinationProperty#getS3Bucket}
             * @param s3Bucket Specifies the Amazon S3 bucket where the audio files are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(software.amazon.awscdk.IResolvable s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioLogDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioLogDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioLogDestinationProperty {
            private final java.lang.Object s3Bucket;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Bucket = software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Bucket = java.util.Objects.requireNonNull(builder.s3Bucket, "s3Bucket is required");
            }

            @Override
            public final java.lang.Object getS3Bucket() {
                return this.s3Bucket;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.AudioLogDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioLogDestinationProperty.Jsii$Proxy that = (AudioLogDestinationProperty.Jsii$Proxy) o;

                return this.s3Bucket.equals(that.s3Bucket);
            }

            @Override
            public final int hashCode() {
                int result = this.s3Bucket.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies settings for logging the audio of conversations between Amazon Lex and a user.
     * <p>
     * You specify whether to log audio and the Amazon S3 bucket where the audio file is stored.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * AudioLogSettingProperty audioLogSettingProperty = AudioLogSettingProperty.builder()
     *         .destination(AudioLogDestinationProperty.builder()
     *                 .s3Bucket(S3BucketLogDestinationProperty.builder()
     *                         .logPrefix("logPrefix")
     *                         .s3BucketArn("s3BucketArn")
     *                         // the properties below are optional
     *                         .kmsKeyArn("kmsKeyArn")
     *                         .build())
     *                 .build())
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.AudioLogSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(AudioLogSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AudioLogSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the location of the audio log files collected when conversation logging is enabled for a bot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestination();

        /**
         * Specifies whether audio logging is enabled for the bot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link AudioLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AudioLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AudioLogSettingProperty> {
            java.lang.Object destination;
            java.lang.Object enabled;

            /**
             * Sets the value of {@link AudioLogSettingProperty#getDestination}
             * @param destination Specifies the location of the audio log files collected when conversation logging is enabled for a bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.lex.CfnBot.AudioLogDestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link AudioLogSettingProperty#getDestination}
             * @param destination Specifies the location of the audio log files collected when conversation logging is enabled for a bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link AudioLogSettingProperty#getEnabled}
             * @param enabled Specifies whether audio logging is enabled for the bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AudioLogSettingProperty#getEnabled}
             * @param enabled Specifies whether audio logging is enabled for the bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AudioLogSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AudioLogSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AudioLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AudioLogSettingProperty {
            private final java.lang.Object destination;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                data.set("enabled", om.valueToTree(this.getEnabled()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.AudioLogSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AudioLogSettingProperty.Jsii$Proxy that = (AudioLogSettingProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                return this.enabled.equals(that.enabled);
            }

            @Override
            public final int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.enabled.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies locale settings for a single locale.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * BotAliasLocaleSettingsItemProperty botAliasLocaleSettingsItemProperty = BotAliasLocaleSettingsItemProperty.builder()
     *         .botAliasLocaleSetting(BotAliasLocaleSettingsProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .codeHookSpecification(CodeHookSpecificationProperty.builder()
     *                         .lambdaCodeHook(LambdaCodeHookProperty.builder()
     *                                 .codeHookInterfaceVersion("codeHookInterfaceVersion")
     *                                 .lambdaArn("lambdaArn")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .localeId("localeId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.BotAliasLocaleSettingsItemProperty")
    @software.amazon.jsii.Jsii.Proxy(BotAliasLocaleSettingsItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BotAliasLocaleSettingsItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies locale settings for a locale.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getBotAliasLocaleSetting();

        /**
         * Specifies the locale that the settings apply to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocaleId();

        /**
         * @return a {@link Builder} of {@link BotAliasLocaleSettingsItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BotAliasLocaleSettingsItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BotAliasLocaleSettingsItemProperty> {
            java.lang.Object botAliasLocaleSetting;
            java.lang.String localeId;

            /**
             * Sets the value of {@link BotAliasLocaleSettingsItemProperty#getBotAliasLocaleSetting}
             * @param botAliasLocaleSetting Specifies locale settings for a locale. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder botAliasLocaleSetting(software.amazon.awscdk.services.lex.CfnBot.BotAliasLocaleSettingsProperty botAliasLocaleSetting) {
                this.botAliasLocaleSetting = botAliasLocaleSetting;
                return this;
            }

            /**
             * Sets the value of {@link BotAliasLocaleSettingsItemProperty#getBotAliasLocaleSetting}
             * @param botAliasLocaleSetting Specifies locale settings for a locale. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder botAliasLocaleSetting(software.amazon.awscdk.IResolvable botAliasLocaleSetting) {
                this.botAliasLocaleSetting = botAliasLocaleSetting;
                return this;
            }

            /**
             * Sets the value of {@link BotAliasLocaleSettingsItemProperty#getLocaleId}
             * @param localeId Specifies the locale that the settings apply to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localeId(java.lang.String localeId) {
                this.localeId = localeId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BotAliasLocaleSettingsItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BotAliasLocaleSettingsItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BotAliasLocaleSettingsItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BotAliasLocaleSettingsItemProperty {
            private final java.lang.Object botAliasLocaleSetting;
            private final java.lang.String localeId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.botAliasLocaleSetting = software.amazon.jsii.Kernel.get(this, "botAliasLocaleSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.localeId = software.amazon.jsii.Kernel.get(this, "localeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.botAliasLocaleSetting = java.util.Objects.requireNonNull(builder.botAliasLocaleSetting, "botAliasLocaleSetting is required");
                this.localeId = java.util.Objects.requireNonNull(builder.localeId, "localeId is required");
            }

            @Override
            public final java.lang.Object getBotAliasLocaleSetting() {
                return this.botAliasLocaleSetting;
            }

            @Override
            public final java.lang.String getLocaleId() {
                return this.localeId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("botAliasLocaleSetting", om.valueToTree(this.getBotAliasLocaleSetting()));
                data.set("localeId", om.valueToTree(this.getLocaleId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.BotAliasLocaleSettingsItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BotAliasLocaleSettingsItemProperty.Jsii$Proxy that = (BotAliasLocaleSettingsItemProperty.Jsii$Proxy) o;

                if (!botAliasLocaleSetting.equals(that.botAliasLocaleSetting)) return false;
                return this.localeId.equals(that.localeId);
            }

            @Override
            public final int hashCode() {
                int result = this.botAliasLocaleSetting.hashCode();
                result = 31 * result + (this.localeId.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies settings that are unique to a locale.
     * <p>
     * For example, you can use a different Lambda function for each locale.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * BotAliasLocaleSettingsProperty botAliasLocaleSettingsProperty = BotAliasLocaleSettingsProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .codeHookSpecification(CodeHookSpecificationProperty.builder()
     *                 .lambdaCodeHook(LambdaCodeHookProperty.builder()
     *                         .codeHookInterfaceVersion("codeHookInterfaceVersion")
     *                         .lambdaArn("lambdaArn")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.BotAliasLocaleSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(BotAliasLocaleSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BotAliasLocaleSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the locale is enabled for the bot.
         * <p>
         * If the value is false, the locale isn't available for use.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * Specifies the Lambda function to use in this locale.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeHookSpecification() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BotAliasLocaleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BotAliasLocaleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BotAliasLocaleSettingsProperty> {
            java.lang.Object enabled;
            java.lang.Object codeHookSpecification;

            /**
             * Sets the value of {@link BotAliasLocaleSettingsProperty#getEnabled}
             * @param enabled Specifies whether the locale is enabled for the bot. This parameter is required.
             *                If the value is false, the locale isn't available for use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link BotAliasLocaleSettingsProperty#getEnabled}
             * @param enabled Specifies whether the locale is enabled for the bot. This parameter is required.
             *                If the value is false, the locale isn't available for use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link BotAliasLocaleSettingsProperty#getCodeHookSpecification}
             * @param codeHookSpecification Specifies the Lambda function to use in this locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeHookSpecification(software.amazon.awscdk.services.lex.CfnBot.CodeHookSpecificationProperty codeHookSpecification) {
                this.codeHookSpecification = codeHookSpecification;
                return this;
            }

            /**
             * Sets the value of {@link BotAliasLocaleSettingsProperty#getCodeHookSpecification}
             * @param codeHookSpecification Specifies the Lambda function to use in this locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeHookSpecification(software.amazon.awscdk.IResolvable codeHookSpecification) {
                this.codeHookSpecification = codeHookSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BotAliasLocaleSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BotAliasLocaleSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BotAliasLocaleSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BotAliasLocaleSettingsProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object codeHookSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.codeHookSpecification = software.amazon.jsii.Kernel.get(this, "codeHookSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.codeHookSpecification = builder.codeHookSpecification;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getCodeHookSpecification() {
                return this.codeHookSpecification;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getCodeHookSpecification() != null) {
                    data.set("codeHookSpecification", om.valueToTree(this.getCodeHookSpecification()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.BotAliasLocaleSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BotAliasLocaleSettingsProperty.Jsii$Proxy that = (BotAliasLocaleSettingsProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                return this.codeHookSpecification != null ? this.codeHookSpecification.equals(that.codeHookSpecification) : that.codeHookSpecification == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.codeHookSpecification != null ? this.codeHookSpecification.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides configuration information for a locale.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * BotLocaleProperty botLocaleProperty = BotLocaleProperty.builder()
     *         .localeId("localeId")
     *         .nluConfidenceThreshold(123)
     *         // the properties below are optional
     *         .customVocabulary(CustomVocabularyProperty.builder()
     *                 .customVocabularyItems(List.of(CustomVocabularyItemProperty.builder()
     *                         .phrase("phrase")
     *                         // the properties below are optional
     *                         .weight(123)
     *                         .build()))
     *                 .build())
     *         .description("description")
     *         .intents(List.of(IntentProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .description("description")
     *                 .dialogCodeHook(DialogCodeHookSettingProperty.builder()
     *                         .enabled(false)
     *                         .build())
     *                 .fulfillmentCodeHook(FulfillmentCodeHookSettingProperty.builder()
     *                         .enabled(false)
     *                         // the properties below are optional
     *                         .fulfillmentUpdatesSpecification(FulfillmentUpdatesSpecificationProperty.builder()
     *                                 .active(false)
     *                                 // the properties below are optional
     *                                 .startResponse(FulfillmentStartResponseSpecificationProperty.builder()
     *                                         .delayInSeconds(123)
     *                                         .messageGroups(List.of(MessageGroupProperty.builder()
     *                                                 .message(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build())
     *                                                 // the properties below are optional
     *                                                 .variations(List.of(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build()))
     *                                                 .build()))
     *                                         // the properties below are optional
     *                                         .allowInterrupt(false)
     *                                         .build())
     *                                 .timeoutInSeconds(123)
     *                                 .updateResponse(FulfillmentUpdateResponseSpecificationProperty.builder()
     *                                         .frequencyInSeconds(123)
     *                                         .messageGroups(List.of(MessageGroupProperty.builder()
     *                                                 .message(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build())
     *                                                 // the properties below are optional
     *                                                 .variations(List.of(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build()))
     *                                                 .build()))
     *                                         // the properties below are optional
     *                                         .allowInterrupt(false)
     *                                         .build())
     *                                 .build())
     *                         .postFulfillmentStatusSpecification(PostFulfillmentStatusSpecificationProperty.builder()
     *                                 .failureResponse(ResponseSpecificationProperty.builder()
     *                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                                 .message(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build())
     *                                                 // the properties below are optional
     *                                                 .variations(List.of(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build()))
     *                                                 .build()))
     *                                         // the properties below are optional
     *                                         .allowInterrupt(false)
     *                                         .build())
     *                                 .successResponse(ResponseSpecificationProperty.builder()
     *                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                                 .message(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build())
     *                                                 // the properties below are optional
     *                                                 .variations(List.of(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build()))
     *                                                 .build()))
     *                                         // the properties below are optional
     *                                         .allowInterrupt(false)
     *                                         .build())
     *                                 .timeoutResponse(ResponseSpecificationProperty.builder()
     *                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                                 .message(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build())
     *                                                 // the properties below are optional
     *                                                 .variations(List.of(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build()))
     *                                                 .build()))
     *                                         // the properties below are optional
     *                                         .allowInterrupt(false)
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .inputContexts(List.of(InputContextProperty.builder()
     *                         .name("name")
     *                         .build()))
     *                 .intentClosingSetting(IntentClosingSettingProperty.builder()
     *                         .closingResponse(ResponseSpecificationProperty.builder()
     *                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                         .message(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .variations(List.of(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build()))
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .allowInterrupt(false)
     *                                 .build())
     *                         // the properties below are optional
     *                         .isActive(false)
     *                         .build())
     *                 .intentConfirmationSetting(IntentConfirmationSettingProperty.builder()
     *                         .declinationResponse(ResponseSpecificationProperty.builder()
     *                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                         .message(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .variations(List.of(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build()))
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .allowInterrupt(false)
     *                                 .build())
     *                         .promptSpecification(PromptSpecificationProperty.builder()
     *                                 .maxRetries(123)
     *                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                         .message(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .variations(List.of(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build()))
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .allowInterrupt(false)
     *                                 .messageSelectionStrategy("messageSelectionStrategy")
     *                                 .build())
     *                         // the properties below are optional
     *                         .isActive(false)
     *                         .build())
     *                 .kendraConfiguration(KendraConfigurationProperty.builder()
     *                         .kendraIndex("kendraIndex")
     *                         // the properties below are optional
     *                         .queryFilterString("queryFilterString")
     *                         .queryFilterStringEnabled(false)
     *                         .build())
     *                 .outputContexts(List.of(OutputContextProperty.builder()
     *                         .name("name")
     *                         .timeToLiveInSeconds(123)
     *                         .turnsToLive(123)
     *                         .build()))
     *                 .parentIntentSignature("parentIntentSignature")
     *                 .sampleUtterances(List.of(SampleUtteranceProperty.builder()
     *                         .utterance("utterance")
     *                         .build()))
     *                 .slotPriorities(List.of(SlotPriorityProperty.builder()
     *                         .priority(123)
     *                         .slotName("slotName")
     *                         .build()))
     *                 .slots(List.of(SlotProperty.builder()
     *                         .name("name")
     *                         .slotTypeName("slotTypeName")
     *                         .valueElicitationSetting(SlotValueElicitationSettingProperty.builder()
     *                                 .slotConstraint("slotConstraint")
     *                                 // the properties below are optional
     *                                 .defaultValueSpecification(SlotDefaultValueSpecificationProperty.builder()
     *                                         .defaultValueList(List.of(SlotDefaultValueProperty.builder()
     *                                                 .defaultValue("defaultValue")
     *                                                 .build()))
     *                                         .build())
     *                                 .promptSpecification(PromptSpecificationProperty.builder()
     *                                         .maxRetries(123)
     *                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                                 .message(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build())
     *                                                 // the properties below are optional
     *                                                 .variations(List.of(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build()))
     *                                                 .build()))
     *                                         // the properties below are optional
     *                                         .allowInterrupt(false)
     *                                         .messageSelectionStrategy("messageSelectionStrategy")
     *                                         .build())
     *                                 .sampleUtterances(List.of(SampleUtteranceProperty.builder()
     *                                         .utterance("utterance")
     *                                         .build()))
     *                                 .waitAndContinueSpecification(WaitAndContinueSpecificationProperty.builder()
     *                                         .continueResponse(ResponseSpecificationProperty.builder()
     *                                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                                         .message(MessageProperty.builder()
     *                                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                         .title("title")
     *                                                                         // the properties below are optional
     *                                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                                 .text("text")
     *                                                                                 .value("value")
     *                                                                                 .build()))
     *                                                                         .imageUrl("imageUrl")
     *                                                                         .subtitle("subtitle")
     *                                                                         .build())
     *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         // the properties below are optional
     *                                                         .variations(List.of(MessageProperty.builder()
     *                                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                         .title("title")
     *                                                                         // the properties below are optional
     *                                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                                 .text("text")
     *                                                                                 .value("value")
     *                                                                                 .build()))
     *                                                                         .imageUrl("imageUrl")
     *                                                                         .subtitle("subtitle")
     *                                                                         .build())
     *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .build()))
     *                                                         .build()))
     *                                                 // the properties below are optional
     *                                                 .allowInterrupt(false)
     *                                                 .build())
     *                                         .waitingResponse(ResponseSpecificationProperty.builder()
     *                                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                                         .message(MessageProperty.builder()
     *                                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                         .title("title")
     *                                                                         // the properties below are optional
     *                                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                                 .text("text")
     *                                                                                 .value("value")
     *                                                                                 .build()))
     *                                                                         .imageUrl("imageUrl")
     *                                                                         .subtitle("subtitle")
     *                                                                         .build())
     *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         // the properties below are optional
     *                                                         .variations(List.of(MessageProperty.builder()
     *                                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                         .title("title")
     *                                                                         // the properties below are optional
     *                                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                                 .text("text")
     *                                                                                 .value("value")
     *                                                                                 .build()))
     *                                                                         .imageUrl("imageUrl")
     *                                                                         .subtitle("subtitle")
     *                                                                         .build())
     *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .build()))
     *                                                         .build()))
     *                                                 // the properties below are optional
     *                                                 .allowInterrupt(false)
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .isActive(false)
     *                                         .stillWaitingResponse(StillWaitingResponseSpecificationProperty.builder()
     *                                                 .frequencyInSeconds(123)
     *                                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                                         .message(MessageProperty.builder()
     *                                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                         .title("title")
     *                                                                         // the properties below are optional
     *                                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                                 .text("text")
     *                                                                                 .value("value")
     *                                                                                 .build()))
     *                                                                         .imageUrl("imageUrl")
     *                                                                         .subtitle("subtitle")
     *                                                                         .build())
     *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .build())
     *                                                         // the properties below are optional
     *                                                         .variations(List.of(MessageProperty.builder()
     *                                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                         .title("title")
     *                                                                         // the properties below are optional
     *                                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                                 .text("text")
     *                                                                                 .value("value")
     *                                                                                 .build()))
     *                                                                         .imageUrl("imageUrl")
     *                                                                         .subtitle("subtitle")
     *                                                                         .build())
     *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                         .value("value")
     *                                                                         .build())
     *                                                                 .build()))
     *                                                         .build()))
     *                                                 .timeoutInSeconds(123)
     *                                                 // the properties below are optional
     *                                                 .allowInterrupt(false)
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .description("description")
     *                         .multipleValuesSetting(MultipleValuesSettingProperty.builder()
     *                                 .allowMultipleValues(false)
     *                                 .build())
     *                         .obfuscationSetting(ObfuscationSettingProperty.builder()
     *                                 .obfuscationSettingType("obfuscationSettingType")
     *                                 .build())
     *                         .build()))
     *                 .build()))
     *         .slotTypes(List.of(SlotTypeProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .description("description")
     *                 .externalSourceSetting(ExternalSourceSettingProperty.builder()
     *                         .grammarSlotTypeSetting(GrammarSlotTypeSettingProperty.builder()
     *                                 .source(GrammarSlotTypeSourceProperty.builder()
     *                                         .s3BucketName("s3BucketName")
     *                                         .s3ObjectKey("s3ObjectKey")
     *                                         // the properties below are optional
     *                                         .kmsKeyArn("kmsKeyArn")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .parentSlotTypeSignature("parentSlotTypeSignature")
     *                 .slotTypeValues(List.of(SlotTypeValueProperty.builder()
     *                         .sampleValue(SampleValueProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         // the properties below are optional
     *                         .synonyms(List.of(SampleValueProperty.builder()
     *                                 .value("value")
     *                                 .build()))
     *                         .build()))
     *                 .valueSelectionSetting(SlotValueSelectionSettingProperty.builder()
     *                         .resolutionStrategy("resolutionStrategy")
     *                         // the properties below are optional
     *                         .advancedRecognitionSetting(AdvancedRecognitionSettingProperty.builder()
     *                                 .audioRecognitionStrategy("audioRecognitionStrategy")
     *                                 .build())
     *                         .regexFilter(SlotValueRegexFilterProperty.builder()
     *                                 .pattern("pattern")
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .voiceSettings(VoiceSettingsProperty.builder()
     *                 .voiceId("voiceId")
     *                 // the properties below are optional
     *                 .engine("engine")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.BotLocaleProperty")
    @software.amazon.jsii.Jsii.Proxy(BotLocaleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BotLocaleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the language and locale that the bot will be used in.
         * <p>
         * The string must match one of the supported locales.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocaleId();

        /**
         * Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents. You must configure an AMAZON.FallbackIntent. AMAZON.KendraSearchIntent is only inserted if it is configured for the bot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getNluConfidenceThreshold();

        /**
         * Specifies a custom vocabulary to use with a specific locale.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomVocabulary() {
            return null;
        }

        /**
         * A description of the bot locale.
         * <p>
         * Use this to help identify the bot locale in lists.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * One or more intents defined for the locale.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntents() {
            return null;
        }

        /**
         * One or more slot types defined for the locale.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSlotTypes() {
            return null;
        }

        /**
         * Identifies the Amazon Polly voice used for audio interaction with the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVoiceSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BotLocaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BotLocaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BotLocaleProperty> {
            java.lang.String localeId;
            java.lang.Number nluConfidenceThreshold;
            java.lang.Object customVocabulary;
            java.lang.String description;
            java.lang.Object intents;
            java.lang.Object slotTypes;
            java.lang.Object voiceSettings;

            /**
             * Sets the value of {@link BotLocaleProperty#getLocaleId}
             * @param localeId The identifier of the language and locale that the bot will be used in. This parameter is required.
             *                 The string must match one of the supported locales.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localeId(java.lang.String localeId) {
                this.localeId = localeId;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getNluConfidenceThreshold}
             * @param nluConfidenceThreshold Determines the threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents. You must configure an AMAZON.FallbackIntent. AMAZON.KendraSearchIntent is only inserted if it is configured for the bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nluConfidenceThreshold(java.lang.Number nluConfidenceThreshold) {
                this.nluConfidenceThreshold = nluConfidenceThreshold;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getCustomVocabulary}
             * @param customVocabulary Specifies a custom vocabulary to use with a specific locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customVocabulary(software.amazon.awscdk.services.lex.CfnBot.CustomVocabularyProperty customVocabulary) {
                this.customVocabulary = customVocabulary;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getCustomVocabulary}
             * @param customVocabulary Specifies a custom vocabulary to use with a specific locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customVocabulary(software.amazon.awscdk.IResolvable customVocabulary) {
                this.customVocabulary = customVocabulary;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getDescription}
             * @param description A description of the bot locale.
             *                    Use this to help identify the bot locale in lists.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getIntents}
             * @param intents One or more intents defined for the locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intents(software.amazon.awscdk.IResolvable intents) {
                this.intents = intents;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getIntents}
             * @param intents One or more intents defined for the locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intents(java.util.List<? extends java.lang.Object> intents) {
                this.intents = intents;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getSlotTypes}
             * @param slotTypes One or more slot types defined for the locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotTypes(software.amazon.awscdk.IResolvable slotTypes) {
                this.slotTypes = slotTypes;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getSlotTypes}
             * @param slotTypes One or more slot types defined for the locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotTypes(java.util.List<? extends java.lang.Object> slotTypes) {
                this.slotTypes = slotTypes;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getVoiceSettings}
             * @param voiceSettings Identifies the Amazon Polly voice used for audio interaction with the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder voiceSettings(software.amazon.awscdk.services.lex.CfnBot.VoiceSettingsProperty voiceSettings) {
                this.voiceSettings = voiceSettings;
                return this;
            }

            /**
             * Sets the value of {@link BotLocaleProperty#getVoiceSettings}
             * @param voiceSettings Identifies the Amazon Polly voice used for audio interaction with the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder voiceSettings(software.amazon.awscdk.IResolvable voiceSettings) {
                this.voiceSettings = voiceSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BotLocaleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BotLocaleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BotLocaleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BotLocaleProperty {
            private final java.lang.String localeId;
            private final java.lang.Number nluConfidenceThreshold;
            private final java.lang.Object customVocabulary;
            private final java.lang.String description;
            private final java.lang.Object intents;
            private final java.lang.Object slotTypes;
            private final java.lang.Object voiceSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.localeId = software.amazon.jsii.Kernel.get(this, "localeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nluConfidenceThreshold = software.amazon.jsii.Kernel.get(this, "nluConfidenceThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.customVocabulary = software.amazon.jsii.Kernel.get(this, "customVocabulary", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.intents = software.amazon.jsii.Kernel.get(this, "intents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.slotTypes = software.amazon.jsii.Kernel.get(this, "slotTypes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.voiceSettings = software.amazon.jsii.Kernel.get(this, "voiceSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.localeId = java.util.Objects.requireNonNull(builder.localeId, "localeId is required");
                this.nluConfidenceThreshold = java.util.Objects.requireNonNull(builder.nluConfidenceThreshold, "nluConfidenceThreshold is required");
                this.customVocabulary = builder.customVocabulary;
                this.description = builder.description;
                this.intents = builder.intents;
                this.slotTypes = builder.slotTypes;
                this.voiceSettings = builder.voiceSettings;
            }

            @Override
            public final java.lang.String getLocaleId() {
                return this.localeId;
            }

            @Override
            public final java.lang.Number getNluConfidenceThreshold() {
                return this.nluConfidenceThreshold;
            }

            @Override
            public final java.lang.Object getCustomVocabulary() {
                return this.customVocabulary;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getIntents() {
                return this.intents;
            }

            @Override
            public final java.lang.Object getSlotTypes() {
                return this.slotTypes;
            }

            @Override
            public final java.lang.Object getVoiceSettings() {
                return this.voiceSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("localeId", om.valueToTree(this.getLocaleId()));
                data.set("nluConfidenceThreshold", om.valueToTree(this.getNluConfidenceThreshold()));
                if (this.getCustomVocabulary() != null) {
                    data.set("customVocabulary", om.valueToTree(this.getCustomVocabulary()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getIntents() != null) {
                    data.set("intents", om.valueToTree(this.getIntents()));
                }
                if (this.getSlotTypes() != null) {
                    data.set("slotTypes", om.valueToTree(this.getSlotTypes()));
                }
                if (this.getVoiceSettings() != null) {
                    data.set("voiceSettings", om.valueToTree(this.getVoiceSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.BotLocaleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BotLocaleProperty.Jsii$Proxy that = (BotLocaleProperty.Jsii$Proxy) o;

                if (!localeId.equals(that.localeId)) return false;
                if (!nluConfidenceThreshold.equals(that.nluConfidenceThreshold)) return false;
                if (this.customVocabulary != null ? !this.customVocabulary.equals(that.customVocabulary) : that.customVocabulary != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.intents != null ? !this.intents.equals(that.intents) : that.intents != null) return false;
                if (this.slotTypes != null ? !this.slotTypes.equals(that.slotTypes) : that.slotTypes != null) return false;
                return this.voiceSettings != null ? this.voiceSettings.equals(that.voiceSettings) : that.voiceSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.localeId.hashCode();
                result = 31 * result + (this.nluConfidenceThreshold.hashCode());
                result = 31 * result + (this.customVocabulary != null ? this.customVocabulary.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.intents != null ? this.intents.hashCode() : 0);
                result = 31 * result + (this.slotTypes != null ? this.slotTypes.hashCode() : 0);
                result = 31 * result + (this.voiceSettings != null ? this.voiceSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a button to use on a response card used to gather slot values from a user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * ButtonProperty buttonProperty = ButtonProperty.builder()
     *         .text("text")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.ButtonProperty")
    @software.amazon.jsii.Jsii.Proxy(ButtonProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ButtonProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The text that appears on the button.
         * <p>
         * Use this to tell the user the value that is returned when they choose this button.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getText();

        /**
         * The value returned to Amazon Lex when the user chooses this button.
         * <p>
         * This must be one of the slot values configured for the slot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link ButtonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ButtonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ButtonProperty> {
            java.lang.String text;
            java.lang.String value;

            /**
             * Sets the value of {@link ButtonProperty#getText}
             * @param text The text that appears on the button. This parameter is required.
             *             Use this to tell the user the value that is returned when they choose this button.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link ButtonProperty#getValue}
             * @param value The value returned to Amazon Lex when the user chooses this button. This parameter is required.
             *              This must be one of the slot values configured for the slot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ButtonProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ButtonProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ButtonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ButtonProperty {
            private final java.lang.String text;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.text = java.util.Objects.requireNonNull(builder.text, "text is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("text", om.valueToTree(this.getText()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.ButtonProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ButtonProperty.Jsii$Proxy that = (ButtonProperty.Jsii$Proxy) o;

                if (!text.equals(that.text)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.text.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the Amazon CloudWatch Logs log group where text and metadata logs are delivered.
     * <p>
     * The log group must exist before you enable logging.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * CloudWatchLogGroupLogDestinationProperty cloudWatchLogGroupLogDestinationProperty = CloudWatchLogGroupLogDestinationProperty.builder()
     *         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
     *         .logPrefix("logPrefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.CloudWatchLogGroupLogDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLogGroupLogDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLogGroupLogDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the Amazon Resource Name (ARN) of the log group where text and metadata logs are delivered.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCloudWatchLogGroupArn();

        /**
         * Specifies the prefix of the log stream name within the log group that you specified.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogPrefix();

        /**
         * @return a {@link Builder} of {@link CloudWatchLogGroupLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLogGroupLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogGroupLogDestinationProperty> {
            java.lang.String cloudWatchLogGroupArn;
            java.lang.String logPrefix;

            /**
             * Sets the value of {@link CloudWatchLogGroupLogDestinationProperty#getCloudWatchLogGroupArn}
             * @param cloudWatchLogGroupArn Specifies the Amazon Resource Name (ARN) of the log group where text and metadata logs are delivered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogGroupArn(java.lang.String cloudWatchLogGroupArn) {
                this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLogGroupLogDestinationProperty#getLogPrefix}
             * @param logPrefix Specifies the prefix of the log stream name within the log group that you specified. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logPrefix(java.lang.String logPrefix) {
                this.logPrefix = logPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogGroupLogDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLogGroupLogDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLogGroupLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogGroupLogDestinationProperty {
            private final java.lang.String cloudWatchLogGroupArn;
            private final java.lang.String logPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogGroupArn = software.amazon.jsii.Kernel.get(this, "cloudWatchLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logPrefix = software.amazon.jsii.Kernel.get(this, "logPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogGroupArn = java.util.Objects.requireNonNull(builder.cloudWatchLogGroupArn, "cloudWatchLogGroupArn is required");
                this.logPrefix = java.util.Objects.requireNonNull(builder.logPrefix, "logPrefix is required");
            }

            @Override
            public final java.lang.String getCloudWatchLogGroupArn() {
                return this.cloudWatchLogGroupArn;
            }

            @Override
            public final java.lang.String getLogPrefix() {
                return this.logPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cloudWatchLogGroupArn", om.valueToTree(this.getCloudWatchLogGroupArn()));
                data.set("logPrefix", om.valueToTree(this.getLogPrefix()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.CloudWatchLogGroupLogDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLogGroupLogDestinationProperty.Jsii$Proxy that = (CloudWatchLogGroupLogDestinationProperty.Jsii$Proxy) o;

                if (!cloudWatchLogGroupArn.equals(that.cloudWatchLogGroupArn)) return false;
                return this.logPrefix.equals(that.logPrefix);
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogGroupArn.hashCode();
                result = 31 * result + (this.logPrefix.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies information about code hooks that Amazon Lex calls during a conversation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * CodeHookSpecificationProperty codeHookSpecificationProperty = CodeHookSpecificationProperty.builder()
     *         .lambdaCodeHook(LambdaCodeHookProperty.builder()
     *                 .codeHookInterfaceVersion("codeHookInterfaceVersion")
     *                 .lambdaArn("lambdaArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.CodeHookSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CodeHookSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CodeHookSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a Lambda function that verifies requests to a bot or fulfills the user's request to a bot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLambdaCodeHook();

        /**
         * @return a {@link Builder} of {@link CodeHookSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CodeHookSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CodeHookSpecificationProperty> {
            java.lang.Object lambdaCodeHook;

            /**
             * Sets the value of {@link CodeHookSpecificationProperty#getLambdaCodeHook}
             * @param lambdaCodeHook Specifies a Lambda function that verifies requests to a bot or fulfills the user's request to a bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaCodeHook(software.amazon.awscdk.services.lex.CfnBot.LambdaCodeHookProperty lambdaCodeHook) {
                this.lambdaCodeHook = lambdaCodeHook;
                return this;
            }

            /**
             * Sets the value of {@link CodeHookSpecificationProperty#getLambdaCodeHook}
             * @param lambdaCodeHook Specifies a Lambda function that verifies requests to a bot or fulfills the user's request to a bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaCodeHook(software.amazon.awscdk.IResolvable lambdaCodeHook) {
                this.lambdaCodeHook = lambdaCodeHook;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CodeHookSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CodeHookSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CodeHookSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeHookSpecificationProperty {
            private final java.lang.Object lambdaCodeHook;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaCodeHook = software.amazon.jsii.Kernel.get(this, "lambdaCodeHook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaCodeHook = java.util.Objects.requireNonNull(builder.lambdaCodeHook, "lambdaCodeHook is required");
            }

            @Override
            public final java.lang.Object getLambdaCodeHook() {
                return this.lambdaCodeHook;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("lambdaCodeHook", om.valueToTree(this.getLambdaCodeHook()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.CodeHookSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CodeHookSpecificationProperty.Jsii$Proxy that = (CodeHookSpecificationProperty.Jsii$Proxy) o;

                return this.lambdaCodeHook.equals(that.lambdaCodeHook);
            }

            @Override
            public final int hashCode() {
                int result = this.lambdaCodeHook.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies settings that manage logging that saves audio, text, and metadata for the conversations with your users.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * ConversationLogSettingsProperty conversationLogSettingsProperty = ConversationLogSettingsProperty.builder()
     *         .audioLogSettings(List.of(AudioLogSettingProperty.builder()
     *                 .destination(AudioLogDestinationProperty.builder()
     *                         .s3Bucket(S3BucketLogDestinationProperty.builder()
     *                                 .logPrefix("logPrefix")
     *                                 .s3BucketArn("s3BucketArn")
     *                                 // the properties below are optional
     *                                 .kmsKeyArn("kmsKeyArn")
     *                                 .build())
     *                         .build())
     *                 .enabled(false)
     *                 .build()))
     *         .textLogSettings(List.of(TextLogSettingProperty.builder()
     *                 .destination(TextLogDestinationProperty.builder()
     *                         .cloudWatch(CloudWatchLogGroupLogDestinationProperty.builder()
     *                                 .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
     *                                 .logPrefix("logPrefix")
     *                                 .build())
     *                         .build())
     *                 .enabled(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.ConversationLogSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(ConversationLogSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConversationLogSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the Amazon S3 settings for logging audio to an S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioLogSettings() {
            return null;
        }

        /**
         * Specifies settings to enable text conversation logs.
         * <p>
         * You specify the Amazon CloudWatch Logs log group and whether logs should be stored for an alias.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTextLogSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConversationLogSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConversationLogSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConversationLogSettingsProperty> {
            java.lang.Object audioLogSettings;
            java.lang.Object textLogSettings;

            /**
             * Sets the value of {@link ConversationLogSettingsProperty#getAudioLogSettings}
             * @param audioLogSettings Specifies the Amazon S3 settings for logging audio to an S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioLogSettings(software.amazon.awscdk.IResolvable audioLogSettings) {
                this.audioLogSettings = audioLogSettings;
                return this;
            }

            /**
             * Sets the value of {@link ConversationLogSettingsProperty#getAudioLogSettings}
             * @param audioLogSettings Specifies the Amazon S3 settings for logging audio to an S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioLogSettings(java.util.List<? extends java.lang.Object> audioLogSettings) {
                this.audioLogSettings = audioLogSettings;
                return this;
            }

            /**
             * Sets the value of {@link ConversationLogSettingsProperty#getTextLogSettings}
             * @param textLogSettings Specifies settings to enable text conversation logs.
             *                        You specify the Amazon CloudWatch Logs log group and whether logs should be stored for an alias.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textLogSettings(software.amazon.awscdk.IResolvable textLogSettings) {
                this.textLogSettings = textLogSettings;
                return this;
            }

            /**
             * Sets the value of {@link ConversationLogSettingsProperty#getTextLogSettings}
             * @param textLogSettings Specifies settings to enable text conversation logs.
             *                        You specify the Amazon CloudWatch Logs log group and whether logs should be stored for an alias.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textLogSettings(java.util.List<? extends java.lang.Object> textLogSettings) {
                this.textLogSettings = textLogSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConversationLogSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConversationLogSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConversationLogSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConversationLogSettingsProperty {
            private final java.lang.Object audioLogSettings;
            private final java.lang.Object textLogSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioLogSettings = software.amazon.jsii.Kernel.get(this, "audioLogSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.textLogSettings = software.amazon.jsii.Kernel.get(this, "textLogSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioLogSettings = builder.audioLogSettings;
                this.textLogSettings = builder.textLogSettings;
            }

            @Override
            public final java.lang.Object getAudioLogSettings() {
                return this.audioLogSettings;
            }

            @Override
            public final java.lang.Object getTextLogSettings() {
                return this.textLogSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioLogSettings() != null) {
                    data.set("audioLogSettings", om.valueToTree(this.getAudioLogSettings()));
                }
                if (this.getTextLogSettings() != null) {
                    data.set("textLogSettings", om.valueToTree(this.getTextLogSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.ConversationLogSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConversationLogSettingsProperty.Jsii$Proxy that = (ConversationLogSettingsProperty.Jsii$Proxy) o;

                if (this.audioLogSettings != null ? !this.audioLogSettings.equals(that.audioLogSettings) : that.audioLogSettings != null) return false;
                return this.textLogSettings != null ? this.textLogSettings.equals(that.textLogSettings) : that.textLogSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioLogSettings != null ? this.audioLogSettings.hashCode() : 0;
                result = 31 * result + (this.textLogSettings != null ? this.textLogSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A custom response string that Amazon Lex sends to your application.
     * <p>
     * You define the content and structure of the string.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * CustomPayloadProperty customPayloadProperty = CustomPayloadProperty.builder()
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.CustomPayloadProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomPayloadProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomPayloadProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The string that is sent to your application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link CustomPayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomPayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomPayloadProperty> {
            java.lang.String value;

            /**
             * Sets the value of {@link CustomPayloadProperty#getValue}
             * @param value The string that is sent to your application. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomPayloadProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomPayloadProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomPayloadProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomPayloadProperty {
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.CustomPayloadProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomPayloadProperty.Jsii$Proxy that = (CustomPayloadProperty.Jsii$Proxy) o;

                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies an entry in a custom vocabulary.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * CustomVocabularyItemProperty customVocabularyItemProperty = CustomVocabularyItemProperty.builder()
     *         .phrase("phrase")
     *         // the properties below are optional
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.CustomVocabularyItemProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomVocabularyItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomVocabularyItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies 1 - 4 words that should be recognized.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPhrase();

        /**
         * Specifies the degree to which the phrase recognition is boosted.
         * <p>
         * The default value is 1.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomVocabularyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomVocabularyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomVocabularyItemProperty> {
            java.lang.String phrase;
            java.lang.Number weight;

            /**
             * Sets the value of {@link CustomVocabularyItemProperty#getPhrase}
             * @param phrase Specifies 1 - 4 words that should be recognized. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phrase(java.lang.String phrase) {
                this.phrase = phrase;
                return this;
            }

            /**
             * Sets the value of {@link CustomVocabularyItemProperty#getWeight}
             * @param weight Specifies the degree to which the phrase recognition is boosted.
             *               The default value is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomVocabularyItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomVocabularyItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomVocabularyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomVocabularyItemProperty {
            private final java.lang.String phrase;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.phrase = software.amazon.jsii.Kernel.get(this, "phrase", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.phrase = java.util.Objects.requireNonNull(builder.phrase, "phrase is required");
                this.weight = builder.weight;
            }

            @Override
            public final java.lang.String getPhrase() {
                return this.phrase;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("phrase", om.valueToTree(this.getPhrase()));
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.CustomVocabularyItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomVocabularyItemProperty.Jsii$Proxy that = (CustomVocabularyItemProperty.Jsii$Proxy) o;

                if (!phrase.equals(that.phrase)) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public final int hashCode() {
                int result = this.phrase.hashCode();
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a custom vocabulary.
     * <p>
     * A custom vocabulary is a list of words that you expect to be used during a conversation with your bot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * CustomVocabularyProperty customVocabularyProperty = CustomVocabularyProperty.builder()
     *         .customVocabularyItems(List.of(CustomVocabularyItemProperty.builder()
     *                 .phrase("phrase")
     *                 // the properties below are optional
     *                 .weight(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.CustomVocabularyProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomVocabularyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomVocabularyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a list of words that you expect to be used during a conversation with your bot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCustomVocabularyItems();

        /**
         * @return a {@link Builder} of {@link CustomVocabularyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomVocabularyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomVocabularyProperty> {
            java.lang.Object customVocabularyItems;

            /**
             * Sets the value of {@link CustomVocabularyProperty#getCustomVocabularyItems}
             * @param customVocabularyItems Specifies a list of words that you expect to be used during a conversation with your bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customVocabularyItems(software.amazon.awscdk.IResolvable customVocabularyItems) {
                this.customVocabularyItems = customVocabularyItems;
                return this;
            }

            /**
             * Sets the value of {@link CustomVocabularyProperty#getCustomVocabularyItems}
             * @param customVocabularyItems Specifies a list of words that you expect to be used during a conversation with your bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customVocabularyItems(java.util.List<? extends java.lang.Object> customVocabularyItems) {
                this.customVocabularyItems = customVocabularyItems;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomVocabularyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomVocabularyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomVocabularyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomVocabularyProperty {
            private final java.lang.Object customVocabularyItems;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customVocabularyItems = software.amazon.jsii.Kernel.get(this, "customVocabularyItems", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customVocabularyItems = java.util.Objects.requireNonNull(builder.customVocabularyItems, "customVocabularyItems is required");
            }

            @Override
            public final java.lang.Object getCustomVocabularyItems() {
                return this.customVocabularyItems;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("customVocabularyItems", om.valueToTree(this.getCustomVocabularyItems()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.CustomVocabularyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomVocabularyProperty.Jsii$Proxy that = (CustomVocabularyProperty.Jsii$Proxy) o;

                return this.customVocabularyItems.equals(that.customVocabularyItems);
            }

            @Override
            public final int hashCode() {
                int result = this.customVocabularyItems.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies whether an intent uses the dialog code hook during conversations with a user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * DialogCodeHookSettingProperty dialogCodeHookSettingProperty = DialogCodeHookSettingProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.DialogCodeHookSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(DialogCodeHookSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DialogCodeHookSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether an intent uses the dialog code hook during a conversation with a user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link DialogCodeHookSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DialogCodeHookSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DialogCodeHookSettingProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link DialogCodeHookSettingProperty#getEnabled}
             * @param enabled Indicates whether an intent uses the dialog code hook during a conversation with a user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DialogCodeHookSettingProperty#getEnabled}
             * @param enabled Indicates whether an intent uses the dialog code hook during a conversation with a user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DialogCodeHookSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DialogCodeHookSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DialogCodeHookSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DialogCodeHookSettingProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.DialogCodeHookSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DialogCodeHookSettingProperty.Jsii$Proxy that = (DialogCodeHookSettingProperty.Jsii$Proxy) o;

                return this.enabled.equals(that.enabled);
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                return result;
            }
        }
    }
    /**
     * Provides information about the external source of the slot type's definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * ExternalSourceSettingProperty externalSourceSettingProperty = ExternalSourceSettingProperty.builder()
     *         .grammarSlotTypeSetting(GrammarSlotTypeSettingProperty.builder()
     *                 .source(GrammarSlotTypeSourceProperty.builder()
     *                         .s3BucketName("s3BucketName")
     *                         .s3ObjectKey("s3ObjectKey")
     *                         // the properties below are optional
     *                         .kmsKeyArn("kmsKeyArn")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.ExternalSourceSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(ExternalSourceSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExternalSourceSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Settings required for a slot type based on a grammar that you provide.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGrammarSlotTypeSetting() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExternalSourceSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExternalSourceSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExternalSourceSettingProperty> {
            java.lang.Object grammarSlotTypeSetting;

            /**
             * Sets the value of {@link ExternalSourceSettingProperty#getGrammarSlotTypeSetting}
             * @param grammarSlotTypeSetting Settings required for a slot type based on a grammar that you provide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grammarSlotTypeSetting(software.amazon.awscdk.services.lex.CfnBot.GrammarSlotTypeSettingProperty grammarSlotTypeSetting) {
                this.grammarSlotTypeSetting = grammarSlotTypeSetting;
                return this;
            }

            /**
             * Sets the value of {@link ExternalSourceSettingProperty#getGrammarSlotTypeSetting}
             * @param grammarSlotTypeSetting Settings required for a slot type based on a grammar that you provide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grammarSlotTypeSetting(software.amazon.awscdk.IResolvable grammarSlotTypeSetting) {
                this.grammarSlotTypeSetting = grammarSlotTypeSetting;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExternalSourceSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExternalSourceSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExternalSourceSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExternalSourceSettingProperty {
            private final java.lang.Object grammarSlotTypeSetting;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.grammarSlotTypeSetting = software.amazon.jsii.Kernel.get(this, "grammarSlotTypeSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.grammarSlotTypeSetting = builder.grammarSlotTypeSetting;
            }

            @Override
            public final java.lang.Object getGrammarSlotTypeSetting() {
                return this.grammarSlotTypeSetting;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGrammarSlotTypeSetting() != null) {
                    data.set("grammarSlotTypeSetting", om.valueToTree(this.getGrammarSlotTypeSetting()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.ExternalSourceSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExternalSourceSettingProperty.Jsii$Proxy that = (ExternalSourceSettingProperty.Jsii$Proxy) o;

                return this.grammarSlotTypeSetting != null ? this.grammarSlotTypeSetting.equals(that.grammarSlotTypeSetting) : that.grammarSlotTypeSetting == null;
            }

            @Override
            public final int hashCode() {
                int result = this.grammarSlotTypeSetting != null ? this.grammarSlotTypeSetting.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Determines if a Lambda function should be invoked for a specific intent.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * FulfillmentCodeHookSettingProperty fulfillmentCodeHookSettingProperty = FulfillmentCodeHookSettingProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .fulfillmentUpdatesSpecification(FulfillmentUpdatesSpecificationProperty.builder()
     *                 .active(false)
     *                 // the properties below are optional
     *                 .startResponse(FulfillmentStartResponseSpecificationProperty.builder()
     *                         .delayInSeconds(123)
     *                         .messageGroups(List.of(MessageGroupProperty.builder()
     *                                 .message(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .variations(List.of(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build()))
     *                                 .build()))
     *                         // the properties below are optional
     *                         .allowInterrupt(false)
     *                         .build())
     *                 .timeoutInSeconds(123)
     *                 .updateResponse(FulfillmentUpdateResponseSpecificationProperty.builder()
     *                         .frequencyInSeconds(123)
     *                         .messageGroups(List.of(MessageGroupProperty.builder()
     *                                 .message(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .variations(List.of(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build()))
     *                                 .build()))
     *                         // the properties below are optional
     *                         .allowInterrupt(false)
     *                         .build())
     *                 .build())
     *         .postFulfillmentStatusSpecification(PostFulfillmentStatusSpecificationProperty.builder()
     *                 .failureResponse(ResponseSpecificationProperty.builder()
     *                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                 .message(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .variations(List.of(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build()))
     *                                 .build()))
     *                         // the properties below are optional
     *                         .allowInterrupt(false)
     *                         .build())
     *                 .successResponse(ResponseSpecificationProperty.builder()
     *                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                 .message(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .variations(List.of(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build()))
     *                                 .build()))
     *                         // the properties below are optional
     *                         .allowInterrupt(false)
     *                         .build())
     *                 .timeoutResponse(ResponseSpecificationProperty.builder()
     *                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                 .message(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .variations(List.of(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build()))
     *                                 .build()))
     *                         // the properties below are optional
     *                         .allowInterrupt(false)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.FulfillmentCodeHookSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(FulfillmentCodeHookSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FulfillmentCodeHookSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether a Lambda function should be invoked for fulfill a specific intent.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * Provides settings for update messages sent to the user for long-running Lambda fulfillment functions.
         * <p>
         * Fulfillment updates can be used only with streaming conversations.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFulfillmentUpdatesSpecification() {
            return null;
        }

        /**
         * Provides settings for messages sent to the user for after the Lambda fulfillment function completes.
         * <p>
         * Post-fulfillment messages can be sent for both streaming and non-streaming conversations.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPostFulfillmentStatusSpecification() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FulfillmentCodeHookSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FulfillmentCodeHookSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FulfillmentCodeHookSettingProperty> {
            java.lang.Object enabled;
            java.lang.Object fulfillmentUpdatesSpecification;
            java.lang.Object postFulfillmentStatusSpecification;

            /**
             * Sets the value of {@link FulfillmentCodeHookSettingProperty#getEnabled}
             * @param enabled Indicates whether a Lambda function should be invoked for fulfill a specific intent. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentCodeHookSettingProperty#getEnabled}
             * @param enabled Indicates whether a Lambda function should be invoked for fulfill a specific intent. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentCodeHookSettingProperty#getFulfillmentUpdatesSpecification}
             * @param fulfillmentUpdatesSpecification Provides settings for update messages sent to the user for long-running Lambda fulfillment functions.
             *                                        Fulfillment updates can be used only with streaming conversations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fulfillmentUpdatesSpecification(software.amazon.awscdk.services.lex.CfnBot.FulfillmentUpdatesSpecificationProperty fulfillmentUpdatesSpecification) {
                this.fulfillmentUpdatesSpecification = fulfillmentUpdatesSpecification;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentCodeHookSettingProperty#getFulfillmentUpdatesSpecification}
             * @param fulfillmentUpdatesSpecification Provides settings for update messages sent to the user for long-running Lambda fulfillment functions.
             *                                        Fulfillment updates can be used only with streaming conversations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fulfillmentUpdatesSpecification(software.amazon.awscdk.IResolvable fulfillmentUpdatesSpecification) {
                this.fulfillmentUpdatesSpecification = fulfillmentUpdatesSpecification;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentCodeHookSettingProperty#getPostFulfillmentStatusSpecification}
             * @param postFulfillmentStatusSpecification Provides settings for messages sent to the user for after the Lambda fulfillment function completes.
             *                                           Post-fulfillment messages can be sent for both streaming and non-streaming conversations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postFulfillmentStatusSpecification(software.amazon.awscdk.services.lex.CfnBot.PostFulfillmentStatusSpecificationProperty postFulfillmentStatusSpecification) {
                this.postFulfillmentStatusSpecification = postFulfillmentStatusSpecification;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentCodeHookSettingProperty#getPostFulfillmentStatusSpecification}
             * @param postFulfillmentStatusSpecification Provides settings for messages sent to the user for after the Lambda fulfillment function completes.
             *                                           Post-fulfillment messages can be sent for both streaming and non-streaming conversations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postFulfillmentStatusSpecification(software.amazon.awscdk.IResolvable postFulfillmentStatusSpecification) {
                this.postFulfillmentStatusSpecification = postFulfillmentStatusSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FulfillmentCodeHookSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FulfillmentCodeHookSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FulfillmentCodeHookSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FulfillmentCodeHookSettingProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object fulfillmentUpdatesSpecification;
            private final java.lang.Object postFulfillmentStatusSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fulfillmentUpdatesSpecification = software.amazon.jsii.Kernel.get(this, "fulfillmentUpdatesSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.postFulfillmentStatusSpecification = software.amazon.jsii.Kernel.get(this, "postFulfillmentStatusSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.fulfillmentUpdatesSpecification = builder.fulfillmentUpdatesSpecification;
                this.postFulfillmentStatusSpecification = builder.postFulfillmentStatusSpecification;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getFulfillmentUpdatesSpecification() {
                return this.fulfillmentUpdatesSpecification;
            }

            @Override
            public final java.lang.Object getPostFulfillmentStatusSpecification() {
                return this.postFulfillmentStatusSpecification;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getFulfillmentUpdatesSpecification() != null) {
                    data.set("fulfillmentUpdatesSpecification", om.valueToTree(this.getFulfillmentUpdatesSpecification()));
                }
                if (this.getPostFulfillmentStatusSpecification() != null) {
                    data.set("postFulfillmentStatusSpecification", om.valueToTree(this.getPostFulfillmentStatusSpecification()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.FulfillmentCodeHookSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FulfillmentCodeHookSettingProperty.Jsii$Proxy that = (FulfillmentCodeHookSettingProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (this.fulfillmentUpdatesSpecification != null ? !this.fulfillmentUpdatesSpecification.equals(that.fulfillmentUpdatesSpecification) : that.fulfillmentUpdatesSpecification != null) return false;
                return this.postFulfillmentStatusSpecification != null ? this.postFulfillmentStatusSpecification.equals(that.postFulfillmentStatusSpecification) : that.postFulfillmentStatusSpecification == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.fulfillmentUpdatesSpecification != null ? this.fulfillmentUpdatesSpecification.hashCode() : 0);
                result = 31 * result + (this.postFulfillmentStatusSpecification != null ? this.postFulfillmentStatusSpecification.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides settings for a message that is sent to the user when a fulfillment Lambda function starts running.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * FulfillmentStartResponseSpecificationProperty fulfillmentStartResponseSpecificationProperty = FulfillmentStartResponseSpecificationProperty.builder()
     *         .delayInSeconds(123)
     *         .messageGroups(List.of(MessageGroupProperty.builder()
     *                 .message(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .variations(List.of(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build()))
     *                 .build()))
     *         // the properties below are optional
     *         .allowInterrupt(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.FulfillmentStartResponseSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(FulfillmentStartResponseSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FulfillmentStartResponseSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The delay between when the Lambda fulfillment function starts running and the start message is played.
         * <p>
         * If the Lambda function returns before the delay is over, the start message isn't played.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDelayInSeconds();

        /**
         * One to 5 message groups that contain start messages.
         * <p>
         * Amazon Lex chooses one of the messages to play to the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMessageGroups();

        /**
         * Determines whether the user can interrupt the start message while it is playing.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowInterrupt() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FulfillmentStartResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FulfillmentStartResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FulfillmentStartResponseSpecificationProperty> {
            java.lang.Number delayInSeconds;
            java.lang.Object messageGroups;
            java.lang.Object allowInterrupt;

            /**
             * Sets the value of {@link FulfillmentStartResponseSpecificationProperty#getDelayInSeconds}
             * @param delayInSeconds The delay between when the Lambda fulfillment function starts running and the start message is played. This parameter is required.
             *                       If the Lambda function returns before the delay is over, the start message isn't played.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delayInSeconds(java.lang.Number delayInSeconds) {
                this.delayInSeconds = delayInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentStartResponseSpecificationProperty#getMessageGroups}
             * @param messageGroups One to 5 message groups that contain start messages. This parameter is required.
             *                      Amazon Lex chooses one of the messages to play to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroups(software.amazon.awscdk.IResolvable messageGroups) {
                this.messageGroups = messageGroups;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentStartResponseSpecificationProperty#getMessageGroups}
             * @param messageGroups One to 5 message groups that contain start messages. This parameter is required.
             *                      Amazon Lex chooses one of the messages to play to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroups(java.util.List<? extends java.lang.Object> messageGroups) {
                this.messageGroups = messageGroups;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentStartResponseSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Determines whether the user can interrupt the start message while it is playing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(java.lang.Boolean allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentStartResponseSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Determines whether the user can interrupt the start message while it is playing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(software.amazon.awscdk.IResolvable allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FulfillmentStartResponseSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FulfillmentStartResponseSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FulfillmentStartResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FulfillmentStartResponseSpecificationProperty {
            private final java.lang.Number delayInSeconds;
            private final java.lang.Object messageGroups;
            private final java.lang.Object allowInterrupt;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.delayInSeconds = software.amazon.jsii.Kernel.get(this, "delayInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.messageGroups = software.amazon.jsii.Kernel.get(this, "messageGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowInterrupt = software.amazon.jsii.Kernel.get(this, "allowInterrupt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.delayInSeconds = java.util.Objects.requireNonNull(builder.delayInSeconds, "delayInSeconds is required");
                this.messageGroups = java.util.Objects.requireNonNull(builder.messageGroups, "messageGroups is required");
                this.allowInterrupt = builder.allowInterrupt;
            }

            @Override
            public final java.lang.Number getDelayInSeconds() {
                return this.delayInSeconds;
            }

            @Override
            public final java.lang.Object getMessageGroups() {
                return this.messageGroups;
            }

            @Override
            public final java.lang.Object getAllowInterrupt() {
                return this.allowInterrupt;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("delayInSeconds", om.valueToTree(this.getDelayInSeconds()));
                data.set("messageGroups", om.valueToTree(this.getMessageGroups()));
                if (this.getAllowInterrupt() != null) {
                    data.set("allowInterrupt", om.valueToTree(this.getAllowInterrupt()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.FulfillmentStartResponseSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FulfillmentStartResponseSpecificationProperty.Jsii$Proxy that = (FulfillmentStartResponseSpecificationProperty.Jsii$Proxy) o;

                if (!delayInSeconds.equals(that.delayInSeconds)) return false;
                if (!messageGroups.equals(that.messageGroups)) return false;
                return this.allowInterrupt != null ? this.allowInterrupt.equals(that.allowInterrupt) : that.allowInterrupt == null;
            }

            @Override
            public final int hashCode() {
                int result = this.delayInSeconds.hashCode();
                result = 31 * result + (this.messageGroups.hashCode());
                result = 31 * result + (this.allowInterrupt != null ? this.allowInterrupt.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information for updating the user on the progress of fulfilling an intent.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * FulfillmentUpdateResponseSpecificationProperty fulfillmentUpdateResponseSpecificationProperty = FulfillmentUpdateResponseSpecificationProperty.builder()
     *         .frequencyInSeconds(123)
     *         .messageGroups(List.of(MessageGroupProperty.builder()
     *                 .message(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .variations(List.of(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build()))
     *                 .build()))
     *         // the properties below are optional
     *         .allowInterrupt(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.FulfillmentUpdateResponseSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(FulfillmentUpdateResponseSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FulfillmentUpdateResponseSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The frequency that a message is sent to the user.
         * <p>
         * When the period ends, Amazon Lex chooses a message from the message groups and plays it to the user. If the fulfillment Lambda function returns before the first period ends, an update message is not played to the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getFrequencyInSeconds();

        /**
         * One to 5 message groups that contain update messages.
         * <p>
         * Amazon Lex chooses one of the messages to play to the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMessageGroups();

        /**
         * Determines whether the user can interrupt an update message while it is playing.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowInterrupt() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FulfillmentUpdateResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FulfillmentUpdateResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FulfillmentUpdateResponseSpecificationProperty> {
            java.lang.Number frequencyInSeconds;
            java.lang.Object messageGroups;
            java.lang.Object allowInterrupt;

            /**
             * Sets the value of {@link FulfillmentUpdateResponseSpecificationProperty#getFrequencyInSeconds}
             * @param frequencyInSeconds The frequency that a message is sent to the user. This parameter is required.
             *                           When the period ends, Amazon Lex chooses a message from the message groups and plays it to the user. If the fulfillment Lambda function returns before the first period ends, an update message is not played to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frequencyInSeconds(java.lang.Number frequencyInSeconds) {
                this.frequencyInSeconds = frequencyInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdateResponseSpecificationProperty#getMessageGroups}
             * @param messageGroups One to 5 message groups that contain update messages. This parameter is required.
             *                      Amazon Lex chooses one of the messages to play to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroups(software.amazon.awscdk.IResolvable messageGroups) {
                this.messageGroups = messageGroups;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdateResponseSpecificationProperty#getMessageGroups}
             * @param messageGroups One to 5 message groups that contain update messages. This parameter is required.
             *                      Amazon Lex chooses one of the messages to play to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroups(java.util.List<? extends java.lang.Object> messageGroups) {
                this.messageGroups = messageGroups;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdateResponseSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Determines whether the user can interrupt an update message while it is playing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(java.lang.Boolean allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdateResponseSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Determines whether the user can interrupt an update message while it is playing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(software.amazon.awscdk.IResolvable allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FulfillmentUpdateResponseSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FulfillmentUpdateResponseSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FulfillmentUpdateResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FulfillmentUpdateResponseSpecificationProperty {
            private final java.lang.Number frequencyInSeconds;
            private final java.lang.Object messageGroups;
            private final java.lang.Object allowInterrupt;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.frequencyInSeconds = software.amazon.jsii.Kernel.get(this, "frequencyInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.messageGroups = software.amazon.jsii.Kernel.get(this, "messageGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowInterrupt = software.amazon.jsii.Kernel.get(this, "allowInterrupt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.frequencyInSeconds = java.util.Objects.requireNonNull(builder.frequencyInSeconds, "frequencyInSeconds is required");
                this.messageGroups = java.util.Objects.requireNonNull(builder.messageGroups, "messageGroups is required");
                this.allowInterrupt = builder.allowInterrupt;
            }

            @Override
            public final java.lang.Number getFrequencyInSeconds() {
                return this.frequencyInSeconds;
            }

            @Override
            public final java.lang.Object getMessageGroups() {
                return this.messageGroups;
            }

            @Override
            public final java.lang.Object getAllowInterrupt() {
                return this.allowInterrupt;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("frequencyInSeconds", om.valueToTree(this.getFrequencyInSeconds()));
                data.set("messageGroups", om.valueToTree(this.getMessageGroups()));
                if (this.getAllowInterrupt() != null) {
                    data.set("allowInterrupt", om.valueToTree(this.getAllowInterrupt()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.FulfillmentUpdateResponseSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FulfillmentUpdateResponseSpecificationProperty.Jsii$Proxy that = (FulfillmentUpdateResponseSpecificationProperty.Jsii$Proxy) o;

                if (!frequencyInSeconds.equals(that.frequencyInSeconds)) return false;
                if (!messageGroups.equals(that.messageGroups)) return false;
                return this.allowInterrupt != null ? this.allowInterrupt.equals(that.allowInterrupt) : that.allowInterrupt == null;
            }

            @Override
            public final int hashCode() {
                int result = this.frequencyInSeconds.hashCode();
                result = 31 * result + (this.messageGroups.hashCode());
                result = 31 * result + (this.allowInterrupt != null ? this.allowInterrupt.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information for updating the user on the progress of fulfilling an intent.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * FulfillmentUpdatesSpecificationProperty fulfillmentUpdatesSpecificationProperty = FulfillmentUpdatesSpecificationProperty.builder()
     *         .active(false)
     *         // the properties below are optional
     *         .startResponse(FulfillmentStartResponseSpecificationProperty.builder()
     *                 .delayInSeconds(123)
     *                 .messageGroups(List.of(MessageGroupProperty.builder()
     *                         .message(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .variations(List.of(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 // the properties below are optional
     *                 .allowInterrupt(false)
     *                 .build())
     *         .timeoutInSeconds(123)
     *         .updateResponse(FulfillmentUpdateResponseSpecificationProperty.builder()
     *                 .frequencyInSeconds(123)
     *                 .messageGroups(List.of(MessageGroupProperty.builder()
     *                         .message(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .variations(List.of(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 // the properties below are optional
     *                 .allowInterrupt(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.FulfillmentUpdatesSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(FulfillmentUpdatesSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FulfillmentUpdatesSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether fulfillment updates are sent to the user. When this field is true, updates are sent.
         * <p>
         * If the active field is set to true, the <code>startResponse</code> , <code>updateResponse</code> , and <code>timeoutInSeconds</code> fields are required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getActive();

        /**
         * Provides configuration information for the message sent to users when the fulfillment Lambda functions starts running.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStartResponse() {
            return null;
        }

        /**
         * The length of time that the fulfillment Lambda function should run before it times out.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInSeconds() {
            return null;
        }

        /**
         * Provides configuration information for messages sent periodically to the user while the fulfillment Lambda function is running.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUpdateResponse() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FulfillmentUpdatesSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FulfillmentUpdatesSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FulfillmentUpdatesSpecificationProperty> {
            java.lang.Object active;
            java.lang.Object startResponse;
            java.lang.Number timeoutInSeconds;
            java.lang.Object updateResponse;

            /**
             * Sets the value of {@link FulfillmentUpdatesSpecificationProperty#getActive}
             * @param active Determines whether fulfillment updates are sent to the user. When this field is true, updates are sent. This parameter is required.
             *               If the active field is set to true, the <code>startResponse</code> , <code>updateResponse</code> , and <code>timeoutInSeconds</code> fields are required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder active(java.lang.Boolean active) {
                this.active = active;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdatesSpecificationProperty#getActive}
             * @param active Determines whether fulfillment updates are sent to the user. When this field is true, updates are sent. This parameter is required.
             *               If the active field is set to true, the <code>startResponse</code> , <code>updateResponse</code> , and <code>timeoutInSeconds</code> fields are required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder active(software.amazon.awscdk.IResolvable active) {
                this.active = active;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdatesSpecificationProperty#getStartResponse}
             * @param startResponse Provides configuration information for the message sent to users when the fulfillment Lambda functions starts running.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startResponse(software.amazon.awscdk.services.lex.CfnBot.FulfillmentStartResponseSpecificationProperty startResponse) {
                this.startResponse = startResponse;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdatesSpecificationProperty#getStartResponse}
             * @param startResponse Provides configuration information for the message sent to users when the fulfillment Lambda functions starts running.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startResponse(software.amazon.awscdk.IResolvable startResponse) {
                this.startResponse = startResponse;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdatesSpecificationProperty#getTimeoutInSeconds}
             * @param timeoutInSeconds The length of time that the fulfillment Lambda function should run before it times out.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutInSeconds(java.lang.Number timeoutInSeconds) {
                this.timeoutInSeconds = timeoutInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdatesSpecificationProperty#getUpdateResponse}
             * @param updateResponse Provides configuration information for messages sent periodically to the user while the fulfillment Lambda function is running.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateResponse(software.amazon.awscdk.services.lex.CfnBot.FulfillmentUpdateResponseSpecificationProperty updateResponse) {
                this.updateResponse = updateResponse;
                return this;
            }

            /**
             * Sets the value of {@link FulfillmentUpdatesSpecificationProperty#getUpdateResponse}
             * @param updateResponse Provides configuration information for messages sent periodically to the user while the fulfillment Lambda function is running.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateResponse(software.amazon.awscdk.IResolvable updateResponse) {
                this.updateResponse = updateResponse;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FulfillmentUpdatesSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FulfillmentUpdatesSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FulfillmentUpdatesSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FulfillmentUpdatesSpecificationProperty {
            private final java.lang.Object active;
            private final java.lang.Object startResponse;
            private final java.lang.Number timeoutInSeconds;
            private final java.lang.Object updateResponse;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.active = software.amazon.jsii.Kernel.get(this, "active", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.startResponse = software.amazon.jsii.Kernel.get(this, "startResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutInSeconds = software.amazon.jsii.Kernel.get(this, "timeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.updateResponse = software.amazon.jsii.Kernel.get(this, "updateResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.active = java.util.Objects.requireNonNull(builder.active, "active is required");
                this.startResponse = builder.startResponse;
                this.timeoutInSeconds = builder.timeoutInSeconds;
                this.updateResponse = builder.updateResponse;
            }

            @Override
            public final java.lang.Object getActive() {
                return this.active;
            }

            @Override
            public final java.lang.Object getStartResponse() {
                return this.startResponse;
            }

            @Override
            public final java.lang.Number getTimeoutInSeconds() {
                return this.timeoutInSeconds;
            }

            @Override
            public final java.lang.Object getUpdateResponse() {
                return this.updateResponse;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("active", om.valueToTree(this.getActive()));
                if (this.getStartResponse() != null) {
                    data.set("startResponse", om.valueToTree(this.getStartResponse()));
                }
                if (this.getTimeoutInSeconds() != null) {
                    data.set("timeoutInSeconds", om.valueToTree(this.getTimeoutInSeconds()));
                }
                if (this.getUpdateResponse() != null) {
                    data.set("updateResponse", om.valueToTree(this.getUpdateResponse()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.FulfillmentUpdatesSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FulfillmentUpdatesSpecificationProperty.Jsii$Proxy that = (FulfillmentUpdatesSpecificationProperty.Jsii$Proxy) o;

                if (!active.equals(that.active)) return false;
                if (this.startResponse != null ? !this.startResponse.equals(that.startResponse) : that.startResponse != null) return false;
                if (this.timeoutInSeconds != null ? !this.timeoutInSeconds.equals(that.timeoutInSeconds) : that.timeoutInSeconds != null) return false;
                return this.updateResponse != null ? this.updateResponse.equals(that.updateResponse) : that.updateResponse == null;
            }

            @Override
            public final int hashCode() {
                int result = this.active.hashCode();
                result = 31 * result + (this.startResponse != null ? this.startResponse.hashCode() : 0);
                result = 31 * result + (this.timeoutInSeconds != null ? this.timeoutInSeconds.hashCode() : 0);
                result = 31 * result + (this.updateResponse != null ? this.updateResponse.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings required for a slot type based on a grammar that you provide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * GrammarSlotTypeSettingProperty grammarSlotTypeSettingProperty = GrammarSlotTypeSettingProperty.builder()
     *         .source(GrammarSlotTypeSourceProperty.builder()
     *                 .s3BucketName("s3BucketName")
     *                 .s3ObjectKey("s3ObjectKey")
     *                 // the properties below are optional
     *                 .kmsKeyArn("kmsKeyArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.GrammarSlotTypeSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(GrammarSlotTypeSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrammarSlotTypeSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source of the grammar used to create the slot type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GrammarSlotTypeSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrammarSlotTypeSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrammarSlotTypeSettingProperty> {
            java.lang.Object source;

            /**
             * Sets the value of {@link GrammarSlotTypeSettingProperty#getSource}
             * @param source The source of the grammar used to create the slot type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.lex.CfnBot.GrammarSlotTypeSourceProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link GrammarSlotTypeSettingProperty#getSource}
             * @param source The source of the grammar used to create the slot type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrammarSlotTypeSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrammarSlotTypeSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrammarSlotTypeSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrammarSlotTypeSettingProperty {
            private final java.lang.Object source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.source = builder.source;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.GrammarSlotTypeSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrammarSlotTypeSettingProperty.Jsii$Proxy that = (GrammarSlotTypeSettingProperty.Jsii$Proxy) o;

                return this.source != null ? this.source.equals(that.source) : that.source == null;
            }

            @Override
            public final int hashCode() {
                int result = this.source != null ? this.source.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes the Amazon S3 bucket name and location for the grammar that is the source of the slot type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * GrammarSlotTypeSourceProperty grammarSlotTypeSourceProperty = GrammarSlotTypeSourceProperty.builder()
     *         .s3BucketName("s3BucketName")
     *         .s3ObjectKey("s3ObjectKey")
     *         // the properties below are optional
     *         .kmsKeyArn("kmsKeyArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.GrammarSlotTypeSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(GrammarSlotTypeSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrammarSlotTypeSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the S3 bucket that contains the grammar source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3BucketName();

        /**
         * The path to the grammar in the S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3ObjectKey();

        /**
         * The AWS Key Management Service key required to decrypt the contents of the grammar, if any.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GrammarSlotTypeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrammarSlotTypeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrammarSlotTypeSourceProperty> {
            java.lang.String s3BucketName;
            java.lang.String s3ObjectKey;
            java.lang.String kmsKeyArn;

            /**
             * Sets the value of {@link GrammarSlotTypeSourceProperty#getS3BucketName}
             * @param s3BucketName The name of the S3 bucket that contains the grammar source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketName(java.lang.String s3BucketName) {
                this.s3BucketName = s3BucketName;
                return this;
            }

            /**
             * Sets the value of {@link GrammarSlotTypeSourceProperty#getS3ObjectKey}
             * @param s3ObjectKey The path to the grammar in the S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ObjectKey(java.lang.String s3ObjectKey) {
                this.s3ObjectKey = s3ObjectKey;
                return this;
            }

            /**
             * Sets the value of {@link GrammarSlotTypeSourceProperty#getKmsKeyArn}
             * @param kmsKeyArn The AWS Key Management Service key required to decrypt the contents of the grammar, if any.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrammarSlotTypeSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrammarSlotTypeSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrammarSlotTypeSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrammarSlotTypeSourceProperty {
            private final java.lang.String s3BucketName;
            private final java.lang.String s3ObjectKey;
            private final java.lang.String kmsKeyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3BucketName = software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3ObjectKey = software.amazon.jsii.Kernel.get(this, "s3ObjectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3BucketName = java.util.Objects.requireNonNull(builder.s3BucketName, "s3BucketName is required");
                this.s3ObjectKey = java.util.Objects.requireNonNull(builder.s3ObjectKey, "s3ObjectKey is required");
                this.kmsKeyArn = builder.kmsKeyArn;
            }

            @Override
            public final java.lang.String getS3BucketName() {
                return this.s3BucketName;
            }

            @Override
            public final java.lang.String getS3ObjectKey() {
                return this.s3ObjectKey;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3BucketName", om.valueToTree(this.getS3BucketName()));
                data.set("s3ObjectKey", om.valueToTree(this.getS3ObjectKey()));
                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.GrammarSlotTypeSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrammarSlotTypeSourceProperty.Jsii$Proxy that = (GrammarSlotTypeSourceProperty.Jsii$Proxy) o;

                if (!s3BucketName.equals(that.s3BucketName)) return false;
                if (!s3ObjectKey.equals(that.s3ObjectKey)) return false;
                return this.kmsKeyArn != null ? this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3BucketName.hashCode();
                result = 31 * result + (this.s3ObjectKey.hashCode());
                result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A card that is shown to the user by a messaging platform.
     * <p>
     * You define the contents of the card, the card is displayed by the platform.
     * <p>
     * When you use a response card, the response from the user is constrained to the text associated with a button on the card.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * ImageResponseCardProperty imageResponseCardProperty = ImageResponseCardProperty.builder()
     *         .title("title")
     *         // the properties below are optional
     *         .buttons(List.of(ButtonProperty.builder()
     *                 .text("text")
     *                 .value("value")
     *                 .build()))
     *         .imageUrl("imageUrl")
     *         .subtitle("subtitle")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.ImageResponseCardProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageResponseCardProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageResponseCardProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The title to display on the response card.
         * <p>
         * The format of the title is determined by the platform displaying the response card.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTitle();

        /**
         * A list of buttons that should be displayed on the response card.
         * <p>
         * The arrangement of the buttons is determined by the platform that displays the buttons.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getButtons() {
            return null;
        }

        /**
         * The URL of an image to display on the response card.
         * <p>
         * The image URL must be publicly available so that the platform displaying the response card has access to the image.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImageUrl() {
            return null;
        }

        /**
         * The subtitle to display on the response card.
         * <p>
         * The format of the subtitle is determined by the platform displaying the response card.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubtitle() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImageResponseCardProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageResponseCardProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageResponseCardProperty> {
            java.lang.String title;
            java.lang.Object buttons;
            java.lang.String imageUrl;
            java.lang.String subtitle;

            /**
             * Sets the value of {@link ImageResponseCardProperty#getTitle}
             * @param title The title to display on the response card. This parameter is required.
             *              The format of the title is determined by the platform displaying the response card.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.lang.String title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link ImageResponseCardProperty#getButtons}
             * @param buttons A list of buttons that should be displayed on the response card.
             *                The arrangement of the buttons is determined by the platform that displays the buttons.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buttons(software.amazon.awscdk.IResolvable buttons) {
                this.buttons = buttons;
                return this;
            }

            /**
             * Sets the value of {@link ImageResponseCardProperty#getButtons}
             * @param buttons A list of buttons that should be displayed on the response card.
             *                The arrangement of the buttons is determined by the platform that displays the buttons.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder buttons(java.util.List<? extends java.lang.Object> buttons) {
                this.buttons = buttons;
                return this;
            }

            /**
             * Sets the value of {@link ImageResponseCardProperty#getImageUrl}
             * @param imageUrl The URL of an image to display on the response card.
             *                 The image URL must be publicly available so that the platform displaying the response card has access to the image.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageUrl(java.lang.String imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            /**
             * Sets the value of {@link ImageResponseCardProperty#getSubtitle}
             * @param subtitle The subtitle to display on the response card.
             *                 The format of the subtitle is determined by the platform displaying the response card.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subtitle(java.lang.String subtitle) {
                this.subtitle = subtitle;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageResponseCardProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageResponseCardProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImageResponseCardProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageResponseCardProperty {
            private final java.lang.String title;
            private final java.lang.Object buttons;
            private final java.lang.String imageUrl;
            private final java.lang.String subtitle;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.buttons = software.amazon.jsii.Kernel.get(this, "buttons", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.imageUrl = software.amazon.jsii.Kernel.get(this, "imageUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subtitle = software.amazon.jsii.Kernel.get(this, "subtitle", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.title = java.util.Objects.requireNonNull(builder.title, "title is required");
                this.buttons = builder.buttons;
                this.imageUrl = builder.imageUrl;
                this.subtitle = builder.subtitle;
            }

            @Override
            public final java.lang.String getTitle() {
                return this.title;
            }

            @Override
            public final java.lang.Object getButtons() {
                return this.buttons;
            }

            @Override
            public final java.lang.String getImageUrl() {
                return this.imageUrl;
            }

            @Override
            public final java.lang.String getSubtitle() {
                return this.subtitle;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("title", om.valueToTree(this.getTitle()));
                if (this.getButtons() != null) {
                    data.set("buttons", om.valueToTree(this.getButtons()));
                }
                if (this.getImageUrl() != null) {
                    data.set("imageUrl", om.valueToTree(this.getImageUrl()));
                }
                if (this.getSubtitle() != null) {
                    data.set("subtitle", om.valueToTree(this.getSubtitle()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.ImageResponseCardProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageResponseCardProperty.Jsii$Proxy that = (ImageResponseCardProperty.Jsii$Proxy) o;

                if (!title.equals(that.title)) return false;
                if (this.buttons != null ? !this.buttons.equals(that.buttons) : that.buttons != null) return false;
                if (this.imageUrl != null ? !this.imageUrl.equals(that.imageUrl) : that.imageUrl != null) return false;
                return this.subtitle != null ? this.subtitle.equals(that.subtitle) : that.subtitle == null;
            }

            @Override
            public final int hashCode() {
                int result = this.title.hashCode();
                result = 31 * result + (this.buttons != null ? this.buttons.hashCode() : 0);
                result = 31 * result + (this.imageUrl != null ? this.imageUrl.hashCode() : 0);
                result = 31 * result + (this.subtitle != null ? this.subtitle.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The name of a context that must be active for an intent to be selected by Amazon Lex .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * InputContextProperty inputContextProperty = InputContextProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.InputContextProperty")
    @software.amazon.jsii.Jsii.Proxy(InputContextProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputContextProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the context.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link InputContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputContextProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link InputContextProperty#getName}
             * @param name The name of the context. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputContextProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputContextProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputContextProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.InputContextProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputContextProperty.Jsii$Proxy that = (InputContextProperty.Jsii$Proxy) o;

                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                return result;
            }
        }
    }
    /**
     * Provides a statement the Amazon Lex conveys to the user when the intent is successfully fulfilled.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * IntentClosingSettingProperty intentClosingSettingProperty = IntentClosingSettingProperty.builder()
     *         .closingResponse(ResponseSpecificationProperty.builder()
     *                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                         .message(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .variations(List.of(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 // the properties below are optional
     *                 .allowInterrupt(false)
     *                 .build())
     *         // the properties below are optional
     *         .isActive(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.IntentClosingSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(IntentClosingSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntentClosingSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The response that Amazon Lex sends to the user when the intent is complete.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getClosingResponse();

        /**
         * Specifies whether an intent's closing response is used.
         * <p>
         * When this field is false, the closing response isn't sent to the user and no closing input from the user is used. If the IsActive field isn't specified, the default is true.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsActive() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntentClosingSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntentClosingSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntentClosingSettingProperty> {
            java.lang.Object closingResponse;
            java.lang.Object isActive;

            /**
             * Sets the value of {@link IntentClosingSettingProperty#getClosingResponse}
             * @param closingResponse The response that Amazon Lex sends to the user when the intent is complete. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder closingResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty closingResponse) {
                this.closingResponse = closingResponse;
                return this;
            }

            /**
             * Sets the value of {@link IntentClosingSettingProperty#getClosingResponse}
             * @param closingResponse The response that Amazon Lex sends to the user when the intent is complete. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder closingResponse(software.amazon.awscdk.IResolvable closingResponse) {
                this.closingResponse = closingResponse;
                return this;
            }

            /**
             * Sets the value of {@link IntentClosingSettingProperty#getIsActive}
             * @param isActive Specifies whether an intent's closing response is used.
             *                 When this field is false, the closing response isn't sent to the user and no closing input from the user is used. If the IsActive field isn't specified, the default is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isActive(java.lang.Boolean isActive) {
                this.isActive = isActive;
                return this;
            }

            /**
             * Sets the value of {@link IntentClosingSettingProperty#getIsActive}
             * @param isActive Specifies whether an intent's closing response is used.
             *                 When this field is false, the closing response isn't sent to the user and no closing input from the user is used. If the IsActive field isn't specified, the default is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isActive(software.amazon.awscdk.IResolvable isActive) {
                this.isActive = isActive;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntentClosingSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntentClosingSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntentClosingSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntentClosingSettingProperty {
            private final java.lang.Object closingResponse;
            private final java.lang.Object isActive;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.closingResponse = software.amazon.jsii.Kernel.get(this, "closingResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isActive = software.amazon.jsii.Kernel.get(this, "isActive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.closingResponse = java.util.Objects.requireNonNull(builder.closingResponse, "closingResponse is required");
                this.isActive = builder.isActive;
            }

            @Override
            public final java.lang.Object getClosingResponse() {
                return this.closingResponse;
            }

            @Override
            public final java.lang.Object getIsActive() {
                return this.isActive;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("closingResponse", om.valueToTree(this.getClosingResponse()));
                if (this.getIsActive() != null) {
                    data.set("isActive", om.valueToTree(this.getIsActive()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.IntentClosingSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntentClosingSettingProperty.Jsii$Proxy that = (IntentClosingSettingProperty.Jsii$Proxy) o;

                if (!closingResponse.equals(that.closingResponse)) return false;
                return this.isActive != null ? this.isActive.equals(that.isActive) : that.isActive == null;
            }

            @Override
            public final int hashCode() {
                int result = this.closingResponse.hashCode();
                result = 31 * result + (this.isActive != null ? this.isActive.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides a prompt for making sure that the user is ready for the intent to be fulfilled.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * IntentConfirmationSettingProperty intentConfirmationSettingProperty = IntentConfirmationSettingProperty.builder()
     *         .declinationResponse(ResponseSpecificationProperty.builder()
     *                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                         .message(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .variations(List.of(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 // the properties below are optional
     *                 .allowInterrupt(false)
     *                 .build())
     *         .promptSpecification(PromptSpecificationProperty.builder()
     *                 .maxRetries(123)
     *                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                         .message(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .variations(List.of(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 // the properties below are optional
     *                 .allowInterrupt(false)
     *                 .messageSelectionStrategy("messageSelectionStrategy")
     *                 .build())
     *         // the properties below are optional
     *         .isActive(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.IntentConfirmationSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(IntentConfirmationSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntentConfirmationSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When the user answers "no" to the question defined in PromptSpecification, Amazon Lex responds with this response to acknowledge that the intent was canceled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDeclinationResponse();

        /**
         * Prompts the user to confirm the intent.
         * <p>
         * This question should have a yes or no answer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPromptSpecification();

        /**
         * Specifies whether the intent's confirmation is sent to the user.
         * <p>
         * When this field is false, confirmation and declination responses aren't sent and processing continues as if the responses aren't present. If the active field isn't specified, the default is true.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsActive() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntentConfirmationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntentConfirmationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntentConfirmationSettingProperty> {
            java.lang.Object declinationResponse;
            java.lang.Object promptSpecification;
            java.lang.Object isActive;

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getDeclinationResponse}
             * @param declinationResponse When the user answers "no" to the question defined in PromptSpecification, Amazon Lex responds with this response to acknowledge that the intent was canceled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder declinationResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty declinationResponse) {
                this.declinationResponse = declinationResponse;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getDeclinationResponse}
             * @param declinationResponse When the user answers "no" to the question defined in PromptSpecification, Amazon Lex responds with this response to acknowledge that the intent was canceled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder declinationResponse(software.amazon.awscdk.IResolvable declinationResponse) {
                this.declinationResponse = declinationResponse;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getPromptSpecification}
             * @param promptSpecification Prompts the user to confirm the intent. This parameter is required.
             *                            This question should have a yes or no answer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptSpecification(software.amazon.awscdk.services.lex.CfnBot.PromptSpecificationProperty promptSpecification) {
                this.promptSpecification = promptSpecification;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getPromptSpecification}
             * @param promptSpecification Prompts the user to confirm the intent. This parameter is required.
             *                            This question should have a yes or no answer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptSpecification(software.amazon.awscdk.IResolvable promptSpecification) {
                this.promptSpecification = promptSpecification;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getIsActive}
             * @param isActive Specifies whether the intent's confirmation is sent to the user.
             *                 When this field is false, confirmation and declination responses aren't sent and processing continues as if the responses aren't present. If the active field isn't specified, the default is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isActive(java.lang.Boolean isActive) {
                this.isActive = isActive;
                return this;
            }

            /**
             * Sets the value of {@link IntentConfirmationSettingProperty#getIsActive}
             * @param isActive Specifies whether the intent's confirmation is sent to the user.
             *                 When this field is false, confirmation and declination responses aren't sent and processing continues as if the responses aren't present. If the active field isn't specified, the default is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isActive(software.amazon.awscdk.IResolvable isActive) {
                this.isActive = isActive;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntentConfirmationSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntentConfirmationSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntentConfirmationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntentConfirmationSettingProperty {
            private final java.lang.Object declinationResponse;
            private final java.lang.Object promptSpecification;
            private final java.lang.Object isActive;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.declinationResponse = software.amazon.jsii.Kernel.get(this, "declinationResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.promptSpecification = software.amazon.jsii.Kernel.get(this, "promptSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isActive = software.amazon.jsii.Kernel.get(this, "isActive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.declinationResponse = java.util.Objects.requireNonNull(builder.declinationResponse, "declinationResponse is required");
                this.promptSpecification = java.util.Objects.requireNonNull(builder.promptSpecification, "promptSpecification is required");
                this.isActive = builder.isActive;
            }

            @Override
            public final java.lang.Object getDeclinationResponse() {
                return this.declinationResponse;
            }

            @Override
            public final java.lang.Object getPromptSpecification() {
                return this.promptSpecification;
            }

            @Override
            public final java.lang.Object getIsActive() {
                return this.isActive;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("declinationResponse", om.valueToTree(this.getDeclinationResponse()));
                data.set("promptSpecification", om.valueToTree(this.getPromptSpecification()));
                if (this.getIsActive() != null) {
                    data.set("isActive", om.valueToTree(this.getIsActive()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.IntentConfirmationSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntentConfirmationSettingProperty.Jsii$Proxy that = (IntentConfirmationSettingProperty.Jsii$Proxy) o;

                if (!declinationResponse.equals(that.declinationResponse)) return false;
                if (!promptSpecification.equals(that.promptSpecification)) return false;
                return this.isActive != null ? this.isActive.equals(that.isActive) : that.isActive == null;
            }

            @Override
            public final int hashCode() {
                int result = this.declinationResponse.hashCode();
                result = 31 * result + (this.promptSpecification.hashCode());
                result = 31 * result + (this.isActive != null ? this.isActive.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents an action that the user wants to perform.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * IntentProperty intentProperty = IntentProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .description("description")
     *         .dialogCodeHook(DialogCodeHookSettingProperty.builder()
     *                 .enabled(false)
     *                 .build())
     *         .fulfillmentCodeHook(FulfillmentCodeHookSettingProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .fulfillmentUpdatesSpecification(FulfillmentUpdatesSpecificationProperty.builder()
     *                         .active(false)
     *                         // the properties below are optional
     *                         .startResponse(FulfillmentStartResponseSpecificationProperty.builder()
     *                                 .delayInSeconds(123)
     *                                 .messageGroups(List.of(MessageGroupProperty.builder()
     *                                         .message(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .variations(List.of(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build()))
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .allowInterrupt(false)
     *                                 .build())
     *                         .timeoutInSeconds(123)
     *                         .updateResponse(FulfillmentUpdateResponseSpecificationProperty.builder()
     *                                 .frequencyInSeconds(123)
     *                                 .messageGroups(List.of(MessageGroupProperty.builder()
     *                                         .message(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .variations(List.of(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build()))
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .allowInterrupt(false)
     *                                 .build())
     *                         .build())
     *                 .postFulfillmentStatusSpecification(PostFulfillmentStatusSpecificationProperty.builder()
     *                         .failureResponse(ResponseSpecificationProperty.builder()
     *                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                         .message(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .variations(List.of(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build()))
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .allowInterrupt(false)
     *                                 .build())
     *                         .successResponse(ResponseSpecificationProperty.builder()
     *                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                         .message(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .variations(List.of(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build()))
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .allowInterrupt(false)
     *                                 .build())
     *                         .timeoutResponse(ResponseSpecificationProperty.builder()
     *                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                         .message(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .variations(List.of(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build()))
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .allowInterrupt(false)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .inputContexts(List.of(InputContextProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .intentClosingSetting(IntentClosingSettingProperty.builder()
     *                 .closingResponse(ResponseSpecificationProperty.builder()
     *                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                 .message(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .variations(List.of(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build()))
     *                                 .build()))
     *                         // the properties below are optional
     *                         .allowInterrupt(false)
     *                         .build())
     *                 // the properties below are optional
     *                 .isActive(false)
     *                 .build())
     *         .intentConfirmationSetting(IntentConfirmationSettingProperty.builder()
     *                 .declinationResponse(ResponseSpecificationProperty.builder()
     *                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                 .message(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .variations(List.of(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build()))
     *                                 .build()))
     *                         // the properties below are optional
     *                         .allowInterrupt(false)
     *                         .build())
     *                 .promptSpecification(PromptSpecificationProperty.builder()
     *                         .maxRetries(123)
     *                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                 .message(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .variations(List.of(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build()))
     *                                 .build()))
     *                         // the properties below are optional
     *                         .allowInterrupt(false)
     *                         .messageSelectionStrategy("messageSelectionStrategy")
     *                         .build())
     *                 // the properties below are optional
     *                 .isActive(false)
     *                 .build())
     *         .kendraConfiguration(KendraConfigurationProperty.builder()
     *                 .kendraIndex("kendraIndex")
     *                 // the properties below are optional
     *                 .queryFilterString("queryFilterString")
     *                 .queryFilterStringEnabled(false)
     *                 .build())
     *         .outputContexts(List.of(OutputContextProperty.builder()
     *                 .name("name")
     *                 .timeToLiveInSeconds(123)
     *                 .turnsToLive(123)
     *                 .build()))
     *         .parentIntentSignature("parentIntentSignature")
     *         .sampleUtterances(List.of(SampleUtteranceProperty.builder()
     *                 .utterance("utterance")
     *                 .build()))
     *         .slotPriorities(List.of(SlotPriorityProperty.builder()
     *                 .priority(123)
     *                 .slotName("slotName")
     *                 .build()))
     *         .slots(List.of(SlotProperty.builder()
     *                 .name("name")
     *                 .slotTypeName("slotTypeName")
     *                 .valueElicitationSetting(SlotValueElicitationSettingProperty.builder()
     *                         .slotConstraint("slotConstraint")
     *                         // the properties below are optional
     *                         .defaultValueSpecification(SlotDefaultValueSpecificationProperty.builder()
     *                                 .defaultValueList(List.of(SlotDefaultValueProperty.builder()
     *                                         .defaultValue("defaultValue")
     *                                         .build()))
     *                                 .build())
     *                         .promptSpecification(PromptSpecificationProperty.builder()
     *                                 .maxRetries(123)
     *                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                         .message(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .variations(List.of(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build()))
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .allowInterrupt(false)
     *                                 .messageSelectionStrategy("messageSelectionStrategy")
     *                                 .build())
     *                         .sampleUtterances(List.of(SampleUtteranceProperty.builder()
     *                                 .utterance("utterance")
     *                                 .build()))
     *                         .waitAndContinueSpecification(WaitAndContinueSpecificationProperty.builder()
     *                                 .continueResponse(ResponseSpecificationProperty.builder()
     *                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                                 .message(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build())
     *                                                 // the properties below are optional
     *                                                 .variations(List.of(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build()))
     *                                                 .build()))
     *                                         // the properties below are optional
     *                                         .allowInterrupt(false)
     *                                         .build())
     *                                 .waitingResponse(ResponseSpecificationProperty.builder()
     *                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                                 .message(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build())
     *                                                 // the properties below are optional
     *                                                 .variations(List.of(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build()))
     *                                                 .build()))
     *                                         // the properties below are optional
     *                                         .allowInterrupt(false)
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .isActive(false)
     *                                 .stillWaitingResponse(StillWaitingResponseSpecificationProperty.builder()
     *                                         .frequencyInSeconds(123)
     *                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                                 .message(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build())
     *                                                 // the properties below are optional
     *                                                 .variations(List.of(MessageProperty.builder()
     *                                                         .customPayload(CustomPayloadProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                                 .title("title")
     *                                                                 // the properties below are optional
     *                                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                                         .text("text")
     *                                                                         .value("value")
     *                                                                         .build()))
     *                                                                 .imageUrl("imageUrl")
     *                                                                 .subtitle("subtitle")
     *                                                                 .build())
     *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build()))
     *                                                 .build()))
     *                                         .timeoutInSeconds(123)
     *                                         // the properties below are optional
     *                                         .allowInterrupt(false)
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .description("description")
     *                 .multipleValuesSetting(MultipleValuesSettingProperty.builder()
     *                         .allowMultipleValues(false)
     *                         .build())
     *                 .obfuscationSetting(ObfuscationSettingProperty.builder()
     *                         .obfuscationSettingType("obfuscationSettingType")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.IntentProperty")
    @software.amazon.jsii.Jsii.Proxy(IntentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IntentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the intent.
         * <p>
         * Intent names must be unique within the locale that contains the intent and can't match the name of any built-in intent.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * A description of the intent.
         * <p>
         * Use the description to help identify the intent in lists.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Specifies that Amazon Lex invokes the alias Lambda function for each user input.
         * <p>
         * You can invoke this Lambda function to personalize user interaction.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDialogCodeHook() {
            return null;
        }

        /**
         * Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment.
         * <p>
         * You can invoke this function to complete the bot's transaction with the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFulfillmentCodeHook() {
            return null;
        }

        /**
         * A list of contexts that must be active for this intent to be considered by Amazon Lex .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputContexts() {
            return null;
        }

        /**
         * Sets the response that Amazon Lex sends to the user when the intent is closed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntentClosingSetting() {
            return null;
        }

        /**
         * Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent.
         * <p>
         * If the user answers "no," the settings contain a statement that is sent to the user to end the intent.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntentConfirmationSetting() {
            return null;
        }

        /**
         * Configuration information required to use the AMAZON.KendraSearchIntent intent to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent is called with Amazon Lex can't determine another intent to invoke.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKendraConfiguration() {
            return null;
        }

        /**
         * A list of contexts that the intent activates when it is fulfilled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputContexts() {
            return null;
        }

        /**
         * A unique identifier for the built-in intent to base this intent on.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParentIntentSignature() {
            return null;
        }

        /**
         * A list of utterances that a user might say to signal the intent.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSampleUtterances() {
            return null;
        }

        /**
         * Indicates the priority for slots.
         * <p>
         * Amazon Lex prompts the user for slot values in priority order.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSlotPriorities() {
            return null;
        }

        /**
         * A list of slots that the intent requires for fulfillment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSlots() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IntentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IntentProperty> {
            java.lang.String name;
            java.lang.String description;
            java.lang.Object dialogCodeHook;
            java.lang.Object fulfillmentCodeHook;
            java.lang.Object inputContexts;
            java.lang.Object intentClosingSetting;
            java.lang.Object intentConfirmationSetting;
            java.lang.Object kendraConfiguration;
            java.lang.Object outputContexts;
            java.lang.String parentIntentSignature;
            java.lang.Object sampleUtterances;
            java.lang.Object slotPriorities;
            java.lang.Object slots;

            /**
             * Sets the value of {@link IntentProperty#getName}
             * @param name The name of the intent. This parameter is required.
             *             Intent names must be unique within the locale that contains the intent and can't match the name of any built-in intent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getDescription}
             * @param description A description of the intent.
             *                    Use the description to help identify the intent in lists.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getDialogCodeHook}
             * @param dialogCodeHook Specifies that Amazon Lex invokes the alias Lambda function for each user input.
             *                       You can invoke this Lambda function to personalize user interaction.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dialogCodeHook(software.amazon.awscdk.services.lex.CfnBot.DialogCodeHookSettingProperty dialogCodeHook) {
                this.dialogCodeHook = dialogCodeHook;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getDialogCodeHook}
             * @param dialogCodeHook Specifies that Amazon Lex invokes the alias Lambda function for each user input.
             *                       You can invoke this Lambda function to personalize user interaction.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dialogCodeHook(software.amazon.awscdk.IResolvable dialogCodeHook) {
                this.dialogCodeHook = dialogCodeHook;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getFulfillmentCodeHook}
             * @param fulfillmentCodeHook Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment.
             *                            You can invoke this function to complete the bot's transaction with the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fulfillmentCodeHook(software.amazon.awscdk.services.lex.CfnBot.FulfillmentCodeHookSettingProperty fulfillmentCodeHook) {
                this.fulfillmentCodeHook = fulfillmentCodeHook;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getFulfillmentCodeHook}
             * @param fulfillmentCodeHook Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment.
             *                            You can invoke this function to complete the bot's transaction with the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fulfillmentCodeHook(software.amazon.awscdk.IResolvable fulfillmentCodeHook) {
                this.fulfillmentCodeHook = fulfillmentCodeHook;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getInputContexts}
             * @param inputContexts A list of contexts that must be active for this intent to be considered by Amazon Lex .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputContexts(software.amazon.awscdk.IResolvable inputContexts) {
                this.inputContexts = inputContexts;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getInputContexts}
             * @param inputContexts A list of contexts that must be active for this intent to be considered by Amazon Lex .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputContexts(java.util.List<? extends java.lang.Object> inputContexts) {
                this.inputContexts = inputContexts;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getIntentClosingSetting}
             * @param intentClosingSetting Sets the response that Amazon Lex sends to the user when the intent is closed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intentClosingSetting(software.amazon.awscdk.services.lex.CfnBot.IntentClosingSettingProperty intentClosingSetting) {
                this.intentClosingSetting = intentClosingSetting;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getIntentClosingSetting}
             * @param intentClosingSetting Sets the response that Amazon Lex sends to the user when the intent is closed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intentClosingSetting(software.amazon.awscdk.IResolvable intentClosingSetting) {
                this.intentClosingSetting = intentClosingSetting;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getIntentConfirmationSetting}
             * @param intentConfirmationSetting Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent.
             *                                  If the user answers "no," the settings contain a statement that is sent to the user to end the intent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intentConfirmationSetting(software.amazon.awscdk.services.lex.CfnBot.IntentConfirmationSettingProperty intentConfirmationSetting) {
                this.intentConfirmationSetting = intentConfirmationSetting;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getIntentConfirmationSetting}
             * @param intentConfirmationSetting Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent.
             *                                  If the user answers "no," the settings contain a statement that is sent to the user to end the intent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intentConfirmationSetting(software.amazon.awscdk.IResolvable intentConfirmationSetting) {
                this.intentConfirmationSetting = intentConfirmationSetting;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getKendraConfiguration}
             * @param kendraConfiguration Configuration information required to use the AMAZON.KendraSearchIntent intent to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent is called with Amazon Lex can't determine another intent to invoke.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kendraConfiguration(software.amazon.awscdk.services.lex.CfnBot.KendraConfigurationProperty kendraConfiguration) {
                this.kendraConfiguration = kendraConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getKendraConfiguration}
             * @param kendraConfiguration Configuration information required to use the AMAZON.KendraSearchIntent intent to connect to an Amazon Kendra index. The AMAZON.KendraSearchIntent intent is called with Amazon Lex can't determine another intent to invoke.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kendraConfiguration(software.amazon.awscdk.IResolvable kendraConfiguration) {
                this.kendraConfiguration = kendraConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getOutputContexts}
             * @param outputContexts A list of contexts that the intent activates when it is fulfilled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputContexts(software.amazon.awscdk.IResolvable outputContexts) {
                this.outputContexts = outputContexts;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getOutputContexts}
             * @param outputContexts A list of contexts that the intent activates when it is fulfilled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputContexts(java.util.List<? extends java.lang.Object> outputContexts) {
                this.outputContexts = outputContexts;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getParentIntentSignature}
             * @param parentIntentSignature A unique identifier for the built-in intent to base this intent on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parentIntentSignature(java.lang.String parentIntentSignature) {
                this.parentIntentSignature = parentIntentSignature;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getSampleUtterances}
             * @param sampleUtterances A list of utterances that a user might say to signal the intent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleUtterances(software.amazon.awscdk.IResolvable sampleUtterances) {
                this.sampleUtterances = sampleUtterances;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getSampleUtterances}
             * @param sampleUtterances A list of utterances that a user might say to signal the intent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleUtterances(java.util.List<? extends java.lang.Object> sampleUtterances) {
                this.sampleUtterances = sampleUtterances;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getSlotPriorities}
             * @param slotPriorities Indicates the priority for slots.
             *                       Amazon Lex prompts the user for slot values in priority order.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotPriorities(software.amazon.awscdk.IResolvable slotPriorities) {
                this.slotPriorities = slotPriorities;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getSlotPriorities}
             * @param slotPriorities Indicates the priority for slots.
             *                       Amazon Lex prompts the user for slot values in priority order.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotPriorities(java.util.List<? extends java.lang.Object> slotPriorities) {
                this.slotPriorities = slotPriorities;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getSlots}
             * @param slots A list of slots that the intent requires for fulfillment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slots(software.amazon.awscdk.IResolvable slots) {
                this.slots = slots;
                return this;
            }

            /**
             * Sets the value of {@link IntentProperty#getSlots}
             * @param slots A list of slots that the intent requires for fulfillment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slots(java.util.List<? extends java.lang.Object> slots) {
                this.slots = slots;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IntentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IntentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntentProperty {
            private final java.lang.String name;
            private final java.lang.String description;
            private final java.lang.Object dialogCodeHook;
            private final java.lang.Object fulfillmentCodeHook;
            private final java.lang.Object inputContexts;
            private final java.lang.Object intentClosingSetting;
            private final java.lang.Object intentConfirmationSetting;
            private final java.lang.Object kendraConfiguration;
            private final java.lang.Object outputContexts;
            private final java.lang.String parentIntentSignature;
            private final java.lang.Object sampleUtterances;
            private final java.lang.Object slotPriorities;
            private final java.lang.Object slots;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dialogCodeHook = software.amazon.jsii.Kernel.get(this, "dialogCodeHook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fulfillmentCodeHook = software.amazon.jsii.Kernel.get(this, "fulfillmentCodeHook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputContexts = software.amazon.jsii.Kernel.get(this, "inputContexts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.intentClosingSetting = software.amazon.jsii.Kernel.get(this, "intentClosingSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.intentConfirmationSetting = software.amazon.jsii.Kernel.get(this, "intentConfirmationSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kendraConfiguration = software.amazon.jsii.Kernel.get(this, "kendraConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputContexts = software.amazon.jsii.Kernel.get(this, "outputContexts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parentIntentSignature = software.amazon.jsii.Kernel.get(this, "parentIntentSignature", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sampleUtterances = software.amazon.jsii.Kernel.get(this, "sampleUtterances", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.slotPriorities = software.amazon.jsii.Kernel.get(this, "slotPriorities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.slots = software.amazon.jsii.Kernel.get(this, "slots", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.description = builder.description;
                this.dialogCodeHook = builder.dialogCodeHook;
                this.fulfillmentCodeHook = builder.fulfillmentCodeHook;
                this.inputContexts = builder.inputContexts;
                this.intentClosingSetting = builder.intentClosingSetting;
                this.intentConfirmationSetting = builder.intentConfirmationSetting;
                this.kendraConfiguration = builder.kendraConfiguration;
                this.outputContexts = builder.outputContexts;
                this.parentIntentSignature = builder.parentIntentSignature;
                this.sampleUtterances = builder.sampleUtterances;
                this.slotPriorities = builder.slotPriorities;
                this.slots = builder.slots;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getDialogCodeHook() {
                return this.dialogCodeHook;
            }

            @Override
            public final java.lang.Object getFulfillmentCodeHook() {
                return this.fulfillmentCodeHook;
            }

            @Override
            public final java.lang.Object getInputContexts() {
                return this.inputContexts;
            }

            @Override
            public final java.lang.Object getIntentClosingSetting() {
                return this.intentClosingSetting;
            }

            @Override
            public final java.lang.Object getIntentConfirmationSetting() {
                return this.intentConfirmationSetting;
            }

            @Override
            public final java.lang.Object getKendraConfiguration() {
                return this.kendraConfiguration;
            }

            @Override
            public final java.lang.Object getOutputContexts() {
                return this.outputContexts;
            }

            @Override
            public final java.lang.String getParentIntentSignature() {
                return this.parentIntentSignature;
            }

            @Override
            public final java.lang.Object getSampleUtterances() {
                return this.sampleUtterances;
            }

            @Override
            public final java.lang.Object getSlotPriorities() {
                return this.slotPriorities;
            }

            @Override
            public final java.lang.Object getSlots() {
                return this.slots;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getDialogCodeHook() != null) {
                    data.set("dialogCodeHook", om.valueToTree(this.getDialogCodeHook()));
                }
                if (this.getFulfillmentCodeHook() != null) {
                    data.set("fulfillmentCodeHook", om.valueToTree(this.getFulfillmentCodeHook()));
                }
                if (this.getInputContexts() != null) {
                    data.set("inputContexts", om.valueToTree(this.getInputContexts()));
                }
                if (this.getIntentClosingSetting() != null) {
                    data.set("intentClosingSetting", om.valueToTree(this.getIntentClosingSetting()));
                }
                if (this.getIntentConfirmationSetting() != null) {
                    data.set("intentConfirmationSetting", om.valueToTree(this.getIntentConfirmationSetting()));
                }
                if (this.getKendraConfiguration() != null) {
                    data.set("kendraConfiguration", om.valueToTree(this.getKendraConfiguration()));
                }
                if (this.getOutputContexts() != null) {
                    data.set("outputContexts", om.valueToTree(this.getOutputContexts()));
                }
                if (this.getParentIntentSignature() != null) {
                    data.set("parentIntentSignature", om.valueToTree(this.getParentIntentSignature()));
                }
                if (this.getSampleUtterances() != null) {
                    data.set("sampleUtterances", om.valueToTree(this.getSampleUtterances()));
                }
                if (this.getSlotPriorities() != null) {
                    data.set("slotPriorities", om.valueToTree(this.getSlotPriorities()));
                }
                if (this.getSlots() != null) {
                    data.set("slots", om.valueToTree(this.getSlots()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.IntentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntentProperty.Jsii$Proxy that = (IntentProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.dialogCodeHook != null ? !this.dialogCodeHook.equals(that.dialogCodeHook) : that.dialogCodeHook != null) return false;
                if (this.fulfillmentCodeHook != null ? !this.fulfillmentCodeHook.equals(that.fulfillmentCodeHook) : that.fulfillmentCodeHook != null) return false;
                if (this.inputContexts != null ? !this.inputContexts.equals(that.inputContexts) : that.inputContexts != null) return false;
                if (this.intentClosingSetting != null ? !this.intentClosingSetting.equals(that.intentClosingSetting) : that.intentClosingSetting != null) return false;
                if (this.intentConfirmationSetting != null ? !this.intentConfirmationSetting.equals(that.intentConfirmationSetting) : that.intentConfirmationSetting != null) return false;
                if (this.kendraConfiguration != null ? !this.kendraConfiguration.equals(that.kendraConfiguration) : that.kendraConfiguration != null) return false;
                if (this.outputContexts != null ? !this.outputContexts.equals(that.outputContexts) : that.outputContexts != null) return false;
                if (this.parentIntentSignature != null ? !this.parentIntentSignature.equals(that.parentIntentSignature) : that.parentIntentSignature != null) return false;
                if (this.sampleUtterances != null ? !this.sampleUtterances.equals(that.sampleUtterances) : that.sampleUtterances != null) return false;
                if (this.slotPriorities != null ? !this.slotPriorities.equals(that.slotPriorities) : that.slotPriorities != null) return false;
                return this.slots != null ? this.slots.equals(that.slots) : that.slots == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.dialogCodeHook != null ? this.dialogCodeHook.hashCode() : 0);
                result = 31 * result + (this.fulfillmentCodeHook != null ? this.fulfillmentCodeHook.hashCode() : 0);
                result = 31 * result + (this.inputContexts != null ? this.inputContexts.hashCode() : 0);
                result = 31 * result + (this.intentClosingSetting != null ? this.intentClosingSetting.hashCode() : 0);
                result = 31 * result + (this.intentConfirmationSetting != null ? this.intentConfirmationSetting.hashCode() : 0);
                result = 31 * result + (this.kendraConfiguration != null ? this.kendraConfiguration.hashCode() : 0);
                result = 31 * result + (this.outputContexts != null ? this.outputContexts.hashCode() : 0);
                result = 31 * result + (this.parentIntentSignature != null ? this.parentIntentSignature.hashCode() : 0);
                result = 31 * result + (this.sampleUtterances != null ? this.sampleUtterances.hashCode() : 0);
                result = 31 * result + (this.slotPriorities != null ? this.slotPriorities.hashCode() : 0);
                result = 31 * result + (this.slots != null ? this.slots.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides configuration information for the AMAZON.KendraSearchIntent intent. When you use this intent, Amazon Lex searches the specified Amazon Kendra index and returns documents from the index that match the user's utterance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * KendraConfigurationProperty kendraConfigurationProperty = KendraConfigurationProperty.builder()
     *         .kendraIndex("kendraIndex")
     *         // the properties below are optional
     *         .queryFilterString("queryFilterString")
     *         .queryFilterStringEnabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.KendraConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(KendraConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KendraConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the AMAZON.KendraSearchIntent intent to search. The index must be in the same account and Region as the Amazon Lex bot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKendraIndex();

        /**
         * A query filter that Amazon Lex sends to Amazon Kendra to filter the response from a query.
         * <p>
         * The filter is in the format defined by Amazon Kendra.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getQueryFilterString() {
            return null;
        }

        /**
         * Determines whether the AMAZON.KendraSearchIntent intent uses a custom query string to query the Amazon Kendra index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryFilterStringEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KendraConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KendraConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KendraConfigurationProperty> {
            java.lang.String kendraIndex;
            java.lang.String queryFilterString;
            java.lang.Object queryFilterStringEnabled;

            /**
             * Sets the value of {@link KendraConfigurationProperty#getKendraIndex}
             * @param kendraIndex The Amazon Resource Name (ARN) of the Amazon Kendra index that you want the AMAZON.KendraSearchIntent intent to search. The index must be in the same account and Region as the Amazon Lex bot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kendraIndex(java.lang.String kendraIndex) {
                this.kendraIndex = kendraIndex;
                return this;
            }

            /**
             * Sets the value of {@link KendraConfigurationProperty#getQueryFilterString}
             * @param queryFilterString A query filter that Amazon Lex sends to Amazon Kendra to filter the response from a query.
             *                          The filter is in the format defined by Amazon Kendra.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryFilterString(java.lang.String queryFilterString) {
                this.queryFilterString = queryFilterString;
                return this;
            }

            /**
             * Sets the value of {@link KendraConfigurationProperty#getQueryFilterStringEnabled}
             * @param queryFilterStringEnabled Determines whether the AMAZON.KendraSearchIntent intent uses a custom query string to query the Amazon Kendra index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryFilterStringEnabled(java.lang.Boolean queryFilterStringEnabled) {
                this.queryFilterStringEnabled = queryFilterStringEnabled;
                return this;
            }

            /**
             * Sets the value of {@link KendraConfigurationProperty#getQueryFilterStringEnabled}
             * @param queryFilterStringEnabled Determines whether the AMAZON.KendraSearchIntent intent uses a custom query string to query the Amazon Kendra index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryFilterStringEnabled(software.amazon.awscdk.IResolvable queryFilterStringEnabled) {
                this.queryFilterStringEnabled = queryFilterStringEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KendraConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KendraConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KendraConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KendraConfigurationProperty {
            private final java.lang.String kendraIndex;
            private final java.lang.String queryFilterString;
            private final java.lang.Object queryFilterStringEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kendraIndex = software.amazon.jsii.Kernel.get(this, "kendraIndex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queryFilterString = software.amazon.jsii.Kernel.get(this, "queryFilterString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queryFilterStringEnabled = software.amazon.jsii.Kernel.get(this, "queryFilterStringEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kendraIndex = java.util.Objects.requireNonNull(builder.kendraIndex, "kendraIndex is required");
                this.queryFilterString = builder.queryFilterString;
                this.queryFilterStringEnabled = builder.queryFilterStringEnabled;
            }

            @Override
            public final java.lang.String getKendraIndex() {
                return this.kendraIndex;
            }

            @Override
            public final java.lang.String getQueryFilterString() {
                return this.queryFilterString;
            }

            @Override
            public final java.lang.Object getQueryFilterStringEnabled() {
                return this.queryFilterStringEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("kendraIndex", om.valueToTree(this.getKendraIndex()));
                if (this.getQueryFilterString() != null) {
                    data.set("queryFilterString", om.valueToTree(this.getQueryFilterString()));
                }
                if (this.getQueryFilterStringEnabled() != null) {
                    data.set("queryFilterStringEnabled", om.valueToTree(this.getQueryFilterStringEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.KendraConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KendraConfigurationProperty.Jsii$Proxy that = (KendraConfigurationProperty.Jsii$Proxy) o;

                if (!kendraIndex.equals(that.kendraIndex)) return false;
                if (this.queryFilterString != null ? !this.queryFilterString.equals(that.queryFilterString) : that.queryFilterString != null) return false;
                return this.queryFilterStringEnabled != null ? this.queryFilterStringEnabled.equals(that.queryFilterStringEnabled) : that.queryFilterStringEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kendraIndex.hashCode();
                result = 31 * result + (this.queryFilterString != null ? this.queryFilterString.hashCode() : 0);
                result = 31 * result + (this.queryFilterStringEnabled != null ? this.queryFilterStringEnabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a Lambda function that verifies requests to a bot or fulfills the user's request to a bot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * LambdaCodeHookProperty lambdaCodeHookProperty = LambdaCodeHookProperty.builder()
     *         .codeHookInterfaceVersion("codeHookInterfaceVersion")
     *         .lambdaArn("lambdaArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.LambdaCodeHookProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaCodeHookProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaCodeHookProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the version of the request-response that you want Amazon Lex to use to invoke your Lambda function.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCodeHookInterfaceVersion();

        /**
         * Specifies the Amazon Resource Name (ARN) of the Lambda function.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLambdaArn();

        /**
         * @return a {@link Builder} of {@link LambdaCodeHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaCodeHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaCodeHookProperty> {
            java.lang.String codeHookInterfaceVersion;
            java.lang.String lambdaArn;

            /**
             * Sets the value of {@link LambdaCodeHookProperty#getCodeHookInterfaceVersion}
             * @param codeHookInterfaceVersion Specifies the version of the request-response that you want Amazon Lex to use to invoke your Lambda function. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeHookInterfaceVersion(java.lang.String codeHookInterfaceVersion) {
                this.codeHookInterfaceVersion = codeHookInterfaceVersion;
                return this;
            }

            /**
             * Sets the value of {@link LambdaCodeHookProperty#getLambdaArn}
             * @param lambdaArn Specifies the Amazon Resource Name (ARN) of the Lambda function. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaArn(java.lang.String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaCodeHookProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaCodeHookProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaCodeHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaCodeHookProperty {
            private final java.lang.String codeHookInterfaceVersion;
            private final java.lang.String lambdaArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.codeHookInterfaceVersion = software.amazon.jsii.Kernel.get(this, "codeHookInterfaceVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lambdaArn = software.amazon.jsii.Kernel.get(this, "lambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.codeHookInterfaceVersion = java.util.Objects.requireNonNull(builder.codeHookInterfaceVersion, "codeHookInterfaceVersion is required");
                this.lambdaArn = java.util.Objects.requireNonNull(builder.lambdaArn, "lambdaArn is required");
            }

            @Override
            public final java.lang.String getCodeHookInterfaceVersion() {
                return this.codeHookInterfaceVersion;
            }

            @Override
            public final java.lang.String getLambdaArn() {
                return this.lambdaArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("codeHookInterfaceVersion", om.valueToTree(this.getCodeHookInterfaceVersion()));
                data.set("lambdaArn", om.valueToTree(this.getLambdaArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.LambdaCodeHookProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaCodeHookProperty.Jsii$Proxy that = (LambdaCodeHookProperty.Jsii$Proxy) o;

                if (!codeHookInterfaceVersion.equals(that.codeHookInterfaceVersion)) return false;
                return this.lambdaArn.equals(that.lambdaArn);
            }

            @Override
            public final int hashCode() {
                int result = this.codeHookInterfaceVersion.hashCode();
                result = 31 * result + (this.lambdaArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Provides one or more messages that Amazon Lex should send to the user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * MessageGroupProperty messageGroupProperty = MessageGroupProperty.builder()
     *         .message(MessageProperty.builder()
     *                 .customPayload(CustomPayloadProperty.builder()
     *                         .value("value")
     *                         .build())
     *                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                         .title("title")
     *                         // the properties below are optional
     *                         .buttons(List.of(ButtonProperty.builder()
     *                                 .text("text")
     *                                 .value("value")
     *                                 .build()))
     *                         .imageUrl("imageUrl")
     *                         .subtitle("subtitle")
     *                         .build())
     *                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                         .value("value")
     *                         .build())
     *                 .ssmlMessage(SSMLMessageProperty.builder()
     *                         .value("value")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .variations(List.of(MessageProperty.builder()
     *                 .customPayload(CustomPayloadProperty.builder()
     *                         .value("value")
     *                         .build())
     *                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                         .title("title")
     *                         // the properties below are optional
     *                         .buttons(List.of(ButtonProperty.builder()
     *                                 .text("text")
     *                                 .value("value")
     *                                 .build()))
     *                         .imageUrl("imageUrl")
     *                         .subtitle("subtitle")
     *                         .build())
     *                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                         .value("value")
     *                         .build())
     *                 .ssmlMessage(SSMLMessageProperty.builder()
     *                         .value("value")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.MessageGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(MessageGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MessageGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The primary message that Amazon Lex should send to the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMessage();

        /**
         * Message variations to send to the user.
         * <p>
         * When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVariations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MessageGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MessageGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MessageGroupProperty> {
            java.lang.Object message;
            java.lang.Object variations;

            /**
             * Sets the value of {@link MessageGroupProperty#getMessage}
             * @param message The primary message that Amazon Lex should send to the user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder message(software.amazon.awscdk.services.lex.CfnBot.MessageProperty message) {
                this.message = message;
                return this;
            }

            /**
             * Sets the value of {@link MessageGroupProperty#getMessage}
             * @param message The primary message that Amazon Lex should send to the user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder message(software.amazon.awscdk.IResolvable message) {
                this.message = message;
                return this;
            }

            /**
             * Sets the value of {@link MessageGroupProperty#getVariations}
             * @param variations Message variations to send to the user.
             *                   When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variations(software.amazon.awscdk.IResolvable variations) {
                this.variations = variations;
                return this;
            }

            /**
             * Sets the value of {@link MessageGroupProperty#getVariations}
             * @param variations Message variations to send to the user.
             *                   When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variations(java.util.List<? extends java.lang.Object> variations) {
                this.variations = variations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MessageGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MessageGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MessageGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MessageGroupProperty {
            private final java.lang.Object message;
            private final java.lang.Object variations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.variations = software.amazon.jsii.Kernel.get(this, "variations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.message = java.util.Objects.requireNonNull(builder.message, "message is required");
                this.variations = builder.variations;
            }

            @Override
            public final java.lang.Object getMessage() {
                return this.message;
            }

            @Override
            public final java.lang.Object getVariations() {
                return this.variations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("message", om.valueToTree(this.getMessage()));
                if (this.getVariations() != null) {
                    data.set("variations", om.valueToTree(this.getVariations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.MessageGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MessageGroupProperty.Jsii$Proxy that = (MessageGroupProperty.Jsii$Proxy) o;

                if (!message.equals(that.message)) return false;
                return this.variations != null ? this.variations.equals(that.variations) : that.variations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.message.hashCode();
                result = 31 * result + (this.variations != null ? this.variations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The object that provides message text and it's type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * MessageProperty messageProperty = MessageProperty.builder()
     *         .customPayload(CustomPayloadProperty.builder()
     *                 .value("value")
     *                 .build())
     *         .imageResponseCard(ImageResponseCardProperty.builder()
     *                 .title("title")
     *                 // the properties below are optional
     *                 .buttons(List.of(ButtonProperty.builder()
     *                         .text("text")
     *                         .value("value")
     *                         .build()))
     *                 .imageUrl("imageUrl")
     *                 .subtitle("subtitle")
     *                 .build())
     *         .plainTextMessage(PlainTextMessageProperty.builder()
     *                 .value("value")
     *                 .build())
     *         .ssmlMessage(SSMLMessageProperty.builder()
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.MessageProperty")
    @software.amazon.jsii.Jsii.Proxy(MessageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MessageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A message in a custom format defined by the client application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomPayload() {
            return null;
        }

        /**
         * A message that defines a response card that the client application can show to the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImageResponseCard() {
            return null;
        }

        /**
         * A message in plain text format.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlainTextMessage() {
            return null;
        }

        /**
         * A message in Speech Synthesis Markup Language (SSML) format.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSsmlMessage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MessageProperty> {
            java.lang.Object customPayload;
            java.lang.Object imageResponseCard;
            java.lang.Object plainTextMessage;
            java.lang.Object ssmlMessage;

            /**
             * Sets the value of {@link MessageProperty#getCustomPayload}
             * @param customPayload A message in a custom format defined by the client application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPayload(software.amazon.awscdk.services.lex.CfnBot.CustomPayloadProperty customPayload) {
                this.customPayload = customPayload;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getCustomPayload}
             * @param customPayload A message in a custom format defined by the client application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPayload(software.amazon.awscdk.IResolvable customPayload) {
                this.customPayload = customPayload;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getImageResponseCard}
             * @param imageResponseCard A message that defines a response card that the client application can show to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageResponseCard(software.amazon.awscdk.services.lex.CfnBot.ImageResponseCardProperty imageResponseCard) {
                this.imageResponseCard = imageResponseCard;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getImageResponseCard}
             * @param imageResponseCard A message that defines a response card that the client application can show to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageResponseCard(software.amazon.awscdk.IResolvable imageResponseCard) {
                this.imageResponseCard = imageResponseCard;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getPlainTextMessage}
             * @param plainTextMessage A message in plain text format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder plainTextMessage(software.amazon.awscdk.services.lex.CfnBot.PlainTextMessageProperty plainTextMessage) {
                this.plainTextMessage = plainTextMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getPlainTextMessage}
             * @param plainTextMessage A message in plain text format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder plainTextMessage(software.amazon.awscdk.IResolvable plainTextMessage) {
                this.plainTextMessage = plainTextMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getSsmlMessage}
             * @param ssmlMessage A message in Speech Synthesis Markup Language (SSML) format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ssmlMessage(software.amazon.awscdk.services.lex.CfnBot.SSMLMessageProperty ssmlMessage) {
                this.ssmlMessage = ssmlMessage;
                return this;
            }

            /**
             * Sets the value of {@link MessageProperty#getSsmlMessage}
             * @param ssmlMessage A message in Speech Synthesis Markup Language (SSML) format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ssmlMessage(software.amazon.awscdk.IResolvable ssmlMessage) {
                this.ssmlMessage = ssmlMessage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MessageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MessageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MessageProperty {
            private final java.lang.Object customPayload;
            private final java.lang.Object imageResponseCard;
            private final java.lang.Object plainTextMessage;
            private final java.lang.Object ssmlMessage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customPayload = software.amazon.jsii.Kernel.get(this, "customPayload", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.imageResponseCard = software.amazon.jsii.Kernel.get(this, "imageResponseCard", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.plainTextMessage = software.amazon.jsii.Kernel.get(this, "plainTextMessage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ssmlMessage = software.amazon.jsii.Kernel.get(this, "ssmlMessage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customPayload = builder.customPayload;
                this.imageResponseCard = builder.imageResponseCard;
                this.plainTextMessage = builder.plainTextMessage;
                this.ssmlMessage = builder.ssmlMessage;
            }

            @Override
            public final java.lang.Object getCustomPayload() {
                return this.customPayload;
            }

            @Override
            public final java.lang.Object getImageResponseCard() {
                return this.imageResponseCard;
            }

            @Override
            public final java.lang.Object getPlainTextMessage() {
                return this.plainTextMessage;
            }

            @Override
            public final java.lang.Object getSsmlMessage() {
                return this.ssmlMessage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomPayload() != null) {
                    data.set("customPayload", om.valueToTree(this.getCustomPayload()));
                }
                if (this.getImageResponseCard() != null) {
                    data.set("imageResponseCard", om.valueToTree(this.getImageResponseCard()));
                }
                if (this.getPlainTextMessage() != null) {
                    data.set("plainTextMessage", om.valueToTree(this.getPlainTextMessage()));
                }
                if (this.getSsmlMessage() != null) {
                    data.set("ssmlMessage", om.valueToTree(this.getSsmlMessage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.MessageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MessageProperty.Jsii$Proxy that = (MessageProperty.Jsii$Proxy) o;

                if (this.customPayload != null ? !this.customPayload.equals(that.customPayload) : that.customPayload != null) return false;
                if (this.imageResponseCard != null ? !this.imageResponseCard.equals(that.imageResponseCard) : that.imageResponseCard != null) return false;
                if (this.plainTextMessage != null ? !this.plainTextMessage.equals(that.plainTextMessage) : that.plainTextMessage != null) return false;
                return this.ssmlMessage != null ? this.ssmlMessage.equals(that.ssmlMessage) : that.ssmlMessage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customPayload != null ? this.customPayload.hashCode() : 0;
                result = 31 * result + (this.imageResponseCard != null ? this.imageResponseCard.hashCode() : 0);
                result = 31 * result + (this.plainTextMessage != null ? this.plainTextMessage.hashCode() : 0);
                result = 31 * result + (this.ssmlMessage != null ? this.ssmlMessage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Indicates whether a slot can return multiple values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * MultipleValuesSettingProperty multipleValuesSettingProperty = MultipleValuesSettingProperty.builder()
     *         .allowMultipleValues(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.MultipleValuesSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(MultipleValuesSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MultipleValuesSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether a slot can return multiple values.
         * <p>
         * When true, the slot may return more than one value in a response. When false, the slot returns only a single value. If AllowMultipleValues is not set, the default value is false.
         * <p>
         * Multi-value slots are only available in the en-US locale.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowMultipleValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MultipleValuesSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MultipleValuesSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MultipleValuesSettingProperty> {
            java.lang.Object allowMultipleValues;

            /**
             * Sets the value of {@link MultipleValuesSettingProperty#getAllowMultipleValues}
             * @param allowMultipleValues Indicates whether a slot can return multiple values.
             *                            When true, the slot may return more than one value in a response. When false, the slot returns only a single value. If AllowMultipleValues is not set, the default value is false.
             *                            <p>
             *                            Multi-value slots are only available in the en-US locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowMultipleValues(java.lang.Boolean allowMultipleValues) {
                this.allowMultipleValues = allowMultipleValues;
                return this;
            }

            /**
             * Sets the value of {@link MultipleValuesSettingProperty#getAllowMultipleValues}
             * @param allowMultipleValues Indicates whether a slot can return multiple values.
             *                            When true, the slot may return more than one value in a response. When false, the slot returns only a single value. If AllowMultipleValues is not set, the default value is false.
             *                            <p>
             *                            Multi-value slots are only available in the en-US locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowMultipleValues(software.amazon.awscdk.IResolvable allowMultipleValues) {
                this.allowMultipleValues = allowMultipleValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MultipleValuesSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MultipleValuesSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MultipleValuesSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultipleValuesSettingProperty {
            private final java.lang.Object allowMultipleValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowMultipleValues = software.amazon.jsii.Kernel.get(this, "allowMultipleValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowMultipleValues = builder.allowMultipleValues;
            }

            @Override
            public final java.lang.Object getAllowMultipleValues() {
                return this.allowMultipleValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowMultipleValues() != null) {
                    data.set("allowMultipleValues", om.valueToTree(this.getAllowMultipleValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.MultipleValuesSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MultipleValuesSettingProperty.Jsii$Proxy that = (MultipleValuesSettingProperty.Jsii$Proxy) o;

                return this.allowMultipleValues != null ? this.allowMultipleValues.equals(that.allowMultipleValues) : that.allowMultipleValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowMultipleValues != null ? this.allowMultipleValues.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Determines whether Amazon Lex obscures slot values in conversation logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * ObfuscationSettingProperty obfuscationSettingProperty = ObfuscationSettingProperty.builder()
     *         .obfuscationSettingType("obfuscationSettingType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.ObfuscationSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(ObfuscationSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ObfuscationSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Value that determines whether Amazon Lex obscures slot values in conversation logs.
         * <p>
         * The default is to obscure the values.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObfuscationSettingType();

        /**
         * @return a {@link Builder} of {@link ObfuscationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ObfuscationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ObfuscationSettingProperty> {
            java.lang.String obfuscationSettingType;

            /**
             * Sets the value of {@link ObfuscationSettingProperty#getObfuscationSettingType}
             * @param obfuscationSettingType Value that determines whether Amazon Lex obscures slot values in conversation logs. This parameter is required.
             *                               The default is to obscure the values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obfuscationSettingType(java.lang.String obfuscationSettingType) {
                this.obfuscationSettingType = obfuscationSettingType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ObfuscationSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ObfuscationSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ObfuscationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObfuscationSettingProperty {
            private final java.lang.String obfuscationSettingType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.obfuscationSettingType = software.amazon.jsii.Kernel.get(this, "obfuscationSettingType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.obfuscationSettingType = java.util.Objects.requireNonNull(builder.obfuscationSettingType, "obfuscationSettingType is required");
            }

            @Override
            public final java.lang.String getObfuscationSettingType() {
                return this.obfuscationSettingType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("obfuscationSettingType", om.valueToTree(this.getObfuscationSettingType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.ObfuscationSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ObfuscationSettingProperty.Jsii$Proxy that = (ObfuscationSettingProperty.Jsii$Proxy) o;

                return this.obfuscationSettingType.equals(that.obfuscationSettingType);
            }

            @Override
            public final int hashCode() {
                int result = this.obfuscationSettingType.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes a session context that is activated when an intent is fulfilled.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * OutputContextProperty outputContextProperty = OutputContextProperty.builder()
     *         .name("name")
     *         .timeToLiveInSeconds(123)
     *         .turnsToLive(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.OutputContextProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputContextProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputContextProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the output context.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The amount of time, in seconds, that the output context should remain active.
         * <p>
         * The time is figured from the first time the context is sent to the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTimeToLiveInSeconds();

        /**
         * The number of conversation turns that the output context should remain active.
         * <p>
         * The number of turns is counted from the first time that the context is sent to the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTurnsToLive();

        /**
         * @return a {@link Builder} of {@link OutputContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputContextProperty> {
            java.lang.String name;
            java.lang.Number timeToLiveInSeconds;
            java.lang.Number turnsToLive;

            /**
             * Sets the value of {@link OutputContextProperty#getName}
             * @param name The name of the output context. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link OutputContextProperty#getTimeToLiveInSeconds}
             * @param timeToLiveInSeconds The amount of time, in seconds, that the output context should remain active. This parameter is required.
             *                            The time is figured from the first time the context is sent to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeToLiveInSeconds(java.lang.Number timeToLiveInSeconds) {
                this.timeToLiveInSeconds = timeToLiveInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link OutputContextProperty#getTurnsToLive}
             * @param turnsToLive The number of conversation turns that the output context should remain active. This parameter is required.
             *                    The number of turns is counted from the first time that the context is sent to the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder turnsToLive(java.lang.Number turnsToLive) {
                this.turnsToLive = turnsToLive;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputContextProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputContextProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputContextProperty {
            private final java.lang.String name;
            private final java.lang.Number timeToLiveInSeconds;
            private final java.lang.Number turnsToLive;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeToLiveInSeconds = software.amazon.jsii.Kernel.get(this, "timeToLiveInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.turnsToLive = software.amazon.jsii.Kernel.get(this, "turnsToLive", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.timeToLiveInSeconds = java.util.Objects.requireNonNull(builder.timeToLiveInSeconds, "timeToLiveInSeconds is required");
                this.turnsToLive = java.util.Objects.requireNonNull(builder.turnsToLive, "turnsToLive is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Number getTimeToLiveInSeconds() {
                return this.timeToLiveInSeconds;
            }

            @Override
            public final java.lang.Number getTurnsToLive() {
                return this.turnsToLive;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("timeToLiveInSeconds", om.valueToTree(this.getTimeToLiveInSeconds()));
                data.set("turnsToLive", om.valueToTree(this.getTurnsToLive()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.OutputContextProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputContextProperty.Jsii$Proxy that = (OutputContextProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!timeToLiveInSeconds.equals(that.timeToLiveInSeconds)) return false;
                return this.turnsToLive.equals(that.turnsToLive);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.timeToLiveInSeconds.hashCode());
                result = 31 * result + (this.turnsToLive.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines an ASCII text message to send to the user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * PlainTextMessageProperty plainTextMessageProperty = PlainTextMessageProperty.builder()
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.PlainTextMessageProperty")
    @software.amazon.jsii.Jsii.Proxy(PlainTextMessageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlainTextMessageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The message to send to the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link PlainTextMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlainTextMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlainTextMessageProperty> {
            java.lang.String value;

            /**
             * Sets the value of {@link PlainTextMessageProperty#getValue}
             * @param value The message to send to the user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlainTextMessageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlainTextMessageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlainTextMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlainTextMessageProperty {
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.PlainTextMessageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlainTextMessageProperty.Jsii$Proxy that = (PlainTextMessageProperty.Jsii$Proxy) o;

                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                return result;
            }
        }
    }
    /**
     * Provides a setting that determines whether the post-fulfillment response is sent to the user.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/lex/latest/dg/streaming-progress.html#progress-complete">Post-fulfillment response</a> in the <em>Amazon Lex developer guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * PostFulfillmentStatusSpecificationProperty postFulfillmentStatusSpecificationProperty = PostFulfillmentStatusSpecificationProperty.builder()
     *         .failureResponse(ResponseSpecificationProperty.builder()
     *                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                         .message(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .variations(List.of(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 // the properties below are optional
     *                 .allowInterrupt(false)
     *                 .build())
     *         .successResponse(ResponseSpecificationProperty.builder()
     *                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                         .message(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .variations(List.of(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 // the properties below are optional
     *                 .allowInterrupt(false)
     *                 .build())
     *         .timeoutResponse(ResponseSpecificationProperty.builder()
     *                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                         .message(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .variations(List.of(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 // the properties below are optional
     *                 .allowInterrupt(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.PostFulfillmentStatusSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PostFulfillmentStatusSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PostFulfillmentStatusSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a list of message groups that Amazon Lex uses to respond when fulfillment isn't successful.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailureResponse() {
            return null;
        }

        /**
         * Specifies a list of message groups that Amazon Lex uses to respond when the fulfillment is successful.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSuccessResponse() {
            return null;
        }

        /**
         * Specifies a list of message groups that Amazon Lex uses to respond when fulfillment isn't completed within the timeout period.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeoutResponse() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PostFulfillmentStatusSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PostFulfillmentStatusSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PostFulfillmentStatusSpecificationProperty> {
            java.lang.Object failureResponse;
            java.lang.Object successResponse;
            java.lang.Object timeoutResponse;

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getFailureResponse}
             * @param failureResponse Specifies a list of message groups that Amazon Lex uses to respond when fulfillment isn't successful.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty failureResponse) {
                this.failureResponse = failureResponse;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getFailureResponse}
             * @param failureResponse Specifies a list of message groups that Amazon Lex uses to respond when fulfillment isn't successful.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureResponse(software.amazon.awscdk.IResolvable failureResponse) {
                this.failureResponse = failureResponse;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getSuccessResponse}
             * @param successResponse Specifies a list of message groups that Amazon Lex uses to respond when the fulfillment is successful.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty successResponse) {
                this.successResponse = successResponse;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getSuccessResponse}
             * @param successResponse Specifies a list of message groups that Amazon Lex uses to respond when the fulfillment is successful.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successResponse(software.amazon.awscdk.IResolvable successResponse) {
                this.successResponse = successResponse;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getTimeoutResponse}
             * @param timeoutResponse Specifies a list of message groups that Amazon Lex uses to respond when fulfillment isn't completed within the timeout period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty timeoutResponse) {
                this.timeoutResponse = timeoutResponse;
                return this;
            }

            /**
             * Sets the value of {@link PostFulfillmentStatusSpecificationProperty#getTimeoutResponse}
             * @param timeoutResponse Specifies a list of message groups that Amazon Lex uses to respond when fulfillment isn't completed within the timeout period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutResponse(software.amazon.awscdk.IResolvable timeoutResponse) {
                this.timeoutResponse = timeoutResponse;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PostFulfillmentStatusSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PostFulfillmentStatusSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PostFulfillmentStatusSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PostFulfillmentStatusSpecificationProperty {
            private final java.lang.Object failureResponse;
            private final java.lang.Object successResponse;
            private final java.lang.Object timeoutResponse;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.failureResponse = software.amazon.jsii.Kernel.get(this, "failureResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.successResponse = software.amazon.jsii.Kernel.get(this, "successResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutResponse = software.amazon.jsii.Kernel.get(this, "timeoutResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.failureResponse = builder.failureResponse;
                this.successResponse = builder.successResponse;
                this.timeoutResponse = builder.timeoutResponse;
            }

            @Override
            public final java.lang.Object getFailureResponse() {
                return this.failureResponse;
            }

            @Override
            public final java.lang.Object getSuccessResponse() {
                return this.successResponse;
            }

            @Override
            public final java.lang.Object getTimeoutResponse() {
                return this.timeoutResponse;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFailureResponse() != null) {
                    data.set("failureResponse", om.valueToTree(this.getFailureResponse()));
                }
                if (this.getSuccessResponse() != null) {
                    data.set("successResponse", om.valueToTree(this.getSuccessResponse()));
                }
                if (this.getTimeoutResponse() != null) {
                    data.set("timeoutResponse", om.valueToTree(this.getTimeoutResponse()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.PostFulfillmentStatusSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PostFulfillmentStatusSpecificationProperty.Jsii$Proxy that = (PostFulfillmentStatusSpecificationProperty.Jsii$Proxy) o;

                if (this.failureResponse != null ? !this.failureResponse.equals(that.failureResponse) : that.failureResponse != null) return false;
                if (this.successResponse != null ? !this.successResponse.equals(that.successResponse) : that.successResponse != null) return false;
                return this.timeoutResponse != null ? this.timeoutResponse.equals(that.timeoutResponse) : that.timeoutResponse == null;
            }

            @Override
            public final int hashCode() {
                int result = this.failureResponse != null ? this.failureResponse.hashCode() : 0;
                result = 31 * result + (this.successResponse != null ? this.successResponse.hashCode() : 0);
                result = 31 * result + (this.timeoutResponse != null ? this.timeoutResponse.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a list of message groups that Amazon Lex sends to a user to elicit a response.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * PromptSpecificationProperty promptSpecificationProperty = PromptSpecificationProperty.builder()
     *         .maxRetries(123)
     *         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                 .message(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .variations(List.of(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build()))
     *                 .build()))
     *         // the properties below are optional
     *         .allowInterrupt(false)
     *         .messageSelectionStrategy("messageSelectionStrategy")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.PromptSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of times the bot tries to elicit a response from the user using this prompt.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxRetries();

        /**
         * A collection of responses that Amazon Lex can send to the user.
         * <p>
         * Amazon Lex chooses the actual response to send at runtime.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMessageGroupsList();

        /**
         * Indicates whether the user can interrupt a speech prompt from the bot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowInterrupt() {
            return null;
        }

        /**
         * `CfnBot.PromptSpecificationProperty.MessageSelectionStrategy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageSelectionStrategy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptSpecificationProperty> {
            java.lang.Number maxRetries;
            java.lang.Object messageGroupsList;
            java.lang.Object allowInterrupt;
            java.lang.String messageSelectionStrategy;

            /**
             * Sets the value of {@link PromptSpecificationProperty#getMaxRetries}
             * @param maxRetries The maximum number of times the bot tries to elicit a response from the user using this prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRetries(java.lang.Number maxRetries) {
                this.maxRetries = maxRetries;
                return this;
            }

            /**
             * Sets the value of {@link PromptSpecificationProperty#getMessageGroupsList}
             * @param messageGroupsList A collection of responses that Amazon Lex can send to the user. This parameter is required.
             *                          Amazon Lex chooses the actual response to send at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroupsList(software.amazon.awscdk.IResolvable messageGroupsList) {
                this.messageGroupsList = messageGroupsList;
                return this;
            }

            /**
             * Sets the value of {@link PromptSpecificationProperty#getMessageGroupsList}
             * @param messageGroupsList A collection of responses that Amazon Lex can send to the user. This parameter is required.
             *                          Amazon Lex chooses the actual response to send at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroupsList(java.util.List<? extends java.lang.Object> messageGroupsList) {
                this.messageGroupsList = messageGroupsList;
                return this;
            }

            /**
             * Sets the value of {@link PromptSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Indicates whether the user can interrupt a speech prompt from the bot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(java.lang.Boolean allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Sets the value of {@link PromptSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Indicates whether the user can interrupt a speech prompt from the bot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(software.amazon.awscdk.IResolvable allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Sets the value of {@link PromptSpecificationProperty#getMessageSelectionStrategy}
             * @param messageSelectionStrategy `CfnBot.PromptSpecificationProperty.MessageSelectionStrategy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageSelectionStrategy(java.lang.String messageSelectionStrategy) {
                this.messageSelectionStrategy = messageSelectionStrategy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptSpecificationProperty {
            private final java.lang.Number maxRetries;
            private final java.lang.Object messageGroupsList;
            private final java.lang.Object allowInterrupt;
            private final java.lang.String messageSelectionStrategy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxRetries = software.amazon.jsii.Kernel.get(this, "maxRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.messageGroupsList = software.amazon.jsii.Kernel.get(this, "messageGroupsList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowInterrupt = software.amazon.jsii.Kernel.get(this, "allowInterrupt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.messageSelectionStrategy = software.amazon.jsii.Kernel.get(this, "messageSelectionStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxRetries = java.util.Objects.requireNonNull(builder.maxRetries, "maxRetries is required");
                this.messageGroupsList = java.util.Objects.requireNonNull(builder.messageGroupsList, "messageGroupsList is required");
                this.allowInterrupt = builder.allowInterrupt;
                this.messageSelectionStrategy = builder.messageSelectionStrategy;
            }

            @Override
            public final java.lang.Number getMaxRetries() {
                return this.maxRetries;
            }

            @Override
            public final java.lang.Object getMessageGroupsList() {
                return this.messageGroupsList;
            }

            @Override
            public final java.lang.Object getAllowInterrupt() {
                return this.allowInterrupt;
            }

            @Override
            public final java.lang.String getMessageSelectionStrategy() {
                return this.messageSelectionStrategy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxRetries", om.valueToTree(this.getMaxRetries()));
                data.set("messageGroupsList", om.valueToTree(this.getMessageGroupsList()));
                if (this.getAllowInterrupt() != null) {
                    data.set("allowInterrupt", om.valueToTree(this.getAllowInterrupt()));
                }
                if (this.getMessageSelectionStrategy() != null) {
                    data.set("messageSelectionStrategy", om.valueToTree(this.getMessageSelectionStrategy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.PromptSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptSpecificationProperty.Jsii$Proxy that = (PromptSpecificationProperty.Jsii$Proxy) o;

                if (!maxRetries.equals(that.maxRetries)) return false;
                if (!messageGroupsList.equals(that.messageGroupsList)) return false;
                if (this.allowInterrupt != null ? !this.allowInterrupt.equals(that.allowInterrupt) : that.allowInterrupt != null) return false;
                return this.messageSelectionStrategy != null ? this.messageSelectionStrategy.equals(that.messageSelectionStrategy) : that.messageSelectionStrategy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxRetries.hashCode();
                result = 31 * result + (this.messageGroupsList.hashCode());
                result = 31 * result + (this.allowInterrupt != null ? this.allowInterrupt.hashCode() : 0);
                result = 31 * result + (this.messageSelectionStrategy != null ? this.messageSelectionStrategy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a list of message groups that Amazon Lex uses to respond to user input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * ResponseSpecificationProperty responseSpecificationProperty = ResponseSpecificationProperty.builder()
     *         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                 .message(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .variations(List.of(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build()))
     *                 .build()))
     *         // the properties below are optional
     *         .allowInterrupt(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.ResponseSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ResponseSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResponseSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A collection of responses that Amazon Lex can send to the user.
         * <p>
         * Amazon Lex chooses the actual response to send at runtime.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMessageGroupsList();

        /**
         * Indicates whether the user can interrupt a speech response from Amazon Lex .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowInterrupt() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResponseSpecificationProperty> {
            java.lang.Object messageGroupsList;
            java.lang.Object allowInterrupt;

            /**
             * Sets the value of {@link ResponseSpecificationProperty#getMessageGroupsList}
             * @param messageGroupsList A collection of responses that Amazon Lex can send to the user. This parameter is required.
             *                          Amazon Lex chooses the actual response to send at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroupsList(software.amazon.awscdk.IResolvable messageGroupsList) {
                this.messageGroupsList = messageGroupsList;
                return this;
            }

            /**
             * Sets the value of {@link ResponseSpecificationProperty#getMessageGroupsList}
             * @param messageGroupsList A collection of responses that Amazon Lex can send to the user. This parameter is required.
             *                          Amazon Lex chooses the actual response to send at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroupsList(java.util.List<? extends java.lang.Object> messageGroupsList) {
                this.messageGroupsList = messageGroupsList;
                return this;
            }

            /**
             * Sets the value of {@link ResponseSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Indicates whether the user can interrupt a speech response from Amazon Lex .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(java.lang.Boolean allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Sets the value of {@link ResponseSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Indicates whether the user can interrupt a speech response from Amazon Lex .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(software.amazon.awscdk.IResolvable allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResponseSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResponseSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResponseSpecificationProperty {
            private final java.lang.Object messageGroupsList;
            private final java.lang.Object allowInterrupt;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.messageGroupsList = software.amazon.jsii.Kernel.get(this, "messageGroupsList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowInterrupt = software.amazon.jsii.Kernel.get(this, "allowInterrupt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.messageGroupsList = java.util.Objects.requireNonNull(builder.messageGroupsList, "messageGroupsList is required");
                this.allowInterrupt = builder.allowInterrupt;
            }

            @Override
            public final java.lang.Object getMessageGroupsList() {
                return this.messageGroupsList;
            }

            @Override
            public final java.lang.Object getAllowInterrupt() {
                return this.allowInterrupt;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("messageGroupsList", om.valueToTree(this.getMessageGroupsList()));
                if (this.getAllowInterrupt() != null) {
                    data.set("allowInterrupt", om.valueToTree(this.getAllowInterrupt()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.ResponseSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResponseSpecificationProperty.Jsii$Proxy that = (ResponseSpecificationProperty.Jsii$Proxy) o;

                if (!messageGroupsList.equals(that.messageGroupsList)) return false;
                return this.allowInterrupt != null ? this.allowInterrupt.equals(that.allowInterrupt) : that.allowInterrupt == null;
            }

            @Override
            public final int hashCode() {
                int result = this.messageGroupsList.hashCode();
                result = 31 * result + (this.allowInterrupt != null ? this.allowInterrupt.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an Amazon S3 bucket for logging audio conversations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * S3BucketLogDestinationProperty s3BucketLogDestinationProperty = S3BucketLogDestinationProperty.builder()
     *         .logPrefix("logPrefix")
     *         .s3BucketArn("s3BucketArn")
     *         // the properties below are optional
     *         .kmsKeyArn("kmsKeyArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.S3BucketLogDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3BucketLogDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3BucketLogDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the Amazon S3 prefix to assign to audio log files.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogPrefix();

        /**
         * Specifies the Amazon Resource Name (ARN) of the Amazon S3 bucket where audio files are stored.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3BucketArn();

        /**
         * Specifies the Amazon Resource Name (ARN) of an AWS Key Management Service key for encrypting audio log files stored in an Amazon S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3BucketLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3BucketLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3BucketLogDestinationProperty> {
            java.lang.String logPrefix;
            java.lang.String s3BucketArn;
            java.lang.String kmsKeyArn;

            /**
             * Sets the value of {@link S3BucketLogDestinationProperty#getLogPrefix}
             * @param logPrefix Specifies the Amazon S3 prefix to assign to audio log files. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logPrefix(java.lang.String logPrefix) {
                this.logPrefix = logPrefix;
                return this;
            }

            /**
             * Sets the value of {@link S3BucketLogDestinationProperty#getS3BucketArn}
             * @param s3BucketArn Specifies the Amazon Resource Name (ARN) of the Amazon S3 bucket where audio files are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketArn(java.lang.String s3BucketArn) {
                this.s3BucketArn = s3BucketArn;
                return this;
            }

            /**
             * Sets the value of {@link S3BucketLogDestinationProperty#getKmsKeyArn}
             * @param kmsKeyArn Specifies the Amazon Resource Name (ARN) of an AWS Key Management Service key for encrypting audio log files stored in an Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3BucketLogDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3BucketLogDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3BucketLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3BucketLogDestinationProperty {
            private final java.lang.String logPrefix;
            private final java.lang.String s3BucketArn;
            private final java.lang.String kmsKeyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logPrefix = software.amazon.jsii.Kernel.get(this, "logPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BucketArn = software.amazon.jsii.Kernel.get(this, "s3BucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logPrefix = java.util.Objects.requireNonNull(builder.logPrefix, "logPrefix is required");
                this.s3BucketArn = java.util.Objects.requireNonNull(builder.s3BucketArn, "s3BucketArn is required");
                this.kmsKeyArn = builder.kmsKeyArn;
            }

            @Override
            public final java.lang.String getLogPrefix() {
                return this.logPrefix;
            }

            @Override
            public final java.lang.String getS3BucketArn() {
                return this.s3BucketArn;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logPrefix", om.valueToTree(this.getLogPrefix()));
                data.set("s3BucketArn", om.valueToTree(this.getS3BucketArn()));
                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.S3BucketLogDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3BucketLogDestinationProperty.Jsii$Proxy that = (S3BucketLogDestinationProperty.Jsii$Proxy) o;

                if (!logPrefix.equals(that.logPrefix)) return false;
                if (!s3BucketArn.equals(that.s3BucketArn)) return false;
                return this.kmsKeyArn != null ? this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logPrefix.hashCode();
                result = 31 * result + (this.s3BucketArn.hashCode());
                result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines an Amazon S3 bucket location.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * S3LocationProperty s3LocationProperty = S3LocationProperty.builder()
     *         .s3Bucket("s3Bucket")
     *         .s3ObjectKey("s3ObjectKey")
     *         // the properties below are optional
     *         .s3ObjectVersion("s3ObjectVersion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 bucket name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Bucket();

        /**
         * The path and file name to the object in the S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3ObjectKey();

        /**
         * The version of the object in the S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3ObjectVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            java.lang.String s3Bucket;
            java.lang.String s3ObjectKey;
            java.lang.String s3ObjectVersion;

            /**
             * Sets the value of {@link S3LocationProperty#getS3Bucket}
             * @param s3Bucket The S3 bucket name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(java.lang.String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getS3ObjectKey}
             * @param s3ObjectKey The path and file name to the object in the S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ObjectKey(java.lang.String s3ObjectKey) {
                this.s3ObjectKey = s3ObjectKey;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getS3ObjectVersion}
             * @param s3ObjectVersion The version of the object in the S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ObjectVersion(java.lang.String s3ObjectVersion) {
                this.s3ObjectVersion = s3ObjectVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String s3Bucket;
            private final java.lang.String s3ObjectKey;
            private final java.lang.String s3ObjectVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Bucket = software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3ObjectKey = software.amazon.jsii.Kernel.get(this, "s3ObjectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3ObjectVersion = software.amazon.jsii.Kernel.get(this, "s3ObjectVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Bucket = java.util.Objects.requireNonNull(builder.s3Bucket, "s3Bucket is required");
                this.s3ObjectKey = java.util.Objects.requireNonNull(builder.s3ObjectKey, "s3ObjectKey is required");
                this.s3ObjectVersion = builder.s3ObjectVersion;
            }

            @Override
            public final java.lang.String getS3Bucket() {
                return this.s3Bucket;
            }

            @Override
            public final java.lang.String getS3ObjectKey() {
                return this.s3ObjectKey;
            }

            @Override
            public final java.lang.String getS3ObjectVersion() {
                return this.s3ObjectVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
                data.set("s3ObjectKey", om.valueToTree(this.getS3ObjectKey()));
                if (this.getS3ObjectVersion() != null) {
                    data.set("s3ObjectVersion", om.valueToTree(this.getS3ObjectVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!s3Bucket.equals(that.s3Bucket)) return false;
                if (!s3ObjectKey.equals(that.s3ObjectKey)) return false;
                return this.s3ObjectVersion != null ? this.s3ObjectVersion.equals(that.s3ObjectVersion) : that.s3ObjectVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Bucket.hashCode();
                result = 31 * result + (this.s3ObjectKey.hashCode());
                result = 31 * result + (this.s3ObjectVersion != null ? this.s3ObjectVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines a Speech Synthesis Markup Language (SSML) prompt.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SSMLMessageProperty sSMLMessageProperty = SSMLMessageProperty.builder()
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SSMLMessageProperty")
    @software.amazon.jsii.Jsii.Proxy(SSMLMessageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SSMLMessageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The SSML text that defines the prompt.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link SSMLMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SSMLMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SSMLMessageProperty> {
            java.lang.String value;

            /**
             * Sets the value of {@link SSMLMessageProperty#getValue}
             * @param value The SSML text that defines the prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SSMLMessageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SSMLMessageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SSMLMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SSMLMessageProperty {
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SSMLMessageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SSMLMessageProperty.Jsii$Proxy that = (SSMLMessageProperty.Jsii$Proxy) o;

                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                return result;
            }
        }
    }
    /**
     * A sample utterance that invokes and intent or responds to a slot elicitation prompt.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SampleUtteranceProperty sampleUtteranceProperty = SampleUtteranceProperty.builder()
     *         .utterance("utterance")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SampleUtteranceProperty")
    @software.amazon.jsii.Jsii.Proxy(SampleUtteranceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SampleUtteranceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The sample utterance that Amazon Lex uses to build its machine-learning model to recognize intents.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUtterance();

        /**
         * @return a {@link Builder} of {@link SampleUtteranceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SampleUtteranceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SampleUtteranceProperty> {
            java.lang.String utterance;

            /**
             * Sets the value of {@link SampleUtteranceProperty#getUtterance}
             * @param utterance The sample utterance that Amazon Lex uses to build its machine-learning model to recognize intents. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder utterance(java.lang.String utterance) {
                this.utterance = utterance;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SampleUtteranceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SampleUtteranceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SampleUtteranceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SampleUtteranceProperty {
            private final java.lang.String utterance;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.utterance = software.amazon.jsii.Kernel.get(this, "utterance", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.utterance = java.util.Objects.requireNonNull(builder.utterance, "utterance is required");
            }

            @Override
            public final java.lang.String getUtterance() {
                return this.utterance;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("utterance", om.valueToTree(this.getUtterance()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SampleUtteranceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SampleUtteranceProperty.Jsii$Proxy that = (SampleUtteranceProperty.Jsii$Proxy) o;

                return this.utterance.equals(that.utterance);
            }

            @Override
            public final int hashCode() {
                int result = this.utterance.hashCode();
                return result;
            }
        }
    }
    /**
     * Defines one of the values for a slot type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SampleValueProperty sampleValueProperty = SampleValueProperty.builder()
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SampleValueProperty")
    @software.amazon.jsii.Jsii.Proxy(SampleValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SampleValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value that can be used for a slot type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link SampleValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SampleValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SampleValueProperty> {
            java.lang.String value;

            /**
             * Sets the value of {@link SampleValueProperty#getValue}
             * @param value The value that can be used for a slot type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SampleValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SampleValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SampleValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SampleValueProperty {
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SampleValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SampleValueProperty.Jsii$Proxy that = (SampleValueProperty.Jsii$Proxy) o;

                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.value.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the default value to use when a user doesn't provide a value for a slot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotDefaultValueProperty slotDefaultValueProperty = SlotDefaultValueProperty.builder()
     *         .defaultValue("defaultValue")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotDefaultValueProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotDefaultValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotDefaultValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default value to use when a user doesn't provide a value for a slot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDefaultValue();

        /**
         * @return a {@link Builder} of {@link SlotDefaultValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotDefaultValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotDefaultValueProperty> {
            java.lang.String defaultValue;

            /**
             * Sets the value of {@link SlotDefaultValueProperty#getDefaultValue}
             * @param defaultValue The default value to use when a user doesn't provide a value for a slot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(java.lang.String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotDefaultValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotDefaultValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotDefaultValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotDefaultValueProperty {
            private final java.lang.String defaultValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultValue = software.amazon.jsii.Kernel.get(this, "defaultValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultValue = java.util.Objects.requireNonNull(builder.defaultValue, "defaultValue is required");
            }

            @Override
            public final java.lang.String getDefaultValue() {
                return this.defaultValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultValue", om.valueToTree(this.getDefaultValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotDefaultValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotDefaultValueProperty.Jsii$Proxy that = (SlotDefaultValueProperty.Jsii$Proxy) o;

                return this.defaultValue.equals(that.defaultValue);
            }

            @Override
            public final int hashCode() {
                int result = this.defaultValue.hashCode();
                return result;
            }
        }
    }
    /**
     * Defines a list of values that Amazon Lex should use as the default value for a slot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotDefaultValueSpecificationProperty slotDefaultValueSpecificationProperty = SlotDefaultValueSpecificationProperty.builder()
     *         .defaultValueList(List.of(SlotDefaultValueProperty.builder()
     *                 .defaultValue("defaultValue")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotDefaultValueSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotDefaultValueSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotDefaultValueSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of default values.
         * <p>
         * Amazon Lex chooses the default value to use in the order that they are presented in the list.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDefaultValueList();

        /**
         * @return a {@link Builder} of {@link SlotDefaultValueSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotDefaultValueSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotDefaultValueSpecificationProperty> {
            java.lang.Object defaultValueList;

            /**
             * Sets the value of {@link SlotDefaultValueSpecificationProperty#getDefaultValueList}
             * @param defaultValueList A list of default values. This parameter is required.
             *                         Amazon Lex chooses the default value to use in the order that they are presented in the list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValueList(software.amazon.awscdk.IResolvable defaultValueList) {
                this.defaultValueList = defaultValueList;
                return this;
            }

            /**
             * Sets the value of {@link SlotDefaultValueSpecificationProperty#getDefaultValueList}
             * @param defaultValueList A list of default values. This parameter is required.
             *                         Amazon Lex chooses the default value to use in the order that they are presented in the list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValueList(java.util.List<? extends java.lang.Object> defaultValueList) {
                this.defaultValueList = defaultValueList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotDefaultValueSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotDefaultValueSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotDefaultValueSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotDefaultValueSpecificationProperty {
            private final java.lang.Object defaultValueList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultValueList = software.amazon.jsii.Kernel.get(this, "defaultValueList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultValueList = java.util.Objects.requireNonNull(builder.defaultValueList, "defaultValueList is required");
            }

            @Override
            public final java.lang.Object getDefaultValueList() {
                return this.defaultValueList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultValueList", om.valueToTree(this.getDefaultValueList()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotDefaultValueSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotDefaultValueSpecificationProperty.Jsii$Proxy that = (SlotDefaultValueSpecificationProperty.Jsii$Proxy) o;

                return this.defaultValueList.equals(that.defaultValueList);
            }

            @Override
            public final int hashCode() {
                int result = this.defaultValueList.hashCode();
                return result;
            }
        }
    }
    /**
     * Sets the priority that Amazon Lex should use when eliciting slots values from a user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotPriorityProperty slotPriorityProperty = SlotPriorityProperty.builder()
     *         .priority(123)
     *         .slotName("slotName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotPriorityProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotPriorityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotPriorityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The priority that Amazon Lex should apply to the slot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

        /**
         * The name of the slot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSlotName();

        /**
         * @return a {@link Builder} of {@link SlotPriorityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotPriorityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotPriorityProperty> {
            java.lang.Number priority;
            java.lang.String slotName;

            /**
             * Sets the value of {@link SlotPriorityProperty#getPriority}
             * @param priority The priority that Amazon Lex should apply to the slot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link SlotPriorityProperty#getSlotName}
             * @param slotName The name of the slot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotName(java.lang.String slotName) {
                this.slotName = slotName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotPriorityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotPriorityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotPriorityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotPriorityProperty {
            private final java.lang.Number priority;
            private final java.lang.String slotName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.slotName = software.amazon.jsii.Kernel.get(this, "slotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
                this.slotName = java.util.Objects.requireNonNull(builder.slotName, "slotName is required");
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.String getSlotName() {
                return this.slotName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("priority", om.valueToTree(this.getPriority()));
                data.set("slotName", om.valueToTree(this.getSlotName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotPriorityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotPriorityProperty.Jsii$Proxy that = (SlotPriorityProperty.Jsii$Proxy) o;

                if (!priority.equals(that.priority)) return false;
                return this.slotName.equals(that.slotName);
            }

            @Override
            public final int hashCode() {
                int result = this.priority.hashCode();
                result = 31 * result + (this.slotName.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the definition of a slot.
     * <p>
     * Amazon Lex elicits slot values from uses to fulfill the user's intent.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotProperty slotProperty = SlotProperty.builder()
     *         .name("name")
     *         .slotTypeName("slotTypeName")
     *         .valueElicitationSetting(SlotValueElicitationSettingProperty.builder()
     *                 .slotConstraint("slotConstraint")
     *                 // the properties below are optional
     *                 .defaultValueSpecification(SlotDefaultValueSpecificationProperty.builder()
     *                         .defaultValueList(List.of(SlotDefaultValueProperty.builder()
     *                                 .defaultValue("defaultValue")
     *                                 .build()))
     *                         .build())
     *                 .promptSpecification(PromptSpecificationProperty.builder()
     *                         .maxRetries(123)
     *                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                 .message(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .variations(List.of(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build()))
     *                                 .build()))
     *                         // the properties below are optional
     *                         .allowInterrupt(false)
     *                         .messageSelectionStrategy("messageSelectionStrategy")
     *                         .build())
     *                 .sampleUtterances(List.of(SampleUtteranceProperty.builder()
     *                         .utterance("utterance")
     *                         .build()))
     *                 .waitAndContinueSpecification(WaitAndContinueSpecificationProperty.builder()
     *                         .continueResponse(ResponseSpecificationProperty.builder()
     *                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                         .message(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .variations(List.of(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build()))
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .allowInterrupt(false)
     *                                 .build())
     *                         .waitingResponse(ResponseSpecificationProperty.builder()
     *                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                         .message(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .variations(List.of(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build()))
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .allowInterrupt(false)
     *                                 .build())
     *                         // the properties below are optional
     *                         .isActive(false)
     *                         .stillWaitingResponse(StillWaitingResponseSpecificationProperty.builder()
     *                                 .frequencyInSeconds(123)
     *                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                         .message(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .variations(List.of(MessageProperty.builder()
     *                                                 .customPayload(CustomPayloadProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                         .title("title")
     *                                                         // the properties below are optional
     *                                                         .buttons(List.of(ButtonProperty.builder()
     *                                                                 .text("text")
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .imageUrl("imageUrl")
     *                                                         .subtitle("subtitle")
     *                                                         .build())
     *                                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build()))
     *                                         .build()))
     *                                 .timeoutInSeconds(123)
     *                                 // the properties below are optional
     *                                 .allowInterrupt(false)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .description("description")
     *         .multipleValuesSetting(MultipleValuesSettingProperty.builder()
     *                 .allowMultipleValues(false)
     *                 .build())
     *         .obfuscationSetting(ObfuscationSettingProperty.builder()
     *                 .obfuscationSettingType("obfuscationSettingType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the slot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The name of the slot type that this slot is based on.
         * <p>
         * The slot type defines the acceptable values for the slot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSlotTypeName();

        /**
         * Determines the slot resolution strategy that Amazon Lex uses to return slot type values.
         * <p>
         * The field can be set to one of the following values:
         * <p>
         * <ul>
         * <li>OriginalValue - Returns the value entered by the user, if the user value is similar to a slot value.</li>
         * <li>TopResolution - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</li>
         * </ul>
         * <p>
         * If you don't specify the valueSelectionStrategy, the default is OriginalValue.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValueElicitationSetting();

        /**
         * A description of the slot type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Determines whether the slot can return multiple values to the application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMultipleValuesSetting() {
            return null;
        }

        /**
         * Determines whether the contents of the slot are obfuscated in Amazon CloudWatch Logs logs.
         * <p>
         * Use obfuscated slots to protect information such as personally identifiable information (PII) in logs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getObfuscationSetting() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SlotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotProperty> {
            java.lang.String name;
            java.lang.String slotTypeName;
            java.lang.Object valueElicitationSetting;
            java.lang.String description;
            java.lang.Object multipleValuesSetting;
            java.lang.Object obfuscationSetting;

            /**
             * Sets the value of {@link SlotProperty#getName}
             * @param name The name of the slot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SlotProperty#getSlotTypeName}
             * @param slotTypeName The name of the slot type that this slot is based on. This parameter is required.
             *                     The slot type defines the acceptable values for the slot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotTypeName(java.lang.String slotTypeName) {
                this.slotTypeName = slotTypeName;
                return this;
            }

            /**
             * Sets the value of {@link SlotProperty#getValueElicitationSetting}
             * @param valueElicitationSetting Determines the slot resolution strategy that Amazon Lex uses to return slot type values. This parameter is required.
             *                                The field can be set to one of the following values:
             *                                <p>
             *                                <ul>
             *                                <li>OriginalValue - Returns the value entered by the user, if the user value is similar to a slot value.</li>
             *                                <li>TopResolution - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</li>
             *                                </ul>
             *                                <p>
             *                                If you don't specify the valueSelectionStrategy, the default is OriginalValue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueElicitationSetting(software.amazon.awscdk.services.lex.CfnBot.SlotValueElicitationSettingProperty valueElicitationSetting) {
                this.valueElicitationSetting = valueElicitationSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotProperty#getValueElicitationSetting}
             * @param valueElicitationSetting Determines the slot resolution strategy that Amazon Lex uses to return slot type values. This parameter is required.
             *                                The field can be set to one of the following values:
             *                                <p>
             *                                <ul>
             *                                <li>OriginalValue - Returns the value entered by the user, if the user value is similar to a slot value.</li>
             *                                <li>TopResolution - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</li>
             *                                </ul>
             *                                <p>
             *                                If you don't specify the valueSelectionStrategy, the default is OriginalValue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueElicitationSetting(software.amazon.awscdk.IResolvable valueElicitationSetting) {
                this.valueElicitationSetting = valueElicitationSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotProperty#getDescription}
             * @param description A description of the slot type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link SlotProperty#getMultipleValuesSetting}
             * @param multipleValuesSetting Determines whether the slot can return multiple values to the application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multipleValuesSetting(software.amazon.awscdk.services.lex.CfnBot.MultipleValuesSettingProperty multipleValuesSetting) {
                this.multipleValuesSetting = multipleValuesSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotProperty#getMultipleValuesSetting}
             * @param multipleValuesSetting Determines whether the slot can return multiple values to the application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multipleValuesSetting(software.amazon.awscdk.IResolvable multipleValuesSetting) {
                this.multipleValuesSetting = multipleValuesSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotProperty#getObfuscationSetting}
             * @param obfuscationSetting Determines whether the contents of the slot are obfuscated in Amazon CloudWatch Logs logs.
             *                           Use obfuscated slots to protect information such as personally identifiable information (PII) in logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obfuscationSetting(software.amazon.awscdk.services.lex.CfnBot.ObfuscationSettingProperty obfuscationSetting) {
                this.obfuscationSetting = obfuscationSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotProperty#getObfuscationSetting}
             * @param obfuscationSetting Determines whether the contents of the slot are obfuscated in Amazon CloudWatch Logs logs.
             *                           Use obfuscated slots to protect information such as personally identifiable information (PII) in logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder obfuscationSetting(software.amazon.awscdk.IResolvable obfuscationSetting) {
                this.obfuscationSetting = obfuscationSetting;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotProperty {
            private final java.lang.String name;
            private final java.lang.String slotTypeName;
            private final java.lang.Object valueElicitationSetting;
            private final java.lang.String description;
            private final java.lang.Object multipleValuesSetting;
            private final java.lang.Object obfuscationSetting;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.slotTypeName = software.amazon.jsii.Kernel.get(this, "slotTypeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueElicitationSetting = software.amazon.jsii.Kernel.get(this, "valueElicitationSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.multipleValuesSetting = software.amazon.jsii.Kernel.get(this, "multipleValuesSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.obfuscationSetting = software.amazon.jsii.Kernel.get(this, "obfuscationSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.slotTypeName = java.util.Objects.requireNonNull(builder.slotTypeName, "slotTypeName is required");
                this.valueElicitationSetting = java.util.Objects.requireNonNull(builder.valueElicitationSetting, "valueElicitationSetting is required");
                this.description = builder.description;
                this.multipleValuesSetting = builder.multipleValuesSetting;
                this.obfuscationSetting = builder.obfuscationSetting;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSlotTypeName() {
                return this.slotTypeName;
            }

            @Override
            public final java.lang.Object getValueElicitationSetting() {
                return this.valueElicitationSetting;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getMultipleValuesSetting() {
                return this.multipleValuesSetting;
            }

            @Override
            public final java.lang.Object getObfuscationSetting() {
                return this.obfuscationSetting;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("slotTypeName", om.valueToTree(this.getSlotTypeName()));
                data.set("valueElicitationSetting", om.valueToTree(this.getValueElicitationSetting()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getMultipleValuesSetting() != null) {
                    data.set("multipleValuesSetting", om.valueToTree(this.getMultipleValuesSetting()));
                }
                if (this.getObfuscationSetting() != null) {
                    data.set("obfuscationSetting", om.valueToTree(this.getObfuscationSetting()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotProperty.Jsii$Proxy that = (SlotProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!slotTypeName.equals(that.slotTypeName)) return false;
                if (!valueElicitationSetting.equals(that.valueElicitationSetting)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.multipleValuesSetting != null ? !this.multipleValuesSetting.equals(that.multipleValuesSetting) : that.multipleValuesSetting != null) return false;
                return this.obfuscationSetting != null ? this.obfuscationSetting.equals(that.obfuscationSetting) : that.obfuscationSetting == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.slotTypeName.hashCode());
                result = 31 * result + (this.valueElicitationSetting.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.multipleValuesSetting != null ? this.multipleValuesSetting.hashCode() : 0);
                result = 31 * result + (this.obfuscationSetting != null ? this.obfuscationSetting.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a slot type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotTypeProperty slotTypeProperty = SlotTypeProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .description("description")
     *         .externalSourceSetting(ExternalSourceSettingProperty.builder()
     *                 .grammarSlotTypeSetting(GrammarSlotTypeSettingProperty.builder()
     *                         .source(GrammarSlotTypeSourceProperty.builder()
     *                                 .s3BucketName("s3BucketName")
     *                                 .s3ObjectKey("s3ObjectKey")
     *                                 // the properties below are optional
     *                                 .kmsKeyArn("kmsKeyArn")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .parentSlotTypeSignature("parentSlotTypeSignature")
     *         .slotTypeValues(List.of(SlotTypeValueProperty.builder()
     *                 .sampleValue(SampleValueProperty.builder()
     *                         .value("value")
     *                         .build())
     *                 // the properties below are optional
     *                 .synonyms(List.of(SampleValueProperty.builder()
     *                         .value("value")
     *                         .build()))
     *                 .build()))
     *         .valueSelectionSetting(SlotValueSelectionSettingProperty.builder()
     *                 .resolutionStrategy("resolutionStrategy")
     *                 // the properties below are optional
     *                 .advancedRecognitionSetting(AdvancedRecognitionSettingProperty.builder()
     *                         .audioRecognitionStrategy("audioRecognitionStrategy")
     *                         .build())
     *                 .regexFilter(SlotValueRegexFilterProperty.builder()
     *                         .pattern("pattern")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the slot type.
         * <p>
         * A slot type name must be unique withing the account.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * A description of the slot type.
         * <p>
         * Use the description to help identify the slot type in lists.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Sets the type of external information used to create the slot type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExternalSourceSetting() {
            return null;
        }

        /**
         * The built-in slot type used as a parent of this slot type.
         * <p>
         * When you define a parent slot type, the new slot type has the configuration of the parent lot type.
         * <p>
         * Only AMAZON.AlphaNumeric is supported.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParentSlotTypeSignature() {
            return null;
        }

        /**
         * A list of SlotTypeValue objects that defines the values that the slot type can take.
         * <p>
         * Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for the slot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSlotTypeValues() {
            return null;
        }

        /**
         * Determines the slot resolution strategy that Amazon Lex uses to return slot type values.
         * <p>
         * The field can be set to one of the following values:
         * <p>
         * <ul>
         * <li>OriginalValue - Returns the value entered by the user, if the user value is similar to a slot value.</li>
         * <li>TopResolution - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</li>
         * </ul>
         * <p>
         * If you don't specify the valueSelectionStrategy, the default is OriginalValue.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValueSelectionSetting() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SlotTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotTypeProperty> {
            java.lang.String name;
            java.lang.String description;
            java.lang.Object externalSourceSetting;
            java.lang.String parentSlotTypeSignature;
            java.lang.Object slotTypeValues;
            java.lang.Object valueSelectionSetting;

            /**
             * Sets the value of {@link SlotTypeProperty#getName}
             * @param name The name of the slot type. This parameter is required.
             *             A slot type name must be unique withing the account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeProperty#getDescription}
             * @param description A description of the slot type.
             *                    Use the description to help identify the slot type in lists.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeProperty#getExternalSourceSetting}
             * @param externalSourceSetting Sets the type of external information used to create the slot type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalSourceSetting(software.amazon.awscdk.services.lex.CfnBot.ExternalSourceSettingProperty externalSourceSetting) {
                this.externalSourceSetting = externalSourceSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeProperty#getExternalSourceSetting}
             * @param externalSourceSetting Sets the type of external information used to create the slot type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalSourceSetting(software.amazon.awscdk.IResolvable externalSourceSetting) {
                this.externalSourceSetting = externalSourceSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeProperty#getParentSlotTypeSignature}
             * @param parentSlotTypeSignature The built-in slot type used as a parent of this slot type.
             *                                When you define a parent slot type, the new slot type has the configuration of the parent lot type.
             *                                <p>
             *                                Only AMAZON.AlphaNumeric is supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parentSlotTypeSignature(java.lang.String parentSlotTypeSignature) {
                this.parentSlotTypeSignature = parentSlotTypeSignature;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeProperty#getSlotTypeValues}
             * @param slotTypeValues A list of SlotTypeValue objects that defines the values that the slot type can take.
             *                       Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for the slot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotTypeValues(software.amazon.awscdk.IResolvable slotTypeValues) {
                this.slotTypeValues = slotTypeValues;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeProperty#getSlotTypeValues}
             * @param slotTypeValues A list of SlotTypeValue objects that defines the values that the slot type can take.
             *                       Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for the slot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotTypeValues(java.util.List<? extends java.lang.Object> slotTypeValues) {
                this.slotTypeValues = slotTypeValues;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeProperty#getValueSelectionSetting}
             * @param valueSelectionSetting Determines the slot resolution strategy that Amazon Lex uses to return slot type values.
             *                              The field can be set to one of the following values:
             *                              <p>
             *                              <ul>
             *                              <li>OriginalValue - Returns the value entered by the user, if the user value is similar to a slot value.</li>
             *                              <li>TopResolution - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</li>
             *                              </ul>
             *                              <p>
             *                              If you don't specify the valueSelectionStrategy, the default is OriginalValue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueSelectionSetting(software.amazon.awscdk.services.lex.CfnBot.SlotValueSelectionSettingProperty valueSelectionSetting) {
                this.valueSelectionSetting = valueSelectionSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeProperty#getValueSelectionSetting}
             * @param valueSelectionSetting Determines the slot resolution strategy that Amazon Lex uses to return slot type values.
             *                              The field can be set to one of the following values:
             *                              <p>
             *                              <ul>
             *                              <li>OriginalValue - Returns the value entered by the user, if the user value is similar to a slot value.</li>
             *                              <li>TopResolution - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</li>
             *                              </ul>
             *                              <p>
             *                              If you don't specify the valueSelectionStrategy, the default is OriginalValue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueSelectionSetting(software.amazon.awscdk.IResolvable valueSelectionSetting) {
                this.valueSelectionSetting = valueSelectionSetting;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotTypeProperty {
            private final java.lang.String name;
            private final java.lang.String description;
            private final java.lang.Object externalSourceSetting;
            private final java.lang.String parentSlotTypeSignature;
            private final java.lang.Object slotTypeValues;
            private final java.lang.Object valueSelectionSetting;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalSourceSetting = software.amazon.jsii.Kernel.get(this, "externalSourceSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parentSlotTypeSignature = software.amazon.jsii.Kernel.get(this, "parentSlotTypeSignature", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.slotTypeValues = software.amazon.jsii.Kernel.get(this, "slotTypeValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.valueSelectionSetting = software.amazon.jsii.Kernel.get(this, "valueSelectionSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.description = builder.description;
                this.externalSourceSetting = builder.externalSourceSetting;
                this.parentSlotTypeSignature = builder.parentSlotTypeSignature;
                this.slotTypeValues = builder.slotTypeValues;
                this.valueSelectionSetting = builder.valueSelectionSetting;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getExternalSourceSetting() {
                return this.externalSourceSetting;
            }

            @Override
            public final java.lang.String getParentSlotTypeSignature() {
                return this.parentSlotTypeSignature;
            }

            @Override
            public final java.lang.Object getSlotTypeValues() {
                return this.slotTypeValues;
            }

            @Override
            public final java.lang.Object getValueSelectionSetting() {
                return this.valueSelectionSetting;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getExternalSourceSetting() != null) {
                    data.set("externalSourceSetting", om.valueToTree(this.getExternalSourceSetting()));
                }
                if (this.getParentSlotTypeSignature() != null) {
                    data.set("parentSlotTypeSignature", om.valueToTree(this.getParentSlotTypeSignature()));
                }
                if (this.getSlotTypeValues() != null) {
                    data.set("slotTypeValues", om.valueToTree(this.getSlotTypeValues()));
                }
                if (this.getValueSelectionSetting() != null) {
                    data.set("valueSelectionSetting", om.valueToTree(this.getValueSelectionSetting()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotTypeProperty.Jsii$Proxy that = (SlotTypeProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.externalSourceSetting != null ? !this.externalSourceSetting.equals(that.externalSourceSetting) : that.externalSourceSetting != null) return false;
                if (this.parentSlotTypeSignature != null ? !this.parentSlotTypeSignature.equals(that.parentSlotTypeSignature) : that.parentSlotTypeSignature != null) return false;
                if (this.slotTypeValues != null ? !this.slotTypeValues.equals(that.slotTypeValues) : that.slotTypeValues != null) return false;
                return this.valueSelectionSetting != null ? this.valueSelectionSetting.equals(that.valueSelectionSetting) : that.valueSelectionSetting == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.externalSourceSetting != null ? this.externalSourceSetting.hashCode() : 0);
                result = 31 * result + (this.parentSlotTypeSignature != null ? this.parentSlotTypeSignature.hashCode() : 0);
                result = 31 * result + (this.slotTypeValues != null ? this.slotTypeValues.hashCode() : 0);
                result = 31 * result + (this.valueSelectionSetting != null ? this.valueSelectionSetting.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Each slot type can have a set of values.
     * <p>
     * The <code>SlotTypeValue</code> represents a value that the slot type can take.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotTypeValueProperty slotTypeValueProperty = SlotTypeValueProperty.builder()
     *         .sampleValue(SampleValueProperty.builder()
     *                 .value("value")
     *                 .build())
     *         // the properties below are optional
     *         .synonyms(List.of(SampleValueProperty.builder()
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotTypeValueProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotTypeValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotTypeValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value of the slot type entry.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSampleValue();

        /**
         * Additional values related to the slot type entry.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSynonyms() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SlotTypeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotTypeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotTypeValueProperty> {
            java.lang.Object sampleValue;
            java.lang.Object synonyms;

            /**
             * Sets the value of {@link SlotTypeValueProperty#getSampleValue}
             * @param sampleValue The value of the slot type entry. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleValue(software.amazon.awscdk.services.lex.CfnBot.SampleValueProperty sampleValue) {
                this.sampleValue = sampleValue;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeValueProperty#getSampleValue}
             * @param sampleValue The value of the slot type entry. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleValue(software.amazon.awscdk.IResolvable sampleValue) {
                this.sampleValue = sampleValue;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeValueProperty#getSynonyms}
             * @param synonyms Additional values related to the slot type entry.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder synonyms(software.amazon.awscdk.IResolvable synonyms) {
                this.synonyms = synonyms;
                return this;
            }

            /**
             * Sets the value of {@link SlotTypeValueProperty#getSynonyms}
             * @param synonyms Additional values related to the slot type entry.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder synonyms(java.util.List<? extends java.lang.Object> synonyms) {
                this.synonyms = synonyms;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotTypeValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotTypeValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotTypeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotTypeValueProperty {
            private final java.lang.Object sampleValue;
            private final java.lang.Object synonyms;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sampleValue = software.amazon.jsii.Kernel.get(this, "sampleValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.synonyms = software.amazon.jsii.Kernel.get(this, "synonyms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sampleValue = java.util.Objects.requireNonNull(builder.sampleValue, "sampleValue is required");
                this.synonyms = builder.synonyms;
            }

            @Override
            public final java.lang.Object getSampleValue() {
                return this.sampleValue;
            }

            @Override
            public final java.lang.Object getSynonyms() {
                return this.synonyms;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sampleValue", om.valueToTree(this.getSampleValue()));
                if (this.getSynonyms() != null) {
                    data.set("synonyms", om.valueToTree(this.getSynonyms()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotTypeValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotTypeValueProperty.Jsii$Proxy that = (SlotTypeValueProperty.Jsii$Proxy) o;

                if (!sampleValue.equals(that.sampleValue)) return false;
                return this.synonyms != null ? this.synonyms.equals(that.synonyms) : that.synonyms == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sampleValue.hashCode();
                result = 31 * result + (this.synonyms != null ? this.synonyms.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings that you can use for eliciting a slot value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotValueElicitationSettingProperty slotValueElicitationSettingProperty = SlotValueElicitationSettingProperty.builder()
     *         .slotConstraint("slotConstraint")
     *         // the properties below are optional
     *         .defaultValueSpecification(SlotDefaultValueSpecificationProperty.builder()
     *                 .defaultValueList(List.of(SlotDefaultValueProperty.builder()
     *                         .defaultValue("defaultValue")
     *                         .build()))
     *                 .build())
     *         .promptSpecification(PromptSpecificationProperty.builder()
     *                 .maxRetries(123)
     *                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                         .message(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .variations(List.of(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 // the properties below are optional
     *                 .allowInterrupt(false)
     *                 .messageSelectionStrategy("messageSelectionStrategy")
     *                 .build())
     *         .sampleUtterances(List.of(SampleUtteranceProperty.builder()
     *                 .utterance("utterance")
     *                 .build()))
     *         .waitAndContinueSpecification(WaitAndContinueSpecificationProperty.builder()
     *                 .continueResponse(ResponseSpecificationProperty.builder()
     *                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                 .message(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .variations(List.of(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build()))
     *                                 .build()))
     *                         // the properties below are optional
     *                         .allowInterrupt(false)
     *                         .build())
     *                 .waitingResponse(ResponseSpecificationProperty.builder()
     *                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                 .message(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .variations(List.of(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build()))
     *                                 .build()))
     *                         // the properties below are optional
     *                         .allowInterrupt(false)
     *                         .build())
     *                 // the properties below are optional
     *                 .isActive(false)
     *                 .stillWaitingResponse(StillWaitingResponseSpecificationProperty.builder()
     *                         .frequencyInSeconds(123)
     *                         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                                 .message(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .variations(List.of(MessageProperty.builder()
     *                                         .customPayload(CustomPayloadProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                                 .title("title")
     *                                                 // the properties below are optional
     *                                                 .buttons(List.of(ButtonProperty.builder()
     *                                                         .text("text")
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .imageUrl("imageUrl")
     *                                                 .subtitle("subtitle")
     *                                                 .build())
     *                                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build()))
     *                                 .build()))
     *                         .timeoutInSeconds(123)
     *                         // the properties below are optional
     *                         .allowInterrupt(false)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotValueElicitationSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotValueElicitationSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotValueElicitationSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the slot is required or optional.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSlotConstraint();

        /**
         * A list of default values for a slot.
         * <p>
         * Default values are used when Amazon Lex hasn't determined a value for a slot. You can specify default values from context variables, session attributes, and defined values.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultValueSpecification() {
            return null;
        }

        /**
         * The prompt that Amazon Lex uses to elicit the slot value from the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPromptSpecification() {
            return null;
        }

        /**
         * If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy.
         * <p>
         * This is optional. In most cases Amazon Lex is capable of understanding user utterances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSampleUtterances() {
            return null;
        }

        /**
         * Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWaitAndContinueSpecification() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SlotValueElicitationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotValueElicitationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotValueElicitationSettingProperty> {
            java.lang.String slotConstraint;
            java.lang.Object defaultValueSpecification;
            java.lang.Object promptSpecification;
            java.lang.Object sampleUtterances;
            java.lang.Object waitAndContinueSpecification;

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getSlotConstraint}
             * @param slotConstraint Specifies whether the slot is required or optional. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotConstraint(java.lang.String slotConstraint) {
                this.slotConstraint = slotConstraint;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getDefaultValueSpecification}
             * @param defaultValueSpecification A list of default values for a slot.
             *                                  Default values are used when Amazon Lex hasn't determined a value for a slot. You can specify default values from context variables, session attributes, and defined values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValueSpecification(software.amazon.awscdk.services.lex.CfnBot.SlotDefaultValueSpecificationProperty defaultValueSpecification) {
                this.defaultValueSpecification = defaultValueSpecification;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getDefaultValueSpecification}
             * @param defaultValueSpecification A list of default values for a slot.
             *                                  Default values are used when Amazon Lex hasn't determined a value for a slot. You can specify default values from context variables, session attributes, and defined values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValueSpecification(software.amazon.awscdk.IResolvable defaultValueSpecification) {
                this.defaultValueSpecification = defaultValueSpecification;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getPromptSpecification}
             * @param promptSpecification The prompt that Amazon Lex uses to elicit the slot value from the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptSpecification(software.amazon.awscdk.services.lex.CfnBot.PromptSpecificationProperty promptSpecification) {
                this.promptSpecification = promptSpecification;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getPromptSpecification}
             * @param promptSpecification The prompt that Amazon Lex uses to elicit the slot value from the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptSpecification(software.amazon.awscdk.IResolvable promptSpecification) {
                this.promptSpecification = promptSpecification;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getSampleUtterances}
             * @param sampleUtterances If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy.
             *                         This is optional. In most cases Amazon Lex is capable of understanding user utterances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleUtterances(software.amazon.awscdk.IResolvable sampleUtterances) {
                this.sampleUtterances = sampleUtterances;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getSampleUtterances}
             * @param sampleUtterances If you know a specific pattern that users might respond to an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy.
             *                         This is optional. In most cases Amazon Lex is capable of understanding user utterances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sampleUtterances(java.util.List<? extends java.lang.Object> sampleUtterances) {
                this.sampleUtterances = sampleUtterances;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getWaitAndContinueSpecification}
             * @param waitAndContinueSpecification Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitAndContinueSpecification(software.amazon.awscdk.services.lex.CfnBot.WaitAndContinueSpecificationProperty waitAndContinueSpecification) {
                this.waitAndContinueSpecification = waitAndContinueSpecification;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueElicitationSettingProperty#getWaitAndContinueSpecification}
             * @param waitAndContinueSpecification Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitAndContinueSpecification(software.amazon.awscdk.IResolvable waitAndContinueSpecification) {
                this.waitAndContinueSpecification = waitAndContinueSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotValueElicitationSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotValueElicitationSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotValueElicitationSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotValueElicitationSettingProperty {
            private final java.lang.String slotConstraint;
            private final java.lang.Object defaultValueSpecification;
            private final java.lang.Object promptSpecification;
            private final java.lang.Object sampleUtterances;
            private final java.lang.Object waitAndContinueSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.slotConstraint = software.amazon.jsii.Kernel.get(this, "slotConstraint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultValueSpecification = software.amazon.jsii.Kernel.get(this, "defaultValueSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.promptSpecification = software.amazon.jsii.Kernel.get(this, "promptSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sampleUtterances = software.amazon.jsii.Kernel.get(this, "sampleUtterances", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.waitAndContinueSpecification = software.amazon.jsii.Kernel.get(this, "waitAndContinueSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.slotConstraint = java.util.Objects.requireNonNull(builder.slotConstraint, "slotConstraint is required");
                this.defaultValueSpecification = builder.defaultValueSpecification;
                this.promptSpecification = builder.promptSpecification;
                this.sampleUtterances = builder.sampleUtterances;
                this.waitAndContinueSpecification = builder.waitAndContinueSpecification;
            }

            @Override
            public final java.lang.String getSlotConstraint() {
                return this.slotConstraint;
            }

            @Override
            public final java.lang.Object getDefaultValueSpecification() {
                return this.defaultValueSpecification;
            }

            @Override
            public final java.lang.Object getPromptSpecification() {
                return this.promptSpecification;
            }

            @Override
            public final java.lang.Object getSampleUtterances() {
                return this.sampleUtterances;
            }

            @Override
            public final java.lang.Object getWaitAndContinueSpecification() {
                return this.waitAndContinueSpecification;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("slotConstraint", om.valueToTree(this.getSlotConstraint()));
                if (this.getDefaultValueSpecification() != null) {
                    data.set("defaultValueSpecification", om.valueToTree(this.getDefaultValueSpecification()));
                }
                if (this.getPromptSpecification() != null) {
                    data.set("promptSpecification", om.valueToTree(this.getPromptSpecification()));
                }
                if (this.getSampleUtterances() != null) {
                    data.set("sampleUtterances", om.valueToTree(this.getSampleUtterances()));
                }
                if (this.getWaitAndContinueSpecification() != null) {
                    data.set("waitAndContinueSpecification", om.valueToTree(this.getWaitAndContinueSpecification()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotValueElicitationSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotValueElicitationSettingProperty.Jsii$Proxy that = (SlotValueElicitationSettingProperty.Jsii$Proxy) o;

                if (!slotConstraint.equals(that.slotConstraint)) return false;
                if (this.defaultValueSpecification != null ? !this.defaultValueSpecification.equals(that.defaultValueSpecification) : that.defaultValueSpecification != null) return false;
                if (this.promptSpecification != null ? !this.promptSpecification.equals(that.promptSpecification) : that.promptSpecification != null) return false;
                if (this.sampleUtterances != null ? !this.sampleUtterances.equals(that.sampleUtterances) : that.sampleUtterances != null) return false;
                return this.waitAndContinueSpecification != null ? this.waitAndContinueSpecification.equals(that.waitAndContinueSpecification) : that.waitAndContinueSpecification == null;
            }

            @Override
            public final int hashCode() {
                int result = this.slotConstraint.hashCode();
                result = 31 * result + (this.defaultValueSpecification != null ? this.defaultValueSpecification.hashCode() : 0);
                result = 31 * result + (this.promptSpecification != null ? this.promptSpecification.hashCode() : 0);
                result = 31 * result + (this.sampleUtterances != null ? this.sampleUtterances.hashCode() : 0);
                result = 31 * result + (this.waitAndContinueSpecification != null ? this.waitAndContinueSpecification.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides a regular expression used to validate the value of a slot.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotValueRegexFilterProperty slotValueRegexFilterProperty = SlotValueRegexFilterProperty.builder()
     *         .pattern("pattern")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotValueRegexFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotValueRegexFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotValueRegexFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A regular expression used to validate the value of a slot.
         * <p>
         * Use a standard regular expression. Amazon Lex supports the following characters in the regular expression:
         * <p>
         * <ul>
         * <li>A-Z, a-z</li>
         * <li>0-9</li>
         * <li>Unicode characters ("\ u<Unicode>")</li>
         * </ul>
         * <p>
         * Represent Unicode characters with four digits, for example "]u0041" or "\ u005A".
         * <p>
         * The following regular expression operators are not supported:
         * <p>
         * <ul>
         * <li>Infinite repeaters: *, +, or {x,} with no upper bound</li>
         * <li>Wild card (.)</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPattern();

        /**
         * @return a {@link Builder} of {@link SlotValueRegexFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotValueRegexFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotValueRegexFilterProperty> {
            java.lang.String pattern;

            /**
             * Sets the value of {@link SlotValueRegexFilterProperty#getPattern}
             * @param pattern A regular expression used to validate the value of a slot. This parameter is required.
             *                Use a standard regular expression. Amazon Lex supports the following characters in the regular expression:
             *                <p>
             *                <ul>
             *                <li>A-Z, a-z</li>
             *                <li>0-9</li>
             *                <li>Unicode characters ("\ u<Unicode>")</li>
             *                </ul>
             *                <p>
             *                Represent Unicode characters with four digits, for example "]u0041" or "\ u005A".
             *                <p>
             *                The following regular expression operators are not supported:
             *                <p>
             *                <ul>
             *                <li>Infinite repeaters: *, +, or {x,} with no upper bound</li>
             *                <li>Wild card (.)</li>
             *                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pattern(java.lang.String pattern) {
                this.pattern = pattern;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotValueRegexFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotValueRegexFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotValueRegexFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotValueRegexFilterProperty {
            private final java.lang.String pattern;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pattern = software.amazon.jsii.Kernel.get(this, "pattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pattern = java.util.Objects.requireNonNull(builder.pattern, "pattern is required");
            }

            @Override
            public final java.lang.String getPattern() {
                return this.pattern;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("pattern", om.valueToTree(this.getPattern()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotValueRegexFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotValueRegexFilterProperty.Jsii$Proxy that = (SlotValueRegexFilterProperty.Jsii$Proxy) o;

                return this.pattern.equals(that.pattern);
            }

            @Override
            public final int hashCode() {
                int result = this.pattern.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains settings used by Amazon Lex to select a slot value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * SlotValueSelectionSettingProperty slotValueSelectionSettingProperty = SlotValueSelectionSettingProperty.builder()
     *         .resolutionStrategy("resolutionStrategy")
     *         // the properties below are optional
     *         .advancedRecognitionSetting(AdvancedRecognitionSettingProperty.builder()
     *                 .audioRecognitionStrategy("audioRecognitionStrategy")
     *                 .build())
     *         .regexFilter(SlotValueRegexFilterProperty.builder()
     *                 .pattern("pattern")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.SlotValueSelectionSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(SlotValueSelectionSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlotValueSelectionSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines the slot resolution strategy that Amazon Lex uses to return slot type values.
         * <p>
         * The field can be set to one of the following values:
         * <p>
         * <ul>
         * <li>OriginalValue - Returns the value entered by the user, if the user value is similar to a slot value.</li>
         * <li>TopResolution - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</li>
         * </ul>
         * <p>
         * If you don't specify the valueSelectionStrategy, the default is OriginalValue.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResolutionStrategy();

        /**
         * Specifies settings that enable advanced recognition settings for slot values.
         * <p>
         * You can use this to enable using slot values as a custom vocabulary for recognizing user utterances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedRecognitionSetting() {
            return null;
        }

        /**
         * A regular expression used to validate the value of a slot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRegexFilter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SlotValueSelectionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlotValueSelectionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlotValueSelectionSettingProperty> {
            java.lang.String resolutionStrategy;
            java.lang.Object advancedRecognitionSetting;
            java.lang.Object regexFilter;

            /**
             * Sets the value of {@link SlotValueSelectionSettingProperty#getResolutionStrategy}
             * @param resolutionStrategy Determines the slot resolution strategy that Amazon Lex uses to return slot type values. This parameter is required.
             *                           The field can be set to one of the following values:
             *                           <p>
             *                           <ul>
             *                           <li>OriginalValue - Returns the value entered by the user, if the user value is similar to a slot value.</li>
             *                           <li>TopResolution - If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned.</li>
             *                           </ul>
             *                           <p>
             *                           If you don't specify the valueSelectionStrategy, the default is OriginalValue.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resolutionStrategy(java.lang.String resolutionStrategy) {
                this.resolutionStrategy = resolutionStrategy;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueSelectionSettingProperty#getAdvancedRecognitionSetting}
             * @param advancedRecognitionSetting Specifies settings that enable advanced recognition settings for slot values.
             *                                   You can use this to enable using slot values as a custom vocabulary for recognizing user utterances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advancedRecognitionSetting(software.amazon.awscdk.services.lex.CfnBot.AdvancedRecognitionSettingProperty advancedRecognitionSetting) {
                this.advancedRecognitionSetting = advancedRecognitionSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueSelectionSettingProperty#getAdvancedRecognitionSetting}
             * @param advancedRecognitionSetting Specifies settings that enable advanced recognition settings for slot values.
             *                                   You can use this to enable using slot values as a custom vocabulary for recognizing user utterances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advancedRecognitionSetting(software.amazon.awscdk.IResolvable advancedRecognitionSetting) {
                this.advancedRecognitionSetting = advancedRecognitionSetting;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueSelectionSettingProperty#getRegexFilter}
             * @param regexFilter A regular expression used to validate the value of a slot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regexFilter(software.amazon.awscdk.services.lex.CfnBot.SlotValueRegexFilterProperty regexFilter) {
                this.regexFilter = regexFilter;
                return this;
            }

            /**
             * Sets the value of {@link SlotValueSelectionSettingProperty#getRegexFilter}
             * @param regexFilter A regular expression used to validate the value of a slot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regexFilter(software.amazon.awscdk.IResolvable regexFilter) {
                this.regexFilter = regexFilter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlotValueSelectionSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlotValueSelectionSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlotValueSelectionSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlotValueSelectionSettingProperty {
            private final java.lang.String resolutionStrategy;
            private final java.lang.Object advancedRecognitionSetting;
            private final java.lang.Object regexFilter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resolutionStrategy = software.amazon.jsii.Kernel.get(this, "resolutionStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.advancedRecognitionSetting = software.amazon.jsii.Kernel.get(this, "advancedRecognitionSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.regexFilter = software.amazon.jsii.Kernel.get(this, "regexFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resolutionStrategy = java.util.Objects.requireNonNull(builder.resolutionStrategy, "resolutionStrategy is required");
                this.advancedRecognitionSetting = builder.advancedRecognitionSetting;
                this.regexFilter = builder.regexFilter;
            }

            @Override
            public final java.lang.String getResolutionStrategy() {
                return this.resolutionStrategy;
            }

            @Override
            public final java.lang.Object getAdvancedRecognitionSetting() {
                return this.advancedRecognitionSetting;
            }

            @Override
            public final java.lang.Object getRegexFilter() {
                return this.regexFilter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resolutionStrategy", om.valueToTree(this.getResolutionStrategy()));
                if (this.getAdvancedRecognitionSetting() != null) {
                    data.set("advancedRecognitionSetting", om.valueToTree(this.getAdvancedRecognitionSetting()));
                }
                if (this.getRegexFilter() != null) {
                    data.set("regexFilter", om.valueToTree(this.getRegexFilter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.SlotValueSelectionSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlotValueSelectionSettingProperty.Jsii$Proxy that = (SlotValueSelectionSettingProperty.Jsii$Proxy) o;

                if (!resolutionStrategy.equals(that.resolutionStrategy)) return false;
                if (this.advancedRecognitionSetting != null ? !this.advancedRecognitionSetting.equals(that.advancedRecognitionSetting) : that.advancedRecognitionSetting != null) return false;
                return this.regexFilter != null ? this.regexFilter.equals(that.regexFilter) : that.regexFilter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resolutionStrategy.hashCode();
                result = 31 * result + (this.advancedRecognitionSetting != null ? this.advancedRecognitionSetting.hashCode() : 0);
                result = 31 * result + (this.regexFilter != null ? this.regexFilter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the messages that Amazon Lex sends to a user to remind them that the bot is waiting for a response.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * StillWaitingResponseSpecificationProperty stillWaitingResponseSpecificationProperty = StillWaitingResponseSpecificationProperty.builder()
     *         .frequencyInSeconds(123)
     *         .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                 .message(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .variations(List.of(MessageProperty.builder()
     *                         .customPayload(CustomPayloadProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .imageResponseCard(ImageResponseCardProperty.builder()
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .buttons(List.of(ButtonProperty.builder()
     *                                         .text("text")
     *                                         .value("value")
     *                                         .build()))
     *                                 .imageUrl("imageUrl")
     *                                 .subtitle("subtitle")
     *                                 .build())
     *                         .plainTextMessage(PlainTextMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .ssmlMessage(SSMLMessageProperty.builder()
     *                                 .value("value")
     *                                 .build())
     *                         .build()))
     *                 .build()))
     *         .timeoutInSeconds(123)
     *         // the properties below are optional
     *         .allowInterrupt(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.StillWaitingResponseSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(StillWaitingResponseSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StillWaitingResponseSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * How often a message should be sent to the user.
         * <p>
         * Minimum of 1 second, maximum of 5 minutes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getFrequencyInSeconds();

        /**
         * A collection of responses that Amazon Lex can send to the user.
         * <p>
         * Amazon Lex chooses the actual response to send at runtime.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMessageGroupsList();

        /**
         * If Amazon Lex waits longer than this length of time for a response, it will stop sending messages.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTimeoutInSeconds();

        /**
         * Indicates that the user can interrupt the response by speaking while the message is being played.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowInterrupt() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StillWaitingResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StillWaitingResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StillWaitingResponseSpecificationProperty> {
            java.lang.Number frequencyInSeconds;
            java.lang.Object messageGroupsList;
            java.lang.Number timeoutInSeconds;
            java.lang.Object allowInterrupt;

            /**
             * Sets the value of {@link StillWaitingResponseSpecificationProperty#getFrequencyInSeconds}
             * @param frequencyInSeconds How often a message should be sent to the user. This parameter is required.
             *                           Minimum of 1 second, maximum of 5 minutes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder frequencyInSeconds(java.lang.Number frequencyInSeconds) {
                this.frequencyInSeconds = frequencyInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link StillWaitingResponseSpecificationProperty#getMessageGroupsList}
             * @param messageGroupsList A collection of responses that Amazon Lex can send to the user. This parameter is required.
             *                          Amazon Lex chooses the actual response to send at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroupsList(software.amazon.awscdk.IResolvable messageGroupsList) {
                this.messageGroupsList = messageGroupsList;
                return this;
            }

            /**
             * Sets the value of {@link StillWaitingResponseSpecificationProperty#getMessageGroupsList}
             * @param messageGroupsList A collection of responses that Amazon Lex can send to the user. This parameter is required.
             *                          Amazon Lex chooses the actual response to send at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageGroupsList(java.util.List<? extends java.lang.Object> messageGroupsList) {
                this.messageGroupsList = messageGroupsList;
                return this;
            }

            /**
             * Sets the value of {@link StillWaitingResponseSpecificationProperty#getTimeoutInSeconds}
             * @param timeoutInSeconds If Amazon Lex waits longer than this length of time for a response, it will stop sending messages. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutInSeconds(java.lang.Number timeoutInSeconds) {
                this.timeoutInSeconds = timeoutInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link StillWaitingResponseSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Indicates that the user can interrupt the response by speaking while the message is being played.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(java.lang.Boolean allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Sets the value of {@link StillWaitingResponseSpecificationProperty#getAllowInterrupt}
             * @param allowInterrupt Indicates that the user can interrupt the response by speaking while the message is being played.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowInterrupt(software.amazon.awscdk.IResolvable allowInterrupt) {
                this.allowInterrupt = allowInterrupt;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StillWaitingResponseSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StillWaitingResponseSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StillWaitingResponseSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StillWaitingResponseSpecificationProperty {
            private final java.lang.Number frequencyInSeconds;
            private final java.lang.Object messageGroupsList;
            private final java.lang.Number timeoutInSeconds;
            private final java.lang.Object allowInterrupt;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.frequencyInSeconds = software.amazon.jsii.Kernel.get(this, "frequencyInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.messageGroupsList = software.amazon.jsii.Kernel.get(this, "messageGroupsList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutInSeconds = software.amazon.jsii.Kernel.get(this, "timeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.allowInterrupt = software.amazon.jsii.Kernel.get(this, "allowInterrupt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.frequencyInSeconds = java.util.Objects.requireNonNull(builder.frequencyInSeconds, "frequencyInSeconds is required");
                this.messageGroupsList = java.util.Objects.requireNonNull(builder.messageGroupsList, "messageGroupsList is required");
                this.timeoutInSeconds = java.util.Objects.requireNonNull(builder.timeoutInSeconds, "timeoutInSeconds is required");
                this.allowInterrupt = builder.allowInterrupt;
            }

            @Override
            public final java.lang.Number getFrequencyInSeconds() {
                return this.frequencyInSeconds;
            }

            @Override
            public final java.lang.Object getMessageGroupsList() {
                return this.messageGroupsList;
            }

            @Override
            public final java.lang.Number getTimeoutInSeconds() {
                return this.timeoutInSeconds;
            }

            @Override
            public final java.lang.Object getAllowInterrupt() {
                return this.allowInterrupt;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("frequencyInSeconds", om.valueToTree(this.getFrequencyInSeconds()));
                data.set("messageGroupsList", om.valueToTree(this.getMessageGroupsList()));
                data.set("timeoutInSeconds", om.valueToTree(this.getTimeoutInSeconds()));
                if (this.getAllowInterrupt() != null) {
                    data.set("allowInterrupt", om.valueToTree(this.getAllowInterrupt()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.StillWaitingResponseSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StillWaitingResponseSpecificationProperty.Jsii$Proxy that = (StillWaitingResponseSpecificationProperty.Jsii$Proxy) o;

                if (!frequencyInSeconds.equals(that.frequencyInSeconds)) return false;
                if (!messageGroupsList.equals(that.messageGroupsList)) return false;
                if (!timeoutInSeconds.equals(that.timeoutInSeconds)) return false;
                return this.allowInterrupt != null ? this.allowInterrupt.equals(that.allowInterrupt) : that.allowInterrupt == null;
            }

            @Override
            public final int hashCode() {
                int result = this.frequencyInSeconds.hashCode();
                result = 31 * result + (this.messageGroupsList.hashCode());
                result = 31 * result + (this.timeoutInSeconds.hashCode());
                result = 31 * result + (this.allowInterrupt != null ? this.allowInterrupt.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies configuration settings for the alias used to test the bot.
     * <p>
     * If the <code>TestBotAliasSettings</code> property is not specified, the settings are configured with default values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * Object sentimentAnalysisSettings;
     * TestBotAliasSettingsProperty testBotAliasSettingsProperty = TestBotAliasSettingsProperty.builder()
     *         .botAliasLocaleSettings(List.of(BotAliasLocaleSettingsItemProperty.builder()
     *                 .botAliasLocaleSetting(BotAliasLocaleSettingsProperty.builder()
     *                         .enabled(false)
     *                         // the properties below are optional
     *                         .codeHookSpecification(CodeHookSpecificationProperty.builder()
     *                                 .lambdaCodeHook(LambdaCodeHookProperty.builder()
     *                                         .codeHookInterfaceVersion("codeHookInterfaceVersion")
     *                                         .lambdaArn("lambdaArn")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .localeId("localeId")
     *                 .build()))
     *         .conversationLogSettings(ConversationLogSettingsProperty.builder()
     *                 .audioLogSettings(List.of(AudioLogSettingProperty.builder()
     *                         .destination(AudioLogDestinationProperty.builder()
     *                                 .s3Bucket(S3BucketLogDestinationProperty.builder()
     *                                         .logPrefix("logPrefix")
     *                                         .s3BucketArn("s3BucketArn")
     *                                         // the properties below are optional
     *                                         .kmsKeyArn("kmsKeyArn")
     *                                         .build())
     *                                 .build())
     *                         .enabled(false)
     *                         .build()))
     *                 .textLogSettings(List.of(TextLogSettingProperty.builder()
     *                         .destination(TextLogDestinationProperty.builder()
     *                                 .cloudWatch(CloudWatchLogGroupLogDestinationProperty.builder()
     *                                         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
     *                                         .logPrefix("logPrefix")
     *                                         .build())
     *                                 .build())
     *                         .enabled(false)
     *                         .build()))
     *                 .build())
     *         .description("description")
     *         .sentimentAnalysisSettings(sentimentAnalysisSettings)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.TestBotAliasSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(TestBotAliasSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TestBotAliasSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies settings that are unique to a locale.
         * <p>
         * For example, you can use a different Lambda function depending on the bot's locale.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBotAliasLocaleSettings() {
            return null;
        }

        /**
         * Specifies settings for conversation logs that save audio, text, and metadata information for conversations with your users.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConversationLogSettings() {
            return null;
        }

        /**
         * Specifies a description for the test bot alias.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Specifies whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSentimentAnalysisSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TestBotAliasSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TestBotAliasSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TestBotAliasSettingsProperty> {
            java.lang.Object botAliasLocaleSettings;
            java.lang.Object conversationLogSettings;
            java.lang.String description;
            java.lang.Object sentimentAnalysisSettings;

            /**
             * Sets the value of {@link TestBotAliasSettingsProperty#getBotAliasLocaleSettings}
             * @param botAliasLocaleSettings Specifies settings that are unique to a locale.
             *                               For example, you can use a different Lambda function depending on the bot's locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder botAliasLocaleSettings(software.amazon.awscdk.IResolvable botAliasLocaleSettings) {
                this.botAliasLocaleSettings = botAliasLocaleSettings;
                return this;
            }

            /**
             * Sets the value of {@link TestBotAliasSettingsProperty#getBotAliasLocaleSettings}
             * @param botAliasLocaleSettings Specifies settings that are unique to a locale.
             *                               For example, you can use a different Lambda function depending on the bot's locale.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder botAliasLocaleSettings(java.util.List<? extends java.lang.Object> botAliasLocaleSettings) {
                this.botAliasLocaleSettings = botAliasLocaleSettings;
                return this;
            }

            /**
             * Sets the value of {@link TestBotAliasSettingsProperty#getConversationLogSettings}
             * @param conversationLogSettings Specifies settings for conversation logs that save audio, text, and metadata information for conversations with your users.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conversationLogSettings(software.amazon.awscdk.services.lex.CfnBot.ConversationLogSettingsProperty conversationLogSettings) {
                this.conversationLogSettings = conversationLogSettings;
                return this;
            }

            /**
             * Sets the value of {@link TestBotAliasSettingsProperty#getConversationLogSettings}
             * @param conversationLogSettings Specifies settings for conversation logs that save audio, text, and metadata information for conversations with your users.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conversationLogSettings(software.amazon.awscdk.IResolvable conversationLogSettings) {
                this.conversationLogSettings = conversationLogSettings;
                return this;
            }

            /**
             * Sets the value of {@link TestBotAliasSettingsProperty#getDescription}
             * @param description Specifies a description for the test bot alias.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link TestBotAliasSettingsProperty#getSentimentAnalysisSettings}
             * @param sentimentAnalysisSettings Specifies whether Amazon Lex will use Amazon Comprehend to detect the sentiment of user utterances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sentimentAnalysisSettings(java.lang.Object sentimentAnalysisSettings) {
                this.sentimentAnalysisSettings = sentimentAnalysisSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TestBotAliasSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TestBotAliasSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TestBotAliasSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TestBotAliasSettingsProperty {
            private final java.lang.Object botAliasLocaleSettings;
            private final java.lang.Object conversationLogSettings;
            private final java.lang.String description;
            private final java.lang.Object sentimentAnalysisSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.botAliasLocaleSettings = software.amazon.jsii.Kernel.get(this, "botAliasLocaleSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.conversationLogSettings = software.amazon.jsii.Kernel.get(this, "conversationLogSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sentimentAnalysisSettings = software.amazon.jsii.Kernel.get(this, "sentimentAnalysisSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.botAliasLocaleSettings = builder.botAliasLocaleSettings;
                this.conversationLogSettings = builder.conversationLogSettings;
                this.description = builder.description;
                this.sentimentAnalysisSettings = builder.sentimentAnalysisSettings;
            }

            @Override
            public final java.lang.Object getBotAliasLocaleSettings() {
                return this.botAliasLocaleSettings;
            }

            @Override
            public final java.lang.Object getConversationLogSettings() {
                return this.conversationLogSettings;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getSentimentAnalysisSettings() {
                return this.sentimentAnalysisSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBotAliasLocaleSettings() != null) {
                    data.set("botAliasLocaleSettings", om.valueToTree(this.getBotAliasLocaleSettings()));
                }
                if (this.getConversationLogSettings() != null) {
                    data.set("conversationLogSettings", om.valueToTree(this.getConversationLogSettings()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getSentimentAnalysisSettings() != null) {
                    data.set("sentimentAnalysisSettings", om.valueToTree(this.getSentimentAnalysisSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.TestBotAliasSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TestBotAliasSettingsProperty.Jsii$Proxy that = (TestBotAliasSettingsProperty.Jsii$Proxy) o;

                if (this.botAliasLocaleSettings != null ? !this.botAliasLocaleSettings.equals(that.botAliasLocaleSettings) : that.botAliasLocaleSettings != null) return false;
                if (this.conversationLogSettings != null ? !this.conversationLogSettings.equals(that.conversationLogSettings) : that.conversationLogSettings != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                return this.sentimentAnalysisSettings != null ? this.sentimentAnalysisSettings.equals(that.sentimentAnalysisSettings) : that.sentimentAnalysisSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.botAliasLocaleSettings != null ? this.botAliasLocaleSettings.hashCode() : 0;
                result = 31 * result + (this.conversationLogSettings != null ? this.conversationLogSettings.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.sentimentAnalysisSettings != null ? this.sentimentAnalysisSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the Amazon CloudWatch Logs destination log group for conversation text logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * TextLogDestinationProperty textLogDestinationProperty = TextLogDestinationProperty.builder()
     *         .cloudWatch(CloudWatchLogGroupLogDestinationProperty.builder()
     *                 .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
     *                 .logPrefix("logPrefix")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.TextLogDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(TextLogDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TextLogDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the Amazon CloudWatch Logs log group where text and metadata logs are delivered.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCloudWatch();

        /**
         * @return a {@link Builder} of {@link TextLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TextLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TextLogDestinationProperty> {
            java.lang.Object cloudWatch;

            /**
             * Sets the value of {@link TextLogDestinationProperty#getCloudWatch}
             * @param cloudWatch Specifies the Amazon CloudWatch Logs log group where text and metadata logs are delivered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatch(software.amazon.awscdk.services.lex.CfnBot.CloudWatchLogGroupLogDestinationProperty cloudWatch) {
                this.cloudWatch = cloudWatch;
                return this;
            }

            /**
             * Sets the value of {@link TextLogDestinationProperty#getCloudWatch}
             * @param cloudWatch Specifies the Amazon CloudWatch Logs log group where text and metadata logs are delivered. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatch(software.amazon.awscdk.IResolvable cloudWatch) {
                this.cloudWatch = cloudWatch;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TextLogDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TextLogDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TextLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TextLogDestinationProperty {
            private final java.lang.Object cloudWatch;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatch = software.amazon.jsii.Kernel.get(this, "cloudWatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatch = java.util.Objects.requireNonNull(builder.cloudWatch, "cloudWatch is required");
            }

            @Override
            public final java.lang.Object getCloudWatch() {
                return this.cloudWatch;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cloudWatch", om.valueToTree(this.getCloudWatch()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.TextLogDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TextLogDestinationProperty.Jsii$Proxy that = (TextLogDestinationProperty.Jsii$Proxy) o;

                return this.cloudWatch.equals(that.cloudWatch);
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatch.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies settings to enable conversation logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * TextLogSettingProperty textLogSettingProperty = TextLogSettingProperty.builder()
     *         .destination(TextLogDestinationProperty.builder()
     *                 .cloudWatch(CloudWatchLogGroupLogDestinationProperty.builder()
     *                         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
     *                         .logPrefix("logPrefix")
     *                         .build())
     *                 .build())
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.TextLogSettingProperty")
    @software.amazon.jsii.Jsii.Proxy(TextLogSettingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TextLogSettingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the Amazon CloudWatch Logs destination log group for conversation text logs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestination();

        /**
         * Specifies whether conversation logs should be stored for an alias.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link TextLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TextLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TextLogSettingProperty> {
            java.lang.Object destination;
            java.lang.Object enabled;

            /**
             * Sets the value of {@link TextLogSettingProperty#getDestination}
             * @param destination Specifies the Amazon CloudWatch Logs destination log group for conversation text logs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.lex.CfnBot.TextLogDestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link TextLogSettingProperty#getDestination}
             * @param destination Specifies the Amazon CloudWatch Logs destination log group for conversation text logs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link TextLogSettingProperty#getEnabled}
             * @param enabled Specifies whether conversation logs should be stored for an alias. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TextLogSettingProperty#getEnabled}
             * @param enabled Specifies whether conversation logs should be stored for an alias. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TextLogSettingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TextLogSettingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TextLogSettingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TextLogSettingProperty {
            private final java.lang.Object destination;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                data.set("enabled", om.valueToTree(this.getEnabled()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.TextLogSettingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TextLogSettingProperty.Jsii$Proxy that = (TextLogSettingProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                return this.enabled.equals(that.enabled);
            }

            @Override
            public final int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.enabled.hashCode());
                return result;
            }
        }
    }
    /**
     * Identifies the Amazon Polly voice used for audio interaction with the user.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * VoiceSettingsProperty voiceSettingsProperty = VoiceSettingsProperty.builder()
     *         .voiceId("voiceId")
     *         // the properties below are optional
     *         .engine("engine")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.VoiceSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(VoiceSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VoiceSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Polly voice used for voice interaction with the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVoiceId();

        /**
         * `CfnBot.VoiceSettingsProperty.Engine`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VoiceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VoiceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VoiceSettingsProperty> {
            java.lang.String voiceId;
            java.lang.String engine;

            /**
             * Sets the value of {@link VoiceSettingsProperty#getVoiceId}
             * @param voiceId The Amazon Polly voice used for voice interaction with the user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder voiceId(java.lang.String voiceId) {
                this.voiceId = voiceId;
                return this;
            }

            /**
             * Sets the value of {@link VoiceSettingsProperty#getEngine}
             * @param engine `CfnBot.VoiceSettingsProperty.Engine`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder engine(java.lang.String engine) {
                this.engine = engine;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VoiceSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VoiceSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VoiceSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VoiceSettingsProperty {
            private final java.lang.String voiceId;
            private final java.lang.String engine;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.voiceId = software.amazon.jsii.Kernel.get(this, "voiceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.voiceId = java.util.Objects.requireNonNull(builder.voiceId, "voiceId is required");
                this.engine = builder.engine;
            }

            @Override
            public final java.lang.String getVoiceId() {
                return this.voiceId;
            }

            @Override
            public final java.lang.String getEngine() {
                return this.engine;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("voiceId", om.valueToTree(this.getVoiceId()));
                if (this.getEngine() != null) {
                    data.set("engine", om.valueToTree(this.getEngine()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.VoiceSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VoiceSettingsProperty.Jsii$Proxy that = (VoiceSettingsProperty.Jsii$Proxy) o;

                if (!voiceId.equals(that.voiceId)) return false;
                return this.engine != null ? this.engine.equals(that.engine) : that.engine == null;
            }

            @Override
            public final int hashCode() {
                int result = this.voiceId.hashCode();
                result = 31 * result + (this.engine != null ? this.engine.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lex.*;
     * WaitAndContinueSpecificationProperty waitAndContinueSpecificationProperty = WaitAndContinueSpecificationProperty.builder()
     *         .continueResponse(ResponseSpecificationProperty.builder()
     *                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                         .message(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .variations(List.of(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 // the properties below are optional
     *                 .allowInterrupt(false)
     *                 .build())
     *         .waitingResponse(ResponseSpecificationProperty.builder()
     *                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                         .message(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .variations(List.of(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 // the properties below are optional
     *                 .allowInterrupt(false)
     *                 .build())
     *         // the properties below are optional
     *         .isActive(false)
     *         .stillWaitingResponse(StillWaitingResponseSpecificationProperty.builder()
     *                 .frequencyInSeconds(123)
     *                 .messageGroupsList(List.of(MessageGroupProperty.builder()
     *                         .message(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .variations(List.of(MessageProperty.builder()
     *                                 .customPayload(CustomPayloadProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .imageResponseCard(ImageResponseCardProperty.builder()
     *                                         .title("title")
     *                                         // the properties below are optional
     *                                         .buttons(List.of(ButtonProperty.builder()
     *                                                 .text("text")
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .imageUrl("imageUrl")
     *                                         .subtitle("subtitle")
     *                                         .build())
     *                                 .plainTextMessage(PlainTextMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .ssmlMessage(SSMLMessageProperty.builder()
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 .timeoutInSeconds(123)
     *                 // the properties below are optional
     *                 .allowInterrupt(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBot.WaitAndContinueSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(WaitAndContinueSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WaitAndContinueSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The response that Amazon Lex sends to indicate that the bot is ready to continue the conversation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getContinueResponse();

        /**
         * The response that Amazon Lex sends to indicate that the bot is waiting for the conversation to continue.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getWaitingResponse();

        /**
         * Specifies whether the bot will wait for a user to respond.
         * <p>
         * When this field is false, wait and continue responses for a slot aren't used and the bot expects an appropriate response within the configured timeout. If the IsActive field isn't specified, the default is true.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsActive() {
            return null;
        }

        /**
         * A response that Amazon Lex sends periodically to the user to indicate that the bot is still waiting for input from the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStillWaitingResponse() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WaitAndContinueSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WaitAndContinueSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WaitAndContinueSpecificationProperty> {
            java.lang.Object continueResponse;
            java.lang.Object waitingResponse;
            java.lang.Object isActive;
            java.lang.Object stillWaitingResponse;

            /**
             * Sets the value of {@link WaitAndContinueSpecificationProperty#getContinueResponse}
             * @param continueResponse The response that Amazon Lex sends to indicate that the bot is ready to continue the conversation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder continueResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty continueResponse) {
                this.continueResponse = continueResponse;
                return this;
            }

            /**
             * Sets the value of {@link WaitAndContinueSpecificationProperty#getContinueResponse}
             * @param continueResponse The response that Amazon Lex sends to indicate that the bot is ready to continue the conversation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder continueResponse(software.amazon.awscdk.IResolvable continueResponse) {
                this.continueResponse = continueResponse;
                return this;
            }

            /**
             * Sets the value of {@link WaitAndContinueSpecificationProperty#getWaitingResponse}
             * @param waitingResponse The response that Amazon Lex sends to indicate that the bot is waiting for the conversation to continue. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitingResponse(software.amazon.awscdk.services.lex.CfnBot.ResponseSpecificationProperty waitingResponse) {
                this.waitingResponse = waitingResponse;
                return this;
            }

            /**
             * Sets the value of {@link WaitAndContinueSpecificationProperty#getWaitingResponse}
             * @param waitingResponse The response that Amazon Lex sends to indicate that the bot is waiting for the conversation to continue. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitingResponse(software.amazon.awscdk.IResolvable waitingResponse) {
                this.waitingResponse = waitingResponse;
                return this;
            }

            /**
             * Sets the value of {@link WaitAndContinueSpecificationProperty#getIsActive}
             * @param isActive Specifies whether the bot will wait for a user to respond.
             *                 When this field is false, wait and continue responses for a slot aren't used and the bot expects an appropriate response within the configured timeout. If the IsActive field isn't specified, the default is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isActive(java.lang.Boolean isActive) {
                this.isActive = isActive;
                return this;
            }

            /**
             * Sets the value of {@link WaitAndContinueSpecificationProperty#getIsActive}
             * @param isActive Specifies whether the bot will wait for a user to respond.
             *                 When this field is false, wait and continue responses for a slot aren't used and the bot expects an appropriate response within the configured timeout. If the IsActive field isn't specified, the default is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isActive(software.amazon.awscdk.IResolvable isActive) {
                this.isActive = isActive;
                return this;
            }

            /**
             * Sets the value of {@link WaitAndContinueSpecificationProperty#getStillWaitingResponse}
             * @param stillWaitingResponse A response that Amazon Lex sends periodically to the user to indicate that the bot is still waiting for input from the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stillWaitingResponse(software.amazon.awscdk.services.lex.CfnBot.StillWaitingResponseSpecificationProperty stillWaitingResponse) {
                this.stillWaitingResponse = stillWaitingResponse;
                return this;
            }

            /**
             * Sets the value of {@link WaitAndContinueSpecificationProperty#getStillWaitingResponse}
             * @param stillWaitingResponse A response that Amazon Lex sends periodically to the user to indicate that the bot is still waiting for input from the user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stillWaitingResponse(software.amazon.awscdk.IResolvable stillWaitingResponse) {
                this.stillWaitingResponse = stillWaitingResponse;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WaitAndContinueSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WaitAndContinueSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WaitAndContinueSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WaitAndContinueSpecificationProperty {
            private final java.lang.Object continueResponse;
            private final java.lang.Object waitingResponse;
            private final java.lang.Object isActive;
            private final java.lang.Object stillWaitingResponse;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.continueResponse = software.amazon.jsii.Kernel.get(this, "continueResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.waitingResponse = software.amazon.jsii.Kernel.get(this, "waitingResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isActive = software.amazon.jsii.Kernel.get(this, "isActive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stillWaitingResponse = software.amazon.jsii.Kernel.get(this, "stillWaitingResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.continueResponse = java.util.Objects.requireNonNull(builder.continueResponse, "continueResponse is required");
                this.waitingResponse = java.util.Objects.requireNonNull(builder.waitingResponse, "waitingResponse is required");
                this.isActive = builder.isActive;
                this.stillWaitingResponse = builder.stillWaitingResponse;
            }

            @Override
            public final java.lang.Object getContinueResponse() {
                return this.continueResponse;
            }

            @Override
            public final java.lang.Object getWaitingResponse() {
                return this.waitingResponse;
            }

            @Override
            public final java.lang.Object getIsActive() {
                return this.isActive;
            }

            @Override
            public final java.lang.Object getStillWaitingResponse() {
                return this.stillWaitingResponse;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("continueResponse", om.valueToTree(this.getContinueResponse()));
                data.set("waitingResponse", om.valueToTree(this.getWaitingResponse()));
                if (this.getIsActive() != null) {
                    data.set("isActive", om.valueToTree(this.getIsActive()));
                }
                if (this.getStillWaitingResponse() != null) {
                    data.set("stillWaitingResponse", om.valueToTree(this.getStillWaitingResponse()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBot.WaitAndContinueSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WaitAndContinueSpecificationProperty.Jsii$Proxy that = (WaitAndContinueSpecificationProperty.Jsii$Proxy) o;

                if (!continueResponse.equals(that.continueResponse)) return false;
                if (!waitingResponse.equals(that.waitingResponse)) return false;
                if (this.isActive != null ? !this.isActive.equals(that.isActive) : that.isActive != null) return false;
                return this.stillWaitingResponse != null ? this.stillWaitingResponse.equals(that.stillWaitingResponse) : that.stillWaitingResponse == null;
            }

            @Override
            public final int hashCode() {
                int result = this.continueResponse.hashCode();
                result = 31 * result + (this.waitingResponse.hashCode());
                result = 31 * result + (this.isActive != null ? this.isActive.hashCode() : 0);
                result = 31 * result + (this.stillWaitingResponse != null ? this.stillWaitingResponse.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lex.CfnBot}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lex.CfnBot> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lex.CfnBotProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lex.CfnBotProps.Builder();
        }

        /**
         * Provides information on additional privacy protections Amazon Lex should use with the bot's data.
         * <p>
         * @return {@code this}
         * @param dataPrivacy Provides information on additional privacy protections Amazon Lex should use with the bot's data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataPrivacy(final java.lang.Object dataPrivacy) {
            this.props.dataPrivacy(dataPrivacy);
            return this;
        }

        /**
         * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
         * <p>
         * A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.
         * <p>
         * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
         * <p>
         * @return {@code this}
         * @param idleSessionTtlInSeconds The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleSessionTtlInSeconds(final java.lang.Number idleSessionTtlInSeconds) {
            this.props.idleSessionTtlInSeconds(idleSessionTtlInSeconds);
            return this;
        }

        /**
         * The name of the field to filter the list of bots.
         * <p>
         * @return {@code this}
         * @param name The name of the field to filter the list of bots. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.
         * <p>
         * @return {@code this}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role used to build and run the bot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * Indicates whether Amazon Lex V2 should automatically build the locales for the bot after a change.
         * <p>
         * @return {@code this}
         * @param autoBuildBotLocales Indicates whether Amazon Lex V2 should automatically build the locales for the bot after a change. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoBuildBotLocales(final java.lang.Boolean autoBuildBotLocales) {
            this.props.autoBuildBotLocales(autoBuildBotLocales);
            return this;
        }
        /**
         * Indicates whether Amazon Lex V2 should automatically build the locales for the bot after a change.
         * <p>
         * @return {@code this}
         * @param autoBuildBotLocales Indicates whether Amazon Lex V2 should automatically build the locales for the bot after a change. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoBuildBotLocales(final software.amazon.awscdk.IResolvable autoBuildBotLocales) {
            this.props.autoBuildBotLocales(autoBuildBotLocales);
            return this;
        }

        /**
         * The Amazon S3 location of files used to import a bot.
         * <p>
         * The files must be in the import format specified in <a href="https://docs.aws.amazon.com/lexv2/latest/dg/import-export-format.html">JSON format for importing and exporting</a> in the <em>Amazon Lex developer guide.</em>
         * <p>
         * @return {@code this}
         * @param botFileS3Location The Amazon S3 location of files used to import a bot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botFileS3Location(final software.amazon.awscdk.services.lex.CfnBot.S3LocationProperty botFileS3Location) {
            this.props.botFileS3Location(botFileS3Location);
            return this;
        }
        /**
         * The Amazon S3 location of files used to import a bot.
         * <p>
         * The files must be in the import format specified in <a href="https://docs.aws.amazon.com/lexv2/latest/dg/import-export-format.html">JSON format for importing and exporting</a> in the <em>Amazon Lex developer guide.</em>
         * <p>
         * @return {@code this}
         * @param botFileS3Location The Amazon S3 location of files used to import a bot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botFileS3Location(final software.amazon.awscdk.IResolvable botFileS3Location) {
            this.props.botFileS3Location(botFileS3Location);
            return this;
        }

        /**
         * A list of locales for the bot.
         * <p>
         * @return {@code this}
         * @param botLocales A list of locales for the bot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botLocales(final software.amazon.awscdk.IResolvable botLocales) {
            this.props.botLocales(botLocales);
            return this;
        }
        /**
         * A list of locales for the bot.
         * <p>
         * @return {@code this}
         * @param botLocales A list of locales for the bot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botLocales(final java.util.List<? extends java.lang.Object> botLocales) {
            this.props.botLocales(botLocales);
            return this;
        }

        /**
         * A list of tags to add to the bot.
         * <p>
         * You can only add tags when you import a bot. You can't use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.
         * <p>
         * @return {@code this}
         * @param botTags A list of tags to add to the bot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botTags(final software.amazon.awscdk.IResolvable botTags) {
            this.props.botTags(botTags);
            return this;
        }
        /**
         * A list of tags to add to the bot.
         * <p>
         * You can only add tags when you import a bot. You can't use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.
         * <p>
         * @return {@code this}
         * @param botTags A list of tags to add to the bot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botTags(final java.util.List<? extends java.lang.Object> botTags) {
            this.props.botTags(botTags);
            return this;
        }

        /**
         * The description of the version.
         * <p>
         * @return {@code this}
         * @param description The description of the version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Specifies configuration settings for the alias used to test the bot.
         * <p>
         * If the <code>TestBotAliasSettings</code> property is not specified, the settings are configured with default values.
         * <p>
         * @return {@code this}
         * @param testBotAliasSettings Specifies configuration settings for the alias used to test the bot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testBotAliasSettings(final software.amazon.awscdk.services.lex.CfnBot.TestBotAliasSettingsProperty testBotAliasSettings) {
            this.props.testBotAliasSettings(testBotAliasSettings);
            return this;
        }
        /**
         * Specifies configuration settings for the alias used to test the bot.
         * <p>
         * If the <code>TestBotAliasSettings</code> property is not specified, the settings are configured with default values.
         * <p>
         * @return {@code this}
         * @param testBotAliasSettings Specifies configuration settings for the alias used to test the bot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testBotAliasSettings(final software.amazon.awscdk.IResolvable testBotAliasSettings) {
            this.props.testBotAliasSettings(testBotAliasSettings);
            return this;
        }

        /**
         * A list of tags to add to the test alias for a bot.
         * <p>
         * You can only add tags when you import a bot. You can't use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.
         * <p>
         * @return {@code this}
         * @param testBotAliasTags A list of tags to add to the test alias for a bot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testBotAliasTags(final software.amazon.awscdk.IResolvable testBotAliasTags) {
            this.props.testBotAliasTags(testBotAliasTags);
            return this;
        }
        /**
         * A list of tags to add to the test alias for a bot.
         * <p>
         * You can only add tags when you import a bot. You can't use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.
         * <p>
         * @return {@code this}
         * @param testBotAliasTags A list of tags to add to the test alias for a bot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testBotAliasTags(final java.util.List<? extends java.lang.Object> testBotAliasTags) {
            this.props.testBotAliasTags(testBotAliasTags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lex.CfnBot}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lex.CfnBot build() {
            return new software.amazon.awscdk.services.lex.CfnBot(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
