package software.amazon.awscdk.services.lakeformation;

/**
 * A CloudFormation `AWS::LakeFormation::PrincipalPermissions`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lakeformation.*;
 * Object catalog;
 * Object tableWildcard;
 * CfnPrincipalPermissions cfnPrincipalPermissions = CfnPrincipalPermissions.Builder.create(this, "MyCfnPrincipalPermissions")
 *         .permissions(List.of("permissions"))
 *         .permissionsWithGrantOption(List.of("permissionsWithGrantOption"))
 *         .principal(DataLakePrincipalProperty.builder()
 *                 .dataLakePrincipalIdentifier("dataLakePrincipalIdentifier")
 *                 .build())
 *         .resource(ResourceProperty.builder()
 *                 .catalog(catalog)
 *                 .database(DatabaseResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .name("name")
 *                         .build())
 *                 .dataCellsFilter(DataCellsFilterResourceProperty.builder()
 *                         .databaseName("databaseName")
 *                         .name("name")
 *                         .tableCatalogId("tableCatalogId")
 *                         .tableName("tableName")
 *                         .build())
 *                 .dataLocation(DataLocationResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .resourceArn("resourceArn")
 *                         .build())
 *                 .lfTag(LFTagKeyResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .tagKey("tagKey")
 *                         .tagValues(List.of("tagValues"))
 *                         .build())
 *                 .lfTagPolicy(LFTagPolicyResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .expression(List.of(LFTagProperty.builder()
 *                                 .tagKey("tagKey")
 *                                 .tagValues(List.of("tagValues"))
 *                                 .build()))
 *                         .resourceType("resourceType")
 *                         .build())
 *                 .table(TableResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .databaseName("databaseName")
 *                         // the properties below are optional
 *                         .name("name")
 *                         .tableWildcard(tableWildcard)
 *                         .build())
 *                 .tableWithColumns(TableWithColumnsResourceProperty.builder()
 *                         .catalogId("catalogId")
 *                         .databaseName("databaseName")
 *                         .name("name")
 *                         // the properties below are optional
 *                         .columnNames(List.of("columnNames"))
 *                         .columnWildcard(ColumnWildcardProperty.builder()
 *                                 .excludedColumnNames(List.of("excludedColumnNames"))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .catalog("catalog")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:52.659Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions")
public class CfnPrincipalPermissions extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnPrincipalPermissions(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPrincipalPermissions(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::LakeFormation::PrincipalPermissions`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPrincipalPermissions(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissionsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPrincipalIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "attrPrincipalIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::LakeFormation::PrincipalPermissions.Permissions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getPermissions() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * `AWS::LakeFormation::PrincipalPermissions.Permissions`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "permissions", java.util.Objects.requireNonNull(value, "permissions is required"));
    }

    /**
     * `AWS::LakeFormation::PrincipalPermissions.PermissionsWithGrantOption`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getPermissionsWithGrantOption() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "permissionsWithGrantOption", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * `AWS::LakeFormation::PrincipalPermissions.PermissionsWithGrantOption`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissionsWithGrantOption(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "permissionsWithGrantOption", java.util.Objects.requireNonNull(value, "permissionsWithGrantOption is required"));
    }

    /**
     * `AWS::LakeFormation::PrincipalPermissions.Principal`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::LakeFormation::PrincipalPermissions.Principal`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrincipal(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.DataLakePrincipalProperty value) {
        software.amazon.jsii.Kernel.set(this, "principal", java.util.Objects.requireNonNull(value, "principal is required"));
    }

    /**
     * `AWS::LakeFormation::PrincipalPermissions.Principal`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrincipal(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "principal", java.util.Objects.requireNonNull(value, "principal is required"));
    }

    /**
     * `AWS::LakeFormation::PrincipalPermissions.Resource`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getResource() {
        return software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::LakeFormation::PrincipalPermissions.Resource`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.ResourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "resource", java.util.Objects.requireNonNull(value, "resource is required"));
    }

    /**
     * `AWS::LakeFormation::PrincipalPermissions.Resource`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resource", java.util.Objects.requireNonNull(value, "resource is required"));
    }

    /**
     * `AWS::LakeFormation::PrincipalPermissions.Catalog`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCatalog() {
        return software.amazon.jsii.Kernel.get(this, "catalog", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::LakeFormation::PrincipalPermissions.Catalog`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCatalog(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "catalog", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * ColumnWildcardProperty columnWildcardProperty = ColumnWildcardProperty.builder()
     *         .excludedColumnNames(List.of("excludedColumnNames"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.ColumnWildcardProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnWildcardProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnWildcardProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPrincipalPermissions.ColumnWildcardProperty.ExcludedColumnNames`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedColumnNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnWildcardProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnWildcardProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnWildcardProperty> {
            java.util.List<java.lang.String> excludedColumnNames;

            /**
             * Sets the value of {@link ColumnWildcardProperty#getExcludedColumnNames}
             * @param excludedColumnNames `CfnPrincipalPermissions.ColumnWildcardProperty.ExcludedColumnNames`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedColumnNames(java.util.List<java.lang.String> excludedColumnNames) {
                this.excludedColumnNames = excludedColumnNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnWildcardProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnWildcardProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnWildcardProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnWildcardProperty {
            private final java.util.List<java.lang.String> excludedColumnNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.excludedColumnNames = software.amazon.jsii.Kernel.get(this, "excludedColumnNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.excludedColumnNames = builder.excludedColumnNames;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludedColumnNames() {
                return this.excludedColumnNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExcludedColumnNames() != null) {
                    data.set("excludedColumnNames", om.valueToTree(this.getExcludedColumnNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.ColumnWildcardProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnWildcardProperty.Jsii$Proxy that = (ColumnWildcardProperty.Jsii$Proxy) o;

                return this.excludedColumnNames != null ? this.excludedColumnNames.equals(that.excludedColumnNames) : that.excludedColumnNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.excludedColumnNames != null ? this.excludedColumnNames.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * DataCellsFilterResourceProperty dataCellsFilterResourceProperty = DataCellsFilterResourceProperty.builder()
     *         .databaseName("databaseName")
     *         .name("name")
     *         .tableCatalogId("tableCatalogId")
     *         .tableName("tableName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.DataCellsFilterResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(DataCellsFilterResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataCellsFilterResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPrincipalPermissions.DataCellsFilterResourceProperty.DatabaseName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * `CfnPrincipalPermissions.DataCellsFilterResourceProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnPrincipalPermissions.DataCellsFilterResourceProperty.TableCatalogId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableCatalogId();

        /**
         * `CfnPrincipalPermissions.DataCellsFilterResourceProperty.TableName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * @return a {@link Builder} of {@link DataCellsFilterResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataCellsFilterResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataCellsFilterResourceProperty> {
            java.lang.String databaseName;
            java.lang.String name;
            java.lang.String tableCatalogId;
            java.lang.String tableName;

            /**
             * Sets the value of {@link DataCellsFilterResourceProperty#getDatabaseName}
             * @param databaseName `CfnPrincipalPermissions.DataCellsFilterResourceProperty.DatabaseName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link DataCellsFilterResourceProperty#getName}
             * @param name `CfnPrincipalPermissions.DataCellsFilterResourceProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DataCellsFilterResourceProperty#getTableCatalogId}
             * @param tableCatalogId `CfnPrincipalPermissions.DataCellsFilterResourceProperty.TableCatalogId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableCatalogId(java.lang.String tableCatalogId) {
                this.tableCatalogId = tableCatalogId;
                return this;
            }

            /**
             * Sets the value of {@link DataCellsFilterResourceProperty#getTableName}
             * @param tableName `CfnPrincipalPermissions.DataCellsFilterResourceProperty.TableName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataCellsFilterResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataCellsFilterResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataCellsFilterResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataCellsFilterResourceProperty {
            private final java.lang.String databaseName;
            private final java.lang.String name;
            private final java.lang.String tableCatalogId;
            private final java.lang.String tableName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableCatalogId = software.amazon.jsii.Kernel.get(this, "tableCatalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.tableCatalogId = java.util.Objects.requireNonNull(builder.tableCatalogId, "tableCatalogId is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getTableCatalogId() {
                return this.tableCatalogId;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("tableCatalogId", om.valueToTree(this.getTableCatalogId()));
                data.set("tableName", om.valueToTree(this.getTableName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.DataCellsFilterResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataCellsFilterResourceProperty.Jsii$Proxy that = (DataCellsFilterResourceProperty.Jsii$Proxy) o;

                if (!databaseName.equals(that.databaseName)) return false;
                if (!name.equals(that.name)) return false;
                if (!tableCatalogId.equals(that.tableCatalogId)) return false;
                return this.tableName.equals(that.tableName);
            }

            @Override
            public final int hashCode() {
                int result = this.databaseName.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.tableCatalogId.hashCode());
                result = 31 * result + (this.tableName.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * DataLakePrincipalProperty dataLakePrincipalProperty = DataLakePrincipalProperty.builder()
     *         .dataLakePrincipalIdentifier("dataLakePrincipalIdentifier")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.DataLakePrincipalProperty")
    @software.amazon.jsii.Jsii.Proxy(DataLakePrincipalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataLakePrincipalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPrincipalPermissions.DataLakePrincipalProperty.DataLakePrincipalIdentifier`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataLakePrincipalIdentifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataLakePrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataLakePrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataLakePrincipalProperty> {
            java.lang.String dataLakePrincipalIdentifier;

            /**
             * Sets the value of {@link DataLakePrincipalProperty#getDataLakePrincipalIdentifier}
             * @param dataLakePrincipalIdentifier `CfnPrincipalPermissions.DataLakePrincipalProperty.DataLakePrincipalIdentifier`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataLakePrincipalIdentifier(java.lang.String dataLakePrincipalIdentifier) {
                this.dataLakePrincipalIdentifier = dataLakePrincipalIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataLakePrincipalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataLakePrincipalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataLakePrincipalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataLakePrincipalProperty {
            private final java.lang.String dataLakePrincipalIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataLakePrincipalIdentifier = software.amazon.jsii.Kernel.get(this, "dataLakePrincipalIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataLakePrincipalIdentifier = builder.dataLakePrincipalIdentifier;
            }

            @Override
            public final java.lang.String getDataLakePrincipalIdentifier() {
                return this.dataLakePrincipalIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataLakePrincipalIdentifier() != null) {
                    data.set("dataLakePrincipalIdentifier", om.valueToTree(this.getDataLakePrincipalIdentifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.DataLakePrincipalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataLakePrincipalProperty.Jsii$Proxy that = (DataLakePrincipalProperty.Jsii$Proxy) o;

                return this.dataLakePrincipalIdentifier != null ? this.dataLakePrincipalIdentifier.equals(that.dataLakePrincipalIdentifier) : that.dataLakePrincipalIdentifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataLakePrincipalIdentifier != null ? this.dataLakePrincipalIdentifier.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * DataLocationResourceProperty dataLocationResourceProperty = DataLocationResourceProperty.builder()
     *         .catalogId("catalogId")
     *         .resourceArn("resourceArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.DataLocationResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(DataLocationResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataLocationResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPrincipalPermissions.DataLocationResourceProperty.CatalogId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCatalogId();

        /**
         * `CfnPrincipalPermissions.DataLocationResourceProperty.ResourceArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceArn();

        /**
         * @return a {@link Builder} of {@link DataLocationResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataLocationResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataLocationResourceProperty> {
            java.lang.String catalogId;
            java.lang.String resourceArn;

            /**
             * Sets the value of {@link DataLocationResourceProperty#getCatalogId}
             * @param catalogId `CfnPrincipalPermissions.DataLocationResourceProperty.CatalogId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link DataLocationResourceProperty#getResourceArn}
             * @param resourceArn `CfnPrincipalPermissions.DataLocationResourceProperty.ResourceArn`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataLocationResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataLocationResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataLocationResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataLocationResourceProperty {
            private final java.lang.String catalogId;
            private final java.lang.String resourceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogId = java.util.Objects.requireNonNull(builder.catalogId, "catalogId is required");
                this.resourceArn = java.util.Objects.requireNonNull(builder.resourceArn, "resourceArn is required");
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("catalogId", om.valueToTree(this.getCatalogId()));
                data.set("resourceArn", om.valueToTree(this.getResourceArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.DataLocationResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataLocationResourceProperty.Jsii$Proxy that = (DataLocationResourceProperty.Jsii$Proxy) o;

                if (!catalogId.equals(that.catalogId)) return false;
                return this.resourceArn.equals(that.resourceArn);
            }

            @Override
            public final int hashCode() {
                int result = this.catalogId.hashCode();
                result = 31 * result + (this.resourceArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * DatabaseResourceProperty databaseResourceProperty = DatabaseResourceProperty.builder()
     *         .catalogId("catalogId")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.DatabaseResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabaseResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabaseResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPrincipalPermissions.DatabaseResourceProperty.CatalogId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCatalogId();

        /**
         * `CfnPrincipalPermissions.DatabaseResourceProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link DatabaseResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabaseResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabaseResourceProperty> {
            java.lang.String catalogId;
            java.lang.String name;

            /**
             * Sets the value of {@link DatabaseResourceProperty#getCatalogId}
             * @param catalogId `CfnPrincipalPermissions.DatabaseResourceProperty.CatalogId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseResourceProperty#getName}
             * @param name `CfnPrincipalPermissions.DatabaseResourceProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabaseResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabaseResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabaseResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseResourceProperty {
            private final java.lang.String catalogId;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogId = java.util.Objects.requireNonNull(builder.catalogId, "catalogId is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("catalogId", om.valueToTree(this.getCatalogId()));
                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.DatabaseResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabaseResourceProperty.Jsii$Proxy that = (DatabaseResourceProperty.Jsii$Proxy) o;

                if (!catalogId.equals(that.catalogId)) return false;
                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.catalogId.hashCode();
                result = 31 * result + (this.name.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * LFTagKeyResourceProperty lFTagKeyResourceProperty = LFTagKeyResourceProperty.builder()
     *         .catalogId("catalogId")
     *         .tagKey("tagKey")
     *         .tagValues(List.of("tagValues"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.LFTagKeyResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(LFTagKeyResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LFTagKeyResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPrincipalPermissions.LFTagKeyResourceProperty.CatalogId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCatalogId();

        /**
         * `CfnPrincipalPermissions.LFTagKeyResourceProperty.TagKey`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTagKey();

        /**
         * `CfnPrincipalPermissions.LFTagKeyResourceProperty.TagValues`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTagValues();

        /**
         * @return a {@link Builder} of {@link LFTagKeyResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LFTagKeyResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LFTagKeyResourceProperty> {
            java.lang.String catalogId;
            java.lang.String tagKey;
            java.util.List<java.lang.String> tagValues;

            /**
             * Sets the value of {@link LFTagKeyResourceProperty#getCatalogId}
             * @param catalogId `CfnPrincipalPermissions.LFTagKeyResourceProperty.CatalogId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link LFTagKeyResourceProperty#getTagKey}
             * @param tagKey `CfnPrincipalPermissions.LFTagKeyResourceProperty.TagKey`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagKey(java.lang.String tagKey) {
                this.tagKey = tagKey;
                return this;
            }

            /**
             * Sets the value of {@link LFTagKeyResourceProperty#getTagValues}
             * @param tagValues `CfnPrincipalPermissions.LFTagKeyResourceProperty.TagValues`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagValues(java.util.List<java.lang.String> tagValues) {
                this.tagValues = tagValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LFTagKeyResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LFTagKeyResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LFTagKeyResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LFTagKeyResourceProperty {
            private final java.lang.String catalogId;
            private final java.lang.String tagKey;
            private final java.util.List<java.lang.String> tagValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagKey = software.amazon.jsii.Kernel.get(this, "tagKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagValues = software.amazon.jsii.Kernel.get(this, "tagValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogId = java.util.Objects.requireNonNull(builder.catalogId, "catalogId is required");
                this.tagKey = java.util.Objects.requireNonNull(builder.tagKey, "tagKey is required");
                this.tagValues = java.util.Objects.requireNonNull(builder.tagValues, "tagValues is required");
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.String getTagKey() {
                return this.tagKey;
            }

            @Override
            public final java.util.List<java.lang.String> getTagValues() {
                return this.tagValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("catalogId", om.valueToTree(this.getCatalogId()));
                data.set("tagKey", om.valueToTree(this.getTagKey()));
                data.set("tagValues", om.valueToTree(this.getTagValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.LFTagKeyResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LFTagKeyResourceProperty.Jsii$Proxy that = (LFTagKeyResourceProperty.Jsii$Proxy) o;

                if (!catalogId.equals(that.catalogId)) return false;
                if (!tagKey.equals(that.tagKey)) return false;
                return this.tagValues.equals(that.tagValues);
            }

            @Override
            public final int hashCode() {
                int result = this.catalogId.hashCode();
                result = 31 * result + (this.tagKey.hashCode());
                result = 31 * result + (this.tagValues.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * LFTagPolicyResourceProperty lFTagPolicyResourceProperty = LFTagPolicyResourceProperty.builder()
     *         .catalogId("catalogId")
     *         .expression(List.of(LFTagProperty.builder()
     *                 .tagKey("tagKey")
     *                 .tagValues(List.of("tagValues"))
     *                 .build()))
     *         .resourceType("resourceType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.LFTagPolicyResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(LFTagPolicyResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LFTagPolicyResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPrincipalPermissions.LFTagPolicyResourceProperty.CatalogId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCatalogId();

        /**
         * `CfnPrincipalPermissions.LFTagPolicyResourceProperty.Expression`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getExpression();

        /**
         * `CfnPrincipalPermissions.LFTagPolicyResourceProperty.ResourceType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceType();

        /**
         * @return a {@link Builder} of {@link LFTagPolicyResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LFTagPolicyResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LFTagPolicyResourceProperty> {
            java.lang.String catalogId;
            java.lang.Object expression;
            java.lang.String resourceType;

            /**
             * Sets the value of {@link LFTagPolicyResourceProperty#getCatalogId}
             * @param catalogId `CfnPrincipalPermissions.LFTagPolicyResourceProperty.CatalogId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link LFTagPolicyResourceProperty#getExpression}
             * @param expression `CfnPrincipalPermissions.LFTagPolicyResourceProperty.Expression`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(software.amazon.awscdk.IResolvable expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link LFTagPolicyResourceProperty#getExpression}
             * @param expression `CfnPrincipalPermissions.LFTagPolicyResourceProperty.Expression`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.util.List<? extends java.lang.Object> expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link LFTagPolicyResourceProperty#getResourceType}
             * @param resourceType `CfnPrincipalPermissions.LFTagPolicyResourceProperty.ResourceType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LFTagPolicyResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LFTagPolicyResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LFTagPolicyResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LFTagPolicyResourceProperty {
            private final java.lang.String catalogId;
            private final java.lang.Object expression;
            private final java.lang.String resourceType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogId = java.util.Objects.requireNonNull(builder.catalogId, "catalogId is required");
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
                this.resourceType = java.util.Objects.requireNonNull(builder.resourceType, "resourceType is required");
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.Object getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("catalogId", om.valueToTree(this.getCatalogId()));
                data.set("expression", om.valueToTree(this.getExpression()));
                data.set("resourceType", om.valueToTree(this.getResourceType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.LFTagPolicyResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LFTagPolicyResourceProperty.Jsii$Proxy that = (LFTagPolicyResourceProperty.Jsii$Proxy) o;

                if (!catalogId.equals(that.catalogId)) return false;
                if (!expression.equals(that.expression)) return false;
                return this.resourceType.equals(that.resourceType);
            }

            @Override
            public final int hashCode() {
                int result = this.catalogId.hashCode();
                result = 31 * result + (this.expression.hashCode());
                result = 31 * result + (this.resourceType.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * LFTagProperty lFTagProperty = LFTagProperty.builder()
     *         .tagKey("tagKey")
     *         .tagValues(List.of("tagValues"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.LFTagProperty")
    @software.amazon.jsii.Jsii.Proxy(LFTagProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LFTagProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPrincipalPermissions.LFTagProperty.TagKey`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTagKey() {
            return null;
        }

        /**
         * `CfnPrincipalPermissions.LFTagProperty.TagValues`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTagValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LFTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LFTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LFTagProperty> {
            java.lang.String tagKey;
            java.util.List<java.lang.String> tagValues;

            /**
             * Sets the value of {@link LFTagProperty#getTagKey}
             * @param tagKey `CfnPrincipalPermissions.LFTagProperty.TagKey`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagKey(java.lang.String tagKey) {
                this.tagKey = tagKey;
                return this;
            }

            /**
             * Sets the value of {@link LFTagProperty#getTagValues}
             * @param tagValues `CfnPrincipalPermissions.LFTagProperty.TagValues`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagValues(java.util.List<java.lang.String> tagValues) {
                this.tagValues = tagValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LFTagProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LFTagProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LFTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LFTagProperty {
            private final java.lang.String tagKey;
            private final java.util.List<java.lang.String> tagValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.tagKey = software.amazon.jsii.Kernel.get(this, "tagKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagValues = software.amazon.jsii.Kernel.get(this, "tagValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.tagKey = builder.tagKey;
                this.tagValues = builder.tagValues;
            }

            @Override
            public final java.lang.String getTagKey() {
                return this.tagKey;
            }

            @Override
            public final java.util.List<java.lang.String> getTagValues() {
                return this.tagValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTagKey() != null) {
                    data.set("tagKey", om.valueToTree(this.getTagKey()));
                }
                if (this.getTagValues() != null) {
                    data.set("tagValues", om.valueToTree(this.getTagValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.LFTagProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LFTagProperty.Jsii$Proxy that = (LFTagProperty.Jsii$Proxy) o;

                if (this.tagKey != null ? !this.tagKey.equals(that.tagKey) : that.tagKey != null) return false;
                return this.tagValues != null ? this.tagValues.equals(that.tagValues) : that.tagValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.tagKey != null ? this.tagKey.hashCode() : 0;
                result = 31 * result + (this.tagValues != null ? this.tagValues.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * Object catalog;
     * Object tableWildcard;
     * ResourceProperty resourceProperty = ResourceProperty.builder()
     *         .catalog(catalog)
     *         .database(DatabaseResourceProperty.builder()
     *                 .catalogId("catalogId")
     *                 .name("name")
     *                 .build())
     *         .dataCellsFilter(DataCellsFilterResourceProperty.builder()
     *                 .databaseName("databaseName")
     *                 .name("name")
     *                 .tableCatalogId("tableCatalogId")
     *                 .tableName("tableName")
     *                 .build())
     *         .dataLocation(DataLocationResourceProperty.builder()
     *                 .catalogId("catalogId")
     *                 .resourceArn("resourceArn")
     *                 .build())
     *         .lfTag(LFTagKeyResourceProperty.builder()
     *                 .catalogId("catalogId")
     *                 .tagKey("tagKey")
     *                 .tagValues(List.of("tagValues"))
     *                 .build())
     *         .lfTagPolicy(LFTagPolicyResourceProperty.builder()
     *                 .catalogId("catalogId")
     *                 .expression(List.of(LFTagProperty.builder()
     *                         .tagKey("tagKey")
     *                         .tagValues(List.of("tagValues"))
     *                         .build()))
     *                 .resourceType("resourceType")
     *                 .build())
     *         .table(TableResourceProperty.builder()
     *                 .catalogId("catalogId")
     *                 .databaseName("databaseName")
     *                 // the properties below are optional
     *                 .name("name")
     *                 .tableWildcard(tableWildcard)
     *                 .build())
     *         .tableWithColumns(TableWithColumnsResourceProperty.builder()
     *                 .catalogId("catalogId")
     *                 .databaseName("databaseName")
     *                 .name("name")
     *                 // the properties below are optional
     *                 .columnNames(List.of("columnNames"))
     *                 .columnWildcard(ColumnWildcardProperty.builder()
     *                         .excludedColumnNames(List.of("excludedColumnNames"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.ResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPrincipalPermissions.ResourceProperty.Catalog`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCatalog() {
            return null;
        }

        /**
         * `CfnPrincipalPermissions.ResourceProperty.Database`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatabase() {
            return null;
        }

        /**
         * `CfnPrincipalPermissions.ResourceProperty.DataCellsFilter`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataCellsFilter() {
            return null;
        }

        /**
         * `CfnPrincipalPermissions.ResourceProperty.DataLocation`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataLocation() {
            return null;
        }

        /**
         * `CfnPrincipalPermissions.ResourceProperty.LFTag`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLfTag() {
            return null;
        }

        /**
         * `CfnPrincipalPermissions.ResourceProperty.LFTagPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLfTagPolicy() {
            return null;
        }

        /**
         * `CfnPrincipalPermissions.ResourceProperty.Table`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTable() {
            return null;
        }

        /**
         * `CfnPrincipalPermissions.ResourceProperty.TableWithColumns`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTableWithColumns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceProperty> {
            java.lang.Object catalog;
            java.lang.Object database;
            java.lang.Object dataCellsFilter;
            java.lang.Object dataLocation;
            java.lang.Object lfTag;
            java.lang.Object lfTagPolicy;
            java.lang.Object table;
            java.lang.Object tableWithColumns;

            /**
             * Sets the value of {@link ResourceProperty#getCatalog}
             * @param catalog `CfnPrincipalPermissions.ResourceProperty.Catalog`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalog(java.lang.Object catalog) {
                this.catalog = catalog;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getDatabase}
             * @param database `CfnPrincipalPermissions.ResourceProperty.Database`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.DatabaseResourceProperty database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getDatabase}
             * @param database `CfnPrincipalPermissions.ResourceProperty.Database`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(software.amazon.awscdk.IResolvable database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getDataCellsFilter}
             * @param dataCellsFilter `CfnPrincipalPermissions.ResourceProperty.DataCellsFilter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataCellsFilter(software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.DataCellsFilterResourceProperty dataCellsFilter) {
                this.dataCellsFilter = dataCellsFilter;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getDataCellsFilter}
             * @param dataCellsFilter `CfnPrincipalPermissions.ResourceProperty.DataCellsFilter`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataCellsFilter(software.amazon.awscdk.IResolvable dataCellsFilter) {
                this.dataCellsFilter = dataCellsFilter;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getDataLocation}
             * @param dataLocation `CfnPrincipalPermissions.ResourceProperty.DataLocation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataLocation(software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.DataLocationResourceProperty dataLocation) {
                this.dataLocation = dataLocation;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getDataLocation}
             * @param dataLocation `CfnPrincipalPermissions.ResourceProperty.DataLocation`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataLocation(software.amazon.awscdk.IResolvable dataLocation) {
                this.dataLocation = dataLocation;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getLfTag}
             * @param lfTag `CfnPrincipalPermissions.ResourceProperty.LFTag`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lfTag(software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.LFTagKeyResourceProperty lfTag) {
                this.lfTag = lfTag;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getLfTag}
             * @param lfTag `CfnPrincipalPermissions.ResourceProperty.LFTag`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lfTag(software.amazon.awscdk.IResolvable lfTag) {
                this.lfTag = lfTag;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getLfTagPolicy}
             * @param lfTagPolicy `CfnPrincipalPermissions.ResourceProperty.LFTagPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lfTagPolicy(software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.LFTagPolicyResourceProperty lfTagPolicy) {
                this.lfTagPolicy = lfTagPolicy;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getLfTagPolicy}
             * @param lfTagPolicy `CfnPrincipalPermissions.ResourceProperty.LFTagPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lfTagPolicy(software.amazon.awscdk.IResolvable lfTagPolicy) {
                this.lfTagPolicy = lfTagPolicy;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getTable}
             * @param table `CfnPrincipalPermissions.ResourceProperty.Table`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder table(software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.TableResourceProperty table) {
                this.table = table;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getTable}
             * @param table `CfnPrincipalPermissions.ResourceProperty.Table`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder table(software.amazon.awscdk.IResolvable table) {
                this.table = table;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getTableWithColumns}
             * @param tableWithColumns `CfnPrincipalPermissions.ResourceProperty.TableWithColumns`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableWithColumns(software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.TableWithColumnsResourceProperty tableWithColumns) {
                this.tableWithColumns = tableWithColumns;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getTableWithColumns}
             * @param tableWithColumns `CfnPrincipalPermissions.ResourceProperty.TableWithColumns`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableWithColumns(software.amazon.awscdk.IResolvable tableWithColumns) {
                this.tableWithColumns = tableWithColumns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceProperty {
            private final java.lang.Object catalog;
            private final java.lang.Object database;
            private final java.lang.Object dataCellsFilter;
            private final java.lang.Object dataLocation;
            private final java.lang.Object lfTag;
            private final java.lang.Object lfTagPolicy;
            private final java.lang.Object table;
            private final java.lang.Object tableWithColumns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalog = software.amazon.jsii.Kernel.get(this, "catalog", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataCellsFilter = software.amazon.jsii.Kernel.get(this, "dataCellsFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataLocation = software.amazon.jsii.Kernel.get(this, "dataLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lfTag = software.amazon.jsii.Kernel.get(this, "lfTag", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lfTagPolicy = software.amazon.jsii.Kernel.get(this, "lfTagPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.table = software.amazon.jsii.Kernel.get(this, "table", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tableWithColumns = software.amazon.jsii.Kernel.get(this, "tableWithColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalog = builder.catalog;
                this.database = builder.database;
                this.dataCellsFilter = builder.dataCellsFilter;
                this.dataLocation = builder.dataLocation;
                this.lfTag = builder.lfTag;
                this.lfTagPolicy = builder.lfTagPolicy;
                this.table = builder.table;
                this.tableWithColumns = builder.tableWithColumns;
            }

            @Override
            public final java.lang.Object getCatalog() {
                return this.catalog;
            }

            @Override
            public final java.lang.Object getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.Object getDataCellsFilter() {
                return this.dataCellsFilter;
            }

            @Override
            public final java.lang.Object getDataLocation() {
                return this.dataLocation;
            }

            @Override
            public final java.lang.Object getLfTag() {
                return this.lfTag;
            }

            @Override
            public final java.lang.Object getLfTagPolicy() {
                return this.lfTagPolicy;
            }

            @Override
            public final java.lang.Object getTable() {
                return this.table;
            }

            @Override
            public final java.lang.Object getTableWithColumns() {
                return this.tableWithColumns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCatalog() != null) {
                    data.set("catalog", om.valueToTree(this.getCatalog()));
                }
                if (this.getDatabase() != null) {
                    data.set("database", om.valueToTree(this.getDatabase()));
                }
                if (this.getDataCellsFilter() != null) {
                    data.set("dataCellsFilter", om.valueToTree(this.getDataCellsFilter()));
                }
                if (this.getDataLocation() != null) {
                    data.set("dataLocation", om.valueToTree(this.getDataLocation()));
                }
                if (this.getLfTag() != null) {
                    data.set("lfTag", om.valueToTree(this.getLfTag()));
                }
                if (this.getLfTagPolicy() != null) {
                    data.set("lfTagPolicy", om.valueToTree(this.getLfTagPolicy()));
                }
                if (this.getTable() != null) {
                    data.set("table", om.valueToTree(this.getTable()));
                }
                if (this.getTableWithColumns() != null) {
                    data.set("tableWithColumns", om.valueToTree(this.getTableWithColumns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.ResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceProperty.Jsii$Proxy that = (ResourceProperty.Jsii$Proxy) o;

                if (this.catalog != null ? !this.catalog.equals(that.catalog) : that.catalog != null) return false;
                if (this.database != null ? !this.database.equals(that.database) : that.database != null) return false;
                if (this.dataCellsFilter != null ? !this.dataCellsFilter.equals(that.dataCellsFilter) : that.dataCellsFilter != null) return false;
                if (this.dataLocation != null ? !this.dataLocation.equals(that.dataLocation) : that.dataLocation != null) return false;
                if (this.lfTag != null ? !this.lfTag.equals(that.lfTag) : that.lfTag != null) return false;
                if (this.lfTagPolicy != null ? !this.lfTagPolicy.equals(that.lfTagPolicy) : that.lfTagPolicy != null) return false;
                if (this.table != null ? !this.table.equals(that.table) : that.table != null) return false;
                return this.tableWithColumns != null ? this.tableWithColumns.equals(that.tableWithColumns) : that.tableWithColumns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalog != null ? this.catalog.hashCode() : 0;
                result = 31 * result + (this.database != null ? this.database.hashCode() : 0);
                result = 31 * result + (this.dataCellsFilter != null ? this.dataCellsFilter.hashCode() : 0);
                result = 31 * result + (this.dataLocation != null ? this.dataLocation.hashCode() : 0);
                result = 31 * result + (this.lfTag != null ? this.lfTag.hashCode() : 0);
                result = 31 * result + (this.lfTagPolicy != null ? this.lfTagPolicy.hashCode() : 0);
                result = 31 * result + (this.table != null ? this.table.hashCode() : 0);
                result = 31 * result + (this.tableWithColumns != null ? this.tableWithColumns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * Object tableWildcard;
     * TableResourceProperty tableResourceProperty = TableResourceProperty.builder()
     *         .catalogId("catalogId")
     *         .databaseName("databaseName")
     *         // the properties below are optional
     *         .name("name")
     *         .tableWildcard(tableWildcard)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.TableResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(TableResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TableResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPrincipalPermissions.TableResourceProperty.CatalogId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCatalogId();

        /**
         * `CfnPrincipalPermissions.TableResourceProperty.DatabaseName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * `CfnPrincipalPermissions.TableResourceProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * `CfnPrincipalPermissions.TableResourceProperty.TableWildcard`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTableWildcard() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TableResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TableResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TableResourceProperty> {
            java.lang.String catalogId;
            java.lang.String databaseName;
            java.lang.String name;
            java.lang.Object tableWildcard;

            /**
             * Sets the value of {@link TableResourceProperty#getCatalogId}
             * @param catalogId `CfnPrincipalPermissions.TableResourceProperty.CatalogId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link TableResourceProperty#getDatabaseName}
             * @param databaseName `CfnPrincipalPermissions.TableResourceProperty.DatabaseName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link TableResourceProperty#getName}
             * @param name `CfnPrincipalPermissions.TableResourceProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link TableResourceProperty#getTableWildcard}
             * @param tableWildcard `CfnPrincipalPermissions.TableResourceProperty.TableWildcard`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableWildcard(java.lang.Object tableWildcard) {
                this.tableWildcard = tableWildcard;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TableResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TableResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TableResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableResourceProperty {
            private final java.lang.String catalogId;
            private final java.lang.String databaseName;
            private final java.lang.String name;
            private final java.lang.Object tableWildcard;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableWildcard = software.amazon.jsii.Kernel.get(this, "tableWildcard", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogId = java.util.Objects.requireNonNull(builder.catalogId, "catalogId is required");
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.name = builder.name;
                this.tableWildcard = builder.tableWildcard;
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getTableWildcard() {
                return this.tableWildcard;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("catalogId", om.valueToTree(this.getCatalogId()));
                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getTableWildcard() != null) {
                    data.set("tableWildcard", om.valueToTree(this.getTableWildcard()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.TableResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TableResourceProperty.Jsii$Proxy that = (TableResourceProperty.Jsii$Proxy) o;

                if (!catalogId.equals(that.catalogId)) return false;
                if (!databaseName.equals(that.databaseName)) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.tableWildcard != null ? this.tableWildcard.equals(that.tableWildcard) : that.tableWildcard == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalogId.hashCode();
                result = 31 * result + (this.databaseName.hashCode());
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.tableWildcard != null ? this.tableWildcard.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * TableWithColumnsResourceProperty tableWithColumnsResourceProperty = TableWithColumnsResourceProperty.builder()
     *         .catalogId("catalogId")
     *         .databaseName("databaseName")
     *         .name("name")
     *         // the properties below are optional
     *         .columnNames(List.of("columnNames"))
     *         .columnWildcard(ColumnWildcardProperty.builder()
     *                 .excludedColumnNames(List.of("excludedColumnNames"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.TableWithColumnsResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(TableWithColumnsResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TableWithColumnsResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPrincipalPermissions.TableWithColumnsResourceProperty.CatalogId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCatalogId();

        /**
         * `CfnPrincipalPermissions.TableWithColumnsResourceProperty.DatabaseName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * `CfnPrincipalPermissions.TableWithColumnsResourceProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnPrincipalPermissions.TableWithColumnsResourceProperty.ColumnNames`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getColumnNames() {
            return null;
        }

        /**
         * `CfnPrincipalPermissions.TableWithColumnsResourceProperty.ColumnWildcard`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumnWildcard() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TableWithColumnsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TableWithColumnsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TableWithColumnsResourceProperty> {
            java.lang.String catalogId;
            java.lang.String databaseName;
            java.lang.String name;
            java.util.List<java.lang.String> columnNames;
            java.lang.Object columnWildcard;

            /**
             * Sets the value of {@link TableWithColumnsResourceProperty#getCatalogId}
             * @param catalogId `CfnPrincipalPermissions.TableWithColumnsResourceProperty.CatalogId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link TableWithColumnsResourceProperty#getDatabaseName}
             * @param databaseName `CfnPrincipalPermissions.TableWithColumnsResourceProperty.DatabaseName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link TableWithColumnsResourceProperty#getName}
             * @param name `CfnPrincipalPermissions.TableWithColumnsResourceProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link TableWithColumnsResourceProperty#getColumnNames}
             * @param columnNames `CfnPrincipalPermissions.TableWithColumnsResourceProperty.ColumnNames`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnNames(java.util.List<java.lang.String> columnNames) {
                this.columnNames = columnNames;
                return this;
            }

            /**
             * Sets the value of {@link TableWithColumnsResourceProperty#getColumnWildcard}
             * @param columnWildcard `CfnPrincipalPermissions.TableWithColumnsResourceProperty.ColumnWildcard`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnWildcard(software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.ColumnWildcardProperty columnWildcard) {
                this.columnWildcard = columnWildcard;
                return this;
            }

            /**
             * Sets the value of {@link TableWithColumnsResourceProperty#getColumnWildcard}
             * @param columnWildcard `CfnPrincipalPermissions.TableWithColumnsResourceProperty.ColumnWildcard`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnWildcard(software.amazon.awscdk.IResolvable columnWildcard) {
                this.columnWildcard = columnWildcard;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TableWithColumnsResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TableWithColumnsResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TableWithColumnsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableWithColumnsResourceProperty {
            private final java.lang.String catalogId;
            private final java.lang.String databaseName;
            private final java.lang.String name;
            private final java.util.List<java.lang.String> columnNames;
            private final java.lang.Object columnWildcard;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.columnNames = software.amazon.jsii.Kernel.get(this, "columnNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.columnWildcard = software.amazon.jsii.Kernel.get(this, "columnWildcard", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogId = java.util.Objects.requireNonNull(builder.catalogId, "catalogId is required");
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.columnNames = builder.columnNames;
                this.columnWildcard = builder.columnWildcard;
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.List<java.lang.String> getColumnNames() {
                return this.columnNames;
            }

            @Override
            public final java.lang.Object getColumnWildcard() {
                return this.columnWildcard;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("catalogId", om.valueToTree(this.getCatalogId()));
                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getColumnNames() != null) {
                    data.set("columnNames", om.valueToTree(this.getColumnNames()));
                }
                if (this.getColumnWildcard() != null) {
                    data.set("columnWildcard", om.valueToTree(this.getColumnWildcard()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnPrincipalPermissions.TableWithColumnsResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TableWithColumnsResourceProperty.Jsii$Proxy that = (TableWithColumnsResourceProperty.Jsii$Proxy) o;

                if (!catalogId.equals(that.catalogId)) return false;
                if (!databaseName.equals(that.databaseName)) return false;
                if (!name.equals(that.name)) return false;
                if (this.columnNames != null ? !this.columnNames.equals(that.columnNames) : that.columnNames != null) return false;
                return this.columnWildcard != null ? this.columnWildcard.equals(that.columnWildcard) : that.columnWildcard == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalogId.hashCode();
                result = 31 * result + (this.databaseName.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.columnNames != null ? this.columnNames.hashCode() : 0);
                result = 31 * result + (this.columnWildcard != null ? this.columnWildcard.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissionsProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissionsProps.Builder();
        }

        /**
         * `AWS::LakeFormation::PrincipalPermissions.Permissions`.
         * <p>
         * @return {@code this}
         * @param permissions `AWS::LakeFormation::PrincipalPermissions.Permissions`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(final java.util.List<java.lang.String> permissions) {
            this.props.permissions(permissions);
            return this;
        }

        /**
         * `AWS::LakeFormation::PrincipalPermissions.PermissionsWithGrantOption`.
         * <p>
         * @return {@code this}
         * @param permissionsWithGrantOption `AWS::LakeFormation::PrincipalPermissions.PermissionsWithGrantOption`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsWithGrantOption(final java.util.List<java.lang.String> permissionsWithGrantOption) {
            this.props.permissionsWithGrantOption(permissionsWithGrantOption);
            return this;
        }

        /**
         * `AWS::LakeFormation::PrincipalPermissions.Principal`.
         * <p>
         * @return {@code this}
         * @param principal `AWS::LakeFormation::PrincipalPermissions.Principal`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(final software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.DataLakePrincipalProperty principal) {
            this.props.principal(principal);
            return this;
        }
        /**
         * `AWS::LakeFormation::PrincipalPermissions.Principal`.
         * <p>
         * @return {@code this}
         * @param principal `AWS::LakeFormation::PrincipalPermissions.Principal`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(final software.amazon.awscdk.IResolvable principal) {
            this.props.principal(principal);
            return this;
        }

        /**
         * `AWS::LakeFormation::PrincipalPermissions.Resource`.
         * <p>
         * @return {@code this}
         * @param resource `AWS::LakeFormation::PrincipalPermissions.Resource`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(final software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.ResourceProperty resource) {
            this.props.resource(resource);
            return this;
        }
        /**
         * `AWS::LakeFormation::PrincipalPermissions.Resource`.
         * <p>
         * @return {@code this}
         * @param resource `AWS::LakeFormation::PrincipalPermissions.Resource`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(final software.amazon.awscdk.IResolvable resource) {
            this.props.resource(resource);
            return this;
        }

        /**
         * `AWS::LakeFormation::PrincipalPermissions.Catalog`.
         * <p>
         * @return {@code this}
         * @param catalog `AWS::LakeFormation::PrincipalPermissions.Catalog`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder catalog(final java.lang.String catalog) {
            this.props.catalog(catalog);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions build() {
            return new software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
