package software.amazon.awscdk.services.kms;

/**
 * The key spec, represents the cryptographic configuration of keys.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Key key = Key.Builder.create(this, "MyKey")
 *         .keySpec(KeySpec.ECC_SECG_P256K1) // Default to SYMMETRIC_DEFAULT
 *         .keyUsage(KeyUsage.SIGN_VERIFY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:52.651Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kms.KeySpec")
public enum KeySpec {
    /**
     * The default key spec.
     * <p>
     * Valid usage: ENCRYPT_DECRYPT
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SYMMETRIC_DEFAULT,
    /**
     * RSA with 2048 bits of key.
     * <p>
     * Valid usage: ENCRYPT_DECRYPT and SIGN_VERIFY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RSA_2048,
    /**
     * RSA with 3072 bits of key.
     * <p>
     * Valid usage: ENCRYPT_DECRYPT and SIGN_VERIFY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RSA_3072,
    /**
     * RSA with 4096 bits of key.
     * <p>
     * Valid usage: ENCRYPT_DECRYPT and SIGN_VERIFY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RSA_4096,
    /**
     * NIST FIPS 186-4, Section 6.4, ECDSA signature using the curve specified by the key and SHA-256 for the message digest.
     * <p>
     * Valid usage: SIGN_VERIFY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ECC_NIST_P256,
    /**
     * NIST FIPS 186-4, Section 6.4, ECDSA signature using the curve specified by the key and SHA-384 for the message digest.
     * <p>
     * Valid usage: SIGN_VERIFY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ECC_NIST_P384,
    /**
     * NIST FIPS 186-4, Section 6.4, ECDSA signature using the curve specified by the key and SHA-512 for the message digest.
     * <p>
     * Valid usage: SIGN_VERIFY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ECC_NIST_P521,
    /**
     * Standards for Efficient Cryptography 2, Section 2.4.1, ECDSA signature on the Koblitz curve.
     * <p>
     * Valid usage: SIGN_VERIFY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ECC_SECG_P256K1,
}
