package software.amazon.awscdk.services.kendra;

/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 * <p>
 * Specifies a data source that you use to with an Amazon Kendra index.
 * <p>
 * You specify a name, connector type and description for your data source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kendra.*;
 * CfnDataSource cfnDataSource = CfnDataSource.Builder.create(this, "MyCfnDataSource")
 *         .indexId("indexId")
 *         .name("name")
 *         .type("type")
 *         // the properties below are optional
 *         .customDocumentEnrichmentConfiguration(CustomDocumentEnrichmentConfigurationProperty.builder()
 *                 .inlineConfigurations(List.of(InlineCustomDocumentEnrichmentConfigurationProperty.builder()
 *                         .condition(DocumentAttributeConditionProperty.builder()
 *                                 .conditionDocumentAttributeKey("conditionDocumentAttributeKey")
 *                                 .operator("operator")
 *                                 // the properties below are optional
 *                                 .conditionOnValue(DocumentAttributeValueProperty.builder()
 *                                         .dateValue("dateValue")
 *                                         .longValue(123)
 *                                         .stringListValue(List.of("stringListValue"))
 *                                         .stringValue("stringValue")
 *                                         .build())
 *                                 .build())
 *                         .documentContentDeletion(false)
 *                         .target(DocumentAttributeTargetProperty.builder()
 *                                 .targetDocumentAttributeKey("targetDocumentAttributeKey")
 *                                 // the properties below are optional
 *                                 .targetDocumentAttributeValue(DocumentAttributeValueProperty.builder()
 *                                         .dateValue("dateValue")
 *                                         .longValue(123)
 *                                         .stringListValue(List.of("stringListValue"))
 *                                         .stringValue("stringValue")
 *                                         .build())
 *                                 .targetDocumentAttributeValueDeletion(false)
 *                                 .build())
 *                         .build()))
 *                 .postExtractionHookConfiguration(HookConfigurationProperty.builder()
 *                         .lambdaArn("lambdaArn")
 *                         .s3Bucket("s3Bucket")
 *                         // the properties below are optional
 *                         .invocationCondition(DocumentAttributeConditionProperty.builder()
 *                                 .conditionDocumentAttributeKey("conditionDocumentAttributeKey")
 *                                 .operator("operator")
 *                                 // the properties below are optional
 *                                 .conditionOnValue(DocumentAttributeValueProperty.builder()
 *                                         .dateValue("dateValue")
 *                                         .longValue(123)
 *                                         .stringListValue(List.of("stringListValue"))
 *                                         .stringValue("stringValue")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .preExtractionHookConfiguration(HookConfigurationProperty.builder()
 *                         .lambdaArn("lambdaArn")
 *                         .s3Bucket("s3Bucket")
 *                         // the properties below are optional
 *                         .invocationCondition(DocumentAttributeConditionProperty.builder()
 *                                 .conditionDocumentAttributeKey("conditionDocumentAttributeKey")
 *                                 .operator("operator")
 *                                 // the properties below are optional
 *                                 .conditionOnValue(DocumentAttributeValueProperty.builder()
 *                                         .dateValue("dateValue")
 *                                         .longValue(123)
 *                                         .stringListValue(List.of("stringListValue"))
 *                                         .stringValue("stringValue")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .roleArn("roleArn")
 *                 .build())
 *         .dataSourceConfiguration(DataSourceConfigurationProperty.builder()
 *                 .confluenceConfiguration(ConfluenceConfigurationProperty.builder()
 *                         .secretArn("secretArn")
 *                         .serverUrl("serverUrl")
 *                         .version("version")
 *                         // the properties below are optional
 *                         .attachmentConfiguration(ConfluenceAttachmentConfigurationProperty.builder()
 *                                 .attachmentFieldMappings(List.of(ConfluenceAttachmentToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .crawlAttachments(false)
 *                                 .build())
 *                         .blogConfiguration(ConfluenceBlogConfigurationProperty.builder()
 *                                 .blogFieldMappings(List.of(ConfluenceBlogToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .build())
 *                         .exclusionPatterns(List.of("exclusionPatterns"))
 *                         .inclusionPatterns(List.of("inclusionPatterns"))
 *                         .pageConfiguration(ConfluencePageConfigurationProperty.builder()
 *                                 .pageFieldMappings(List.of(ConfluencePageToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .build())
 *                         .spaceConfiguration(ConfluenceSpaceConfigurationProperty.builder()
 *                                 .crawlArchivedSpaces(false)
 *                                 .crawlPersonalSpaces(false)
 *                                 .excludeSpaces(List.of("excludeSpaces"))
 *                                 .includeSpaces(List.of("includeSpaces"))
 *                                 .spaceFieldMappings(List.of(ConfluenceSpaceToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .build())
 *                         .vpcConfiguration(DataSourceVpcConfigurationProperty.builder()
 *                                 .securityGroupIds(List.of("securityGroupIds"))
 *                                 .subnetIds(List.of("subnetIds"))
 *                                 .build())
 *                         .build())
 *                 .databaseConfiguration(DatabaseConfigurationProperty.builder()
 *                         .columnConfiguration(ColumnConfigurationProperty.builder()
 *                                 .changeDetectingColumns(List.of("changeDetectingColumns"))
 *                                 .documentDataColumnName("documentDataColumnName")
 *                                 .documentIdColumnName("documentIdColumnName")
 *                                 // the properties below are optional
 *                                 .documentTitleColumnName("documentTitleColumnName")
 *                                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .build())
 *                         .connectionConfiguration(ConnectionConfigurationProperty.builder()
 *                                 .databaseHost("databaseHost")
 *                                 .databaseName("databaseName")
 *                                 .databasePort(123)
 *                                 .secretArn("secretArn")
 *                                 .tableName("tableName")
 *                                 .build())
 *                         .databaseEngineType("databaseEngineType")
 *                         // the properties below are optional
 *                         .aclConfiguration(AclConfigurationProperty.builder()
 *                                 .allowedGroupsColumnName("allowedGroupsColumnName")
 *                                 .build())
 *                         .sqlConfiguration(SqlConfigurationProperty.builder()
 *                                 .queryIdentifiersEnclosingOption("queryIdentifiersEnclosingOption")
 *                                 .build())
 *                         .vpcConfiguration(DataSourceVpcConfigurationProperty.builder()
 *                                 .securityGroupIds(List.of("securityGroupIds"))
 *                                 .subnetIds(List.of("subnetIds"))
 *                                 .build())
 *                         .build())
 *                 .googleDriveConfiguration(GoogleDriveConfigurationProperty.builder()
 *                         .secretArn("secretArn")
 *                         // the properties below are optional
 *                         .excludeMimeTypes(List.of("excludeMimeTypes"))
 *                         .excludeSharedDrives(List.of("excludeSharedDrives"))
 *                         .excludeUserAccounts(List.of("excludeUserAccounts"))
 *                         .exclusionPatterns(List.of("exclusionPatterns"))
 *                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                 .dataSourceFieldName("dataSourceFieldName")
 *                                 .indexFieldName("indexFieldName")
 *                                 // the properties below are optional
 *                                 .dateFieldFormat("dateFieldFormat")
 *                                 .build()))
 *                         .inclusionPatterns(List.of("inclusionPatterns"))
 *                         .build())
 *                 .oneDriveConfiguration(OneDriveConfigurationProperty.builder()
 *                         .oneDriveUsers(OneDriveUsersProperty.builder()
 *                                 .oneDriveUserList(List.of("oneDriveUserList"))
 *                                 .oneDriveUserS3Path(S3PathProperty.builder()
 *                                         .bucket("bucket")
 *                                         .key("key")
 *                                         .build())
 *                                 .build())
 *                         .secretArn("secretArn")
 *                         .tenantDomain("tenantDomain")
 *                         // the properties below are optional
 *                         .disableLocalGroups(false)
 *                         .exclusionPatterns(List.of("exclusionPatterns"))
 *                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                 .dataSourceFieldName("dataSourceFieldName")
 *                                 .indexFieldName("indexFieldName")
 *                                 // the properties below are optional
 *                                 .dateFieldFormat("dateFieldFormat")
 *                                 .build()))
 *                         .inclusionPatterns(List.of("inclusionPatterns"))
 *                         .build())
 *                 .s3Configuration(S3DataSourceConfigurationProperty.builder()
 *                         .bucketName("bucketName")
 *                         // the properties below are optional
 *                         .accessControlListConfiguration(AccessControlListConfigurationProperty.builder()
 *                                 .keyPath("keyPath")
 *                                 .build())
 *                         .documentsMetadataConfiguration(DocumentsMetadataConfigurationProperty.builder()
 *                                 .s3Prefix("s3Prefix")
 *                                 .build())
 *                         .exclusionPatterns(List.of("exclusionPatterns"))
 *                         .inclusionPatterns(List.of("inclusionPatterns"))
 *                         .inclusionPrefixes(List.of("inclusionPrefixes"))
 *                         .build())
 *                 .salesforceConfiguration(SalesforceConfigurationProperty.builder()
 *                         .secretArn("secretArn")
 *                         .serverUrl("serverUrl")
 *                         // the properties below are optional
 *                         .chatterFeedConfiguration(SalesforceChatterFeedConfigurationProperty.builder()
 *                                 .documentDataFieldName("documentDataFieldName")
 *                                 // the properties below are optional
 *                                 .documentTitleFieldName("documentTitleFieldName")
 *                                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .includeFilterTypes(List.of("includeFilterTypes"))
 *                                 .build())
 *                         .crawlAttachments(false)
 *                         .excludeAttachmentFilePatterns(List.of("excludeAttachmentFilePatterns"))
 *                         .includeAttachmentFilePatterns(List.of("includeAttachmentFilePatterns"))
 *                         .knowledgeArticleConfiguration(SalesforceKnowledgeArticleConfigurationProperty.builder()
 *                                 .includedStates(List.of("includedStates"))
 *                                 // the properties below are optional
 *                                 .customKnowledgeArticleTypeConfigurations(List.of(SalesforceCustomKnowledgeArticleTypeConfigurationProperty.builder()
 *                                         .documentDataFieldName("documentDataFieldName")
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .documentTitleFieldName("documentTitleFieldName")
 *                                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                                 .dataSourceFieldName("dataSourceFieldName")
 *                                                 .indexFieldName("indexFieldName")
 *                                                 // the properties below are optional
 *                                                 .dateFieldFormat("dateFieldFormat")
 *                                                 .build()))
 *                                         .build()))
 *                                 .standardKnowledgeArticleTypeConfiguration(SalesforceStandardKnowledgeArticleTypeConfigurationProperty.builder()
 *                                         .documentDataFieldName("documentDataFieldName")
 *                                         // the properties below are optional
 *                                         .documentTitleFieldName("documentTitleFieldName")
 *                                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                                 .dataSourceFieldName("dataSourceFieldName")
 *                                                 .indexFieldName("indexFieldName")
 *                                                 // the properties below are optional
 *                                                 .dateFieldFormat("dateFieldFormat")
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         .standardObjectAttachmentConfiguration(SalesforceStandardObjectAttachmentConfigurationProperty.builder()
 *                                 .documentTitleFieldName("documentTitleFieldName")
 *                                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .build())
 *                         .standardObjectConfigurations(List.of(SalesforceStandardObjectConfigurationProperty.builder()
 *                                 .documentDataFieldName("documentDataFieldName")
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .documentTitleFieldName("documentTitleFieldName")
 *                                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .serviceNowConfiguration(ServiceNowConfigurationProperty.builder()
 *                         .hostUrl("hostUrl")
 *                         .secretArn("secretArn")
 *                         .serviceNowBuildVersion("serviceNowBuildVersion")
 *                         // the properties below are optional
 *                         .authenticationType("authenticationType")
 *                         .knowledgeArticleConfiguration(ServiceNowKnowledgeArticleConfigurationProperty.builder()
 *                                 .documentDataFieldName("documentDataFieldName")
 *                                 // the properties below are optional
 *                                 .crawlAttachments(false)
 *                                 .documentTitleFieldName("documentTitleFieldName")
 *                                 .excludeAttachmentFilePatterns(List.of("excludeAttachmentFilePatterns"))
 *                                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .filterQuery("filterQuery")
 *                                 .includeAttachmentFilePatterns(List.of("includeAttachmentFilePatterns"))
 *                                 .build())
 *                         .serviceCatalogConfiguration(ServiceNowServiceCatalogConfigurationProperty.builder()
 *                                 .documentDataFieldName("documentDataFieldName")
 *                                 // the properties below are optional
 *                                 .crawlAttachments(false)
 *                                 .documentTitleFieldName("documentTitleFieldName")
 *                                 .excludeAttachmentFilePatterns(List.of("excludeAttachmentFilePatterns"))
 *                                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                         .dataSourceFieldName("dataSourceFieldName")
 *                                         .indexFieldName("indexFieldName")
 *                                         // the properties below are optional
 *                                         .dateFieldFormat("dateFieldFormat")
 *                                         .build()))
 *                                 .includeAttachmentFilePatterns(List.of("includeAttachmentFilePatterns"))
 *                                 .build())
 *                         .build())
 *                 .sharePointConfiguration(SharePointConfigurationProperty.builder()
 *                         .secretArn("secretArn")
 *                         .sharePointVersion("sharePointVersion")
 *                         .urls(List.of("urls"))
 *                         // the properties below are optional
 *                         .crawlAttachments(false)
 *                         .disableLocalGroups(false)
 *                         .documentTitleFieldName("documentTitleFieldName")
 *                         .exclusionPatterns(List.of("exclusionPatterns"))
 *                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                 .dataSourceFieldName("dataSourceFieldName")
 *                                 .indexFieldName("indexFieldName")
 *                                 // the properties below are optional
 *                                 .dateFieldFormat("dateFieldFormat")
 *                                 .build()))
 *                         .inclusionPatterns(List.of("inclusionPatterns"))
 *                         .sslCertificateS3Path(S3PathProperty.builder()
 *                                 .bucket("bucket")
 *                                 .key("key")
 *                                 .build())
 *                         .useChangeLog(false)
 *                         .vpcConfiguration(DataSourceVpcConfigurationProperty.builder()
 *                                 .securityGroupIds(List.of("securityGroupIds"))
 *                                 .subnetIds(List.of("subnetIds"))
 *                                 .build())
 *                         .build())
 *                 .webCrawlerConfiguration(WebCrawlerConfigurationProperty.builder()
 *                         .urls(WebCrawlerUrlsProperty.builder()
 *                                 .seedUrlConfiguration(WebCrawlerSeedUrlConfigurationProperty.builder()
 *                                         .seedUrls(List.of("seedUrls"))
 *                                         // the properties below are optional
 *                                         .webCrawlerMode("webCrawlerMode")
 *                                         .build())
 *                                 .siteMapsConfiguration(WebCrawlerSiteMapsConfigurationProperty.builder()
 *                                         .siteMaps(List.of("siteMaps"))
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .authenticationConfiguration(WebCrawlerAuthenticationConfigurationProperty.builder()
 *                                 .basicAuthentication(List.of(WebCrawlerBasicAuthenticationProperty.builder()
 *                                         .credentials("credentials")
 *                                         .host("host")
 *                                         .port(123)
 *                                         .build()))
 *                                 .build())
 *                         .crawlDepth(123)
 *                         .maxContentSizePerPageInMegaBytes(123)
 *                         .maxLinksPerPage(123)
 *                         .maxUrlsPerMinuteCrawlRate(123)
 *                         .proxyConfiguration(ProxyConfigurationProperty.builder()
 *                                 .host("host")
 *                                 .port(123)
 *                                 // the properties below are optional
 *                                 .credentials("credentials")
 *                                 .build())
 *                         .urlExclusionPatterns(List.of("urlExclusionPatterns"))
 *                         .urlInclusionPatterns(List.of("urlInclusionPatterns"))
 *                         .build())
 *                 .workDocsConfiguration(WorkDocsConfigurationProperty.builder()
 *                         .organizationId("organizationId")
 *                         // the properties below are optional
 *                         .crawlComments(false)
 *                         .exclusionPatterns(List.of("exclusionPatterns"))
 *                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
 *                                 .dataSourceFieldName("dataSourceFieldName")
 *                                 .indexFieldName("indexFieldName")
 *                                 // the properties below are optional
 *                                 .dateFieldFormat("dateFieldFormat")
 *                                 .build()))
 *                         .inclusionPatterns(List.of("inclusionPatterns"))
 *                         .useChangeLog(false)
 *                         .build())
 *                 .build())
 *         .description("description")
 *         .roleArn("roleArn")
 *         .schedule("schedule")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:52.424Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource")
public class CfnDataSource extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kendra.CfnDataSource.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Kendra::DataSource`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kendra.CfnDataSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the data source. For example:.
     * <p>
     * <code>arn:aws:kendra:us-west-2:111122223333:index/335c3741-41df-46a6-b5d3-61f85b787884/data-source/b8cae438-6787-4091-8897-684a652bbb0a</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier for the data source. For example:.
     * <p>
     * <code>b8cae438-6787-4091-8897-684a652bbb0a</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The identifier of the index that should be associated with this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIndexId() {
        return software.amazon.jsii.Kernel.get(this, "indexId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the index that should be associated with this data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIndexId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "indexId", java.util.Objects.requireNonNull(value, "indexId is required"));
    }

    /**
     * The name of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The type of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * Configuration information for altering document metadata and content during the document ingestion process.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomDocumentEnrichmentConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "customDocumentEnrichmentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration information for altering document metadata and content during the document ingestion process.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomDocumentEnrichmentConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kendra.CfnDataSource.CustomDocumentEnrichmentConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "customDocumentEnrichmentConfiguration", value);
    }

    /**
     * Configuration information for altering document metadata and content during the document ingestion process.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomDocumentEnrichmentConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customDocumentEnrichmentConfiguration", value);
    }

    /**
     * Configuration information for an Amazon Kendra data source.
     * <p>
     * The contents of the configuration depend on the type of data source. You can only specify one type of data source in the configuration. Choose from one of the following data sources.
     * <p>
     * <ul>
     * <li>Amazon S3</li>
     * <li>Confluence</li>
     * <li>Custom</li>
     * <li>Database</li>
     * <li>Microsoft OneDrive</li>
     * <li>Microsoft SharePoint</li>
     * <li>Salesforce</li>
     * <li>ServiceNow</li>
     * </ul>
     * <p>
     * You can't specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code> .
     * <p>
     * The <code>Configuration</code> parameter is required for all other data sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataSourceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "dataSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration information for an Amazon Kendra data source.
     * <p>
     * The contents of the configuration depend on the type of data source. You can only specify one type of data source in the configuration. Choose from one of the following data sources.
     * <p>
     * <ul>
     * <li>Amazon S3</li>
     * <li>Confluence</li>
     * <li>Custom</li>
     * <li>Database</li>
     * <li>Microsoft OneDrive</li>
     * <li>Microsoft SharePoint</li>
     * <li>Salesforce</li>
     * <li>ServiceNow</li>
     * </ul>
     * <p>
     * You can't specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code> .
     * <p>
     * The <code>Configuration</code> parameter is required for all other data sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kendra.CfnDataSource.DataSourceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataSourceConfiguration", value);
    }

    /**
     * Configuration information for an Amazon Kendra data source.
     * <p>
     * The contents of the configuration depend on the type of data source. You can only specify one type of data source in the configuration. Choose from one of the following data sources.
     * <p>
     * <ul>
     * <li>Amazon S3</li>
     * <li>Confluence</li>
     * <li>Custom</li>
     * <li>Database</li>
     * <li>Microsoft OneDrive</li>
     * <li>Microsoft SharePoint</li>
     * <li>Salesforce</li>
     * <li>ServiceNow</li>
     * </ul>
     * <p>
     * You can't specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code> .
     * <p>
     * The <code>Configuration</code> parameter is required for all other data sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataSourceConfiguration", value);
    }

    /**
     * A description of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The Amazon Resource Name (ARN) of a role with permission to access the data source.
     * <p>
     * You can't specify the <code>RoleArn</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code> .
     * <p>
     * The <code>RoleArn</code> parameter is required for all other data sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of a role with permission to access the data source.
     * <p>
     * You can't specify the <code>RoleArn</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code> .
     * <p>
     * The <code>RoleArn</code> parameter is required for all other data sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", value);
    }

    /**
     * Sets the frequency that Amazon Kendra checks the documents in your data source and updates the index.
     * <p>
     * If you don't set a schedule, Amazon Kendra doesn't periodically update the index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSchedule() {
        return software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Sets the frequency that Amazon Kendra checks the documents in your data source and updates the index.
     * <p>
     * If you don't set a schedule, Amazon Kendra doesn't periodically update the index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }
    /**
     * Specifies access control list files for the documents in a data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * AccessControlListConfigurationProperty accessControlListConfigurationProperty = AccessControlListConfigurationProperty.builder()
     *         .keyPath("keyPath")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.AccessControlListConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AccessControlListConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccessControlListConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Path to the AWS S3 bucket that contains the access control list files.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccessControlListConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccessControlListConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccessControlListConfigurationProperty> {
            java.lang.String keyPath;

            /**
             * Sets the value of {@link AccessControlListConfigurationProperty#getKeyPath}
             * @param keyPath Path to the AWS S3 bucket that contains the access control list files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyPath(java.lang.String keyPath) {
                this.keyPath = keyPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccessControlListConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccessControlListConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccessControlListConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessControlListConfigurationProperty {
            private final java.lang.String keyPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.keyPath = software.amazon.jsii.Kernel.get(this, "keyPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.keyPath = builder.keyPath;
            }

            @Override
            public final java.lang.String getKeyPath() {
                return this.keyPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKeyPath() != null) {
                    data.set("keyPath", om.valueToTree(this.getKeyPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.AccessControlListConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccessControlListConfigurationProperty.Jsii$Proxy that = (AccessControlListConfigurationProperty.Jsii$Proxy) o;

                return this.keyPath != null ? this.keyPath.equals(that.keyPath) : that.keyPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.keyPath != null ? this.keyPath.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Provides information about the column that should be used for filtering the query response by groups.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * AclConfigurationProperty aclConfigurationProperty = AclConfigurationProperty.builder()
     *         .allowedGroupsColumnName("allowedGroupsColumnName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.AclConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AclConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AclConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of groups, separated by semi-colons, that filters a query response based on user context.
         * <p>
         * The document is only returned to users that are in one of the groups specified in the <code>UserContext</code> field of the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Query.html">Query</a> operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAllowedGroupsColumnName();

        /**
         * @return a {@link Builder} of {@link AclConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AclConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AclConfigurationProperty> {
            java.lang.String allowedGroupsColumnName;

            /**
             * Sets the value of {@link AclConfigurationProperty#getAllowedGroupsColumnName}
             * @param allowedGroupsColumnName A list of groups, separated by semi-colons, that filters a query response based on user context. This parameter is required.
             *                                The document is only returned to users that are in one of the groups specified in the <code>UserContext</code> field of the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_Query.html">Query</a> operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedGroupsColumnName(java.lang.String allowedGroupsColumnName) {
                this.allowedGroupsColumnName = allowedGroupsColumnName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AclConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AclConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AclConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AclConfigurationProperty {
            private final java.lang.String allowedGroupsColumnName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowedGroupsColumnName = software.amazon.jsii.Kernel.get(this, "allowedGroupsColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowedGroupsColumnName = java.util.Objects.requireNonNull(builder.allowedGroupsColumnName, "allowedGroupsColumnName is required");
            }

            @Override
            public final java.lang.String getAllowedGroupsColumnName() {
                return this.allowedGroupsColumnName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("allowedGroupsColumnName", om.valueToTree(this.getAllowedGroupsColumnName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.AclConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AclConfigurationProperty.Jsii$Proxy that = (AclConfigurationProperty.Jsii$Proxy) o;

                return this.allowedGroupsColumnName.equals(that.allowedGroupsColumnName);
            }

            @Override
            public final int hashCode() {
                int result = this.allowedGroupsColumnName.hashCode();
                return result;
            }
        }
    }
    /**
     * Provides information about how Amazon Kendra should use the columns of a database in an index.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * ColumnConfigurationProperty columnConfigurationProperty = ColumnConfigurationProperty.builder()
     *         .changeDetectingColumns(List.of("changeDetectingColumns"))
     *         .documentDataColumnName("documentDataColumnName")
     *         .documentIdColumnName("documentIdColumnName")
     *         // the properties below are optional
     *         .documentTitleColumnName("documentTitleColumnName")
     *         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                 .dataSourceFieldName("dataSourceFieldName")
     *                 .indexFieldName("indexFieldName")
     *                 // the properties below are optional
     *                 .dateFieldFormat("dateFieldFormat")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.ColumnConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * One to five columns that indicate when a document in the database has changed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getChangeDetectingColumns();

        /**
         * The column that contains the contents of the document.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDocumentDataColumnName();

        /**
         * The column that provides the document's unique identifier.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDocumentIdColumnName();

        /**
         * The column that contains the title of the document.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentTitleColumnName() {
            return null;
        }

        /**
         * An array of objects that map database column names to the corresponding fields in an index.
         * <p>
         * You must first create the fields in the index using the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateIndex.html">UpdateIndex</a> operation.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFieldMappings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnConfigurationProperty> {
            java.util.List<java.lang.String> changeDetectingColumns;
            java.lang.String documentDataColumnName;
            java.lang.String documentIdColumnName;
            java.lang.String documentTitleColumnName;
            java.lang.Object fieldMappings;

            /**
             * Sets the value of {@link ColumnConfigurationProperty#getChangeDetectingColumns}
             * @param changeDetectingColumns One to five columns that indicate when a document in the database has changed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder changeDetectingColumns(java.util.List<java.lang.String> changeDetectingColumns) {
                this.changeDetectingColumns = changeDetectingColumns;
                return this;
            }

            /**
             * Sets the value of {@link ColumnConfigurationProperty#getDocumentDataColumnName}
             * @param documentDataColumnName The column that contains the contents of the document. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentDataColumnName(java.lang.String documentDataColumnName) {
                this.documentDataColumnName = documentDataColumnName;
                return this;
            }

            /**
             * Sets the value of {@link ColumnConfigurationProperty#getDocumentIdColumnName}
             * @param documentIdColumnName The column that provides the document's unique identifier. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentIdColumnName(java.lang.String documentIdColumnName) {
                this.documentIdColumnName = documentIdColumnName;
                return this;
            }

            /**
             * Sets the value of {@link ColumnConfigurationProperty#getDocumentTitleColumnName}
             * @param documentTitleColumnName The column that contains the title of the document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentTitleColumnName(java.lang.String documentTitleColumnName) {
                this.documentTitleColumnName = documentTitleColumnName;
                return this;
            }

            /**
             * Sets the value of {@link ColumnConfigurationProperty#getFieldMappings}
             * @param fieldMappings An array of objects that map database column names to the corresponding fields in an index.
             *                      You must first create the fields in the index using the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateIndex.html">UpdateIndex</a> operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(software.amazon.awscdk.IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link ColumnConfigurationProperty#getFieldMappings}
             * @param fieldMappings An array of objects that map database column names to the corresponding fields in an index.
             *                      You must first create the fields in the index using the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateIndex.html">UpdateIndex</a> operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(java.util.List<? extends java.lang.Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnConfigurationProperty {
            private final java.util.List<java.lang.String> changeDetectingColumns;
            private final java.lang.String documentDataColumnName;
            private final java.lang.String documentIdColumnName;
            private final java.lang.String documentTitleColumnName;
            private final java.lang.Object fieldMappings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.changeDetectingColumns = software.amazon.jsii.Kernel.get(this, "changeDetectingColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.documentDataColumnName = software.amazon.jsii.Kernel.get(this, "documentDataColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.documentIdColumnName = software.amazon.jsii.Kernel.get(this, "documentIdColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.documentTitleColumnName = software.amazon.jsii.Kernel.get(this, "documentTitleColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldMappings = software.amazon.jsii.Kernel.get(this, "fieldMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.changeDetectingColumns = java.util.Objects.requireNonNull(builder.changeDetectingColumns, "changeDetectingColumns is required");
                this.documentDataColumnName = java.util.Objects.requireNonNull(builder.documentDataColumnName, "documentDataColumnName is required");
                this.documentIdColumnName = java.util.Objects.requireNonNull(builder.documentIdColumnName, "documentIdColumnName is required");
                this.documentTitleColumnName = builder.documentTitleColumnName;
                this.fieldMappings = builder.fieldMappings;
            }

            @Override
            public final java.util.List<java.lang.String> getChangeDetectingColumns() {
                return this.changeDetectingColumns;
            }

            @Override
            public final java.lang.String getDocumentDataColumnName() {
                return this.documentDataColumnName;
            }

            @Override
            public final java.lang.String getDocumentIdColumnName() {
                return this.documentIdColumnName;
            }

            @Override
            public final java.lang.String getDocumentTitleColumnName() {
                return this.documentTitleColumnName;
            }

            @Override
            public final java.lang.Object getFieldMappings() {
                return this.fieldMappings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("changeDetectingColumns", om.valueToTree(this.getChangeDetectingColumns()));
                data.set("documentDataColumnName", om.valueToTree(this.getDocumentDataColumnName()));
                data.set("documentIdColumnName", om.valueToTree(this.getDocumentIdColumnName()));
                if (this.getDocumentTitleColumnName() != null) {
                    data.set("documentTitleColumnName", om.valueToTree(this.getDocumentTitleColumnName()));
                }
                if (this.getFieldMappings() != null) {
                    data.set("fieldMappings", om.valueToTree(this.getFieldMappings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.ColumnConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnConfigurationProperty.Jsii$Proxy that = (ColumnConfigurationProperty.Jsii$Proxy) o;

                if (!changeDetectingColumns.equals(that.changeDetectingColumns)) return false;
                if (!documentDataColumnName.equals(that.documentDataColumnName)) return false;
                if (!documentIdColumnName.equals(that.documentIdColumnName)) return false;
                if (this.documentTitleColumnName != null ? !this.documentTitleColumnName.equals(that.documentTitleColumnName) : that.documentTitleColumnName != null) return false;
                return this.fieldMappings != null ? this.fieldMappings.equals(that.fieldMappings) : that.fieldMappings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.changeDetectingColumns.hashCode();
                result = 31 * result + (this.documentDataColumnName.hashCode());
                result = 31 * result + (this.documentIdColumnName.hashCode());
                result = 31 * result + (this.documentTitleColumnName != null ? this.documentTitleColumnName.hashCode() : 0);
                result = 31 * result + (this.fieldMappings != null ? this.fieldMappings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration of attachment settings for the Confluence data source.
     * <p>
     * Attachment settings are optional, if you don't specify settings attachments, Amazon Kendra won't index them.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * ConfluenceAttachmentConfigurationProperty confluenceAttachmentConfigurationProperty = ConfluenceAttachmentConfigurationProperty.builder()
     *         .attachmentFieldMappings(List.of(ConfluenceAttachmentToIndexFieldMappingProperty.builder()
     *                 .dataSourceFieldName("dataSourceFieldName")
     *                 .indexFieldName("indexFieldName")
     *                 // the properties below are optional
     *                 .dateFieldFormat("dateFieldFormat")
     *                 .build()))
     *         .crawlAttachments(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceAttachmentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfluenceAttachmentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfluenceAttachmentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Maps attributes or field names of Confluence attachments to Amazon Kendra index field names.
         * <p>
         * To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Confluence data source field names must exist in your Confluence custom metadata.
         * <p>
         * If you specify the <code>AttachentFieldMappings</code> parameter, you must specify at least one field mapping.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttachmentFieldMappings() {
            return null;
        }

        /**
         * Indicates whether Amazon Kendra indexes attachments to the pages and blogs in the Confluence data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrawlAttachments() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfluenceAttachmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfluenceAttachmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfluenceAttachmentConfigurationProperty> {
            java.lang.Object attachmentFieldMappings;
            java.lang.Object crawlAttachments;

            /**
             * Sets the value of {@link ConfluenceAttachmentConfigurationProperty#getAttachmentFieldMappings}
             * @param attachmentFieldMappings Maps attributes or field names of Confluence attachments to Amazon Kendra index field names.
             *                                To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Confluence data source field names must exist in your Confluence custom metadata.
             *                                <p>
             *                                If you specify the <code>AttachentFieldMappings</code> parameter, you must specify at least one field mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attachmentFieldMappings(software.amazon.awscdk.IResolvable attachmentFieldMappings) {
                this.attachmentFieldMappings = attachmentFieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceAttachmentConfigurationProperty#getAttachmentFieldMappings}
             * @param attachmentFieldMappings Maps attributes or field names of Confluence attachments to Amazon Kendra index field names.
             *                                To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Confluence data source field names must exist in your Confluence custom metadata.
             *                                <p>
             *                                If you specify the <code>AttachentFieldMappings</code> parameter, you must specify at least one field mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attachmentFieldMappings(java.util.List<? extends java.lang.Object> attachmentFieldMappings) {
                this.attachmentFieldMappings = attachmentFieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceAttachmentConfigurationProperty#getCrawlAttachments}
             * @param crawlAttachments Indicates whether Amazon Kendra indexes attachments to the pages and blogs in the Confluence data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlAttachments(java.lang.Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceAttachmentConfigurationProperty#getCrawlAttachments}
             * @param crawlAttachments Indicates whether Amazon Kendra indexes attachments to the pages and blogs in the Confluence data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlAttachments(software.amazon.awscdk.IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfluenceAttachmentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfluenceAttachmentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfluenceAttachmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfluenceAttachmentConfigurationProperty {
            private final java.lang.Object attachmentFieldMappings;
            private final java.lang.Object crawlAttachments;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attachmentFieldMappings = software.amazon.jsii.Kernel.get(this, "attachmentFieldMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.crawlAttachments = software.amazon.jsii.Kernel.get(this, "crawlAttachments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attachmentFieldMappings = builder.attachmentFieldMappings;
                this.crawlAttachments = builder.crawlAttachments;
            }

            @Override
            public final java.lang.Object getAttachmentFieldMappings() {
                return this.attachmentFieldMappings;
            }

            @Override
            public final java.lang.Object getCrawlAttachments() {
                return this.crawlAttachments;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttachmentFieldMappings() != null) {
                    data.set("attachmentFieldMappings", om.valueToTree(this.getAttachmentFieldMappings()));
                }
                if (this.getCrawlAttachments() != null) {
                    data.set("crawlAttachments", om.valueToTree(this.getCrawlAttachments()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceAttachmentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfluenceAttachmentConfigurationProperty.Jsii$Proxy that = (ConfluenceAttachmentConfigurationProperty.Jsii$Proxy) o;

                if (this.attachmentFieldMappings != null ? !this.attachmentFieldMappings.equals(that.attachmentFieldMappings) : that.attachmentFieldMappings != null) return false;
                return this.crawlAttachments != null ? this.crawlAttachments.equals(that.crawlAttachments) : that.crawlAttachments == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attachmentFieldMappings != null ? this.attachmentFieldMappings.hashCode() : 0;
                result = 31 * result + (this.crawlAttachments != null ? this.crawlAttachments.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Maps attributes or field names of Confluence attachments to Amazon Kendra index field names.
     * <p>
     * To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Confuence data source field names must exist in your Confluence custom metadata.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * ConfluenceAttachmentToIndexFieldMappingProperty confluenceAttachmentToIndexFieldMappingProperty = ConfluenceAttachmentToIndexFieldMappingProperty.builder()
     *         .dataSourceFieldName("dataSourceFieldName")
     *         .indexFieldName("indexFieldName")
     *         // the properties below are optional
     *         .dateFieldFormat("dateFieldFormat")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceAttachmentToIndexFieldMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfluenceAttachmentToIndexFieldMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfluenceAttachmentToIndexFieldMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field in the data source.
         * <p>
         * You must first create the index field using the <code>UpdateIndex</code> API.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSourceFieldName();

        /**
         * The name of the index field to map to the Confluence data source field.
         * <p>
         * The index field type must match the Confluence field type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndexFieldName();

        /**
         * The format for date fields in the data source.
         * <p>
         * If the field specified in <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not a date field, an exception is thrown.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDateFieldFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfluenceAttachmentToIndexFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfluenceAttachmentToIndexFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfluenceAttachmentToIndexFieldMappingProperty> {
            java.lang.String dataSourceFieldName;
            java.lang.String indexFieldName;
            java.lang.String dateFieldFormat;

            /**
             * Sets the value of {@link ConfluenceAttachmentToIndexFieldMappingProperty#getDataSourceFieldName}
             * @param dataSourceFieldName The name of the field in the data source. This parameter is required.
             *                            You must first create the index field using the <code>UpdateIndex</code> API.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSourceFieldName(java.lang.String dataSourceFieldName) {
                this.dataSourceFieldName = dataSourceFieldName;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceAttachmentToIndexFieldMappingProperty#getIndexFieldName}
             * @param indexFieldName The name of the index field to map to the Confluence data source field. This parameter is required.
             *                       The index field type must match the Confluence field type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexFieldName(java.lang.String indexFieldName) {
                this.indexFieldName = indexFieldName;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceAttachmentToIndexFieldMappingProperty#getDateFieldFormat}
             * @param dateFieldFormat The format for date fields in the data source.
             *                        If the field specified in <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not a date field, an exception is thrown.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateFieldFormat(java.lang.String dateFieldFormat) {
                this.dateFieldFormat = dateFieldFormat;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfluenceAttachmentToIndexFieldMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfluenceAttachmentToIndexFieldMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfluenceAttachmentToIndexFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfluenceAttachmentToIndexFieldMappingProperty {
            private final java.lang.String dataSourceFieldName;
            private final java.lang.String indexFieldName;
            private final java.lang.String dateFieldFormat;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSourceFieldName = software.amazon.jsii.Kernel.get(this, "dataSourceFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.indexFieldName = software.amazon.jsii.Kernel.get(this, "indexFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dateFieldFormat = software.amazon.jsii.Kernel.get(this, "dateFieldFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSourceFieldName = java.util.Objects.requireNonNull(builder.dataSourceFieldName, "dataSourceFieldName is required");
                this.indexFieldName = java.util.Objects.requireNonNull(builder.indexFieldName, "indexFieldName is required");
                this.dateFieldFormat = builder.dateFieldFormat;
            }

            @Override
            public final java.lang.String getDataSourceFieldName() {
                return this.dataSourceFieldName;
            }

            @Override
            public final java.lang.String getIndexFieldName() {
                return this.indexFieldName;
            }

            @Override
            public final java.lang.String getDateFieldFormat() {
                return this.dateFieldFormat;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSourceFieldName", om.valueToTree(this.getDataSourceFieldName()));
                data.set("indexFieldName", om.valueToTree(this.getIndexFieldName()));
                if (this.getDateFieldFormat() != null) {
                    data.set("dateFieldFormat", om.valueToTree(this.getDateFieldFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceAttachmentToIndexFieldMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfluenceAttachmentToIndexFieldMappingProperty.Jsii$Proxy that = (ConfluenceAttachmentToIndexFieldMappingProperty.Jsii$Proxy) o;

                if (!dataSourceFieldName.equals(that.dataSourceFieldName)) return false;
                if (!indexFieldName.equals(that.indexFieldName)) return false;
                return this.dateFieldFormat != null ? this.dateFieldFormat.equals(that.dateFieldFormat) : that.dateFieldFormat == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataSourceFieldName.hashCode();
                result = 31 * result + (this.indexFieldName.hashCode());
                result = 31 * result + (this.dateFieldFormat != null ? this.dateFieldFormat.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration of blog settings for the Confluence data source.
     * <p>
     * Blogs are always indexed unless filtered from the index by the <code>ExclusionPatterns</code> or <code>InclusionPatterns</code> fields in the <code>ConfluenceConfiguration</code> object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * ConfluenceBlogConfigurationProperty confluenceBlogConfigurationProperty = ConfluenceBlogConfigurationProperty.builder()
     *         .blogFieldMappings(List.of(ConfluenceBlogToIndexFieldMappingProperty.builder()
     *                 .dataSourceFieldName("dataSourceFieldName")
     *                 .indexFieldName("indexFieldName")
     *                 // the properties below are optional
     *                 .dateFieldFormat("dateFieldFormat")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceBlogConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfluenceBlogConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfluenceBlogConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Maps attributes or field names of Confluence blogs to Amazon Kendra index field names.
         * <p>
         * To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Confluence data source field names must exist in your Confluence custom metadata.
         * <p>
         * If you specify the <code>BlogFieldMappings</code> parameter, you must specify at least one field mapping.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlogFieldMappings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfluenceBlogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfluenceBlogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfluenceBlogConfigurationProperty> {
            java.lang.Object blogFieldMappings;

            /**
             * Sets the value of {@link ConfluenceBlogConfigurationProperty#getBlogFieldMappings}
             * @param blogFieldMappings Maps attributes or field names of Confluence blogs to Amazon Kendra index field names.
             *                          To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Confluence data source field names must exist in your Confluence custom metadata.
             *                          <p>
             *                          If you specify the <code>BlogFieldMappings</code> parameter, you must specify at least one field mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blogFieldMappings(software.amazon.awscdk.IResolvable blogFieldMappings) {
                this.blogFieldMappings = blogFieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceBlogConfigurationProperty#getBlogFieldMappings}
             * @param blogFieldMappings Maps attributes or field names of Confluence blogs to Amazon Kendra index field names.
             *                          To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Confluence data source field names must exist in your Confluence custom metadata.
             *                          <p>
             *                          If you specify the <code>BlogFieldMappings</code> parameter, you must specify at least one field mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blogFieldMappings(java.util.List<? extends java.lang.Object> blogFieldMappings) {
                this.blogFieldMappings = blogFieldMappings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfluenceBlogConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfluenceBlogConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfluenceBlogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfluenceBlogConfigurationProperty {
            private final java.lang.Object blogFieldMappings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blogFieldMappings = software.amazon.jsii.Kernel.get(this, "blogFieldMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blogFieldMappings = builder.blogFieldMappings;
            }

            @Override
            public final java.lang.Object getBlogFieldMappings() {
                return this.blogFieldMappings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlogFieldMappings() != null) {
                    data.set("blogFieldMappings", om.valueToTree(this.getBlogFieldMappings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceBlogConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfluenceBlogConfigurationProperty.Jsii$Proxy that = (ConfluenceBlogConfigurationProperty.Jsii$Proxy) o;

                return this.blogFieldMappings != null ? this.blogFieldMappings.equals(that.blogFieldMappings) : that.blogFieldMappings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blogFieldMappings != null ? this.blogFieldMappings.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Maps attributes or field names of Confluence blog to Amazon Kendra index field names.
     * <p>
     * To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Confluence data source field names must exist in your Confluence custom metadata.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * ConfluenceBlogToIndexFieldMappingProperty confluenceBlogToIndexFieldMappingProperty = ConfluenceBlogToIndexFieldMappingProperty.builder()
     *         .dataSourceFieldName("dataSourceFieldName")
     *         .indexFieldName("indexFieldName")
     *         // the properties below are optional
     *         .dateFieldFormat("dateFieldFormat")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceBlogToIndexFieldMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfluenceBlogToIndexFieldMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfluenceBlogToIndexFieldMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field in the data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSourceFieldName();

        /**
         * The name of the index field to map to the Confluence data source field.
         * <p>
         * The index field type must match the Confluence field type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndexFieldName();

        /**
         * The format for date fields in the data source.
         * <p>
         * If the field specified in <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not a date field, an exception is thrown.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDateFieldFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfluenceBlogToIndexFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfluenceBlogToIndexFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfluenceBlogToIndexFieldMappingProperty> {
            java.lang.String dataSourceFieldName;
            java.lang.String indexFieldName;
            java.lang.String dateFieldFormat;

            /**
             * Sets the value of {@link ConfluenceBlogToIndexFieldMappingProperty#getDataSourceFieldName}
             * @param dataSourceFieldName The name of the field in the data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSourceFieldName(java.lang.String dataSourceFieldName) {
                this.dataSourceFieldName = dataSourceFieldName;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceBlogToIndexFieldMappingProperty#getIndexFieldName}
             * @param indexFieldName The name of the index field to map to the Confluence data source field. This parameter is required.
             *                       The index field type must match the Confluence field type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexFieldName(java.lang.String indexFieldName) {
                this.indexFieldName = indexFieldName;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceBlogToIndexFieldMappingProperty#getDateFieldFormat}
             * @param dateFieldFormat The format for date fields in the data source.
             *                        If the field specified in <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not a date field, an exception is thrown.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateFieldFormat(java.lang.String dateFieldFormat) {
                this.dateFieldFormat = dateFieldFormat;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfluenceBlogToIndexFieldMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfluenceBlogToIndexFieldMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfluenceBlogToIndexFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfluenceBlogToIndexFieldMappingProperty {
            private final java.lang.String dataSourceFieldName;
            private final java.lang.String indexFieldName;
            private final java.lang.String dateFieldFormat;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSourceFieldName = software.amazon.jsii.Kernel.get(this, "dataSourceFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.indexFieldName = software.amazon.jsii.Kernel.get(this, "indexFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dateFieldFormat = software.amazon.jsii.Kernel.get(this, "dateFieldFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSourceFieldName = java.util.Objects.requireNonNull(builder.dataSourceFieldName, "dataSourceFieldName is required");
                this.indexFieldName = java.util.Objects.requireNonNull(builder.indexFieldName, "indexFieldName is required");
                this.dateFieldFormat = builder.dateFieldFormat;
            }

            @Override
            public final java.lang.String getDataSourceFieldName() {
                return this.dataSourceFieldName;
            }

            @Override
            public final java.lang.String getIndexFieldName() {
                return this.indexFieldName;
            }

            @Override
            public final java.lang.String getDateFieldFormat() {
                return this.dateFieldFormat;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSourceFieldName", om.valueToTree(this.getDataSourceFieldName()));
                data.set("indexFieldName", om.valueToTree(this.getIndexFieldName()));
                if (this.getDateFieldFormat() != null) {
                    data.set("dateFieldFormat", om.valueToTree(this.getDateFieldFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceBlogToIndexFieldMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfluenceBlogToIndexFieldMappingProperty.Jsii$Proxy that = (ConfluenceBlogToIndexFieldMappingProperty.Jsii$Proxy) o;

                if (!dataSourceFieldName.equals(that.dataSourceFieldName)) return false;
                if (!indexFieldName.equals(that.indexFieldName)) return false;
                return this.dateFieldFormat != null ? this.dateFieldFormat.equals(that.dateFieldFormat) : that.dateFieldFormat == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataSourceFieldName.hashCode();
                result = 31 * result + (this.indexFieldName.hashCode());
                result = 31 * result + (this.dateFieldFormat != null ? this.dateFieldFormat.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information to connect to Confluence as your data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * ConfluenceConfigurationProperty confluenceConfigurationProperty = ConfluenceConfigurationProperty.builder()
     *         .secretArn("secretArn")
     *         .serverUrl("serverUrl")
     *         .version("version")
     *         // the properties below are optional
     *         .attachmentConfiguration(ConfluenceAttachmentConfigurationProperty.builder()
     *                 .attachmentFieldMappings(List.of(ConfluenceAttachmentToIndexFieldMappingProperty.builder()
     *                         .dataSourceFieldName("dataSourceFieldName")
     *                         .indexFieldName("indexFieldName")
     *                         // the properties below are optional
     *                         .dateFieldFormat("dateFieldFormat")
     *                         .build()))
     *                 .crawlAttachments(false)
     *                 .build())
     *         .blogConfiguration(ConfluenceBlogConfigurationProperty.builder()
     *                 .blogFieldMappings(List.of(ConfluenceBlogToIndexFieldMappingProperty.builder()
     *                         .dataSourceFieldName("dataSourceFieldName")
     *                         .indexFieldName("indexFieldName")
     *                         // the properties below are optional
     *                         .dateFieldFormat("dateFieldFormat")
     *                         .build()))
     *                 .build())
     *         .exclusionPatterns(List.of("exclusionPatterns"))
     *         .inclusionPatterns(List.of("inclusionPatterns"))
     *         .pageConfiguration(ConfluencePageConfigurationProperty.builder()
     *                 .pageFieldMappings(List.of(ConfluencePageToIndexFieldMappingProperty.builder()
     *                         .dataSourceFieldName("dataSourceFieldName")
     *                         .indexFieldName("indexFieldName")
     *                         // the properties below are optional
     *                         .dateFieldFormat("dateFieldFormat")
     *                         .build()))
     *                 .build())
     *         .spaceConfiguration(ConfluenceSpaceConfigurationProperty.builder()
     *                 .crawlArchivedSpaces(false)
     *                 .crawlPersonalSpaces(false)
     *                 .excludeSpaces(List.of("excludeSpaces"))
     *                 .includeSpaces(List.of("includeSpaces"))
     *                 .spaceFieldMappings(List.of(ConfluenceSpaceToIndexFieldMappingProperty.builder()
     *                         .dataSourceFieldName("dataSourceFieldName")
     *                         .indexFieldName("indexFieldName")
     *                         // the properties below are optional
     *                         .dateFieldFormat("dateFieldFormat")
     *                         .build()))
     *                 .build())
     *         .vpcConfiguration(DataSourceVpcConfigurationProperty.builder()
     *                 .securityGroupIds(List.of("securityGroupIds"))
     *                 .subnetIds(List.of("subnetIds"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfluenceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfluenceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that contains the key-value pairs required to connect to your Confluence server.
         * <p>
         * The secret must contain a JSON structure with the following keys:
         * <p>
         * <ul>
         * <li>username—The user name or email address of a user with administrative privileges for the Confluence server.</li>
         * <li>password—The password associated with the user logging in to the Confluence server.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretArn();

        /**
         * The URL of your Confluence instance.
         * <p>
         * Use the full URL of the server. For example, <em>https://server.example.com:port/</em> . You can also use an IP address, for example, <em>https://192.168.1.113/</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServerUrl();

        /**
         * Specifies the version of the Confluence installation that you are connecting to.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVersion();

        /**
         * Configuration information for indexing attachments to Confluence blogs and pages.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttachmentConfiguration() {
            return null;
        }

        /**
         * Configuration information for indexing Confluence blogs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlogConfiguration() {
            return null;
        }

        /**
         * >A list of regular expression patterns to exclude certain blog posts, pages, spaces, or attachments in your Confluence.
         * <p>
         * Content that matches the patterns are excluded from the index. Content that doesn't match the patterns is included in the index. If content matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the content isn't included in the index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclusionPatterns() {
            return null;
        }

        /**
         * A list of regular expression patterns to include certain blog posts, pages, spaces, or attachments in your Confluence.
         * <p>
         * Content that matches the patterns are included in the index. Content that doesn't match the patterns is excluded from the index. If content matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the content isn't included in the index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclusionPatterns() {
            return null;
        }

        /**
         * Configuration information for indexing Confluence pages.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPageConfiguration() {
            return null;
        }

        /**
         * Configuration information for indexing Confluence spaces.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSpaceConfiguration() {
            return null;
        }

        /**
         * Configuration information for an Amazon Virtual Private Cloud to connect to your Confluence.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfluenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfluenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfluenceConfigurationProperty> {
            java.lang.String secretArn;
            java.lang.String serverUrl;
            java.lang.String version;
            java.lang.Object attachmentConfiguration;
            java.lang.Object blogConfiguration;
            java.util.List<java.lang.String> exclusionPatterns;
            java.util.List<java.lang.String> inclusionPatterns;
            java.lang.Object pageConfiguration;
            java.lang.Object spaceConfiguration;
            java.lang.Object vpcConfiguration;

            /**
             * Sets the value of {@link ConfluenceConfigurationProperty#getSecretArn}
             * @param secretArn The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that contains the key-value pairs required to connect to your Confluence server. This parameter is required.
             *                  The secret must contain a JSON structure with the following keys:
             *                  <p>
             *                  <ul>
             *                  <li>username—The user name or email address of a user with administrative privileges for the Confluence server.</li>
             *                  <li>password—The password associated with the user logging in to the Confluence server.</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceConfigurationProperty#getServerUrl}
             * @param serverUrl The URL of your Confluence instance. This parameter is required.
             *                  Use the full URL of the server. For example, <em>https://server.example.com:port/</em> . You can also use an IP address, for example, <em>https://192.168.1.113/</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverUrl(java.lang.String serverUrl) {
                this.serverUrl = serverUrl;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceConfigurationProperty#getVersion}
             * @param version Specifies the version of the Confluence installation that you are connecting to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceConfigurationProperty#getAttachmentConfiguration}
             * @param attachmentConfiguration Configuration information for indexing attachments to Confluence blogs and pages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attachmentConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.ConfluenceAttachmentConfigurationProperty attachmentConfiguration) {
                this.attachmentConfiguration = attachmentConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceConfigurationProperty#getAttachmentConfiguration}
             * @param attachmentConfiguration Configuration information for indexing attachments to Confluence blogs and pages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attachmentConfiguration(software.amazon.awscdk.IResolvable attachmentConfiguration) {
                this.attachmentConfiguration = attachmentConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceConfigurationProperty#getBlogConfiguration}
             * @param blogConfiguration Configuration information for indexing Confluence blogs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blogConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.ConfluenceBlogConfigurationProperty blogConfiguration) {
                this.blogConfiguration = blogConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceConfigurationProperty#getBlogConfiguration}
             * @param blogConfiguration Configuration information for indexing Confluence blogs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blogConfiguration(software.amazon.awscdk.IResolvable blogConfiguration) {
                this.blogConfiguration = blogConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceConfigurationProperty#getExclusionPatterns}
             * @param exclusionPatterns >A list of regular expression patterns to exclude certain blog posts, pages, spaces, or attachments in your Confluence.
             *                          Content that matches the patterns are excluded from the index. Content that doesn't match the patterns is included in the index. If content matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the content isn't included in the index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusionPatterns(java.util.List<java.lang.String> exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceConfigurationProperty#getInclusionPatterns}
             * @param inclusionPatterns A list of regular expression patterns to include certain blog posts, pages, spaces, or attachments in your Confluence.
             *                          Content that matches the patterns are included in the index. Content that doesn't match the patterns is excluded from the index. If content matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the content isn't included in the index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusionPatterns(java.util.List<java.lang.String> inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceConfigurationProperty#getPageConfiguration}
             * @param pageConfiguration Configuration information for indexing Confluence pages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pageConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.ConfluencePageConfigurationProperty pageConfiguration) {
                this.pageConfiguration = pageConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceConfigurationProperty#getPageConfiguration}
             * @param pageConfiguration Configuration information for indexing Confluence pages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pageConfiguration(software.amazon.awscdk.IResolvable pageConfiguration) {
                this.pageConfiguration = pageConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceConfigurationProperty#getSpaceConfiguration}
             * @param spaceConfiguration Configuration information for indexing Confluence spaces.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spaceConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.ConfluenceSpaceConfigurationProperty spaceConfiguration) {
                this.spaceConfiguration = spaceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceConfigurationProperty#getSpaceConfiguration}
             * @param spaceConfiguration Configuration information for indexing Confluence spaces.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spaceConfiguration(software.amazon.awscdk.IResolvable spaceConfiguration) {
                this.spaceConfiguration = spaceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration Configuration information for an Amazon Virtual Private Cloud to connect to your Confluence.
             *                         For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.DataSourceVpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration Configuration information for an Amazon Virtual Private Cloud to connect to your Confluence.
             *                         For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html">Configuring a VPC</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfluenceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfluenceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfluenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfluenceConfigurationProperty {
            private final java.lang.String secretArn;
            private final java.lang.String serverUrl;
            private final java.lang.String version;
            private final java.lang.Object attachmentConfiguration;
            private final java.lang.Object blogConfiguration;
            private final java.util.List<java.lang.String> exclusionPatterns;
            private final java.util.List<java.lang.String> inclusionPatterns;
            private final java.lang.Object pageConfiguration;
            private final java.lang.Object spaceConfiguration;
            private final java.lang.Object vpcConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverUrl = software.amazon.jsii.Kernel.get(this, "serverUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.attachmentConfiguration = software.amazon.jsii.Kernel.get(this, "attachmentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.blogConfiguration = software.amazon.jsii.Kernel.get(this, "blogConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.exclusionPatterns = software.amazon.jsii.Kernel.get(this, "exclusionPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.inclusionPatterns = software.amazon.jsii.Kernel.get(this, "inclusionPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.pageConfiguration = software.amazon.jsii.Kernel.get(this, "pageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spaceConfiguration = software.amazon.jsii.Kernel.get(this, "spaceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcConfiguration = software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretArn = java.util.Objects.requireNonNull(builder.secretArn, "secretArn is required");
                this.serverUrl = java.util.Objects.requireNonNull(builder.serverUrl, "serverUrl is required");
                this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
                this.attachmentConfiguration = builder.attachmentConfiguration;
                this.blogConfiguration = builder.blogConfiguration;
                this.exclusionPatterns = builder.exclusionPatterns;
                this.inclusionPatterns = builder.inclusionPatterns;
                this.pageConfiguration = builder.pageConfiguration;
                this.spaceConfiguration = builder.spaceConfiguration;
                this.vpcConfiguration = builder.vpcConfiguration;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            public final java.lang.String getServerUrl() {
                return this.serverUrl;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            public final java.lang.Object getAttachmentConfiguration() {
                return this.attachmentConfiguration;
            }

            @Override
            public final java.lang.Object getBlogConfiguration() {
                return this.blogConfiguration;
            }

            @Override
            public final java.util.List<java.lang.String> getExclusionPatterns() {
                return this.exclusionPatterns;
            }

            @Override
            public final java.util.List<java.lang.String> getInclusionPatterns() {
                return this.inclusionPatterns;
            }

            @Override
            public final java.lang.Object getPageConfiguration() {
                return this.pageConfiguration;
            }

            @Override
            public final java.lang.Object getSpaceConfiguration() {
                return this.spaceConfiguration;
            }

            @Override
            public final java.lang.Object getVpcConfiguration() {
                return this.vpcConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("secretArn", om.valueToTree(this.getSecretArn()));
                data.set("serverUrl", om.valueToTree(this.getServerUrl()));
                data.set("version", om.valueToTree(this.getVersion()));
                if (this.getAttachmentConfiguration() != null) {
                    data.set("attachmentConfiguration", om.valueToTree(this.getAttachmentConfiguration()));
                }
                if (this.getBlogConfiguration() != null) {
                    data.set("blogConfiguration", om.valueToTree(this.getBlogConfiguration()));
                }
                if (this.getExclusionPatterns() != null) {
                    data.set("exclusionPatterns", om.valueToTree(this.getExclusionPatterns()));
                }
                if (this.getInclusionPatterns() != null) {
                    data.set("inclusionPatterns", om.valueToTree(this.getInclusionPatterns()));
                }
                if (this.getPageConfiguration() != null) {
                    data.set("pageConfiguration", om.valueToTree(this.getPageConfiguration()));
                }
                if (this.getSpaceConfiguration() != null) {
                    data.set("spaceConfiguration", om.valueToTree(this.getSpaceConfiguration()));
                }
                if (this.getVpcConfiguration() != null) {
                    data.set("vpcConfiguration", om.valueToTree(this.getVpcConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfluenceConfigurationProperty.Jsii$Proxy that = (ConfluenceConfigurationProperty.Jsii$Proxy) o;

                if (!secretArn.equals(that.secretArn)) return false;
                if (!serverUrl.equals(that.serverUrl)) return false;
                if (!version.equals(that.version)) return false;
                if (this.attachmentConfiguration != null ? !this.attachmentConfiguration.equals(that.attachmentConfiguration) : that.attachmentConfiguration != null) return false;
                if (this.blogConfiguration != null ? !this.blogConfiguration.equals(that.blogConfiguration) : that.blogConfiguration != null) return false;
                if (this.exclusionPatterns != null ? !this.exclusionPatterns.equals(that.exclusionPatterns) : that.exclusionPatterns != null) return false;
                if (this.inclusionPatterns != null ? !this.inclusionPatterns.equals(that.inclusionPatterns) : that.inclusionPatterns != null) return false;
                if (this.pageConfiguration != null ? !this.pageConfiguration.equals(that.pageConfiguration) : that.pageConfiguration != null) return false;
                if (this.spaceConfiguration != null ? !this.spaceConfiguration.equals(that.spaceConfiguration) : that.spaceConfiguration != null) return false;
                return this.vpcConfiguration != null ? this.vpcConfiguration.equals(that.vpcConfiguration) : that.vpcConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretArn.hashCode();
                result = 31 * result + (this.serverUrl.hashCode());
                result = 31 * result + (this.version.hashCode());
                result = 31 * result + (this.attachmentConfiguration != null ? this.attachmentConfiguration.hashCode() : 0);
                result = 31 * result + (this.blogConfiguration != null ? this.blogConfiguration.hashCode() : 0);
                result = 31 * result + (this.exclusionPatterns != null ? this.exclusionPatterns.hashCode() : 0);
                result = 31 * result + (this.inclusionPatterns != null ? this.inclusionPatterns.hashCode() : 0);
                result = 31 * result + (this.pageConfiguration != null ? this.pageConfiguration.hashCode() : 0);
                result = 31 * result + (this.spaceConfiguration != null ? this.spaceConfiguration.hashCode() : 0);
                result = 31 * result + (this.vpcConfiguration != null ? this.vpcConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration of the page settings for the Confluence data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * ConfluencePageConfigurationProperty confluencePageConfigurationProperty = ConfluencePageConfigurationProperty.builder()
     *         .pageFieldMappings(List.of(ConfluencePageToIndexFieldMappingProperty.builder()
     *                 .dataSourceFieldName("dataSourceFieldName")
     *                 .indexFieldName("indexFieldName")
     *                 // the properties below are optional
     *                 .dateFieldFormat("dateFieldFormat")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.ConfluencePageConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfluencePageConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfluencePageConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * >Maps attributes or field names of Confluence pages to Amazon Kendra index field names.
         * <p>
         * To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Confluence data source field names must exist in your Confluence custom metadata.
         * <p>
         * If you specify the <code>PageFieldMappings</code> parameter, you must specify at least one field mapping.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPageFieldMappings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfluencePageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfluencePageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfluencePageConfigurationProperty> {
            java.lang.Object pageFieldMappings;

            /**
             * Sets the value of {@link ConfluencePageConfigurationProperty#getPageFieldMappings}
             * @param pageFieldMappings >Maps attributes or field names of Confluence pages to Amazon Kendra index field names.
             *                          To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Confluence data source field names must exist in your Confluence custom metadata.
             *                          <p>
             *                          If you specify the <code>PageFieldMappings</code> parameter, you must specify at least one field mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pageFieldMappings(software.amazon.awscdk.IResolvable pageFieldMappings) {
                this.pageFieldMappings = pageFieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link ConfluencePageConfigurationProperty#getPageFieldMappings}
             * @param pageFieldMappings >Maps attributes or field names of Confluence pages to Amazon Kendra index field names.
             *                          To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Confluence data source field names must exist in your Confluence custom metadata.
             *                          <p>
             *                          If you specify the <code>PageFieldMappings</code> parameter, you must specify at least one field mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pageFieldMappings(java.util.List<? extends java.lang.Object> pageFieldMappings) {
                this.pageFieldMappings = pageFieldMappings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfluencePageConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfluencePageConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfluencePageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfluencePageConfigurationProperty {
            private final java.lang.Object pageFieldMappings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pageFieldMappings = software.amazon.jsii.Kernel.get(this, "pageFieldMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pageFieldMappings = builder.pageFieldMappings;
            }

            @Override
            public final java.lang.Object getPageFieldMappings() {
                return this.pageFieldMappings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPageFieldMappings() != null) {
                    data.set("pageFieldMappings", om.valueToTree(this.getPageFieldMappings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.ConfluencePageConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfluencePageConfigurationProperty.Jsii$Proxy that = (ConfluencePageConfigurationProperty.Jsii$Proxy) o;

                return this.pageFieldMappings != null ? this.pageFieldMappings.equals(that.pageFieldMappings) : that.pageFieldMappings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pageFieldMappings != null ? this.pageFieldMappings.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * >Maps attributes or field names of Confluence pages to Amazon Kendra index field names.
     * <p>
     * To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Confluence data source field names must exist in your Confluence custom metadata.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * ConfluencePageToIndexFieldMappingProperty confluencePageToIndexFieldMappingProperty = ConfluencePageToIndexFieldMappingProperty.builder()
     *         .dataSourceFieldName("dataSourceFieldName")
     *         .indexFieldName("indexFieldName")
     *         // the properties below are optional
     *         .dateFieldFormat("dateFieldFormat")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.ConfluencePageToIndexFieldMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfluencePageToIndexFieldMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfluencePageToIndexFieldMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field in the data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSourceFieldName();

        /**
         * The name of the index field to map to the Confluence data source field.
         * <p>
         * The index field type must match the Confluence field type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndexFieldName();

        /**
         * The format for date fields in the data source.
         * <p>
         * If the field specified in <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not a date field, an exception is thrown.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDateFieldFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfluencePageToIndexFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfluencePageToIndexFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfluencePageToIndexFieldMappingProperty> {
            java.lang.String dataSourceFieldName;
            java.lang.String indexFieldName;
            java.lang.String dateFieldFormat;

            /**
             * Sets the value of {@link ConfluencePageToIndexFieldMappingProperty#getDataSourceFieldName}
             * @param dataSourceFieldName The name of the field in the data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSourceFieldName(java.lang.String dataSourceFieldName) {
                this.dataSourceFieldName = dataSourceFieldName;
                return this;
            }

            /**
             * Sets the value of {@link ConfluencePageToIndexFieldMappingProperty#getIndexFieldName}
             * @param indexFieldName The name of the index field to map to the Confluence data source field. This parameter is required.
             *                       The index field type must match the Confluence field type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexFieldName(java.lang.String indexFieldName) {
                this.indexFieldName = indexFieldName;
                return this;
            }

            /**
             * Sets the value of {@link ConfluencePageToIndexFieldMappingProperty#getDateFieldFormat}
             * @param dateFieldFormat The format for date fields in the data source.
             *                        If the field specified in <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not a date field, an exception is thrown.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateFieldFormat(java.lang.String dateFieldFormat) {
                this.dateFieldFormat = dateFieldFormat;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfluencePageToIndexFieldMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfluencePageToIndexFieldMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfluencePageToIndexFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfluencePageToIndexFieldMappingProperty {
            private final java.lang.String dataSourceFieldName;
            private final java.lang.String indexFieldName;
            private final java.lang.String dateFieldFormat;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSourceFieldName = software.amazon.jsii.Kernel.get(this, "dataSourceFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.indexFieldName = software.amazon.jsii.Kernel.get(this, "indexFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dateFieldFormat = software.amazon.jsii.Kernel.get(this, "dateFieldFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSourceFieldName = java.util.Objects.requireNonNull(builder.dataSourceFieldName, "dataSourceFieldName is required");
                this.indexFieldName = java.util.Objects.requireNonNull(builder.indexFieldName, "indexFieldName is required");
                this.dateFieldFormat = builder.dateFieldFormat;
            }

            @Override
            public final java.lang.String getDataSourceFieldName() {
                return this.dataSourceFieldName;
            }

            @Override
            public final java.lang.String getIndexFieldName() {
                return this.indexFieldName;
            }

            @Override
            public final java.lang.String getDateFieldFormat() {
                return this.dateFieldFormat;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSourceFieldName", om.valueToTree(this.getDataSourceFieldName()));
                data.set("indexFieldName", om.valueToTree(this.getIndexFieldName()));
                if (this.getDateFieldFormat() != null) {
                    data.set("dateFieldFormat", om.valueToTree(this.getDateFieldFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.ConfluencePageToIndexFieldMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfluencePageToIndexFieldMappingProperty.Jsii$Proxy that = (ConfluencePageToIndexFieldMappingProperty.Jsii$Proxy) o;

                if (!dataSourceFieldName.equals(that.dataSourceFieldName)) return false;
                if (!indexFieldName.equals(that.indexFieldName)) return false;
                return this.dateFieldFormat != null ? this.dateFieldFormat.equals(that.dateFieldFormat) : that.dateFieldFormat == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataSourceFieldName.hashCode();
                result = 31 * result + (this.indexFieldName.hashCode());
                result = 31 * result + (this.dateFieldFormat != null ? this.dateFieldFormat.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration information for indexing Confluence spaces.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * ConfluenceSpaceConfigurationProperty confluenceSpaceConfigurationProperty = ConfluenceSpaceConfigurationProperty.builder()
     *         .crawlArchivedSpaces(false)
     *         .crawlPersonalSpaces(false)
     *         .excludeSpaces(List.of("excludeSpaces"))
     *         .includeSpaces(List.of("includeSpaces"))
     *         .spaceFieldMappings(List.of(ConfluenceSpaceToIndexFieldMappingProperty.builder()
     *                 .dataSourceFieldName("dataSourceFieldName")
     *                 .indexFieldName("indexFieldName")
     *                 // the properties below are optional
     *                 .dateFieldFormat("dateFieldFormat")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceSpaceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfluenceSpaceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfluenceSpaceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether Amazon Kendra should index archived spaces.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrawlArchivedSpaces() {
            return null;
        }

        /**
         * Specifies whether Amazon Kendra should index personal spaces.
         * <p>
         * Users can add restrictions to items in personal spaces. If personal spaces are indexed, queries without user context information may return restricted items from a personal space in their results. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering on user context</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrawlPersonalSpaces() {
            return null;
        }

        /**
         * A list of space keys of Confluence spaces.
         * <p>
         * If you include a key, the blogs, documents, and attachments in the space are not indexed. If a space is in both the <code>ExcludeSpaces</code> and the <code>IncludeSpaces</code> list, the space is excluded.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludeSpaces() {
            return null;
        }

        /**
         * A list of space keys for Confluence spaces.
         * <p>
         * If you include a key, the blogs, documents, and attachments in the space are indexed. Spaces that aren't in the list aren't indexed. A space in the list must exist. Otherwise, Amazon Kendra logs an error when the data source is synchronized. If a space is in both the <code>IncludeSpaces</code> and the <code>ExcludeSpaces</code> list, the space is excluded.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludeSpaces() {
            return null;
        }

        /**
         * Maps attributes or field names of Confluence spaces to Amazon Kendra index field names.
         * <p>
         * To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Confluence data source field names must exist in your Confluence custom metadata.
         * <p>
         * If you specify the <code>SpaceFieldMappings</code> parameter, you must specify at least one field mapping.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSpaceFieldMappings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfluenceSpaceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfluenceSpaceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfluenceSpaceConfigurationProperty> {
            java.lang.Object crawlArchivedSpaces;
            java.lang.Object crawlPersonalSpaces;
            java.util.List<java.lang.String> excludeSpaces;
            java.util.List<java.lang.String> includeSpaces;
            java.lang.Object spaceFieldMappings;

            /**
             * Sets the value of {@link ConfluenceSpaceConfigurationProperty#getCrawlArchivedSpaces}
             * @param crawlArchivedSpaces Specifies whether Amazon Kendra should index archived spaces.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlArchivedSpaces(java.lang.Boolean crawlArchivedSpaces) {
                this.crawlArchivedSpaces = crawlArchivedSpaces;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceSpaceConfigurationProperty#getCrawlArchivedSpaces}
             * @param crawlArchivedSpaces Specifies whether Amazon Kendra should index archived spaces.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlArchivedSpaces(software.amazon.awscdk.IResolvable crawlArchivedSpaces) {
                this.crawlArchivedSpaces = crawlArchivedSpaces;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceSpaceConfigurationProperty#getCrawlPersonalSpaces}
             * @param crawlPersonalSpaces Specifies whether Amazon Kendra should index personal spaces.
             *                            Users can add restrictions to items in personal spaces. If personal spaces are indexed, queries without user context information may return restricted items from a personal space in their results. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering on user context</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlPersonalSpaces(java.lang.Boolean crawlPersonalSpaces) {
                this.crawlPersonalSpaces = crawlPersonalSpaces;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceSpaceConfigurationProperty#getCrawlPersonalSpaces}
             * @param crawlPersonalSpaces Specifies whether Amazon Kendra should index personal spaces.
             *                            Users can add restrictions to items in personal spaces. If personal spaces are indexed, queries without user context information may return restricted items from a personal space in their results. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering on user context</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlPersonalSpaces(software.amazon.awscdk.IResolvable crawlPersonalSpaces) {
                this.crawlPersonalSpaces = crawlPersonalSpaces;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceSpaceConfigurationProperty#getExcludeSpaces}
             * @param excludeSpaces A list of space keys of Confluence spaces.
             *                      If you include a key, the blogs, documents, and attachments in the space are not indexed. If a space is in both the <code>ExcludeSpaces</code> and the <code>IncludeSpaces</code> list, the space is excluded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeSpaces(java.util.List<java.lang.String> excludeSpaces) {
                this.excludeSpaces = excludeSpaces;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceSpaceConfigurationProperty#getIncludeSpaces}
             * @param includeSpaces A list of space keys for Confluence spaces.
             *                      If you include a key, the blogs, documents, and attachments in the space are indexed. Spaces that aren't in the list aren't indexed. A space in the list must exist. Otherwise, Amazon Kendra logs an error when the data source is synchronized. If a space is in both the <code>IncludeSpaces</code> and the <code>ExcludeSpaces</code> list, the space is excluded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSpaces(java.util.List<java.lang.String> includeSpaces) {
                this.includeSpaces = includeSpaces;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceSpaceConfigurationProperty#getSpaceFieldMappings}
             * @param spaceFieldMappings Maps attributes or field names of Confluence spaces to Amazon Kendra index field names.
             *                           To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Confluence data source field names must exist in your Confluence custom metadata.
             *                           <p>
             *                           If you specify the <code>SpaceFieldMappings</code> parameter, you must specify at least one field mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spaceFieldMappings(software.amazon.awscdk.IResolvable spaceFieldMappings) {
                this.spaceFieldMappings = spaceFieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceSpaceConfigurationProperty#getSpaceFieldMappings}
             * @param spaceFieldMappings Maps attributes or field names of Confluence spaces to Amazon Kendra index field names.
             *                           To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Confluence data source field names must exist in your Confluence custom metadata.
             *                           <p>
             *                           If you specify the <code>SpaceFieldMappings</code> parameter, you must specify at least one field mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spaceFieldMappings(java.util.List<? extends java.lang.Object> spaceFieldMappings) {
                this.spaceFieldMappings = spaceFieldMappings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfluenceSpaceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfluenceSpaceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfluenceSpaceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfluenceSpaceConfigurationProperty {
            private final java.lang.Object crawlArchivedSpaces;
            private final java.lang.Object crawlPersonalSpaces;
            private final java.util.List<java.lang.String> excludeSpaces;
            private final java.util.List<java.lang.String> includeSpaces;
            private final java.lang.Object spaceFieldMappings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.crawlArchivedSpaces = software.amazon.jsii.Kernel.get(this, "crawlArchivedSpaces", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.crawlPersonalSpaces = software.amazon.jsii.Kernel.get(this, "crawlPersonalSpaces", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludeSpaces = software.amazon.jsii.Kernel.get(this, "excludeSpaces", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.includeSpaces = software.amazon.jsii.Kernel.get(this, "includeSpaces", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.spaceFieldMappings = software.amazon.jsii.Kernel.get(this, "spaceFieldMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.crawlArchivedSpaces = builder.crawlArchivedSpaces;
                this.crawlPersonalSpaces = builder.crawlPersonalSpaces;
                this.excludeSpaces = builder.excludeSpaces;
                this.includeSpaces = builder.includeSpaces;
                this.spaceFieldMappings = builder.spaceFieldMappings;
            }

            @Override
            public final java.lang.Object getCrawlArchivedSpaces() {
                return this.crawlArchivedSpaces;
            }

            @Override
            public final java.lang.Object getCrawlPersonalSpaces() {
                return this.crawlPersonalSpaces;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludeSpaces() {
                return this.excludeSpaces;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludeSpaces() {
                return this.includeSpaces;
            }

            @Override
            public final java.lang.Object getSpaceFieldMappings() {
                return this.spaceFieldMappings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCrawlArchivedSpaces() != null) {
                    data.set("crawlArchivedSpaces", om.valueToTree(this.getCrawlArchivedSpaces()));
                }
                if (this.getCrawlPersonalSpaces() != null) {
                    data.set("crawlPersonalSpaces", om.valueToTree(this.getCrawlPersonalSpaces()));
                }
                if (this.getExcludeSpaces() != null) {
                    data.set("excludeSpaces", om.valueToTree(this.getExcludeSpaces()));
                }
                if (this.getIncludeSpaces() != null) {
                    data.set("includeSpaces", om.valueToTree(this.getIncludeSpaces()));
                }
                if (this.getSpaceFieldMappings() != null) {
                    data.set("spaceFieldMappings", om.valueToTree(this.getSpaceFieldMappings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceSpaceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfluenceSpaceConfigurationProperty.Jsii$Proxy that = (ConfluenceSpaceConfigurationProperty.Jsii$Proxy) o;

                if (this.crawlArchivedSpaces != null ? !this.crawlArchivedSpaces.equals(that.crawlArchivedSpaces) : that.crawlArchivedSpaces != null) return false;
                if (this.crawlPersonalSpaces != null ? !this.crawlPersonalSpaces.equals(that.crawlPersonalSpaces) : that.crawlPersonalSpaces != null) return false;
                if (this.excludeSpaces != null ? !this.excludeSpaces.equals(that.excludeSpaces) : that.excludeSpaces != null) return false;
                if (this.includeSpaces != null ? !this.includeSpaces.equals(that.includeSpaces) : that.includeSpaces != null) return false;
                return this.spaceFieldMappings != null ? this.spaceFieldMappings.equals(that.spaceFieldMappings) : that.spaceFieldMappings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.crawlArchivedSpaces != null ? this.crawlArchivedSpaces.hashCode() : 0;
                result = 31 * result + (this.crawlPersonalSpaces != null ? this.crawlPersonalSpaces.hashCode() : 0);
                result = 31 * result + (this.excludeSpaces != null ? this.excludeSpaces.hashCode() : 0);
                result = 31 * result + (this.includeSpaces != null ? this.includeSpaces.hashCode() : 0);
                result = 31 * result + (this.spaceFieldMappings != null ? this.spaceFieldMappings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * >Maps attributes or field names of Confluence spaces to Amazon Kendra index field names.
     * <p>
     * To create custom fields, use the <code>UpdateIndex</code> API before you map to Confluence fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Confluence data source field names must exist in your Confluence custom metadata.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * ConfluenceSpaceToIndexFieldMappingProperty confluenceSpaceToIndexFieldMappingProperty = ConfluenceSpaceToIndexFieldMappingProperty.builder()
     *         .dataSourceFieldName("dataSourceFieldName")
     *         .indexFieldName("indexFieldName")
     *         // the properties below are optional
     *         .dateFieldFormat("dateFieldFormat")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceSpaceToIndexFieldMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfluenceSpaceToIndexFieldMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfluenceSpaceToIndexFieldMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field in the data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSourceFieldName();

        /**
         * The name of the index field to map to the Confluence data source field.
         * <p>
         * The index field type must match the Confluence field type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndexFieldName();

        /**
         * The format for date fields in the data source.
         * <p>
         * If the field specified in <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not a date field, an exception is thrown.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDateFieldFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfluenceSpaceToIndexFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfluenceSpaceToIndexFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfluenceSpaceToIndexFieldMappingProperty> {
            java.lang.String dataSourceFieldName;
            java.lang.String indexFieldName;
            java.lang.String dateFieldFormat;

            /**
             * Sets the value of {@link ConfluenceSpaceToIndexFieldMappingProperty#getDataSourceFieldName}
             * @param dataSourceFieldName The name of the field in the data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSourceFieldName(java.lang.String dataSourceFieldName) {
                this.dataSourceFieldName = dataSourceFieldName;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceSpaceToIndexFieldMappingProperty#getIndexFieldName}
             * @param indexFieldName The name of the index field to map to the Confluence data source field. This parameter is required.
             *                       The index field type must match the Confluence field type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexFieldName(java.lang.String indexFieldName) {
                this.indexFieldName = indexFieldName;
                return this;
            }

            /**
             * Sets the value of {@link ConfluenceSpaceToIndexFieldMappingProperty#getDateFieldFormat}
             * @param dateFieldFormat The format for date fields in the data source.
             *                        If the field specified in <code>DataSourceFieldName</code> is a date field you must specify the date format. If the field is not a date field, an exception is thrown.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateFieldFormat(java.lang.String dateFieldFormat) {
                this.dateFieldFormat = dateFieldFormat;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfluenceSpaceToIndexFieldMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfluenceSpaceToIndexFieldMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfluenceSpaceToIndexFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfluenceSpaceToIndexFieldMappingProperty {
            private final java.lang.String dataSourceFieldName;
            private final java.lang.String indexFieldName;
            private final java.lang.String dateFieldFormat;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSourceFieldName = software.amazon.jsii.Kernel.get(this, "dataSourceFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.indexFieldName = software.amazon.jsii.Kernel.get(this, "indexFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dateFieldFormat = software.amazon.jsii.Kernel.get(this, "dateFieldFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSourceFieldName = java.util.Objects.requireNonNull(builder.dataSourceFieldName, "dataSourceFieldName is required");
                this.indexFieldName = java.util.Objects.requireNonNull(builder.indexFieldName, "indexFieldName is required");
                this.dateFieldFormat = builder.dateFieldFormat;
            }

            @Override
            public final java.lang.String getDataSourceFieldName() {
                return this.dataSourceFieldName;
            }

            @Override
            public final java.lang.String getIndexFieldName() {
                return this.indexFieldName;
            }

            @Override
            public final java.lang.String getDateFieldFormat() {
                return this.dateFieldFormat;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSourceFieldName", om.valueToTree(this.getDataSourceFieldName()));
                data.set("indexFieldName", om.valueToTree(this.getIndexFieldName()));
                if (this.getDateFieldFormat() != null) {
                    data.set("dateFieldFormat", om.valueToTree(this.getDateFieldFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.ConfluenceSpaceToIndexFieldMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfluenceSpaceToIndexFieldMappingProperty.Jsii$Proxy that = (ConfluenceSpaceToIndexFieldMappingProperty.Jsii$Proxy) o;

                if (!dataSourceFieldName.equals(that.dataSourceFieldName)) return false;
                if (!indexFieldName.equals(that.indexFieldName)) return false;
                return this.dateFieldFormat != null ? this.dateFieldFormat.equals(that.dateFieldFormat) : that.dateFieldFormat == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataSourceFieldName.hashCode();
                result = 31 * result + (this.indexFieldName.hashCode());
                result = 31 * result + (this.dateFieldFormat != null ? this.dateFieldFormat.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information that's required to connect to a database.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * ConnectionConfigurationProperty connectionConfigurationProperty = ConnectionConfigurationProperty.builder()
     *         .databaseHost("databaseHost")
     *         .databaseName("databaseName")
     *         .databasePort(123)
     *         .secretArn("secretArn")
     *         .tableName("tableName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.ConnectionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the host for the database.
         * <p>
         * Can be either a string (host.subdomain.domain.tld) or an IPv4 or IPv6 address.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseHost();

        /**
         * The name of the database containing the document data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * The port that the database uses for connections.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDatabasePort();

        /**
         * The Amazon Resource Name (ARN) of credentials stored in AWS Secrets Manager .
         * <p>
         * The credentials should be a user/password pair. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html">Using a Database Data Source</a> . For more information about AWS Secrets Manager , see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">What Is AWS Secrets Manager</a> in the <em>AWS Secrets Manager</em> user guide.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretArn();

        /**
         * The name of the table that contains the document data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * @return a {@link Builder} of {@link ConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectionConfigurationProperty> {
            java.lang.String databaseHost;
            java.lang.String databaseName;
            java.lang.Number databasePort;
            java.lang.String secretArn;
            java.lang.String tableName;

            /**
             * Sets the value of {@link ConnectionConfigurationProperty#getDatabaseHost}
             * @param databaseHost The name of the host for the database. This parameter is required.
             *                     Can be either a string (host.subdomain.domain.tld) or an IPv4 or IPv6 address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseHost(java.lang.String databaseHost) {
                this.databaseHost = databaseHost;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionConfigurationProperty#getDatabaseName}
             * @param databaseName The name of the database containing the document data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionConfigurationProperty#getDatabasePort}
             * @param databasePort The port that the database uses for connections. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databasePort(java.lang.Number databasePort) {
                this.databasePort = databasePort;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionConfigurationProperty#getSecretArn}
             * @param secretArn The Amazon Resource Name (ARN) of credentials stored in AWS Secrets Manager . This parameter is required.
             *                  The credentials should be a user/password pair. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html">Using a Database Data Source</a> . For more information about AWS Secrets Manager , see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">What Is AWS Secrets Manager</a> in the <em>AWS Secrets Manager</em> user guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionConfigurationProperty#getTableName}
             * @param tableName The name of the table that contains the document data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionConfigurationProperty {
            private final java.lang.String databaseHost;
            private final java.lang.String databaseName;
            private final java.lang.Number databasePort;
            private final java.lang.String secretArn;
            private final java.lang.String tableName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseHost = software.amazon.jsii.Kernel.get(this, "databaseHost", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databasePort = software.amazon.jsii.Kernel.get(this, "databasePort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseHost = java.util.Objects.requireNonNull(builder.databaseHost, "databaseHost is required");
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.databasePort = java.util.Objects.requireNonNull(builder.databasePort, "databasePort is required");
                this.secretArn = java.util.Objects.requireNonNull(builder.secretArn, "secretArn is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
            }

            @Override
            public final java.lang.String getDatabaseHost() {
                return this.databaseHost;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.Number getDatabasePort() {
                return this.databasePort;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseHost", om.valueToTree(this.getDatabaseHost()));
                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("databasePort", om.valueToTree(this.getDatabasePort()));
                data.set("secretArn", om.valueToTree(this.getSecretArn()));
                data.set("tableName", om.valueToTree(this.getTableName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.ConnectionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectionConfigurationProperty.Jsii$Proxy that = (ConnectionConfigurationProperty.Jsii$Proxy) o;

                if (!databaseHost.equals(that.databaseHost)) return false;
                if (!databaseName.equals(that.databaseName)) return false;
                if (!databasePort.equals(that.databasePort)) return false;
                if (!secretArn.equals(that.secretArn)) return false;
                return this.tableName.equals(that.tableName);
            }

            @Override
            public final int hashCode() {
                int result = this.databaseHost.hashCode();
                result = 31 * result + (this.databaseName.hashCode());
                result = 31 * result + (this.databasePort.hashCode());
                result = 31 * result + (this.secretArn.hashCode());
                result = 31 * result + (this.tableName.hashCode());
                return result;
            }
        }
    }
    /**
     * Provides the configuration information for altering document metadata and content during the document ingestion process.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * CustomDocumentEnrichmentConfigurationProperty customDocumentEnrichmentConfigurationProperty = CustomDocumentEnrichmentConfigurationProperty.builder()
     *         .inlineConfigurations(List.of(InlineCustomDocumentEnrichmentConfigurationProperty.builder()
     *                 .condition(DocumentAttributeConditionProperty.builder()
     *                         .conditionDocumentAttributeKey("conditionDocumentAttributeKey")
     *                         .operator("operator")
     *                         // the properties below are optional
     *                         .conditionOnValue(DocumentAttributeValueProperty.builder()
     *                                 .dateValue("dateValue")
     *                                 .longValue(123)
     *                                 .stringListValue(List.of("stringListValue"))
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         .build())
     *                 .documentContentDeletion(false)
     *                 .target(DocumentAttributeTargetProperty.builder()
     *                         .targetDocumentAttributeKey("targetDocumentAttributeKey")
     *                         // the properties below are optional
     *                         .targetDocumentAttributeValue(DocumentAttributeValueProperty.builder()
     *                                 .dateValue("dateValue")
     *                                 .longValue(123)
     *                                 .stringListValue(List.of("stringListValue"))
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         .targetDocumentAttributeValueDeletion(false)
     *                         .build())
     *                 .build()))
     *         .postExtractionHookConfiguration(HookConfigurationProperty.builder()
     *                 .lambdaArn("lambdaArn")
     *                 .s3Bucket("s3Bucket")
     *                 // the properties below are optional
     *                 .invocationCondition(DocumentAttributeConditionProperty.builder()
     *                         .conditionDocumentAttributeKey("conditionDocumentAttributeKey")
     *                         .operator("operator")
     *                         // the properties below are optional
     *                         .conditionOnValue(DocumentAttributeValueProperty.builder()
     *                                 .dateValue("dateValue")
     *                                 .longValue(123)
     *                                 .stringListValue(List.of("stringListValue"))
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .preExtractionHookConfiguration(HookConfigurationProperty.builder()
     *                 .lambdaArn("lambdaArn")
     *                 .s3Bucket("s3Bucket")
     *                 // the properties below are optional
     *                 .invocationCondition(DocumentAttributeConditionProperty.builder()
     *                         .conditionDocumentAttributeKey("conditionDocumentAttributeKey")
     *                         .operator("operator")
     *                         // the properties below are optional
     *                         .conditionOnValue(DocumentAttributeValueProperty.builder()
     *                                 .dateValue("dateValue")
     *                                 .longValue(123)
     *                                 .stringListValue(List.of("stringListValue"))
     *                                 .stringValue("stringValue")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.CustomDocumentEnrichmentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomDocumentEnrichmentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomDocumentEnrichmentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Kendra.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInlineConfigurations() {
            return null;
        }

        /**
         * Configuration information for invoking a Lambda function in AWS Lambda on the structured documents with their metadata and text extracted.
         * <p>
         * You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation">Advanced data manipulation</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPostExtractionHookConfiguration() {
            return null;
        }

        /**
         * Configuration information for invoking a Lambda function in AWS Lambda on the original or raw documents before extracting their metadata and text.
         * <p>
         * You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation">Advanced data manipulation</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPreExtractionHookConfiguration() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of a role with permission to run `PreExtractionHookConfiguration` and `PostExtractionHookConfiguration` for altering document metadata and content during the document ingestion process.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomDocumentEnrichmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomDocumentEnrichmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomDocumentEnrichmentConfigurationProperty> {
            java.lang.Object inlineConfigurations;
            java.lang.Object postExtractionHookConfiguration;
            java.lang.Object preExtractionHookConfiguration;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link CustomDocumentEnrichmentConfigurationProperty#getInlineConfigurations}
             * @param inlineConfigurations Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Kendra.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inlineConfigurations(software.amazon.awscdk.IResolvable inlineConfigurations) {
                this.inlineConfigurations = inlineConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link CustomDocumentEnrichmentConfigurationProperty#getInlineConfigurations}
             * @param inlineConfigurations Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Kendra.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inlineConfigurations(java.util.List<? extends java.lang.Object> inlineConfigurations) {
                this.inlineConfigurations = inlineConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link CustomDocumentEnrichmentConfigurationProperty#getPostExtractionHookConfiguration}
             * @param postExtractionHookConfiguration Configuration information for invoking a Lambda function in AWS Lambda on the structured documents with their metadata and text extracted.
             *                                        You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation">Advanced data manipulation</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postExtractionHookConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.HookConfigurationProperty postExtractionHookConfiguration) {
                this.postExtractionHookConfiguration = postExtractionHookConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CustomDocumentEnrichmentConfigurationProperty#getPostExtractionHookConfiguration}
             * @param postExtractionHookConfiguration Configuration information for invoking a Lambda function in AWS Lambda on the structured documents with their metadata and text extracted.
             *                                        You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation">Advanced data manipulation</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postExtractionHookConfiguration(software.amazon.awscdk.IResolvable postExtractionHookConfiguration) {
                this.postExtractionHookConfiguration = postExtractionHookConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CustomDocumentEnrichmentConfigurationProperty#getPreExtractionHookConfiguration}
             * @param preExtractionHookConfiguration Configuration information for invoking a Lambda function in AWS Lambda on the original or raw documents before extracting their metadata and text.
             *                                       You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation">Advanced data manipulation</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preExtractionHookConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.HookConfigurationProperty preExtractionHookConfiguration) {
                this.preExtractionHookConfiguration = preExtractionHookConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CustomDocumentEnrichmentConfigurationProperty#getPreExtractionHookConfiguration}
             * @param preExtractionHookConfiguration Configuration information for invoking a Lambda function in AWS Lambda on the original or raw documents before extracting their metadata and text.
             *                                       You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation">Advanced data manipulation</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preExtractionHookConfiguration(software.amazon.awscdk.IResolvable preExtractionHookConfiguration) {
                this.preExtractionHookConfiguration = preExtractionHookConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link CustomDocumentEnrichmentConfigurationProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of a role with permission to run `PreExtractionHookConfiguration` and `PostExtractionHookConfiguration` for altering document metadata and content during the document ingestion process.
             *                For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomDocumentEnrichmentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomDocumentEnrichmentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomDocumentEnrichmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomDocumentEnrichmentConfigurationProperty {
            private final java.lang.Object inlineConfigurations;
            private final java.lang.Object postExtractionHookConfiguration;
            private final java.lang.Object preExtractionHookConfiguration;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inlineConfigurations = software.amazon.jsii.Kernel.get(this, "inlineConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.postExtractionHookConfiguration = software.amazon.jsii.Kernel.get(this, "postExtractionHookConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.preExtractionHookConfiguration = software.amazon.jsii.Kernel.get(this, "preExtractionHookConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inlineConfigurations = builder.inlineConfigurations;
                this.postExtractionHookConfiguration = builder.postExtractionHookConfiguration;
                this.preExtractionHookConfiguration = builder.preExtractionHookConfiguration;
                this.roleArn = builder.roleArn;
            }

            @Override
            public final java.lang.Object getInlineConfigurations() {
                return this.inlineConfigurations;
            }

            @Override
            public final java.lang.Object getPostExtractionHookConfiguration() {
                return this.postExtractionHookConfiguration;
            }

            @Override
            public final java.lang.Object getPreExtractionHookConfiguration() {
                return this.preExtractionHookConfiguration;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInlineConfigurations() != null) {
                    data.set("inlineConfigurations", om.valueToTree(this.getInlineConfigurations()));
                }
                if (this.getPostExtractionHookConfiguration() != null) {
                    data.set("postExtractionHookConfiguration", om.valueToTree(this.getPostExtractionHookConfiguration()));
                }
                if (this.getPreExtractionHookConfiguration() != null) {
                    data.set("preExtractionHookConfiguration", om.valueToTree(this.getPreExtractionHookConfiguration()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.CustomDocumentEnrichmentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomDocumentEnrichmentConfigurationProperty.Jsii$Proxy that = (CustomDocumentEnrichmentConfigurationProperty.Jsii$Proxy) o;

                if (this.inlineConfigurations != null ? !this.inlineConfigurations.equals(that.inlineConfigurations) : that.inlineConfigurations != null) return false;
                if (this.postExtractionHookConfiguration != null ? !this.postExtractionHookConfiguration.equals(that.postExtractionHookConfiguration) : that.postExtractionHookConfiguration != null) return false;
                if (this.preExtractionHookConfiguration != null ? !this.preExtractionHookConfiguration.equals(that.preExtractionHookConfiguration) : that.preExtractionHookConfiguration != null) return false;
                return this.roleArn != null ? this.roleArn.equals(that.roleArn) : that.roleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inlineConfigurations != null ? this.inlineConfigurations.hashCode() : 0;
                result = 31 * result + (this.postExtractionHookConfiguration != null ? this.postExtractionHookConfiguration.hashCode() : 0);
                result = 31 * result + (this.preExtractionHookConfiguration != null ? this.preExtractionHookConfiguration.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information for an Amazon Kendra data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * DataSourceConfigurationProperty dataSourceConfigurationProperty = DataSourceConfigurationProperty.builder()
     *         .confluenceConfiguration(ConfluenceConfigurationProperty.builder()
     *                 .secretArn("secretArn")
     *                 .serverUrl("serverUrl")
     *                 .version("version")
     *                 // the properties below are optional
     *                 .attachmentConfiguration(ConfluenceAttachmentConfigurationProperty.builder()
     *                         .attachmentFieldMappings(List.of(ConfluenceAttachmentToIndexFieldMappingProperty.builder()
     *                                 .dataSourceFieldName("dataSourceFieldName")
     *                                 .indexFieldName("indexFieldName")
     *                                 // the properties below are optional
     *                                 .dateFieldFormat("dateFieldFormat")
     *                                 .build()))
     *                         .crawlAttachments(false)
     *                         .build())
     *                 .blogConfiguration(ConfluenceBlogConfigurationProperty.builder()
     *                         .blogFieldMappings(List.of(ConfluenceBlogToIndexFieldMappingProperty.builder()
     *                                 .dataSourceFieldName("dataSourceFieldName")
     *                                 .indexFieldName("indexFieldName")
     *                                 // the properties below are optional
     *                                 .dateFieldFormat("dateFieldFormat")
     *                                 .build()))
     *                         .build())
     *                 .exclusionPatterns(List.of("exclusionPatterns"))
     *                 .inclusionPatterns(List.of("inclusionPatterns"))
     *                 .pageConfiguration(ConfluencePageConfigurationProperty.builder()
     *                         .pageFieldMappings(List.of(ConfluencePageToIndexFieldMappingProperty.builder()
     *                                 .dataSourceFieldName("dataSourceFieldName")
     *                                 .indexFieldName("indexFieldName")
     *                                 // the properties below are optional
     *                                 .dateFieldFormat("dateFieldFormat")
     *                                 .build()))
     *                         .build())
     *                 .spaceConfiguration(ConfluenceSpaceConfigurationProperty.builder()
     *                         .crawlArchivedSpaces(false)
     *                         .crawlPersonalSpaces(false)
     *                         .excludeSpaces(List.of("excludeSpaces"))
     *                         .includeSpaces(List.of("includeSpaces"))
     *                         .spaceFieldMappings(List.of(ConfluenceSpaceToIndexFieldMappingProperty.builder()
     *                                 .dataSourceFieldName("dataSourceFieldName")
     *                                 .indexFieldName("indexFieldName")
     *                                 // the properties below are optional
     *                                 .dateFieldFormat("dateFieldFormat")
     *                                 .build()))
     *                         .build())
     *                 .vpcConfiguration(DataSourceVpcConfigurationProperty.builder()
     *                         .securityGroupIds(List.of("securityGroupIds"))
     *                         .subnetIds(List.of("subnetIds"))
     *                         .build())
     *                 .build())
     *         .databaseConfiguration(DatabaseConfigurationProperty.builder()
     *                 .columnConfiguration(ColumnConfigurationProperty.builder()
     *                         .changeDetectingColumns(List.of("changeDetectingColumns"))
     *                         .documentDataColumnName("documentDataColumnName")
     *                         .documentIdColumnName("documentIdColumnName")
     *                         // the properties below are optional
     *                         .documentTitleColumnName("documentTitleColumnName")
     *                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                                 .dataSourceFieldName("dataSourceFieldName")
     *                                 .indexFieldName("indexFieldName")
     *                                 // the properties below are optional
     *                                 .dateFieldFormat("dateFieldFormat")
     *                                 .build()))
     *                         .build())
     *                 .connectionConfiguration(ConnectionConfigurationProperty.builder()
     *                         .databaseHost("databaseHost")
     *                         .databaseName("databaseName")
     *                         .databasePort(123)
     *                         .secretArn("secretArn")
     *                         .tableName("tableName")
     *                         .build())
     *                 .databaseEngineType("databaseEngineType")
     *                 // the properties below are optional
     *                 .aclConfiguration(AclConfigurationProperty.builder()
     *                         .allowedGroupsColumnName("allowedGroupsColumnName")
     *                         .build())
     *                 .sqlConfiguration(SqlConfigurationProperty.builder()
     *                         .queryIdentifiersEnclosingOption("queryIdentifiersEnclosingOption")
     *                         .build())
     *                 .vpcConfiguration(DataSourceVpcConfigurationProperty.builder()
     *                         .securityGroupIds(List.of("securityGroupIds"))
     *                         .subnetIds(List.of("subnetIds"))
     *                         .build())
     *                 .build())
     *         .googleDriveConfiguration(GoogleDriveConfigurationProperty.builder()
     *                 .secretArn("secretArn")
     *                 // the properties below are optional
     *                 .excludeMimeTypes(List.of("excludeMimeTypes"))
     *                 .excludeSharedDrives(List.of("excludeSharedDrives"))
     *                 .excludeUserAccounts(List.of("excludeUserAccounts"))
     *                 .exclusionPatterns(List.of("exclusionPatterns"))
     *                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                         .dataSourceFieldName("dataSourceFieldName")
     *                         .indexFieldName("indexFieldName")
     *                         // the properties below are optional
     *                         .dateFieldFormat("dateFieldFormat")
     *                         .build()))
     *                 .inclusionPatterns(List.of("inclusionPatterns"))
     *                 .build())
     *         .oneDriveConfiguration(OneDriveConfigurationProperty.builder()
     *                 .oneDriveUsers(OneDriveUsersProperty.builder()
     *                         .oneDriveUserList(List.of("oneDriveUserList"))
     *                         .oneDriveUserS3Path(S3PathProperty.builder()
     *                                 .bucket("bucket")
     *                                 .key("key")
     *                                 .build())
     *                         .build())
     *                 .secretArn("secretArn")
     *                 .tenantDomain("tenantDomain")
     *                 // the properties below are optional
     *                 .disableLocalGroups(false)
     *                 .exclusionPatterns(List.of("exclusionPatterns"))
     *                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                         .dataSourceFieldName("dataSourceFieldName")
     *                         .indexFieldName("indexFieldName")
     *                         // the properties below are optional
     *                         .dateFieldFormat("dateFieldFormat")
     *                         .build()))
     *                 .inclusionPatterns(List.of("inclusionPatterns"))
     *                 .build())
     *         .s3Configuration(S3DataSourceConfigurationProperty.builder()
     *                 .bucketName("bucketName")
     *                 // the properties below are optional
     *                 .accessControlListConfiguration(AccessControlListConfigurationProperty.builder()
     *                         .keyPath("keyPath")
     *                         .build())
     *                 .documentsMetadataConfiguration(DocumentsMetadataConfigurationProperty.builder()
     *                         .s3Prefix("s3Prefix")
     *                         .build())
     *                 .exclusionPatterns(List.of("exclusionPatterns"))
     *                 .inclusionPatterns(List.of("inclusionPatterns"))
     *                 .inclusionPrefixes(List.of("inclusionPrefixes"))
     *                 .build())
     *         .salesforceConfiguration(SalesforceConfigurationProperty.builder()
     *                 .secretArn("secretArn")
     *                 .serverUrl("serverUrl")
     *                 // the properties below are optional
     *                 .chatterFeedConfiguration(SalesforceChatterFeedConfigurationProperty.builder()
     *                         .documentDataFieldName("documentDataFieldName")
     *                         // the properties below are optional
     *                         .documentTitleFieldName("documentTitleFieldName")
     *                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                                 .dataSourceFieldName("dataSourceFieldName")
     *                                 .indexFieldName("indexFieldName")
     *                                 // the properties below are optional
     *                                 .dateFieldFormat("dateFieldFormat")
     *                                 .build()))
     *                         .includeFilterTypes(List.of("includeFilterTypes"))
     *                         .build())
     *                 .crawlAttachments(false)
     *                 .excludeAttachmentFilePatterns(List.of("excludeAttachmentFilePatterns"))
     *                 .includeAttachmentFilePatterns(List.of("includeAttachmentFilePatterns"))
     *                 .knowledgeArticleConfiguration(SalesforceKnowledgeArticleConfigurationProperty.builder()
     *                         .includedStates(List.of("includedStates"))
     *                         // the properties below are optional
     *                         .customKnowledgeArticleTypeConfigurations(List.of(SalesforceCustomKnowledgeArticleTypeConfigurationProperty.builder()
     *                                 .documentDataFieldName("documentDataFieldName")
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .documentTitleFieldName("documentTitleFieldName")
     *                                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                                         .dataSourceFieldName("dataSourceFieldName")
     *                                         .indexFieldName("indexFieldName")
     *                                         // the properties below are optional
     *                                         .dateFieldFormat("dateFieldFormat")
     *                                         .build()))
     *                                 .build()))
     *                         .standardKnowledgeArticleTypeConfiguration(SalesforceStandardKnowledgeArticleTypeConfigurationProperty.builder()
     *                                 .documentDataFieldName("documentDataFieldName")
     *                                 // the properties below are optional
     *                                 .documentTitleFieldName("documentTitleFieldName")
     *                                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                                         .dataSourceFieldName("dataSourceFieldName")
     *                                         .indexFieldName("indexFieldName")
     *                                         // the properties below are optional
     *                                         .dateFieldFormat("dateFieldFormat")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .standardObjectAttachmentConfiguration(SalesforceStandardObjectAttachmentConfigurationProperty.builder()
     *                         .documentTitleFieldName("documentTitleFieldName")
     *                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                                 .dataSourceFieldName("dataSourceFieldName")
     *                                 .indexFieldName("indexFieldName")
     *                                 // the properties below are optional
     *                                 .dateFieldFormat("dateFieldFormat")
     *                                 .build()))
     *                         .build())
     *                 .standardObjectConfigurations(List.of(SalesforceStandardObjectConfigurationProperty.builder()
     *                         .documentDataFieldName("documentDataFieldName")
     *                         .name("name")
     *                         // the properties below are optional
     *                         .documentTitleFieldName("documentTitleFieldName")
     *                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                                 .dataSourceFieldName("dataSourceFieldName")
     *                                 .indexFieldName("indexFieldName")
     *                                 // the properties below are optional
     *                                 .dateFieldFormat("dateFieldFormat")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .serviceNowConfiguration(ServiceNowConfigurationProperty.builder()
     *                 .hostUrl("hostUrl")
     *                 .secretArn("secretArn")
     *                 .serviceNowBuildVersion("serviceNowBuildVersion")
     *                 // the properties below are optional
     *                 .authenticationType("authenticationType")
     *                 .knowledgeArticleConfiguration(ServiceNowKnowledgeArticleConfigurationProperty.builder()
     *                         .documentDataFieldName("documentDataFieldName")
     *                         // the properties below are optional
     *                         .crawlAttachments(false)
     *                         .documentTitleFieldName("documentTitleFieldName")
     *                         .excludeAttachmentFilePatterns(List.of("excludeAttachmentFilePatterns"))
     *                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                                 .dataSourceFieldName("dataSourceFieldName")
     *                                 .indexFieldName("indexFieldName")
     *                                 // the properties below are optional
     *                                 .dateFieldFormat("dateFieldFormat")
     *                                 .build()))
     *                         .filterQuery("filterQuery")
     *                         .includeAttachmentFilePatterns(List.of("includeAttachmentFilePatterns"))
     *                         .build())
     *                 .serviceCatalogConfiguration(ServiceNowServiceCatalogConfigurationProperty.builder()
     *                         .documentDataFieldName("documentDataFieldName")
     *                         // the properties below are optional
     *                         .crawlAttachments(false)
     *                         .documentTitleFieldName("documentTitleFieldName")
     *                         .excludeAttachmentFilePatterns(List.of("excludeAttachmentFilePatterns"))
     *                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                                 .dataSourceFieldName("dataSourceFieldName")
     *                                 .indexFieldName("indexFieldName")
     *                                 // the properties below are optional
     *                                 .dateFieldFormat("dateFieldFormat")
     *                                 .build()))
     *                         .includeAttachmentFilePatterns(List.of("includeAttachmentFilePatterns"))
     *                         .build())
     *                 .build())
     *         .sharePointConfiguration(SharePointConfigurationProperty.builder()
     *                 .secretArn("secretArn")
     *                 .sharePointVersion("sharePointVersion")
     *                 .urls(List.of("urls"))
     *                 // the properties below are optional
     *                 .crawlAttachments(false)
     *                 .disableLocalGroups(false)
     *                 .documentTitleFieldName("documentTitleFieldName")
     *                 .exclusionPatterns(List.of("exclusionPatterns"))
     *                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                         .dataSourceFieldName("dataSourceFieldName")
     *                         .indexFieldName("indexFieldName")
     *                         // the properties below are optional
     *                         .dateFieldFormat("dateFieldFormat")
     *                         .build()))
     *                 .inclusionPatterns(List.of("inclusionPatterns"))
     *                 .sslCertificateS3Path(S3PathProperty.builder()
     *                         .bucket("bucket")
     *                         .key("key")
     *                         .build())
     *                 .useChangeLog(false)
     *                 .vpcConfiguration(DataSourceVpcConfigurationProperty.builder()
     *                         .securityGroupIds(List.of("securityGroupIds"))
     *                         .subnetIds(List.of("subnetIds"))
     *                         .build())
     *                 .build())
     *         .webCrawlerConfiguration(WebCrawlerConfigurationProperty.builder()
     *                 .urls(WebCrawlerUrlsProperty.builder()
     *                         .seedUrlConfiguration(WebCrawlerSeedUrlConfigurationProperty.builder()
     *                                 .seedUrls(List.of("seedUrls"))
     *                                 // the properties below are optional
     *                                 .webCrawlerMode("webCrawlerMode")
     *                                 .build())
     *                         .siteMapsConfiguration(WebCrawlerSiteMapsConfigurationProperty.builder()
     *                                 .siteMaps(List.of("siteMaps"))
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .authenticationConfiguration(WebCrawlerAuthenticationConfigurationProperty.builder()
     *                         .basicAuthentication(List.of(WebCrawlerBasicAuthenticationProperty.builder()
     *                                 .credentials("credentials")
     *                                 .host("host")
     *                                 .port(123)
     *                                 .build()))
     *                         .build())
     *                 .crawlDepth(123)
     *                 .maxContentSizePerPageInMegaBytes(123)
     *                 .maxLinksPerPage(123)
     *                 .maxUrlsPerMinuteCrawlRate(123)
     *                 .proxyConfiguration(ProxyConfigurationProperty.builder()
     *                         .host("host")
     *                         .port(123)
     *                         // the properties below are optional
     *                         .credentials("credentials")
     *                         .build())
     *                 .urlExclusionPatterns(List.of("urlExclusionPatterns"))
     *                 .urlInclusionPatterns(List.of("urlInclusionPatterns"))
     *                 .build())
     *         .workDocsConfiguration(WorkDocsConfigurationProperty.builder()
     *                 .organizationId("organizationId")
     *                 // the properties below are optional
     *                 .crawlComments(false)
     *                 .exclusionPatterns(List.of("exclusionPatterns"))
     *                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                         .dataSourceFieldName("dataSourceFieldName")
     *                         .indexFieldName("indexFieldName")
     *                         // the properties below are optional
     *                         .dateFieldFormat("dateFieldFormat")
     *                         .build()))
     *                 .inclusionPatterns(List.of("inclusionPatterns"))
     *                 .useChangeLog(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.DataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Provides the configuration information to connect to Confluence as your data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfluenceConfiguration() {
            return null;
        }

        /**
         * Provides the configuration information to connect to a database as your data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatabaseConfiguration() {
            return null;
        }

        /**
         * Provides the configuration information to connect to Google Drive as your data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGoogleDriveConfiguration() {
            return null;
        }

        /**
         * Provides the configuration information to connect to Microsoft OneDrive as your data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOneDriveConfiguration() {
            return null;
        }

        /**
         * Provides the configuration information to connect to an Amazon S3 bucket as your data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Configuration() {
            return null;
        }

        /**
         * Provides the configuration information to connect to Salesforce as your data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSalesforceConfiguration() {
            return null;
        }

        /**
         * Provides the configuration information to connect to ServiceNow as your data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServiceNowConfiguration() {
            return null;
        }

        /**
         * Provides the configuration information to connect to Microsoft SharePoint as your data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSharePointConfiguration() {
            return null;
        }

        /**
         * Provides the configuration information required for Amazon Kendra Web Crawler.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWebCrawlerConfiguration() {
            return null;
        }

        /**
         * Provides the configuration information to connect to Amazon WorkDocs as your data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWorkDocsConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSourceConfigurationProperty> {
            java.lang.Object confluenceConfiguration;
            java.lang.Object databaseConfiguration;
            java.lang.Object googleDriveConfiguration;
            java.lang.Object oneDriveConfiguration;
            java.lang.Object s3Configuration;
            java.lang.Object salesforceConfiguration;
            java.lang.Object serviceNowConfiguration;
            java.lang.Object sharePointConfiguration;
            java.lang.Object webCrawlerConfiguration;
            java.lang.Object workDocsConfiguration;

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getConfluenceConfiguration}
             * @param confluenceConfiguration Provides the configuration information to connect to Confluence as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confluenceConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.ConfluenceConfigurationProperty confluenceConfiguration) {
                this.confluenceConfiguration = confluenceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getConfluenceConfiguration}
             * @param confluenceConfiguration Provides the configuration information to connect to Confluence as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confluenceConfiguration(software.amazon.awscdk.IResolvable confluenceConfiguration) {
                this.confluenceConfiguration = confluenceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getDatabaseConfiguration}
             * @param databaseConfiguration Provides the configuration information to connect to a database as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.DatabaseConfigurationProperty databaseConfiguration) {
                this.databaseConfiguration = databaseConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getDatabaseConfiguration}
             * @param databaseConfiguration Provides the configuration information to connect to a database as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseConfiguration(software.amazon.awscdk.IResolvable databaseConfiguration) {
                this.databaseConfiguration = databaseConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getGoogleDriveConfiguration}
             * @param googleDriveConfiguration Provides the configuration information to connect to Google Drive as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder googleDriveConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.GoogleDriveConfigurationProperty googleDriveConfiguration) {
                this.googleDriveConfiguration = googleDriveConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getGoogleDriveConfiguration}
             * @param googleDriveConfiguration Provides the configuration information to connect to Google Drive as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder googleDriveConfiguration(software.amazon.awscdk.IResolvable googleDriveConfiguration) {
                this.googleDriveConfiguration = googleDriveConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getOneDriveConfiguration}
             * @param oneDriveConfiguration Provides the configuration information to connect to Microsoft OneDrive as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oneDriveConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.OneDriveConfigurationProperty oneDriveConfiguration) {
                this.oneDriveConfiguration = oneDriveConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getOneDriveConfiguration}
             * @param oneDriveConfiguration Provides the configuration information to connect to Microsoft OneDrive as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oneDriveConfiguration(software.amazon.awscdk.IResolvable oneDriveConfiguration) {
                this.oneDriveConfiguration = oneDriveConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getS3Configuration}
             * @param s3Configuration Provides the configuration information to connect to an Amazon S3 bucket as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.kendra.CfnDataSource.S3DataSourceConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getS3Configuration}
             * @param s3Configuration Provides the configuration information to connect to an Amazon S3 bucket as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getSalesforceConfiguration}
             * @param salesforceConfiguration Provides the configuration information to connect to Salesforce as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforceConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.SalesforceConfigurationProperty salesforceConfiguration) {
                this.salesforceConfiguration = salesforceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getSalesforceConfiguration}
             * @param salesforceConfiguration Provides the configuration information to connect to Salesforce as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforceConfiguration(software.amazon.awscdk.IResolvable salesforceConfiguration) {
                this.salesforceConfiguration = salesforceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getServiceNowConfiguration}
             * @param serviceNowConfiguration Provides the configuration information to connect to ServiceNow as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNowConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.ServiceNowConfigurationProperty serviceNowConfiguration) {
                this.serviceNowConfiguration = serviceNowConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getServiceNowConfiguration}
             * @param serviceNowConfiguration Provides the configuration information to connect to ServiceNow as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNowConfiguration(software.amazon.awscdk.IResolvable serviceNowConfiguration) {
                this.serviceNowConfiguration = serviceNowConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getSharePointConfiguration}
             * @param sharePointConfiguration Provides the configuration information to connect to Microsoft SharePoint as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sharePointConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.SharePointConfigurationProperty sharePointConfiguration) {
                this.sharePointConfiguration = sharePointConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getSharePointConfiguration}
             * @param sharePointConfiguration Provides the configuration information to connect to Microsoft SharePoint as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sharePointConfiguration(software.amazon.awscdk.IResolvable sharePointConfiguration) {
                this.sharePointConfiguration = sharePointConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getWebCrawlerConfiguration}
             * @param webCrawlerConfiguration Provides the configuration information required for Amazon Kendra Web Crawler.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webCrawlerConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.WebCrawlerConfigurationProperty webCrawlerConfiguration) {
                this.webCrawlerConfiguration = webCrawlerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getWebCrawlerConfiguration}
             * @param webCrawlerConfiguration Provides the configuration information required for Amazon Kendra Web Crawler.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webCrawlerConfiguration(software.amazon.awscdk.IResolvable webCrawlerConfiguration) {
                this.webCrawlerConfiguration = webCrawlerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getWorkDocsConfiguration}
             * @param workDocsConfiguration Provides the configuration information to connect to Amazon WorkDocs as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workDocsConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.WorkDocsConfigurationProperty workDocsConfiguration) {
                this.workDocsConfiguration = workDocsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceConfigurationProperty#getWorkDocsConfiguration}
             * @param workDocsConfiguration Provides the configuration information to connect to Amazon WorkDocs as your data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workDocsConfiguration(software.amazon.awscdk.IResolvable workDocsConfiguration) {
                this.workDocsConfiguration = workDocsConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSourceConfigurationProperty {
            private final java.lang.Object confluenceConfiguration;
            private final java.lang.Object databaseConfiguration;
            private final java.lang.Object googleDriveConfiguration;
            private final java.lang.Object oneDriveConfiguration;
            private final java.lang.Object s3Configuration;
            private final java.lang.Object salesforceConfiguration;
            private final java.lang.Object serviceNowConfiguration;
            private final java.lang.Object sharePointConfiguration;
            private final java.lang.Object webCrawlerConfiguration;
            private final java.lang.Object workDocsConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.confluenceConfiguration = software.amazon.jsii.Kernel.get(this, "confluenceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.databaseConfiguration = software.amazon.jsii.Kernel.get(this, "databaseConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.googleDriveConfiguration = software.amazon.jsii.Kernel.get(this, "googleDriveConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.oneDriveConfiguration = software.amazon.jsii.Kernel.get(this, "oneDriveConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.salesforceConfiguration = software.amazon.jsii.Kernel.get(this, "salesforceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceNowConfiguration = software.amazon.jsii.Kernel.get(this, "serviceNowConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sharePointConfiguration = software.amazon.jsii.Kernel.get(this, "sharePointConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.webCrawlerConfiguration = software.amazon.jsii.Kernel.get(this, "webCrawlerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.workDocsConfiguration = software.amazon.jsii.Kernel.get(this, "workDocsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.confluenceConfiguration = builder.confluenceConfiguration;
                this.databaseConfiguration = builder.databaseConfiguration;
                this.googleDriveConfiguration = builder.googleDriveConfiguration;
                this.oneDriveConfiguration = builder.oneDriveConfiguration;
                this.s3Configuration = builder.s3Configuration;
                this.salesforceConfiguration = builder.salesforceConfiguration;
                this.serviceNowConfiguration = builder.serviceNowConfiguration;
                this.sharePointConfiguration = builder.sharePointConfiguration;
                this.webCrawlerConfiguration = builder.webCrawlerConfiguration;
                this.workDocsConfiguration = builder.workDocsConfiguration;
            }

            @Override
            public final java.lang.Object getConfluenceConfiguration() {
                return this.confluenceConfiguration;
            }

            @Override
            public final java.lang.Object getDatabaseConfiguration() {
                return this.databaseConfiguration;
            }

            @Override
            public final java.lang.Object getGoogleDriveConfiguration() {
                return this.googleDriveConfiguration;
            }

            @Override
            public final java.lang.Object getOneDriveConfiguration() {
                return this.oneDriveConfiguration;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            public final java.lang.Object getSalesforceConfiguration() {
                return this.salesforceConfiguration;
            }

            @Override
            public final java.lang.Object getServiceNowConfiguration() {
                return this.serviceNowConfiguration;
            }

            @Override
            public final java.lang.Object getSharePointConfiguration() {
                return this.sharePointConfiguration;
            }

            @Override
            public final java.lang.Object getWebCrawlerConfiguration() {
                return this.webCrawlerConfiguration;
            }

            @Override
            public final java.lang.Object getWorkDocsConfiguration() {
                return this.workDocsConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfluenceConfiguration() != null) {
                    data.set("confluenceConfiguration", om.valueToTree(this.getConfluenceConfiguration()));
                }
                if (this.getDatabaseConfiguration() != null) {
                    data.set("databaseConfiguration", om.valueToTree(this.getDatabaseConfiguration()));
                }
                if (this.getGoogleDriveConfiguration() != null) {
                    data.set("googleDriveConfiguration", om.valueToTree(this.getGoogleDriveConfiguration()));
                }
                if (this.getOneDriveConfiguration() != null) {
                    data.set("oneDriveConfiguration", om.valueToTree(this.getOneDriveConfiguration()));
                }
                if (this.getS3Configuration() != null) {
                    data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                }
                if (this.getSalesforceConfiguration() != null) {
                    data.set("salesforceConfiguration", om.valueToTree(this.getSalesforceConfiguration()));
                }
                if (this.getServiceNowConfiguration() != null) {
                    data.set("serviceNowConfiguration", om.valueToTree(this.getServiceNowConfiguration()));
                }
                if (this.getSharePointConfiguration() != null) {
                    data.set("sharePointConfiguration", om.valueToTree(this.getSharePointConfiguration()));
                }
                if (this.getWebCrawlerConfiguration() != null) {
                    data.set("webCrawlerConfiguration", om.valueToTree(this.getWebCrawlerConfiguration()));
                }
                if (this.getWorkDocsConfiguration() != null) {
                    data.set("workDocsConfiguration", om.valueToTree(this.getWorkDocsConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.DataSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSourceConfigurationProperty.Jsii$Proxy that = (DataSourceConfigurationProperty.Jsii$Proxy) o;

                if (this.confluenceConfiguration != null ? !this.confluenceConfiguration.equals(that.confluenceConfiguration) : that.confluenceConfiguration != null) return false;
                if (this.databaseConfiguration != null ? !this.databaseConfiguration.equals(that.databaseConfiguration) : that.databaseConfiguration != null) return false;
                if (this.googleDriveConfiguration != null ? !this.googleDriveConfiguration.equals(that.googleDriveConfiguration) : that.googleDriveConfiguration != null) return false;
                if (this.oneDriveConfiguration != null ? !this.oneDriveConfiguration.equals(that.oneDriveConfiguration) : that.oneDriveConfiguration != null) return false;
                if (this.s3Configuration != null ? !this.s3Configuration.equals(that.s3Configuration) : that.s3Configuration != null) return false;
                if (this.salesforceConfiguration != null ? !this.salesforceConfiguration.equals(that.salesforceConfiguration) : that.salesforceConfiguration != null) return false;
                if (this.serviceNowConfiguration != null ? !this.serviceNowConfiguration.equals(that.serviceNowConfiguration) : that.serviceNowConfiguration != null) return false;
                if (this.sharePointConfiguration != null ? !this.sharePointConfiguration.equals(that.sharePointConfiguration) : that.sharePointConfiguration != null) return false;
                if (this.webCrawlerConfiguration != null ? !this.webCrawlerConfiguration.equals(that.webCrawlerConfiguration) : that.webCrawlerConfiguration != null) return false;
                return this.workDocsConfiguration != null ? this.workDocsConfiguration.equals(that.workDocsConfiguration) : that.workDocsConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.confluenceConfiguration != null ? this.confluenceConfiguration.hashCode() : 0;
                result = 31 * result + (this.databaseConfiguration != null ? this.databaseConfiguration.hashCode() : 0);
                result = 31 * result + (this.googleDriveConfiguration != null ? this.googleDriveConfiguration.hashCode() : 0);
                result = 31 * result + (this.oneDriveConfiguration != null ? this.oneDriveConfiguration.hashCode() : 0);
                result = 31 * result + (this.s3Configuration != null ? this.s3Configuration.hashCode() : 0);
                result = 31 * result + (this.salesforceConfiguration != null ? this.salesforceConfiguration.hashCode() : 0);
                result = 31 * result + (this.serviceNowConfiguration != null ? this.serviceNowConfiguration.hashCode() : 0);
                result = 31 * result + (this.sharePointConfiguration != null ? this.sharePointConfiguration.hashCode() : 0);
                result = 31 * result + (this.webCrawlerConfiguration != null ? this.webCrawlerConfiguration.hashCode() : 0);
                result = 31 * result + (this.workDocsConfiguration != null ? this.workDocsConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Maps a column or attribute in the data source to an index field.
     * <p>
     * You must first create the fields in the index using the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateIndex.html">UpdateIndex</a> operation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * DataSourceToIndexFieldMappingProperty dataSourceToIndexFieldMappingProperty = DataSourceToIndexFieldMappingProperty.builder()
     *         .dataSourceFieldName("dataSourceFieldName")
     *         .indexFieldName("indexFieldName")
     *         // the properties below are optional
     *         .dateFieldFormat("dateFieldFormat")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.DataSourceToIndexFieldMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSourceToIndexFieldMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSourceToIndexFieldMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the column or attribute in the data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSourceFieldName();

        /**
         * The name of the field in the index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndexFieldName();

        /**
         * The type of data stored in the column or attribute.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDateFieldFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataSourceToIndexFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSourceToIndexFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSourceToIndexFieldMappingProperty> {
            java.lang.String dataSourceFieldName;
            java.lang.String indexFieldName;
            java.lang.String dateFieldFormat;

            /**
             * Sets the value of {@link DataSourceToIndexFieldMappingProperty#getDataSourceFieldName}
             * @param dataSourceFieldName The name of the column or attribute in the data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSourceFieldName(java.lang.String dataSourceFieldName) {
                this.dataSourceFieldName = dataSourceFieldName;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceToIndexFieldMappingProperty#getIndexFieldName}
             * @param indexFieldName The name of the field in the index. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexFieldName(java.lang.String indexFieldName) {
                this.indexFieldName = indexFieldName;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceToIndexFieldMappingProperty#getDateFieldFormat}
             * @param dateFieldFormat The type of data stored in the column or attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateFieldFormat(java.lang.String dateFieldFormat) {
                this.dateFieldFormat = dateFieldFormat;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSourceToIndexFieldMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSourceToIndexFieldMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSourceToIndexFieldMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSourceToIndexFieldMappingProperty {
            private final java.lang.String dataSourceFieldName;
            private final java.lang.String indexFieldName;
            private final java.lang.String dateFieldFormat;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataSourceFieldName = software.amazon.jsii.Kernel.get(this, "dataSourceFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.indexFieldName = software.amazon.jsii.Kernel.get(this, "indexFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dateFieldFormat = software.amazon.jsii.Kernel.get(this, "dateFieldFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataSourceFieldName = java.util.Objects.requireNonNull(builder.dataSourceFieldName, "dataSourceFieldName is required");
                this.indexFieldName = java.util.Objects.requireNonNull(builder.indexFieldName, "indexFieldName is required");
                this.dateFieldFormat = builder.dateFieldFormat;
            }

            @Override
            public final java.lang.String getDataSourceFieldName() {
                return this.dataSourceFieldName;
            }

            @Override
            public final java.lang.String getIndexFieldName() {
                return this.indexFieldName;
            }

            @Override
            public final java.lang.String getDateFieldFormat() {
                return this.dateFieldFormat;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataSourceFieldName", om.valueToTree(this.getDataSourceFieldName()));
                data.set("indexFieldName", om.valueToTree(this.getIndexFieldName()));
                if (this.getDateFieldFormat() != null) {
                    data.set("dateFieldFormat", om.valueToTree(this.getDateFieldFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.DataSourceToIndexFieldMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSourceToIndexFieldMappingProperty.Jsii$Proxy that = (DataSourceToIndexFieldMappingProperty.Jsii$Proxy) o;

                if (!dataSourceFieldName.equals(that.dataSourceFieldName)) return false;
                if (!indexFieldName.equals(that.indexFieldName)) return false;
                return this.dateFieldFormat != null ? this.dateFieldFormat.equals(that.dateFieldFormat) : that.dateFieldFormat == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataSourceFieldName.hashCode();
                result = 31 * result + (this.indexFieldName.hashCode());
                result = 31 * result + (this.dateFieldFormat != null ? this.dateFieldFormat.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information to connect to an Amazon VPC.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * DataSourceVpcConfigurationProperty dataSourceVpcConfigurationProperty = DataSourceVpcConfigurationProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetIds(List.of("subnetIds"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.DataSourceVpcConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSourceVpcConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSourceVpcConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of identifiers of security groups within your Amazon VPC.
         * <p>
         * The security groups should enable Amazon Kendra to connect to the data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * A list of identifiers for subnets within your Amazon VPC.
         * <p>
         * The subnets should be able to connect to each other in the VPC, and they should have outgoing access to the Internet through a NAT device.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

        /**
         * @return a {@link Builder} of {@link DataSourceVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSourceVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSourceVpcConfigurationProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnetIds;

            /**
             * Sets the value of {@link DataSourceVpcConfigurationProperty#getSecurityGroupIds}
             * @param securityGroupIds A list of identifiers of security groups within your Amazon VPC. This parameter is required.
             *                         The security groups should enable Amazon Kendra to connect to the data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link DataSourceVpcConfigurationProperty#getSubnetIds}
             * @param subnetIds A list of identifiers for subnets within your Amazon VPC. This parameter is required.
             *                  The subnets should be able to connect to each other in the VPC, and they should have outgoing access to the Internet through a NAT device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSourceVpcConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSourceVpcConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSourceVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSourceVpcConfigurationProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.DataSourceVpcConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSourceVpcConfigurationProperty.Jsii$Proxy that = (DataSourceVpcConfigurationProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnetIds.equals(that.subnetIds);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnetIds.hashCode());
                return result;
            }
        }
    }
    /**
     * Provides the configuration information to connect to a index.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * DatabaseConfigurationProperty databaseConfigurationProperty = DatabaseConfigurationProperty.builder()
     *         .columnConfiguration(ColumnConfigurationProperty.builder()
     *                 .changeDetectingColumns(List.of("changeDetectingColumns"))
     *                 .documentDataColumnName("documentDataColumnName")
     *                 .documentIdColumnName("documentIdColumnName")
     *                 // the properties below are optional
     *                 .documentTitleColumnName("documentTitleColumnName")
     *                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                         .dataSourceFieldName("dataSourceFieldName")
     *                         .indexFieldName("indexFieldName")
     *                         // the properties below are optional
     *                         .dateFieldFormat("dateFieldFormat")
     *                         .build()))
     *                 .build())
     *         .connectionConfiguration(ConnectionConfigurationProperty.builder()
     *                 .databaseHost("databaseHost")
     *                 .databaseName("databaseName")
     *                 .databasePort(123)
     *                 .secretArn("secretArn")
     *                 .tableName("tableName")
     *                 .build())
     *         .databaseEngineType("databaseEngineType")
     *         // the properties below are optional
     *         .aclConfiguration(AclConfigurationProperty.builder()
     *                 .allowedGroupsColumnName("allowedGroupsColumnName")
     *                 .build())
     *         .sqlConfiguration(SqlConfigurationProperty.builder()
     *                 .queryIdentifiersEnclosingOption("queryIdentifiersEnclosingOption")
     *                 .build())
     *         .vpcConfiguration(DataSourceVpcConfigurationProperty.builder()
     *                 .securityGroupIds(List.of("securityGroupIds"))
     *                 .subnetIds(List.of("subnetIds"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.DatabaseConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabaseConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabaseConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about where the index should get the document information from the database.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getColumnConfiguration();

        /**
         * Configuration information that's required to connect to a database.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getConnectionConfiguration();

        /**
         * The type of database engine that runs the database.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseEngineType();

        /**
         * Information about the database column that provides information for user context filtering.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAclConfiguration() {
            return null;
        }

        /**
         * Provides information about how Amazon Kendra uses quote marks around SQL identifiers when querying a database data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqlConfiguration() {
            return null;
        }

        /**
         * Provides information for connecting to an Amazon VPC.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatabaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabaseConfigurationProperty> {
            java.lang.Object columnConfiguration;
            java.lang.Object connectionConfiguration;
            java.lang.String databaseEngineType;
            java.lang.Object aclConfiguration;
            java.lang.Object sqlConfiguration;
            java.lang.Object vpcConfiguration;

            /**
             * Sets the value of {@link DatabaseConfigurationProperty#getColumnConfiguration}
             * @param columnConfiguration Information about where the index should get the document information from the database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.ColumnConfigurationProperty columnConfiguration) {
                this.columnConfiguration = columnConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseConfigurationProperty#getColumnConfiguration}
             * @param columnConfiguration Information about where the index should get the document information from the database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnConfiguration(software.amazon.awscdk.IResolvable columnConfiguration) {
                this.columnConfiguration = columnConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseConfigurationProperty#getConnectionConfiguration}
             * @param connectionConfiguration Configuration information that's required to connect to a database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.ConnectionConfigurationProperty connectionConfiguration) {
                this.connectionConfiguration = connectionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseConfigurationProperty#getConnectionConfiguration}
             * @param connectionConfiguration Configuration information that's required to connect to a database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionConfiguration(software.amazon.awscdk.IResolvable connectionConfiguration) {
                this.connectionConfiguration = connectionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseConfigurationProperty#getDatabaseEngineType}
             * @param databaseEngineType The type of database engine that runs the database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseEngineType(java.lang.String databaseEngineType) {
                this.databaseEngineType = databaseEngineType;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseConfigurationProperty#getAclConfiguration}
             * @param aclConfiguration Information about the database column that provides information for user context filtering.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aclConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.AclConfigurationProperty aclConfiguration) {
                this.aclConfiguration = aclConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseConfigurationProperty#getAclConfiguration}
             * @param aclConfiguration Information about the database column that provides information for user context filtering.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aclConfiguration(software.amazon.awscdk.IResolvable aclConfiguration) {
                this.aclConfiguration = aclConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseConfigurationProperty#getSqlConfiguration}
             * @param sqlConfiguration Provides information about how Amazon Kendra uses quote marks around SQL identifiers when querying a database data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.SqlConfigurationProperty sqlConfiguration) {
                this.sqlConfiguration = sqlConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseConfigurationProperty#getSqlConfiguration}
             * @param sqlConfiguration Provides information about how Amazon Kendra uses quote marks around SQL identifiers when querying a database data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqlConfiguration(software.amazon.awscdk.IResolvable sqlConfiguration) {
                this.sqlConfiguration = sqlConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration Provides information for connecting to an Amazon VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.DataSourceVpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration Provides information for connecting to an Amazon VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabaseConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabaseConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseConfigurationProperty {
            private final java.lang.Object columnConfiguration;
            private final java.lang.Object connectionConfiguration;
            private final java.lang.String databaseEngineType;
            private final java.lang.Object aclConfiguration;
            private final java.lang.Object sqlConfiguration;
            private final java.lang.Object vpcConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnConfiguration = software.amazon.jsii.Kernel.get(this, "columnConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.connectionConfiguration = software.amazon.jsii.Kernel.get(this, "connectionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.databaseEngineType = software.amazon.jsii.Kernel.get(this, "databaseEngineType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.aclConfiguration = software.amazon.jsii.Kernel.get(this, "aclConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqlConfiguration = software.amazon.jsii.Kernel.get(this, "sqlConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcConfiguration = software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnConfiguration = java.util.Objects.requireNonNull(builder.columnConfiguration, "columnConfiguration is required");
                this.connectionConfiguration = java.util.Objects.requireNonNull(builder.connectionConfiguration, "connectionConfiguration is required");
                this.databaseEngineType = java.util.Objects.requireNonNull(builder.databaseEngineType, "databaseEngineType is required");
                this.aclConfiguration = builder.aclConfiguration;
                this.sqlConfiguration = builder.sqlConfiguration;
                this.vpcConfiguration = builder.vpcConfiguration;
            }

            @Override
            public final java.lang.Object getColumnConfiguration() {
                return this.columnConfiguration;
            }

            @Override
            public final java.lang.Object getConnectionConfiguration() {
                return this.connectionConfiguration;
            }

            @Override
            public final java.lang.String getDatabaseEngineType() {
                return this.databaseEngineType;
            }

            @Override
            public final java.lang.Object getAclConfiguration() {
                return this.aclConfiguration;
            }

            @Override
            public final java.lang.Object getSqlConfiguration() {
                return this.sqlConfiguration;
            }

            @Override
            public final java.lang.Object getVpcConfiguration() {
                return this.vpcConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnConfiguration", om.valueToTree(this.getColumnConfiguration()));
                data.set("connectionConfiguration", om.valueToTree(this.getConnectionConfiguration()));
                data.set("databaseEngineType", om.valueToTree(this.getDatabaseEngineType()));
                if (this.getAclConfiguration() != null) {
                    data.set("aclConfiguration", om.valueToTree(this.getAclConfiguration()));
                }
                if (this.getSqlConfiguration() != null) {
                    data.set("sqlConfiguration", om.valueToTree(this.getSqlConfiguration()));
                }
                if (this.getVpcConfiguration() != null) {
                    data.set("vpcConfiguration", om.valueToTree(this.getVpcConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.DatabaseConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabaseConfigurationProperty.Jsii$Proxy that = (DatabaseConfigurationProperty.Jsii$Proxy) o;

                if (!columnConfiguration.equals(that.columnConfiguration)) return false;
                if (!connectionConfiguration.equals(that.connectionConfiguration)) return false;
                if (!databaseEngineType.equals(that.databaseEngineType)) return false;
                if (this.aclConfiguration != null ? !this.aclConfiguration.equals(that.aclConfiguration) : that.aclConfiguration != null) return false;
                if (this.sqlConfiguration != null ? !this.sqlConfiguration.equals(that.sqlConfiguration) : that.sqlConfiguration != null) return false;
                return this.vpcConfiguration != null ? this.vpcConfiguration.equals(that.vpcConfiguration) : that.vpcConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnConfiguration.hashCode();
                result = 31 * result + (this.connectionConfiguration.hashCode());
                result = 31 * result + (this.databaseEngineType.hashCode());
                result = 31 * result + (this.aclConfiguration != null ? this.aclConfiguration.hashCode() : 0);
                result = 31 * result + (this.sqlConfiguration != null ? this.sqlConfiguration.hashCode() : 0);
                result = 31 * result + (this.vpcConfiguration != null ? this.vpcConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The condition used for the target document attribute or metadata field when ingesting documents into Amazon Kendra.
     * <p>
     * You use this with <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_DocumentAttributeTarget.html">DocumentAttributeTarget to apply the condition</a> .
     * <p>
     * For example, you can create the 'Department' target field and have it prefill department names associated with the documents based on information in the 'Source_URI' field. Set the condition that if the 'Source_URI' field contains 'financial' in its URI value, then prefill the target field 'Department' with the target value 'Finance' for the document.
     * <p>
     * Amazon Kendra cannot create a target field if it has not already been created as an index field. After you create your index field, you can create a document metadata field using <code>DocumentAttributeTarget</code> . Amazon Kendra then will map your newly created metadata field to your index field.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * DocumentAttributeConditionProperty documentAttributeConditionProperty = DocumentAttributeConditionProperty.builder()
     *         .conditionDocumentAttributeKey("conditionDocumentAttributeKey")
     *         .operator("operator")
     *         // the properties below are optional
     *         .conditionOnValue(DocumentAttributeValueProperty.builder()
     *                 .dateValue("dateValue")
     *                 .longValue(123)
     *                 .stringListValue(List.of("stringListValue"))
     *                 .stringValue("stringValue")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.DocumentAttributeConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentAttributeConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentAttributeConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the document attribute used for the condition.
         * <p>
         * For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs associated with the documents.
         * <p>
         * Amazon Kendra currently does not support <code>_document_body</code> as an attribute key used for the condition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConditionDocumentAttributeKey();

        /**
         * The condition operator.
         * <p>
         * For example, you can use 'Contains' to partially match a string.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperator();

        /**
         * The value used by the operator.
         * <p>
         * For example, you can specify the value 'financial' for strings in the 'Source_URI' field that partially match or contain this value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConditionOnValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentAttributeConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentAttributeConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentAttributeConditionProperty> {
            java.lang.String conditionDocumentAttributeKey;
            java.lang.String operator;
            java.lang.Object conditionOnValue;

            /**
             * Sets the value of {@link DocumentAttributeConditionProperty#getConditionDocumentAttributeKey}
             * @param conditionDocumentAttributeKey The identifier of the document attribute used for the condition. This parameter is required.
             *                                      For example, 'Source_URI' could be an identifier for the attribute or metadata field that contains source URIs associated with the documents.
             *                                      <p>
             *                                      Amazon Kendra currently does not support <code>_document_body</code> as an attribute key used for the condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionDocumentAttributeKey(java.lang.String conditionDocumentAttributeKey) {
                this.conditionDocumentAttributeKey = conditionDocumentAttributeKey;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeConditionProperty#getOperator}
             * @param operator The condition operator. This parameter is required.
             *                 For example, you can use 'Contains' to partially match a string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeConditionProperty#getConditionOnValue}
             * @param conditionOnValue The value used by the operator.
             *                         For example, you can specify the value 'financial' for strings in the 'Source_URI' field that partially match or contain this value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionOnValue(software.amazon.awscdk.services.kendra.CfnDataSource.DocumentAttributeValueProperty conditionOnValue) {
                this.conditionOnValue = conditionOnValue;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeConditionProperty#getConditionOnValue}
             * @param conditionOnValue The value used by the operator.
             *                         For example, you can specify the value 'financial' for strings in the 'Source_URI' field that partially match or contain this value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionOnValue(software.amazon.awscdk.IResolvable conditionOnValue) {
                this.conditionOnValue = conditionOnValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentAttributeConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentAttributeConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentAttributeConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentAttributeConditionProperty {
            private final java.lang.String conditionDocumentAttributeKey;
            private final java.lang.String operator;
            private final java.lang.Object conditionOnValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.conditionDocumentAttributeKey = software.amazon.jsii.Kernel.get(this, "conditionDocumentAttributeKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.conditionOnValue = software.amazon.jsii.Kernel.get(this, "conditionOnValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.conditionDocumentAttributeKey = java.util.Objects.requireNonNull(builder.conditionDocumentAttributeKey, "conditionDocumentAttributeKey is required");
                this.operator = java.util.Objects.requireNonNull(builder.operator, "operator is required");
                this.conditionOnValue = builder.conditionOnValue;
            }

            @Override
            public final java.lang.String getConditionDocumentAttributeKey() {
                return this.conditionDocumentAttributeKey;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.lang.Object getConditionOnValue() {
                return this.conditionOnValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("conditionDocumentAttributeKey", om.valueToTree(this.getConditionDocumentAttributeKey()));
                data.set("operator", om.valueToTree(this.getOperator()));
                if (this.getConditionOnValue() != null) {
                    data.set("conditionOnValue", om.valueToTree(this.getConditionOnValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.DocumentAttributeConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentAttributeConditionProperty.Jsii$Proxy that = (DocumentAttributeConditionProperty.Jsii$Proxy) o;

                if (!conditionDocumentAttributeKey.equals(that.conditionDocumentAttributeKey)) return false;
                if (!operator.equals(that.operator)) return false;
                return this.conditionOnValue != null ? this.conditionOnValue.equals(that.conditionOnValue) : that.conditionOnValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.conditionDocumentAttributeKey.hashCode();
                result = 31 * result + (this.operator.hashCode());
                result = 31 * result + (this.conditionOnValue != null ? this.conditionOnValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The target document attribute or metadata field you want to alter when ingesting documents into Amazon Kendra.
     * <p>
     * For example, you can delete customer identification numbers associated with the documents, stored in the document metadata field called 'Customer_ID'. You set the target key as 'Customer_ID' and the deletion flag to <code>TRUE</code> . This removes all customer ID values in the field 'Customer_ID'. This would scrub personally identifiable information from each document's metadata.
     * <p>
     * Amazon Kendra cannot create a target field if it has not already been created as an index field. After you create your index field, you can create a document metadata field using <code>DocumentAttributeTarget</code> . Amazon Kendra then will map your newly created metadata field to your index field.
     * <p>
     * You can also use this with <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_DocumentAttributeCondition.html">DocumentAttributeCondition</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * DocumentAttributeTargetProperty documentAttributeTargetProperty = DocumentAttributeTargetProperty.builder()
     *         .targetDocumentAttributeKey("targetDocumentAttributeKey")
     *         // the properties below are optional
     *         .targetDocumentAttributeValue(DocumentAttributeValueProperty.builder()
     *                 .dateValue("dateValue")
     *                 .longValue(123)
     *                 .stringListValue(List.of("stringListValue"))
     *                 .stringValue("stringValue")
     *                 .build())
     *         .targetDocumentAttributeValueDeletion(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.DocumentAttributeTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentAttributeTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentAttributeTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the target document attribute or metadata field.
         * <p>
         * For example, 'Department' could be an identifier for the target attribute or metadata field that includes the department names associated with the documents.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetDocumentAttributeKey();

        /**
         * The target value you want to create for the target attribute.
         * <p>
         * For example, 'Finance' could be the target value for the target attribute key 'Department'.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetDocumentAttributeValue() {
            return null;
        }

        /**
         * `TRUE` to delete the existing target value for your specified target attribute key.
         * <p>
         * You cannot create a target value and set this to <code>TRUE</code> . To create a target value ( <code>TargetDocumentAttributeValue</code> ), set this to <code>FALSE</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetDocumentAttributeValueDeletion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentAttributeTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentAttributeTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentAttributeTargetProperty> {
            java.lang.String targetDocumentAttributeKey;
            java.lang.Object targetDocumentAttributeValue;
            java.lang.Object targetDocumentAttributeValueDeletion;

            /**
             * Sets the value of {@link DocumentAttributeTargetProperty#getTargetDocumentAttributeKey}
             * @param targetDocumentAttributeKey The identifier of the target document attribute or metadata field. This parameter is required.
             *                                   For example, 'Department' could be an identifier for the target attribute or metadata field that includes the department names associated with the documents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetDocumentAttributeKey(java.lang.String targetDocumentAttributeKey) {
                this.targetDocumentAttributeKey = targetDocumentAttributeKey;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeTargetProperty#getTargetDocumentAttributeValue}
             * @param targetDocumentAttributeValue The target value you want to create for the target attribute.
             *                                     For example, 'Finance' could be the target value for the target attribute key 'Department'.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetDocumentAttributeValue(software.amazon.awscdk.services.kendra.CfnDataSource.DocumentAttributeValueProperty targetDocumentAttributeValue) {
                this.targetDocumentAttributeValue = targetDocumentAttributeValue;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeTargetProperty#getTargetDocumentAttributeValue}
             * @param targetDocumentAttributeValue The target value you want to create for the target attribute.
             *                                     For example, 'Finance' could be the target value for the target attribute key 'Department'.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetDocumentAttributeValue(software.amazon.awscdk.IResolvable targetDocumentAttributeValue) {
                this.targetDocumentAttributeValue = targetDocumentAttributeValue;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeTargetProperty#getTargetDocumentAttributeValueDeletion}
             * @param targetDocumentAttributeValueDeletion `TRUE` to delete the existing target value for your specified target attribute key.
             *                                             You cannot create a target value and set this to <code>TRUE</code> . To create a target value ( <code>TargetDocumentAttributeValue</code> ), set this to <code>FALSE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetDocumentAttributeValueDeletion(java.lang.Boolean targetDocumentAttributeValueDeletion) {
                this.targetDocumentAttributeValueDeletion = targetDocumentAttributeValueDeletion;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeTargetProperty#getTargetDocumentAttributeValueDeletion}
             * @param targetDocumentAttributeValueDeletion `TRUE` to delete the existing target value for your specified target attribute key.
             *                                             You cannot create a target value and set this to <code>TRUE</code> . To create a target value ( <code>TargetDocumentAttributeValue</code> ), set this to <code>FALSE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetDocumentAttributeValueDeletion(software.amazon.awscdk.IResolvable targetDocumentAttributeValueDeletion) {
                this.targetDocumentAttributeValueDeletion = targetDocumentAttributeValueDeletion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentAttributeTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentAttributeTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentAttributeTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentAttributeTargetProperty {
            private final java.lang.String targetDocumentAttributeKey;
            private final java.lang.Object targetDocumentAttributeValue;
            private final java.lang.Object targetDocumentAttributeValueDeletion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetDocumentAttributeKey = software.amazon.jsii.Kernel.get(this, "targetDocumentAttributeKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetDocumentAttributeValue = software.amazon.jsii.Kernel.get(this, "targetDocumentAttributeValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.targetDocumentAttributeValueDeletion = software.amazon.jsii.Kernel.get(this, "targetDocumentAttributeValueDeletion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetDocumentAttributeKey = java.util.Objects.requireNonNull(builder.targetDocumentAttributeKey, "targetDocumentAttributeKey is required");
                this.targetDocumentAttributeValue = builder.targetDocumentAttributeValue;
                this.targetDocumentAttributeValueDeletion = builder.targetDocumentAttributeValueDeletion;
            }

            @Override
            public final java.lang.String getTargetDocumentAttributeKey() {
                return this.targetDocumentAttributeKey;
            }

            @Override
            public final java.lang.Object getTargetDocumentAttributeValue() {
                return this.targetDocumentAttributeValue;
            }

            @Override
            public final java.lang.Object getTargetDocumentAttributeValueDeletion() {
                return this.targetDocumentAttributeValueDeletion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetDocumentAttributeKey", om.valueToTree(this.getTargetDocumentAttributeKey()));
                if (this.getTargetDocumentAttributeValue() != null) {
                    data.set("targetDocumentAttributeValue", om.valueToTree(this.getTargetDocumentAttributeValue()));
                }
                if (this.getTargetDocumentAttributeValueDeletion() != null) {
                    data.set("targetDocumentAttributeValueDeletion", om.valueToTree(this.getTargetDocumentAttributeValueDeletion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.DocumentAttributeTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentAttributeTargetProperty.Jsii$Proxy that = (DocumentAttributeTargetProperty.Jsii$Proxy) o;

                if (!targetDocumentAttributeKey.equals(that.targetDocumentAttributeKey)) return false;
                if (this.targetDocumentAttributeValue != null ? !this.targetDocumentAttributeValue.equals(that.targetDocumentAttributeValue) : that.targetDocumentAttributeValue != null) return false;
                return this.targetDocumentAttributeValueDeletion != null ? this.targetDocumentAttributeValueDeletion.equals(that.targetDocumentAttributeValueDeletion) : that.targetDocumentAttributeValueDeletion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetDocumentAttributeKey.hashCode();
                result = 31 * result + (this.targetDocumentAttributeValue != null ? this.targetDocumentAttributeValue.hashCode() : 0);
                result = 31 * result + (this.targetDocumentAttributeValueDeletion != null ? this.targetDocumentAttributeValueDeletion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The value of a document attribute.
     * <p>
     * You can only provide one value for a document attribute.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * DocumentAttributeValueProperty documentAttributeValueProperty = DocumentAttributeValueProperty.builder()
     *         .dateValue("dateValue")
     *         .longValue(123)
     *         .stringListValue(List.of("stringListValue"))
     *         .stringValue("stringValue")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.DocumentAttributeValueProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentAttributeValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentAttributeValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A date expressed as an ISO 8601 string.
         * <p>
         * It is important for the time zone to be included in the ISO 8601 date-time format. For example, 2012-03-25T12:30:10+01:00 is the ISO 8601 date-time format for March 25th 2012 at 12:30PM (plus 10 seconds) in Central European Time.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDateValue() {
            return null;
        }

        /**
         * A long integer value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLongValue() {
            return null;
        }

        /**
         * A list of strings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStringListValue() {
            return null;
        }

        /**
         * A string, such as "department".
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStringValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentAttributeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentAttributeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentAttributeValueProperty> {
            java.lang.String dateValue;
            java.lang.Number longValue;
            java.util.List<java.lang.String> stringListValue;
            java.lang.String stringValue;

            /**
             * Sets the value of {@link DocumentAttributeValueProperty#getDateValue}
             * @param dateValue A date expressed as an ISO 8601 string.
             *                  It is important for the time zone to be included in the ISO 8601 date-time format. For example, 2012-03-25T12:30:10+01:00 is the ISO 8601 date-time format for March 25th 2012 at 12:30PM (plus 10 seconds) in Central European Time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateValue(java.lang.String dateValue) {
                this.dateValue = dateValue;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeValueProperty#getLongValue}
             * @param longValue A long integer value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder longValue(java.lang.Number longValue) {
                this.longValue = longValue;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeValueProperty#getStringListValue}
             * @param stringListValue A list of strings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringListValue(java.util.List<java.lang.String> stringListValue) {
                this.stringListValue = stringListValue;
                return this;
            }

            /**
             * Sets the value of {@link DocumentAttributeValueProperty#getStringValue}
             * @param stringValue A string, such as "department".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringValue(java.lang.String stringValue) {
                this.stringValue = stringValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentAttributeValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentAttributeValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentAttributeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentAttributeValueProperty {
            private final java.lang.String dateValue;
            private final java.lang.Number longValue;
            private final java.util.List<java.lang.String> stringListValue;
            private final java.lang.String stringValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dateValue = software.amazon.jsii.Kernel.get(this, "dateValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.longValue = software.amazon.jsii.Kernel.get(this, "longValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stringListValue = software.amazon.jsii.Kernel.get(this, "stringListValue", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.stringValue = software.amazon.jsii.Kernel.get(this, "stringValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dateValue = builder.dateValue;
                this.longValue = builder.longValue;
                this.stringListValue = builder.stringListValue;
                this.stringValue = builder.stringValue;
            }

            @Override
            public final java.lang.String getDateValue() {
                return this.dateValue;
            }

            @Override
            public final java.lang.Number getLongValue() {
                return this.longValue;
            }

            @Override
            public final java.util.List<java.lang.String> getStringListValue() {
                return this.stringListValue;
            }

            @Override
            public final java.lang.String getStringValue() {
                return this.stringValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDateValue() != null) {
                    data.set("dateValue", om.valueToTree(this.getDateValue()));
                }
                if (this.getLongValue() != null) {
                    data.set("longValue", om.valueToTree(this.getLongValue()));
                }
                if (this.getStringListValue() != null) {
                    data.set("stringListValue", om.valueToTree(this.getStringListValue()));
                }
                if (this.getStringValue() != null) {
                    data.set("stringValue", om.valueToTree(this.getStringValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.DocumentAttributeValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentAttributeValueProperty.Jsii$Proxy that = (DocumentAttributeValueProperty.Jsii$Proxy) o;

                if (this.dateValue != null ? !this.dateValue.equals(that.dateValue) : that.dateValue != null) return false;
                if (this.longValue != null ? !this.longValue.equals(that.longValue) : that.longValue != null) return false;
                if (this.stringListValue != null ? !this.stringListValue.equals(that.stringListValue) : that.stringListValue != null) return false;
                return this.stringValue != null ? this.stringValue.equals(that.stringValue) : that.stringValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dateValue != null ? this.dateValue.hashCode() : 0;
                result = 31 * result + (this.longValue != null ? this.longValue.hashCode() : 0);
                result = 31 * result + (this.stringListValue != null ? this.stringListValue.hashCode() : 0);
                result = 31 * result + (this.stringValue != null ? this.stringValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Document metadata files that contain information such as the document access control information, source URI, document author, and custom attributes.
     * <p>
     * Each metadata file contains metadata about a single document.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * DocumentsMetadataConfigurationProperty documentsMetadataConfigurationProperty = DocumentsMetadataConfigurationProperty.builder()
     *         .s3Prefix("s3Prefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.DocumentsMetadataConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentsMetadataConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentsMetadataConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A prefix used to filter metadata configuration files in the AWS S3 bucket.
         * <p>
         * The S3 bucket might contain multiple metadata files. Use <code>S3Prefix</code> to include only the desired metadata files.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3Prefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DocumentsMetadataConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentsMetadataConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentsMetadataConfigurationProperty> {
            java.lang.String s3Prefix;

            /**
             * Sets the value of {@link DocumentsMetadataConfigurationProperty#getS3Prefix}
             * @param s3Prefix A prefix used to filter metadata configuration files in the AWS S3 bucket.
             *                 The S3 bucket might contain multiple metadata files. Use <code>S3Prefix</code> to include only the desired metadata files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Prefix(java.lang.String s3Prefix) {
                this.s3Prefix = s3Prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentsMetadataConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentsMetadataConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentsMetadataConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentsMetadataConfigurationProperty {
            private final java.lang.String s3Prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Prefix = software.amazon.jsii.Kernel.get(this, "s3Prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Prefix = builder.s3Prefix;
            }

            @Override
            public final java.lang.String getS3Prefix() {
                return this.s3Prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3Prefix() != null) {
                    data.set("s3Prefix", om.valueToTree(this.getS3Prefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.DocumentsMetadataConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentsMetadataConfigurationProperty.Jsii$Proxy that = (DocumentsMetadataConfigurationProperty.Jsii$Proxy) o;

                return this.s3Prefix != null ? this.s3Prefix.equals(that.s3Prefix) : that.s3Prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Prefix != null ? this.s3Prefix.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Provides the configuration information to connect to Google Drive as your data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * GoogleDriveConfigurationProperty googleDriveConfigurationProperty = GoogleDriveConfigurationProperty.builder()
     *         .secretArn("secretArn")
     *         // the properties below are optional
     *         .excludeMimeTypes(List.of("excludeMimeTypes"))
     *         .excludeSharedDrives(List.of("excludeSharedDrives"))
     *         .excludeUserAccounts(List.of("excludeUserAccounts"))
     *         .exclusionPatterns(List.of("exclusionPatterns"))
     *         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                 .dataSourceFieldName("dataSourceFieldName")
     *                 .indexFieldName("indexFieldName")
     *                 // the properties below are optional
     *                 .dateFieldFormat("dateFieldFormat")
     *                 .build()))
     *         .inclusionPatterns(List.of("inclusionPatterns"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.GoogleDriveConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(GoogleDriveConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GoogleDriveConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of a AWS Secrets Manager secret that contains the credentials required to connect to Google Drive.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive data source</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretArn();

        /**
         * A list of MIME types to exclude from the index. All documents matching the specified MIME type are excluded.
         * <p>
         * For a list of MIME types, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive data source</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludeMimeTypes() {
            return null;
        }

        /**
         * A list of identifiers or shared drives to exclude from the index.
         * <p>
         * All files and folders stored on the shared drive are excluded.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludeSharedDrives() {
            return null;
        }

        /**
         * A list of email addresses of the users.
         * <p>
         * Documents owned by these users are excluded from the index. Documents shared with excluded users are indexed unless they are excluded in another way.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludeUserAccounts() {
            return null;
        }

        /**
         * A list of regular expression patterns to exclude certain items in your Google Drive, including shared drives and users' My Drives.
         * <p>
         * Items that match the patterns are excluded from the index. Items that don't match the patterns are included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't included in the index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclusionPatterns() {
            return null;
        }

        /**
         * Maps Google Drive data source attributes or field names to Amazon Kendra index field names.
         * <p>
         * To create custom fields, use the <code>UpdateIndex</code> API before you map to Google Drive fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Google Drive data source field names must exist in your Google Drive custom metadata.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFieldMappings() {
            return null;
        }

        /**
         * A list of regular expression patterns to include certain items in your Google Drive, including shared drives and users' My Drives.
         * <p>
         * Items that match the patterns are included in the index. Items that don't match the patterns are excluded from the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't included in the index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclusionPatterns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GoogleDriveConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GoogleDriveConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GoogleDriveConfigurationProperty> {
            java.lang.String secretArn;
            java.util.List<java.lang.String> excludeMimeTypes;
            java.util.List<java.lang.String> excludeSharedDrives;
            java.util.List<java.lang.String> excludeUserAccounts;
            java.util.List<java.lang.String> exclusionPatterns;
            java.lang.Object fieldMappings;
            java.util.List<java.lang.String> inclusionPatterns;

            /**
             * Sets the value of {@link GoogleDriveConfigurationProperty#getSecretArn}
             * @param secretArn The Amazon Resource Name (ARN) of a AWS Secrets Manager secret that contains the credentials required to connect to Google Drive. This parameter is required.
             *                  For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive data source</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Sets the value of {@link GoogleDriveConfigurationProperty#getExcludeMimeTypes}
             * @param excludeMimeTypes A list of MIME types to exclude from the index. All documents matching the specified MIME type are excluded.
             *                         For a list of MIME types, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html">Using a Google Workspace Drive data source</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeMimeTypes(java.util.List<java.lang.String> excludeMimeTypes) {
                this.excludeMimeTypes = excludeMimeTypes;
                return this;
            }

            /**
             * Sets the value of {@link GoogleDriveConfigurationProperty#getExcludeSharedDrives}
             * @param excludeSharedDrives A list of identifiers or shared drives to exclude from the index.
             *                            All files and folders stored on the shared drive are excluded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeSharedDrives(java.util.List<java.lang.String> excludeSharedDrives) {
                this.excludeSharedDrives = excludeSharedDrives;
                return this;
            }

            /**
             * Sets the value of {@link GoogleDriveConfigurationProperty#getExcludeUserAccounts}
             * @param excludeUserAccounts A list of email addresses of the users.
             *                            Documents owned by these users are excluded from the index. Documents shared with excluded users are indexed unless they are excluded in another way.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeUserAccounts(java.util.List<java.lang.String> excludeUserAccounts) {
                this.excludeUserAccounts = excludeUserAccounts;
                return this;
            }

            /**
             * Sets the value of {@link GoogleDriveConfigurationProperty#getExclusionPatterns}
             * @param exclusionPatterns A list of regular expression patterns to exclude certain items in your Google Drive, including shared drives and users' My Drives.
             *                          Items that match the patterns are excluded from the index. Items that don't match the patterns are included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't included in the index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusionPatterns(java.util.List<java.lang.String> exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            /**
             * Sets the value of {@link GoogleDriveConfigurationProperty#getFieldMappings}
             * @param fieldMappings Maps Google Drive data source attributes or field names to Amazon Kendra index field names.
             *                      To create custom fields, use the <code>UpdateIndex</code> API before you map to Google Drive fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Google Drive data source field names must exist in your Google Drive custom metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(software.amazon.awscdk.IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link GoogleDriveConfigurationProperty#getFieldMappings}
             * @param fieldMappings Maps Google Drive data source attributes or field names to Amazon Kendra index field names.
             *                      To create custom fields, use the <code>UpdateIndex</code> API before you map to Google Drive fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Google Drive data source field names must exist in your Google Drive custom metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(java.util.List<? extends java.lang.Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link GoogleDriveConfigurationProperty#getInclusionPatterns}
             * @param inclusionPatterns A list of regular expression patterns to include certain items in your Google Drive, including shared drives and users' My Drives.
             *                          Items that match the patterns are included in the index. Items that don't match the patterns are excluded from the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't included in the index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusionPatterns(java.util.List<java.lang.String> inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GoogleDriveConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GoogleDriveConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GoogleDriveConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GoogleDriveConfigurationProperty {
            private final java.lang.String secretArn;
            private final java.util.List<java.lang.String> excludeMimeTypes;
            private final java.util.List<java.lang.String> excludeSharedDrives;
            private final java.util.List<java.lang.String> excludeUserAccounts;
            private final java.util.List<java.lang.String> exclusionPatterns;
            private final java.lang.Object fieldMappings;
            private final java.util.List<java.lang.String> inclusionPatterns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.excludeMimeTypes = software.amazon.jsii.Kernel.get(this, "excludeMimeTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.excludeSharedDrives = software.amazon.jsii.Kernel.get(this, "excludeSharedDrives", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.excludeUserAccounts = software.amazon.jsii.Kernel.get(this, "excludeUserAccounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.exclusionPatterns = software.amazon.jsii.Kernel.get(this, "exclusionPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.fieldMappings = software.amazon.jsii.Kernel.get(this, "fieldMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inclusionPatterns = software.amazon.jsii.Kernel.get(this, "inclusionPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretArn = java.util.Objects.requireNonNull(builder.secretArn, "secretArn is required");
                this.excludeMimeTypes = builder.excludeMimeTypes;
                this.excludeSharedDrives = builder.excludeSharedDrives;
                this.excludeUserAccounts = builder.excludeUserAccounts;
                this.exclusionPatterns = builder.exclusionPatterns;
                this.fieldMappings = builder.fieldMappings;
                this.inclusionPatterns = builder.inclusionPatterns;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludeMimeTypes() {
                return this.excludeMimeTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludeSharedDrives() {
                return this.excludeSharedDrives;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludeUserAccounts() {
                return this.excludeUserAccounts;
            }

            @Override
            public final java.util.List<java.lang.String> getExclusionPatterns() {
                return this.exclusionPatterns;
            }

            @Override
            public final java.lang.Object getFieldMappings() {
                return this.fieldMappings;
            }

            @Override
            public final java.util.List<java.lang.String> getInclusionPatterns() {
                return this.inclusionPatterns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("secretArn", om.valueToTree(this.getSecretArn()));
                if (this.getExcludeMimeTypes() != null) {
                    data.set("excludeMimeTypes", om.valueToTree(this.getExcludeMimeTypes()));
                }
                if (this.getExcludeSharedDrives() != null) {
                    data.set("excludeSharedDrives", om.valueToTree(this.getExcludeSharedDrives()));
                }
                if (this.getExcludeUserAccounts() != null) {
                    data.set("excludeUserAccounts", om.valueToTree(this.getExcludeUserAccounts()));
                }
                if (this.getExclusionPatterns() != null) {
                    data.set("exclusionPatterns", om.valueToTree(this.getExclusionPatterns()));
                }
                if (this.getFieldMappings() != null) {
                    data.set("fieldMappings", om.valueToTree(this.getFieldMappings()));
                }
                if (this.getInclusionPatterns() != null) {
                    data.set("inclusionPatterns", om.valueToTree(this.getInclusionPatterns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.GoogleDriveConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GoogleDriveConfigurationProperty.Jsii$Proxy that = (GoogleDriveConfigurationProperty.Jsii$Proxy) o;

                if (!secretArn.equals(that.secretArn)) return false;
                if (this.excludeMimeTypes != null ? !this.excludeMimeTypes.equals(that.excludeMimeTypes) : that.excludeMimeTypes != null) return false;
                if (this.excludeSharedDrives != null ? !this.excludeSharedDrives.equals(that.excludeSharedDrives) : that.excludeSharedDrives != null) return false;
                if (this.excludeUserAccounts != null ? !this.excludeUserAccounts.equals(that.excludeUserAccounts) : that.excludeUserAccounts != null) return false;
                if (this.exclusionPatterns != null ? !this.exclusionPatterns.equals(that.exclusionPatterns) : that.exclusionPatterns != null) return false;
                if (this.fieldMappings != null ? !this.fieldMappings.equals(that.fieldMappings) : that.fieldMappings != null) return false;
                return this.inclusionPatterns != null ? this.inclusionPatterns.equals(that.inclusionPatterns) : that.inclusionPatterns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretArn.hashCode();
                result = 31 * result + (this.excludeMimeTypes != null ? this.excludeMimeTypes.hashCode() : 0);
                result = 31 * result + (this.excludeSharedDrives != null ? this.excludeSharedDrives.hashCode() : 0);
                result = 31 * result + (this.excludeUserAccounts != null ? this.excludeUserAccounts.hashCode() : 0);
                result = 31 * result + (this.exclusionPatterns != null ? this.exclusionPatterns.hashCode() : 0);
                result = 31 * result + (this.fieldMappings != null ? this.fieldMappings.hashCode() : 0);
                result = 31 * result + (this.inclusionPatterns != null ? this.inclusionPatterns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information for invoking a Lambda function in AWS Lambda to alter document metadata and content when ingesting documents into Amazon Kendra.
     * <p>
     * You can configure your Lambda function using <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_CustomDocumentEnrichmentConfiguration.html">PreExtractionHookConfiguration</a> if you want to apply advanced alterations on the original or raw documents. If you want to apply advanced alterations on the Amazon Kendra structured documents, you must configure your Lambda function using <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_CustomDocumentEnrichmentConfiguration.html">PostExtractionHookConfiguration</a> . You can only invoke one Lambda function. However, this function can invoke other functions it requires.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * HookConfigurationProperty hookConfigurationProperty = HookConfigurationProperty.builder()
     *         .lambdaArn("lambdaArn")
     *         .s3Bucket("s3Bucket")
     *         // the properties below are optional
     *         .invocationCondition(DocumentAttributeConditionProperty.builder()
     *                 .conditionDocumentAttributeKey("conditionDocumentAttributeKey")
     *                 .operator("operator")
     *                 // the properties below are optional
     *                 .conditionOnValue(DocumentAttributeValueProperty.builder()
     *                         .dateValue("dateValue")
     *                         .longValue(123)
     *                         .stringListValue(List.of("stringListValue"))
     *                         .stringValue("stringValue")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.HookConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HookConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HookConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of a role with permission to run a Lambda function during ingestion.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLambdaArn();

        /**
         * Stores the original, raw documents or the structured, parsed documents before and after altering them.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#cde-data-contracts-lambda">Data contracts for Lambda functions</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Bucket();

        /**
         * The condition used for when a Lambda function should be invoked.
         * <p>
         * For example, you can specify a condition that if there are empty date-time values, then Amazon Kendra should invoke a function that inserts the current date-time.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInvocationCondition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HookConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HookConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HookConfigurationProperty> {
            java.lang.String lambdaArn;
            java.lang.String s3Bucket;
            java.lang.Object invocationCondition;

            /**
             * Sets the value of {@link HookConfigurationProperty#getLambdaArn}
             * @param lambdaArn The Amazon Resource Name (ARN) of a role with permission to run a Lambda function during ingestion. This parameter is required.
             *                  For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM roles for Amazon Kendra</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaArn(java.lang.String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            /**
             * Sets the value of {@link HookConfigurationProperty#getS3Bucket}
             * @param s3Bucket Stores the original, raw documents or the structured, parsed documents before and after altering them. This parameter is required.
             *                 For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#cde-data-contracts-lambda">Data contracts for Lambda functions</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(java.lang.String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Sets the value of {@link HookConfigurationProperty#getInvocationCondition}
             * @param invocationCondition The condition used for when a Lambda function should be invoked.
             *                            For example, you can specify a condition that if there are empty date-time values, then Amazon Kendra should invoke a function that inserts the current date-time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invocationCondition(software.amazon.awscdk.services.kendra.CfnDataSource.DocumentAttributeConditionProperty invocationCondition) {
                this.invocationCondition = invocationCondition;
                return this;
            }

            /**
             * Sets the value of {@link HookConfigurationProperty#getInvocationCondition}
             * @param invocationCondition The condition used for when a Lambda function should be invoked.
             *                            For example, you can specify a condition that if there are empty date-time values, then Amazon Kendra should invoke a function that inserts the current date-time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invocationCondition(software.amazon.awscdk.IResolvable invocationCondition) {
                this.invocationCondition = invocationCondition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HookConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HookConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HookConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HookConfigurationProperty {
            private final java.lang.String lambdaArn;
            private final java.lang.String s3Bucket;
            private final java.lang.Object invocationCondition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaArn = software.amazon.jsii.Kernel.get(this, "lambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Bucket = software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.invocationCondition = software.amazon.jsii.Kernel.get(this, "invocationCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaArn = java.util.Objects.requireNonNull(builder.lambdaArn, "lambdaArn is required");
                this.s3Bucket = java.util.Objects.requireNonNull(builder.s3Bucket, "s3Bucket is required");
                this.invocationCondition = builder.invocationCondition;
            }

            @Override
            public final java.lang.String getLambdaArn() {
                return this.lambdaArn;
            }

            @Override
            public final java.lang.String getS3Bucket() {
                return this.s3Bucket;
            }

            @Override
            public final java.lang.Object getInvocationCondition() {
                return this.invocationCondition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("lambdaArn", om.valueToTree(this.getLambdaArn()));
                data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
                if (this.getInvocationCondition() != null) {
                    data.set("invocationCondition", om.valueToTree(this.getInvocationCondition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.HookConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HookConfigurationProperty.Jsii$Proxy that = (HookConfigurationProperty.Jsii$Proxy) o;

                if (!lambdaArn.equals(that.lambdaArn)) return false;
                if (!s3Bucket.equals(that.s3Bucket)) return false;
                return this.invocationCondition != null ? this.invocationCondition.equals(that.invocationCondition) : that.invocationCondition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.lambdaArn.hashCode();
                result = 31 * result + (this.s3Bucket.hashCode());
                result = 31 * result + (this.invocationCondition != null ? this.invocationCondition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information for applying basic logic to alter document metadata and content when ingesting documents into Amazon Kendra.
     * <p>
     * To apply advanced logic, to go beyond what you can do with basic logic, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_HookConfiguration.html">HookConfiguration</a> .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing document metadata during the ingestion process</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * InlineCustomDocumentEnrichmentConfigurationProperty inlineCustomDocumentEnrichmentConfigurationProperty = InlineCustomDocumentEnrichmentConfigurationProperty.builder()
     *         .condition(DocumentAttributeConditionProperty.builder()
     *                 .conditionDocumentAttributeKey("conditionDocumentAttributeKey")
     *                 .operator("operator")
     *                 // the properties below are optional
     *                 .conditionOnValue(DocumentAttributeValueProperty.builder()
     *                         .dateValue("dateValue")
     *                         .longValue(123)
     *                         .stringListValue(List.of("stringListValue"))
     *                         .stringValue("stringValue")
     *                         .build())
     *                 .build())
     *         .documentContentDeletion(false)
     *         .target(DocumentAttributeTargetProperty.builder()
     *                 .targetDocumentAttributeKey("targetDocumentAttributeKey")
     *                 // the properties below are optional
     *                 .targetDocumentAttributeValue(DocumentAttributeValueProperty.builder()
     *                         .dateValue("dateValue")
     *                         .longValue(123)
     *                         .stringListValue(List.of("stringListValue"))
     *                         .stringValue("stringValue")
     *                         .build())
     *                 .targetDocumentAttributeValueDeletion(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.InlineCustomDocumentEnrichmentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(InlineCustomDocumentEnrichmentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InlineCustomDocumentEnrichmentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Kendra.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCondition() {
            return null;
        }

        /**
         * `TRUE` to delete content if the condition used for the target attribute is met.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDocumentContentDeletion() {
            return null;
        }

        /**
         * Configuration of the target document attribute or metadata field when ingesting documents into Amazon Kendra.
         * <p>
         * You can also include a value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTarget() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InlineCustomDocumentEnrichmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InlineCustomDocumentEnrichmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InlineCustomDocumentEnrichmentConfigurationProperty> {
            java.lang.Object condition;
            java.lang.Object documentContentDeletion;
            java.lang.Object target;

            /**
             * Sets the value of {@link InlineCustomDocumentEnrichmentConfigurationProperty#getCondition}
             * @param condition Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Kendra.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(software.amazon.awscdk.services.kendra.CfnDataSource.DocumentAttributeConditionProperty condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link InlineCustomDocumentEnrichmentConfigurationProperty#getCondition}
             * @param condition Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Kendra.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(software.amazon.awscdk.IResolvable condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link InlineCustomDocumentEnrichmentConfigurationProperty#getDocumentContentDeletion}
             * @param documentContentDeletion `TRUE` to delete content if the condition used for the target attribute is met.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentContentDeletion(java.lang.Boolean documentContentDeletion) {
                this.documentContentDeletion = documentContentDeletion;
                return this;
            }

            /**
             * Sets the value of {@link InlineCustomDocumentEnrichmentConfigurationProperty#getDocumentContentDeletion}
             * @param documentContentDeletion `TRUE` to delete content if the condition used for the target attribute is met.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentContentDeletion(software.amazon.awscdk.IResolvable documentContentDeletion) {
                this.documentContentDeletion = documentContentDeletion;
                return this;
            }

            /**
             * Sets the value of {@link InlineCustomDocumentEnrichmentConfigurationProperty#getTarget}
             * @param target Configuration of the target document attribute or metadata field when ingesting documents into Amazon Kendra.
             *               You can also include a value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(software.amazon.awscdk.services.kendra.CfnDataSource.DocumentAttributeTargetProperty target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link InlineCustomDocumentEnrichmentConfigurationProperty#getTarget}
             * @param target Configuration of the target document attribute or metadata field when ingesting documents into Amazon Kendra.
             *               You can also include a value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(software.amazon.awscdk.IResolvable target) {
                this.target = target;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InlineCustomDocumentEnrichmentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InlineCustomDocumentEnrichmentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InlineCustomDocumentEnrichmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InlineCustomDocumentEnrichmentConfigurationProperty {
            private final java.lang.Object condition;
            private final java.lang.Object documentContentDeletion;
            private final java.lang.Object target;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.documentContentDeletion = software.amazon.jsii.Kernel.get(this, "documentContentDeletion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.condition = builder.condition;
                this.documentContentDeletion = builder.documentContentDeletion;
                this.target = builder.target;
            }

            @Override
            public final java.lang.Object getCondition() {
                return this.condition;
            }

            @Override
            public final java.lang.Object getDocumentContentDeletion() {
                return this.documentContentDeletion;
            }

            @Override
            public final java.lang.Object getTarget() {
                return this.target;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCondition() != null) {
                    data.set("condition", om.valueToTree(this.getCondition()));
                }
                if (this.getDocumentContentDeletion() != null) {
                    data.set("documentContentDeletion", om.valueToTree(this.getDocumentContentDeletion()));
                }
                if (this.getTarget() != null) {
                    data.set("target", om.valueToTree(this.getTarget()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.InlineCustomDocumentEnrichmentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InlineCustomDocumentEnrichmentConfigurationProperty.Jsii$Proxy that = (InlineCustomDocumentEnrichmentConfigurationProperty.Jsii$Proxy) o;

                if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) return false;
                if (this.documentContentDeletion != null ? !this.documentContentDeletion.equals(that.documentContentDeletion) : that.documentContentDeletion != null) return false;
                return this.target != null ? this.target.equals(that.target) : that.target == null;
            }

            @Override
            public final int hashCode() {
                int result = this.condition != null ? this.condition.hashCode() : 0;
                result = 31 * result + (this.documentContentDeletion != null ? this.documentContentDeletion.hashCode() : 0);
                result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information to connect to OneDrive as your data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * OneDriveConfigurationProperty oneDriveConfigurationProperty = OneDriveConfigurationProperty.builder()
     *         .oneDriveUsers(OneDriveUsersProperty.builder()
     *                 .oneDriveUserList(List.of("oneDriveUserList"))
     *                 .oneDriveUserS3Path(S3PathProperty.builder()
     *                         .bucket("bucket")
     *                         .key("key")
     *                         .build())
     *                 .build())
     *         .secretArn("secretArn")
     *         .tenantDomain("tenantDomain")
     *         // the properties below are optional
     *         .disableLocalGroups(false)
     *         .exclusionPatterns(List.of("exclusionPatterns"))
     *         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                 .dataSourceFieldName("dataSourceFieldName")
     *                 .indexFieldName("indexFieldName")
     *                 // the properties below are optional
     *                 .dateFieldFormat("dateFieldFormat")
     *                 .build()))
     *         .inclusionPatterns(List.of("inclusionPatterns"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.OneDriveConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OneDriveConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OneDriveConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of user accounts whose documents should be indexed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOneDriveUsers();

        /**
         * The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that contains the user name and password to connect to OneDrive.
         * <p>
         * The user named should be the application ID for the OneDrive application, and the password is the application key for the OneDrive application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretArn();

        /**
         * The Azure Active Directory domain of the organization.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTenantDomain();

        /**
         * A Boolean value that specifies whether local groups are disabled ( `True` ) or enabled ( `False` ).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableLocalGroups() {
            return null;
        }

        /**
         * A list of regular expression patterns to exclude certain documents in your OneDrive.
         * <p>
         * Documents that match the patterns are excluded from the index. Documents that don't match the patterns are included in the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
         * <p>
         * The pattern is applied to the file name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclusionPatterns() {
            return null;
        }

        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map OneDrive data source attributes or field names to Amazon Kendra index field names.
         * <p>
         * To create custom fields, use the <code>UpdateIndex</code> API before you map to OneDrive fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The OneDrive data source field names must exist in your OneDrive custom metadata.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFieldMappings() {
            return null;
        }

        /**
         * A list of regular expression patterns to include certain documents in your OneDrive.
         * <p>
         * Documents that match the patterns are included in the index. Documents that don't match the patterns are excluded from the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
         * <p>
         * The pattern is applied to the file name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclusionPatterns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OneDriveConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OneDriveConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OneDriveConfigurationProperty> {
            java.lang.Object oneDriveUsers;
            java.lang.String secretArn;
            java.lang.String tenantDomain;
            java.lang.Object disableLocalGroups;
            java.util.List<java.lang.String> exclusionPatterns;
            java.lang.Object fieldMappings;
            java.util.List<java.lang.String> inclusionPatterns;

            /**
             * Sets the value of {@link OneDriveConfigurationProperty#getOneDriveUsers}
             * @param oneDriveUsers A list of user accounts whose documents should be indexed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oneDriveUsers(software.amazon.awscdk.services.kendra.CfnDataSource.OneDriveUsersProperty oneDriveUsers) {
                this.oneDriveUsers = oneDriveUsers;
                return this;
            }

            /**
             * Sets the value of {@link OneDriveConfigurationProperty#getOneDriveUsers}
             * @param oneDriveUsers A list of user accounts whose documents should be indexed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oneDriveUsers(software.amazon.awscdk.IResolvable oneDriveUsers) {
                this.oneDriveUsers = oneDriveUsers;
                return this;
            }

            /**
             * Sets the value of {@link OneDriveConfigurationProperty#getSecretArn}
             * @param secretArn The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that contains the user name and password to connect to OneDrive. This parameter is required.
             *                  The user named should be the application ID for the OneDrive application, and the password is the application key for the OneDrive application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Sets the value of {@link OneDriveConfigurationProperty#getTenantDomain}
             * @param tenantDomain The Azure Active Directory domain of the organization. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tenantDomain(java.lang.String tenantDomain) {
                this.tenantDomain = tenantDomain;
                return this;
            }

            /**
             * Sets the value of {@link OneDriveConfigurationProperty#getDisableLocalGroups}
             * @param disableLocalGroups A Boolean value that specifies whether local groups are disabled ( `True` ) or enabled ( `False` ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableLocalGroups(java.lang.Boolean disableLocalGroups) {
                this.disableLocalGroups = disableLocalGroups;
                return this;
            }

            /**
             * Sets the value of {@link OneDriveConfigurationProperty#getDisableLocalGroups}
             * @param disableLocalGroups A Boolean value that specifies whether local groups are disabled ( `True` ) or enabled ( `False` ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableLocalGroups(software.amazon.awscdk.IResolvable disableLocalGroups) {
                this.disableLocalGroups = disableLocalGroups;
                return this;
            }

            /**
             * Sets the value of {@link OneDriveConfigurationProperty#getExclusionPatterns}
             * @param exclusionPatterns A list of regular expression patterns to exclude certain documents in your OneDrive.
             *                          Documents that match the patterns are excluded from the index. Documents that don't match the patterns are included in the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
             *                          <p>
             *                          The pattern is applied to the file name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusionPatterns(java.util.List<java.lang.String> exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            /**
             * Sets the value of {@link OneDriveConfigurationProperty#getFieldMappings}
             * @param fieldMappings A list of `DataSourceToIndexFieldMapping` objects that map OneDrive data source attributes or field names to Amazon Kendra index field names.
             *                      To create custom fields, use the <code>UpdateIndex</code> API before you map to OneDrive fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The OneDrive data source field names must exist in your OneDrive custom metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(software.amazon.awscdk.IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link OneDriveConfigurationProperty#getFieldMappings}
             * @param fieldMappings A list of `DataSourceToIndexFieldMapping` objects that map OneDrive data source attributes or field names to Amazon Kendra index field names.
             *                      To create custom fields, use the <code>UpdateIndex</code> API before you map to OneDrive fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The OneDrive data source field names must exist in your OneDrive custom metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(java.util.List<? extends java.lang.Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link OneDriveConfigurationProperty#getInclusionPatterns}
             * @param inclusionPatterns A list of regular expression patterns to include certain documents in your OneDrive.
             *                          Documents that match the patterns are included in the index. Documents that don't match the patterns are excluded from the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
             *                          <p>
             *                          The pattern is applied to the file name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusionPatterns(java.util.List<java.lang.String> inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OneDriveConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OneDriveConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OneDriveConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OneDriveConfigurationProperty {
            private final java.lang.Object oneDriveUsers;
            private final java.lang.String secretArn;
            private final java.lang.String tenantDomain;
            private final java.lang.Object disableLocalGroups;
            private final java.util.List<java.lang.String> exclusionPatterns;
            private final java.lang.Object fieldMappings;
            private final java.util.List<java.lang.String> inclusionPatterns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.oneDriveUsers = software.amazon.jsii.Kernel.get(this, "oneDriveUsers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tenantDomain = software.amazon.jsii.Kernel.get(this, "tenantDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.disableLocalGroups = software.amazon.jsii.Kernel.get(this, "disableLocalGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.exclusionPatterns = software.amazon.jsii.Kernel.get(this, "exclusionPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.fieldMappings = software.amazon.jsii.Kernel.get(this, "fieldMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inclusionPatterns = software.amazon.jsii.Kernel.get(this, "inclusionPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.oneDriveUsers = java.util.Objects.requireNonNull(builder.oneDriveUsers, "oneDriveUsers is required");
                this.secretArn = java.util.Objects.requireNonNull(builder.secretArn, "secretArn is required");
                this.tenantDomain = java.util.Objects.requireNonNull(builder.tenantDomain, "tenantDomain is required");
                this.disableLocalGroups = builder.disableLocalGroups;
                this.exclusionPatterns = builder.exclusionPatterns;
                this.fieldMappings = builder.fieldMappings;
                this.inclusionPatterns = builder.inclusionPatterns;
            }

            @Override
            public final java.lang.Object getOneDriveUsers() {
                return this.oneDriveUsers;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            public final java.lang.String getTenantDomain() {
                return this.tenantDomain;
            }

            @Override
            public final java.lang.Object getDisableLocalGroups() {
                return this.disableLocalGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getExclusionPatterns() {
                return this.exclusionPatterns;
            }

            @Override
            public final java.lang.Object getFieldMappings() {
                return this.fieldMappings;
            }

            @Override
            public final java.util.List<java.lang.String> getInclusionPatterns() {
                return this.inclusionPatterns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("oneDriveUsers", om.valueToTree(this.getOneDriveUsers()));
                data.set("secretArn", om.valueToTree(this.getSecretArn()));
                data.set("tenantDomain", om.valueToTree(this.getTenantDomain()));
                if (this.getDisableLocalGroups() != null) {
                    data.set("disableLocalGroups", om.valueToTree(this.getDisableLocalGroups()));
                }
                if (this.getExclusionPatterns() != null) {
                    data.set("exclusionPatterns", om.valueToTree(this.getExclusionPatterns()));
                }
                if (this.getFieldMappings() != null) {
                    data.set("fieldMappings", om.valueToTree(this.getFieldMappings()));
                }
                if (this.getInclusionPatterns() != null) {
                    data.set("inclusionPatterns", om.valueToTree(this.getInclusionPatterns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.OneDriveConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OneDriveConfigurationProperty.Jsii$Proxy that = (OneDriveConfigurationProperty.Jsii$Proxy) o;

                if (!oneDriveUsers.equals(that.oneDriveUsers)) return false;
                if (!secretArn.equals(that.secretArn)) return false;
                if (!tenantDomain.equals(that.tenantDomain)) return false;
                if (this.disableLocalGroups != null ? !this.disableLocalGroups.equals(that.disableLocalGroups) : that.disableLocalGroups != null) return false;
                if (this.exclusionPatterns != null ? !this.exclusionPatterns.equals(that.exclusionPatterns) : that.exclusionPatterns != null) return false;
                if (this.fieldMappings != null ? !this.fieldMappings.equals(that.fieldMappings) : that.fieldMappings != null) return false;
                return this.inclusionPatterns != null ? this.inclusionPatterns.equals(that.inclusionPatterns) : that.inclusionPatterns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.oneDriveUsers.hashCode();
                result = 31 * result + (this.secretArn.hashCode());
                result = 31 * result + (this.tenantDomain.hashCode());
                result = 31 * result + (this.disableLocalGroups != null ? this.disableLocalGroups.hashCode() : 0);
                result = 31 * result + (this.exclusionPatterns != null ? this.exclusionPatterns.hashCode() : 0);
                result = 31 * result + (this.fieldMappings != null ? this.fieldMappings.hashCode() : 0);
                result = 31 * result + (this.inclusionPatterns != null ? this.inclusionPatterns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * User accounts whose documents should be indexed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * OneDriveUsersProperty oneDriveUsersProperty = OneDriveUsersProperty.builder()
     *         .oneDriveUserList(List.of("oneDriveUserList"))
     *         .oneDriveUserS3Path(S3PathProperty.builder()
     *                 .bucket("bucket")
     *                 .key("key")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.OneDriveUsersProperty")
    @software.amazon.jsii.Jsii.Proxy(OneDriveUsersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OneDriveUsersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of users whose documents should be indexed.
         * <p>
         * Specify the user names in email format, for example, <code>username&#64;tenantdomain</code> . If you need to index the documents of more than 100 users, use the <code>OneDriveUserS3Path</code> field to specify the location of a file containing a list of users.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOneDriveUserList() {
            return null;
        }

        /**
         * The S3 bucket location of a file containing a list of users whose documents should be indexed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOneDriveUserS3Path() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OneDriveUsersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OneDriveUsersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OneDriveUsersProperty> {
            java.util.List<java.lang.String> oneDriveUserList;
            java.lang.Object oneDriveUserS3Path;

            /**
             * Sets the value of {@link OneDriveUsersProperty#getOneDriveUserList}
             * @param oneDriveUserList A list of users whose documents should be indexed.
             *                         Specify the user names in email format, for example, <code>username&#64;tenantdomain</code> . If you need to index the documents of more than 100 users, use the <code>OneDriveUserS3Path</code> field to specify the location of a file containing a list of users.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oneDriveUserList(java.util.List<java.lang.String> oneDriveUserList) {
                this.oneDriveUserList = oneDriveUserList;
                return this;
            }

            /**
             * Sets the value of {@link OneDriveUsersProperty#getOneDriveUserS3Path}
             * @param oneDriveUserS3Path The S3 bucket location of a file containing a list of users whose documents should be indexed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oneDriveUserS3Path(software.amazon.awscdk.services.kendra.CfnDataSource.S3PathProperty oneDriveUserS3Path) {
                this.oneDriveUserS3Path = oneDriveUserS3Path;
                return this;
            }

            /**
             * Sets the value of {@link OneDriveUsersProperty#getOneDriveUserS3Path}
             * @param oneDriveUserS3Path The S3 bucket location of a file containing a list of users whose documents should be indexed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oneDriveUserS3Path(software.amazon.awscdk.IResolvable oneDriveUserS3Path) {
                this.oneDriveUserS3Path = oneDriveUserS3Path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OneDriveUsersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OneDriveUsersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OneDriveUsersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OneDriveUsersProperty {
            private final java.util.List<java.lang.String> oneDriveUserList;
            private final java.lang.Object oneDriveUserS3Path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.oneDriveUserList = software.amazon.jsii.Kernel.get(this, "oneDriveUserList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.oneDriveUserS3Path = software.amazon.jsii.Kernel.get(this, "oneDriveUserS3Path", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.oneDriveUserList = builder.oneDriveUserList;
                this.oneDriveUserS3Path = builder.oneDriveUserS3Path;
            }

            @Override
            public final java.util.List<java.lang.String> getOneDriveUserList() {
                return this.oneDriveUserList;
            }

            @Override
            public final java.lang.Object getOneDriveUserS3Path() {
                return this.oneDriveUserS3Path;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOneDriveUserList() != null) {
                    data.set("oneDriveUserList", om.valueToTree(this.getOneDriveUserList()));
                }
                if (this.getOneDriveUserS3Path() != null) {
                    data.set("oneDriveUserS3Path", om.valueToTree(this.getOneDriveUserS3Path()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.OneDriveUsersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OneDriveUsersProperty.Jsii$Proxy that = (OneDriveUsersProperty.Jsii$Proxy) o;

                if (this.oneDriveUserList != null ? !this.oneDriveUserList.equals(that.oneDriveUserList) : that.oneDriveUserList != null) return false;
                return this.oneDriveUserS3Path != null ? this.oneDriveUserS3Path.equals(that.oneDriveUserS3Path) : that.oneDriveUserS3Path == null;
            }

            @Override
            public final int hashCode() {
                int result = this.oneDriveUserList != null ? this.oneDriveUserList.hashCode() : 0;
                result = 31 * result + (this.oneDriveUserS3Path != null ? this.oneDriveUserS3Path.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information for a web proxy to connect to website hosts.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * ProxyConfigurationProperty proxyConfigurationProperty = ProxyConfigurationProperty.builder()
     *         .host("host")
     *         .port(123)
     *         // the properties below are optional
     *         .credentials("credentials")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.ProxyConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ProxyConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProxyConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the website host you want to connect to via a web proxy server.
         * <p>
         * For example, the host name of https://a.example.com/page1.html is "a.example.com".
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHost();

        /**
         * The port number of the website host you want to connect to via a web proxy server.
         * <p>
         * For example, the port for https://a.example.com/page1.html is 443, the standard port for HTTPS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * Your secret ARN, which you can create in [AWS Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html).
         * <p>
         * The credentials are optional. You use a secret if web proxy credentials are required to connect to a website host. Amazon Kendra currently support basic authentication to connect to a web proxy server. The secret stores your credentials.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCredentials() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProxyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProxyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProxyConfigurationProperty> {
            java.lang.String host;
            java.lang.Number port;
            java.lang.String credentials;

            /**
             * Sets the value of {@link ProxyConfigurationProperty#getHost}
             * @param host The name of the website host you want to connect to via a web proxy server. This parameter is required.
             *             For example, the host name of https://a.example.com/page1.html is "a.example.com".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link ProxyConfigurationProperty#getPort}
             * @param port The port number of the website host you want to connect to via a web proxy server. This parameter is required.
             *             For example, the port for https://a.example.com/page1.html is 443, the standard port for HTTPS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link ProxyConfigurationProperty#getCredentials}
             * @param credentials Your secret ARN, which you can create in [AWS Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html).
             *                    The credentials are optional. You use a secret if web proxy credentials are required to connect to a website host. Amazon Kendra currently support basic authentication to connect to a web proxy server. The secret stores your credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentials(java.lang.String credentials) {
                this.credentials = credentials;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProxyConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProxyConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProxyConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProxyConfigurationProperty {
            private final java.lang.String host;
            private final java.lang.Number port;
            private final java.lang.String credentials;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.credentials = builder.credentials;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getCredentials() {
                return this.credentials;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("host", om.valueToTree(this.getHost()));
                data.set("port", om.valueToTree(this.getPort()));
                if (this.getCredentials() != null) {
                    data.set("credentials", om.valueToTree(this.getCredentials()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.ProxyConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProxyConfigurationProperty.Jsii$Proxy that = (ProxyConfigurationProperty.Jsii$Proxy) o;

                if (!host.equals(that.host)) return false;
                if (!port.equals(that.port)) return false;
                return this.credentials != null ? this.credentials.equals(that.credentials) : that.credentials == null;
            }

            @Override
            public final int hashCode() {
                int result = this.host.hashCode();
                result = 31 * result + (this.port.hashCode());
                result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information to connect to an Amazon S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * S3DataSourceConfigurationProperty s3DataSourceConfigurationProperty = S3DataSourceConfigurationProperty.builder()
     *         .bucketName("bucketName")
     *         // the properties below are optional
     *         .accessControlListConfiguration(AccessControlListConfigurationProperty.builder()
     *                 .keyPath("keyPath")
     *                 .build())
     *         .documentsMetadataConfiguration(DocumentsMetadataConfigurationProperty.builder()
     *                 .s3Prefix("s3Prefix")
     *                 .build())
     *         .exclusionPatterns(List.of("exclusionPatterns"))
     *         .inclusionPatterns(List.of("inclusionPatterns"))
     *         .inclusionPrefixes(List.of("inclusionPrefixes"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.S3DataSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3DataSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3DataSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the bucket that contains the documents.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * Provides the path to the S3 bucket that contains the user context filtering files for the data source.
         * <p>
         * For the format of the file, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html">Access control for S3 data sources</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAccessControlListConfiguration() {
            return null;
        }

        /**
         * Specifies document metadata files that contain information such as the document access control information, source URI, document author, and custom attributes.
         * <p>
         * Each metadata file contains metadata about a single document.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDocumentsMetadataConfiguration() {
            return null;
        }

        /**
         * A list of glob patterns for documents that should not be indexed.
         * <p>
         * If a document that matches an inclusion prefix or inclusion pattern also matches an exclusion pattern, the document is not indexed.
         * <p>
         * Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples</a> are:
         * <p>
         * <ul>
         * <li>**.png , <em>.jpg</em> will exclude all PNG and JPEG image files in a directory (files with the extensions .png and .jpg).</li>
         * <li><strong>internal</strong> will exclude all files in a directory that contain 'internal' in the file name, such as 'internal', 'internal_only', 'company_internal'.</li>
         * <li>*** /<em>internal</em>* will exclude all internal-related files in a directory and its subdirectories.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclusionPatterns() {
            return null;
        }

        /**
         * A list of glob patterns for documents that should be indexed.
         * <p>
         * If a document that matches an inclusion pattern also matches an exclusion pattern, the document is not indexed.
         * <p>
         * Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples</a> are:
         * <p>
         * <ul>
         * <li>*<em>.txt</em> will include all text files in a directory (files with the extension .txt).</li>
         * <li>*** /<em>.txt</em> will include all text files in a directory and its subdirectories.</li>
         * <li><strong>tax</strong> will include all files in a directory that contain 'tax' in the file name, such as 'tax', 'taxes', 'income_tax'.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclusionPatterns() {
            return null;
        }

        /**
         * A list of S3 prefixes for the documents that should be included in the index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclusionPrefixes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3DataSourceConfigurationProperty> {
            java.lang.String bucketName;
            java.lang.Object accessControlListConfiguration;
            java.lang.Object documentsMetadataConfiguration;
            java.util.List<java.lang.String> exclusionPatterns;
            java.util.List<java.lang.String> inclusionPatterns;
            java.util.List<java.lang.String> inclusionPrefixes;

            /**
             * Sets the value of {@link S3DataSourceConfigurationProperty#getBucketName}
             * @param bucketName The name of the bucket that contains the documents. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3DataSourceConfigurationProperty#getAccessControlListConfiguration}
             * @param accessControlListConfiguration Provides the path to the S3 bucket that contains the user context filtering files for the data source.
             *                                       For the format of the file, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html">Access control for S3 data sources</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlListConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.AccessControlListConfigurationProperty accessControlListConfiguration) {
                this.accessControlListConfiguration = accessControlListConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link S3DataSourceConfigurationProperty#getAccessControlListConfiguration}
             * @param accessControlListConfiguration Provides the path to the S3 bucket that contains the user context filtering files for the data source.
             *                                       For the format of the file, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html">Access control for S3 data sources</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessControlListConfiguration(software.amazon.awscdk.IResolvable accessControlListConfiguration) {
                this.accessControlListConfiguration = accessControlListConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link S3DataSourceConfigurationProperty#getDocumentsMetadataConfiguration}
             * @param documentsMetadataConfiguration Specifies document metadata files that contain information such as the document access control information, source URI, document author, and custom attributes.
             *                                       Each metadata file contains metadata about a single document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentsMetadataConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.DocumentsMetadataConfigurationProperty documentsMetadataConfiguration) {
                this.documentsMetadataConfiguration = documentsMetadataConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link S3DataSourceConfigurationProperty#getDocumentsMetadataConfiguration}
             * @param documentsMetadataConfiguration Specifies document metadata files that contain information such as the document access control information, source URI, document author, and custom attributes.
             *                                       Each metadata file contains metadata about a single document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentsMetadataConfiguration(software.amazon.awscdk.IResolvable documentsMetadataConfiguration) {
                this.documentsMetadataConfiguration = documentsMetadataConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link S3DataSourceConfigurationProperty#getExclusionPatterns}
             * @param exclusionPatterns A list of glob patterns for documents that should not be indexed.
             *                          If a document that matches an inclusion prefix or inclusion pattern also matches an exclusion pattern, the document is not indexed.
             *                          <p>
             *                          Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples</a> are:
             *                          <p>
             *                          <ul>
             *                          <li>**.png , <em>.jpg</em> will exclude all PNG and JPEG image files in a directory (files with the extensions .png and .jpg).</li>
             *                          <li><strong>internal</strong> will exclude all files in a directory that contain 'internal' in the file name, such as 'internal', 'internal_only', 'company_internal'.</li>
             *                          <li>*** /<em>internal</em>* will exclude all internal-related files in a directory and its subdirectories.</li>
             *                          </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusionPatterns(java.util.List<java.lang.String> exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            /**
             * Sets the value of {@link S3DataSourceConfigurationProperty#getInclusionPatterns}
             * @param inclusionPatterns A list of glob patterns for documents that should be indexed.
             *                          If a document that matches an inclusion pattern also matches an exclusion pattern, the document is not indexed.
             *                          <p>
             *                          Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples</a> are:
             *                          <p>
             *                          <ul>
             *                          <li>*<em>.txt</em> will include all text files in a directory (files with the extension .txt).</li>
             *                          <li>*** /<em>.txt</em> will include all text files in a directory and its subdirectories.</li>
             *                          <li><strong>tax</strong> will include all files in a directory that contain 'tax' in the file name, such as 'tax', 'taxes', 'income_tax'.</li>
             *                          </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusionPatterns(java.util.List<java.lang.String> inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            /**
             * Sets the value of {@link S3DataSourceConfigurationProperty#getInclusionPrefixes}
             * @param inclusionPrefixes A list of S3 prefixes for the documents that should be included in the index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusionPrefixes(java.util.List<java.lang.String> inclusionPrefixes) {
                this.inclusionPrefixes = inclusionPrefixes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3DataSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3DataSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3DataSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3DataSourceConfigurationProperty {
            private final java.lang.String bucketName;
            private final java.lang.Object accessControlListConfiguration;
            private final java.lang.Object documentsMetadataConfiguration;
            private final java.util.List<java.lang.String> exclusionPatterns;
            private final java.util.List<java.lang.String> inclusionPatterns;
            private final java.util.List<java.lang.String> inclusionPrefixes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accessControlListConfiguration = software.amazon.jsii.Kernel.get(this, "accessControlListConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.documentsMetadataConfiguration = software.amazon.jsii.Kernel.get(this, "documentsMetadataConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.exclusionPatterns = software.amazon.jsii.Kernel.get(this, "exclusionPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.inclusionPatterns = software.amazon.jsii.Kernel.get(this, "inclusionPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.inclusionPrefixes = software.amazon.jsii.Kernel.get(this, "inclusionPrefixes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.accessControlListConfiguration = builder.accessControlListConfiguration;
                this.documentsMetadataConfiguration = builder.documentsMetadataConfiguration;
                this.exclusionPatterns = builder.exclusionPatterns;
                this.inclusionPatterns = builder.inclusionPatterns;
                this.inclusionPrefixes = builder.inclusionPrefixes;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.Object getAccessControlListConfiguration() {
                return this.accessControlListConfiguration;
            }

            @Override
            public final java.lang.Object getDocumentsMetadataConfiguration() {
                return this.documentsMetadataConfiguration;
            }

            @Override
            public final java.util.List<java.lang.String> getExclusionPatterns() {
                return this.exclusionPatterns;
            }

            @Override
            public final java.util.List<java.lang.String> getInclusionPatterns() {
                return this.inclusionPatterns;
            }

            @Override
            public final java.util.List<java.lang.String> getInclusionPrefixes() {
                return this.inclusionPrefixes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                if (this.getAccessControlListConfiguration() != null) {
                    data.set("accessControlListConfiguration", om.valueToTree(this.getAccessControlListConfiguration()));
                }
                if (this.getDocumentsMetadataConfiguration() != null) {
                    data.set("documentsMetadataConfiguration", om.valueToTree(this.getDocumentsMetadataConfiguration()));
                }
                if (this.getExclusionPatterns() != null) {
                    data.set("exclusionPatterns", om.valueToTree(this.getExclusionPatterns()));
                }
                if (this.getInclusionPatterns() != null) {
                    data.set("inclusionPatterns", om.valueToTree(this.getInclusionPatterns()));
                }
                if (this.getInclusionPrefixes() != null) {
                    data.set("inclusionPrefixes", om.valueToTree(this.getInclusionPrefixes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.S3DataSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3DataSourceConfigurationProperty.Jsii$Proxy that = (S3DataSourceConfigurationProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (this.accessControlListConfiguration != null ? !this.accessControlListConfiguration.equals(that.accessControlListConfiguration) : that.accessControlListConfiguration != null) return false;
                if (this.documentsMetadataConfiguration != null ? !this.documentsMetadataConfiguration.equals(that.documentsMetadataConfiguration) : that.documentsMetadataConfiguration != null) return false;
                if (this.exclusionPatterns != null ? !this.exclusionPatterns.equals(that.exclusionPatterns) : that.exclusionPatterns != null) return false;
                if (this.inclusionPatterns != null ? !this.inclusionPatterns.equals(that.inclusionPatterns) : that.inclusionPatterns != null) return false;
                return this.inclusionPrefixes != null ? this.inclusionPrefixes.equals(that.inclusionPrefixes) : that.inclusionPrefixes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.accessControlListConfiguration != null ? this.accessControlListConfiguration.hashCode() : 0);
                result = 31 * result + (this.documentsMetadataConfiguration != null ? this.documentsMetadataConfiguration.hashCode() : 0);
                result = 31 * result + (this.exclusionPatterns != null ? this.exclusionPatterns.hashCode() : 0);
                result = 31 * result + (this.inclusionPatterns != null ? this.inclusionPatterns.hashCode() : 0);
                result = 31 * result + (this.inclusionPrefixes != null ? this.inclusionPrefixes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information required to find a specific file in an Amazon S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * S3PathProperty s3PathProperty = S3PathProperty.builder()
     *         .bucket("bucket")
     *         .key("key")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.S3PathProperty")
    @software.amazon.jsii.Jsii.Proxy(S3PathProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3PathProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the S3 bucket that contains the file.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * The name of the file.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * @return a {@link Builder} of {@link S3PathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3PathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3PathProperty> {
            java.lang.String bucket;
            java.lang.String key;

            /**
             * Sets the value of {@link S3PathProperty#getBucket}
             * @param bucket The name of the S3 bucket that contains the file. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3PathProperty#getKey}
             * @param key The name of the file. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3PathProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3PathProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3PathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3PathProperty {
            private final java.lang.String bucket;
            private final java.lang.String key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("key", om.valueToTree(this.getKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.S3PathProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3PathProperty.Jsii$Proxy that = (S3PathProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                return this.key.equals(that.key);
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration information for syncing a Salesforce chatter feed.
     * <p>
     * The contents of the object comes from the Salesforce FeedItem table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * SalesforceChatterFeedConfigurationProperty salesforceChatterFeedConfigurationProperty = SalesforceChatterFeedConfigurationProperty.builder()
     *         .documentDataFieldName("documentDataFieldName")
     *         // the properties below are optional
     *         .documentTitleFieldName("documentTitleFieldName")
     *         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                 .dataSourceFieldName("dataSourceFieldName")
     *                 .indexFieldName("indexFieldName")
     *                 // the properties below are optional
     *                 .dateFieldFormat("dateFieldFormat")
     *                 .build()))
     *         .includeFilterTypes(List.of("includeFilterTypes"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceChatterFeedConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceChatterFeedConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceChatterFeedConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the column in the Salesforce FeedItem table that contains the content to index.
         * <p>
         * Typically this is the <code>Body</code> column.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDocumentDataFieldName();

        /**
         * The name of the column in the Salesforce FeedItem table that contains the title of the document.
         * <p>
         * This is typically the <code>Title</code> column.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentTitleFieldName() {
            return null;
        }

        /**
         * Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFieldMappings() {
            return null;
        }

        /**
         * Filters the documents in the feed based on status of the user.
         * <p>
         * When you specify <code>ACTIVE_USERS</code> only documents from users who have an active account are indexed. When you specify <code>STANDARD_USER</code> only documents for Salesforce standard users are documented. You can specify both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludeFilterTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceChatterFeedConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceChatterFeedConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceChatterFeedConfigurationProperty> {
            java.lang.String documentDataFieldName;
            java.lang.String documentTitleFieldName;
            java.lang.Object fieldMappings;
            java.util.List<java.lang.String> includeFilterTypes;

            /**
             * Sets the value of {@link SalesforceChatterFeedConfigurationProperty#getDocumentDataFieldName}
             * @param documentDataFieldName The name of the column in the Salesforce FeedItem table that contains the content to index. This parameter is required.
             *                              Typically this is the <code>Body</code> column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentDataFieldName(java.lang.String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceChatterFeedConfigurationProperty#getDocumentTitleFieldName}
             * @param documentTitleFieldName The name of the column in the Salesforce FeedItem table that contains the title of the document.
             *                               This is typically the <code>Title</code> column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentTitleFieldName(java.lang.String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceChatterFeedConfigurationProperty#getFieldMappings}
             * @param fieldMappings Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(software.amazon.awscdk.IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceChatterFeedConfigurationProperty#getFieldMappings}
             * @param fieldMappings Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(java.util.List<? extends java.lang.Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceChatterFeedConfigurationProperty#getIncludeFilterTypes}
             * @param includeFilterTypes Filters the documents in the feed based on status of the user.
             *                           When you specify <code>ACTIVE_USERS</code> only documents from users who have an active account are indexed. When you specify <code>STANDARD_USER</code> only documents for Salesforce standard users are documented. You can specify both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeFilterTypes(java.util.List<java.lang.String> includeFilterTypes) {
                this.includeFilterTypes = includeFilterTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceChatterFeedConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceChatterFeedConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceChatterFeedConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceChatterFeedConfigurationProperty {
            private final java.lang.String documentDataFieldName;
            private final java.lang.String documentTitleFieldName;
            private final java.lang.Object fieldMappings;
            private final java.util.List<java.lang.String> includeFilterTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.documentDataFieldName = software.amazon.jsii.Kernel.get(this, "documentDataFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.documentTitleFieldName = software.amazon.jsii.Kernel.get(this, "documentTitleFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldMappings = software.amazon.jsii.Kernel.get(this, "fieldMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeFilterTypes = software.amazon.jsii.Kernel.get(this, "includeFilterTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.documentDataFieldName = java.util.Objects.requireNonNull(builder.documentDataFieldName, "documentDataFieldName is required");
                this.documentTitleFieldName = builder.documentTitleFieldName;
                this.fieldMappings = builder.fieldMappings;
                this.includeFilterTypes = builder.includeFilterTypes;
            }

            @Override
            public final java.lang.String getDocumentDataFieldName() {
                return this.documentDataFieldName;
            }

            @Override
            public final java.lang.String getDocumentTitleFieldName() {
                return this.documentTitleFieldName;
            }

            @Override
            public final java.lang.Object getFieldMappings() {
                return this.fieldMappings;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludeFilterTypes() {
                return this.includeFilterTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("documentDataFieldName", om.valueToTree(this.getDocumentDataFieldName()));
                if (this.getDocumentTitleFieldName() != null) {
                    data.set("documentTitleFieldName", om.valueToTree(this.getDocumentTitleFieldName()));
                }
                if (this.getFieldMappings() != null) {
                    data.set("fieldMappings", om.valueToTree(this.getFieldMappings()));
                }
                if (this.getIncludeFilterTypes() != null) {
                    data.set("includeFilterTypes", om.valueToTree(this.getIncludeFilterTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceChatterFeedConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceChatterFeedConfigurationProperty.Jsii$Proxy that = (SalesforceChatterFeedConfigurationProperty.Jsii$Proxy) o;

                if (!documentDataFieldName.equals(that.documentDataFieldName)) return false;
                if (this.documentTitleFieldName != null ? !this.documentTitleFieldName.equals(that.documentTitleFieldName) : that.documentTitleFieldName != null) return false;
                if (this.fieldMappings != null ? !this.fieldMappings.equals(that.fieldMappings) : that.fieldMappings != null) return false;
                return this.includeFilterTypes != null ? this.includeFilterTypes.equals(that.includeFilterTypes) : that.includeFilterTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.documentDataFieldName.hashCode();
                result = 31 * result + (this.documentTitleFieldName != null ? this.documentTitleFieldName.hashCode() : 0);
                result = 31 * result + (this.fieldMappings != null ? this.fieldMappings.hashCode() : 0);
                result = 31 * result + (this.includeFilterTypes != null ? this.includeFilterTypes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information to connect to Salesforce as your data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * SalesforceConfigurationProperty salesforceConfigurationProperty = SalesforceConfigurationProperty.builder()
     *         .secretArn("secretArn")
     *         .serverUrl("serverUrl")
     *         // the properties below are optional
     *         .chatterFeedConfiguration(SalesforceChatterFeedConfigurationProperty.builder()
     *                 .documentDataFieldName("documentDataFieldName")
     *                 // the properties below are optional
     *                 .documentTitleFieldName("documentTitleFieldName")
     *                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                         .dataSourceFieldName("dataSourceFieldName")
     *                         .indexFieldName("indexFieldName")
     *                         // the properties below are optional
     *                         .dateFieldFormat("dateFieldFormat")
     *                         .build()))
     *                 .includeFilterTypes(List.of("includeFilterTypes"))
     *                 .build())
     *         .crawlAttachments(false)
     *         .excludeAttachmentFilePatterns(List.of("excludeAttachmentFilePatterns"))
     *         .includeAttachmentFilePatterns(List.of("includeAttachmentFilePatterns"))
     *         .knowledgeArticleConfiguration(SalesforceKnowledgeArticleConfigurationProperty.builder()
     *                 .includedStates(List.of("includedStates"))
     *                 // the properties below are optional
     *                 .customKnowledgeArticleTypeConfigurations(List.of(SalesforceCustomKnowledgeArticleTypeConfigurationProperty.builder()
     *                         .documentDataFieldName("documentDataFieldName")
     *                         .name("name")
     *                         // the properties below are optional
     *                         .documentTitleFieldName("documentTitleFieldName")
     *                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                                 .dataSourceFieldName("dataSourceFieldName")
     *                                 .indexFieldName("indexFieldName")
     *                                 // the properties below are optional
     *                                 .dateFieldFormat("dateFieldFormat")
     *                                 .build()))
     *                         .build()))
     *                 .standardKnowledgeArticleTypeConfiguration(SalesforceStandardKnowledgeArticleTypeConfigurationProperty.builder()
     *                         .documentDataFieldName("documentDataFieldName")
     *                         // the properties below are optional
     *                         .documentTitleFieldName("documentTitleFieldName")
     *                         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                                 .dataSourceFieldName("dataSourceFieldName")
     *                                 .indexFieldName("indexFieldName")
     *                                 // the properties below are optional
     *                                 .dateFieldFormat("dateFieldFormat")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .standardObjectAttachmentConfiguration(SalesforceStandardObjectAttachmentConfigurationProperty.builder()
     *                 .documentTitleFieldName("documentTitleFieldName")
     *                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                         .dataSourceFieldName("dataSourceFieldName")
     *                         .indexFieldName("indexFieldName")
     *                         // the properties below are optional
     *                         .dateFieldFormat("dateFieldFormat")
     *                         .build()))
     *                 .build())
     *         .standardObjectConfigurations(List.of(SalesforceStandardObjectConfigurationProperty.builder()
     *                 .documentDataFieldName("documentDataFieldName")
     *                 .name("name")
     *                 // the properties below are optional
     *                 .documentTitleFieldName("documentTitleFieldName")
     *                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                         .dataSourceFieldName("dataSourceFieldName")
     *                         .indexFieldName("indexFieldName")
     *                         // the properties below are optional
     *                         .dateFieldFormat("dateFieldFormat")
     *                         .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that contains the key/value pairs required to connect to your Salesforce instance.
         * <p>
         * The secret must contain a JSON structure with the following keys:
         * <p>
         * <ul>
         * <li>authenticationUrl - The OAUTH endpoint that Amazon Kendra connects to get an OAUTH token.</li>
         * <li>consumerKey - The application public key generated when you created your Salesforce application.</li>
         * <li>consumerSecret - The application private key generated when you created your Salesforce application.</li>
         * <li>password - The password associated with the user logging in to the Salesforce instance.</li>
         * <li>securityToken - The token associated with the user account logging in to the Salesforce instance.</li>
         * <li>username - The user name of the user logging in to the Salesforce instance.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretArn();

        /**
         * The instance URL for the Salesforce site that you want to index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServerUrl();

        /**
         * Configuration information for Salesforce chatter feeds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getChatterFeedConfiguration() {
            return null;
        }

        /**
         * Indicates whether Amazon Kendra should index attachments to Salesforce objects.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrawlAttachments() {
            return null;
        }

        /**
         * A list of regular expression patterns to exclude certain documents in your Salesforce.
         * <p>
         * Documents that match the patterns are excluded from the index. Documents that don't match the patterns are included in the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
         * <p>
         * The pattern is applied to the name of the attached file.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludeAttachmentFilePatterns() {
            return null;
        }

        /**
         * A list of regular expression patterns to include certain documents in your Salesforce.
         * <p>
         * Documents that match the patterns are included in the index. Documents that don't match the patterns are excluded from the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
         * <p>
         * The pattern is applied to the name of the attached file.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludeAttachmentFilePatterns() {
            return null;
        }

        /**
         * Configuration information for the knowledge article types that Amazon Kendra indexes.
         * <p>
         * Amazon Kendra indexes standard knowledge articles and the standard fields of knowledge articles, or the custom fields of custom knowledge articles, but not both.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKnowledgeArticleConfiguration() {
            return null;
        }

        /**
         * Configuration information for processing attachments to Salesforce standard objects.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStandardObjectAttachmentConfiguration() {
            return null;
        }

        /**
         * Configuration of the Salesforce standard objects that Amazon Kendra indexes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStandardObjectConfigurations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceConfigurationProperty> {
            java.lang.String secretArn;
            java.lang.String serverUrl;
            java.lang.Object chatterFeedConfiguration;
            java.lang.Object crawlAttachments;
            java.util.List<java.lang.String> excludeAttachmentFilePatterns;
            java.util.List<java.lang.String> includeAttachmentFilePatterns;
            java.lang.Object knowledgeArticleConfiguration;
            java.lang.Object standardObjectAttachmentConfiguration;
            java.lang.Object standardObjectConfigurations;

            /**
             * Sets the value of {@link SalesforceConfigurationProperty#getSecretArn}
             * @param secretArn The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that contains the key/value pairs required to connect to your Salesforce instance. This parameter is required.
             *                  The secret must contain a JSON structure with the following keys:
             *                  <p>
             *                  <ul>
             *                  <li>authenticationUrl - The OAUTH endpoint that Amazon Kendra connects to get an OAUTH token.</li>
             *                  <li>consumerKey - The application public key generated when you created your Salesforce application.</li>
             *                  <li>consumerSecret - The application private key generated when you created your Salesforce application.</li>
             *                  <li>password - The password associated with the user logging in to the Salesforce instance.</li>
             *                  <li>securityToken - The token associated with the user account logging in to the Salesforce instance.</li>
             *                  <li>username - The user name of the user logging in to the Salesforce instance.</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConfigurationProperty#getServerUrl}
             * @param serverUrl The instance URL for the Salesforce site that you want to index. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverUrl(java.lang.String serverUrl) {
                this.serverUrl = serverUrl;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConfigurationProperty#getChatterFeedConfiguration}
             * @param chatterFeedConfiguration Configuration information for Salesforce chatter feeds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder chatterFeedConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.SalesforceChatterFeedConfigurationProperty chatterFeedConfiguration) {
                this.chatterFeedConfiguration = chatterFeedConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConfigurationProperty#getChatterFeedConfiguration}
             * @param chatterFeedConfiguration Configuration information for Salesforce chatter feeds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder chatterFeedConfiguration(software.amazon.awscdk.IResolvable chatterFeedConfiguration) {
                this.chatterFeedConfiguration = chatterFeedConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConfigurationProperty#getCrawlAttachments}
             * @param crawlAttachments Indicates whether Amazon Kendra should index attachments to Salesforce objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlAttachments(java.lang.Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConfigurationProperty#getCrawlAttachments}
             * @param crawlAttachments Indicates whether Amazon Kendra should index attachments to Salesforce objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlAttachments(software.amazon.awscdk.IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConfigurationProperty#getExcludeAttachmentFilePatterns}
             * @param excludeAttachmentFilePatterns A list of regular expression patterns to exclude certain documents in your Salesforce.
             *                                      Documents that match the patterns are excluded from the index. Documents that don't match the patterns are included in the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
             *                                      <p>
             *                                      The pattern is applied to the name of the attached file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeAttachmentFilePatterns(java.util.List<java.lang.String> excludeAttachmentFilePatterns) {
                this.excludeAttachmentFilePatterns = excludeAttachmentFilePatterns;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConfigurationProperty#getIncludeAttachmentFilePatterns}
             * @param includeAttachmentFilePatterns A list of regular expression patterns to include certain documents in your Salesforce.
             *                                      Documents that match the patterns are included in the index. Documents that don't match the patterns are excluded from the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
             *                                      <p>
             *                                      The pattern is applied to the name of the attached file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeAttachmentFilePatterns(java.util.List<java.lang.String> includeAttachmentFilePatterns) {
                this.includeAttachmentFilePatterns = includeAttachmentFilePatterns;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConfigurationProperty#getKnowledgeArticleConfiguration}
             * @param knowledgeArticleConfiguration Configuration information for the knowledge article types that Amazon Kendra indexes.
             *                                      Amazon Kendra indexes standard knowledge articles and the standard fields of knowledge articles, or the custom fields of custom knowledge articles, but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder knowledgeArticleConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.SalesforceKnowledgeArticleConfigurationProperty knowledgeArticleConfiguration) {
                this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConfigurationProperty#getKnowledgeArticleConfiguration}
             * @param knowledgeArticleConfiguration Configuration information for the knowledge article types that Amazon Kendra indexes.
             *                                      Amazon Kendra indexes standard knowledge articles and the standard fields of knowledge articles, or the custom fields of custom knowledge articles, but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder knowledgeArticleConfiguration(software.amazon.awscdk.IResolvable knowledgeArticleConfiguration) {
                this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConfigurationProperty#getStandardObjectAttachmentConfiguration}
             * @param standardObjectAttachmentConfiguration Configuration information for processing attachments to Salesforce standard objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder standardObjectAttachmentConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.SalesforceStandardObjectAttachmentConfigurationProperty standardObjectAttachmentConfiguration) {
                this.standardObjectAttachmentConfiguration = standardObjectAttachmentConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConfigurationProperty#getStandardObjectAttachmentConfiguration}
             * @param standardObjectAttachmentConfiguration Configuration information for processing attachments to Salesforce standard objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder standardObjectAttachmentConfiguration(software.amazon.awscdk.IResolvable standardObjectAttachmentConfiguration) {
                this.standardObjectAttachmentConfiguration = standardObjectAttachmentConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConfigurationProperty#getStandardObjectConfigurations}
             * @param standardObjectConfigurations Configuration of the Salesforce standard objects that Amazon Kendra indexes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder standardObjectConfigurations(software.amazon.awscdk.IResolvable standardObjectConfigurations) {
                this.standardObjectConfigurations = standardObjectConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConfigurationProperty#getStandardObjectConfigurations}
             * @param standardObjectConfigurations Configuration of the Salesforce standard objects that Amazon Kendra indexes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder standardObjectConfigurations(java.util.List<? extends java.lang.Object> standardObjectConfigurations) {
                this.standardObjectConfigurations = standardObjectConfigurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceConfigurationProperty {
            private final java.lang.String secretArn;
            private final java.lang.String serverUrl;
            private final java.lang.Object chatterFeedConfiguration;
            private final java.lang.Object crawlAttachments;
            private final java.util.List<java.lang.String> excludeAttachmentFilePatterns;
            private final java.util.List<java.lang.String> includeAttachmentFilePatterns;
            private final java.lang.Object knowledgeArticleConfiguration;
            private final java.lang.Object standardObjectAttachmentConfiguration;
            private final java.lang.Object standardObjectConfigurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serverUrl = software.amazon.jsii.Kernel.get(this, "serverUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.chatterFeedConfiguration = software.amazon.jsii.Kernel.get(this, "chatterFeedConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.crawlAttachments = software.amazon.jsii.Kernel.get(this, "crawlAttachments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludeAttachmentFilePatterns = software.amazon.jsii.Kernel.get(this, "excludeAttachmentFilePatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.includeAttachmentFilePatterns = software.amazon.jsii.Kernel.get(this, "includeAttachmentFilePatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.knowledgeArticleConfiguration = software.amazon.jsii.Kernel.get(this, "knowledgeArticleConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.standardObjectAttachmentConfiguration = software.amazon.jsii.Kernel.get(this, "standardObjectAttachmentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.standardObjectConfigurations = software.amazon.jsii.Kernel.get(this, "standardObjectConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretArn = java.util.Objects.requireNonNull(builder.secretArn, "secretArn is required");
                this.serverUrl = java.util.Objects.requireNonNull(builder.serverUrl, "serverUrl is required");
                this.chatterFeedConfiguration = builder.chatterFeedConfiguration;
                this.crawlAttachments = builder.crawlAttachments;
                this.excludeAttachmentFilePatterns = builder.excludeAttachmentFilePatterns;
                this.includeAttachmentFilePatterns = builder.includeAttachmentFilePatterns;
                this.knowledgeArticleConfiguration = builder.knowledgeArticleConfiguration;
                this.standardObjectAttachmentConfiguration = builder.standardObjectAttachmentConfiguration;
                this.standardObjectConfigurations = builder.standardObjectConfigurations;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            public final java.lang.String getServerUrl() {
                return this.serverUrl;
            }

            @Override
            public final java.lang.Object getChatterFeedConfiguration() {
                return this.chatterFeedConfiguration;
            }

            @Override
            public final java.lang.Object getCrawlAttachments() {
                return this.crawlAttachments;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludeAttachmentFilePatterns() {
                return this.excludeAttachmentFilePatterns;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludeAttachmentFilePatterns() {
                return this.includeAttachmentFilePatterns;
            }

            @Override
            public final java.lang.Object getKnowledgeArticleConfiguration() {
                return this.knowledgeArticleConfiguration;
            }

            @Override
            public final java.lang.Object getStandardObjectAttachmentConfiguration() {
                return this.standardObjectAttachmentConfiguration;
            }

            @Override
            public final java.lang.Object getStandardObjectConfigurations() {
                return this.standardObjectConfigurations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("secretArn", om.valueToTree(this.getSecretArn()));
                data.set("serverUrl", om.valueToTree(this.getServerUrl()));
                if (this.getChatterFeedConfiguration() != null) {
                    data.set("chatterFeedConfiguration", om.valueToTree(this.getChatterFeedConfiguration()));
                }
                if (this.getCrawlAttachments() != null) {
                    data.set("crawlAttachments", om.valueToTree(this.getCrawlAttachments()));
                }
                if (this.getExcludeAttachmentFilePatterns() != null) {
                    data.set("excludeAttachmentFilePatterns", om.valueToTree(this.getExcludeAttachmentFilePatterns()));
                }
                if (this.getIncludeAttachmentFilePatterns() != null) {
                    data.set("includeAttachmentFilePatterns", om.valueToTree(this.getIncludeAttachmentFilePatterns()));
                }
                if (this.getKnowledgeArticleConfiguration() != null) {
                    data.set("knowledgeArticleConfiguration", om.valueToTree(this.getKnowledgeArticleConfiguration()));
                }
                if (this.getStandardObjectAttachmentConfiguration() != null) {
                    data.set("standardObjectAttachmentConfiguration", om.valueToTree(this.getStandardObjectAttachmentConfiguration()));
                }
                if (this.getStandardObjectConfigurations() != null) {
                    data.set("standardObjectConfigurations", om.valueToTree(this.getStandardObjectConfigurations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceConfigurationProperty.Jsii$Proxy that = (SalesforceConfigurationProperty.Jsii$Proxy) o;

                if (!secretArn.equals(that.secretArn)) return false;
                if (!serverUrl.equals(that.serverUrl)) return false;
                if (this.chatterFeedConfiguration != null ? !this.chatterFeedConfiguration.equals(that.chatterFeedConfiguration) : that.chatterFeedConfiguration != null) return false;
                if (this.crawlAttachments != null ? !this.crawlAttachments.equals(that.crawlAttachments) : that.crawlAttachments != null) return false;
                if (this.excludeAttachmentFilePatterns != null ? !this.excludeAttachmentFilePatterns.equals(that.excludeAttachmentFilePatterns) : that.excludeAttachmentFilePatterns != null) return false;
                if (this.includeAttachmentFilePatterns != null ? !this.includeAttachmentFilePatterns.equals(that.includeAttachmentFilePatterns) : that.includeAttachmentFilePatterns != null) return false;
                if (this.knowledgeArticleConfiguration != null ? !this.knowledgeArticleConfiguration.equals(that.knowledgeArticleConfiguration) : that.knowledgeArticleConfiguration != null) return false;
                if (this.standardObjectAttachmentConfiguration != null ? !this.standardObjectAttachmentConfiguration.equals(that.standardObjectAttachmentConfiguration) : that.standardObjectAttachmentConfiguration != null) return false;
                return this.standardObjectConfigurations != null ? this.standardObjectConfigurations.equals(that.standardObjectConfigurations) : that.standardObjectConfigurations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretArn.hashCode();
                result = 31 * result + (this.serverUrl.hashCode());
                result = 31 * result + (this.chatterFeedConfiguration != null ? this.chatterFeedConfiguration.hashCode() : 0);
                result = 31 * result + (this.crawlAttachments != null ? this.crawlAttachments.hashCode() : 0);
                result = 31 * result + (this.excludeAttachmentFilePatterns != null ? this.excludeAttachmentFilePatterns.hashCode() : 0);
                result = 31 * result + (this.includeAttachmentFilePatterns != null ? this.includeAttachmentFilePatterns.hashCode() : 0);
                result = 31 * result + (this.knowledgeArticleConfiguration != null ? this.knowledgeArticleConfiguration.hashCode() : 0);
                result = 31 * result + (this.standardObjectAttachmentConfiguration != null ? this.standardObjectAttachmentConfiguration.hashCode() : 0);
                result = 31 * result + (this.standardObjectConfigurations != null ? this.standardObjectConfigurations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information for indexing Salesforce custom articles.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * SalesforceCustomKnowledgeArticleTypeConfigurationProperty salesforceCustomKnowledgeArticleTypeConfigurationProperty = SalesforceCustomKnowledgeArticleTypeConfigurationProperty.builder()
     *         .documentDataFieldName("documentDataFieldName")
     *         .name("name")
     *         // the properties below are optional
     *         .documentTitleFieldName("documentTitleFieldName")
     *         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                 .dataSourceFieldName("dataSourceFieldName")
     *                 .indexFieldName("indexFieldName")
     *                 // the properties below are optional
     *                 .dateFieldFormat("dateFieldFormat")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceCustomKnowledgeArticleTypeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceCustomKnowledgeArticleTypeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field in the custom knowledge article that contains the document data to index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDocumentDataFieldName();

        /**
         * The name of the configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The name of the field in the custom knowledge article that contains the document title.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentTitleFieldName() {
            return null;
        }

        /**
         * Maps attributes or field names of the custom knowledge article to Amazon Kendra index field names.
         * <p>
         * To create custom fields, use the <code>UpdateIndex</code> API before you map to Salesforce fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Salesforce data source field names must exist in your Salesforce custom metadata.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFieldMappings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceCustomKnowledgeArticleTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceCustomKnowledgeArticleTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceCustomKnowledgeArticleTypeConfigurationProperty> {
            java.lang.String documentDataFieldName;
            java.lang.String name;
            java.lang.String documentTitleFieldName;
            java.lang.Object fieldMappings;

            /**
             * Sets the value of {@link SalesforceCustomKnowledgeArticleTypeConfigurationProperty#getDocumentDataFieldName}
             * @param documentDataFieldName The name of the field in the custom knowledge article that contains the document data to index. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentDataFieldName(java.lang.String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceCustomKnowledgeArticleTypeConfigurationProperty#getName}
             * @param name The name of the configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceCustomKnowledgeArticleTypeConfigurationProperty#getDocumentTitleFieldName}
             * @param documentTitleFieldName The name of the field in the custom knowledge article that contains the document title.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentTitleFieldName(java.lang.String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceCustomKnowledgeArticleTypeConfigurationProperty#getFieldMappings}
             * @param fieldMappings Maps attributes or field names of the custom knowledge article to Amazon Kendra index field names.
             *                      To create custom fields, use the <code>UpdateIndex</code> API before you map to Salesforce fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Salesforce data source field names must exist in your Salesforce custom metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(software.amazon.awscdk.IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceCustomKnowledgeArticleTypeConfigurationProperty#getFieldMappings}
             * @param fieldMappings Maps attributes or field names of the custom knowledge article to Amazon Kendra index field names.
             *                      To create custom fields, use the <code>UpdateIndex</code> API before you map to Salesforce fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Salesforce data source field names must exist in your Salesforce custom metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(java.util.List<? extends java.lang.Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceCustomKnowledgeArticleTypeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceCustomKnowledgeArticleTypeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceCustomKnowledgeArticleTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceCustomKnowledgeArticleTypeConfigurationProperty {
            private final java.lang.String documentDataFieldName;
            private final java.lang.String name;
            private final java.lang.String documentTitleFieldName;
            private final java.lang.Object fieldMappings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.documentDataFieldName = software.amazon.jsii.Kernel.get(this, "documentDataFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.documentTitleFieldName = software.amazon.jsii.Kernel.get(this, "documentTitleFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldMappings = software.amazon.jsii.Kernel.get(this, "fieldMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.documentDataFieldName = java.util.Objects.requireNonNull(builder.documentDataFieldName, "documentDataFieldName is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.documentTitleFieldName = builder.documentTitleFieldName;
                this.fieldMappings = builder.fieldMappings;
            }

            @Override
            public final java.lang.String getDocumentDataFieldName() {
                return this.documentDataFieldName;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getDocumentTitleFieldName() {
                return this.documentTitleFieldName;
            }

            @Override
            public final java.lang.Object getFieldMappings() {
                return this.fieldMappings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("documentDataFieldName", om.valueToTree(this.getDocumentDataFieldName()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getDocumentTitleFieldName() != null) {
                    data.set("documentTitleFieldName", om.valueToTree(this.getDocumentTitleFieldName()));
                }
                if (this.getFieldMappings() != null) {
                    data.set("fieldMappings", om.valueToTree(this.getFieldMappings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceCustomKnowledgeArticleTypeConfigurationProperty.Jsii$Proxy that = (SalesforceCustomKnowledgeArticleTypeConfigurationProperty.Jsii$Proxy) o;

                if (!documentDataFieldName.equals(that.documentDataFieldName)) return false;
                if (!name.equals(that.name)) return false;
                if (this.documentTitleFieldName != null ? !this.documentTitleFieldName.equals(that.documentTitleFieldName) : that.documentTitleFieldName != null) return false;
                return this.fieldMappings != null ? this.fieldMappings.equals(that.fieldMappings) : that.fieldMappings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.documentDataFieldName.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.documentTitleFieldName != null ? this.documentTitleFieldName.hashCode() : 0);
                result = 31 * result + (this.fieldMappings != null ? this.fieldMappings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information for the knowledge article types that Amazon Kendra indexes.
     * <p>
     * Amazon Kendra indexes standard knowledge articles and the standard fields of knowledge articles, or the custom fields of custom knowledge articles, but not both
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * SalesforceKnowledgeArticleConfigurationProperty salesforceKnowledgeArticleConfigurationProperty = SalesforceKnowledgeArticleConfigurationProperty.builder()
     *         .includedStates(List.of("includedStates"))
     *         // the properties below are optional
     *         .customKnowledgeArticleTypeConfigurations(List.of(SalesforceCustomKnowledgeArticleTypeConfigurationProperty.builder()
     *                 .documentDataFieldName("documentDataFieldName")
     *                 .name("name")
     *                 // the properties below are optional
     *                 .documentTitleFieldName("documentTitleFieldName")
     *                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                         .dataSourceFieldName("dataSourceFieldName")
     *                         .indexFieldName("indexFieldName")
     *                         // the properties below are optional
     *                         .dateFieldFormat("dateFieldFormat")
     *                         .build()))
     *                 .build()))
     *         .standardKnowledgeArticleTypeConfiguration(SalesforceStandardKnowledgeArticleTypeConfigurationProperty.builder()
     *                 .documentDataFieldName("documentDataFieldName")
     *                 // the properties below are optional
     *                 .documentTitleFieldName("documentTitleFieldName")
     *                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                         .dataSourceFieldName("dataSourceFieldName")
     *                         .indexFieldName("indexFieldName")
     *                         // the properties below are optional
     *                         .dateFieldFormat("dateFieldFormat")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceKnowledgeArticleConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceKnowledgeArticleConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceKnowledgeArticleConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the document states that should be included when Amazon Kendra indexes knowledge articles.
         * <p>
         * You must specify at least one state.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getIncludedStates();

        /**
         * Configuration information for custom Salesforce knowledge articles.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomKnowledgeArticleTypeConfigurations() {
            return null;
        }

        /**
         * Configuration information for standard Salesforce knowledge articles.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStandardKnowledgeArticleTypeConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceKnowledgeArticleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceKnowledgeArticleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceKnowledgeArticleConfigurationProperty> {
            java.util.List<java.lang.String> includedStates;
            java.lang.Object customKnowledgeArticleTypeConfigurations;
            java.lang.Object standardKnowledgeArticleTypeConfiguration;

            /**
             * Sets the value of {@link SalesforceKnowledgeArticleConfigurationProperty#getIncludedStates}
             * @param includedStates Specifies the document states that should be included when Amazon Kendra indexes knowledge articles. This parameter is required.
             *                       You must specify at least one state.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includedStates(java.util.List<java.lang.String> includedStates) {
                this.includedStates = includedStates;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceKnowledgeArticleConfigurationProperty#getCustomKnowledgeArticleTypeConfigurations}
             * @param customKnowledgeArticleTypeConfigurations Configuration information for custom Salesforce knowledge articles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customKnowledgeArticleTypeConfigurations(software.amazon.awscdk.IResolvable customKnowledgeArticleTypeConfigurations) {
                this.customKnowledgeArticleTypeConfigurations = customKnowledgeArticleTypeConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceKnowledgeArticleConfigurationProperty#getCustomKnowledgeArticleTypeConfigurations}
             * @param customKnowledgeArticleTypeConfigurations Configuration information for custom Salesforce knowledge articles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customKnowledgeArticleTypeConfigurations(java.util.List<? extends java.lang.Object> customKnowledgeArticleTypeConfigurations) {
                this.customKnowledgeArticleTypeConfigurations = customKnowledgeArticleTypeConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceKnowledgeArticleConfigurationProperty#getStandardKnowledgeArticleTypeConfiguration}
             * @param standardKnowledgeArticleTypeConfiguration Configuration information for standard Salesforce knowledge articles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder standardKnowledgeArticleTypeConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.SalesforceStandardKnowledgeArticleTypeConfigurationProperty standardKnowledgeArticleTypeConfiguration) {
                this.standardKnowledgeArticleTypeConfiguration = standardKnowledgeArticleTypeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceKnowledgeArticleConfigurationProperty#getStandardKnowledgeArticleTypeConfiguration}
             * @param standardKnowledgeArticleTypeConfiguration Configuration information for standard Salesforce knowledge articles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder standardKnowledgeArticleTypeConfiguration(software.amazon.awscdk.IResolvable standardKnowledgeArticleTypeConfiguration) {
                this.standardKnowledgeArticleTypeConfiguration = standardKnowledgeArticleTypeConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceKnowledgeArticleConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceKnowledgeArticleConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceKnowledgeArticleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceKnowledgeArticleConfigurationProperty {
            private final java.util.List<java.lang.String> includedStates;
            private final java.lang.Object customKnowledgeArticleTypeConfigurations;
            private final java.lang.Object standardKnowledgeArticleTypeConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.includedStates = software.amazon.jsii.Kernel.get(this, "includedStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.customKnowledgeArticleTypeConfigurations = software.amazon.jsii.Kernel.get(this, "customKnowledgeArticleTypeConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.standardKnowledgeArticleTypeConfiguration = software.amazon.jsii.Kernel.get(this, "standardKnowledgeArticleTypeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.includedStates = java.util.Objects.requireNonNull(builder.includedStates, "includedStates is required");
                this.customKnowledgeArticleTypeConfigurations = builder.customKnowledgeArticleTypeConfigurations;
                this.standardKnowledgeArticleTypeConfiguration = builder.standardKnowledgeArticleTypeConfiguration;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludedStates() {
                return this.includedStates;
            }

            @Override
            public final java.lang.Object getCustomKnowledgeArticleTypeConfigurations() {
                return this.customKnowledgeArticleTypeConfigurations;
            }

            @Override
            public final java.lang.Object getStandardKnowledgeArticleTypeConfiguration() {
                return this.standardKnowledgeArticleTypeConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("includedStates", om.valueToTree(this.getIncludedStates()));
                if (this.getCustomKnowledgeArticleTypeConfigurations() != null) {
                    data.set("customKnowledgeArticleTypeConfigurations", om.valueToTree(this.getCustomKnowledgeArticleTypeConfigurations()));
                }
                if (this.getStandardKnowledgeArticleTypeConfiguration() != null) {
                    data.set("standardKnowledgeArticleTypeConfiguration", om.valueToTree(this.getStandardKnowledgeArticleTypeConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceKnowledgeArticleConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceKnowledgeArticleConfigurationProperty.Jsii$Proxy that = (SalesforceKnowledgeArticleConfigurationProperty.Jsii$Proxy) o;

                if (!includedStates.equals(that.includedStates)) return false;
                if (this.customKnowledgeArticleTypeConfigurations != null ? !this.customKnowledgeArticleTypeConfigurations.equals(that.customKnowledgeArticleTypeConfigurations) : that.customKnowledgeArticleTypeConfigurations != null) return false;
                return this.standardKnowledgeArticleTypeConfiguration != null ? this.standardKnowledgeArticleTypeConfiguration.equals(that.standardKnowledgeArticleTypeConfiguration) : that.standardKnowledgeArticleTypeConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.includedStates.hashCode();
                result = 31 * result + (this.customKnowledgeArticleTypeConfigurations != null ? this.customKnowledgeArticleTypeConfigurations.hashCode() : 0);
                result = 31 * result + (this.standardKnowledgeArticleTypeConfiguration != null ? this.standardKnowledgeArticleTypeConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information for standard Salesforce knowledge articles.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * SalesforceStandardKnowledgeArticleTypeConfigurationProperty salesforceStandardKnowledgeArticleTypeConfigurationProperty = SalesforceStandardKnowledgeArticleTypeConfigurationProperty.builder()
     *         .documentDataFieldName("documentDataFieldName")
     *         // the properties below are optional
     *         .documentTitleFieldName("documentTitleFieldName")
     *         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                 .dataSourceFieldName("dataSourceFieldName")
     *                 .indexFieldName("indexFieldName")
     *                 // the properties below are optional
     *                 .dateFieldFormat("dateFieldFormat")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceStandardKnowledgeArticleTypeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceStandardKnowledgeArticleTypeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceStandardKnowledgeArticleTypeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field that contains the document data to index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDocumentDataFieldName();

        /**
         * The name of the field that contains the document title.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentTitleFieldName() {
            return null;
        }

        /**
         * Maps attributes or field names of the knowledge article to Amazon Kendra index field names.
         * <p>
         * To create custom fields, use the <code>UpdateIndex</code> API before you map to Salesforce fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Salesforce data source field names must exist in your Salesforce custom metadata.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFieldMappings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceStandardKnowledgeArticleTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceStandardKnowledgeArticleTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceStandardKnowledgeArticleTypeConfigurationProperty> {
            java.lang.String documentDataFieldName;
            java.lang.String documentTitleFieldName;
            java.lang.Object fieldMappings;

            /**
             * Sets the value of {@link SalesforceStandardKnowledgeArticleTypeConfigurationProperty#getDocumentDataFieldName}
             * @param documentDataFieldName The name of the field that contains the document data to index. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentDataFieldName(java.lang.String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceStandardKnowledgeArticleTypeConfigurationProperty#getDocumentTitleFieldName}
             * @param documentTitleFieldName The name of the field that contains the document title.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentTitleFieldName(java.lang.String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceStandardKnowledgeArticleTypeConfigurationProperty#getFieldMappings}
             * @param fieldMappings Maps attributes or field names of the knowledge article to Amazon Kendra index field names.
             *                      To create custom fields, use the <code>UpdateIndex</code> API before you map to Salesforce fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Salesforce data source field names must exist in your Salesforce custom metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(software.amazon.awscdk.IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceStandardKnowledgeArticleTypeConfigurationProperty#getFieldMappings}
             * @param fieldMappings Maps attributes or field names of the knowledge article to Amazon Kendra index field names.
             *                      To create custom fields, use the <code>UpdateIndex</code> API before you map to Salesforce fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Salesforce data source field names must exist in your Salesforce custom metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(java.util.List<? extends java.lang.Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceStandardKnowledgeArticleTypeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceStandardKnowledgeArticleTypeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceStandardKnowledgeArticleTypeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceStandardKnowledgeArticleTypeConfigurationProperty {
            private final java.lang.String documentDataFieldName;
            private final java.lang.String documentTitleFieldName;
            private final java.lang.Object fieldMappings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.documentDataFieldName = software.amazon.jsii.Kernel.get(this, "documentDataFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.documentTitleFieldName = software.amazon.jsii.Kernel.get(this, "documentTitleFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldMappings = software.amazon.jsii.Kernel.get(this, "fieldMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.documentDataFieldName = java.util.Objects.requireNonNull(builder.documentDataFieldName, "documentDataFieldName is required");
                this.documentTitleFieldName = builder.documentTitleFieldName;
                this.fieldMappings = builder.fieldMappings;
            }

            @Override
            public final java.lang.String getDocumentDataFieldName() {
                return this.documentDataFieldName;
            }

            @Override
            public final java.lang.String getDocumentTitleFieldName() {
                return this.documentTitleFieldName;
            }

            @Override
            public final java.lang.Object getFieldMappings() {
                return this.fieldMappings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("documentDataFieldName", om.valueToTree(this.getDocumentDataFieldName()));
                if (this.getDocumentTitleFieldName() != null) {
                    data.set("documentTitleFieldName", om.valueToTree(this.getDocumentTitleFieldName()));
                }
                if (this.getFieldMappings() != null) {
                    data.set("fieldMappings", om.valueToTree(this.getFieldMappings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceStandardKnowledgeArticleTypeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceStandardKnowledgeArticleTypeConfigurationProperty.Jsii$Proxy that = (SalesforceStandardKnowledgeArticleTypeConfigurationProperty.Jsii$Proxy) o;

                if (!documentDataFieldName.equals(that.documentDataFieldName)) return false;
                if (this.documentTitleFieldName != null ? !this.documentTitleFieldName.equals(that.documentTitleFieldName) : that.documentTitleFieldName != null) return false;
                return this.fieldMappings != null ? this.fieldMappings.equals(that.fieldMappings) : that.fieldMappings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.documentDataFieldName.hashCode();
                result = 31 * result + (this.documentTitleFieldName != null ? this.documentTitleFieldName.hashCode() : 0);
                result = 31 * result + (this.fieldMappings != null ? this.fieldMappings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information for processing attachments to Salesforce standard objects.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * SalesforceStandardObjectAttachmentConfigurationProperty salesforceStandardObjectAttachmentConfigurationProperty = SalesforceStandardObjectAttachmentConfigurationProperty.builder()
     *         .documentTitleFieldName("documentTitleFieldName")
     *         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                 .dataSourceFieldName("dataSourceFieldName")
     *                 .indexFieldName("indexFieldName")
     *                 // the properties below are optional
     *                 .dateFieldFormat("dateFieldFormat")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceStandardObjectAttachmentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceStandardObjectAttachmentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceStandardObjectAttachmentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field used for the document title.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentTitleFieldName() {
            return null;
        }

        /**
         * One or more objects that map fields in attachments to Amazon Kendra index fields.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFieldMappings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceStandardObjectAttachmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceStandardObjectAttachmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceStandardObjectAttachmentConfigurationProperty> {
            java.lang.String documentTitleFieldName;
            java.lang.Object fieldMappings;

            /**
             * Sets the value of {@link SalesforceStandardObjectAttachmentConfigurationProperty#getDocumentTitleFieldName}
             * @param documentTitleFieldName The name of the field used for the document title.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentTitleFieldName(java.lang.String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceStandardObjectAttachmentConfigurationProperty#getFieldMappings}
             * @param fieldMappings One or more objects that map fields in attachments to Amazon Kendra index fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(software.amazon.awscdk.IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceStandardObjectAttachmentConfigurationProperty#getFieldMappings}
             * @param fieldMappings One or more objects that map fields in attachments to Amazon Kendra index fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(java.util.List<? extends java.lang.Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceStandardObjectAttachmentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceStandardObjectAttachmentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceStandardObjectAttachmentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceStandardObjectAttachmentConfigurationProperty {
            private final java.lang.String documentTitleFieldName;
            private final java.lang.Object fieldMappings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.documentTitleFieldName = software.amazon.jsii.Kernel.get(this, "documentTitleFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldMappings = software.amazon.jsii.Kernel.get(this, "fieldMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.documentTitleFieldName = builder.documentTitleFieldName;
                this.fieldMappings = builder.fieldMappings;
            }

            @Override
            public final java.lang.String getDocumentTitleFieldName() {
                return this.documentTitleFieldName;
            }

            @Override
            public final java.lang.Object getFieldMappings() {
                return this.fieldMappings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDocumentTitleFieldName() != null) {
                    data.set("documentTitleFieldName", om.valueToTree(this.getDocumentTitleFieldName()));
                }
                if (this.getFieldMappings() != null) {
                    data.set("fieldMappings", om.valueToTree(this.getFieldMappings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceStandardObjectAttachmentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceStandardObjectAttachmentConfigurationProperty.Jsii$Proxy that = (SalesforceStandardObjectAttachmentConfigurationProperty.Jsii$Proxy) o;

                if (this.documentTitleFieldName != null ? !this.documentTitleFieldName.equals(that.documentTitleFieldName) : that.documentTitleFieldName != null) return false;
                return this.fieldMappings != null ? this.fieldMappings.equals(that.fieldMappings) : that.fieldMappings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.documentTitleFieldName != null ? this.documentTitleFieldName.hashCode() : 0;
                result = 31 * result + (this.fieldMappings != null ? this.fieldMappings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies configuration information for indexing a single standard object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * SalesforceStandardObjectConfigurationProperty salesforceStandardObjectConfigurationProperty = SalesforceStandardObjectConfigurationProperty.builder()
     *         .documentDataFieldName("documentDataFieldName")
     *         .name("name")
     *         // the properties below are optional
     *         .documentTitleFieldName("documentTitleFieldName")
     *         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                 .dataSourceFieldName("dataSourceFieldName")
     *                 .indexFieldName("indexFieldName")
     *                 // the properties below are optional
     *                 .dateFieldFormat("dateFieldFormat")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceStandardObjectConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceStandardObjectConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceStandardObjectConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field in the standard object table that contains the document contents.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDocumentDataFieldName();

        /**
         * The name of the standard object.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The name of the field in the standard object table that contains the document title.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentTitleFieldName() {
            return null;
        }

        /**
         * Maps attributes or field names of the standard object to Amazon Kendra index field names.
         * <p>
         * To create custom fields, use the <code>UpdateIndex</code> API before you map to Salesforce fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Salesforce data source field names must exist in your Salesforce custom metadata.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFieldMappings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceStandardObjectConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceStandardObjectConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceStandardObjectConfigurationProperty> {
            java.lang.String documentDataFieldName;
            java.lang.String name;
            java.lang.String documentTitleFieldName;
            java.lang.Object fieldMappings;

            /**
             * Sets the value of {@link SalesforceStandardObjectConfigurationProperty#getDocumentDataFieldName}
             * @param documentDataFieldName The name of the field in the standard object table that contains the document contents. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentDataFieldName(java.lang.String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceStandardObjectConfigurationProperty#getName}
             * @param name The name of the standard object. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceStandardObjectConfigurationProperty#getDocumentTitleFieldName}
             * @param documentTitleFieldName The name of the field in the standard object table that contains the document title.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentTitleFieldName(java.lang.String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceStandardObjectConfigurationProperty#getFieldMappings}
             * @param fieldMappings Maps attributes or field names of the standard object to Amazon Kendra index field names.
             *                      To create custom fields, use the <code>UpdateIndex</code> API before you map to Salesforce fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Salesforce data source field names must exist in your Salesforce custom metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(software.amazon.awscdk.IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceStandardObjectConfigurationProperty#getFieldMappings}
             * @param fieldMappings Maps attributes or field names of the standard object to Amazon Kendra index field names.
             *                      To create custom fields, use the <code>UpdateIndex</code> API before you map to Salesforce fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Salesforce data source field names must exist in your Salesforce custom metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(java.util.List<? extends java.lang.Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceStandardObjectConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceStandardObjectConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceStandardObjectConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceStandardObjectConfigurationProperty {
            private final java.lang.String documentDataFieldName;
            private final java.lang.String name;
            private final java.lang.String documentTitleFieldName;
            private final java.lang.Object fieldMappings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.documentDataFieldName = software.amazon.jsii.Kernel.get(this, "documentDataFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.documentTitleFieldName = software.amazon.jsii.Kernel.get(this, "documentTitleFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldMappings = software.amazon.jsii.Kernel.get(this, "fieldMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.documentDataFieldName = java.util.Objects.requireNonNull(builder.documentDataFieldName, "documentDataFieldName is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.documentTitleFieldName = builder.documentTitleFieldName;
                this.fieldMappings = builder.fieldMappings;
            }

            @Override
            public final java.lang.String getDocumentDataFieldName() {
                return this.documentDataFieldName;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getDocumentTitleFieldName() {
                return this.documentTitleFieldName;
            }

            @Override
            public final java.lang.Object getFieldMappings() {
                return this.fieldMappings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("documentDataFieldName", om.valueToTree(this.getDocumentDataFieldName()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getDocumentTitleFieldName() != null) {
                    data.set("documentTitleFieldName", om.valueToTree(this.getDocumentTitleFieldName()));
                }
                if (this.getFieldMappings() != null) {
                    data.set("fieldMappings", om.valueToTree(this.getFieldMappings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.SalesforceStandardObjectConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceStandardObjectConfigurationProperty.Jsii$Proxy that = (SalesforceStandardObjectConfigurationProperty.Jsii$Proxy) o;

                if (!documentDataFieldName.equals(that.documentDataFieldName)) return false;
                if (!name.equals(that.name)) return false;
                if (this.documentTitleFieldName != null ? !this.documentTitleFieldName.equals(that.documentTitleFieldName) : that.documentTitleFieldName != null) return false;
                return this.fieldMappings != null ? this.fieldMappings.equals(that.fieldMappings) : that.fieldMappings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.documentDataFieldName.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.documentTitleFieldName != null ? this.documentTitleFieldName.hashCode() : 0);
                result = 31 * result + (this.fieldMappings != null ? this.fieldMappings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information to connect to ServiceNow as your data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * ServiceNowConfigurationProperty serviceNowConfigurationProperty = ServiceNowConfigurationProperty.builder()
     *         .hostUrl("hostUrl")
     *         .secretArn("secretArn")
     *         .serviceNowBuildVersion("serviceNowBuildVersion")
     *         // the properties below are optional
     *         .authenticationType("authenticationType")
     *         .knowledgeArticleConfiguration(ServiceNowKnowledgeArticleConfigurationProperty.builder()
     *                 .documentDataFieldName("documentDataFieldName")
     *                 // the properties below are optional
     *                 .crawlAttachments(false)
     *                 .documentTitleFieldName("documentTitleFieldName")
     *                 .excludeAttachmentFilePatterns(List.of("excludeAttachmentFilePatterns"))
     *                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                         .dataSourceFieldName("dataSourceFieldName")
     *                         .indexFieldName("indexFieldName")
     *                         // the properties below are optional
     *                         .dateFieldFormat("dateFieldFormat")
     *                         .build()))
     *                 .filterQuery("filterQuery")
     *                 .includeAttachmentFilePatterns(List.of("includeAttachmentFilePatterns"))
     *                 .build())
     *         .serviceCatalogConfiguration(ServiceNowServiceCatalogConfigurationProperty.builder()
     *                 .documentDataFieldName("documentDataFieldName")
     *                 // the properties below are optional
     *                 .crawlAttachments(false)
     *                 .documentTitleFieldName("documentTitleFieldName")
     *                 .excludeAttachmentFilePatterns(List.of("excludeAttachmentFilePatterns"))
     *                 .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                         .dataSourceFieldName("dataSourceFieldName")
     *                         .indexFieldName("indexFieldName")
     *                         // the properties below are optional
     *                         .dateFieldFormat("dateFieldFormat")
     *                         .build()))
     *                 .includeAttachmentFilePatterns(List.of("includeAttachmentFilePatterns"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.ServiceNowConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceNowConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceNowConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ServiceNow instance that the data source connects to.
         * <p>
         * The host endpoint should look like the following: <em>{instance}.service-now.com.</em>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHostUrl();

        /**
         * The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the user name and password required to connect to the ServiceNow instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretArn();

        /**
         * The identifier of the release that the ServiceNow host is running.
         * <p>
         * If the host is not running the <code>LONDON</code> release, use <code>OTHERS</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServiceNowBuildVersion();

        /**
         * The type of authentication used to connect to the ServiceNow instance.
         * <p>
         * If you choose <code>HTTP_BASIC</code> , Amazon Kendra is authenticated using the user name and password provided in the AWS Secrets Manager secret in the <code>SecretArn</code> field. When you choose <code>OAUTH2</code> , Amazon Kendra is authenticated using the OAuth token and secret provided in the Secrets Manager secret, and the user name and password are used to determine which information Amazon Kendra has access to.
         * <p>
         * When you use <code>OAUTH2</code> authentication, you must generate a token and a client secret using the ServiceNow console. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html">Using a ServiceNow data source</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthenticationType() {
            return null;
        }

        /**
         * Configuration information for crawling knowledge articles in the ServiceNow site.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKnowledgeArticleConfiguration() {
            return null;
        }

        /**
         * Configuration information for crawling service catalogs in the ServiceNow site.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServiceCatalogConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceNowConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceNowConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceNowConfigurationProperty> {
            java.lang.String hostUrl;
            java.lang.String secretArn;
            java.lang.String serviceNowBuildVersion;
            java.lang.String authenticationType;
            java.lang.Object knowledgeArticleConfiguration;
            java.lang.Object serviceCatalogConfiguration;

            /**
             * Sets the value of {@link ServiceNowConfigurationProperty#getHostUrl}
             * @param hostUrl The ServiceNow instance that the data source connects to. This parameter is required.
             *                The host endpoint should look like the following: <em>{instance}.service-now.com.</em>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostUrl(java.lang.String hostUrl) {
                this.hostUrl = hostUrl;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowConfigurationProperty#getSecretArn}
             * @param secretArn The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the user name and password required to connect to the ServiceNow instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowConfigurationProperty#getServiceNowBuildVersion}
             * @param serviceNowBuildVersion The identifier of the release that the ServiceNow host is running. This parameter is required.
             *                               If the host is not running the <code>LONDON</code> release, use <code>OTHERS</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNowBuildVersion(java.lang.String serviceNowBuildVersion) {
                this.serviceNowBuildVersion = serviceNowBuildVersion;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowConfigurationProperty#getAuthenticationType}
             * @param authenticationType The type of authentication used to connect to the ServiceNow instance.
             *                           If you choose <code>HTTP_BASIC</code> , Amazon Kendra is authenticated using the user name and password provided in the AWS Secrets Manager secret in the <code>SecretArn</code> field. When you choose <code>OAUTH2</code> , Amazon Kendra is authenticated using the OAuth token and secret provided in the Secrets Manager secret, and the user name and password are used to determine which information Amazon Kendra has access to.
             *                           <p>
             *                           When you use <code>OAUTH2</code> authentication, you must generate a token and a client secret using the ServiceNow console. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html">Using a ServiceNow data source</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationType(java.lang.String authenticationType) {
                this.authenticationType = authenticationType;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowConfigurationProperty#getKnowledgeArticleConfiguration}
             * @param knowledgeArticleConfiguration Configuration information for crawling knowledge articles in the ServiceNow site.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder knowledgeArticleConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty knowledgeArticleConfiguration) {
                this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowConfigurationProperty#getKnowledgeArticleConfiguration}
             * @param knowledgeArticleConfiguration Configuration information for crawling knowledge articles in the ServiceNow site.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder knowledgeArticleConfiguration(software.amazon.awscdk.IResolvable knowledgeArticleConfiguration) {
                this.knowledgeArticleConfiguration = knowledgeArticleConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowConfigurationProperty#getServiceCatalogConfiguration}
             * @param serviceCatalogConfiguration Configuration information for crawling service catalogs in the ServiceNow site.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceCatalogConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.ServiceNowServiceCatalogConfigurationProperty serviceCatalogConfiguration) {
                this.serviceCatalogConfiguration = serviceCatalogConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowConfigurationProperty#getServiceCatalogConfiguration}
             * @param serviceCatalogConfiguration Configuration information for crawling service catalogs in the ServiceNow site.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceCatalogConfiguration(software.amazon.awscdk.IResolvable serviceCatalogConfiguration) {
                this.serviceCatalogConfiguration = serviceCatalogConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceNowConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceNowConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceNowConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceNowConfigurationProperty {
            private final java.lang.String hostUrl;
            private final java.lang.String secretArn;
            private final java.lang.String serviceNowBuildVersion;
            private final java.lang.String authenticationType;
            private final java.lang.Object knowledgeArticleConfiguration;
            private final java.lang.Object serviceCatalogConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hostUrl = software.amazon.jsii.Kernel.get(this, "hostUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceNowBuildVersion = software.amazon.jsii.Kernel.get(this, "serviceNowBuildVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.knowledgeArticleConfiguration = software.amazon.jsii.Kernel.get(this, "knowledgeArticleConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceCatalogConfiguration = software.amazon.jsii.Kernel.get(this, "serviceCatalogConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hostUrl = java.util.Objects.requireNonNull(builder.hostUrl, "hostUrl is required");
                this.secretArn = java.util.Objects.requireNonNull(builder.secretArn, "secretArn is required");
                this.serviceNowBuildVersion = java.util.Objects.requireNonNull(builder.serviceNowBuildVersion, "serviceNowBuildVersion is required");
                this.authenticationType = builder.authenticationType;
                this.knowledgeArticleConfiguration = builder.knowledgeArticleConfiguration;
                this.serviceCatalogConfiguration = builder.serviceCatalogConfiguration;
            }

            @Override
            public final java.lang.String getHostUrl() {
                return this.hostUrl;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            public final java.lang.String getServiceNowBuildVersion() {
                return this.serviceNowBuildVersion;
            }

            @Override
            public final java.lang.String getAuthenticationType() {
                return this.authenticationType;
            }

            @Override
            public final java.lang.Object getKnowledgeArticleConfiguration() {
                return this.knowledgeArticleConfiguration;
            }

            @Override
            public final java.lang.Object getServiceCatalogConfiguration() {
                return this.serviceCatalogConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hostUrl", om.valueToTree(this.getHostUrl()));
                data.set("secretArn", om.valueToTree(this.getSecretArn()));
                data.set("serviceNowBuildVersion", om.valueToTree(this.getServiceNowBuildVersion()));
                if (this.getAuthenticationType() != null) {
                    data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
                }
                if (this.getKnowledgeArticleConfiguration() != null) {
                    data.set("knowledgeArticleConfiguration", om.valueToTree(this.getKnowledgeArticleConfiguration()));
                }
                if (this.getServiceCatalogConfiguration() != null) {
                    data.set("serviceCatalogConfiguration", om.valueToTree(this.getServiceCatalogConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.ServiceNowConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceNowConfigurationProperty.Jsii$Proxy that = (ServiceNowConfigurationProperty.Jsii$Proxy) o;

                if (!hostUrl.equals(that.hostUrl)) return false;
                if (!secretArn.equals(that.secretArn)) return false;
                if (!serviceNowBuildVersion.equals(that.serviceNowBuildVersion)) return false;
                if (this.authenticationType != null ? !this.authenticationType.equals(that.authenticationType) : that.authenticationType != null) return false;
                if (this.knowledgeArticleConfiguration != null ? !this.knowledgeArticleConfiguration.equals(that.knowledgeArticleConfiguration) : that.knowledgeArticleConfiguration != null) return false;
                return this.serviceCatalogConfiguration != null ? this.serviceCatalogConfiguration.equals(that.serviceCatalogConfiguration) : that.serviceCatalogConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hostUrl.hashCode();
                result = 31 * result + (this.secretArn.hashCode());
                result = 31 * result + (this.serviceNowBuildVersion.hashCode());
                result = 31 * result + (this.authenticationType != null ? this.authenticationType.hashCode() : 0);
                result = 31 * result + (this.knowledgeArticleConfiguration != null ? this.knowledgeArticleConfiguration.hashCode() : 0);
                result = 31 * result + (this.serviceCatalogConfiguration != null ? this.serviceCatalogConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information for crawling knowledge articles in the ServiceNow site.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * ServiceNowKnowledgeArticleConfigurationProperty serviceNowKnowledgeArticleConfigurationProperty = ServiceNowKnowledgeArticleConfigurationProperty.builder()
     *         .documentDataFieldName("documentDataFieldName")
     *         // the properties below are optional
     *         .crawlAttachments(false)
     *         .documentTitleFieldName("documentTitleFieldName")
     *         .excludeAttachmentFilePatterns(List.of("excludeAttachmentFilePatterns"))
     *         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                 .dataSourceFieldName("dataSourceFieldName")
     *                 .indexFieldName("indexFieldName")
     *                 // the properties below are optional
     *                 .dateFieldFormat("dateFieldFormat")
     *                 .build()))
     *         .filterQuery("filterQuery")
     *         .includeAttachmentFilePatterns(List.of("includeAttachmentFilePatterns"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceNowKnowledgeArticleConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceNowKnowledgeArticleConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDocumentDataFieldName();

        /**
         * Indicates whether Amazon Kendra should index attachments to knowledge articles.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrawlAttachments() {
            return null;
        }

        /**
         * The name of the ServiceNow field that is mapped to the index document title field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentTitleFieldName() {
            return null;
        }

        /**
         * A list of regular expression patterns to exclude certain attachments of knowledge articles in your ServiceNow.
         * <p>
         * Item that match the patterns are excluded from the index. Items that don't match the patterns are included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't included in the index.
         * <p>
         * The regex is applied to the field specified in the <code>PatternTargetField</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludeAttachmentFilePatterns() {
            return null;
        }

        /**
         * Maps attributes or field names of knoweldge articles to Amazon Kendra index field names.
         * <p>
         * To create custom fields, use the <code>UpdateIndex</code> API before you map to ServiceNow fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The ServiceNow data source field names must exist in your ServiceNow custom metadata.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFieldMappings() {
            return null;
        }

        /**
         * A query that selects the knowledge articles to index.
         * <p>
         * The query can return articles from multiple knowledge bases, and the knowledge bases can be public or private.
         * <p>
         * The query string must be one generated by the ServiceNow console. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html">Specifying documents to index with a query</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFilterQuery() {
            return null;
        }

        /**
         * A list of regular expression patterns to include certain attachments of knowledge articles in your ServiceNow.
         * <p>
         * Item that match the patterns are included in the index. Items that don't match the patterns are excluded from the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't included in the index.
         * <p>
         * The regex is applied to the field specified in the <code>PatternTargetField</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludeAttachmentFilePatterns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceNowKnowledgeArticleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceNowKnowledgeArticleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceNowKnowledgeArticleConfigurationProperty> {
            java.lang.String documentDataFieldName;
            java.lang.Object crawlAttachments;
            java.lang.String documentTitleFieldName;
            java.util.List<java.lang.String> excludeAttachmentFilePatterns;
            java.lang.Object fieldMappings;
            java.lang.String filterQuery;
            java.util.List<java.lang.String> includeAttachmentFilePatterns;

            /**
             * Sets the value of {@link ServiceNowKnowledgeArticleConfigurationProperty#getDocumentDataFieldName}
             * @param documentDataFieldName The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra index. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentDataFieldName(java.lang.String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowKnowledgeArticleConfigurationProperty#getCrawlAttachments}
             * @param crawlAttachments Indicates whether Amazon Kendra should index attachments to knowledge articles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlAttachments(java.lang.Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowKnowledgeArticleConfigurationProperty#getCrawlAttachments}
             * @param crawlAttachments Indicates whether Amazon Kendra should index attachments to knowledge articles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlAttachments(software.amazon.awscdk.IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowKnowledgeArticleConfigurationProperty#getDocumentTitleFieldName}
             * @param documentTitleFieldName The name of the ServiceNow field that is mapped to the index document title field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentTitleFieldName(java.lang.String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowKnowledgeArticleConfigurationProperty#getExcludeAttachmentFilePatterns}
             * @param excludeAttachmentFilePatterns A list of regular expression patterns to exclude certain attachments of knowledge articles in your ServiceNow.
             *                                      Item that match the patterns are excluded from the index. Items that don't match the patterns are included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't included in the index.
             *                                      <p>
             *                                      The regex is applied to the field specified in the <code>PatternTargetField</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeAttachmentFilePatterns(java.util.List<java.lang.String> excludeAttachmentFilePatterns) {
                this.excludeAttachmentFilePatterns = excludeAttachmentFilePatterns;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowKnowledgeArticleConfigurationProperty#getFieldMappings}
             * @param fieldMappings Maps attributes or field names of knoweldge articles to Amazon Kendra index field names.
             *                      To create custom fields, use the <code>UpdateIndex</code> API before you map to ServiceNow fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The ServiceNow data source field names must exist in your ServiceNow custom metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(software.amazon.awscdk.IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowKnowledgeArticleConfigurationProperty#getFieldMappings}
             * @param fieldMappings Maps attributes or field names of knoweldge articles to Amazon Kendra index field names.
             *                      To create custom fields, use the <code>UpdateIndex</code> API before you map to ServiceNow fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The ServiceNow data source field names must exist in your ServiceNow custom metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(java.util.List<? extends java.lang.Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowKnowledgeArticleConfigurationProperty#getFilterQuery}
             * @param filterQuery A query that selects the knowledge articles to index.
             *                    The query can return articles from multiple knowledge bases, and the knowledge bases can be public or private.
             *                    <p>
             *                    The query string must be one generated by the ServiceNow console. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html">Specifying documents to index with a query</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterQuery(java.lang.String filterQuery) {
                this.filterQuery = filterQuery;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowKnowledgeArticleConfigurationProperty#getIncludeAttachmentFilePatterns}
             * @param includeAttachmentFilePatterns A list of regular expression patterns to include certain attachments of knowledge articles in your ServiceNow.
             *                                      Item that match the patterns are included in the index. Items that don't match the patterns are excluded from the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't included in the index.
             *                                      <p>
             *                                      The regex is applied to the field specified in the <code>PatternTargetField</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeAttachmentFilePatterns(java.util.List<java.lang.String> includeAttachmentFilePatterns) {
                this.includeAttachmentFilePatterns = includeAttachmentFilePatterns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceNowKnowledgeArticleConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceNowKnowledgeArticleConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceNowKnowledgeArticleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceNowKnowledgeArticleConfigurationProperty {
            private final java.lang.String documentDataFieldName;
            private final java.lang.Object crawlAttachments;
            private final java.lang.String documentTitleFieldName;
            private final java.util.List<java.lang.String> excludeAttachmentFilePatterns;
            private final java.lang.Object fieldMappings;
            private final java.lang.String filterQuery;
            private final java.util.List<java.lang.String> includeAttachmentFilePatterns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.documentDataFieldName = software.amazon.jsii.Kernel.get(this, "documentDataFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.crawlAttachments = software.amazon.jsii.Kernel.get(this, "crawlAttachments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.documentTitleFieldName = software.amazon.jsii.Kernel.get(this, "documentTitleFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.excludeAttachmentFilePatterns = software.amazon.jsii.Kernel.get(this, "excludeAttachmentFilePatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.fieldMappings = software.amazon.jsii.Kernel.get(this, "fieldMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filterQuery = software.amazon.jsii.Kernel.get(this, "filterQuery", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeAttachmentFilePatterns = software.amazon.jsii.Kernel.get(this, "includeAttachmentFilePatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.documentDataFieldName = java.util.Objects.requireNonNull(builder.documentDataFieldName, "documentDataFieldName is required");
                this.crawlAttachments = builder.crawlAttachments;
                this.documentTitleFieldName = builder.documentTitleFieldName;
                this.excludeAttachmentFilePatterns = builder.excludeAttachmentFilePatterns;
                this.fieldMappings = builder.fieldMappings;
                this.filterQuery = builder.filterQuery;
                this.includeAttachmentFilePatterns = builder.includeAttachmentFilePatterns;
            }

            @Override
            public final java.lang.String getDocumentDataFieldName() {
                return this.documentDataFieldName;
            }

            @Override
            public final java.lang.Object getCrawlAttachments() {
                return this.crawlAttachments;
            }

            @Override
            public final java.lang.String getDocumentTitleFieldName() {
                return this.documentTitleFieldName;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludeAttachmentFilePatterns() {
                return this.excludeAttachmentFilePatterns;
            }

            @Override
            public final java.lang.Object getFieldMappings() {
                return this.fieldMappings;
            }

            @Override
            public final java.lang.String getFilterQuery() {
                return this.filterQuery;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludeAttachmentFilePatterns() {
                return this.includeAttachmentFilePatterns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("documentDataFieldName", om.valueToTree(this.getDocumentDataFieldName()));
                if (this.getCrawlAttachments() != null) {
                    data.set("crawlAttachments", om.valueToTree(this.getCrawlAttachments()));
                }
                if (this.getDocumentTitleFieldName() != null) {
                    data.set("documentTitleFieldName", om.valueToTree(this.getDocumentTitleFieldName()));
                }
                if (this.getExcludeAttachmentFilePatterns() != null) {
                    data.set("excludeAttachmentFilePatterns", om.valueToTree(this.getExcludeAttachmentFilePatterns()));
                }
                if (this.getFieldMappings() != null) {
                    data.set("fieldMappings", om.valueToTree(this.getFieldMappings()));
                }
                if (this.getFilterQuery() != null) {
                    data.set("filterQuery", om.valueToTree(this.getFilterQuery()));
                }
                if (this.getIncludeAttachmentFilePatterns() != null) {
                    data.set("includeAttachmentFilePatterns", om.valueToTree(this.getIncludeAttachmentFilePatterns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceNowKnowledgeArticleConfigurationProperty.Jsii$Proxy that = (ServiceNowKnowledgeArticleConfigurationProperty.Jsii$Proxy) o;

                if (!documentDataFieldName.equals(that.documentDataFieldName)) return false;
                if (this.crawlAttachments != null ? !this.crawlAttachments.equals(that.crawlAttachments) : that.crawlAttachments != null) return false;
                if (this.documentTitleFieldName != null ? !this.documentTitleFieldName.equals(that.documentTitleFieldName) : that.documentTitleFieldName != null) return false;
                if (this.excludeAttachmentFilePatterns != null ? !this.excludeAttachmentFilePatterns.equals(that.excludeAttachmentFilePatterns) : that.excludeAttachmentFilePatterns != null) return false;
                if (this.fieldMappings != null ? !this.fieldMappings.equals(that.fieldMappings) : that.fieldMappings != null) return false;
                if (this.filterQuery != null ? !this.filterQuery.equals(that.filterQuery) : that.filterQuery != null) return false;
                return this.includeAttachmentFilePatterns != null ? this.includeAttachmentFilePatterns.equals(that.includeAttachmentFilePatterns) : that.includeAttachmentFilePatterns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.documentDataFieldName.hashCode();
                result = 31 * result + (this.crawlAttachments != null ? this.crawlAttachments.hashCode() : 0);
                result = 31 * result + (this.documentTitleFieldName != null ? this.documentTitleFieldName.hashCode() : 0);
                result = 31 * result + (this.excludeAttachmentFilePatterns != null ? this.excludeAttachmentFilePatterns.hashCode() : 0);
                result = 31 * result + (this.fieldMappings != null ? this.fieldMappings.hashCode() : 0);
                result = 31 * result + (this.filterQuery != null ? this.filterQuery.hashCode() : 0);
                result = 31 * result + (this.includeAttachmentFilePatterns != null ? this.includeAttachmentFilePatterns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information for crawling service catalog items in the ServiceNow site.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * ServiceNowServiceCatalogConfigurationProperty serviceNowServiceCatalogConfigurationProperty = ServiceNowServiceCatalogConfigurationProperty.builder()
     *         .documentDataFieldName("documentDataFieldName")
     *         // the properties below are optional
     *         .crawlAttachments(false)
     *         .documentTitleFieldName("documentTitleFieldName")
     *         .excludeAttachmentFilePatterns(List.of("excludeAttachmentFilePatterns"))
     *         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                 .dataSourceFieldName("dataSourceFieldName")
     *                 .indexFieldName("indexFieldName")
     *                 // the properties below are optional
     *                 .dateFieldFormat("dateFieldFormat")
     *                 .build()))
     *         .includeAttachmentFilePatterns(List.of("includeAttachmentFilePatterns"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.ServiceNowServiceCatalogConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceNowServiceCatalogConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceNowServiceCatalogConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDocumentDataFieldName();

        /**
         * Indicates whether Amazon Kendra should crawl attachments to the service catalog items.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrawlAttachments() {
            return null;
        }

        /**
         * The name of the ServiceNow field that is mapped to the index document title field.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentTitleFieldName() {
            return null;
        }

        /**
         * A list of regular expression patterns to exclude certain attachments of catalogs in your ServiceNow.
         * <p>
         * Item that match the patterns are excluded from the index. Items that don't match the patterns are included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't included in the index.
         * <p>
         * The regex is applied to the file name of the attachment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludeAttachmentFilePatterns() {
            return null;
        }

        /**
         * Maps attributes or field names of catalogs to Amazon Kendra index field names.
         * <p>
         * To create custom fields, use the <code>UpdateIndex</code> API before you map to ServiceNow fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The ServiceNow data source field names must exist in your ServiceNow custom metadata.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFieldMappings() {
            return null;
        }

        /**
         * A list of regular expression patterns to include certain attachments of catalogs in your ServiceNow.
         * <p>
         * Item that match the patterns are included in the index. Items that don't match the patterns are excluded from the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't included in the index.
         * <p>
         * The regex is applied to the file name of the attachment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludeAttachmentFilePatterns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceNowServiceCatalogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceNowServiceCatalogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceNowServiceCatalogConfigurationProperty> {
            java.lang.String documentDataFieldName;
            java.lang.Object crawlAttachments;
            java.lang.String documentTitleFieldName;
            java.util.List<java.lang.String> excludeAttachmentFilePatterns;
            java.lang.Object fieldMappings;
            java.util.List<java.lang.String> includeAttachmentFilePatterns;

            /**
             * Sets the value of {@link ServiceNowServiceCatalogConfigurationProperty#getDocumentDataFieldName}
             * @param documentDataFieldName The name of the ServiceNow field that is mapped to the index document contents field in the Amazon Kendra index. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentDataFieldName(java.lang.String documentDataFieldName) {
                this.documentDataFieldName = documentDataFieldName;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowServiceCatalogConfigurationProperty#getCrawlAttachments}
             * @param crawlAttachments Indicates whether Amazon Kendra should crawl attachments to the service catalog items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlAttachments(java.lang.Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowServiceCatalogConfigurationProperty#getCrawlAttachments}
             * @param crawlAttachments Indicates whether Amazon Kendra should crawl attachments to the service catalog items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlAttachments(software.amazon.awscdk.IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowServiceCatalogConfigurationProperty#getDocumentTitleFieldName}
             * @param documentTitleFieldName The name of the ServiceNow field that is mapped to the index document title field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentTitleFieldName(java.lang.String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowServiceCatalogConfigurationProperty#getExcludeAttachmentFilePatterns}
             * @param excludeAttachmentFilePatterns A list of regular expression patterns to exclude certain attachments of catalogs in your ServiceNow.
             *                                      Item that match the patterns are excluded from the index. Items that don't match the patterns are included in the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't included in the index.
             *                                      <p>
             *                                      The regex is applied to the file name of the attachment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeAttachmentFilePatterns(java.util.List<java.lang.String> excludeAttachmentFilePatterns) {
                this.excludeAttachmentFilePatterns = excludeAttachmentFilePatterns;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowServiceCatalogConfigurationProperty#getFieldMappings}
             * @param fieldMappings Maps attributes or field names of catalogs to Amazon Kendra index field names.
             *                      To create custom fields, use the <code>UpdateIndex</code> API before you map to ServiceNow fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The ServiceNow data source field names must exist in your ServiceNow custom metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(software.amazon.awscdk.IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowServiceCatalogConfigurationProperty#getFieldMappings}
             * @param fieldMappings Maps attributes or field names of catalogs to Amazon Kendra index field names.
             *                      To create custom fields, use the <code>UpdateIndex</code> API before you map to ServiceNow fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The ServiceNow data source field names must exist in your ServiceNow custom metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(java.util.List<? extends java.lang.Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowServiceCatalogConfigurationProperty#getIncludeAttachmentFilePatterns}
             * @param includeAttachmentFilePatterns A list of regular expression patterns to include certain attachments of catalogs in your ServiceNow.
             *                                      Item that match the patterns are included in the index. Items that don't match the patterns are excluded from the index. If an item matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the item isn't included in the index.
             *                                      <p>
             *                                      The regex is applied to the file name of the attachment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeAttachmentFilePatterns(java.util.List<java.lang.String> includeAttachmentFilePatterns) {
                this.includeAttachmentFilePatterns = includeAttachmentFilePatterns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceNowServiceCatalogConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceNowServiceCatalogConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceNowServiceCatalogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceNowServiceCatalogConfigurationProperty {
            private final java.lang.String documentDataFieldName;
            private final java.lang.Object crawlAttachments;
            private final java.lang.String documentTitleFieldName;
            private final java.util.List<java.lang.String> excludeAttachmentFilePatterns;
            private final java.lang.Object fieldMappings;
            private final java.util.List<java.lang.String> includeAttachmentFilePatterns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.documentDataFieldName = software.amazon.jsii.Kernel.get(this, "documentDataFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.crawlAttachments = software.amazon.jsii.Kernel.get(this, "crawlAttachments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.documentTitleFieldName = software.amazon.jsii.Kernel.get(this, "documentTitleFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.excludeAttachmentFilePatterns = software.amazon.jsii.Kernel.get(this, "excludeAttachmentFilePatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.fieldMappings = software.amazon.jsii.Kernel.get(this, "fieldMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeAttachmentFilePatterns = software.amazon.jsii.Kernel.get(this, "includeAttachmentFilePatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.documentDataFieldName = java.util.Objects.requireNonNull(builder.documentDataFieldName, "documentDataFieldName is required");
                this.crawlAttachments = builder.crawlAttachments;
                this.documentTitleFieldName = builder.documentTitleFieldName;
                this.excludeAttachmentFilePatterns = builder.excludeAttachmentFilePatterns;
                this.fieldMappings = builder.fieldMappings;
                this.includeAttachmentFilePatterns = builder.includeAttachmentFilePatterns;
            }

            @Override
            public final java.lang.String getDocumentDataFieldName() {
                return this.documentDataFieldName;
            }

            @Override
            public final java.lang.Object getCrawlAttachments() {
                return this.crawlAttachments;
            }

            @Override
            public final java.lang.String getDocumentTitleFieldName() {
                return this.documentTitleFieldName;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludeAttachmentFilePatterns() {
                return this.excludeAttachmentFilePatterns;
            }

            @Override
            public final java.lang.Object getFieldMappings() {
                return this.fieldMappings;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludeAttachmentFilePatterns() {
                return this.includeAttachmentFilePatterns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("documentDataFieldName", om.valueToTree(this.getDocumentDataFieldName()));
                if (this.getCrawlAttachments() != null) {
                    data.set("crawlAttachments", om.valueToTree(this.getCrawlAttachments()));
                }
                if (this.getDocumentTitleFieldName() != null) {
                    data.set("documentTitleFieldName", om.valueToTree(this.getDocumentTitleFieldName()));
                }
                if (this.getExcludeAttachmentFilePatterns() != null) {
                    data.set("excludeAttachmentFilePatterns", om.valueToTree(this.getExcludeAttachmentFilePatterns()));
                }
                if (this.getFieldMappings() != null) {
                    data.set("fieldMappings", om.valueToTree(this.getFieldMappings()));
                }
                if (this.getIncludeAttachmentFilePatterns() != null) {
                    data.set("includeAttachmentFilePatterns", om.valueToTree(this.getIncludeAttachmentFilePatterns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.ServiceNowServiceCatalogConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceNowServiceCatalogConfigurationProperty.Jsii$Proxy that = (ServiceNowServiceCatalogConfigurationProperty.Jsii$Proxy) o;

                if (!documentDataFieldName.equals(that.documentDataFieldName)) return false;
                if (this.crawlAttachments != null ? !this.crawlAttachments.equals(that.crawlAttachments) : that.crawlAttachments != null) return false;
                if (this.documentTitleFieldName != null ? !this.documentTitleFieldName.equals(that.documentTitleFieldName) : that.documentTitleFieldName != null) return false;
                if (this.excludeAttachmentFilePatterns != null ? !this.excludeAttachmentFilePatterns.equals(that.excludeAttachmentFilePatterns) : that.excludeAttachmentFilePatterns != null) return false;
                if (this.fieldMappings != null ? !this.fieldMappings.equals(that.fieldMappings) : that.fieldMappings != null) return false;
                return this.includeAttachmentFilePatterns != null ? this.includeAttachmentFilePatterns.equals(that.includeAttachmentFilePatterns) : that.includeAttachmentFilePatterns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.documentDataFieldName.hashCode();
                result = 31 * result + (this.crawlAttachments != null ? this.crawlAttachments.hashCode() : 0);
                result = 31 * result + (this.documentTitleFieldName != null ? this.documentTitleFieldName.hashCode() : 0);
                result = 31 * result + (this.excludeAttachmentFilePatterns != null ? this.excludeAttachmentFilePatterns.hashCode() : 0);
                result = 31 * result + (this.fieldMappings != null ? this.fieldMappings.hashCode() : 0);
                result = 31 * result + (this.includeAttachmentFilePatterns != null ? this.includeAttachmentFilePatterns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information to connect to Microsoft SharePoint as your data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * SharePointConfigurationProperty sharePointConfigurationProperty = SharePointConfigurationProperty.builder()
     *         .secretArn("secretArn")
     *         .sharePointVersion("sharePointVersion")
     *         .urls(List.of("urls"))
     *         // the properties below are optional
     *         .crawlAttachments(false)
     *         .disableLocalGroups(false)
     *         .documentTitleFieldName("documentTitleFieldName")
     *         .exclusionPatterns(List.of("exclusionPatterns"))
     *         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                 .dataSourceFieldName("dataSourceFieldName")
     *                 .indexFieldName("indexFieldName")
     *                 // the properties below are optional
     *                 .dateFieldFormat("dateFieldFormat")
     *                 .build()))
     *         .inclusionPatterns(List.of("inclusionPatterns"))
     *         .sslCertificateS3Path(S3PathProperty.builder()
     *                 .bucket("bucket")
     *                 .key("key")
     *                 .build())
     *         .useChangeLog(false)
     *         .vpcConfiguration(DataSourceVpcConfigurationProperty.builder()
     *                 .securityGroupIds(List.of("securityGroupIds"))
     *                 .subnetIds(List.of("subnetIds"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.SharePointConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SharePointConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SharePointConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of credentials stored in AWS Secrets Manager .
         * <p>
         * The credentials should be a user/password pair. If you use SharePoint Server, you also need to provide the sever domain name as part of the credentials. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html">Using a Microsoft SharePoint Data Source</a> . For more information about AWS Secrets Manager see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">What Is AWS Secrets Manager</a> in the <em>AWS Secrets Manager</em> user guide.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretArn();

        /**
         * The version of Microsoft SharePoint that you are using as a data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSharePointVersion();

        /**
         * The URLs of the Microsoft SharePoint site that contains the documents that should be indexed.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getUrls();

        /**
         * `TRUE` to include attachments to documents stored in your Microsoft SharePoint site in the index;
         * <p>
         * otherwise, <code>FALSE</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrawlAttachments() {
            return null;
        }

        /**
         * A Boolean value that specifies whether local groups are disabled ( `True` ) or enabled ( `False` ).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableLocalGroups() {
            return null;
        }

        /**
         * The Microsoft SharePoint attribute field that contains the title of the document.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentTitleFieldName() {
            return null;
        }

        /**
         * A list of regular expression patterns.
         * <p>
         * Documents that match the patterns are excluded from the index. Documents that don't match the patterns are included in the index. If a document matches both an exclusion pattern and an inclusion pattern, the document is not included in the index.
         * <p>
         * The regex is applied to the display URL of the SharePoint document.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclusionPatterns() {
            return null;
        }

        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map Microsoft SharePoint attributes to custom fields in the Amazon Kendra index.
         * <p>
         * You must first create the index fields using the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateIndex.html">UpdateIndex</a> operation before you map SharePoint attributes. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping Data Source Fields</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFieldMappings() {
            return null;
        }

        /**
         * A list of regular expression patterns to include certain documents in your SharePoint.
         * <p>
         * Documents that match the patterns are included in the index. Documents that don't match the patterns are excluded from the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
         * <p>
         * The regex is applied to the display URL of the SharePoint document.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclusionPatterns() {
            return null;
        }

        /**
         * Information required to find a specific file in an Amazon S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSslCertificateS3Path() {
            return null;
        }

        /**
         * `TRUE` to use the SharePoint change log to determine which documents require updating in the index.
         * <p>
         * Depending on the change log's size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in SharePoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseChangeLog() {
            return null;
        }

        /**
         * Provides information for connecting to an Amazon VPC.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SharePointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SharePointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SharePointConfigurationProperty> {
            java.lang.String secretArn;
            java.lang.String sharePointVersion;
            java.util.List<java.lang.String> urls;
            java.lang.Object crawlAttachments;
            java.lang.Object disableLocalGroups;
            java.lang.String documentTitleFieldName;
            java.util.List<java.lang.String> exclusionPatterns;
            java.lang.Object fieldMappings;
            java.util.List<java.lang.String> inclusionPatterns;
            java.lang.Object sslCertificateS3Path;
            java.lang.Object useChangeLog;
            java.lang.Object vpcConfiguration;

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getSecretArn}
             * @param secretArn The Amazon Resource Name (ARN) of credentials stored in AWS Secrets Manager . This parameter is required.
             *                  The credentials should be a user/password pair. If you use SharePoint Server, you also need to provide the sever domain name as part of the credentials. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html">Using a Microsoft SharePoint Data Source</a> . For more information about AWS Secrets Manager see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">What Is AWS Secrets Manager</a> in the <em>AWS Secrets Manager</em> user guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getSharePointVersion}
             * @param sharePointVersion The version of Microsoft SharePoint that you are using as a data source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sharePointVersion(java.lang.String sharePointVersion) {
                this.sharePointVersion = sharePointVersion;
                return this;
            }

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getUrls}
             * @param urls The URLs of the Microsoft SharePoint site that contains the documents that should be indexed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder urls(java.util.List<java.lang.String> urls) {
                this.urls = urls;
                return this;
            }

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getCrawlAttachments}
             * @param crawlAttachments `TRUE` to include attachments to documents stored in your Microsoft SharePoint site in the index;.
             *                         otherwise, <code>FALSE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlAttachments(java.lang.Boolean crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getCrawlAttachments}
             * @param crawlAttachments `TRUE` to include attachments to documents stored in your Microsoft SharePoint site in the index;.
             *                         otherwise, <code>FALSE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlAttachments(software.amazon.awscdk.IResolvable crawlAttachments) {
                this.crawlAttachments = crawlAttachments;
                return this;
            }

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getDisableLocalGroups}
             * @param disableLocalGroups A Boolean value that specifies whether local groups are disabled ( `True` ) or enabled ( `False` ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableLocalGroups(java.lang.Boolean disableLocalGroups) {
                this.disableLocalGroups = disableLocalGroups;
                return this;
            }

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getDisableLocalGroups}
             * @param disableLocalGroups A Boolean value that specifies whether local groups are disabled ( `True` ) or enabled ( `False` ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableLocalGroups(software.amazon.awscdk.IResolvable disableLocalGroups) {
                this.disableLocalGroups = disableLocalGroups;
                return this;
            }

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getDocumentTitleFieldName}
             * @param documentTitleFieldName The Microsoft SharePoint attribute field that contains the title of the document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentTitleFieldName(java.lang.String documentTitleFieldName) {
                this.documentTitleFieldName = documentTitleFieldName;
                return this;
            }

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getExclusionPatterns}
             * @param exclusionPatterns A list of regular expression patterns.
             *                          Documents that match the patterns are excluded from the index. Documents that don't match the patterns are included in the index. If a document matches both an exclusion pattern and an inclusion pattern, the document is not included in the index.
             *                          <p>
             *                          The regex is applied to the display URL of the SharePoint document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusionPatterns(java.util.List<java.lang.String> exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getFieldMappings}
             * @param fieldMappings A list of `DataSourceToIndexFieldMapping` objects that map Microsoft SharePoint attributes to custom fields in the Amazon Kendra index.
             *                      You must first create the index fields using the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateIndex.html">UpdateIndex</a> operation before you map SharePoint attributes. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping Data Source Fields</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(software.amazon.awscdk.IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getFieldMappings}
             * @param fieldMappings A list of `DataSourceToIndexFieldMapping` objects that map Microsoft SharePoint attributes to custom fields in the Amazon Kendra index.
             *                      You must first create the index fields using the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateIndex.html">UpdateIndex</a> operation before you map SharePoint attributes. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping Data Source Fields</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(java.util.List<? extends java.lang.Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getInclusionPatterns}
             * @param inclusionPatterns A list of regular expression patterns to include certain documents in your SharePoint.
             *                          Documents that match the patterns are included in the index. Documents that don't match the patterns are excluded from the index. If a document matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the document isn't included in the index.
             *                          <p>
             *                          The regex is applied to the display URL of the SharePoint document.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusionPatterns(java.util.List<java.lang.String> inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getSslCertificateS3Path}
             * @param sslCertificateS3Path Information required to find a specific file in an Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslCertificateS3Path(software.amazon.awscdk.services.kendra.CfnDataSource.S3PathProperty sslCertificateS3Path) {
                this.sslCertificateS3Path = sslCertificateS3Path;
                return this;
            }

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getSslCertificateS3Path}
             * @param sslCertificateS3Path Information required to find a specific file in an Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslCertificateS3Path(software.amazon.awscdk.IResolvable sslCertificateS3Path) {
                this.sslCertificateS3Path = sslCertificateS3Path;
                return this;
            }

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getUseChangeLog}
             * @param useChangeLog `TRUE` to use the SharePoint change log to determine which documents require updating in the index.
             *                     Depending on the change log's size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in SharePoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useChangeLog(java.lang.Boolean useChangeLog) {
                this.useChangeLog = useChangeLog;
                return this;
            }

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getUseChangeLog}
             * @param useChangeLog `TRUE` to use the SharePoint change log to determine which documents require updating in the index.
             *                     Depending on the change log's size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in SharePoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useChangeLog(software.amazon.awscdk.IResolvable useChangeLog) {
                this.useChangeLog = useChangeLog;
                return this;
            }

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration Provides information for connecting to an Amazon VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.DataSourceVpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SharePointConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration Provides information for connecting to an Amazon VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SharePointConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SharePointConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SharePointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SharePointConfigurationProperty {
            private final java.lang.String secretArn;
            private final java.lang.String sharePointVersion;
            private final java.util.List<java.lang.String> urls;
            private final java.lang.Object crawlAttachments;
            private final java.lang.Object disableLocalGroups;
            private final java.lang.String documentTitleFieldName;
            private final java.util.List<java.lang.String> exclusionPatterns;
            private final java.lang.Object fieldMappings;
            private final java.util.List<java.lang.String> inclusionPatterns;
            private final java.lang.Object sslCertificateS3Path;
            private final java.lang.Object useChangeLog;
            private final java.lang.Object vpcConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sharePointVersion = software.amazon.jsii.Kernel.get(this, "sharePointVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.urls = software.amazon.jsii.Kernel.get(this, "urls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.crawlAttachments = software.amazon.jsii.Kernel.get(this, "crawlAttachments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.disableLocalGroups = software.amazon.jsii.Kernel.get(this, "disableLocalGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.documentTitleFieldName = software.amazon.jsii.Kernel.get(this, "documentTitleFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exclusionPatterns = software.amazon.jsii.Kernel.get(this, "exclusionPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.fieldMappings = software.amazon.jsii.Kernel.get(this, "fieldMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inclusionPatterns = software.amazon.jsii.Kernel.get(this, "inclusionPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sslCertificateS3Path = software.amazon.jsii.Kernel.get(this, "sslCertificateS3Path", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useChangeLog = software.amazon.jsii.Kernel.get(this, "useChangeLog", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcConfiguration = software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretArn = java.util.Objects.requireNonNull(builder.secretArn, "secretArn is required");
                this.sharePointVersion = java.util.Objects.requireNonNull(builder.sharePointVersion, "sharePointVersion is required");
                this.urls = java.util.Objects.requireNonNull(builder.urls, "urls is required");
                this.crawlAttachments = builder.crawlAttachments;
                this.disableLocalGroups = builder.disableLocalGroups;
                this.documentTitleFieldName = builder.documentTitleFieldName;
                this.exclusionPatterns = builder.exclusionPatterns;
                this.fieldMappings = builder.fieldMappings;
                this.inclusionPatterns = builder.inclusionPatterns;
                this.sslCertificateS3Path = builder.sslCertificateS3Path;
                this.useChangeLog = builder.useChangeLog;
                this.vpcConfiguration = builder.vpcConfiguration;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            public final java.lang.String getSharePointVersion() {
                return this.sharePointVersion;
            }

            @Override
            public final java.util.List<java.lang.String> getUrls() {
                return this.urls;
            }

            @Override
            public final java.lang.Object getCrawlAttachments() {
                return this.crawlAttachments;
            }

            @Override
            public final java.lang.Object getDisableLocalGroups() {
                return this.disableLocalGroups;
            }

            @Override
            public final java.lang.String getDocumentTitleFieldName() {
                return this.documentTitleFieldName;
            }

            @Override
            public final java.util.List<java.lang.String> getExclusionPatterns() {
                return this.exclusionPatterns;
            }

            @Override
            public final java.lang.Object getFieldMappings() {
                return this.fieldMappings;
            }

            @Override
            public final java.util.List<java.lang.String> getInclusionPatterns() {
                return this.inclusionPatterns;
            }

            @Override
            public final java.lang.Object getSslCertificateS3Path() {
                return this.sslCertificateS3Path;
            }

            @Override
            public final java.lang.Object getUseChangeLog() {
                return this.useChangeLog;
            }

            @Override
            public final java.lang.Object getVpcConfiguration() {
                return this.vpcConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("secretArn", om.valueToTree(this.getSecretArn()));
                data.set("sharePointVersion", om.valueToTree(this.getSharePointVersion()));
                data.set("urls", om.valueToTree(this.getUrls()));
                if (this.getCrawlAttachments() != null) {
                    data.set("crawlAttachments", om.valueToTree(this.getCrawlAttachments()));
                }
                if (this.getDisableLocalGroups() != null) {
                    data.set("disableLocalGroups", om.valueToTree(this.getDisableLocalGroups()));
                }
                if (this.getDocumentTitleFieldName() != null) {
                    data.set("documentTitleFieldName", om.valueToTree(this.getDocumentTitleFieldName()));
                }
                if (this.getExclusionPatterns() != null) {
                    data.set("exclusionPatterns", om.valueToTree(this.getExclusionPatterns()));
                }
                if (this.getFieldMappings() != null) {
                    data.set("fieldMappings", om.valueToTree(this.getFieldMappings()));
                }
                if (this.getInclusionPatterns() != null) {
                    data.set("inclusionPatterns", om.valueToTree(this.getInclusionPatterns()));
                }
                if (this.getSslCertificateS3Path() != null) {
                    data.set("sslCertificateS3Path", om.valueToTree(this.getSslCertificateS3Path()));
                }
                if (this.getUseChangeLog() != null) {
                    data.set("useChangeLog", om.valueToTree(this.getUseChangeLog()));
                }
                if (this.getVpcConfiguration() != null) {
                    data.set("vpcConfiguration", om.valueToTree(this.getVpcConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.SharePointConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SharePointConfigurationProperty.Jsii$Proxy that = (SharePointConfigurationProperty.Jsii$Proxy) o;

                if (!secretArn.equals(that.secretArn)) return false;
                if (!sharePointVersion.equals(that.sharePointVersion)) return false;
                if (!urls.equals(that.urls)) return false;
                if (this.crawlAttachments != null ? !this.crawlAttachments.equals(that.crawlAttachments) : that.crawlAttachments != null) return false;
                if (this.disableLocalGroups != null ? !this.disableLocalGroups.equals(that.disableLocalGroups) : that.disableLocalGroups != null) return false;
                if (this.documentTitleFieldName != null ? !this.documentTitleFieldName.equals(that.documentTitleFieldName) : that.documentTitleFieldName != null) return false;
                if (this.exclusionPatterns != null ? !this.exclusionPatterns.equals(that.exclusionPatterns) : that.exclusionPatterns != null) return false;
                if (this.fieldMappings != null ? !this.fieldMappings.equals(that.fieldMappings) : that.fieldMappings != null) return false;
                if (this.inclusionPatterns != null ? !this.inclusionPatterns.equals(that.inclusionPatterns) : that.inclusionPatterns != null) return false;
                if (this.sslCertificateS3Path != null ? !this.sslCertificateS3Path.equals(that.sslCertificateS3Path) : that.sslCertificateS3Path != null) return false;
                if (this.useChangeLog != null ? !this.useChangeLog.equals(that.useChangeLog) : that.useChangeLog != null) return false;
                return this.vpcConfiguration != null ? this.vpcConfiguration.equals(that.vpcConfiguration) : that.vpcConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.secretArn.hashCode();
                result = 31 * result + (this.sharePointVersion.hashCode());
                result = 31 * result + (this.urls.hashCode());
                result = 31 * result + (this.crawlAttachments != null ? this.crawlAttachments.hashCode() : 0);
                result = 31 * result + (this.disableLocalGroups != null ? this.disableLocalGroups.hashCode() : 0);
                result = 31 * result + (this.documentTitleFieldName != null ? this.documentTitleFieldName.hashCode() : 0);
                result = 31 * result + (this.exclusionPatterns != null ? this.exclusionPatterns.hashCode() : 0);
                result = 31 * result + (this.fieldMappings != null ? this.fieldMappings.hashCode() : 0);
                result = 31 * result + (this.inclusionPatterns != null ? this.inclusionPatterns.hashCode() : 0);
                result = 31 * result + (this.sslCertificateS3Path != null ? this.sslCertificateS3Path.hashCode() : 0);
                result = 31 * result + (this.useChangeLog != null ? this.useChangeLog.hashCode() : 0);
                result = 31 * result + (this.vpcConfiguration != null ? this.vpcConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides information that configures Amazon Kendra to use a SQL database.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * SqlConfigurationProperty sqlConfigurationProperty = SqlConfigurationProperty.builder()
     *         .queryIdentifiersEnclosingOption("queryIdentifiersEnclosingOption")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.SqlConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SqlConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SqlConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether Amazon Kendra encloses SQL identifiers for tables and column names in double quotes (") when making a database query.
         * <p>
         * You can set the value to <code>DOUBLE_QUOTES</code> or <code>NONE</code> .
         * <p>
         * By default, Amazon Kendra passes SQL identifiers the way that they are entered into the data source configuration. It does not change the case of identifiers or enclose them in quotes.
         * <p>
         * PostgreSQL internally converts uppercase characters to lower case characters in identifiers unless they are quoted. Choosing this option encloses identifiers in quotes so that PostgreSQL does not convert the character's case.
         * <p>
         * For MySQL databases, you must enable the ansi_quotes option when you set this field to <code>DOUBLE_QUOTES</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getQueryIdentifiersEnclosingOption() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SqlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SqlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SqlConfigurationProperty> {
            java.lang.String queryIdentifiersEnclosingOption;

            /**
             * Sets the value of {@link SqlConfigurationProperty#getQueryIdentifiersEnclosingOption}
             * @param queryIdentifiersEnclosingOption Determines whether Amazon Kendra encloses SQL identifiers for tables and column names in double quotes (") when making a database query.
             *                                        You can set the value to <code>DOUBLE_QUOTES</code> or <code>NONE</code> .
             *                                        <p>
             *                                        By default, Amazon Kendra passes SQL identifiers the way that they are entered into the data source configuration. It does not change the case of identifiers or enclose them in quotes.
             *                                        <p>
             *                                        PostgreSQL internally converts uppercase characters to lower case characters in identifiers unless they are quoted. Choosing this option encloses identifiers in quotes so that PostgreSQL does not convert the character's case.
             *                                        <p>
             *                                        For MySQL databases, you must enable the ansi_quotes option when you set this field to <code>DOUBLE_QUOTES</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryIdentifiersEnclosingOption(java.lang.String queryIdentifiersEnclosingOption) {
                this.queryIdentifiersEnclosingOption = queryIdentifiersEnclosingOption;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SqlConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SqlConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SqlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SqlConfigurationProperty {
            private final java.lang.String queryIdentifiersEnclosingOption;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queryIdentifiersEnclosingOption = software.amazon.jsii.Kernel.get(this, "queryIdentifiersEnclosingOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queryIdentifiersEnclosingOption = builder.queryIdentifiersEnclosingOption;
            }

            @Override
            public final java.lang.String getQueryIdentifiersEnclosingOption() {
                return this.queryIdentifiersEnclosingOption;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getQueryIdentifiersEnclosingOption() != null) {
                    data.set("queryIdentifiersEnclosingOption", om.valueToTree(this.getQueryIdentifiersEnclosingOption()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.SqlConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SqlConfigurationProperty.Jsii$Proxy that = (SqlConfigurationProperty.Jsii$Proxy) o;

                return this.queryIdentifiersEnclosingOption != null ? this.queryIdentifiersEnclosingOption.equals(that.queryIdentifiersEnclosingOption) : that.queryIdentifiersEnclosingOption == null;
            }

            @Override
            public final int hashCode() {
                int result = this.queryIdentifiersEnclosingOption != null ? this.queryIdentifiersEnclosingOption.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Provides the configuration information to connect to websites that require user authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * WebCrawlerAuthenticationConfigurationProperty webCrawlerAuthenticationConfigurationProperty = WebCrawlerAuthenticationConfigurationProperty.builder()
     *         .basicAuthentication(List.of(WebCrawlerBasicAuthenticationProperty.builder()
     *                 .credentials("credentials")
     *                 .host("host")
     *                 .port(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerAuthenticationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WebCrawlerAuthenticationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebCrawlerAuthenticationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of configuration information that's required to connect to and crawl a website host using basic authentication credentials.
         * <p>
         * The list includes the name and port number of the website host.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBasicAuthentication() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WebCrawlerAuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebCrawlerAuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebCrawlerAuthenticationConfigurationProperty> {
            java.lang.Object basicAuthentication;

            /**
             * Sets the value of {@link WebCrawlerAuthenticationConfigurationProperty#getBasicAuthentication}
             * @param basicAuthentication The list of configuration information that's required to connect to and crawl a website host using basic authentication credentials.
             *                            The list includes the name and port number of the website host.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuthentication(software.amazon.awscdk.IResolvable basicAuthentication) {
                this.basicAuthentication = basicAuthentication;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerAuthenticationConfigurationProperty#getBasicAuthentication}
             * @param basicAuthentication The list of configuration information that's required to connect to and crawl a website host using basic authentication credentials.
             *                            The list includes the name and port number of the website host.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuthentication(java.util.List<? extends java.lang.Object> basicAuthentication) {
                this.basicAuthentication = basicAuthentication;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebCrawlerAuthenticationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebCrawlerAuthenticationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebCrawlerAuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebCrawlerAuthenticationConfigurationProperty {
            private final java.lang.Object basicAuthentication;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.basicAuthentication = software.amazon.jsii.Kernel.get(this, "basicAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.basicAuthentication = builder.basicAuthentication;
            }

            @Override
            public final java.lang.Object getBasicAuthentication() {
                return this.basicAuthentication;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBasicAuthentication() != null) {
                    data.set("basicAuthentication", om.valueToTree(this.getBasicAuthentication()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerAuthenticationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebCrawlerAuthenticationConfigurationProperty.Jsii$Proxy that = (WebCrawlerAuthenticationConfigurationProperty.Jsii$Proxy) o;

                return this.basicAuthentication != null ? this.basicAuthentication.equals(that.basicAuthentication) : that.basicAuthentication == null;
            }

            @Override
            public final int hashCode() {
                int result = this.basicAuthentication != null ? this.basicAuthentication.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Provides the configuration information to connect to websites that require basic user authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * WebCrawlerBasicAuthenticationProperty webCrawlerBasicAuthenticationProperty = WebCrawlerBasicAuthenticationProperty.builder()
     *         .credentials("credentials")
     *         .host("host")
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerBasicAuthenticationProperty")
    @software.amazon.jsii.Jsii.Proxy(WebCrawlerBasicAuthenticationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebCrawlerBasicAuthenticationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Your secret ARN, which you can create in [AWS Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html).
         * <p>
         * You use a secret if basic authentication credentials are required to connect to a website. The secret stores your credentials of user name and password.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCredentials();

        /**
         * The name of the website host you want to connect to using authentication credentials.
         * <p>
         * For example, the host name of https://a.example.com/page1.html is "a.example.com".
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHost();

        /**
         * The port number of the website host you want to connect to using authentication credentials.
         * <p>
         * For example, the port for https://a.example.com/page1.html is 443, the standard port for HTTPS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * @return a {@link Builder} of {@link WebCrawlerBasicAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebCrawlerBasicAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebCrawlerBasicAuthenticationProperty> {
            java.lang.String credentials;
            java.lang.String host;
            java.lang.Number port;

            /**
             * Sets the value of {@link WebCrawlerBasicAuthenticationProperty#getCredentials}
             * @param credentials Your secret ARN, which you can create in [AWS Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html). This parameter is required.
             *                    You use a secret if basic authentication credentials are required to connect to a website. The secret stores your credentials of user name and password.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentials(java.lang.String credentials) {
                this.credentials = credentials;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerBasicAuthenticationProperty#getHost}
             * @param host The name of the website host you want to connect to using authentication credentials. This parameter is required.
             *             For example, the host name of https://a.example.com/page1.html is "a.example.com".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerBasicAuthenticationProperty#getPort}
             * @param port The port number of the website host you want to connect to using authentication credentials. This parameter is required.
             *             For example, the port for https://a.example.com/page1.html is 443, the standard port for HTTPS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebCrawlerBasicAuthenticationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebCrawlerBasicAuthenticationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebCrawlerBasicAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebCrawlerBasicAuthenticationProperty {
            private final java.lang.String credentials;
            private final java.lang.String host;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.credentials = java.util.Objects.requireNonNull(builder.credentials, "credentials is required");
                this.host = java.util.Objects.requireNonNull(builder.host, "host is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
            }

            @Override
            public final java.lang.String getCredentials() {
                return this.credentials;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("credentials", om.valueToTree(this.getCredentials()));
                data.set("host", om.valueToTree(this.getHost()));
                data.set("port", om.valueToTree(this.getPort()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerBasicAuthenticationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebCrawlerBasicAuthenticationProperty.Jsii$Proxy that = (WebCrawlerBasicAuthenticationProperty.Jsii$Proxy) o;

                if (!credentials.equals(that.credentials)) return false;
                if (!host.equals(that.host)) return false;
                return this.port.equals(that.port);
            }

            @Override
            public final int hashCode() {
                int result = this.credentials.hashCode();
                result = 31 * result + (this.host.hashCode());
                result = 31 * result + (this.port.hashCode());
                return result;
            }
        }
    }
    /**
     * Provides the configuration information required for Amazon Kendra Web Crawler.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * WebCrawlerConfigurationProperty webCrawlerConfigurationProperty = WebCrawlerConfigurationProperty.builder()
     *         .urls(WebCrawlerUrlsProperty.builder()
     *                 .seedUrlConfiguration(WebCrawlerSeedUrlConfigurationProperty.builder()
     *                         .seedUrls(List.of("seedUrls"))
     *                         // the properties below are optional
     *                         .webCrawlerMode("webCrawlerMode")
     *                         .build())
     *                 .siteMapsConfiguration(WebCrawlerSiteMapsConfigurationProperty.builder()
     *                         .siteMaps(List.of("siteMaps"))
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .authenticationConfiguration(WebCrawlerAuthenticationConfigurationProperty.builder()
     *                 .basicAuthentication(List.of(WebCrawlerBasicAuthenticationProperty.builder()
     *                         .credentials("credentials")
     *                         .host("host")
     *                         .port(123)
     *                         .build()))
     *                 .build())
     *         .crawlDepth(123)
     *         .maxContentSizePerPageInMegaBytes(123)
     *         .maxLinksPerPage(123)
     *         .maxUrlsPerMinuteCrawlRate(123)
     *         .proxyConfiguration(ProxyConfigurationProperty.builder()
     *                 .host("host")
     *                 .port(123)
     *                 // the properties below are optional
     *                 .credentials("credentials")
     *                 .build())
     *         .urlExclusionPatterns(List.of("urlExclusionPatterns"))
     *         .urlInclusionPatterns(List.of("urlInclusionPatterns"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WebCrawlerConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebCrawlerConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl.
         * <p>
         * You can include website subdomains. You can list up to 100 seed URLs and up to three sitemap URLs.
         * <p>
         * You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling.
         * <p>
         * <em>When selecting websites to index, you must adhere to the <a href="https://docs.aws.amazon.com/aup/">Amazon Acceptable Use Policy</a> and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own webpages, or webpages that you have authorization to index.</em>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getUrls();

        /**
         * Configuration information required to connect to websites using authentication.
         * <p>
         * You can connect to websites using basic authentication of user name and password.
         * <p>
         * You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS. You use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a> to store your authentication credentials.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticationConfiguration() {
            return null;
        }

        /**
         * Specifies the number of levels in a website that you want to crawl.
         * <p>
         * The first level begins from the website seed or starting point URL. For example, if a website has 3 levels – index level (i.e. seed in this example), sections level, and subsections level – and you are only interested in crawling information up to the sections level (i.e. levels 0-1), you can set your depth to 1.
         * <p>
         * The default crawl depth is set to 2.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCrawlDepth() {
            return null;
        }

        /**
         * The maximum size (in MB) of a webpage or attachment to crawl.
         * <p>
         * Files larger than this size (in MB) are skipped/not crawled.
         * <p>
         * The default maximum size of a webpage or attachment is set to 50 MB.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxContentSizePerPageInMegaBytes() {
            return null;
        }

        /**
         * The maximum number of URLs on a webpage to include when crawling a website. This number is per webpage.
         * <p>
         * As a website’s webpages are crawled, any URLs the webpages link to are also crawled. URLs on a webpage are crawled in order of appearance.
         * <p>
         * The default maximum links per page is 100.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxLinksPerPage() {
            return null;
        }

        /**
         * The maximum number of URLs crawled per website host per minute.
         * <p>
         * A minimum of one URL is required.
         * <p>
         * The default maximum number of URLs crawled per website host per minute is 300.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxUrlsPerMinuteCrawlRate() {
            return null;
        }

        /**
         * Configuration information required to connect to your internal websites via a web proxy.
         * <p>
         * You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS.
         * <p>
         * Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication. To store web proxy credentials, you use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProxyConfiguration() {
            return null;
        }

        /**
         * A list of regular expression patterns to exclude certain URLs to crawl.
         * <p>
         * URLs that match the patterns are excluded from the index. URLs that don't match the patterns are included in the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getUrlExclusionPatterns() {
            return null;
        }

        /**
         * A list of regular expression patterns to include certain URLs to crawl.
         * <p>
         * URLs that match the patterns are included in the index. URLs that don't match the patterns are excluded from the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getUrlInclusionPatterns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WebCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebCrawlerConfigurationProperty> {
            java.lang.Object urls;
            java.lang.Object authenticationConfiguration;
            java.lang.Number crawlDepth;
            java.lang.Number maxContentSizePerPageInMegaBytes;
            java.lang.Number maxLinksPerPage;
            java.lang.Number maxUrlsPerMinuteCrawlRate;
            java.lang.Object proxyConfiguration;
            java.util.List<java.lang.String> urlExclusionPatterns;
            java.util.List<java.lang.String> urlInclusionPatterns;

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getUrls}
             * @param urls Specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl. This parameter is required.
             *             You can include website subdomains. You can list up to 100 seed URLs and up to three sitemap URLs.
             *             <p>
             *             You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling.
             *             <p>
             *             <em>When selecting websites to index, you must adhere to the <a href="https://docs.aws.amazon.com/aup/">Amazon Acceptable Use Policy</a> and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own webpages, or webpages that you have authorization to index.</em>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder urls(software.amazon.awscdk.services.kendra.CfnDataSource.WebCrawlerUrlsProperty urls) {
                this.urls = urls;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getUrls}
             * @param urls Specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl. This parameter is required.
             *             You can include website subdomains. You can list up to 100 seed URLs and up to three sitemap URLs.
             *             <p>
             *             You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling.
             *             <p>
             *             <em>When selecting websites to index, you must adhere to the <a href="https://docs.aws.amazon.com/aup/">Amazon Acceptable Use Policy</a> and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own webpages, or webpages that you have authorization to index.</em>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder urls(software.amazon.awscdk.IResolvable urls) {
                this.urls = urls;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getAuthenticationConfiguration}
             * @param authenticationConfiguration Configuration information required to connect to websites using authentication.
             *                                    You can connect to websites using basic authentication of user name and password.
             *                                    <p>
             *                                    You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS. You use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a> to store your authentication credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.WebCrawlerAuthenticationConfigurationProperty authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getAuthenticationConfiguration}
             * @param authenticationConfiguration Configuration information required to connect to websites using authentication.
             *                                    You can connect to websites using basic authentication of user name and password.
             *                                    <p>
             *                                    You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS. You use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a> to store your authentication credentials.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationConfiguration(software.amazon.awscdk.IResolvable authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getCrawlDepth}
             * @param crawlDepth Specifies the number of levels in a website that you want to crawl.
             *                   The first level begins from the website seed or starting point URL. For example, if a website has 3 levels – index level (i.e. seed in this example), sections level, and subsections level – and you are only interested in crawling information up to the sections level (i.e. levels 0-1), you can set your depth to 1.
             *                   <p>
             *                   The default crawl depth is set to 2.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlDepth(java.lang.Number crawlDepth) {
                this.crawlDepth = crawlDepth;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getMaxContentSizePerPageInMegaBytes}
             * @param maxContentSizePerPageInMegaBytes The maximum size (in MB) of a webpage or attachment to crawl.
             *                                         Files larger than this size (in MB) are skipped/not crawled.
             *                                         <p>
             *                                         The default maximum size of a webpage or attachment is set to 50 MB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxContentSizePerPageInMegaBytes(java.lang.Number maxContentSizePerPageInMegaBytes) {
                this.maxContentSizePerPageInMegaBytes = maxContentSizePerPageInMegaBytes;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getMaxLinksPerPage}
             * @param maxLinksPerPage The maximum number of URLs on a webpage to include when crawling a website. This number is per webpage.
             *                        As a website’s webpages are crawled, any URLs the webpages link to are also crawled. URLs on a webpage are crawled in order of appearance.
             *                        <p>
             *                        The default maximum links per page is 100.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxLinksPerPage(java.lang.Number maxLinksPerPage) {
                this.maxLinksPerPage = maxLinksPerPage;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getMaxUrlsPerMinuteCrawlRate}
             * @param maxUrlsPerMinuteCrawlRate The maximum number of URLs crawled per website host per minute.
             *                                  A minimum of one URL is required.
             *                                  <p>
             *                                  The default maximum number of URLs crawled per website host per minute is 300.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxUrlsPerMinuteCrawlRate(java.lang.Number maxUrlsPerMinuteCrawlRate) {
                this.maxUrlsPerMinuteCrawlRate = maxUrlsPerMinuteCrawlRate;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getProxyConfiguration}
             * @param proxyConfiguration Configuration information required to connect to your internal websites via a web proxy.
             *                           You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS.
             *                           <p>
             *                           Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication. To store web proxy credentials, you use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder proxyConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.ProxyConfigurationProperty proxyConfiguration) {
                this.proxyConfiguration = proxyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getProxyConfiguration}
             * @param proxyConfiguration Configuration information required to connect to your internal websites via a web proxy.
             *                           You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS.
             *                           <p>
             *                           Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication. To store web proxy credentials, you use a secret in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">AWS Secrets Manager</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder proxyConfiguration(software.amazon.awscdk.IResolvable proxyConfiguration) {
                this.proxyConfiguration = proxyConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getUrlExclusionPatterns}
             * @param urlExclusionPatterns A list of regular expression patterns to exclude certain URLs to crawl.
             *                             URLs that match the patterns are excluded from the index. URLs that don't match the patterns are included in the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder urlExclusionPatterns(java.util.List<java.lang.String> urlExclusionPatterns) {
                this.urlExclusionPatterns = urlExclusionPatterns;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerConfigurationProperty#getUrlInclusionPatterns}
             * @param urlInclusionPatterns A list of regular expression patterns to include certain URLs to crawl.
             *                             URLs that match the patterns are included in the index. URLs that don't match the patterns are excluded from the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder urlInclusionPatterns(java.util.List<java.lang.String> urlInclusionPatterns) {
                this.urlInclusionPatterns = urlInclusionPatterns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebCrawlerConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebCrawlerConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebCrawlerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebCrawlerConfigurationProperty {
            private final java.lang.Object urls;
            private final java.lang.Object authenticationConfiguration;
            private final java.lang.Number crawlDepth;
            private final java.lang.Number maxContentSizePerPageInMegaBytes;
            private final java.lang.Number maxLinksPerPage;
            private final java.lang.Number maxUrlsPerMinuteCrawlRate;
            private final java.lang.Object proxyConfiguration;
            private final java.util.List<java.lang.String> urlExclusionPatterns;
            private final java.util.List<java.lang.String> urlInclusionPatterns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.urls = software.amazon.jsii.Kernel.get(this, "urls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.authenticationConfiguration = software.amazon.jsii.Kernel.get(this, "authenticationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.crawlDepth = software.amazon.jsii.Kernel.get(this, "crawlDepth", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxContentSizePerPageInMegaBytes = software.amazon.jsii.Kernel.get(this, "maxContentSizePerPageInMegaBytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxLinksPerPage = software.amazon.jsii.Kernel.get(this, "maxLinksPerPage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxUrlsPerMinuteCrawlRate = software.amazon.jsii.Kernel.get(this, "maxUrlsPerMinuteCrawlRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.proxyConfiguration = software.amazon.jsii.Kernel.get(this, "proxyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.urlExclusionPatterns = software.amazon.jsii.Kernel.get(this, "urlExclusionPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.urlInclusionPatterns = software.amazon.jsii.Kernel.get(this, "urlInclusionPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.urls = java.util.Objects.requireNonNull(builder.urls, "urls is required");
                this.authenticationConfiguration = builder.authenticationConfiguration;
                this.crawlDepth = builder.crawlDepth;
                this.maxContentSizePerPageInMegaBytes = builder.maxContentSizePerPageInMegaBytes;
                this.maxLinksPerPage = builder.maxLinksPerPage;
                this.maxUrlsPerMinuteCrawlRate = builder.maxUrlsPerMinuteCrawlRate;
                this.proxyConfiguration = builder.proxyConfiguration;
                this.urlExclusionPatterns = builder.urlExclusionPatterns;
                this.urlInclusionPatterns = builder.urlInclusionPatterns;
            }

            @Override
            public final java.lang.Object getUrls() {
                return this.urls;
            }

            @Override
            public final java.lang.Object getAuthenticationConfiguration() {
                return this.authenticationConfiguration;
            }

            @Override
            public final java.lang.Number getCrawlDepth() {
                return this.crawlDepth;
            }

            @Override
            public final java.lang.Number getMaxContentSizePerPageInMegaBytes() {
                return this.maxContentSizePerPageInMegaBytes;
            }

            @Override
            public final java.lang.Number getMaxLinksPerPage() {
                return this.maxLinksPerPage;
            }

            @Override
            public final java.lang.Number getMaxUrlsPerMinuteCrawlRate() {
                return this.maxUrlsPerMinuteCrawlRate;
            }

            @Override
            public final java.lang.Object getProxyConfiguration() {
                return this.proxyConfiguration;
            }

            @Override
            public final java.util.List<java.lang.String> getUrlExclusionPatterns() {
                return this.urlExclusionPatterns;
            }

            @Override
            public final java.util.List<java.lang.String> getUrlInclusionPatterns() {
                return this.urlInclusionPatterns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("urls", om.valueToTree(this.getUrls()));
                if (this.getAuthenticationConfiguration() != null) {
                    data.set("authenticationConfiguration", om.valueToTree(this.getAuthenticationConfiguration()));
                }
                if (this.getCrawlDepth() != null) {
                    data.set("crawlDepth", om.valueToTree(this.getCrawlDepth()));
                }
                if (this.getMaxContentSizePerPageInMegaBytes() != null) {
                    data.set("maxContentSizePerPageInMegaBytes", om.valueToTree(this.getMaxContentSizePerPageInMegaBytes()));
                }
                if (this.getMaxLinksPerPage() != null) {
                    data.set("maxLinksPerPage", om.valueToTree(this.getMaxLinksPerPage()));
                }
                if (this.getMaxUrlsPerMinuteCrawlRate() != null) {
                    data.set("maxUrlsPerMinuteCrawlRate", om.valueToTree(this.getMaxUrlsPerMinuteCrawlRate()));
                }
                if (this.getProxyConfiguration() != null) {
                    data.set("proxyConfiguration", om.valueToTree(this.getProxyConfiguration()));
                }
                if (this.getUrlExclusionPatterns() != null) {
                    data.set("urlExclusionPatterns", om.valueToTree(this.getUrlExclusionPatterns()));
                }
                if (this.getUrlInclusionPatterns() != null) {
                    data.set("urlInclusionPatterns", om.valueToTree(this.getUrlInclusionPatterns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebCrawlerConfigurationProperty.Jsii$Proxy that = (WebCrawlerConfigurationProperty.Jsii$Proxy) o;

                if (!urls.equals(that.urls)) return false;
                if (this.authenticationConfiguration != null ? !this.authenticationConfiguration.equals(that.authenticationConfiguration) : that.authenticationConfiguration != null) return false;
                if (this.crawlDepth != null ? !this.crawlDepth.equals(that.crawlDepth) : that.crawlDepth != null) return false;
                if (this.maxContentSizePerPageInMegaBytes != null ? !this.maxContentSizePerPageInMegaBytes.equals(that.maxContentSizePerPageInMegaBytes) : that.maxContentSizePerPageInMegaBytes != null) return false;
                if (this.maxLinksPerPage != null ? !this.maxLinksPerPage.equals(that.maxLinksPerPage) : that.maxLinksPerPage != null) return false;
                if (this.maxUrlsPerMinuteCrawlRate != null ? !this.maxUrlsPerMinuteCrawlRate.equals(that.maxUrlsPerMinuteCrawlRate) : that.maxUrlsPerMinuteCrawlRate != null) return false;
                if (this.proxyConfiguration != null ? !this.proxyConfiguration.equals(that.proxyConfiguration) : that.proxyConfiguration != null) return false;
                if (this.urlExclusionPatterns != null ? !this.urlExclusionPatterns.equals(that.urlExclusionPatterns) : that.urlExclusionPatterns != null) return false;
                return this.urlInclusionPatterns != null ? this.urlInclusionPatterns.equals(that.urlInclusionPatterns) : that.urlInclusionPatterns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.urls.hashCode();
                result = 31 * result + (this.authenticationConfiguration != null ? this.authenticationConfiguration.hashCode() : 0);
                result = 31 * result + (this.crawlDepth != null ? this.crawlDepth.hashCode() : 0);
                result = 31 * result + (this.maxContentSizePerPageInMegaBytes != null ? this.maxContentSizePerPageInMegaBytes.hashCode() : 0);
                result = 31 * result + (this.maxLinksPerPage != null ? this.maxLinksPerPage.hashCode() : 0);
                result = 31 * result + (this.maxUrlsPerMinuteCrawlRate != null ? this.maxUrlsPerMinuteCrawlRate.hashCode() : 0);
                result = 31 * result + (this.proxyConfiguration != null ? this.proxyConfiguration.hashCode() : 0);
                result = 31 * result + (this.urlExclusionPatterns != null ? this.urlExclusionPatterns.hashCode() : 0);
                result = 31 * result + (this.urlInclusionPatterns != null ? this.urlInclusionPatterns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information of the seed or starting point URLs to crawl.
     * <p>
     * <em>When selecting websites to index, you must adhere to the <a href="https://docs.aws.amazon.com/aup/">Amazon Acceptable Use Policy</a> and all other Amazon terms. Remember that you must only use the Amazon Kendra web crawler to index your own webpages, or webpages that you have authorization to index.</em>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * WebCrawlerSeedUrlConfigurationProperty webCrawlerSeedUrlConfigurationProperty = WebCrawlerSeedUrlConfigurationProperty.builder()
     *         .seedUrls(List.of("seedUrls"))
     *         // the properties below are optional
     *         .webCrawlerMode("webCrawlerMode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerSeedUrlConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WebCrawlerSeedUrlConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebCrawlerSeedUrlConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of seed or starting point URLs of the websites you want to crawl.
         * <p>
         * The list can include a maximum of 100 seed URLs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSeedUrls();

        /**
         * You can choose one of the following modes:.
         * <p>
         * <ul>
         * <li><code>HOST_ONLY</code> – crawl only the website host names. For example, if the seed URL is "abc.example.com", then only URLs with host name "abc.example.com" are crawled.</li>
         * <li><code>SUBDOMAINS</code> – crawl the website host names with subdomains. For example, if the seed URL is "abc.example.com", then "a.abc.example.com" and "b.abc.example.com" are also crawled.</li>
         * <li><code>EVERYTHING</code> – crawl the website host names with subdomains and other domains that the webpages link to.</li>
         * </ul>
         * <p>
         * The default mode is set to <code>HOST_ONLY</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWebCrawlerMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WebCrawlerSeedUrlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebCrawlerSeedUrlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebCrawlerSeedUrlConfigurationProperty> {
            java.util.List<java.lang.String> seedUrls;
            java.lang.String webCrawlerMode;

            /**
             * Sets the value of {@link WebCrawlerSeedUrlConfigurationProperty#getSeedUrls}
             * @param seedUrls The list of seed or starting point URLs of the websites you want to crawl. This parameter is required.
             *                 The list can include a maximum of 100 seed URLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder seedUrls(java.util.List<java.lang.String> seedUrls) {
                this.seedUrls = seedUrls;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerSeedUrlConfigurationProperty#getWebCrawlerMode}
             * @param webCrawlerMode You can choose one of the following modes:.
             *                       <ul>
             *                       <li><code>HOST_ONLY</code> – crawl only the website host names. For example, if the seed URL is "abc.example.com", then only URLs with host name "abc.example.com" are crawled.</li>
             *                       <li><code>SUBDOMAINS</code> – crawl the website host names with subdomains. For example, if the seed URL is "abc.example.com", then "a.abc.example.com" and "b.abc.example.com" are also crawled.</li>
             *                       <li><code>EVERYTHING</code> – crawl the website host names with subdomains and other domains that the webpages link to.</li>
             *                       </ul>
             *                       <p>
             *                       The default mode is set to <code>HOST_ONLY</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webCrawlerMode(java.lang.String webCrawlerMode) {
                this.webCrawlerMode = webCrawlerMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebCrawlerSeedUrlConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebCrawlerSeedUrlConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebCrawlerSeedUrlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebCrawlerSeedUrlConfigurationProperty {
            private final java.util.List<java.lang.String> seedUrls;
            private final java.lang.String webCrawlerMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.seedUrls = software.amazon.jsii.Kernel.get(this, "seedUrls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.webCrawlerMode = software.amazon.jsii.Kernel.get(this, "webCrawlerMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.seedUrls = java.util.Objects.requireNonNull(builder.seedUrls, "seedUrls is required");
                this.webCrawlerMode = builder.webCrawlerMode;
            }

            @Override
            public final java.util.List<java.lang.String> getSeedUrls() {
                return this.seedUrls;
            }

            @Override
            public final java.lang.String getWebCrawlerMode() {
                return this.webCrawlerMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("seedUrls", om.valueToTree(this.getSeedUrls()));
                if (this.getWebCrawlerMode() != null) {
                    data.set("webCrawlerMode", om.valueToTree(this.getWebCrawlerMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerSeedUrlConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebCrawlerSeedUrlConfigurationProperty.Jsii$Proxy that = (WebCrawlerSeedUrlConfigurationProperty.Jsii$Proxy) o;

                if (!seedUrls.equals(that.seedUrls)) return false;
                return this.webCrawlerMode != null ? this.webCrawlerMode.equals(that.webCrawlerMode) : that.webCrawlerMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.seedUrls.hashCode();
                result = 31 * result + (this.webCrawlerMode != null ? this.webCrawlerMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information of the sitemap URLs to crawl.
     * <p>
     * <em>When selecting websites to index, you must adhere to the <a href="https://docs.aws.amazon.com/aup/">Amazon Acceptable Use Policy</a> and all other Amazon terms. Remember that you must only use the Amazon Kendra web crawler to index your own webpages, or webpages that you have authorization to index.</em>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * WebCrawlerSiteMapsConfigurationProperty webCrawlerSiteMapsConfigurationProperty = WebCrawlerSiteMapsConfigurationProperty.builder()
     *         .siteMaps(List.of("siteMaps"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerSiteMapsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WebCrawlerSiteMapsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebCrawlerSiteMapsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of sitemap URLs of the websites you want to crawl.
         * <p>
         * The list can include a maximum of three sitemap URLs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSiteMaps();

        /**
         * @return a {@link Builder} of {@link WebCrawlerSiteMapsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebCrawlerSiteMapsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebCrawlerSiteMapsConfigurationProperty> {
            java.util.List<java.lang.String> siteMaps;

            /**
             * Sets the value of {@link WebCrawlerSiteMapsConfigurationProperty#getSiteMaps}
             * @param siteMaps The list of sitemap URLs of the websites you want to crawl. This parameter is required.
             *                 The list can include a maximum of three sitemap URLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder siteMaps(java.util.List<java.lang.String> siteMaps) {
                this.siteMaps = siteMaps;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebCrawlerSiteMapsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebCrawlerSiteMapsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebCrawlerSiteMapsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebCrawlerSiteMapsConfigurationProperty {
            private final java.util.List<java.lang.String> siteMaps;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.siteMaps = software.amazon.jsii.Kernel.get(this, "siteMaps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.siteMaps = java.util.Objects.requireNonNull(builder.siteMaps, "siteMaps is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSiteMaps() {
                return this.siteMaps;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("siteMaps", om.valueToTree(this.getSiteMaps()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerSiteMapsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebCrawlerSiteMapsConfigurationProperty.Jsii$Proxy that = (WebCrawlerSiteMapsConfigurationProperty.Jsii$Proxy) o;

                return this.siteMaps.equals(that.siteMaps);
            }

            @Override
            public final int hashCode() {
                int result = this.siteMaps.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl.
     * <p>
     * You can include website subdomains. You can list up to 100 seed URLs and up to three sitemap URLs.
     * <p>
     * You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling.
     * <p>
     * <em>When selecting websites to index, you must adhere to the <a href="https://docs.aws.amazon.com/aup/">Amazon Acceptable Use Policy</a> and all other Amazon terms. Remember that you must only use the Amazon Kendra web crawler to index your own webpages, or webpages that you have authorization to index.</em>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * WebCrawlerUrlsProperty webCrawlerUrlsProperty = WebCrawlerUrlsProperty.builder()
     *         .seedUrlConfiguration(WebCrawlerSeedUrlConfigurationProperty.builder()
     *                 .seedUrls(List.of("seedUrls"))
     *                 // the properties below are optional
     *                 .webCrawlerMode("webCrawlerMode")
     *                 .build())
     *         .siteMapsConfiguration(WebCrawlerSiteMapsConfigurationProperty.builder()
     *                 .siteMaps(List.of("siteMaps"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerUrlsProperty")
    @software.amazon.jsii.Jsii.Proxy(WebCrawlerUrlsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebCrawlerUrlsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration of the seed or starting point URLs of the websites you want to crawl.
         * <p>
         * You can choose to crawl only the website host names, or the website host names with subdomains, or the website host names with subdomains and other domains that the webpages link to.
         * <p>
         * You can list up to 100 seed URLs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSeedUrlConfiguration() {
            return null;
        }

        /**
         * Configuration of the sitemap URLs of the websites you want to crawl.
         * <p>
         * Only URLs belonging to the same website host names are crawled. You can list up to three sitemap URLs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSiteMapsConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WebCrawlerUrlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebCrawlerUrlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebCrawlerUrlsProperty> {
            java.lang.Object seedUrlConfiguration;
            java.lang.Object siteMapsConfiguration;

            /**
             * Sets the value of {@link WebCrawlerUrlsProperty#getSeedUrlConfiguration}
             * @param seedUrlConfiguration Configuration of the seed or starting point URLs of the websites you want to crawl.
             *                             You can choose to crawl only the website host names, or the website host names with subdomains, or the website host names with subdomains and other domains that the webpages link to.
             *                             <p>
             *                             You can list up to 100 seed URLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder seedUrlConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.WebCrawlerSeedUrlConfigurationProperty seedUrlConfiguration) {
                this.seedUrlConfiguration = seedUrlConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerUrlsProperty#getSeedUrlConfiguration}
             * @param seedUrlConfiguration Configuration of the seed or starting point URLs of the websites you want to crawl.
             *                             You can choose to crawl only the website host names, or the website host names with subdomains, or the website host names with subdomains and other domains that the webpages link to.
             *                             <p>
             *                             You can list up to 100 seed URLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder seedUrlConfiguration(software.amazon.awscdk.IResolvable seedUrlConfiguration) {
                this.seedUrlConfiguration = seedUrlConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerUrlsProperty#getSiteMapsConfiguration}
             * @param siteMapsConfiguration Configuration of the sitemap URLs of the websites you want to crawl.
             *                              Only URLs belonging to the same website host names are crawled. You can list up to three sitemap URLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder siteMapsConfiguration(software.amazon.awscdk.services.kendra.CfnDataSource.WebCrawlerSiteMapsConfigurationProperty siteMapsConfiguration) {
                this.siteMapsConfiguration = siteMapsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WebCrawlerUrlsProperty#getSiteMapsConfiguration}
             * @param siteMapsConfiguration Configuration of the sitemap URLs of the websites you want to crawl.
             *                              Only URLs belonging to the same website host names are crawled. You can list up to three sitemap URLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder siteMapsConfiguration(software.amazon.awscdk.IResolvable siteMapsConfiguration) {
                this.siteMapsConfiguration = siteMapsConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebCrawlerUrlsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebCrawlerUrlsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebCrawlerUrlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebCrawlerUrlsProperty {
            private final java.lang.Object seedUrlConfiguration;
            private final java.lang.Object siteMapsConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.seedUrlConfiguration = software.amazon.jsii.Kernel.get(this, "seedUrlConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.siteMapsConfiguration = software.amazon.jsii.Kernel.get(this, "siteMapsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.seedUrlConfiguration = builder.seedUrlConfiguration;
                this.siteMapsConfiguration = builder.siteMapsConfiguration;
            }

            @Override
            public final java.lang.Object getSeedUrlConfiguration() {
                return this.seedUrlConfiguration;
            }

            @Override
            public final java.lang.Object getSiteMapsConfiguration() {
                return this.siteMapsConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSeedUrlConfiguration() != null) {
                    data.set("seedUrlConfiguration", om.valueToTree(this.getSeedUrlConfiguration()));
                }
                if (this.getSiteMapsConfiguration() != null) {
                    data.set("siteMapsConfiguration", om.valueToTree(this.getSiteMapsConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.WebCrawlerUrlsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebCrawlerUrlsProperty.Jsii$Proxy that = (WebCrawlerUrlsProperty.Jsii$Proxy) o;

                if (this.seedUrlConfiguration != null ? !this.seedUrlConfiguration.equals(that.seedUrlConfiguration) : that.seedUrlConfiguration != null) return false;
                return this.siteMapsConfiguration != null ? this.siteMapsConfiguration.equals(that.siteMapsConfiguration) : that.siteMapsConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.seedUrlConfiguration != null ? this.seedUrlConfiguration.hashCode() : 0;
                result = 31 * result + (this.siteMapsConfiguration != null ? this.siteMapsConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides the configuration information to connect to Amazon WorkDocs as your data source.
     * <p>
     * Amazon WorkDocs connector is available in Oregon, North Virginia, Sydney, Singapore and Ireland regions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kendra.*;
     * WorkDocsConfigurationProperty workDocsConfigurationProperty = WorkDocsConfigurationProperty.builder()
     *         .organizationId("organizationId")
     *         // the properties below are optional
     *         .crawlComments(false)
     *         .exclusionPatterns(List.of("exclusionPatterns"))
     *         .fieldMappings(List.of(DataSourceToIndexFieldMappingProperty.builder()
     *                 .dataSourceFieldName("dataSourceFieldName")
     *                 .indexFieldName("indexFieldName")
     *                 // the properties below are optional
     *                 .dateFieldFormat("dateFieldFormat")
     *                 .build()))
     *         .inclusionPatterns(List.of("inclusionPatterns"))
     *         .useChangeLog(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kendra.CfnDataSource.WorkDocsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkDocsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkDocsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the directory corresponding to your Amazon WorkDocs site repository.
         * <p>
         * You can find the organization ID in the <a href="https://docs.aws.amazon.com/directoryservicev2/">AWS Directory Service</a> by going to <em>Active Directory</em> , then <em>Directories</em> . Your Amazon WorkDocs site directory has an ID, which is the organization ID. You can also set up a new Amazon WorkDocs directory in the AWS Directory Service console and enable a Amazon WorkDocs site for the directory in the Amazon WorkDocs console.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOrganizationId();

        /**
         * `TRUE` to include comments on documents in your index.
         * <p>
         * Including comments in your index means each comment is a document that can be searched on.
         * <p>
         * The default is set to <code>FALSE</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCrawlComments() {
            return null;
        }

        /**
         * A list of regular expression patterns to exclude certain files in your Amazon WorkDocs site repository.
         * <p>
         * Files that match the patterns are excluded from the index. Files that don’t match the patterns are included in the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclusionPatterns() {
            return null;
        }

        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map Amazon WorkDocs data source attributes or field names to Amazon Kendra index field names.
         * <p>
         * To create custom fields, use the <code>UpdateIndex</code> API before you map to Amazon WorkDocs fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Amazon WorkDocs data source field names must exist in your Amazon WorkDocs custom metadata.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFieldMappings() {
            return null;
        }

        /**
         * A list of regular expression patterns to include certain files in your Amazon WorkDocs site repository.
         * <p>
         * Files that match the patterns are included in the index. Files that don't match the patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclusionPatterns() {
            return null;
        }

        /**
         * `TRUE` to use the Amazon WorkDocs change log to determine which documents require updating in the index.
         * <p>
         * Depending on the change log's size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in Amazon WorkDocs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseChangeLog() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkDocsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkDocsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkDocsConfigurationProperty> {
            java.lang.String organizationId;
            java.lang.Object crawlComments;
            java.util.List<java.lang.String> exclusionPatterns;
            java.lang.Object fieldMappings;
            java.util.List<java.lang.String> inclusionPatterns;
            java.lang.Object useChangeLog;

            /**
             * Sets the value of {@link WorkDocsConfigurationProperty#getOrganizationId}
             * @param organizationId The identifier of the directory corresponding to your Amazon WorkDocs site repository. This parameter is required.
             *                       You can find the organization ID in the <a href="https://docs.aws.amazon.com/directoryservicev2/">AWS Directory Service</a> by going to <em>Active Directory</em> , then <em>Directories</em> . Your Amazon WorkDocs site directory has an ID, which is the organization ID. You can also set up a new Amazon WorkDocs directory in the AWS Directory Service console and enable a Amazon WorkDocs site for the directory in the Amazon WorkDocs console.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationId(java.lang.String organizationId) {
                this.organizationId = organizationId;
                return this;
            }

            /**
             * Sets the value of {@link WorkDocsConfigurationProperty#getCrawlComments}
             * @param crawlComments `TRUE` to include comments on documents in your index.
             *                      Including comments in your index means each comment is a document that can be searched on.
             *                      <p>
             *                      The default is set to <code>FALSE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlComments(java.lang.Boolean crawlComments) {
                this.crawlComments = crawlComments;
                return this;
            }

            /**
             * Sets the value of {@link WorkDocsConfigurationProperty#getCrawlComments}
             * @param crawlComments `TRUE` to include comments on documents in your index.
             *                      Including comments in your index means each comment is a document that can be searched on.
             *                      <p>
             *                      The default is set to <code>FALSE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crawlComments(software.amazon.awscdk.IResolvable crawlComments) {
                this.crawlComments = crawlComments;
                return this;
            }

            /**
             * Sets the value of {@link WorkDocsConfigurationProperty#getExclusionPatterns}
             * @param exclusionPatterns A list of regular expression patterns to exclude certain files in your Amazon WorkDocs site repository.
             *                          Files that match the patterns are excluded from the index. Files that don’t match the patterns are included in the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusionPatterns(java.util.List<java.lang.String> exclusionPatterns) {
                this.exclusionPatterns = exclusionPatterns;
                return this;
            }

            /**
             * Sets the value of {@link WorkDocsConfigurationProperty#getFieldMappings}
             * @param fieldMappings A list of `DataSourceToIndexFieldMapping` objects that map Amazon WorkDocs data source attributes or field names to Amazon Kendra index field names.
             *                      To create custom fields, use the <code>UpdateIndex</code> API before you map to Amazon WorkDocs fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Amazon WorkDocs data source field names must exist in your Amazon WorkDocs custom metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(software.amazon.awscdk.IResolvable fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link WorkDocsConfigurationProperty#getFieldMappings}
             * @param fieldMappings A list of `DataSourceToIndexFieldMapping` objects that map Amazon WorkDocs data source attributes or field names to Amazon Kendra index field names.
             *                      To create custom fields, use the <code>UpdateIndex</code> API before you map to Amazon WorkDocs fields. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields</a> . The Amazon WorkDocs data source field names must exist in your Amazon WorkDocs custom metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldMappings(java.util.List<? extends java.lang.Object> fieldMappings) {
                this.fieldMappings = fieldMappings;
                return this;
            }

            /**
             * Sets the value of {@link WorkDocsConfigurationProperty#getInclusionPatterns}
             * @param inclusionPatterns A list of regular expression patterns to include certain files in your Amazon WorkDocs site repository.
             *                          Files that match the patterns are included in the index. Files that don't match the patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusionPatterns(java.util.List<java.lang.String> inclusionPatterns) {
                this.inclusionPatterns = inclusionPatterns;
                return this;
            }

            /**
             * Sets the value of {@link WorkDocsConfigurationProperty#getUseChangeLog}
             * @param useChangeLog `TRUE` to use the Amazon WorkDocs change log to determine which documents require updating in the index.
             *                     Depending on the change log's size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in Amazon WorkDocs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useChangeLog(java.lang.Boolean useChangeLog) {
                this.useChangeLog = useChangeLog;
                return this;
            }

            /**
             * Sets the value of {@link WorkDocsConfigurationProperty#getUseChangeLog}
             * @param useChangeLog `TRUE` to use the Amazon WorkDocs change log to determine which documents require updating in the index.
             *                     Depending on the change log's size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in Amazon WorkDocs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useChangeLog(software.amazon.awscdk.IResolvable useChangeLog) {
                this.useChangeLog = useChangeLog;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkDocsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkDocsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkDocsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkDocsConfigurationProperty {
            private final java.lang.String organizationId;
            private final java.lang.Object crawlComments;
            private final java.util.List<java.lang.String> exclusionPatterns;
            private final java.lang.Object fieldMappings;
            private final java.util.List<java.lang.String> inclusionPatterns;
            private final java.lang.Object useChangeLog;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.organizationId = software.amazon.jsii.Kernel.get(this, "organizationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.crawlComments = software.amazon.jsii.Kernel.get(this, "crawlComments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.exclusionPatterns = software.amazon.jsii.Kernel.get(this, "exclusionPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.fieldMappings = software.amazon.jsii.Kernel.get(this, "fieldMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inclusionPatterns = software.amazon.jsii.Kernel.get(this, "inclusionPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.useChangeLog = software.amazon.jsii.Kernel.get(this, "useChangeLog", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.organizationId = java.util.Objects.requireNonNull(builder.organizationId, "organizationId is required");
                this.crawlComments = builder.crawlComments;
                this.exclusionPatterns = builder.exclusionPatterns;
                this.fieldMappings = builder.fieldMappings;
                this.inclusionPatterns = builder.inclusionPatterns;
                this.useChangeLog = builder.useChangeLog;
            }

            @Override
            public final java.lang.String getOrganizationId() {
                return this.organizationId;
            }

            @Override
            public final java.lang.Object getCrawlComments() {
                return this.crawlComments;
            }

            @Override
            public final java.util.List<java.lang.String> getExclusionPatterns() {
                return this.exclusionPatterns;
            }

            @Override
            public final java.lang.Object getFieldMappings() {
                return this.fieldMappings;
            }

            @Override
            public final java.util.List<java.lang.String> getInclusionPatterns() {
                return this.inclusionPatterns;
            }

            @Override
            public final java.lang.Object getUseChangeLog() {
                return this.useChangeLog;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("organizationId", om.valueToTree(this.getOrganizationId()));
                if (this.getCrawlComments() != null) {
                    data.set("crawlComments", om.valueToTree(this.getCrawlComments()));
                }
                if (this.getExclusionPatterns() != null) {
                    data.set("exclusionPatterns", om.valueToTree(this.getExclusionPatterns()));
                }
                if (this.getFieldMappings() != null) {
                    data.set("fieldMappings", om.valueToTree(this.getFieldMappings()));
                }
                if (this.getInclusionPatterns() != null) {
                    data.set("inclusionPatterns", om.valueToTree(this.getInclusionPatterns()));
                }
                if (this.getUseChangeLog() != null) {
                    data.set("useChangeLog", om.valueToTree(this.getUseChangeLog()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kendra.CfnDataSource.WorkDocsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkDocsConfigurationProperty.Jsii$Proxy that = (WorkDocsConfigurationProperty.Jsii$Proxy) o;

                if (!organizationId.equals(that.organizationId)) return false;
                if (this.crawlComments != null ? !this.crawlComments.equals(that.crawlComments) : that.crawlComments != null) return false;
                if (this.exclusionPatterns != null ? !this.exclusionPatterns.equals(that.exclusionPatterns) : that.exclusionPatterns != null) return false;
                if (this.fieldMappings != null ? !this.fieldMappings.equals(that.fieldMappings) : that.fieldMappings != null) return false;
                if (this.inclusionPatterns != null ? !this.inclusionPatterns.equals(that.inclusionPatterns) : that.inclusionPatterns != null) return false;
                return this.useChangeLog != null ? this.useChangeLog.equals(that.useChangeLog) : that.useChangeLog == null;
            }

            @Override
            public final int hashCode() {
                int result = this.organizationId.hashCode();
                result = 31 * result + (this.crawlComments != null ? this.crawlComments.hashCode() : 0);
                result = 31 * result + (this.exclusionPatterns != null ? this.exclusionPatterns.hashCode() : 0);
                result = 31 * result + (this.fieldMappings != null ? this.fieldMappings.hashCode() : 0);
                result = 31 * result + (this.inclusionPatterns != null ? this.inclusionPatterns.hashCode() : 0);
                result = 31 * result + (this.useChangeLog != null ? this.useChangeLog.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.kendra.CfnDataSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.kendra.CfnDataSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.kendra.CfnDataSourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.kendra.CfnDataSourceProps.Builder();
        }

        /**
         * The identifier of the index that should be associated with this data source.
         * <p>
         * @return {@code this}
         * @param indexId The identifier of the index that should be associated with this data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexId(final java.lang.String indexId) {
            this.props.indexId(indexId);
            return this;
        }

        /**
         * The name of the data source.
         * <p>
         * @return {@code this}
         * @param name The name of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The type of the data source.
         * <p>
         * @return {@code this}
         * @param type The type of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * Configuration information for altering document metadata and content during the document ingestion process.
         * <p>
         * @return {@code this}
         * @param customDocumentEnrichmentConfiguration Configuration information for altering document metadata and content during the document ingestion process. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDocumentEnrichmentConfiguration(final software.amazon.awscdk.services.kendra.CfnDataSource.CustomDocumentEnrichmentConfigurationProperty customDocumentEnrichmentConfiguration) {
            this.props.customDocumentEnrichmentConfiguration(customDocumentEnrichmentConfiguration);
            return this;
        }
        /**
         * Configuration information for altering document metadata and content during the document ingestion process.
         * <p>
         * @return {@code this}
         * @param customDocumentEnrichmentConfiguration Configuration information for altering document metadata and content during the document ingestion process. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDocumentEnrichmentConfiguration(final software.amazon.awscdk.IResolvable customDocumentEnrichmentConfiguration) {
            this.props.customDocumentEnrichmentConfiguration(customDocumentEnrichmentConfiguration);
            return this;
        }

        /**
         * Configuration information for an Amazon Kendra data source.
         * <p>
         * The contents of the configuration depend on the type of data source. You can only specify one type of data source in the configuration. Choose from one of the following data sources.
         * <p>
         * <ul>
         * <li>Amazon S3</li>
         * <li>Confluence</li>
         * <li>Custom</li>
         * <li>Database</li>
         * <li>Microsoft OneDrive</li>
         * <li>Microsoft SharePoint</li>
         * <li>Salesforce</li>
         * <li>ServiceNow</li>
         * </ul>
         * <p>
         * You can't specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code> .
         * <p>
         * The <code>Configuration</code> parameter is required for all other data sources.
         * <p>
         * @return {@code this}
         * @param dataSourceConfiguration Configuration information for an Amazon Kendra data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceConfiguration(final software.amazon.awscdk.services.kendra.CfnDataSource.DataSourceConfigurationProperty dataSourceConfiguration) {
            this.props.dataSourceConfiguration(dataSourceConfiguration);
            return this;
        }
        /**
         * Configuration information for an Amazon Kendra data source.
         * <p>
         * The contents of the configuration depend on the type of data source. You can only specify one type of data source in the configuration. Choose from one of the following data sources.
         * <p>
         * <ul>
         * <li>Amazon S3</li>
         * <li>Confluence</li>
         * <li>Custom</li>
         * <li>Database</li>
         * <li>Microsoft OneDrive</li>
         * <li>Microsoft SharePoint</li>
         * <li>Salesforce</li>
         * <li>ServiceNow</li>
         * </ul>
         * <p>
         * You can't specify the <code>Configuration</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code> .
         * <p>
         * The <code>Configuration</code> parameter is required for all other data sources.
         * <p>
         * @return {@code this}
         * @param dataSourceConfiguration Configuration information for an Amazon Kendra data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceConfiguration(final software.amazon.awscdk.IResolvable dataSourceConfiguration) {
            this.props.dataSourceConfiguration(dataSourceConfiguration);
            return this;
        }

        /**
         * A description of the data source.
         * <p>
         * @return {@code this}
         * @param description A description of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of a role with permission to access the data source.
         * <p>
         * You can't specify the <code>RoleArn</code> parameter when the <code>Type</code> parameter is set to <code>CUSTOM</code> .
         * <p>
         * The <code>RoleArn</code> parameter is required for all other data sources.
         * <p>
         * @return {@code this}
         * @param roleArn The Amazon Resource Name (ARN) of a role with permission to access the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * Sets the frequency that Amazon Kendra checks the documents in your data source and updates the index.
         * <p>
         * If you don't set a schedule, Amazon Kendra doesn't periodically update the index.
         * <p>
         * @return {@code this}
         * @param schedule Sets the frequency that Amazon Kendra checks the documents in your data source and updates the index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final java.lang.String schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.kendra.CfnDataSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.kendra.CfnDataSource build() {
            return new software.amazon.awscdk.services.kendra.CfnDataSource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
