package software.amazon.awscdk.services.greengrass;

/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinition`.
 * <p>
 * The <code>AWS::Greengrass::FunctionDefinition</code> resource represents a function definition for AWS IoT Greengrass . Function definitions are used to organize your function definition versions.
 * <p>
 * Function definitions can reference multiple function definition versions. All function definition versions must be associated with a function definition. Each function definition version can contain one or more functions.
 * <p>
 * <blockquote>
 * <p>
 * When you create a function definition, you can optionally include an initial function definition version. To associate a function definition version later, create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html"><code>AWS::Greengrass::FunctionDefinitionVersion</code></a> resource and specify the ID of this function definition.
 * <p>
 * After you create the function definition version that contains the functions you want to deploy, you must add it to your group version. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html"><code>AWS::Greengrass::Group</code></a> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * Object tags;
 * Object variables;
 * CfnFunctionDefinition cfnFunctionDefinition = CfnFunctionDefinition.Builder.create(this, "MyCfnFunctionDefinition")
 *         .name("name")
 *         // the properties below are optional
 *         .initialVersion(FunctionDefinitionVersionProperty.builder()
 *                 .functions(List.of(FunctionProperty.builder()
 *                         .functionArn("functionArn")
 *                         .functionConfiguration(FunctionConfigurationProperty.builder()
 *                                 .encodingType("encodingType")
 *                                 .environment(EnvironmentProperty.builder()
 *                                         .accessSysfs(false)
 *                                         .execution(ExecutionProperty.builder()
 *                                                 .isolationMode("isolationMode")
 *                                                 .runAs(RunAsProperty.builder()
 *                                                         .gid(123)
 *                                                         .uid(123)
 *                                                         .build())
 *                                                 .build())
 *                                         .resourceAccessPolicies(List.of(ResourceAccessPolicyProperty.builder()
 *                                                 .resourceId("resourceId")
 *                                                 // the properties below are optional
 *                                                 .permission("permission")
 *                                                 .build()))
 *                                         .variables(variables)
 *                                         .build())
 *                                 .execArgs("execArgs")
 *                                 .executable("executable")
 *                                 .memorySize(123)
 *                                 .pinned(false)
 *                                 .timeout(123)
 *                                 .build())
 *                         .id("id")
 *                         .build()))
 *                 // the properties below are optional
 *                 .defaultConfig(DefaultConfigProperty.builder()
 *                         .execution(ExecutionProperty.builder()
 *                                 .isolationMode("isolationMode")
 *                                 .runAs(RunAsProperty.builder()
 *                                         .gid(123)
 *                                         .uid(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .tags(tags)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:51.904Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinition")
public class CfnFunctionDefinition extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnFunctionDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFunctionDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.greengrass.CfnFunctionDefinition.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Greengrass::FunctionDefinition`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFunctionDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the `FunctionDefinition` , such as `arn:aws:greengrass:us-east-1:  :/greengrass/definition/functions/1234a5b6-78cd-901e-2fgh-3i45j6k178l9` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the `FunctionDefinition` , such as `1234a5b6-78cd-901e-2fgh-3i45j6k178l9` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the last `FunctionDefinitionVersion` that was added to the `FunctionDefinition` , such as `arn:aws:greengrass:us-east-1:  :/greengrass/definition/functions/1234a5b6-78cd-901e-2fgh-3i45j6k178l9/versions/9876ac30-4bdb-4f9d-95af-b5fdb66be1a2` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLatestVersionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrLatestVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the `FunctionDefinition` , such as `MyFunctionDefinition` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Application-specific metadata to attach to the function definition.
     * <p>
     * You can use tags in IAM policies to control access to AWS IoT Greengrass resources. You can also use tags to categorize your resources. For more information, see <a href="https://docs.aws.amazon.com/greengrass/latest/developerguide/tagging.html">Tagging Your AWS IoT Greengrass Resources</a> in the <em>Developer Guide</em> .
     * <p>
     * This <code>Json</code> property type is processed as a map of key-value pairs. It uses the following format, which is different from most <code>Tags</code> implementations in AWS CloudFormation templates.
     * <p>
     * <blockquote><pre>
     * "Tags": { "KeyName0": "value", "KeyName1": "value", "KeyName2": "value"
     * }
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the function definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the function definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The function definition version to include when the function definition is created.
     * <p>
     * A function definition version contains a list of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-function.html"><code>function</code></a> property types.
     * <p>
     * <blockquote>
     * <p>
     * To associate a function definition version after the function definition is created, create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html"><code>AWS::Greengrass::FunctionDefinitionVersion</code></a> resource and specify the ID of this function definition.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInitialVersion() {
        return software.amazon.jsii.Kernel.get(this, "initialVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The function definition version to include when the function definition is created.
     * <p>
     * A function definition version contains a list of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-function.html"><code>function</code></a> property types.
     * <p>
     * <blockquote>
     * <p>
     * To associate a function definition version after the function definition is created, create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html"><code>AWS::Greengrass::FunctionDefinitionVersion</code></a> resource and specify the ID of this function definition.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInitialVersion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.greengrass.CfnFunctionDefinition.FunctionDefinitionVersionProperty value) {
        software.amazon.jsii.Kernel.set(this, "initialVersion", value);
    }

    /**
     * The function definition version to include when the function definition is created.
     * <p>
     * A function definition version contains a list of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-function.html"><code>function</code></a> property types.
     * <p>
     * <blockquote>
     * <p>
     * To associate a function definition version after the function definition is created, create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html"><code>AWS::Greengrass::FunctionDefinitionVersion</code></a> resource and specify the ID of this function definition.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInitialVersion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "initialVersion", value);
    }
    /**
     * The default configuration that applies to all Lambda functions in the function definition version.
     * <p>
     * Individual Lambda functions can override these settings.
     * <p>
     * In an AWS CloudFormation template, <code>DefaultConfig</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functiondefinitionversion.html"><code>FunctionDefinitionVersion</code></a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * DefaultConfigProperty defaultConfigProperty = DefaultConfigProperty.builder()
     *         .execution(ExecutionProperty.builder()
     *                 .isolationMode("isolationMode")
     *                 .runAs(RunAsProperty.builder()
     *                         .gid(123)
     *                         .uid(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinition.DefaultConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration settings for the Lambda execution environment on the AWS IoT Greengrass core.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getExecution();

        /**
         * @return a {@link Builder} of {@link DefaultConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultConfigProperty> {
            java.lang.Object execution;

            /**
             * Sets the value of {@link DefaultConfigProperty#getExecution}
             * @param execution Configuration settings for the Lambda execution environment on the AWS IoT Greengrass core. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder execution(software.amazon.awscdk.services.greengrass.CfnFunctionDefinition.ExecutionProperty execution) {
                this.execution = execution;
                return this;
            }

            /**
             * Sets the value of {@link DefaultConfigProperty#getExecution}
             * @param execution Configuration settings for the Lambda execution environment on the AWS IoT Greengrass core. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder execution(software.amazon.awscdk.IResolvable execution) {
                this.execution = execution;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefaultConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultConfigProperty {
            private final java.lang.Object execution;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.execution = software.amazon.jsii.Kernel.get(this, "execution", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.execution = java.util.Objects.requireNonNull(builder.execution, "execution is required");
            }

            @Override
            public final java.lang.Object getExecution() {
                return this.execution;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("execution", om.valueToTree(this.getExecution()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnFunctionDefinition.DefaultConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultConfigProperty.Jsii$Proxy that = (DefaultConfigProperty.Jsii$Proxy) o;

                return this.execution.equals(that.execution);
            }

            @Override
            public final int hashCode() {
                int result = this.execution.hashCode();
                return result;
            }
        }
    }
    /**
     * The environment configuration for a Lambda function on the AWS IoT Greengrass core.
     * <p>
     * In an AWS CloudFormation template, <code>Environment</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functionconfiguration.html"><code>FunctionConfiguration</code></a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * Object variables;
     * EnvironmentProperty environmentProperty = EnvironmentProperty.builder()
     *         .accessSysfs(false)
     *         .execution(ExecutionProperty.builder()
     *                 .isolationMode("isolationMode")
     *                 .runAs(RunAsProperty.builder()
     *                         .gid(123)
     *                         .uid(123)
     *                         .build())
     *                 .build())
     *         .resourceAccessPolicies(List.of(ResourceAccessPolicyProperty.builder()
     *                 .resourceId("resourceId")
     *                 // the properties below are optional
     *                 .permission("permission")
     *                 .build()))
     *         .variables(variables)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinition.EnvironmentProperty")
    @software.amazon.jsii.Jsii.Proxy(EnvironmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnvironmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the function is allowed to access the `/sys` directory on the core device, which allows the read device information from `/sys` .
         * <p>
         * <blockquote>
         * <p>
         * This property applies only to Lambda functions that run in a Greengrass container.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAccessSysfs() {
            return null;
        }

        /**
         * Settings for the Lambda execution environment in AWS IoT Greengrass .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExecution() {
            return null;
        }

        /**
         * A list of the [resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html) in the group that the function can access, with the corresponding read-only or read-write permissions. The maximum is 10 resources.
         * <p>
         * <blockquote>
         * <p>
         * This property applies only for Lambda functions that run in a Greengrass container.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAccessPolicies() {
            return null;
        }

        /**
         * Environment variables for the Lambda function.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVariables() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnvironmentProperty> {
            java.lang.Object accessSysfs;
            java.lang.Object execution;
            java.lang.Object resourceAccessPolicies;
            java.lang.Object variables;

            /**
             * Sets the value of {@link EnvironmentProperty#getAccessSysfs}
             * @param accessSysfs Indicates whether the function is allowed to access the `/sys` directory on the core device, which allows the read device information from `/sys` .
             *                    <blockquote>
             *                    <p>
             *                    This property applies only to Lambda functions that run in a Greengrass container.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessSysfs(java.lang.Boolean accessSysfs) {
                this.accessSysfs = accessSysfs;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getAccessSysfs}
             * @param accessSysfs Indicates whether the function is allowed to access the `/sys` directory on the core device, which allows the read device information from `/sys` .
             *                    <blockquote>
             *                    <p>
             *                    This property applies only to Lambda functions that run in a Greengrass container.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessSysfs(software.amazon.awscdk.IResolvable accessSysfs) {
                this.accessSysfs = accessSysfs;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getExecution}
             * @param execution Settings for the Lambda execution environment in AWS IoT Greengrass .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder execution(software.amazon.awscdk.services.greengrass.CfnFunctionDefinition.ExecutionProperty execution) {
                this.execution = execution;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getExecution}
             * @param execution Settings for the Lambda execution environment in AWS IoT Greengrass .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder execution(software.amazon.awscdk.IResolvable execution) {
                this.execution = execution;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getResourceAccessPolicies}
             * @param resourceAccessPolicies A list of the [resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html) in the group that the function can access, with the corresponding read-only or read-write permissions. The maximum is 10 resources.
             *                               <blockquote>
             *                               <p>
             *                               This property applies only for Lambda functions that run in a Greengrass container.
             *                               <p>
             *                               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAccessPolicies(software.amazon.awscdk.IResolvable resourceAccessPolicies) {
                this.resourceAccessPolicies = resourceAccessPolicies;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getResourceAccessPolicies}
             * @param resourceAccessPolicies A list of the [resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html) in the group that the function can access, with the corresponding read-only or read-write permissions. The maximum is 10 resources.
             *                               <blockquote>
             *                               <p>
             *                               This property applies only for Lambda functions that run in a Greengrass container.
             *                               <p>
             *                               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAccessPolicies(java.util.List<? extends java.lang.Object> resourceAccessPolicies) {
                this.resourceAccessPolicies = resourceAccessPolicies;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getVariables}
             * @param variables Environment variables for the Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(java.lang.Object variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnvironmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentProperty {
            private final java.lang.Object accessSysfs;
            private final java.lang.Object execution;
            private final java.lang.Object resourceAccessPolicies;
            private final java.lang.Object variables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessSysfs = software.amazon.jsii.Kernel.get(this, "accessSysfs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.execution = software.amazon.jsii.Kernel.get(this, "execution", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAccessPolicies = software.amazon.jsii.Kernel.get(this, "resourceAccessPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.variables = software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessSysfs = builder.accessSysfs;
                this.execution = builder.execution;
                this.resourceAccessPolicies = builder.resourceAccessPolicies;
                this.variables = builder.variables;
            }

            @Override
            public final java.lang.Object getAccessSysfs() {
                return this.accessSysfs;
            }

            @Override
            public final java.lang.Object getExecution() {
                return this.execution;
            }

            @Override
            public final java.lang.Object getResourceAccessPolicies() {
                return this.resourceAccessPolicies;
            }

            @Override
            public final java.lang.Object getVariables() {
                return this.variables;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessSysfs() != null) {
                    data.set("accessSysfs", om.valueToTree(this.getAccessSysfs()));
                }
                if (this.getExecution() != null) {
                    data.set("execution", om.valueToTree(this.getExecution()));
                }
                if (this.getResourceAccessPolicies() != null) {
                    data.set("resourceAccessPolicies", om.valueToTree(this.getResourceAccessPolicies()));
                }
                if (this.getVariables() != null) {
                    data.set("variables", om.valueToTree(this.getVariables()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnFunctionDefinition.EnvironmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnvironmentProperty.Jsii$Proxy that = (EnvironmentProperty.Jsii$Proxy) o;

                if (this.accessSysfs != null ? !this.accessSysfs.equals(that.accessSysfs) : that.accessSysfs != null) return false;
                if (this.execution != null ? !this.execution.equals(that.execution) : that.execution != null) return false;
                if (this.resourceAccessPolicies != null ? !this.resourceAccessPolicies.equals(that.resourceAccessPolicies) : that.resourceAccessPolicies != null) return false;
                return this.variables != null ? this.variables.equals(that.variables) : that.variables == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessSysfs != null ? this.accessSysfs.hashCode() : 0;
                result = 31 * result + (this.execution != null ? this.execution.hashCode() : 0);
                result = 31 * result + (this.resourceAccessPolicies != null ? this.resourceAccessPolicies.hashCode() : 0);
                result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration settings for the Lambda execution environment on the AWS IoT Greengrass core.
     * <p>
     * In an AWS CloudFormation template, <code>Execution</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-defaultconfig.html"><code>DefaultConfig</code></a> property type for a function definition version and the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-environment.html"><code>Environment</code></a> property type for a function.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * ExecutionProperty executionProperty = ExecutionProperty.builder()
     *         .isolationMode("isolationMode")
     *         .runAs(RunAsProperty.builder()
     *                 .gid(123)
     *                 .uid(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinition.ExecutionProperty")
    @software.amazon.jsii.Jsii.Proxy(ExecutionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExecutionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The containerization that the Lambda function runs in.
         * <p>
         * Valid values are <code>GreengrassContainer</code> or <code>NoContainer</code> . Typically, this is <code>GreengrassContainer</code> . For more information, see <a href="https://docs.aws.amazon.com/greengrass/latest/developerguide/lambda-group-config.html#lambda-function-containerization">Containerization</a> in the <em>Developer Guide</em> .
         * <p>
         * <ul>
         * <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html"><code>DefaultConfig</code></a> property of a function definition version, this setting is used as the default containerization for all Lambda functions in the function definition version.</li>
         * <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html"><code>Environment</code></a> property of a function, this setting applies to the individual function and overrides the default. Omit this value to run the function with the default containerization.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * We recommend that you run in a Greengrass container unless your business case requires that you run without containerization.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIsolationMode() {
            return null;
        }

        /**
         * The user and group permissions used to run the Lambda function.
         * <p>
         * Typically, this is the ggc_user and ggc_group. For more information, see <a href="https://docs.aws.amazon.com/greengrass/latest/developerguide/lambda-group-config.html#lambda-access-identity.html">Run as</a> in the <em>Developer Guide</em> .
         * <p>
         * <ul>
         * <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html"><code>DefaultConfig</code></a> property of a function definition version, this setting is used as the default access identity for all Lambda functions in the function definition version.</li>
         * <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html"><code>Environment</code></a> property of a function, this setting applies to the individual function and overrides the default. You can override the user, group, or both. Omit this value to run the function with the default permissions.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Running as the root user increases risks to your data and device. Do not run as root (UID/GID=0) unless your business case requires it. For more information and requirements, see <a href="https://docs.aws.amazon.com/greengrass/latest/developerguide/lambda-group-config.html#lambda-running-as-root">Running a Lambda Function as Root</a> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRunAs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExecutionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExecutionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExecutionProperty> {
            java.lang.String isolationMode;
            java.lang.Object runAs;

            /**
             * Sets the value of {@link ExecutionProperty#getIsolationMode}
             * @param isolationMode The containerization that the Lambda function runs in.
             *                      Valid values are <code>GreengrassContainer</code> or <code>NoContainer</code> . Typically, this is <code>GreengrassContainer</code> . For more information, see <a href="https://docs.aws.amazon.com/greengrass/latest/developerguide/lambda-group-config.html#lambda-function-containerization">Containerization</a> in the <em>Developer Guide</em> .
             *                      <p>
             *                      <ul>
             *                      <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html"><code>DefaultConfig</code></a> property of a function definition version, this setting is used as the default containerization for all Lambda functions in the function definition version.</li>
             *                      <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html"><code>Environment</code></a> property of a function, this setting applies to the individual function and overrides the default. Omit this value to run the function with the default containerization.</li>
             *                      </ul>
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      We recommend that you run in a Greengrass container unless your business case requires that you run without containerization.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isolationMode(java.lang.String isolationMode) {
                this.isolationMode = isolationMode;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionProperty#getRunAs}
             * @param runAs The user and group permissions used to run the Lambda function.
             *              Typically, this is the ggc_user and ggc_group. For more information, see <a href="https://docs.aws.amazon.com/greengrass/latest/developerguide/lambda-group-config.html#lambda-access-identity.html">Run as</a> in the <em>Developer Guide</em> .
             *              <p>
             *              <ul>
             *              <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html"><code>DefaultConfig</code></a> property of a function definition version, this setting is used as the default access identity for all Lambda functions in the function definition version.</li>
             *              <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html"><code>Environment</code></a> property of a function, this setting applies to the individual function and overrides the default. You can override the user, group, or both. Omit this value to run the function with the default permissions.</li>
             *              </ul>
             *              <p>
             *              <blockquote>
             *              <p>
             *              Running as the root user increases risks to your data and device. Do not run as root (UID/GID=0) unless your business case requires it. For more information and requirements, see <a href="https://docs.aws.amazon.com/greengrass/latest/developerguide/lambda-group-config.html#lambda-running-as-root">Running a Lambda Function as Root</a> .
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runAs(software.amazon.awscdk.services.greengrass.CfnFunctionDefinition.RunAsProperty runAs) {
                this.runAs = runAs;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionProperty#getRunAs}
             * @param runAs The user and group permissions used to run the Lambda function.
             *              Typically, this is the ggc_user and ggc_group. For more information, see <a href="https://docs.aws.amazon.com/greengrass/latest/developerguide/lambda-group-config.html#lambda-access-identity.html">Run as</a> in the <em>Developer Guide</em> .
             *              <p>
             *              <ul>
             *              <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html"><code>DefaultConfig</code></a> property of a function definition version, this setting is used as the default access identity for all Lambda functions in the function definition version.</li>
             *              <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html"><code>Environment</code></a> property of a function, this setting applies to the individual function and overrides the default. You can override the user, group, or both. Omit this value to run the function with the default permissions.</li>
             *              </ul>
             *              <p>
             *              <blockquote>
             *              <p>
             *              Running as the root user increases risks to your data and device. Do not run as root (UID/GID=0) unless your business case requires it. For more information and requirements, see <a href="https://docs.aws.amazon.com/greengrass/latest/developerguide/lambda-group-config.html#lambda-running-as-root">Running a Lambda Function as Root</a> .
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runAs(software.amazon.awscdk.IResolvable runAs) {
                this.runAs = runAs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExecutionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExecutionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExecutionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExecutionProperty {
            private final java.lang.String isolationMode;
            private final java.lang.Object runAs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isolationMode = software.amazon.jsii.Kernel.get(this, "isolationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.runAs = software.amazon.jsii.Kernel.get(this, "runAs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isolationMode = builder.isolationMode;
                this.runAs = builder.runAs;
            }

            @Override
            public final java.lang.String getIsolationMode() {
                return this.isolationMode;
            }

            @Override
            public final java.lang.Object getRunAs() {
                return this.runAs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIsolationMode() != null) {
                    data.set("isolationMode", om.valueToTree(this.getIsolationMode()));
                }
                if (this.getRunAs() != null) {
                    data.set("runAs", om.valueToTree(this.getRunAs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnFunctionDefinition.ExecutionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExecutionProperty.Jsii$Proxy that = (ExecutionProperty.Jsii$Proxy) o;

                if (this.isolationMode != null ? !this.isolationMode.equals(that.isolationMode) : that.isolationMode != null) return false;
                return this.runAs != null ? this.runAs.equals(that.runAs) : that.runAs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.isolationMode != null ? this.isolationMode.hashCode() : 0;
                result = 31 * result + (this.runAs != null ? this.runAs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The group-specific configuration settings for a Lambda function.
     * <p>
     * These settings configure the function's behavior in the Greengrass group. For more information, see <a href="https://docs.aws.amazon.com/greengrass/latest/developerguide/lambda-group-config.html">Controlling Execution of Greengrass Lambda Functions by Using Group-Specific Configuration</a> in the <em>Developer Guide</em> .
     * <p>
     * In an AWS CloudFormation template, <code>FunctionConfiguration</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-function.html"><code>Function</code></a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * Object variables;
     * FunctionConfigurationProperty functionConfigurationProperty = FunctionConfigurationProperty.builder()
     *         .encodingType("encodingType")
     *         .environment(EnvironmentProperty.builder()
     *                 .accessSysfs(false)
     *                 .execution(ExecutionProperty.builder()
     *                         .isolationMode("isolationMode")
     *                         .runAs(RunAsProperty.builder()
     *                                 .gid(123)
     *                                 .uid(123)
     *                                 .build())
     *                         .build())
     *                 .resourceAccessPolicies(List.of(ResourceAccessPolicyProperty.builder()
     *                         .resourceId("resourceId")
     *                         // the properties below are optional
     *                         .permission("permission")
     *                         .build()))
     *                 .variables(variables)
     *                 .build())
     *         .execArgs("execArgs")
     *         .executable("executable")
     *         .memorySize(123)
     *         .pinned(false)
     *         .timeout(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinition.FunctionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FunctionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FunctionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The expected encoding type of the input payload for the function.
         * <p>
         * Valid values are <code>json</code> (default) and <code>binary</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncodingType() {
            return null;
        }

        /**
         * The environment configuration of the function.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * The execution arguments.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecArgs() {
            return null;
        }

        /**
         * The name of the function executable.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutable() {
            return null;
        }

        /**
         * The memory size (in KB) required by the function.
         * <p>
         * <blockquote>
         * <p>
         * This property applies only to Lambda functions that run in a Greengrass container.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMemorySize() {
            return null;
        }

        /**
         * Indicates whether the function is pinned (or *long-lived* ).
         * <p>
         * Pinned functions start when the core starts and process all requests in the same container. The default value is false.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPinned() {
            return null;
        }

        /**
         * The allowed execution time (in seconds) after which the function should terminate.
         * <p>
         * For pinned functions, this timeout applies for each request.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FunctionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FunctionConfigurationProperty> {
            java.lang.String encodingType;
            java.lang.Object environment;
            java.lang.String execArgs;
            java.lang.String executable;
            java.lang.Number memorySize;
            java.lang.Object pinned;
            java.lang.Number timeout;

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getEncodingType}
             * @param encodingType The expected encoding type of the input payload for the function.
             *                     Valid values are <code>json</code> (default) and <code>binary</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encodingType(java.lang.String encodingType) {
                this.encodingType = encodingType;
                return this;
            }

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getEnvironment}
             * @param environment The environment configuration of the function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.services.greengrass.CfnFunctionDefinition.EnvironmentProperty environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getEnvironment}
             * @param environment The environment configuration of the function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.IResolvable environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getExecArgs}
             * @param execArgs The execution arguments.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder execArgs(java.lang.String execArgs) {
                this.execArgs = execArgs;
                return this;
            }

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getExecutable}
             * @param executable The name of the function executable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executable(java.lang.String executable) {
                this.executable = executable;
                return this;
            }

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getMemorySize}
             * @param memorySize The memory size (in KB) required by the function.
             *                   <blockquote>
             *                   <p>
             *                   This property applies only to Lambda functions that run in a Greengrass container.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memorySize(java.lang.Number memorySize) {
                this.memorySize = memorySize;
                return this;
            }

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getPinned}
             * @param pinned Indicates whether the function is pinned (or *long-lived* ).
             *               Pinned functions start when the core starts and process all requests in the same container. The default value is false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pinned(java.lang.Boolean pinned) {
                this.pinned = pinned;
                return this;
            }

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getPinned}
             * @param pinned Indicates whether the function is pinned (or *long-lived* ).
             *               Pinned functions start when the core starts and process all requests in the same container. The default value is false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pinned(software.amazon.awscdk.IResolvable pinned) {
                this.pinned = pinned;
                return this;
            }

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getTimeout}
             * @param timeout The allowed execution time (in seconds) after which the function should terminate.
             *                For pinned functions, this timeout applies for each request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(java.lang.Number timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FunctionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FunctionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionConfigurationProperty {
            private final java.lang.String encodingType;
            private final java.lang.Object environment;
            private final java.lang.String execArgs;
            private final java.lang.String executable;
            private final java.lang.Number memorySize;
            private final java.lang.Object pinned;
            private final java.lang.Number timeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encodingType = software.amazon.jsii.Kernel.get(this, "encodingType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.execArgs = software.amazon.jsii.Kernel.get(this, "execArgs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.executable = software.amazon.jsii.Kernel.get(this, "executable", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.memorySize = software.amazon.jsii.Kernel.get(this, "memorySize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.pinned = software.amazon.jsii.Kernel.get(this, "pinned", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encodingType = builder.encodingType;
                this.environment = builder.environment;
                this.execArgs = builder.execArgs;
                this.executable = builder.executable;
                this.memorySize = builder.memorySize;
                this.pinned = builder.pinned;
                this.timeout = builder.timeout;
            }

            @Override
            public final java.lang.String getEncodingType() {
                return this.encodingType;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public final java.lang.String getExecArgs() {
                return this.execArgs;
            }

            @Override
            public final java.lang.String getExecutable() {
                return this.executable;
            }

            @Override
            public final java.lang.Number getMemorySize() {
                return this.memorySize;
            }

            @Override
            public final java.lang.Object getPinned() {
                return this.pinned;
            }

            @Override
            public final java.lang.Number getTimeout() {
                return this.timeout;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEncodingType() != null) {
                    data.set("encodingType", om.valueToTree(this.getEncodingType()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getExecArgs() != null) {
                    data.set("execArgs", om.valueToTree(this.getExecArgs()));
                }
                if (this.getExecutable() != null) {
                    data.set("executable", om.valueToTree(this.getExecutable()));
                }
                if (this.getMemorySize() != null) {
                    data.set("memorySize", om.valueToTree(this.getMemorySize()));
                }
                if (this.getPinned() != null) {
                    data.set("pinned", om.valueToTree(this.getPinned()));
                }
                if (this.getTimeout() != null) {
                    data.set("timeout", om.valueToTree(this.getTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnFunctionDefinition.FunctionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionConfigurationProperty.Jsii$Proxy that = (FunctionConfigurationProperty.Jsii$Proxy) o;

                if (this.encodingType != null ? !this.encodingType.equals(that.encodingType) : that.encodingType != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                if (this.execArgs != null ? !this.execArgs.equals(that.execArgs) : that.execArgs != null) return false;
                if (this.executable != null ? !this.executable.equals(that.executable) : that.executable != null) return false;
                if (this.memorySize != null ? !this.memorySize.equals(that.memorySize) : that.memorySize != null) return false;
                if (this.pinned != null ? !this.pinned.equals(that.pinned) : that.pinned != null) return false;
                return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encodingType != null ? this.encodingType.hashCode() : 0;
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.execArgs != null ? this.execArgs.hashCode() : 0);
                result = 31 * result + (this.executable != null ? this.executable.hashCode() : 0);
                result = 31 * result + (this.memorySize != null ? this.memorySize.hashCode() : 0);
                result = 31 * result + (this.pinned != null ? this.pinned.hashCode() : 0);
                result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A function definition version contains a list of functions.
     * <p>
     * <blockquote>
     * <p>
     * After you create a function definition version that contains the functions you want to deploy, you must add it to your group version. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html"><code>AWS::Greengrass::Group</code></a> .
     * <p>
     * </blockquote>
     * <p>
     * In an AWS CloudFormation template, <code>FunctionDefinitionVersion</code> is the property type of the <code>InitialVersion</code> property in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html"><code>AWS::Greengrass::FunctionDefinition</code></a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * Object variables;
     * FunctionDefinitionVersionProperty functionDefinitionVersionProperty = FunctionDefinitionVersionProperty.builder()
     *         .functions(List.of(FunctionProperty.builder()
     *                 .functionArn("functionArn")
     *                 .functionConfiguration(FunctionConfigurationProperty.builder()
     *                         .encodingType("encodingType")
     *                         .environment(EnvironmentProperty.builder()
     *                                 .accessSysfs(false)
     *                                 .execution(ExecutionProperty.builder()
     *                                         .isolationMode("isolationMode")
     *                                         .runAs(RunAsProperty.builder()
     *                                                 .gid(123)
     *                                                 .uid(123)
     *                                                 .build())
     *                                         .build())
     *                                 .resourceAccessPolicies(List.of(ResourceAccessPolicyProperty.builder()
     *                                         .resourceId("resourceId")
     *                                         // the properties below are optional
     *                                         .permission("permission")
     *                                         .build()))
     *                                 .variables(variables)
     *                                 .build())
     *                         .execArgs("execArgs")
     *                         .executable("executable")
     *                         .memorySize(123)
     *                         .pinned(false)
     *                         .timeout(123)
     *                         .build())
     *                 .id("id")
     *                 .build()))
     *         // the properties below are optional
     *         .defaultConfig(DefaultConfigProperty.builder()
     *                 .execution(ExecutionProperty.builder()
     *                         .isolationMode("isolationMode")
     *                         .runAs(RunAsProperty.builder()
     *                                 .gid(123)
     *                                 .uid(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinition.FunctionDefinitionVersionProperty")
    @software.amazon.jsii.Jsii.Proxy(FunctionDefinitionVersionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FunctionDefinitionVersionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The functions in this version.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFunctions();

        /**
         * The default configuration that applies to all Lambda functions in the group.
         * <p>
         * Individual Lambda functions can override these settings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FunctionDefinitionVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionDefinitionVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FunctionDefinitionVersionProperty> {
            java.lang.Object functions;
            java.lang.Object defaultConfig;

            /**
             * Sets the value of {@link FunctionDefinitionVersionProperty#getFunctions}
             * @param functions The functions in this version. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functions(software.amazon.awscdk.IResolvable functions) {
                this.functions = functions;
                return this;
            }

            /**
             * Sets the value of {@link FunctionDefinitionVersionProperty#getFunctions}
             * @param functions The functions in this version. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functions(java.util.List<? extends java.lang.Object> functions) {
                this.functions = functions;
                return this;
            }

            /**
             * Sets the value of {@link FunctionDefinitionVersionProperty#getDefaultConfig}
             * @param defaultConfig The default configuration that applies to all Lambda functions in the group.
             *                      Individual Lambda functions can override these settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultConfig(software.amazon.awscdk.services.greengrass.CfnFunctionDefinition.DefaultConfigProperty defaultConfig) {
                this.defaultConfig = defaultConfig;
                return this;
            }

            /**
             * Sets the value of {@link FunctionDefinitionVersionProperty#getDefaultConfig}
             * @param defaultConfig The default configuration that applies to all Lambda functions in the group.
             *                      Individual Lambda functions can override these settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultConfig(software.amazon.awscdk.IResolvable defaultConfig) {
                this.defaultConfig = defaultConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionDefinitionVersionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FunctionDefinitionVersionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FunctionDefinitionVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionDefinitionVersionProperty {
            private final java.lang.Object functions;
            private final java.lang.Object defaultConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.functions = software.amazon.jsii.Kernel.get(this, "functions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultConfig = software.amazon.jsii.Kernel.get(this, "defaultConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.functions = java.util.Objects.requireNonNull(builder.functions, "functions is required");
                this.defaultConfig = builder.defaultConfig;
            }

            @Override
            public final java.lang.Object getFunctions() {
                return this.functions;
            }

            @Override
            public final java.lang.Object getDefaultConfig() {
                return this.defaultConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("functions", om.valueToTree(this.getFunctions()));
                if (this.getDefaultConfig() != null) {
                    data.set("defaultConfig", om.valueToTree(this.getDefaultConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnFunctionDefinition.FunctionDefinitionVersionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionDefinitionVersionProperty.Jsii$Proxy that = (FunctionDefinitionVersionProperty.Jsii$Proxy) o;

                if (!functions.equals(that.functions)) return false;
                return this.defaultConfig != null ? this.defaultConfig.equals(that.defaultConfig) : that.defaultConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.functions.hashCode();
                result = 31 * result + (this.defaultConfig != null ? this.defaultConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A function is a Lambda function that's referenced from an AWS IoT Greengrass group.
     * <p>
     * The function is deployed to a Greengrass core where it runs locally. For more information, see <a href="https://docs.aws.amazon.com/greengrass/latest/developerguide/lambda-functions.html">Run Lambda Functions on the AWS IoT Greengrass Core</a> in the <em>Developer Guide</em> .
     * <p>
     * In an AWS CloudFormation template, the <code>Functions</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functiondefinitionversion.html"><code>FunctionDefinitionVersion</code></a> property type contains a list of <code>Function</code> property types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * Object variables;
     * FunctionProperty functionProperty = FunctionProperty.builder()
     *         .functionArn("functionArn")
     *         .functionConfiguration(FunctionConfigurationProperty.builder()
     *                 .encodingType("encodingType")
     *                 .environment(EnvironmentProperty.builder()
     *                         .accessSysfs(false)
     *                         .execution(ExecutionProperty.builder()
     *                                 .isolationMode("isolationMode")
     *                                 .runAs(RunAsProperty.builder()
     *                                         .gid(123)
     *                                         .uid(123)
     *                                         .build())
     *                                 .build())
     *                         .resourceAccessPolicies(List.of(ResourceAccessPolicyProperty.builder()
     *                                 .resourceId("resourceId")
     *                                 // the properties below are optional
     *                                 .permission("permission")
     *                                 .build()))
     *                         .variables(variables)
     *                         .build())
     *                 .execArgs("execArgs")
     *                 .executable("executable")
     *                 .memorySize(123)
     *                 .pinned(false)
     *                 .timeout(123)
     *                 .build())
     *         .id("id")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinition.FunctionProperty")
    @software.amazon.jsii.Jsii.Proxy(FunctionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FunctionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the alias (recommended) or version of the referenced Lambda function.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn();

        /**
         * The group-specific settings of the Lambda function.
         * <p>
         * These settings configure the function's behavior in the Greengrass group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFunctionConfiguration();

        /**
         * A descriptive or arbitrary ID for the function.
         * <p>
         * This value must be unique within the function definition version. Maximum length is 128 characters with pattern <code>[a-zA-Z0-9:_-]+</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * @return a {@link Builder} of {@link FunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FunctionProperty> {
            java.lang.String functionArn;
            java.lang.Object functionConfiguration;
            java.lang.String id;

            /**
             * Sets the value of {@link FunctionProperty#getFunctionArn}
             * @param functionArn The Amazon Resource Name (ARN) of the alias (recommended) or version of the referenced Lambda function. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionArn(java.lang.String functionArn) {
                this.functionArn = functionArn;
                return this;
            }

            /**
             * Sets the value of {@link FunctionProperty#getFunctionConfiguration}
             * @param functionConfiguration The group-specific settings of the Lambda function. This parameter is required.
             *                              These settings configure the function's behavior in the Greengrass group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionConfiguration(software.amazon.awscdk.services.greengrass.CfnFunctionDefinition.FunctionConfigurationProperty functionConfiguration) {
                this.functionConfiguration = functionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link FunctionProperty#getFunctionConfiguration}
             * @param functionConfiguration The group-specific settings of the Lambda function. This parameter is required.
             *                              These settings configure the function's behavior in the Greengrass group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionConfiguration(software.amazon.awscdk.IResolvable functionConfiguration) {
                this.functionConfiguration = functionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link FunctionProperty#getId}
             * @param id A descriptive or arbitrary ID for the function. This parameter is required.
             *           This value must be unique within the function definition version. Maximum length is 128 characters with pattern <code>[a-zA-Z0-9:_-]+</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FunctionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionProperty {
            private final java.lang.String functionArn;
            private final java.lang.Object functionConfiguration;
            private final java.lang.String id;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.functionArn = software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.functionConfiguration = software.amazon.jsii.Kernel.get(this, "functionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.functionArn = java.util.Objects.requireNonNull(builder.functionArn, "functionArn is required");
                this.functionConfiguration = java.util.Objects.requireNonNull(builder.functionConfiguration, "functionConfiguration is required");
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
            }

            @Override
            public final java.lang.String getFunctionArn() {
                return this.functionArn;
            }

            @Override
            public final java.lang.Object getFunctionConfiguration() {
                return this.functionConfiguration;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("functionArn", om.valueToTree(this.getFunctionArn()));
                data.set("functionConfiguration", om.valueToTree(this.getFunctionConfiguration()));
                data.set("id", om.valueToTree(this.getId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnFunctionDefinition.FunctionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionProperty.Jsii$Proxy that = (FunctionProperty.Jsii$Proxy) o;

                if (!functionArn.equals(that.functionArn)) return false;
                if (!functionConfiguration.equals(that.functionConfiguration)) return false;
                return this.id.equals(that.id);
            }

            @Override
            public final int hashCode() {
                int result = this.functionArn.hashCode();
                result = 31 * result + (this.functionConfiguration.hashCode());
                result = 31 * result + (this.id.hashCode());
                return result;
            }
        }
    }
    /**
     * A list of the [resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html) in the group that the function can access, with the corresponding read-only or read-write permissions. The maximum is 10 resources.
     * <p>
     * <blockquote>
     * <p>
     * This property applies only to Lambda functions that run in a Greengrass container.
     * <p>
     * </blockquote>
     * <p>
     * In an AWS CloudFormation template, <code>ResourceAccessPolicy</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-environment.html"><code>Environment</code></a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * ResourceAccessPolicyProperty resourceAccessPolicyProperty = ResourceAccessPolicyProperty.builder()
     *         .resourceId("resourceId")
     *         // the properties below are optional
     *         .permission("permission")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinition.ResourceAccessPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceAccessPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceAccessPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the resource.
         * <p>
         * This ID is assigned to the resource when you create the resource definition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceId();

        /**
         * The read-only or read-write access that the Lambda function has to the resource.
         * <p>
         * Valid values are <code>ro</code> or <code>rw</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPermission() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceAccessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceAccessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceAccessPolicyProperty> {
            java.lang.String resourceId;
            java.lang.String permission;

            /**
             * Sets the value of {@link ResourceAccessPolicyProperty#getResourceId}
             * @param resourceId The ID of the resource. This parameter is required.
             *                   This ID is assigned to the resource when you create the resource definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceId(java.lang.String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Sets the value of {@link ResourceAccessPolicyProperty#getPermission}
             * @param permission The read-only or read-write access that the Lambda function has to the resource.
             *                   Valid values are <code>ro</code> or <code>rw</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder permission(java.lang.String permission) {
                this.permission = permission;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceAccessPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceAccessPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceAccessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceAccessPolicyProperty {
            private final java.lang.String resourceId;
            private final java.lang.String permission;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.permission = software.amazon.jsii.Kernel.get(this, "permission", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceId = java.util.Objects.requireNonNull(builder.resourceId, "resourceId is required");
                this.permission = builder.permission;
            }

            @Override
            public final java.lang.String getResourceId() {
                return this.resourceId;
            }

            @Override
            public final java.lang.String getPermission() {
                return this.permission;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceId", om.valueToTree(this.getResourceId()));
                if (this.getPermission() != null) {
                    data.set("permission", om.valueToTree(this.getPermission()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnFunctionDefinition.ResourceAccessPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceAccessPolicyProperty.Jsii$Proxy that = (ResourceAccessPolicyProperty.Jsii$Proxy) o;

                if (!resourceId.equals(that.resourceId)) return false;
                return this.permission != null ? this.permission.equals(that.permission) : that.permission == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceId.hashCode();
                result = 31 * result + (this.permission != null ? this.permission.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The access identity whose permissions are used to run the Lambda function.
     * <p>
     * This setting overrides the default access identity that's specified for the group (by default, ggc_user and ggc_group). You can override the user, group, or both. For more information, see <a href="https://docs.aws.amazon.com/greengrass/latest/developerguide/lambda-group-config.html#lambda-access-identity.html">Run as</a> in the <em>Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * Running as the root user increases risks to your data and device. Do not run as root (UID/GID=0) unless your business case requires it. For more information and requirements, see <a href="https://docs.aws.amazon.com/greengrass/latest/developerguide/lambda-group-config.html#lambda-running-as-root">Running a Lambda Function as Root</a> .
     * <p>
     * </blockquote>
     * <p>
     * In an AWS CloudFormation template, <code>RunAs</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-execution.html"><code>Execution</code></a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * RunAsProperty runAsProperty = RunAsProperty.builder()
     *         .gid(123)
     *         .uid(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinition.RunAsProperty")
    @software.amazon.jsii.Jsii.Proxy(RunAsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RunAsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The group ID whose permissions are used to run the Lambda function.
         * <p>
         * You can use the <code>getent group</code> command on your core device to look up the group ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGid() {
            return null;
        }

        /**
         * The user ID whose permissions are used to run the Lambda function.
         * <p>
         * You can use the <code>getent passwd</code> command on your core device to look up the user ID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getUid() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RunAsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RunAsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RunAsProperty> {
            java.lang.Number gid;
            java.lang.Number uid;

            /**
             * Sets the value of {@link RunAsProperty#getGid}
             * @param gid The group ID whose permissions are used to run the Lambda function.
             *            You can use the <code>getent group</code> command on your core device to look up the group ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gid(java.lang.Number gid) {
                this.gid = gid;
                return this;
            }

            /**
             * Sets the value of {@link RunAsProperty#getUid}
             * @param uid The user ID whose permissions are used to run the Lambda function.
             *            You can use the <code>getent passwd</code> command on your core device to look up the user ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uid(java.lang.Number uid) {
                this.uid = uid;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RunAsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RunAsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RunAsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RunAsProperty {
            private final java.lang.Number gid;
            private final java.lang.Number uid;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.gid = software.amazon.jsii.Kernel.get(this, "gid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.uid = software.amazon.jsii.Kernel.get(this, "uid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.gid = builder.gid;
                this.uid = builder.uid;
            }

            @Override
            public final java.lang.Number getGid() {
                return this.gid;
            }

            @Override
            public final java.lang.Number getUid() {
                return this.uid;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGid() != null) {
                    data.set("gid", om.valueToTree(this.getGid()));
                }
                if (this.getUid() != null) {
                    data.set("uid", om.valueToTree(this.getUid()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnFunctionDefinition.RunAsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RunAsProperty.Jsii$Proxy that = (RunAsProperty.Jsii$Proxy) o;

                if (this.gid != null ? !this.gid.equals(that.gid) : that.gid != null) return false;
                return this.uid != null ? this.uid.equals(that.uid) : that.uid == null;
            }

            @Override
            public final int hashCode() {
                int result = this.gid != null ? this.gid.hashCode() : 0;
                result = 31 * result + (this.uid != null ? this.uid.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.greengrass.CfnFunctionDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.greengrass.CfnFunctionDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionProps.Builder();
        }

        /**
         * The name of the function definition.
         * <p>
         * @return {@code this}
         * @param name The name of the function definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The function definition version to include when the function definition is created.
         * <p>
         * A function definition version contains a list of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-function.html"><code>function</code></a> property types.
         * <p>
         * <blockquote>
         * <p>
         * To associate a function definition version after the function definition is created, create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html"><code>AWS::Greengrass::FunctionDefinitionVersion</code></a> resource and specify the ID of this function definition.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param initialVersion The function definition version to include when the function definition is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialVersion(final software.amazon.awscdk.services.greengrass.CfnFunctionDefinition.FunctionDefinitionVersionProperty initialVersion) {
            this.props.initialVersion(initialVersion);
            return this;
        }
        /**
         * The function definition version to include when the function definition is created.
         * <p>
         * A function definition version contains a list of <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-function.html"><code>function</code></a> property types.
         * <p>
         * <blockquote>
         * <p>
         * To associate a function definition version after the function definition is created, create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html"><code>AWS::Greengrass::FunctionDefinitionVersion</code></a> resource and specify the ID of this function definition.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param initialVersion The function definition version to include when the function definition is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialVersion(final software.amazon.awscdk.IResolvable initialVersion) {
            this.props.initialVersion(initialVersion);
            return this;
        }

        /**
         * Application-specific metadata to attach to the function definition.
         * <p>
         * You can use tags in IAM policies to control access to AWS IoT Greengrass resources. You can also use tags to categorize your resources. For more information, see <a href="https://docs.aws.amazon.com/greengrass/latest/developerguide/tagging.html">Tagging Your AWS IoT Greengrass Resources</a> in the <em>Developer Guide</em> .
         * <p>
         * This <code>Json</code> property type is processed as a map of key-value pairs. It uses the following format, which is different from most <code>Tags</code> implementations in AWS CloudFormation templates.
         * <p>
         * <blockquote><pre>
         * "Tags": { "KeyName0": "value", "KeyName1": "value", "KeyName2": "value"
         * }
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param tags Application-specific metadata to attach to the function definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.lang.Object tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.greengrass.CfnFunctionDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.greengrass.CfnFunctionDefinition build() {
            return new software.amazon.awscdk.services.greengrass.CfnFunctionDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
