package software.amazon.awscdk.services.finspace;

/**
 * Properties for defining a `CfnEnvironment`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.finspace.*;
 * Object attributeMap;
 * CfnEnvironmentProps cfnEnvironmentProps = CfnEnvironmentProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .dataBundles(List.of("dataBundles"))
 *         .description("description")
 *         .federationMode("federationMode")
 *         .federationParameters(FederationParametersProperty.builder()
 *                 .applicationCallBackUrl("applicationCallBackUrl")
 *                 .attributeMap(attributeMap)
 *                 .federationProviderName("federationProviderName")
 *                 .federationUrn("federationUrn")
 *                 .samlMetadataDocument("samlMetadataDocument")
 *                 .samlMetadataUrl("samlMetadataUrl")
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .superuserParameters(SuperuserParametersProperty.builder()
 *                 .emailAddress("emailAddress")
 *                 .firstName("firstName")
 *                 .lastName("lastName")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:51.668Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_finspace.CfnEnvironmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnEnvironmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEnvironmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the FinSpace environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The list of Amazon Resource Names (ARN) of the data bundles to install. Currently supported data bundle ARNs:.
     * <p>
     * <ul>
     * <li><code>arn:aws:finspace:${Region}::data-bundle/capital-markets-sample</code> - Contains sample Capital Markets datasets, categories and controlled vocabularies.</li>
     * <li><code>arn:aws:finspace:${Region}::data-bundle/taq</code> (default) - Contains trades and quotes data in addition to sample Capital Markets data.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDataBundles() {
        return null;
    }

    /**
     * The description of the FinSpace environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The authentication mode for the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFederationMode() {
        return null;
    }

    /**
     * Configuration information when authentication mode is FEDERATED.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFederationParameters() {
        return null;
    }

    /**
     * The KMS key id used to encrypt in the FinSpace environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * Configuration information for the superuser.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSuperuserParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEnvironmentProps> {
        java.lang.String name;
        java.util.List<java.lang.String> dataBundles;
        java.lang.String description;
        java.lang.String federationMode;
        java.lang.Object federationParameters;
        java.lang.String kmsKeyId;
        java.lang.Object superuserParameters;

        /**
         * Sets the value of {@link CfnEnvironmentProps#getName}
         * @param name The name of the FinSpace environment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getDataBundles}
         * @param dataBundles The list of Amazon Resource Names (ARN) of the data bundles to install. Currently supported data bundle ARNs:.
         *                    <ul>
         *                    <li><code>arn:aws:finspace:${Region}::data-bundle/capital-markets-sample</code> - Contains sample Capital Markets datasets, categories and controlled vocabularies.</li>
         *                    <li><code>arn:aws:finspace:${Region}::data-bundle/taq</code> (default) - Contains trades and quotes data in addition to sample Capital Markets data.</li>
         *                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataBundles(java.util.List<java.lang.String> dataBundles) {
            this.dataBundles = dataBundles;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getDescription}
         * @param description The description of the FinSpace environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getFederationMode}
         * @param federationMode The authentication mode for the environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder federationMode(java.lang.String federationMode) {
            this.federationMode = federationMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getFederationParameters}
         * @param federationParameters Configuration information when authentication mode is FEDERATED.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder federationParameters(software.amazon.awscdk.services.finspace.CfnEnvironment.FederationParametersProperty federationParameters) {
            this.federationParameters = federationParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getFederationParameters}
         * @param federationParameters Configuration information when authentication mode is FEDERATED.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder federationParameters(software.amazon.awscdk.IResolvable federationParameters) {
            this.federationParameters = federationParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getKmsKeyId}
         * @param kmsKeyId The KMS key id used to encrypt in the FinSpace environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getSuperuserParameters}
         * @param superuserParameters Configuration information for the superuser.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder superuserParameters(software.amazon.awscdk.services.finspace.CfnEnvironment.SuperuserParametersProperty superuserParameters) {
            this.superuserParameters = superuserParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnEnvironmentProps#getSuperuserParameters}
         * @param superuserParameters Configuration information for the superuser.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder superuserParameters(software.amazon.awscdk.IResolvable superuserParameters) {
            this.superuserParameters = superuserParameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEnvironmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEnvironmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEnvironmentProps {
        private final java.lang.String name;
        private final java.util.List<java.lang.String> dataBundles;
        private final java.lang.String description;
        private final java.lang.String federationMode;
        private final java.lang.Object federationParameters;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object superuserParameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataBundles = software.amazon.jsii.Kernel.get(this, "dataBundles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.federationMode = software.amazon.jsii.Kernel.get(this, "federationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.federationParameters = software.amazon.jsii.Kernel.get(this, "federationParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.superuserParameters = software.amazon.jsii.Kernel.get(this, "superuserParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.dataBundles = builder.dataBundles;
            this.description = builder.description;
            this.federationMode = builder.federationMode;
            this.federationParameters = builder.federationParameters;
            this.kmsKeyId = builder.kmsKeyId;
            this.superuserParameters = builder.superuserParameters;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<java.lang.String> getDataBundles() {
            return this.dataBundles;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getFederationMode() {
            return this.federationMode;
        }

        @Override
        public final java.lang.Object getFederationParameters() {
            return this.federationParameters;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.Object getSuperuserParameters() {
            return this.superuserParameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getDataBundles() != null) {
                data.set("dataBundles", om.valueToTree(this.getDataBundles()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getFederationMode() != null) {
                data.set("federationMode", om.valueToTree(this.getFederationMode()));
            }
            if (this.getFederationParameters() != null) {
                data.set("federationParameters", om.valueToTree(this.getFederationParameters()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getSuperuserParameters() != null) {
                data.set("superuserParameters", om.valueToTree(this.getSuperuserParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_finspace.CfnEnvironmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEnvironmentProps.Jsii$Proxy that = (CfnEnvironmentProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.dataBundles != null ? !this.dataBundles.equals(that.dataBundles) : that.dataBundles != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.federationMode != null ? !this.federationMode.equals(that.federationMode) : that.federationMode != null) return false;
            if (this.federationParameters != null ? !this.federationParameters.equals(that.federationParameters) : that.federationParameters != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            return this.superuserParameters != null ? this.superuserParameters.equals(that.superuserParameters) : that.superuserParameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.dataBundles != null ? this.dataBundles.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.federationMode != null ? this.federationMode.hashCode() : 0);
            result = 31 * result + (this.federationParameters != null ? this.federationParameters.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.superuserParameters != null ? this.superuserParameters.hashCode() : 0);
            return result;
        }
    }
}
