package software.amazon.awscdk.services.events.targets;

/**
 * Properties to define an ECS Event Task.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.events.Rule;
 * import software.amazon.awscdk.services.events.Schedule;
 * import software.amazon.awscdk.services.events.targets.EcsTask;
 * import software.amazon.awscdk.services.ecs.Cluster;
 * import software.amazon.awscdk.services.ecs.TaskDefinition;
 * import software.amazon.awscdk.services.iam.Role;
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * Role role;
 * EcsTask ecsTaskTarget = EcsTask.Builder.create().cluster(cluster).taskDefinition(taskDefinition).role(role).build();
 * Rule.Builder.create(this, "ScheduleRule")
 *         .schedule(Schedule.cron(CronOptions.builder().minute("0").hour("4").build()))
 *         .targets(List.of(ecsTaskTarget))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:51.629Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.EcsTaskProps")
@software.amazon.jsii.Jsii.Proxy(EcsTaskProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcsTaskProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.events.targets.TargetBaseProps {

    /**
     * Cluster where service will be deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ICluster getCluster();

    /**
     * Task Definition of the task that should be started.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ITaskDefinition getTaskDefinition();

    /**
     * Container setting overrides.
     * <p>
     * Key is the name of the container to override, value is the
     * values you want to override.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.events.targets.ContainerOverride> getContainerOverrides() {
        return null;
    }

    /**
     * The platform version on which to run your task.
     * <p>
     * Unless you have specific compatibility requirements, you don't need to specify this.
     * <p>
     * Default: - ECS will set the Fargate platform version to 'LATEST'
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FargatePlatformVersion getPlatformVersion() {
        return null;
    }

    /**
     * Existing IAM role to run the ECS task.
     * <p>
     * Default: A new IAM role is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * Existing security groups to use for the task's ENIs.
     * <p>
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     * <p>
     * Default: A new security group is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * In what subnets to place the task's ENIs.
     * <p>
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     * <p>
     * Default: Private subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return null;
    }

    /**
     * How many tasks should be started when this event is triggered.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTaskCount() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcsTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcsTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EcsTaskProps> {
        software.amazon.awscdk.services.ecs.ICluster cluster;
        software.amazon.awscdk.services.ecs.ITaskDefinition taskDefinition;
        java.util.List<software.amazon.awscdk.services.events.targets.ContainerOverride> containerOverrides;
        software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion;
        software.amazon.awscdk.services.iam.IRole role;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        java.lang.Number taskCount;
        software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        software.amazon.awscdk.Duration maxEventAge;
        java.lang.Number retryAttempts;

        /**
         * Sets the value of {@link EcsTaskProps#getCluster}
         * @param cluster Cluster where service will be deployed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link EcsTaskProps#getTaskDefinition}
         * @param taskDefinition Task Definition of the task that should be started. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(software.amazon.awscdk.services.ecs.ITaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        /**
         * Sets the value of {@link EcsTaskProps#getContainerOverrides}
         * @param containerOverrides Container setting overrides.
         *                           Key is the name of the container to override, value is the
         *                           values you want to override.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder containerOverrides(java.util.List<? extends software.amazon.awscdk.services.events.targets.ContainerOverride> containerOverrides) {
            this.containerOverrides = (java.util.List<software.amazon.awscdk.services.events.targets.ContainerOverride>)containerOverrides;
            return this;
        }

        /**
         * Sets the value of {@link EcsTaskProps#getPlatformVersion}
         * @param platformVersion The platform version on which to run your task.
         *                        Unless you have specific compatibility requirements, you don't need to specify this.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformVersion(software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        /**
         * Sets the value of {@link EcsTaskProps#getRole}
         * @param role Existing IAM role to run the ECS task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link EcsTaskProps#getSecurityGroups}
         * @param securityGroups Existing security groups to use for the task's ENIs.
         *                       (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link EcsTaskProps#getSubnetSelection}
         * @param subnetSelection In what subnets to place the task's ENIs.
         *                        (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of {@link EcsTaskProps#getTaskCount}
         * @param taskCount How many tasks should be started when this event is triggered.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskCount(java.lang.Number taskCount) {
            this.taskCount = taskCount;
            return this;
        }

        /**
         * Sets the value of {@link EcsTaskProps#getDeadLetterQueue}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. Check out the [considerations for using a dead-letter queue](https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations).
         *                        The events not successfully delivered are automatically retried for a specified period of time,
         *                        depending on the retry policy of the target.
         *                        If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link EcsTaskProps#getMaxEventAge}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing.
         *                    Minimum value of 60.
         *                    Maximum value of 86400.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(software.amazon.awscdk.Duration maxEventAge) {
            this.maxEventAge = maxEventAge;
            return this;
        }

        /**
         * Sets the value of {@link EcsTaskProps#getRetryAttempts}
         * @param retryAttempts The maximum number of times to retry when the function returns an error.
         *                      Minimum value of 0.
         *                      Maximum value of 185.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcsTaskProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EcsTaskProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcsTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsTaskProps {
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final software.amazon.awscdk.services.ecs.ITaskDefinition taskDefinition;
        private final java.util.List<software.amazon.awscdk.services.events.targets.ContainerOverride> containerOverrides;
        private final software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final java.lang.Number taskCount;
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final software.amazon.awscdk.Duration maxEventAge;
        private final java.lang.Number retryAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
            this.taskDefinition = software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ITaskDefinition.class));
            this.containerOverrides = software.amazon.jsii.Kernel.get(this, "containerOverrides", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.targets.ContainerOverride.class)));
            this.platformVersion = software.amazon.jsii.Kernel.get(this, "platformVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargatePlatformVersion.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.subnetSelection = software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.taskCount = software.amazon.jsii.Kernel.get(this, "taskCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.deadLetterQueue = software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
            this.maxEventAge = software.amazon.jsii.Kernel.get(this, "maxEventAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.taskDefinition = java.util.Objects.requireNonNull(builder.taskDefinition, "taskDefinition is required");
            this.containerOverrides = (java.util.List<software.amazon.awscdk.services.events.targets.ContainerOverride>)builder.containerOverrides;
            this.platformVersion = builder.platformVersion;
            this.role = builder.role;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.subnetSelection = builder.subnetSelection;
            this.taskCount = builder.taskCount;
            this.deadLetterQueue = builder.deadLetterQueue;
            this.maxEventAge = builder.maxEventAge;
            this.retryAttempts = builder.retryAttempts;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ITaskDefinition getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.events.targets.ContainerOverride> getContainerOverrides() {
            return this.containerOverrides;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.FargatePlatformVersion getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public final java.lang.Number getTaskCount() {
            return this.taskCount;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxEventAge() {
            return this.maxEventAge;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("taskDefinition", om.valueToTree(this.getTaskDefinition()));
            if (this.getContainerOverrides() != null) {
                data.set("containerOverrides", om.valueToTree(this.getContainerOverrides()));
            }
            if (this.getPlatformVersion() != null) {
                data.set("platformVersion", om.valueToTree(this.getPlatformVersion()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getTaskCount() != null) {
                data.set("taskCount", om.valueToTree(this.getTaskCount()));
            }
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getMaxEventAge() != null) {
                data.set("maxEventAge", om.valueToTree(this.getMaxEventAge()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events_targets.EcsTaskProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcsTaskProps.Jsii$Proxy that = (EcsTaskProps.Jsii$Proxy) o;

            if (!cluster.equals(that.cluster)) return false;
            if (!taskDefinition.equals(that.taskDefinition)) return false;
            if (this.containerOverrides != null ? !this.containerOverrides.equals(that.containerOverrides) : that.containerOverrides != null) return false;
            if (this.platformVersion != null ? !this.platformVersion.equals(that.platformVersion) : that.platformVersion != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            if (this.taskCount != null ? !this.taskCount.equals(that.taskCount) : that.taskCount != null) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.maxEventAge != null ? !this.maxEventAge.equals(that.maxEventAge) : that.maxEventAge != null) return false;
            return this.retryAttempts != null ? this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cluster.hashCode();
            result = 31 * result + (this.taskDefinition.hashCode());
            result = 31 * result + (this.containerOverrides != null ? this.containerOverrides.hashCode() : 0);
            result = 31 * result + (this.platformVersion != null ? this.platformVersion.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.taskCount != null ? this.taskCount.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.maxEventAge != null ? this.maxEventAge.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            return result;
        }
    }
}
