package software.amazon.awscdk.services.eks;

/**
 * Options for adding worker nodes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * cluster.addAutoScalingGroupCapacity("BottlerocketNodes", AutoScalingGroupCapacityOptions.builder()
 *         .instanceType(new InstanceType("t3.small"))
 *         .minCapacity(2)
 *         .machineImageType(MachineImageType.BOTTLEROCKET)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:51.205Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AutoScalingGroupCapacityOptions")
@software.amazon.jsii.Jsii.Proxy(AutoScalingGroupCapacityOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AutoScalingGroupCapacityOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.autoscaling.CommonAutoScalingGroupProps {

    /**
     * Instance type of the instances to start.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * Configures the EC2 user-data script for instances in this autoscaling group to bootstrap the node (invoke `/etc/eks/bootstrap.sh`) and associate it with the EKS cluster.
     * <p>
     * If you wish to provide a custom user data script, set this to <code>false</code> and
     * manually invoke <code>autoscalingGroup.addUserData()</code>.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getBootstrapEnabled() {
        return null;
    }

    /**
     * EKS node bootstrapping options.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.BootstrapOptions getBootstrapOptions() {
        return null;
    }

    /**
     * Machine image type.
     * <p>
     * Default: MachineImageType.AMAZON_LINUX_2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.MachineImageType getMachineImageType() {
        return null;
    }

    /**
     * Will automatically update the aws-auth ConfigMap to map the IAM instance role to RBAC.
     * <p>
     * This cannot be explicitly set to <code>true</code> if the cluster has kubectl disabled.
     * <p>
     * Default: - true if the cluster has kubectl enabled (which is the default).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMapRole() {
        return null;
    }

    /**
     * Installs the AWS spot instance interrupt handler on the cluster if it's not already added.
     * <p>
     * Only relevant if <code>spotPrice</code> is used.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSpotInterruptHandler() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AutoScalingGroupCapacityOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AutoScalingGroupCapacityOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AutoScalingGroupCapacityOptions> {
        software.amazon.awscdk.services.ec2.InstanceType instanceType;
        java.lang.Boolean bootstrapEnabled;
        software.amazon.awscdk.services.eks.BootstrapOptions bootstrapOptions;
        software.amazon.awscdk.services.eks.MachineImageType machineImageType;
        java.lang.Boolean mapRole;
        java.lang.Boolean spotInterruptHandler;
        java.lang.Boolean allowAllOutbound;
        java.lang.Boolean associatePublicIpAddress;
        java.lang.String autoScalingGroupName;
        java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> blockDevices;
        software.amazon.awscdk.Duration cooldown;
        java.lang.Number desiredCapacity;
        java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> groupMetrics;
        software.amazon.awscdk.services.autoscaling.HealthCheck healthCheck;
        java.lang.Boolean ignoreUnmodifiedSizeProperties;
        software.amazon.awscdk.services.autoscaling.Monitoring instanceMonitoring;
        java.lang.String keyName;
        java.lang.Number maxCapacity;
        software.amazon.awscdk.Duration maxInstanceLifetime;
        java.lang.Number minCapacity;
        java.lang.Boolean newInstancesProtectedFromScaleIn;
        java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> notifications;
        software.amazon.awscdk.services.autoscaling.Signals signals;
        java.lang.String spotPrice;
        java.util.List<software.amazon.awscdk.services.autoscaling.TerminationPolicy> terminationPolicies;
        software.amazon.awscdk.services.autoscaling.UpdatePolicy updatePolicy;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getInstanceType}
         * @param instanceType Instance type of the instances to start. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getBootstrapEnabled}
         * @param bootstrapEnabled Configures the EC2 user-data script for instances in this autoscaling group to bootstrap the node (invoke `/etc/eks/bootstrap.sh`) and associate it with the EKS cluster.
         *                         If you wish to provide a custom user data script, set this to <code>false</code> and
         *                         manually invoke <code>autoscalingGroup.addUserData()</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapEnabled(java.lang.Boolean bootstrapEnabled) {
            this.bootstrapEnabled = bootstrapEnabled;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getBootstrapOptions}
         * @param bootstrapOptions EKS node bootstrapping options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapOptions(software.amazon.awscdk.services.eks.BootstrapOptions bootstrapOptions) {
            this.bootstrapOptions = bootstrapOptions;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getMachineImageType}
         * @param machineImageType Machine image type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImageType(software.amazon.awscdk.services.eks.MachineImageType machineImageType) {
            this.machineImageType = machineImageType;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getMapRole}
         * @param mapRole Will automatically update the aws-auth ConfigMap to map the IAM instance role to RBAC.
         *                This cannot be explicitly set to <code>true</code> if the cluster has kubectl disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapRole(java.lang.Boolean mapRole) {
            this.mapRole = mapRole;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getSpotInterruptHandler}
         * @param spotInterruptHandler Installs the AWS spot instance interrupt handler on the cluster if it's not already added.
         *                             Only relevant if <code>spotPrice</code> is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotInterruptHandler(java.lang.Boolean spotInterruptHandler) {
            this.spotInterruptHandler = spotInterruptHandler;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getAllowAllOutbound}
         * @param allowAllOutbound Whether the instances can initiate connections to anywhere by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(java.lang.Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getAssociatePublicIpAddress}
         * @param associatePublicIpAddress Whether instances in the Auto Scaling Group should have public IP addresses associated with them.
         *                                 <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(java.lang.Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getAutoScalingGroupName}
         * @param autoScalingGroupName The name of the Auto Scaling group.
         *                             This name must be unique per Region per account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupName(java.lang.String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getBlockDevices}
         * @param blockDevices Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
         *                     Each instance that is launched has an associated root device volume,
         *                     either an Amazon EBS volume or an instance store volume.
         *                     You can use block device mappings to specify additional EBS volumes or
         *                     instance store volumes to attach to an instance when it is launched.
         *                     <p>
         *                     <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder blockDevices(java.util.List<? extends software.amazon.awscdk.services.autoscaling.BlockDevice> blockDevices) {
            this.blockDevices = (java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice>)blockDevices;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getCooldown}
         * @param cooldown Default scaling cooldown for this AutoScalingGroup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(software.amazon.awscdk.Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getDesiredCapacity}
         * @param desiredCapacity Initial amount of instances in the fleet.
         *                        If this is set to a number, every deployment will reset the amount of
         *                        instances to this number. It is recommended to leave this value blank.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCapacity(java.lang.Number desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getGroupMetrics}
         * @param groupMetrics Enable monitoring for group metrics, these metrics describe the group rather than any of its instances.
         *                     To report all group metrics use <code>GroupMetrics.all()</code>
         *                     Group metrics are reported in a granularity of 1 minute at no additional charge.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder groupMetrics(java.util.List<? extends software.amazon.awscdk.services.autoscaling.GroupMetrics> groupMetrics) {
            this.groupMetrics = (java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics>)groupMetrics;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getHealthCheck}
         * @param healthCheck Configuration for health checks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.autoscaling.HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getIgnoreUnmodifiedSizeProperties}
         * @param ignoreUnmodifiedSizeProperties If the ASG has scheduled actions, don't reset unchanged group sizes.
         *                                       Only used if the ASG has scheduled actions (which may scale your ASG up
         *                                       or down regardless of cdk deployments). If true, the size of the group
         *                                       will only be reset if it has been changed in the CDK app. If false, the
         *                                       sizes will always be changed back to what they were in the CDK app
         *                                       on deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreUnmodifiedSizeProperties(java.lang.Boolean ignoreUnmodifiedSizeProperties) {
            this.ignoreUnmodifiedSizeProperties = ignoreUnmodifiedSizeProperties;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getInstanceMonitoring}
         * @param instanceMonitoring Controls whether instances in this group are launched with detailed or basic monitoring.
         *                           When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account
         *                           is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes.
         *                           <p>
         *                           <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMonitoring(software.amazon.awscdk.services.autoscaling.Monitoring instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getKeyName}
         * @param keyName Name of SSH keypair to grant access to instances.
         *                <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getMaxCapacity}
         * @param maxCapacity Maximum number of instances in the fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(java.lang.Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getMaxInstanceLifetime}
         * @param maxInstanceLifetime The maximum amount of time that an instance can be in service.
         *                            The maximum duration applies
         *                            to all current and future instances in the group. As an instance approaches its maximum duration,
         *                            it is terminated and replaced, and cannot be used again.
         *                            <p>
         *                            You must specify a value of at least 604,800 seconds (7 days). To clear a previously set value,
         *                            leave this property undefined.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxInstanceLifetime(software.amazon.awscdk.Duration maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getMinCapacity}
         * @param minCapacity Minimum number of instances in the fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minCapacity(java.lang.Number minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getNewInstancesProtectedFromScaleIn}
         * @param newInstancesProtectedFromScaleIn Whether newly-launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in.
         *                                         By default, Auto Scaling can terminate an instance at any time after launch
         *                                         when scaling in an Auto Scaling Group, subject to the group's termination
         *                                         policy. However, you may wish to protect newly-launched instances from
         *                                         being scaled in if they are going to run critical applications that should
         *                                         not be prematurely terminated.
         *                                         <p>
         *                                         This flag must be enabled if the Auto Scaling Group will be associated with
         *                                         an ECS Capacity Provider with managed termination protection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder newInstancesProtectedFromScaleIn(java.lang.Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getNotifications}
         * @param notifications Configure autoscaling group to send notifications about fleet changes to an SNS topic(s).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder notifications(java.util.List<? extends software.amazon.awscdk.services.autoscaling.NotificationConfiguration> notifications) {
            this.notifications = (java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration>)notifications;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getSignals}
         * @param signals Configure waiting for signals during deployment.
         *                Use this to pause the CloudFormation deployment to wait for the instances
         *                in the AutoScalingGroup to report successful startup during
         *                creation and updates. The UserData script needs to invoke <code>cfn-signal</code>
         *                with a success or failure code after it is done setting up the instance.
         *                <p>
         *                Without waiting for signals, the CloudFormation deployment will proceed as
         *                soon as the AutoScalingGroup has been created or updated but before the
         *                instances in the group have been started.
         *                <p>
         *                For example, to have instances wait for an Elastic Load Balancing health check before
         *                they signal success, add a health-check verification by using the
         *                cfn-init helper script. For an example, see the verify_instance_health
         *                command in the Auto Scaling rolling updates sample template:
         *                <p>
         *                https://github.com/awslabs/aws-cloudformation-templates/blob/master/aws/services/AutoScaling/AutoScalingRollingUpdates.yaml
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signals(software.amazon.awscdk.services.autoscaling.Signals signals) {
            this.signals = signals;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getSpotPrice}
         * @param spotPrice The maximum hourly price (in USD) to be paid for any Spot Instance launched to fulfill the request.
         *                  Spot Instances are
         *                  launched when the price you specify exceeds the current Spot market price.
         *                  <p>
         *                  <code>launchTemplate</code> and <code>mixedInstancesPolicy</code> must not be specified when this property is specified
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotPrice(java.lang.String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getTerminationPolicies}
         * @param terminationPolicies A policy or a list of policies that are used to select the instances to terminate.
         *                            The policies are executed in the order that you list them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder terminationPolicies(java.util.List<? extends software.amazon.awscdk.services.autoscaling.TerminationPolicy> terminationPolicies) {
            this.terminationPolicies = (java.util.List<software.amazon.awscdk.services.autoscaling.TerminationPolicy>)terminationPolicies;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getUpdatePolicy}
         * @param updatePolicy What to do when an AutoScalingGroup's instance configuration is changed.
         *                     This is applied when any of the settings on the ASG are changed that
         *                     affect how the instances should be created (VPC, instance type, startup
         *                     scripts, etc.). It indicates how the existing instances should be
         *                     replaced with new instances matching the new config. By default, nothing
         *                     is done and only new instances are launched with the new config.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updatePolicy(software.amazon.awscdk.services.autoscaling.UpdatePolicy updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupCapacityOptions#getVpcSubnets}
         * @param vpcSubnets Where to place instances within the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AutoScalingGroupCapacityOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AutoScalingGroupCapacityOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AutoScalingGroupCapacityOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoScalingGroupCapacityOptions {
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final java.lang.Boolean bootstrapEnabled;
        private final software.amazon.awscdk.services.eks.BootstrapOptions bootstrapOptions;
        private final software.amazon.awscdk.services.eks.MachineImageType machineImageType;
        private final java.lang.Boolean mapRole;
        private final java.lang.Boolean spotInterruptHandler;
        private final java.lang.Boolean allowAllOutbound;
        private final java.lang.Boolean associatePublicIpAddress;
        private final java.lang.String autoScalingGroupName;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> blockDevices;
        private final software.amazon.awscdk.Duration cooldown;
        private final java.lang.Number desiredCapacity;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> groupMetrics;
        private final software.amazon.awscdk.services.autoscaling.HealthCheck healthCheck;
        private final java.lang.Boolean ignoreUnmodifiedSizeProperties;
        private final software.amazon.awscdk.services.autoscaling.Monitoring instanceMonitoring;
        private final java.lang.String keyName;
        private final java.lang.Number maxCapacity;
        private final software.amazon.awscdk.Duration maxInstanceLifetime;
        private final java.lang.Number minCapacity;
        private final java.lang.Boolean newInstancesProtectedFromScaleIn;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> notifications;
        private final software.amazon.awscdk.services.autoscaling.Signals signals;
        private final java.lang.String spotPrice;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.TerminationPolicy> terminationPolicies;
        private final software.amazon.awscdk.services.autoscaling.UpdatePolicy updatePolicy;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.bootstrapEnabled = software.amazon.jsii.Kernel.get(this, "bootstrapEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.bootstrapOptions = software.amazon.jsii.Kernel.get(this, "bootstrapOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.BootstrapOptions.class));
            this.machineImageType = software.amazon.jsii.Kernel.get(this, "machineImageType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.MachineImageType.class));
            this.mapRole = software.amazon.jsii.Kernel.get(this, "mapRole", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.spotInterruptHandler = software.amazon.jsii.Kernel.get(this, "spotInterruptHandler", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.allowAllOutbound = software.amazon.jsii.Kernel.get(this, "allowAllOutbound", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.associatePublicIpAddress = software.amazon.jsii.Kernel.get(this, "associatePublicIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.autoScalingGroupName = software.amazon.jsii.Kernel.get(this, "autoScalingGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.blockDevices = software.amazon.jsii.Kernel.get(this, "blockDevices", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.BlockDevice.class)));
            this.cooldown = software.amazon.jsii.Kernel.get(this, "cooldown", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.desiredCapacity = software.amazon.jsii.Kernel.get(this, "desiredCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.groupMetrics = software.amazon.jsii.Kernel.get(this, "groupMetrics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.GroupMetrics.class)));
            this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.HealthCheck.class));
            this.ignoreUnmodifiedSizeProperties = software.amazon.jsii.Kernel.get(this, "ignoreUnmodifiedSizeProperties", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.instanceMonitoring = software.amazon.jsii.Kernel.get(this, "instanceMonitoring", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.Monitoring.class));
            this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxInstanceLifetime = software.amazon.jsii.Kernel.get(this, "maxInstanceLifetime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.minCapacity = software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.newInstancesProtectedFromScaleIn = software.amazon.jsii.Kernel.get(this, "newInstancesProtectedFromScaleIn", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.notifications = software.amazon.jsii.Kernel.get(this, "notifications", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.NotificationConfiguration.class)));
            this.signals = software.amazon.jsii.Kernel.get(this, "signals", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.Signals.class));
            this.spotPrice = software.amazon.jsii.Kernel.get(this, "spotPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.terminationPolicies = software.amazon.jsii.Kernel.get(this, "terminationPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.TerminationPolicy.class)));
            this.updatePolicy = software.amazon.jsii.Kernel.get(this, "updatePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.UpdatePolicy.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.bootstrapEnabled = builder.bootstrapEnabled;
            this.bootstrapOptions = builder.bootstrapOptions;
            this.machineImageType = builder.machineImageType;
            this.mapRole = builder.mapRole;
            this.spotInterruptHandler = builder.spotInterruptHandler;
            this.allowAllOutbound = builder.allowAllOutbound;
            this.associatePublicIpAddress = builder.associatePublicIpAddress;
            this.autoScalingGroupName = builder.autoScalingGroupName;
            this.blockDevices = (java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice>)builder.blockDevices;
            this.cooldown = builder.cooldown;
            this.desiredCapacity = builder.desiredCapacity;
            this.groupMetrics = (java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics>)builder.groupMetrics;
            this.healthCheck = builder.healthCheck;
            this.ignoreUnmodifiedSizeProperties = builder.ignoreUnmodifiedSizeProperties;
            this.instanceMonitoring = builder.instanceMonitoring;
            this.keyName = builder.keyName;
            this.maxCapacity = builder.maxCapacity;
            this.maxInstanceLifetime = builder.maxInstanceLifetime;
            this.minCapacity = builder.minCapacity;
            this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
            this.notifications = (java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration>)builder.notifications;
            this.signals = builder.signals;
            this.spotPrice = builder.spotPrice;
            this.terminationPolicies = (java.util.List<software.amazon.awscdk.services.autoscaling.TerminationPolicy>)builder.terminationPolicies;
            this.updatePolicy = builder.updatePolicy;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.Boolean getBootstrapEnabled() {
            return this.bootstrapEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.eks.BootstrapOptions getBootstrapOptions() {
            return this.bootstrapOptions;
        }

        @Override
        public final software.amazon.awscdk.services.eks.MachineImageType getMachineImageType() {
            return this.machineImageType;
        }

        @Override
        public final java.lang.Boolean getMapRole() {
            return this.mapRole;
        }

        @Override
        public final java.lang.Boolean getSpotInterruptHandler() {
            return this.spotInterruptHandler;
        }

        @Override
        public final java.lang.Boolean getAllowAllOutbound() {
            return this.allowAllOutbound;
        }

        @Override
        public final java.lang.Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final java.lang.String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.BlockDevice> getBlockDevices() {
            return this.blockDevices;
        }

        @Override
        public final software.amazon.awscdk.Duration getCooldown() {
            return this.cooldown;
        }

        @Override
        public final java.lang.Number getDesiredCapacity() {
            return this.desiredCapacity;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.GroupMetrics> getGroupMetrics() {
            return this.groupMetrics;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.HealthCheck getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public final java.lang.Boolean getIgnoreUnmodifiedSizeProperties() {
            return this.ignoreUnmodifiedSizeProperties;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.Monitoring getInstanceMonitoring() {
            return this.instanceMonitoring;
        }

        @Override
        public final java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public final java.lang.Number getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxInstanceLifetime() {
            return this.maxInstanceLifetime;
        }

        @Override
        public final java.lang.Number getMinCapacity() {
            return this.minCapacity;
        }

        @Override
        public final java.lang.Boolean getNewInstancesProtectedFromScaleIn() {
            return this.newInstancesProtectedFromScaleIn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.NotificationConfiguration> getNotifications() {
            return this.notifications;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.Signals getSignals() {
            return this.signals;
        }

        @Override
        public final java.lang.String getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.TerminationPolicy> getTerminationPolicies() {
            return this.terminationPolicies;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.UpdatePolicy getUpdatePolicy() {
            return this.updatePolicy;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            if (this.getBootstrapEnabled() != null) {
                data.set("bootstrapEnabled", om.valueToTree(this.getBootstrapEnabled()));
            }
            if (this.getBootstrapOptions() != null) {
                data.set("bootstrapOptions", om.valueToTree(this.getBootstrapOptions()));
            }
            if (this.getMachineImageType() != null) {
                data.set("machineImageType", om.valueToTree(this.getMachineImageType()));
            }
            if (this.getMapRole() != null) {
                data.set("mapRole", om.valueToTree(this.getMapRole()));
            }
            if (this.getSpotInterruptHandler() != null) {
                data.set("spotInterruptHandler", om.valueToTree(this.getSpotInterruptHandler()));
            }
            if (this.getAllowAllOutbound() != null) {
                data.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
            }
            if (this.getAssociatePublicIpAddress() != null) {
                data.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
            }
            if (this.getAutoScalingGroupName() != null) {
                data.set("autoScalingGroupName", om.valueToTree(this.getAutoScalingGroupName()));
            }
            if (this.getBlockDevices() != null) {
                data.set("blockDevices", om.valueToTree(this.getBlockDevices()));
            }
            if (this.getCooldown() != null) {
                data.set("cooldown", om.valueToTree(this.getCooldown()));
            }
            if (this.getDesiredCapacity() != null) {
                data.set("desiredCapacity", om.valueToTree(this.getDesiredCapacity()));
            }
            if (this.getGroupMetrics() != null) {
                data.set("groupMetrics", om.valueToTree(this.getGroupMetrics()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getIgnoreUnmodifiedSizeProperties() != null) {
                data.set("ignoreUnmodifiedSizeProperties", om.valueToTree(this.getIgnoreUnmodifiedSizeProperties()));
            }
            if (this.getInstanceMonitoring() != null) {
                data.set("instanceMonitoring", om.valueToTree(this.getInstanceMonitoring()));
            }
            if (this.getKeyName() != null) {
                data.set("keyName", om.valueToTree(this.getKeyName()));
            }
            if (this.getMaxCapacity() != null) {
                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
            }
            if (this.getMaxInstanceLifetime() != null) {
                data.set("maxInstanceLifetime", om.valueToTree(this.getMaxInstanceLifetime()));
            }
            if (this.getMinCapacity() != null) {
                data.set("minCapacity", om.valueToTree(this.getMinCapacity()));
            }
            if (this.getNewInstancesProtectedFromScaleIn() != null) {
                data.set("newInstancesProtectedFromScaleIn", om.valueToTree(this.getNewInstancesProtectedFromScaleIn()));
            }
            if (this.getNotifications() != null) {
                data.set("notifications", om.valueToTree(this.getNotifications()));
            }
            if (this.getSignals() != null) {
                data.set("signals", om.valueToTree(this.getSignals()));
            }
            if (this.getSpotPrice() != null) {
                data.set("spotPrice", om.valueToTree(this.getSpotPrice()));
            }
            if (this.getTerminationPolicies() != null) {
                data.set("terminationPolicies", om.valueToTree(this.getTerminationPolicies()));
            }
            if (this.getUpdatePolicy() != null) {
                data.set("updatePolicy", om.valueToTree(this.getUpdatePolicy()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.AutoScalingGroupCapacityOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AutoScalingGroupCapacityOptions.Jsii$Proxy that = (AutoScalingGroupCapacityOptions.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (this.bootstrapEnabled != null ? !this.bootstrapEnabled.equals(that.bootstrapEnabled) : that.bootstrapEnabled != null) return false;
            if (this.bootstrapOptions != null ? !this.bootstrapOptions.equals(that.bootstrapOptions) : that.bootstrapOptions != null) return false;
            if (this.machineImageType != null ? !this.machineImageType.equals(that.machineImageType) : that.machineImageType != null) return false;
            if (this.mapRole != null ? !this.mapRole.equals(that.mapRole) : that.mapRole != null) return false;
            if (this.spotInterruptHandler != null ? !this.spotInterruptHandler.equals(that.spotInterruptHandler) : that.spotInterruptHandler != null) return false;
            if (this.allowAllOutbound != null ? !this.allowAllOutbound.equals(that.allowAllOutbound) : that.allowAllOutbound != null) return false;
            if (this.associatePublicIpAddress != null ? !this.associatePublicIpAddress.equals(that.associatePublicIpAddress) : that.associatePublicIpAddress != null) return false;
            if (this.autoScalingGroupName != null ? !this.autoScalingGroupName.equals(that.autoScalingGroupName) : that.autoScalingGroupName != null) return false;
            if (this.blockDevices != null ? !this.blockDevices.equals(that.blockDevices) : that.blockDevices != null) return false;
            if (this.cooldown != null ? !this.cooldown.equals(that.cooldown) : that.cooldown != null) return false;
            if (this.desiredCapacity != null ? !this.desiredCapacity.equals(that.desiredCapacity) : that.desiredCapacity != null) return false;
            if (this.groupMetrics != null ? !this.groupMetrics.equals(that.groupMetrics) : that.groupMetrics != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.ignoreUnmodifiedSizeProperties != null ? !this.ignoreUnmodifiedSizeProperties.equals(that.ignoreUnmodifiedSizeProperties) : that.ignoreUnmodifiedSizeProperties != null) return false;
            if (this.instanceMonitoring != null ? !this.instanceMonitoring.equals(that.instanceMonitoring) : that.instanceMonitoring != null) return false;
            if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
            if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
            if (this.maxInstanceLifetime != null ? !this.maxInstanceLifetime.equals(that.maxInstanceLifetime) : that.maxInstanceLifetime != null) return false;
            if (this.minCapacity != null ? !this.minCapacity.equals(that.minCapacity) : that.minCapacity != null) return false;
            if (this.newInstancesProtectedFromScaleIn != null ? !this.newInstancesProtectedFromScaleIn.equals(that.newInstancesProtectedFromScaleIn) : that.newInstancesProtectedFromScaleIn != null) return false;
            if (this.notifications != null ? !this.notifications.equals(that.notifications) : that.notifications != null) return false;
            if (this.signals != null ? !this.signals.equals(that.signals) : that.signals != null) return false;
            if (this.spotPrice != null ? !this.spotPrice.equals(that.spotPrice) : that.spotPrice != null) return false;
            if (this.terminationPolicies != null ? !this.terminationPolicies.equals(that.terminationPolicies) : that.terminationPolicies != null) return false;
            if (this.updatePolicy != null ? !this.updatePolicy.equals(that.updatePolicy) : that.updatePolicy != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.bootstrapEnabled != null ? this.bootstrapEnabled.hashCode() : 0);
            result = 31 * result + (this.bootstrapOptions != null ? this.bootstrapOptions.hashCode() : 0);
            result = 31 * result + (this.machineImageType != null ? this.machineImageType.hashCode() : 0);
            result = 31 * result + (this.mapRole != null ? this.mapRole.hashCode() : 0);
            result = 31 * result + (this.spotInterruptHandler != null ? this.spotInterruptHandler.hashCode() : 0);
            result = 31 * result + (this.allowAllOutbound != null ? this.allowAllOutbound.hashCode() : 0);
            result = 31 * result + (this.associatePublicIpAddress != null ? this.associatePublicIpAddress.hashCode() : 0);
            result = 31 * result + (this.autoScalingGroupName != null ? this.autoScalingGroupName.hashCode() : 0);
            result = 31 * result + (this.blockDevices != null ? this.blockDevices.hashCode() : 0);
            result = 31 * result + (this.cooldown != null ? this.cooldown.hashCode() : 0);
            result = 31 * result + (this.desiredCapacity != null ? this.desiredCapacity.hashCode() : 0);
            result = 31 * result + (this.groupMetrics != null ? this.groupMetrics.hashCode() : 0);
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.ignoreUnmodifiedSizeProperties != null ? this.ignoreUnmodifiedSizeProperties.hashCode() : 0);
            result = 31 * result + (this.instanceMonitoring != null ? this.instanceMonitoring.hashCode() : 0);
            result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
            result = 31 * result + (this.maxCapacity != null ? this.maxCapacity.hashCode() : 0);
            result = 31 * result + (this.maxInstanceLifetime != null ? this.maxInstanceLifetime.hashCode() : 0);
            result = 31 * result + (this.minCapacity != null ? this.minCapacity.hashCode() : 0);
            result = 31 * result + (this.newInstancesProtectedFromScaleIn != null ? this.newInstancesProtectedFromScaleIn.hashCode() : 0);
            result = 31 * result + (this.notifications != null ? this.notifications.hashCode() : 0);
            result = 31 * result + (this.signals != null ? this.signals.hashCode() : 0);
            result = 31 * result + (this.spotPrice != null ? this.spotPrice.hashCode() : 0);
            result = 31 * result + (this.terminationPolicies != null ? this.terminationPolicies.hashCode() : 0);
            result = 31 * result + (this.updatePolicy != null ? this.updatePolicy.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
