package software.amazon.awscdk.services.ecs;

/**
 * The placement constraints to use for tasks in the service. For more information, see [Amazon ECS Task Placement Constraints](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html).
 * <p>
 * Tasks will only be placed on instances that match these rules.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc = Vpc.fromLookup(this, "Vpc", VpcLookupOptions.builder()
 *         .isDefault(true)
 *         .build());
 * Cluster cluster = Cluster.Builder.create(this, "Ec2Cluster").vpc(vpc).build();
 * cluster.addCapacity("DefaultAutoScalingGroup", AddCapacityOptions.builder()
 *         .instanceType(new InstanceType("t2.micro"))
 *         .vpcSubnets(SubnetSelection.builder().subnetType(SubnetType.PUBLIC).build())
 *         .build());
 * TaskDefinition taskDefinition = TaskDefinition.Builder.create(this, "TD")
 *         .compatibility(Compatibility.EC2)
 *         .build();
 * taskDefinition.addContainer("TheContainer", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("foo/bar"))
 *         .memoryLimitMiB(256)
 *         .build());
 * EcsRunTask runTask = EcsRunTask.Builder.create(this, "Run")
 *         .integrationPattern(IntegrationPattern.RUN_JOB)
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .launchTarget(EcsEc2LaunchTarget.Builder.create()
 *                 .placementStrategies(List.of(PlacementStrategy.spreadAcrossInstances(), PlacementStrategy.packedByCpu(), PlacementStrategy.randomly()))
 *                 .placementConstraints(List.of(PlacementConstraint.memberOf("blieptuut")))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:51.048Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.PlacementConstraint")
public class PlacementConstraint extends software.amazon.jsii.JsiiObject {

    protected PlacementConstraint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PlacementConstraint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Use distinctInstance to ensure that each task in a particular group is running on a different container instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementConstraint distinctInstances() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.PlacementConstraint.class, "distinctInstances", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementConstraint.class));
    }

    /**
     * Use memberOf to restrict the selection to a group of valid candidates specified by a query expression.
     * <p>
     * Multiple expressions can be specified. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language</a>.
     * <p>
     * You can specify multiple expressions in one call. The tasks will only be placed on instances matching all expressions.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html</a>
     * @param expressions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementConstraint memberOf(final @org.jetbrains.annotations.NotNull java.lang.String... expressions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.PlacementConstraint.class, "memberOf", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementConstraint.class), java.util.Arrays.<Object>stream(expressions).toArray(Object[]::new));
    }

    /**
     * Return the placement JSON.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.CfnService.PlacementConstraintProperty> toJson() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "toJson", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnService.PlacementConstraintProperty.class))));
    }
}
