package software.amazon.awscdk.services.datasync;

/**
 * Properties for defining a `CfnLocationEFS`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnLocationEFSProps cfnLocationEFSProps = CfnLocationEFSProps.builder()
 *         .ec2Config(Ec2ConfigProperty.builder()
 *                 .securityGroupArns(List.of("securityGroupArns"))
 *                 .subnetArn("subnetArn")
 *                 .build())
 *         .efsFilesystemArn("efsFilesystemArn")
 *         // the properties below are optional
 *         .accessPointArn("accessPointArn")
 *         .fileSystemAccessRoleArn("fileSystemAccessRoleArn")
 *         .inTransitEncryption("inTransitEncryption")
 *         .subdirectory("subdirectory")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:50.189Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnLocationEFSProps")
@software.amazon.jsii.Jsii.Proxy(CfnLocationEFSProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLocationEFSProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The subnet and security group that the Amazon EFS file system uses.
     * <p>
     * The security group that you provide needs to be able to communicate with the security group on the mount target in the subnet specified.
     * <p>
     * The exact relationship between security group M (of the mount target) and security group S (which you provide for DataSync to use at this stage) is as follows:
     * <p>
     * <ul>
     * <li>Security group M (which you associate with the mount target) must allow inbound access for the Transmission Control Protocol (TCP) on the NFS port (2049) from security group S. You can enable inbound connections either by IP address (CIDR range) or security group.</li>
     * <li>Security group S (provided to DataSync to access EFS) should have a rule that enables outbound connections to the NFS port on one of the file system’s mount targets. You can enable outbound connections either by IP address (CIDR range) or security group.</li>
     * </ul>
     * <p>
     * For information about security groups and mount targets, see <a href="https://docs.aws.amazon.com/efs/latest/ug/security-considerations.html#network-access">Security Groups for Amazon EC2 Instances and Mount Targets</a> in the <em>Amazon EFS User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getEc2Config();

    /**
     * The Amazon Resource Name (ARN) for the Amazon EFS file system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEfsFilesystemArn();

    /**
     * `AWS::DataSync::LocationEFS.AccessPointArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccessPointArn() {
        return null;
    }

    /**
     * `AWS::DataSync::LocationEFS.FileSystemAccessRoleArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileSystemAccessRoleArn() {
        return null;
    }

    /**
     * `AWS::DataSync::LocationEFS.InTransitEncryption`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInTransitEncryption() {
        return null;
    }

    /**
     * A subdirectory in the location’s path.
     * <p>
     * This subdirectory in the EFS file system is used to read data from the EFS source location or write data to the EFS destination. By default, AWS DataSync uses the root directory.
     * <p>
     * <blockquote>
     * <p>
     * <code>Subdirectory</code> must be specified with forward slashes. For example, <code>/path/to/folder</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubdirectory() {
        return null;
    }

    /**
     * The key-value pair that represents a tag that you want to add to the resource.
     * <p>
     * The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLocationEFSProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLocationEFSProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLocationEFSProps> {
        java.lang.Object ec2Config;
        java.lang.String efsFilesystemArn;
        java.lang.String accessPointArn;
        java.lang.String fileSystemAccessRoleArn;
        java.lang.String inTransitEncryption;
        java.lang.String subdirectory;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnLocationEFSProps#getEc2Config}
         * @param ec2Config The subnet and security group that the Amazon EFS file system uses. This parameter is required.
         *                  The security group that you provide needs to be able to communicate with the security group on the mount target in the subnet specified.
         *                  <p>
         *                  The exact relationship between security group M (of the mount target) and security group S (which you provide for DataSync to use at this stage) is as follows:
         *                  <p>
         *                  <ul>
         *                  <li>Security group M (which you associate with the mount target) must allow inbound access for the Transmission Control Protocol (TCP) on the NFS port (2049) from security group S. You can enable inbound connections either by IP address (CIDR range) or security group.</li>
         *                  <li>Security group S (provided to DataSync to access EFS) should have a rule that enables outbound connections to the NFS port on one of the file system’s mount targets. You can enable outbound connections either by IP address (CIDR range) or security group.</li>
         *                  </ul>
         *                  <p>
         *                  For information about security groups and mount targets, see <a href="https://docs.aws.amazon.com/efs/latest/ug/security-considerations.html#network-access">Security Groups for Amazon EC2 Instances and Mount Targets</a> in the <em>Amazon EFS User Guide.</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2Config(software.amazon.awscdk.services.datasync.CfnLocationEFS.Ec2ConfigProperty ec2Config) {
            this.ec2Config = ec2Config;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationEFSProps#getEc2Config}
         * @param ec2Config The subnet and security group that the Amazon EFS file system uses. This parameter is required.
         *                  The security group that you provide needs to be able to communicate with the security group on the mount target in the subnet specified.
         *                  <p>
         *                  The exact relationship between security group M (of the mount target) and security group S (which you provide for DataSync to use at this stage) is as follows:
         *                  <p>
         *                  <ul>
         *                  <li>Security group M (which you associate with the mount target) must allow inbound access for the Transmission Control Protocol (TCP) on the NFS port (2049) from security group S. You can enable inbound connections either by IP address (CIDR range) or security group.</li>
         *                  <li>Security group S (provided to DataSync to access EFS) should have a rule that enables outbound connections to the NFS port on one of the file system’s mount targets. You can enable outbound connections either by IP address (CIDR range) or security group.</li>
         *                  </ul>
         *                  <p>
         *                  For information about security groups and mount targets, see <a href="https://docs.aws.amazon.com/efs/latest/ug/security-considerations.html#network-access">Security Groups for Amazon EC2 Instances and Mount Targets</a> in the <em>Amazon EFS User Guide.</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2Config(software.amazon.awscdk.IResolvable ec2Config) {
            this.ec2Config = ec2Config;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationEFSProps#getEfsFilesystemArn}
         * @param efsFilesystemArn The Amazon Resource Name (ARN) for the Amazon EFS file system. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder efsFilesystemArn(java.lang.String efsFilesystemArn) {
            this.efsFilesystemArn = efsFilesystemArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationEFSProps#getAccessPointArn}
         * @param accessPointArn `AWS::DataSync::LocationEFS.AccessPointArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPointArn(java.lang.String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationEFSProps#getFileSystemAccessRoleArn}
         * @param fileSystemAccessRoleArn `AWS::DataSync::LocationEFS.FileSystemAccessRoleArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemAccessRoleArn(java.lang.String fileSystemAccessRoleArn) {
            this.fileSystemAccessRoleArn = fileSystemAccessRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationEFSProps#getInTransitEncryption}
         * @param inTransitEncryption `AWS::DataSync::LocationEFS.InTransitEncryption`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inTransitEncryption(java.lang.String inTransitEncryption) {
            this.inTransitEncryption = inTransitEncryption;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationEFSProps#getSubdirectory}
         * @param subdirectory A subdirectory in the location’s path.
         *                     This subdirectory in the EFS file system is used to read data from the EFS source location or write data to the EFS destination. By default, AWS DataSync uses the root directory.
         *                     <p>
         *                     <blockquote>
         *                     <p>
         *                     <code>Subdirectory</code> must be specified with forward slashes. For example, <code>/path/to/folder</code> .
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subdirectory(java.lang.String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        /**
         * Sets the value of {@link CfnLocationEFSProps#getTags}
         * @param tags The key-value pair that represents a tag that you want to add to the resource.
         *             The value can be an empty string. This value helps you manage, filter, and search for your resources. We recommend that you create a name tag for your location.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLocationEFSProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLocationEFSProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLocationEFSProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLocationEFSProps {
        private final java.lang.Object ec2Config;
        private final java.lang.String efsFilesystemArn;
        private final java.lang.String accessPointArn;
        private final java.lang.String fileSystemAccessRoleArn;
        private final java.lang.String inTransitEncryption;
        private final java.lang.String subdirectory;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ec2Config = software.amazon.jsii.Kernel.get(this, "ec2Config", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.efsFilesystemArn = software.amazon.jsii.Kernel.get(this, "efsFilesystemArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessPointArn = software.amazon.jsii.Kernel.get(this, "accessPointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fileSystemAccessRoleArn = software.amazon.jsii.Kernel.get(this, "fileSystemAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inTransitEncryption = software.amazon.jsii.Kernel.get(this, "inTransitEncryption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subdirectory = software.amazon.jsii.Kernel.get(this, "subdirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ec2Config = java.util.Objects.requireNonNull(builder.ec2Config, "ec2Config is required");
            this.efsFilesystemArn = java.util.Objects.requireNonNull(builder.efsFilesystemArn, "efsFilesystemArn is required");
            this.accessPointArn = builder.accessPointArn;
            this.fileSystemAccessRoleArn = builder.fileSystemAccessRoleArn;
            this.inTransitEncryption = builder.inTransitEncryption;
            this.subdirectory = builder.subdirectory;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getEc2Config() {
            return this.ec2Config;
        }

        @Override
        public final java.lang.String getEfsFilesystemArn() {
            return this.efsFilesystemArn;
        }

        @Override
        public final java.lang.String getAccessPointArn() {
            return this.accessPointArn;
        }

        @Override
        public final java.lang.String getFileSystemAccessRoleArn() {
            return this.fileSystemAccessRoleArn;
        }

        @Override
        public final java.lang.String getInTransitEncryption() {
            return this.inTransitEncryption;
        }

        @Override
        public final java.lang.String getSubdirectory() {
            return this.subdirectory;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ec2Config", om.valueToTree(this.getEc2Config()));
            data.set("efsFilesystemArn", om.valueToTree(this.getEfsFilesystemArn()));
            if (this.getAccessPointArn() != null) {
                data.set("accessPointArn", om.valueToTree(this.getAccessPointArn()));
            }
            if (this.getFileSystemAccessRoleArn() != null) {
                data.set("fileSystemAccessRoleArn", om.valueToTree(this.getFileSystemAccessRoleArn()));
            }
            if (this.getInTransitEncryption() != null) {
                data.set("inTransitEncryption", om.valueToTree(this.getInTransitEncryption()));
            }
            if (this.getSubdirectory() != null) {
                data.set("subdirectory", om.valueToTree(this.getSubdirectory()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnLocationEFSProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLocationEFSProps.Jsii$Proxy that = (CfnLocationEFSProps.Jsii$Proxy) o;

            if (!ec2Config.equals(that.ec2Config)) return false;
            if (!efsFilesystemArn.equals(that.efsFilesystemArn)) return false;
            if (this.accessPointArn != null ? !this.accessPointArn.equals(that.accessPointArn) : that.accessPointArn != null) return false;
            if (this.fileSystemAccessRoleArn != null ? !this.fileSystemAccessRoleArn.equals(that.fileSystemAccessRoleArn) : that.fileSystemAccessRoleArn != null) return false;
            if (this.inTransitEncryption != null ? !this.inTransitEncryption.equals(that.inTransitEncryption) : that.inTransitEncryption != null) return false;
            if (this.subdirectory != null ? !this.subdirectory.equals(that.subdirectory) : that.subdirectory != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ec2Config.hashCode();
            result = 31 * result + (this.efsFilesystemArn.hashCode());
            result = 31 * result + (this.accessPointArn != null ? this.accessPointArn.hashCode() : 0);
            result = 31 * result + (this.fileSystemAccessRoleArn != null ? this.fileSystemAccessRoleArn.hashCode() : 0);
            result = 31 * result + (this.inTransitEncryption != null ? this.inTransitEncryption.hashCode() : 0);
            result = 31 * result + (this.subdirectory != null ? this.subdirectory.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
