package software.amazon.awscdk.services.cognito;

/**
 * Props to initialize ResourceServerScope.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool pool = new UserPool(this, "Pool");
 * ResourceServerScope readOnlyScope = ResourceServerScope.Builder.create().scopeName("read").scopeDescription("Read-only access").build();
 * ResourceServerScope fullAccessScope = ResourceServerScope.Builder.create().scopeName("*").scopeDescription("Full access").build();
 * UserPoolResourceServer userServer = pool.addResourceServer("ResourceServer", UserPoolResourceServerOptions.builder()
 *         .identifier("users")
 *         .scopes(List.of(readOnlyScope, fullAccessScope))
 *         .build());
 * UserPoolClient readOnlyClient = pool.addClient("read-only-client", UserPoolClientOptions.builder()
 *         // ...
 *         .oAuth(OAuthSettings.builder()
 *                 // ...
 *                 .scopes(List.of(OAuthScope.resourceServer(userServer, readOnlyScope)))
 *                 .build())
 *         .build());
 * UserPoolClient fullAccessClient = pool.addClient("full-access-client", UserPoolClientOptions.builder()
 *         // ...
 *         .oAuth(OAuthSettings.builder()
 *                 // ...
 *                 .scopes(List.of(OAuthScope.resourceServer(userServer, fullAccessScope)))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:50.016Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.ResourceServerScopeProps")
@software.amazon.jsii.Jsii.Proxy(ResourceServerScopeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResourceServerScopeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A description of the scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScopeDescription();

    /**
     * The name of the scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScopeName();

    /**
     * @return a {@link Builder} of {@link ResourceServerScopeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResourceServerScopeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResourceServerScopeProps> {
        java.lang.String scopeDescription;
        java.lang.String scopeName;

        /**
         * Sets the value of {@link ResourceServerScopeProps#getScopeDescription}
         * @param scopeDescription A description of the scope. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scopeDescription(java.lang.String scopeDescription) {
            this.scopeDescription = scopeDescription;
            return this;
        }

        /**
         * Sets the value of {@link ResourceServerScopeProps#getScopeName}
         * @param scopeName The name of the scope. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scopeName(java.lang.String scopeName) {
            this.scopeName = scopeName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResourceServerScopeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResourceServerScopeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResourceServerScopeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceServerScopeProps {
        private final java.lang.String scopeDescription;
        private final java.lang.String scopeName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.scopeDescription = software.amazon.jsii.Kernel.get(this, "scopeDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scopeName = software.amazon.jsii.Kernel.get(this, "scopeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.scopeDescription = java.util.Objects.requireNonNull(builder.scopeDescription, "scopeDescription is required");
            this.scopeName = java.util.Objects.requireNonNull(builder.scopeName, "scopeName is required");
        }

        @Override
        public final java.lang.String getScopeDescription() {
            return this.scopeDescription;
        }

        @Override
        public final java.lang.String getScopeName() {
            return this.scopeName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("scopeDescription", om.valueToTree(this.getScopeDescription()));
            data.set("scopeName", om.valueToTree(this.getScopeName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.ResourceServerScopeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResourceServerScopeProps.Jsii$Proxy that = (ResourceServerScopeProps.Jsii$Proxy) o;

            if (!scopeDescription.equals(that.scopeDescription)) return false;
            return this.scopeName.equals(that.scopeName);
        }

        @Override
        public final int hashCode() {
            int result = this.scopeDescription.hashCode();
            result = 31 * result + (this.scopeName.hashCode());
            return result;
        }
    }
}
