package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Construction properties of {@link EcsDeployAction}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.services.ecs.*;
 * FargateService service;
 * Pipeline pipeline = new Pipeline(this, "MyPipeline");
 * Artifact buildOutput = new Artifact();
 * IStage deployStage = pipeline.addStage(StageOptions.builder()
 *         .stageName("Deploy")
 *         .actions(List.of(
 *             EcsDeployAction.Builder.create()
 *                     .actionName("DeployAction")
 *                     .service(service)
 *                     // if your file is called imagedefinitions.json,
 *                     // use the `input` property,
 *                     // and leave out the `imageFile` property
 *                     .input(buildOutput)
 *                     // if your file name is _not_ imagedefinitions.json,
 *                     // use the `imageFile` property,
 *                     // and leave out the `input` property
 *                     .imageFile(buildOutput.atPath("imageDef.json"))
 *                     .deploymentTimeout(Duration.minutes(60))
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:49.879Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.EcsDeployActionProps")
@software.amazon.jsii.Jsii.Proxy(EcsDeployActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcsDeployActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.CommonAwsActionProps {

    /**
     * The ECS Service to deploy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IBaseService getService();

    /**
     * Timeout for the ECS deployment in minutes.
     * <p>
     * Value must be between 1-60.
     * <p>
     * Default: - 60 minutes
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-ECS.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-ECS.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getDeploymentTimeout() {
        return null;
    }

    /**
     * The name of the JSON image definitions file to use for deployments.
     * <p>
     * The JSON file is a list of objects,
     * each with 2 keys: <code>name</code> is the name of the container in the Task Definition,
     * and <code>imageUri</code> is the Docker image URI you want to update your service with.
     * Use this property if you want to use a different name for this file than the default 'imagedefinitions.json'.
     * If you use this property, you don't need to specify the <code>input</code> property.
     * <p>
     * Default: - one of this property, or `input`, is required
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-create.html#pipelines-create-image-definitions">https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-create.html#pipelines-create-image-definitions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.ArtifactPath getImageFile() {
        return null;
    }

    /**
     * The input artifact that contains the JSON image definitions file to use for deployments.
     * <p>
     * The JSON file is a list of objects,
     * each with 2 keys: <code>name</code> is the name of the container in the Task Definition,
     * and <code>imageUri</code> is the Docker image URI you want to update your service with.
     * If you use this property, it's assumed the file is called 'imagedefinitions.json'.
     * If your build uses a different file, leave this property empty,
     * and use the <code>imageFile</code> property instead.
     * <p>
     * Default: - one of this property, or `imageFile`, is required
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-create.html#pipelines-create-image-definitions">https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-create.html#pipelines-create-image-definitions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.Artifact getInput() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcsDeployActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcsDeployActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EcsDeployActionProps> {
        software.amazon.awscdk.services.ecs.IBaseService service;
        software.amazon.awscdk.Duration deploymentTimeout;
        software.amazon.awscdk.services.codepipeline.ArtifactPath imageFile;
        software.amazon.awscdk.services.codepipeline.Artifact input;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.String actionName;
        java.lang.Number runOrder;
        java.lang.String variablesNamespace;

        /**
         * Sets the value of {@link EcsDeployActionProps#getService}
         * @param service The ECS Service to deploy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(software.amazon.awscdk.services.ecs.IBaseService service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeployActionProps#getDeploymentTimeout}
         * @param deploymentTimeout Timeout for the ECS deployment in minutes.
         *                          Value must be between 1-60.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentTimeout(software.amazon.awscdk.Duration deploymentTimeout) {
            this.deploymentTimeout = deploymentTimeout;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeployActionProps#getImageFile}
         * @param imageFile The name of the JSON image definitions file to use for deployments.
         *                  The JSON file is a list of objects,
         *                  each with 2 keys: <code>name</code> is the name of the container in the Task Definition,
         *                  and <code>imageUri</code> is the Docker image URI you want to update your service with.
         *                  Use this property if you want to use a different name for this file than the default 'imagedefinitions.json'.
         *                  If you use this property, you don't need to specify the <code>input</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageFile(software.amazon.awscdk.services.codepipeline.ArtifactPath imageFile) {
            this.imageFile = imageFile;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeployActionProps#getInput}
         * @param input The input artifact that contains the JSON image definitions file to use for deployments.
         *              The JSON file is a list of objects,
         *              each with 2 keys: <code>name</code> is the name of the container in the Task Definition,
         *              and <code>imageUri</code> is the Docker image URI you want to update your service with.
         *              If you use this property, it's assumed the file is called 'imagedefinitions.json'.
         *              If your build uses a different file, leave this property empty,
         *              and use the <code>imageFile</code> property instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(software.amazon.awscdk.services.codepipeline.Artifact input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeployActionProps#getRole}
         * @param role The Role in which context's this Action will be executing in.
         *             The Pipeline's Role will assume this Role
         *             (the required permissions for that will be granted automatically)
         *             right before executing this Action.
         *             This Action will be passed into your {&#64;link IAction.bind}
         *             method in the {&#64;link ActionBindOptions.role} property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeployActionProps#getActionName}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         *                   Note that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeployActionProps#getRunOrder}
         * @param runOrder The runOrder property for this Action.
         *                 RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link EcsDeployActionProps#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcsDeployActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EcsDeployActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcsDeployActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsDeployActionProps {
        private final software.amazon.awscdk.services.ecs.IBaseService service;
        private final software.amazon.awscdk.Duration deploymentTimeout;
        private final software.amazon.awscdk.services.codepipeline.ArtifactPath imageFile;
        private final software.amazon.awscdk.services.codepipeline.Artifact input;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String actionName;
        private final java.lang.Number runOrder;
        private final java.lang.String variablesNamespace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.service = software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IBaseService.class));
            this.deploymentTimeout = software.amazon.jsii.Kernel.get(this, "deploymentTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.imageFile = software.amazon.jsii.Kernel.get(this, "imageFile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ArtifactPath.class));
            this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.variablesNamespace = software.amazon.jsii.Kernel.get(this, "variablesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.service = java.util.Objects.requireNonNull(builder.service, "service is required");
            this.deploymentTimeout = builder.deploymentTimeout;
            this.imageFile = builder.imageFile;
            this.input = builder.input;
            this.role = builder.role;
            this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
            this.runOrder = builder.runOrder;
            this.variablesNamespace = builder.variablesNamespace;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.IBaseService getService() {
            return this.service;
        }

        @Override
        public final software.amazon.awscdk.Duration getDeploymentTimeout() {
            return this.deploymentTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.ArtifactPath getImageFile() {
            return this.imageFile;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getInput() {
            return this.input;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("service", om.valueToTree(this.getService()));
            if (this.getDeploymentTimeout() != null) {
                data.set("deploymentTimeout", om.valueToTree(this.getDeploymentTimeout()));
            }
            if (this.getImageFile() != null) {
                data.set("imageFile", om.valueToTree(this.getImageFile()));
            }
            if (this.getInput() != null) {
                data.set("input", om.valueToTree(this.getInput()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            data.set("actionName", om.valueToTree(this.getActionName()));
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.EcsDeployActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcsDeployActionProps.Jsii$Proxy that = (EcsDeployActionProps.Jsii$Proxy) o;

            if (!service.equals(that.service)) return false;
            if (this.deploymentTimeout != null ? !this.deploymentTimeout.equals(that.deploymentTimeout) : that.deploymentTimeout != null) return false;
            if (this.imageFile != null ? !this.imageFile.equals(that.imageFile) : that.imageFile != null) return false;
            if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (!actionName.equals(that.actionName)) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            return this.variablesNamespace != null ? this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace == null;
        }

        @Override
        public final int hashCode() {
            int result = this.service.hashCode();
            result = 31 * result + (this.deploymentTimeout != null ? this.deploymentTimeout.hashCode() : 0);
            result = 31 * result + (this.imageFile != null ? this.imageFile.hashCode() : 0);
            result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.actionName.hashCode());
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            return result;
        }
    }
}
